unit Unit60;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, Grids, DBGrids, Db;

type
  TForm60 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    GroupBox1: TGroupBox;
    BitBtn1: TBitBtn;
    Label2: TLabel;
    ComboBox2: TComboBox;
    BitBtn2: TBitBtn;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    DataSource2: TDataSource;
    DBGrid2: TDBGrid;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Edit1: TEdit;
    Label6: TLabel;
    Edit2: TEdit;
    Button1: TButton;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label7: TLabel;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    procedure DiagnsticoporTrecho1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form60: TForm60;

implementation

uses Childwin, Unit24, ComObj, ActiveX, Unit94;

{$R *.DFM}

procedure TForm60.DiagnsticoporTrecho1Click(Sender: TObject);
begin
  Form60.DiagnsticoporTrecho1Click(Sender);
end;

procedure TForm60.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm60.FormShow(Sender: TObject);
begin
  GroupBox2.Visible := False;
  DataModule24.Table17.Active := False;
  DataModule24.Table35.Active := False;
  GroupBox1.Visible := False;
  BitBtn4.Visible := False;
  DBGrid1.Visible := False;
  DBGrid2.Visible := False;
end;

procedure TForm60.ComboBox2Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Arquivo, Programa, Dados, Calc, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome: string[4];
  ArqDados, Arq: TextFile;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox2.Text = Local then Trecho := Nome;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  if ComboBox2.Text <> '' then
    begin
      DataModule24.Table17.Active := False;
      DataModule24.Table17.TableName := Calc + 'Nec' + Trecho + '.dbf';
      DataModule24.Table17.Active := True;
    end;
end;

procedure TForm60.BitBtn2Click(Sender: TObject);
var
  Excel: OleVariant;
  Ano, NPeriodos, i, j, Modo, FileCodeExcel, NRodov, Code, NPP, icont, NFields,
    jk: integer;
  ArqDados: TextFile;
  PP, CustoTotal, Perct, Deficit: Single;
  Programa, Dados, Calc, Arquivo, ArqDbf, ArqCsv, FaixaTraf, DadosAnoBase, Linha,
    ConfReg: string;
  Rodovia: array [1..350] of string[4];
  Year: string[4];
  Parametro: string[5];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string;
begin
  Screen.Cursor := crHourglass;
  DataModule24.Table17.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  { Cdigos de identificao das rodovias que compem a rede }
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  { Converte de CSV para DBF }
    for i := 1 to NRodov do
      begin
        ArqCsv := Calc + 'Nec' + Rodovia[i] + '.csv';
        ArqDbf := Calc + 'Nec' + Rodovia[i] + '.dbf';
  NFields := 27;
  AssignFile(ArqDados, ArqCsv);
  Reset(ArqDados);
  Readln(ArqDados, Linha);
  with DataModule24.Table17 do
    begin
      Active := False;
      TableName := ArqDbf;
      CreateTable;
      Active := True;
      Edit;
      First;
    end;
    while not eof(ArqDados) do
      begin
        Readln(ArqDados, Linha);
        j := 1;
        for icont := 1 to NFields do
          Campo[icont] := '';
        for icont := 1 to Length(Linha) do
          begin
            if Linha[icont] = ',' then
              j := j + 1
            else
              if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
          end;
        if ConfReg = 'Portuguese' then
          begin
            for j := 2 to 27 do
              begin
                for jk := 1 to Length(Campo[j]) do
                  if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              end;
           end;
        DataModule24.Table17.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
          StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),StrToFloat(Campo[7]),
          StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),StrToFloat(Campo[11]),
          StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),StrToFloat(Campo[15]),
          StrToFloat(Campo[16]),StrToFloat(Campo[17]),StrToFloat(Campo[18]),StrToFloat(Campo[19]),
          StrToFloat(Campo[20]),StrToFloat(Campo[21]),StrToFloat(Campo[22]),StrToFloat(Campo[23]),
          StrToFloat(Campo[24]),StrToFloat(Campo[25]),StrToFloat(Campo[26]),StrToFloat(Campo[27])]);
      end;
    DataModule24.Table17.Close;
    DataModule24.Table17.Active := False;
    CloseFile(ArqDados);
      end;
 if CheckBox3.Checked then
  begin
  { Relatrio de Condio e Vida Restante }
    for i := 1 to NRodov do
      for j := 1 to 4 do
        begin
          Arquivo := DadosAnoBase + 'Deflex\' + Rodovia[i] + '_' + IntToStr(j) + '.csv';
          if FileExists(Arquivo) then
            begin
              Arquivo := Calc + 'Pvar.dat';
              AssignFile(ArqDados, Arquivo);
              Rewrite(ArqDados);
              Writeln(ArqDados, i);
              Writeln(ArqDados, j);
              CloseFile(ArqDados);
              WinExec('ParamVR.exe /c', SW_HIDE);
              StartTime := now;
              NumSec := 20;
              repeat
                Application.ProcessMessages;
                if FileExists(ArqCsv) then Flag := 1;
              until Now > StartTime + NumSec * (1/24/60/60);
            end;
        end;
  end;
  GroupBox1.Visible := True;
  BitBtn4.Visible := True;
  Label2.Visible := False;
  ComboBox2.Visible := False;
  Label4.Visible := False;
  Label5.Visible := False;
  Label6.Visible := False;
  Edit1.Visible := False;
  Edit2.Visible := False;
  Button1.Visible := False;
  Screen.Cursor := crDefault;
end;

procedure TForm60.BitBtn3Click(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox2.Items.LoadFromFile(Arquivo);
  BitBtn4.Visible := True;
  Label2.Visible := False;
  ComboBox2.Visible := False;
  Label4.Visible := False;
  Label5.Visible := False;
  Label6.Visible := False;
  Edit1.Visible := False;
  Edit2.Visible := False;
  Button1.Visible := False;
GroupBox1.Visible := True;
end;

procedure TForm60.BitBtn4Click(Sender: TObject);
var
  Excel: OleVariant;
  Ano, NPeriodos, FileCodeExcel, NRodov, i, Modo, NPP, icont, j, IRodov,
    NFields, NTrechos, k, kk, jcont: integer;
  ArqDados, ArqOut: TextFile;
  Programa, Dados, Calc, Arquivo, ArqXls, ArqCsv, ArqXlsNovo, Linha,
    TipoMed, DadosAnoBase: string;
  Rodovia: array [1..350] of string[4];
  Year, AnoAtual: string[4];
  Estrategia: string[3];
  PPmin, PPmax, inf: Single;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo, km: array [1..150] of string[15];
  STH, Iniciokm, Finalkm, MedidaF1, Hfrescm1, HReccm1, MedidaF2, Hfrescm2, 
    HReccm2, MedidaF3, Hfrescm3, HReccm3, MedidaF4, Hfrescm4, HReccm4: string;
  Trecho: array [1..60] of integer;
  Inverte: Boolean;
  Linhas, AnoUlt: array [1..4] of string;
begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  { Cdigos de identificao das rodovias que compem a rede }
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  Modo := 6;
  Arquivo := Calc + 'Modo.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Modo);
  CloseFile(ArqDados);
  ArqCsv := 'DOS.DAT';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  WinExec('HistMan.exe /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 10;
  repeat
    Application.ProcessMessages;
    if FileExists(ArqCsv) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  ArqCsv := 'DOS2.DAT';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  WinExec('Unifilar.bat /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 10;
  repeat
    Application.ProcessMessages;
    if FileExists(ArqCsv) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Lista dos trechos onde a ordem dos subtrechos deve ser invertida }
  AssignFile(ArqDados, 'Inverte.dat');
  Reset(ArqDados);
  Readln(ArqDados, NTrechos);
  for i := 1 to NTrechos do
    Readln(ArqDados, Trecho[i]);
  CloseFile(ArqDados);
  NFields := 19;
  for IRodov := 1 to NRodov do
    begin
      for j := 1 to 4 do
        AnoUlt[j] := 'Ano Fx' + IntToStr(j) + ':';
      STH := 'Subtrecho:';
      Iniciokm := 'km';
      Finalkm := '';
      MedidaF1 := 'Faixa 1';
      Hfrescm1 := 'hc Fx1';
      HReccm1 := 'HR Fx1';
      MedidaF2 := 'Faixa 2';
      Hfrescm2 := 'hc Fx2';
      HReccm2 := 'HR Fx2';
      MedidaF3 := 'Faixa 3';
      Hfrescm3 := 'hc Fx3';
      HReccm3 := 'HR Fx3';
      MedidaF4 := 'Faixa 4';
      Hfrescm4 := 'hc Fx4';
      HReccm4 := 'HR Fx4';
      Inverte := False;
      for i := 1 to NTrechos do
        if IRodov = Trecho[i] then Inverte := True;
      if Inverte then Estrategia := 'HSX' else Estrategia := 'HST';
      Arquivo := Calc + Estrategia + Rodovia[IRodov] + '.csv';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      while not Eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for i := 1 to NFields do
            Campo[i] := '';
          for i := 1 to Length(Linha) do
            begin
              if Linha[i] = ',' then
                j := j + 1
              else
                if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
            end;
          STH := STH + ',' + Campo[1];
          Iniciokm := Iniciokm + ',' + Campo[2];
          Finalkm := Finalkm + ',' + Campo[3];
          AnoUlt[1] := AnoUlt[1] + ',' + Campo[4];
          MedidaF1 := MedidaF1 + ',' + Campo[5];
          Hfrescm1 := Hfrescm1 + ',' + Campo[6];
          HReccm1 := HReccm1 + ',' + Campo[7];
          AnoUlt[2] := AnoUlt[2] + ',' + Campo[8];
          MedidaF2 := MedidaF2 + ',' + Campo[9];
          Hfrescm2 := Hfrescm2 + ',' + Campo[10];
          HReccm2 := HReccm2 + ',' + Campo[11];
          AnoUlt[3] := AnoUlt[3] + ',' + Campo[12];
          MedidaF3 := MedidaF3 + ',' + Campo[13];
          Hfrescm3 := Hfrescm3 + ',' + Campo[14];
          HReccm3 := HReccm3 + ',' + Campo[15];
          AnoUlt[4] := AnoUlt[4] + ',' + Campo[16];
          MedidaF4 := MedidaF4 + ',' + Campo[17];
          Hfrescm4 := Hfrescm4 + ',' + Campo[18];
          HReccm4 := HReccm4 + ',' + Campo[19];
        end;
      CloseFile(ArqDados);
      Iniciokm := Iniciokm + ',' + Campo[3];
      ArqCsv := Calc + 'Hist' + Rodovia[IRodov] + '.csv';
      AssignFile(ArqDados, ArqCsv);
      Rewrite(ArqDados);
      Writeln(ArqDados, STH);
      Writeln(ArqDados, Iniciokm);
      Writeln(ArqDados);
      Writeln(ArqDados);
      Writeln(ArqDados);
      Writeln(ArqDados, MedidaF1);
      Writeln(ArqDados, Hfrescm1);
      Writeln(ArqDados, HReccm1);
      Writeln(ArqDados, MedidaF2);
      Writeln(ArqDados, Hfrescm2);
      Writeln(ArqDados, HReccm2);
      Writeln(ArqDados, MedidaF3);
      Writeln(ArqDados, Hfrescm3);
      Writeln(ArqDados, HReccm3);
      Writeln(ArqDados, MedidaF4);
      Writeln(ArqDados, Hfrescm4);
      Writeln(ArqDados, HReccm4);
      Writeln(ArqDados);
      Writeln(ArqDados);
      Writeln(ArqDados);
      for j := 1 to 4 do
        Writeln(ArqDados, AnoUlt[j]);
      CloseFile(ArqDados);
    end;
  { Insere os arquivo *.csv gerados nas planilhas Excel dos unifilares }
    Excel := CreateOleObject('Excel.Application');
    Excel.Visible := False;
    for i := 1 to NRodov do
      begin
        AnoAtual := IntToStr(Ano);
        ArqXlsNovo := Calc + 'Unifilares\Atual\' + 'Unifilar_' + Rodovia[i] + '_' + AnoAtual + '.xls';
        if FileExists(ArqXlsNovo) then
          begin
            AssignFile(ArqDados, ArqXlsNovo);
            Erase(ArqDados);
          end;
        ArqCsv := Calc + 'PP' + Rodovia[i] + '1.csv';
        FileCodeExcel := 6;
        Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
        ArqXls := Dados + Year + '\Unifilar\' + 'Unifilar_' + Rodovia[i] + '.xls';
        FileCodeExcel := 1;
        Excel.Workbooks.Open(ArqXls, True, FileCodeExcel);
        Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
        Excel.Workbooks[2].Sheets[1].PasteSpecial;
        ArqCsv := Calc + 'PP' + Rodovia[i] + '2.csv';
        FileCodeExcel := 6;
        Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
        Excel.Workbooks[3].Sheets[1].UsedRange.Copy;
        Excel.Workbooks[2].Sheets[2].PasteSpecial;
        ArqCsv := Calc + 'CONat' + Rodovia[i] + '.csv';
        FileCodeExcel := 6;
        Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
        Excel.Workbooks[4].Sheets[1].UsedRange.Copy;
        Excel.Workbooks[2].Sheets[3].PasteSpecial;
        ArqCsv := Calc + 'Hist' + Rodovia[i] + '.csv';
        FileCodeExcel := 6;
        Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
        Excel.Workbooks[5].Sheets[1].UsedRange.Copy;
        Excel.Workbooks[2].Sheets[4].PasteSpecial;
        FileCodeExcel := 1;
        Excel.Workbooks[2].Sheets[1].SaveAs(ArqXlsNovo, FileCodeExcel);
        Excel.Workbooks[2].Saved := True;
        Excel.Workbooks.Close;
      end;
    Excel.Quit;
  Screen.Cursor := crDefault;
end;

procedure TForm60.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked = False then
    begin
      GroupBox2.Visible := False;
      CheckBox2.Checked := True;
      DBGrid1.Visible := True;
      DBGrid1.Align := alClient;
      DBGrid2.Visible := False;
      Label2.Visible := True;
      ComboBox2.Visible := True;
      Label4.Visible := False;
      Label5.Visible := False;
      Label6.Visible := False;
      Edit1.Visible := False;
      Edit2.Visible := False;
      Button1.Visible := False;
    end
  else
    begin
      GroupBox2.Visible := True;
      CheckBox2.Checked := False;
      DBGrid1.Visible := False;
      DBGrid2.Visible := True;
      DBGrid2.Align := alClient;
      Label2.Visible := False;
      ComboBox2.Visible := False;
      Label4.Visible := True;
      Label5.Visible := True;
      Label6.Visible := True;
      Edit1.Visible := True;
      Edit2.Visible := True;
      Button1.Visible := True;
    end;
end;

procedure TForm60.CheckBox2Click(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  if CheckBox2.Checked = True then
    begin
      GroupBox2.Visible := False;
      CheckBox1.Checked := False;
      DBGrid1.Visible := True;
      DBGrid1.Align := alClient;
      DBGrid2.Visible := False;
      Label2.Visible := True;
      ComboBox2.Visible := True;
      Label4.Visible := False;
      Label5.Visible := False;
      Label6.Visible := False;
      Edit1.Visible := False;
      Edit2.Visible := False;
      Button1.Visible := False;
      Arquivo := DadosAnoBase + 'Trechos.dat';
      ComboBox2.Items.LoadFromFile(Arquivo);
    end
  else
    begin
      GroupBox2.Visible := True;
      CheckBox1.Checked := True;
      DBGrid1.Visible := False;
      DBGrid2.Visible := True;
      DBGrid2.Align := alClient;
      Label2.Visible := False;
      ComboBox2.Visible := False;
      Label4.Visible := True;
      Label5.Visible := True;
      Label6.Visible := True;
      Edit1.Visible := True;
      Edit2.Visible := True;
      Button1.Visible := True;
    end;
end;

procedure TForm60.Button1Click(Sender: TObject);
var
  Excel: OleVariant;
  Ano, NPeriodos, i, Modo, FileCodeExcel, NRodov, Code, NPP, j, icont, jk,
    NFields: integer;
  ArqDados: TextFile;
  PP, CustoTotal, Perct, Deficit, P1, P2: Single;
  Programa, Dados, Calc, Arquivo, ArqDbf, ArqCsv, FaixaTraf, Linha, ConfReg,
    DadosAnoBase: string;
  Rodovia: array [1..350] of string[4];
  Year: string[4];
  Parametro: string[5];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string;
begin
  Screen.Cursor := crHourglass;
  DataModule24.Table17.Active := False;
  DataModule24.Table35.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  { Cdigos de identificao das rodovias que compem a rede }
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  if ComboBox1.Text = 'ndice de Prioridade' then
    begin
      P1 := StrToFloat(Edit1.Text);
      P2 := StrToFloat(Edit2.Text);
    end
  else
    begin
      P1 := 1;
      P2 := 1;
    end;
  Arquivo := Calc + 'Pesos.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, ComboBox1.Text);
  Writeln(ArqDados, P1);
  Writeln(ArqDados, P2);
  CloseFile(ArqDados);
  ArqCsv := 'DOS.DAT';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  WinExec('Prior.bat /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 7;
  repeat
    Application.ProcessMessages;
    if FileExists(ArqCsv) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Converte de CSV para DBF }
  ArqDbf := Calc + 'Prioriza.dbf';
  ArqCsv := Calc + 'Prior.csv';
  NFields := 17;
  AssignFile(ArqDados, ArqCsv);
  Reset(ArqDados);
  Readln(ArqDados, Linha);
  with DataModule24.Table35 do
    begin
      Active := False;
      TableName := ArqDbf;
      CreateTable;
      Active := True;
      Edit;
      First;
    end;
    while not eof(ArqDados) do
      begin
        Readln(ArqDados, Linha);
        j := 1;
        for icont := 1 to NFields do
          Campo[icont] := '';
        for icont := 1 to Length(Linha) do
          begin
            if Linha[icont] = ',' then
              j := j + 1
            else
              if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
          end;
        if ConfReg = 'Portuguese' then
          begin
            for j := 3 to 4 do
              begin
                for jk := 1 to Length(Campo[j]) do
                  if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              end;
            for j := 7 to 17 do
              begin
                for jk := 1 to Length(Campo[j]) do
                  if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              end;
          end;
        DataModule24.Table35.InsertRecord([Campo[1],Campo[2],StrToFloat(Campo[3]),
          StrToFloat(Campo[4]),Campo[5],Campo[6],StrToFloat(Campo[7]),StrToFloat(Campo[8]),
          StrToFloat(Campo[9]),StrToFloat(Campo[10]),StrToFloat(Campo[11]),StrToFloat(Campo[12]),
          StrToFloat(Campo[13]),StrToFloat(Campo[14]),StrToFloat(Campo[15]),
          StrToFloat(Campo[16]),StrToFloat(Campo[17])]);
      end;
    DataModule24.Table35.Close;
    DataModule24.Table35.Active := False;
    CloseFile(ArqDados);
  DataModule24.Table35.Active := True;
  Excel := CreateOleObject('Excel.Application');
  Excel.Visible := True;
  ArqCsv := Calc + 'Prior2.csv';
  Converte(ArqCsv);
  FileCodeExcel := 6;
  Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
  Screen.Cursor := crDefault;
end;

procedure TForm60.ComboBox1Change(Sender: TObject);
begin
  if ComboBox1.Text = 'ndice de Prioridade' then
    begin
      Label4.Visible := True;
      Label5.Visible := True;
      Label6.Visible := True;
      Edit1.Visible := True;
      Edit2.Visible := True;
    end
  else
    begin
      Label4.Visible := False;
      Label5.Visible := False;
      Label6.Visible := False;
      Edit1.Visible := False;
      Edit2.Visible := False;
    end;
end;

procedure TForm60.CheckBox3Click(Sender: TObject);
begin
  if CheckBox3.Checked = True then CheckBox4.Checked := False;
  if CheckBox3.Checked = False then CheckBox4.Checked := True;
end;

procedure TForm60.CheckBox4Click(Sender: TObject);
begin
  if CheckBox4.Checked = True then CheckBox3.Checked := False;
  if CheckBox4.Checked = False then CheckBox3.Checked := True;
end;

initialization
  CoInitialize (nil);

end.
