{ QuickReport list template }

unit Unit59;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Qrctrls, quickrpt, DB, DBTables, ExtCtrls;

type
  TQRListForm12 = class(TQuickRep)
    MasterTable: TTable;
    DetailBand1: TQRBand;
    PageFooterBand1: TQRBand;
    TitleBand1: TQRBand;
    ColumnHeaderBand1: TQRBand;
    QRSysData1: TQRSysData;
    QRLabel1: TQRLabel;
    QRSysData2: TQRSysData;
    QRLabel4: TQRLabel;
    QRLabel5: TQRLabel;
    QRLabel6: TQRLabel;
    QRDBText1: TQRDBText;
    QRDBText2: TQRDBText;
    QRDBText3: TQRDBText;
    QRSysData3: TQRSysData;
    QRSysData4: TQRSysData;
    QRImage1: TQRImage;
    MasterTableITEM: TStringField;
    MasterTableCUSTO: TFloatField;
    MasterTableUNIDADE: TStringField;
    procedure QRListForm12BeforePrint(Sender: TCustomQuickRep;
      var PrintReport: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  QRListForm12: TQRListForm12;

implementation

uses Unit1;

{$R *.DFM}

procedure TQRListForm12.QRListForm12BeforePrint(Sender: TCustomQuickRep;
  var PrintReport: Boolean);
var
  ArqDados: TextFile;
  Ano, NPeriodos, NumSGP: integer;
  Programa, Dados, Calc, Arquivo, Polo, Local: string;
  Year: string[4];
  Trecho: string[4];
  SGP, Sistema: string[5];
  Num, CodSGP: string[2];
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := Calc + 'Local.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, Polo);
  Readln(ArqDados, Local);
  Readln(ArqDados, Trecho);
  CloseFile(ArqDados);
  AssignFile(ArqDados, 'Sistema.dat');
  Reset(ArqDados);
  Readln(ArqDados, SGP);
  CloseFile(ArqDados);
  if SGP[5] = '\' then Sistema := SGP[1] + SGP[2] + SGP[3] + SGP[4] else Sistema := SGP;
  Num := '';
  if Sistema = 'SGP4' then
   Num := '2'
  else
   if Sistema = 'SGP5' then
    Num := '3'
   else
    if Sistema = 'SGP3' then
      Num := '1'
    else
      if Sistema = 'SGPC' then
        Num := '11'
      else
        if Sistema = 'SGPL' then
          Num := '12'
        else
          if Sistema = 'SGPM' then Num := '13';
  if Sistema = 'SGP6' then Num := '4';
  if Sistema = 'SGP8' then Num := '6';
  if Sistema = 'SGP9' then Num := '7';
  if Sistema = 'SGP10' then Num := '8';
  if Sistema = 'SGP11' then Num := '9';
  if Sistema = 'SGP13' then Num := '14';
  if Sistema = 'SGP14' then Num := '16';
  if Sistema = 'SGP16' then Num := '17';
  if Sistema = 'SGP17' then Num := '18';
  if Sistema = 'SGP18' then Num := '19';
  if Sistema = 'SGP19' then Num := '20';
  if Sistema = 'SGP20' then Num := '21';
  if Sistema = 'SGP21' then Num := '22';
  if Sistema = 'SGP22' then Num := '23';
  if Sistema = 'SGP23' then Num := '24';
  if Sistema = 'SGP24' then Num := '25';
  if Sistema = 'SGP25' then Num := '26';
  if Sistema = 'SGP26' then Num := '27';
  if Sistema = 'SGP27' then Num := '28';
  if Sistema = 'SGP28' then Num := '29';
  if Sistema = 'SGP29' then Num := '15';
  if Sistema = 'SGMBD' then Num := '35';
  if Num = '' then
    begin
      CodSGP :=  Sistema[4] + Sistema[5];
      NumSGP := StrToInt(CodSGP) + 10;
      Num := IntToStr(NumSGP);
    end;
  MasterTable.Active := False;
  MasterTable.DatabaseName := 'STANDARD' + Num + '4';
  MasterTable.TableName := Dados + 'Custos\COST_' + Trecho + '_' + Year + '.dbf';
  MasterTable.Active := True;
  QRLabel4.Caption := 'Trecho: ' + Local;
  QRImage1.Picture.LoadFromFile(Dados + 'Logotipo.jpg');
end;

end.
