unit Unit52;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, TeEngine, Series, TeeProcs, Chart, DBChart,
  Db;

type
  TForm52 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label2: TLabel;
    ComboBox2: TComboBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    DBChart1: TDBChart;
    Series1: TLineSeries;
    Panel3: TPanel;
    DBChart2: TDBChart;
    Series2: TLineSeries;
    DBChart3: TDBChart;
    Series3: TLineSeries;
    DBChart4: TDBChart;
    Series4: TLineSeries;
    DataSource1: TDataSource;
    GroupBox1: TGroupBox;
    ComboBox3: TComboBox;
    CheckBox1: TCheckBox;
    RadioGroup1: TRadioGroup;
    procedure SntesedosResultados1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form52: TForm52;

implementation

uses Childwin, Unit53, Unit54, Unit55, Unit56, Unit24,
     Printers;

{$R *.DFM}

procedure TForm52.SntesedosResultados1Click(Sender: TObject);
begin
  MDIChild.SntesedosResultados1Click(Sender);
end;

procedure TForm52.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm52.FormShow(Sender: TObject);
begin
  DBChart1.Visible := False;
  DBChart2.Visible := False;
  DBChart3.Visible := False;
  DBChart4.Visible := False;
  DataModule24.Table11.Active := False;
  DataModule24.Table10.Active := False;
  DataModule24.Table15.Active := False;
  DataModule24.Table6.Active := False;
  DataModule24.Table7.Active := False;
  DataModule24.Table8.Active := False;
  Label2.Caption := '';
  GroupBox1.Visible := False;
  ComboBox2.Visible := False;
end;

procedure TForm52.ComboBox1Change(Sender: TObject);
begin
  ComboBox2.Text := '';
  DBChart1.Visible := False;
  DBChart2.Visible := False;
  DBChart3.Visible := False;
  DBChart4.Visible := False;
  DataModule24.Table11.Active := False;
  DataModule24.Table10.Active := False;
  DataModule24.Table15.Active := False;
  DataModule24.Table6.Active := False;
  DataModule24.Table7.Active := False;
  DataModule24.Table8.Active := False;
  GroupBox1.Visible := False;
  if (ComboBox1.Text = 'Estratgia Gerada') then
    begin
      Label2.Caption := 'Estratgia:';
      ComboBox2.Visible := True;
    end
  else
    begin
      Label2.Caption := '';
      ComboBox2.Visible := False;
    end;
end;

procedure TForm52.BitBtn1Click(Sender: TObject);
var
  ArqDados, Arq: TextFile;
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo: string;
  Year: string[4];
  Caso, Estrat: string[2];
  Series: TLineSeries;
begin
  ComboBox3.Text := '';
  DBChart1.Visible := False;
  DBChart2.Visible := False;
  DBChart3.Visible := False;
  DBChart4.Visible := False;
  DataModule24.Table11.Active := False;
  DataModule24.Table10.Active := False;
  DataModule24.Table15.Active := False;
  DataModule24.Table6.Active := False;
  DataModule24.Table7.Active := False;
  DataModule24.Table8.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  if (ComboBox1.Text <> 'Estratgia Gerada') then
      begin
        Estrat := '';
        if (ComboBox1.Text = 'Efeito do Nvel de Investimento') then Caso := 'NI';
        if (ComboBox1.Text = 'Efeito do Perodo de Projeto') then Caso := 'PP';
        if (ComboBox1.Text = 'Efeito do PSI Terminal') then Caso := 'PT';
      end
  else
      begin
        Caso := 'EG';
        if (ComboBox2.Text = 'Evoluo da Condio sem Investimentos') then Estrat := 'SI';
        if (ComboBox2.Text = 'Estratgia-Base') then Estrat := 'EB';
        if (ComboBox2.Text = 'Estratgia sob Restries') then Estrat := 'RO';
      end;
  Arquivo := Calc + 'Caso.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Caso);
  Writeln(ArqDados, Estrat);
  CloseFile(ArqDados);
  GroupBox1.Visible := True;
  Series1.Clear;
  Series2.Clear;
  Series3.Clear;
  Series4.Clear;
  Series1.ParentChart := DBChart1;
  Series2.ParentChart := DBChart2;
  Series3.ParentChart := DBChart3;
  Series4.ParentChart := DBChart4;
  if (ComboBox1.Text = 'Estratgia Gerada') then
    begin
      if (ComboBox2.Text = 'Evoluo da Condio sem Investimentos')
       then DataSource1.DataSet := DataModule24.Table11;
      if (ComboBox2.Text = 'Estratgia-Base')
       then DataSource1.DataSet := DataModule24.Table10;
      if (ComboBox2.Text = 'Estratgia sob Restries')
       then DataSource1.DataSet := DataModule24.Table15;
      Series1.DataSource := DataSource1.DataSet;
      Series2.DataSource := DataSource1.DataSet;
      Series3.DataSource := DataSource1.DataSet;
      Series4.DataSource := DataSource1.DataSet;
      DBChart1.AddSeries(Series1);
      DBChart2.AddSeries(Series2);
      DBChart3.AddSeries(Series3);
      DBChart4.AddSeries(Series4);
      DBChart1.Title.Text.Clear;
      DBChart2.Title.Text.Clear;
      DBChart3.Title.Text.Clear;
      DBChart4.Title.Text.Clear;
      DBChart1.Title.Text.Append('Custo (R$ 1000,00/ano)');
      DBChart2.Title.Text.Append('PSI mdio da rede');
      DBChart3.Title.Text.Append('Ocorrncias (% da rede)');
      DBChart4.Title.Text.Append('Vida Restante (anos)');
      Series1.XValues.ValueSource := 'ANO';
      Series1.YValues.ValueSource := 'CUSTO';
      Series2.XValues.ValueSource := 'ANO';
      Series2.YValues.ValueSource := 'PSIMEDIO';
      Series3.XValues.ValueSource := 'ANO';
      Series3.YValues.ValueSource := 'OCORR';
      Series4.XValues.ValueSource := 'ANO';
      Series4.YValues.ValueSource := 'VRANOS';
      if Estrat = 'SI' then DataModule24.Table11.Active := True;
      if Estrat = 'EB' then DataModule24.Table10.Active := True;
      if Estrat = 'RO' then DataModule24.Table15.Active := True;
    end;
  if (ComboBox1.Text = 'Efeito do Nvel de Investimento') then
    begin
      DataSource1.DataSet := DataModule24.Table6;
      Series1.DataSource := DataSource1.DataSet;
      Series2.DataSource := DataSource1.DataSet;
      Series3.DataSource := DataSource1.DataSet;
      Series4.DataSource := DataSource1.DataSet;
      DBChart1.AddSeries(Series1);
      DBChart2.AddSeries(Series2);
      DBChart3.AddSeries(Series3);
      DBChart4.AddSeries(Series4);
      DBChart1.Title.Text.Clear;
      DBChart2.Title.Text.Clear;
      DBChart3.Title.Text.Clear;
      DBChart4.Title.Text.Clear;
      DBChart1.Title.Text.Append('Custo no Ciclo de Vida (milhes de R$)');
      DBChart2.Title.Text.Append('PSI mdio da rede');
      DBChart3.Title.Text.Append('Ocorrncias (% da rede)');
      DBChart4.Title.Text.Append('Relao Benefcio-Custo');
      Series1.XValues.ValueSource := 'INVESTIMEN';
      Series1.YValues.ValueSource := 'CCV';
      Series2.XValues.ValueSource := 'INVESTIMEN';
      Series2.YValues.ValueSource := 'PSIMED';
      Series3.XValues.ValueSource := 'INVESTIMEN';
      Series3.YValues.ValueSource := 'OCORRENCIA';
      Series4.XValues.ValueSource := 'INVESTIMEN';
      Series4.YValues.ValueSource := 'RBC';
      DataModule24.Table6.Active := True;
    end;
  if (ComboBox1.Text = 'Efeito do Perodo de Projeto') then
    begin
      DataSource1.DataSet := DataModule24.Table7;
      Series1.DataSource := DataSource1.DataSet;
      Series2.DataSource := DataSource1.DataSet;
      Series3.DataSource := DataSource1.DataSet;
      Series4.DataSource := DataSource1.DataSet;
      DBChart1.AddSeries(Series1);
      DBChart2.AddSeries(Series2);
      DBChart3.AddSeries(Series3);
      DBChart4.AddSeries(Series4);
      DBChart1.Title.Text.Clear;
      DBChart2.Title.Text.Clear;
      DBChart3.Title.Text.Clear;
      DBChart4.Title.Text.Clear;
      DBChart1.Title.Text.Append('Custo no Ciclo de Vida (milhes de R$)');
      DBChart2.Title.Text.Append('PSI mdio da rede');
      DBChart3.Title.Text.Append('Ocorrncias (% da rede)');
      DBChart4.Title.Text.Append('Relao Benefcio-Custo');
      Series1.XValues.ValueSource := 'PPROJETO';
      Series1.YValues.ValueSource := 'CCV';
      Series2.XValues.ValueSource := 'PPROJETO';
      Series2.YValues.ValueSource := 'PSIMED';
      Series3.XValues.ValueSource := 'PPROJETO';
      Series3.YValues.ValueSource := 'OCORRENCIA';
      Series4.XValues.ValueSource := 'PPROJETO';
      Series4.YValues.ValueSource := 'RBC';
      DataModule24.Table7.Active := True;
    end;
  if (ComboBox1.Text = 'Efeito do PSI Terminal') then
    begin
      DataSource1.DataSet := DataModule24.Table8;
      Series1.DataSource := DataSource1.DataSet;
      Series2.DataSource := DataSource1.DataSet;
      Series3.DataSource := DataSource1.DataSet;
      Series4.DataSource := DataSource1.DataSet;
      DBChart1.AddSeries(Series1);
      DBChart2.AddSeries(Series2);
      DBChart3.AddSeries(Series3);
      DBChart4.AddSeries(Series4);
      DBChart1.Title.Text.Clear;
      DBChart2.Title.Text.Clear;
      DBChart3.Title.Text.Clear;
      DBChart4.Title.Text.Clear;
      DBChart1.Title.Text.Append('Custo no Ciclo de Vida (milhes de R$)');
      DBChart2.Title.Text.Append('PSI mdio da rede');
      DBChart3.Title.Text.Append('Ocorrncias (% da rede)');
      DBChart4.Title.Text.Append('Relao Benefcio-Custo');
      Series1.XValues.ValueSource := 'PSIT';
      Series1.YValues.ValueSource := 'CCV';
      Series2.XValues.ValueSource := 'PSIT';
      Series2.YValues.ValueSource := 'PSIMED';
      Series3.XValues.ValueSource := 'PSIT';
      Series3.YValues.ValueSource := 'OCORRENCIA';
      Series4.XValues.ValueSource := 'PSIT';
      Series4.YValues.ValueSource := 'RBC';
      DataModule24.Table8.Active := True;
    end;
  DBChart1.Visible := True;
  DBChart2.Visible := True;
  DBChart3.Visible := True;
  DBChart4.Visible := True;
end;

procedure TForm52.ComboBox2Change(Sender: TObject);
begin
  DBChart1.Visible := False;
  DBChart2.Visible := False;
  DBChart3.Visible := False;
  DBChart4.Visible := False;
  DataModule24.Table11.Active := False;
  DataModule24.Table10.Active := False;
  DataModule24.Table15.Active := False;
  GroupBox1.Visible := False;
end;

procedure TForm52.CheckBox1Click(Sender: TObject);
begin
  DBChart1.View3D := CheckBox1.Checked;
  DBChart2.View3D := CheckBox1.Checked;
  DBChart3.View3D := CheckBox1.Checked;
  DBChart4.View3D := CheckBox1.Checked;
end;

procedure TForm52.ComboBox3Change(Sender: TObject);
var
  tmpH, tmpW, tmpWMargin, tmpHMargin: Longint; { margins }
  OldOrientation: TPrinterOrientation;
begin
  if ComboBox3.Text <> '' then
  if ComboBox3.Text = 'Tabela' then
    begin
      if (ComboBox1.Text = 'Estratgia Gerada') then QRListForm7.Preview;
      if (ComboBox1.Text = 'Efeito do Nvel de Investimento') then QRListForm8.Preview;
      if (ComboBox1.Text = 'Efeito do Perodo de Projeto') then QRListForm9.Preview;
      if (ComboBox1.Text = 'Efeito do PSI Terminal') then QRListForm10.Preview;
    end
  else
    begin
      Screen.Cursor := crHourGlass;
      OldOrientation:=Printer.Orientation;  { <-- save paper orientation }
      Printer.Orientation:=poLandscape; { <-- Force Horizontal paper }
      try
        Printer.BeginDoc;       { <-- start printer job }
        try
          Printer.Title := ComboBox1.Text + '    ' + ComboBox2.Text;

          Case RadioGroup1.ItemIndex of
             0: Begin { screen proportional }
                  DBChart1.PrintResolution:= 0;
                  DBChart2.PrintResolution:= 0;
                  DBChart3.PrintResolution:= 0;
                  DBChart4.PrintResolution:= 0;
                End;
             1: Begin { thin lines and small fonts }
                  DBChart1.PrintResolution:= -100;
                  DBChart2.PrintResolution:= -100;
                  DBChart3.PrintResolution:= -100;
                  DBChart4.PrintResolution:= -100;
                End;
          end;

          { Print the four charts, each one at a different paper position }

          { CALCULATE HORIZONTAL MARGIN }
          tmpW:=Printer.PageWidth;
          tmpWMargin:=Round(5.0*tmpW/100.0); { <-- 5% margins }
          tmpW:=tmpW-2*tmpWMargin;  { <-- left and right margins }
          tmpW:=tmpW div 2; { half width for left and right charts }

          { CALCULATE VERTICAL MARGIN }
          tmpH:=Printer.PageHeight;
          tmpHMargin:=Round(5.0*tmpH/100.0);  { <-- 5% margins }
          tmpH:=tmpH-2*tmpHMargin;  { <-- bottom and top margins }
          tmpH:=tmpH div 2; { half height for top and bottom charts }

          { left / top chart }
          DBChart1.PrintPartial( Rect( tmpWMargin,tmpHMargin,
                                 tmpWMargin+tmpW,tmpHMargin+tmpH ) );

          { right / top chart }
          DBChart3.PrintPartial( Rect( tmpWMargin+tmpW,tmpHMargin,
                                 tmpWMargin+2*tmpW,tmpHMargin+tmpH ) );

          { left / bottom chart }
          DBChart2.PrintPartial( Rect( tmpWMargin,tmpHMargin+tmpH,
                                 tmpWMargin+tmpW,tmpHMargin+2*tmpH ) );

          { right / bottom chart }
          DBChart4.PrintPartial( Rect( tmpWMargin+tmpW,tmpHMargin+tmpH,
                                 tmpWMargin+2*tmpW,tmpHMargin+2*tmpH ) );

          Printer.EndDoc; { <-- end job and print !! }
        except
           on Exception do  { just in case an error happens... }
              Begin
                Printer.Abort;
                Printer.EndDoc;
                Raise;
              end;
        end;
        finally
          Printer.Orientation:=OldOrientation;  { <-- restore paper orientation }
          Screen.Cursor:=crDefault; { <-- restore cursor }
      end;
    end;
end;

end.



