unit Unit50;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TForm50 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label2: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    Edit2: TEdit;
    Label4: TLabel;
    Panel3: TPanel;
    Label5: TLabel;
    ComboBox2: TComboBox;
    Label1: TLabel;
    Label6: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    Edit5: TEdit;
    Edit6: TEdit;
    GroupBox1: TGroupBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    Label9: TLabel;
    RadioGroup1: TRadioGroup;
    procedure IncluiNovoTrecho1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form50: TForm50;

implementation

uses Childwin, ComObj, ActiveX, Unit10, Unit24;

{$R *.DFM}

procedure TForm50.IncluiNovoTrecho1Click(Sender: TObject);
begin
  MDIChild.IncluiNovoTrecho1Click(Sender);
end;

procedure TForm50.FormShow(Sender: TObject);
begin
  GroupBox1.Visible := False;
  Label5.Caption := '';
  Label9.Caption := '';
  ComboBox2.Visible := False;
end;

procedure TForm50.BitBtn1Click(Sender: TObject);
const
  NFaixasMax = 4;
var
  Excel: OleVariant;
  i, j, NSTH, Ano, NPeriodos, NRodov, STHini, STHfim, NDados, IFaixa, IRodov,
    FileCodeExcel, NFields, icont, isth, NLinhas, icont1, jk: integer;
  Arquivo, Programa, Dados, Calc, Arq, ArqData, ArqDbf, Texto1, Texto2, ArqCsv,
    DadosAnoBase, Tipo, LinhaArq, Subtrecho, Revest, Base, SubBase, RefSL,
    Subleito, AnoRevest, SentidoFx2, Param: string;
  NomeArq, km, Carga, Bloc, Tar, Tsup, IRI, ATResq, ATRdir, PastaDados, LinhaOut,
    Pista, NFaixas, LargFaixa, LargAcost, TTm2, TBm2, TLm2, CR1m2, CR2m2, APLm2,
    DGm2, EXm2, AF1m2, AF2m2, AF3m2, PAm2, R1m2, R2m2, CORm2, DNm2, Lado, Local,
    Nome, ConfReg: string;
  QI, kminiFx3, kmfimFx3, LFx, LAc, Altitude, kmP, Dist, kmP2: Single;
  Df: array [1..7] of string[10];
  Year, NomeTrecho: string[4];
  kmini, km1, km2, Resto, kmfim, PluvmmAno, Altm, AcostLE, AcostLD, kmi, kmf,
    Faixa1, Faixa2, Faixa3, Faixa4, kmini1, kmfim1, Pluv1, Altm1, AcostLE1, PSR,
    AcostLD1, Fx1, Fx2, Fx3, Fx4, ExtFim,Marshall,RtDiamet,VaziosAr,TeorAsf, Area,
    h1origcm,h2cm,CBRbase,Rcs28dBase,h3cm,CBRsb,Rcs28dSb,h4cm,CBRref,CBRsl,LLsl,
    IPsl,Perct200,ProfRocha, PSRacost, Degraucm, Perct, IGG, Dplaca, Qmed, TarMed,
    TsupMed, AnoRevAcost, h1cm, PerctVDM, VDM, VDMc2, VDMc3, VDMc4, VDMc5, VDMc6,
    PerctTT3, PerctBL3, PerctTL3, PerctCR2, PerctCR3, PerctDP, PerctD, PerctEX,
    PerctATR, PerctEM, PerctP, PerctR2, PerctR3, PerctCOR, VDMcom: Single;
  ArqDados, ArqOut, ArqIn: TextFile;
  Trecho: array[1..350] of string;
  Code: array[1..350] of string[4];
  TipoDado: array [1..40] of string;
  Faixa: array [1..4] of string[1];
  Codigo: string[5];
  Rodovia: array [1..350] of string[4];
  source, destination: file;
  buffer: array [1..1024] of byte;
  readcnt, writecnt, NCasos: integer;
  scrname, destname: string;
  Linha: array [1..60] of string;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string;
  QIFx, kmiFx, kmfFx, ATResqFx, ATRdirFx: array [1..NFaixasMax, 1..10000] of Single;
  Trocou: Boolean;
begin
 Screen.Cursor := crHourglass;
 { Ano-base e subdiretrios }
   AssignFile(ArqDados, 'Diretor.dat');
   Reset(ArqDados);
   Readln(ArqDados, Ano);
   Readln(ArqDados, NPeriodos);
   Readln(ArqDados, Programa);
   Readln(ArqDados, Dados);
   Readln(ArqDados, Calc);
   Readln(ArqDados, DadosAnoBase);
   CloseFile(ArqDados);
   Year := IntToStr(Ano);
 AssignFile(ArqDados, 'Config.dat');
 Reset(ArqDados);
 Readln(ArqDados, ConfReg);
 CloseFile(ArqDados);
if RadioGroup1.ItemIndex < 2 then
 begin
  ArqData := DadosAnoBase + 'Trechos.dat';
  Arq := DadosAnoBase + 'Trechos.dsc';
  AssignFile(ArqDados, ArqData);
  Reset(ArqDados);
  AssignFile(ArqOut, Arq);
  Reset(ArqOut);
  i := 0;
  while Eof(ArqDados) = False do
    begin
      i := i + 1;
      Readln(ArqDados, Trecho[i]);
      Readln(ArqOut, Code[i]);
    end;
  CloseFile(ArqDados);
  CloseFile(ArqOut);
  i := i + 1;
  Trecho[i] := Edit1.Text;
  Code[i] := Edit2.Text;
  AssignFile(ArqDados, ArqData);
  Rewrite(ArqDados);
  AssignFile(ArqOut, Arq);
  Rewrite(ArqOut);
  for j := 1 to i do
    begin
      Writeln(ArqDados, Trecho[j]);
      Writeln(ArqOut, Code[j]);
    end;
  CloseFile(ArqDados);
  CloseFile(ArqOut);
  AssignFile(ArqDados, DadosAnoBase + 'Tre.dat');
  Rewrite(ArqDados);
  for j := 1 to i do
    begin
      LinhaArq := '';
      for icont := 1 to Length(Trecho[j]) do
        if Trecho[j,icont] <> ',' then LinhaArq := LinhaArq + Trecho[j,icont];
      Writeln(ArqDados, LinhaArq);
    end;
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for j := 1 to NRodov do
    Readln(ArqDados, Rodovia[j]);
  CloseFile(ArqDados);
  NRodov := NRodov + 1;
  Rodovia[NRodov] := Code[i];
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Writeln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  Arquivo := Programa + 'GeraDat.bat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, 'Copy ' + Dados + 'Cargas_' + Rodovia[1] + '.dat ' + Dados + 'Cargas_' + Rodovia[NRodov] + '.dat');
  Writeln(ArqDados, 'Copy ' + Calc + 'Fv_' + Rodovia[1] + '.dat ' + Calc + 'Fv_' + Rodovia[NRodov] + '.dat');
  Writeln(ArqDados, 'Copy ' + Calc + 'USACE_' + Rodovia[1] + '.dat ' + Calc + 'USACE_' + Rodovia[NRodov] + '.dat');
  Writeln(ArqDados, 'Cadas.exe');
  CloseFile(ArqDados);
  Arquivo := Calc + 'Calib.csv';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, Texto1);
  for i := 1 to NRodov-1 do
    Readln(ArqDados, Linha[i]);
  Readln(ArqDados, Texto2);
  CloseFile(ArqDados);
  Linha[NRodov] := Rodovia[NRodov] + ',2.5,0.10,1.0';
  Arquivo := Calc + 'Calib.csv';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Texto1);
  for i := 1 to NRodov do
    Writeln(ArqDados, Linha[i]);
  Writeln(ArqDados, Texto2);
  CloseFile(ArqDados);
  { Cria o arquivo dos parmetros da rvore de deciso }
      scrname := Calc + 'Arv' + Rodovia[1] + '.dat';
      destname := Calc + 'Arv' + Rodovia[NRodov] + '.dat';
      AssignFile(source, scrname);
      Try
         Reset(source, 1);
      Except
         Exit;
      end;
      AssignFile(destination, destname);
      Try
         Rewrite(destination, 1);
      Except
         Exit;
      end;
      Repeat
        BlockRead(source, buffer, sizeof(buffer), readcnt);
        Try
          BlockWrite(destination, buffer, readcnt, writecnt);
        Except
          Exit;
        end;
      until (readcnt=0) or (writecnt<>readcnt);
      CloseFile(destination);
      CloseFile(source);
   { Cria o arquivo dos custos unitrios }
      scrname := Dados + 'Custos\' + 'Cost_' + Rodovia[1] + '_' + Year + '.dbf';
      destname := Dados + 'Custos\' + 'Cost_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      AssignFile(source, scrname);
      Try
         Reset(source, 1);
      Except
         Exit;
      end;
      AssignFile(destination, destname);
      Try
         Rewrite(destination, 1);
      Except
         Exit;
      end;
      Repeat
        BlockRead(source, buffer, sizeof(buffer), readcnt);
        Try
          BlockWrite(destination, buffer, readcnt, writecnt);
        Except
          Exit;
        end;
      until (readcnt=0) or (writecnt<>readcnt);
      CloseFile(destination);
      CloseFile(source);
      scrname := Calc + 'Cost' + Rodovia[1] + '.csv';
      destname := Calc + 'Cost' + Rodovia[NRodov] + '.csv';
      AssignFile(source, scrname);
      Try
         Reset(source, 1);
      Except
         Exit;
      end;
      AssignFile(destination, destname);
      Try
         Rewrite(destination, 1);
      Except
         Exit;
      end;
      Repeat
        BlockRead(source, buffer, sizeof(buffer), readcnt);
        Try
          BlockWrite(destination, buffer, readcnt, writecnt);
        Except
          Exit;
        end;
      until (readcnt=0) or (writecnt<>readcnt);
      CloseFile(destination);
      CloseFile(source);
  STHini := StrToInt(Edit3.Text);
  STHfim := StrToInt(Edit4.Text);
  kmi := StrToFloat(Edit5.Text);
  kmf := StrToFloat(Edit6.Text);
  Faixa[1] := '1';
  Faixa[2] := '2';
  Faixa[3] := '3';
  Faixa[4] := '4';
  Arquivo := Calc + 'Code' + Rodovia[NRodov] + '.STH';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, NSTH);
  for i := STHini to STHfim do
    Writeln(ArqDados, i);
  CloseFile(ArqDados);
  Label5.Caption := 'Trecho:';
  ComboBox2.Items.LoadFromFile(ArqData);
  ComboBox2.Visible := True;
  for i := 1 to NFaixasMax do
    begin
      Arquivo := Calc + 'Sol' + Rodovia[1] + Faixa[i] + '.csv';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Readln(ArqDados, Texto1);
      CloseFile(ArqDados);
      Arquivo := Calc + 'Sol' + Rodovia[NRodov] + Faixa[i] + '.csv';
      AssignFile(ArqDados, Arquivo);
      Rewrite(ArqDados);
      Writeln(ArqDados, Texto1);
      CloseFile(ArqDados);
    end;
  { Gera os dados cadastrais }
  Arquivo := Calc + 'Cadas.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Rodovia[NRodov]);
  Writeln(ArqDados, STHini);
  Writeln(ArqDados, STHfim);
  Writeln(ArqDados, kmi);
  Writeln(ArqDados, kmf);
  CloseFile(ArqDados);
  Arquivo := 'DOS.DAT';
  if FileExists(Arquivo) then
    begin
      AssignFile(ArqDados, Arquivo);
      Erase(ArqDados)
    end;
  WinExec('GeraDat.bat /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 3;
  repeat
    Application.ProcessMessages;
    if FileExists(Arquivo) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
  ArqCsv := Calc + 'Cadas' + Rodovia[NRodov] + '.csv';
      NFields := 25;
      AssignFile(ArqDados, ArqCsv);
      Reset(ArqDados);
      Readln(ArqDados, LinhaArq);
      with DataModule10.Table2 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, LinhaArq);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(LinhaArq) do
            begin
              if LinhaArq[icont] = ',' then
                j := j + 1
              else
                if LinhaArq[icont] <> '"' then Campo[j] := Campo[j] + LinhaArq[icont];
            end;
          if ConfReg = 'Portuguese' then
            begin
              for j := 5 to 6 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
              for j := 8 to 14 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
              for j := 18 to 24 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
            end;
          DataModule10.Table2.InsertRecord([Campo[1],Campo[2],Campo[3],Campo[4],StrToFloat(Campo[5]),
            StrToFloat(Campo[6]),Campo[7],StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),
            StrToFloat(Campo[11]),StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),
            Campo[15],Campo[16],Campo[17],StrToFloat(Campo[18]),StrToFloat(Campo[19]),
            StrToFloat(Campo[20]),StrToFloat(Campo[21]),StrToFloat(Campo[22]),StrToFloat(Campo[23]),
            StrToFloat(Campo[24]),Campo[25]]);
        end;
      DataModule10.Table2.Close;
      DataModule10.Table2.Active := False;
      CloseFile(ArqDados);
  { Estrutura do Pavimento Original }
    for IFaixa := 1 to NFaixasMax do
      begin
        ArqDbf := Dados + 'Estr_' + Rodovia[NRodov] + Faixa[IFaixa] + '_' + Year + '.dbf';
        with DataModule10.Table4 do
          begin
            Active := False;
            TableName := ArqDbf;
            CreateTable;
            Active := True;
            Edit;
            First;
          end;
        ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
        DataModule10.Table2.Active := False;
        DataModule10.Table2.TableName := ArqDbf;
        DataModule10.Table2.Active := True;
        while not DataModule10.Table2.Eof do
          begin
            Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
            if IFaixa <= Round(DataModule10.Table2.Fields.Fields[7].AsFloat) then
              begin
                Revest := 'CBUQ';
                Base := 'BG';
                SubBase := '';
                RefSL := '';
                Subleito := '';
                AnoRevest := '1985';
                Marshall := -1;
                RtDiamet := -1;
                VaziosAr := -1;
                TeorAsf := -1;
                h1origcm := 5;
                h2cm := 15;
                CBRbase := -1;
                Rcs28dBase := -1;
                h3cm := 0;
                CBRsb := -1;
                Rcs28dSb := -1;
                h4cm := 0;
                CBRref := -1;
                CBRsl := 10;
                LLsl := -1;
                IPsl := -1;
                Perct200 := -1;
                ProfRocha := -1;
              end
            else
              begin
                Revest := '';
                Base := '';
                SubBase := '';
                RefSL := '';
                Subleito := '';
                AnoRevest := '-1';
                Marshall := -1;
                RtDiamet := -1;
                VaziosAr := -1;
                TeorAsf := -1;
                h1origcm := 0;
                h2cm := 0;
                CBRbase := -1;
                Rcs28dBase := -1;
                h3cm := 0;
                CBRsb := -1;
                Rcs28dSb := -1;
                h4cm := 0;
                CBRref := -1;
                CBRsl := -1;
                LLsl := -1;
                IPsl := -1;
                Perct200 := -1;
                ProfRocha := -1;
              end;
            if ConfReg = 'Portuguese' then
              begin
                Param := FloatToStr(Marshall);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                Marshall := StrToFloat(Param);
                Param := FloatToStr(Rcs28dBase);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                Rcs28dBase := StrToFloat(Param);
                Param := FloatToStr(Rcs28dSb);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                Rcs28dSb := StrToFloat(Param);
                Param := FloatToStr(LLsl);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                LLsl := StrToFloat(Param);
                Param := FloatToStr(IPsl);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                IPsl := StrToFloat(Param);
                Param := FloatToStr(Perct200);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                Perct200 := StrToFloat(Param);
                Param := FloatToStr(ProfRocha);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                ProfRocha := StrToFloat(Param);
                Param := FloatToStr(CBRbase);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                CBRbase := StrToFloat(Param);
                Param := FloatToStr(CBRsb);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                CBRsb := StrToFloat(Param);
                Param := FloatToStr(CBRref);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                CBRref := StrToFloat(Param);
                Param := FloatToStr(CBRsl);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                CBRsl := StrToFloat(Param);
                Param := FloatToStr(h4cm);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                h4cm := StrToFloat(Param);
                Param := FloatToStr(h3cm);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                h3cm := StrToFloat(Param);
                Param := FloatToStr(h2cm);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                h2cm := StrToFloat(Param);
                Param := FloatToStr(h1Origcm);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                h1Origcm := StrToFloat(Param);
                Param := FloatToStr(TeorAsf);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                TeorAsf := StrToFloat(Param);
                Param := FloatToStr(VaziosAr);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                VaziosAr := StrToFloat(Param);
                Param := FloatToStr(RtDiamet);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                RtDiamet := StrToFloat(Param);
              end;
            DataModule10.Table4.InsertRecord([Subtrecho,AnoRevest,Revest,Marshall,RtDiamet,VaziosAr,
              TeorAsf,h1origcm,Base,h2cm,CBRbase,Rcs28dBase,SubBase,h3cm,CBRsb,Rcs28dSb,RefSL,h4cm,
              CBRref,Subleito,CBRsl,LLsl,IPsl,Perct200,ProfRocha]);
            DataModule10.Table2.Next;
          end;
        DataModule10.Table4.Close;
        DataModule10.Table4.Active := False;
      end;
  { Acostamentos }
      ArqDbf := Dados + 'Acost_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      NFields := 14;
      for icont := 1 to NFields do
        Campo[icont] := '-1';
      with DataModule10.Table1 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      DataModule10.Table2.Active := False;
      DataModule10.Table2.TableName := ArqDbf;
      DataModule10.Table2.Active := True;
      while not DataModule10.Table2.Eof do
        begin
          Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
          if ConfReg = 'Portuguese' then
            begin
              j := 3;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 5;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 7;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 9;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 10;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 13;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
            end;
          DataModule10.Table1.InsertRecord([Subtrecho,'',StrToFloat(Campo[3]),'',
            StrToFloat(Campo[5]),'',StrToFloat(Campo[7]),'',StrToFloat(Campo[9]),
            StrToFloat(Campo[10]),'','',StrToFloat(Campo[13]),'Nao']);
          DataModule10.Table2.Next;
        end;
      DataModule10.Table1.Close;
      DataModule10.Table1.Active := False;
  { QI }
      ArqDbf := Dados + 'Func_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      NFields := 7;
      for icont := 1 to NFields do
        Campo[icont] := '';
      with DataModule10.Table5 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      DataModule10.Table2.Active := False;
      DataModule10.Table2.TableName := ArqDbf;
      DataModule10.Table2.Active := True;
      while not DataModule10.Table2.Eof do
        begin
          Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
          DataModule10.Table5.InsertRecord([Subtrecho,-1,-1,-1,-1,Campo[6],'Nenhum']);
          DataModule10.Table2.Next;
        end;
      DataModule10.Table5.Close;
      DataModule10.Table5.Active := False;
  { IRI }
      ArqDbf := Dados + 'IRI_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      NFields := 7;
      for icont := 1 to NFields do
        Campo[icont] := '';
      with DataModule10.Table16 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      DataModule10.Table2.Active := False;
      DataModule10.Table2.TableName := ArqDbf;
      DataModule10.Table2.Active := True;
      while not DataModule10.Table2.Eof do
        begin
          Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
          DataModule10.Table16.InsertRecord([Subtrecho,-1,-1,-1,-1,Campo[6],'Nenhum']);
          DataModule10.Table2.Next;
        end;
      DataModule10.Table16.Close;
      DataModule10.Table16.Active := False;
  { ATR }
      ArqDbf := Dados + 'ATR_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      NFields := 19;
      for icont := 1 to NFields do
        Campo[icont] := '-1';
      with DataModule10.Table10 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      DataModule10.Table2.Active := False;
      DataModule10.Table2.TableName := ArqDbf;
      DataModule10.Table2.Active := True;
      while not DataModule10.Table2.Eof do
        begin
          Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
          if ConfReg = 'Portuguese' then
            begin
              for j := 2 to 9 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
              for j := 12 to 19 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
            end;
          DataModule10.Table10.InsertRecord([Subtrecho,StrToFloat(Campo[2]),
            StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),
            StrToFloat(Campo[6]),StrToFloat(Campo[7]),StrToFloat(Campo[8]),
            StrToFloat(Campo[9]),'','',StrToFloat(Campo[12]),
            StrToFloat(Campo[13]),StrToFloat(Campo[14]),StrToFloat(Campo[15]),
            StrToFloat(Campo[16]),StrToFloat(Campo[17]),StrToFloat(Campo[18]),
            StrToFloat(Campo[19])]);
          DataModule10.Table2.Next;
        end;
      DataModule10.Table10.Close;
      DataModule10.Table10.Active := False;
  { Cria o arquivo de ampliaes de capacidade de trfego }
      ArqDbf := Calc + 'Amplia_' + Rodovia[NRodov] + '.dbf';
      NFields := 6;
      for icont := 1 to NFields do
        Campo[icont] := '-1';
      with DataModule24.Table33 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      DataModule10.Table2.Active := False;
      DataModule10.Table2.TableName := ArqDbf;
      DataModule10.Table2.Active := True;
      while not DataModule10.Table2.Eof do
        begin
          Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
          if ConfReg = 'Portuguese' then
            begin
              for j := 2 to 6 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
            end;
          DataModule24.Table33.InsertRecord([Subtrecho,StrToFloat(Campo[2]),
            StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),
            StrToFloat(Campo[6])]);
          DataModule10.Table2.Next;
        end;
      DataModule24.Table33.Close;
      DataModule24.Table33.Active := False;
   { Trfego Atuante }
      ArqDbf := Dados + 'Traf_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      NFields := 13;
      for icont := 1 to NFields do
        Campo[icont] := '-1';
      with DataModule10.Table7 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
      DataModule10.Table2.Active := False;
      DataModule10.Table2.TableName := ArqDbf;
      DataModule10.Table2.Active := True;
      while not DataModule10.Table2.Eof do
        begin
          Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
          if ConfReg = 'Portuguese' then
            begin
              j := 3;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 6;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 7;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
            end;
          DataModule10.Table7.InsertRecord([Subtrecho,'Contagem',StrToFloat(Campo[3]),
            100.0,100.0,StrToFloat(Campo[6]),StrToFloat(Campo[7]),5000.0,400.0,
            250.0,150.0,100.0,100.0]);
          DataModule10.Table2.Next;
         end;
      DataModule10.Table7.Close;
      DataModule10.Table7.Active := False;
  { Deflexes }
    NFields := 22;
    for icont := 1 to NFields do
      Campo[icont] := '-1';
    for IFaixa := 1 to NFaixasMax do
      begin
        ArqDbf := Dados + 'DFX_' + Rodovia[NRodov] + Faixa[IFaixa] + '_' + Year + '.dbf';
        with DataModule10.Table3 do
          begin
            Active := False;
            TableName := ArqDbf;
            CreateTable;
            Active := True;
            Edit;
            First;
          end;
        ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
        DataModule10.Table2.Active := False;
        DataModule10.Table2.TableName := ArqDbf;
        DataModule10.Table2.Active := True;
        while not DataModule10.Table2.Eof do
          begin
            Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
            if ConfReg = 'Portuguese' then
              begin
                for j := 2 to 20 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
              end;
            DataModule10.Table3.InsertRecord([Subtrecho,StrToFloat(Campo[2]),StrToFloat(Campo[3]),
              StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),
              StrToFloat(Campo[7]),StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),
              StrToFloat(Campo[11]),StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),
              StrToFloat(Campo[15]),StrToFloat(Campo[16]),StrToFloat(Campo[17]),StrToFloat(Campo[18]),
              StrToFloat(Campo[19]),StrToFloat(Campo[20]),'','Nenhum']);
            DataModule10.Table2.Next;
          end;
        DataModule10.Table3.Close;
        DataModule10.Table3.Active := False;
      end;
  { Mdulos de Elasticidade das Camadas }
    NFields := 17;
    for icont := 1 to NFields do
      Campo[icont] := '-1';
    for IFaixa := 1 to NFaixasMax do
      begin
        ArqDbf := Dados + 'MOD_' + Rodovia[NRodov] + Faixa[IFaixa] + '_' + Year + '.dbf';
        with DataModule10.Table12 do
          begin
            Active := False;
            TableName := ArqDbf;
            CreateTable;
            Active := True;
            Edit;
            First;
          end;
        ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
        DataModule10.Table2.Active := False;
        DataModule10.Table2.TableName := ArqDbf;
        DataModule10.Table2.Active := True;
        while not DataModule10.Table2.Eof do
          begin
            Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
            if ConfReg = 'Portuguese' then
              begin
                for j := 2 to 15 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
              end;
            DataModule10.Table12.InsertRecord([Subtrecho,StrToFloat(Campo[2]),StrToFloat(Campo[3]),
              StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),
              StrToFloat(Campo[7]),StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),
              StrToFloat(Campo[11]),StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),
              StrToFloat(Campo[15]),'','Nenhum']);
            DataModule10.Table2.Next;
          end;
        DataModule10.Table12.Close;
        DataModule10.Table12.Active := False;
      end;
  { LVC }
    NFields := 39;
    for icont := 1 to NFields do
      Campo[icont] := '';
    for IFaixa := 1 to NFaixasMax do
      begin
        ArqDbf := Dados + 'LVC_' + Rodovia[NRodov] + Faixa[IFaixa] + '_' + Year + '.dbf';
        with DataModule10.Table6 do
          begin
            Active := False;
            TableName := ArqDbf;
            CreateTable;
            Active := True;
            Edit;
            First;
          end;
        ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
        DataModule10.Table2.Active := False;
        DataModule10.Table2.TableName := ArqDbf;
        DataModule10.Table2.Active := True;
        while not DataModule10.Table2.Eof do
          begin
            Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
            kmi := DataModule10.Table2.Fields.Fields[4].AsFloat;
            kmf := DataModule10.Table2.Fields.Fields[5].AsFloat;
            if ConfReg = 'Portuguese' then
              begin
                Param := FloatToStr(kmi);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                kmi := StrToFloat(Param);
                Param := FloatToStr(kmf);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                kmf := StrToFloat(Param);
              end;
            DataModule10.Table6.InsertRecord([Subtrecho,kmi,kmf,-1,
              Campo[5],Campo[6],Campo[7],Campo[8],Campo[9],
              Campo[10],Campo[11],Campo[12],Campo[13],Campo[14],Campo[15],
              Campo[16],Campo[17],Campo[18],Campo[19],Campo[20],Campo[21],
              Campo[22],Campo[23],Campo[24],Campo[25],Campo[26],Campo[27],
              Campo[28],Campo[29],Campo[30],Campo[31],Campo[32],Campo[33],
              Campo[34],Campo[35],-1,-1,Campo[38],'Nenhuma']);
            DataModule10.Table2.Next;
          end;
        DataModule10.Table6.Close;
        DataModule10.Table6.Active := False;
      end;
  { SUP }
    NFields := 26;
    for icont := 1 to NFields do
      Campo[icont] := '';
    for IFaixa := 1 to NFaixasMax do
      begin
        ArqDbf := Dados + 'SUP_' + Rodovia[NRodov] + Faixa[IFaixa] + '_' + Year + '.dbf';
        with DataModule10.Table17 do
          begin
            Active := False;
            TableName := ArqDbf;
            CreateTable;
            Active := True;
            Edit;
            First;
          end;
        ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
        DataModule10.Table2.Active := False;
        DataModule10.Table2.TableName := ArqDbf;
        DataModule10.Table2.Active := True;
        while not DataModule10.Table2.Eof do
          begin
            Subtrecho := DataModule10.Table2.Fields.Fields[0].AsString;
            kmi := DataModule10.Table2.Fields.Fields[4].AsFloat;
            kmf := DataModule10.Table2.Fields.Fields[5].AsFloat;
            if ConfReg = 'Portuguese' then
              begin
                Param := FloatToStr(kmi);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                kmi := StrToFloat(Param);
                Param := FloatToStr(kmf);
                for jk := 1 to Length(Param) do
                  if Param[jk] = '.' then Param[jk] := ',';
                kmf := StrToFloat(Param);
              end;
            DataModule10.Table17.InsertRecord([Subtrecho,kmi,kmf,-1,
              Campo[5],Campo[6],Campo[7],Campo[8],Campo[9],
              Campo[10],Campo[11],Campo[12],Campo[13],Campo[14],Campo[15],
              Campo[16],Campo[17],Campo[18],Campo[19],Campo[20],Campo[21],
              Campo[22],-1,-1,Campo[25],'Nenhuma']);
            DataModule10.Table2.Next;
          end;
        DataModule10.Table17.Close;
        DataModule10.Table17.Active := False;
      end;
  { Histrico de Manuteno }
    NFields := 19;
    for icont := 1 to NFields do
      Campo[icont] := '0';
    ArqDbf := Dados + 'Cadas_' + Rodovia[NRodov] + '_' + Year + '.dbf';
    DataModule10.Table2.Active := False;
    DataModule10.Table2.TableName := ArqDbf;
    DataModule10.Table2.Active := True;
    while not DataModule10.Table2.Eof do
      begin
        isth := StrToInt(DataModule10.Table2.Fields.Fields[0].AsString);
              if isth < 10 then
                Codigo := '0000'
              else
                begin
                  if isth < 100 then
                    Codigo := '000'
                  else
                     begin
                      if isth < 1000 then
                        Codigo := '00'
                      else
                        begin
                          if isth < 10000 then
                            Codigo := '0'
                          else
                            Codigo := '';
                        end;
                    end;
                end;
        Codigo := Codigo + IntToStr(isth);
        ArqDbf := Dados + 'HistMan\HM_' + Codigo + '.dbf';
        with DataModule10.Table9 do
          begin
            Active := False;
            TableName := ArqDbf;
            CreateTable;
            Active := True;
            Edit;
            First;
          end;
        if ConfReg = 'Portuguese' then
          begin
            for j := 5 to 7 do
              begin
                for jk := 1 to Length(Campo[j]) do
                  if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              end;
            for j := 9 to 11 do
              begin
                for jk := 1 to Length(Campo[j]) do
                  if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              end;
            for j := 13 to 15 do
              begin
                for jk := 1 to Length(Campo[j]) do
                  if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              end;
            for j := 17 to 19 do
              begin
                for jk := 1 to Length(Campo[j]) do
                  if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              end;
          end;
        DataModule10.Table9.InsertRecord(['0','','','',StrToFloat(Campo[5]),
          StrToFloat(Campo[6]),StrToFloat(Campo[7]),'',StrToFloat(Campo[9]),StrToFloat(Campo[10]),
          StrToFloat(Campo[11]),'',StrToFloat(Campo[13]),StrToFloat(Campo[14]),
          StrToFloat(Campo[15]),'',StrToFloat(Campo[17]),StrToFloat(Campo[18]),StrToFloat(Campo[19])]);
        DataModule10.Table2.Next;
      end;
    DataModule10.Table9.Close;
    DataModule10.Table9.Active := False;
 end;
if RadioGroup1.ItemIndex > 0 then
 begin
 { Converte as planilhas Excel do FWD para *.csv }
   if RadioGroup1.ItemIndex = 1 then
     NomeTrecho := Rodovia[NRodov]
   else
     begin
       Arquivo := DadosAnoBase + 'Trechos.dat';
       AssignFile(ArqDados, Arquivo);
       Reset(ArqDados);
       Arquivo := DadosAnoBase + 'Trechos.dsc';
       AssignFile(ArqIn, Arquivo);
       Reset(ArqIn);
       while Eof(ArqDados) = False do
         begin
           Readln(ArqDados, Local);
           Readln(ArqIn, Nome);
           if ComboBox2.Text = Local then NomeTrecho := Nome;
         end;
       CloseFile(ArqDados);
       CloseFile(ArqIn);
    end;
 if CheckBox4.Checked then
  begin
    Label9.Caption := 'Convertendo os arquivos de deflexes ...';
    Label9.Refresh;
    Bloc := ',0,20,30,45,60,90,120,30,Out. 2012,FWD';
    Excel := CreateOleObject('Excel.Application');
    Excel.Visible := False;
    for IFaixa := 1 to NFaixasMax do
      begin
        NomeArq := 'FWD_Faixa ' + IntToStr(IFaixa);
        Arquivo := Dados + 'Temp\' + NomeTrecho + '\' + NomeArq + '.xls';
        if FileExists(Arquivo) then
          begin
            ArqCsv := Dados + 'Temp\FWD.csv';
            if FileExists(ArqCsv) then
              begin
                AssignFile(ArqOut, ArqCsv);
                Erase(ArqOut);
              end;
            FileCodeExcel := 1;
            Excel.Workbooks.Open(Arquivo, True, FileCodeExcel);
            Excel.Workbooks.Add;
            Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
            Excel.Workbooks[2].Sheets[1].PasteSpecial;
            FileCodeExcel := 6;
            Excel.Workbooks[2].Sheets[1].SaveAs(ArqCsv, FileCodeExcel);
            Excel.Workbooks[2].Saved := True;
            Excel.Workbooks.Close;
            Excel.Quit;
            { Altera o formato dos dados }
             Arquivo := DadosAnoBase + 'Deflex\' + NomeTrecho + '_' + IntToStr(IFaixa) + '.csv';
             AssignFile(ArqOut, Arquivo);
             Rewrite(ArqOut);
             LinhaArq := 'km,Carga_kgf,Df1,Df2,Df3,Df4,Df5,Df6,Df7,Tar,Tsup,R1,R2,R3,R4,R5,R6,R7,D placa,Data,Equipamento';
             Writeln(ArqOut, LinhaArq);
             AssignFile(ArqIn, ArqCsv);
             Reset(ArqIn);
             NFields := 11;
             for i := 1 to 8 do
               Readln(ArqIn, LinhaArq);
             while not Eof(ArqIn) do
               begin
                 Readln(ArqIn, LinhaArq);
                 j := 1;
                 for i := 1 to NFields do
                   Campo[i] := '';
                 icont := 0;
                 for i := 1 to Length(LinhaArq) do
                     begin
                       if j = 2 then
                         begin
                           if icont = 0 then
                             begin
                               if (LinhaArq[i] <> '"') and (LinhaArq[i] <> ',') then Campo[j] := Campo[j] + LinhaArq[i];
                               if LinhaArq[i] = ',' then icont := 1;
                             end
                           else
                             begin
                               if LinhaArq[i] = ',' then
                                 j := j + 1
                               else
                                 if LinhaArq[i] <> '"' then Campo[j] := Campo[j] + LinhaArq[i];
                             end;
                         end
                       else
                         if LinhaArq[i] = ',' then
                           j := j + 1
                         else
                           Campo[j] := Campo[j] + LinhaArq[i];
                     end;
                   km := '';
                   for i := 1 to Length(Campo[1]) do
                   begin
                     if Campo[1,i] <> ' ' then
                       if Campo[1,i] <> '+' then km := km + Campo[1,i] else km := km + '.';
                   end;
                   Carga := Campo[2];
                   for i := 1 to 7 do
                     Df[i] := Campo[2+i];
                   Tar := Campo[10];
                   Tsup := Campo[11];
                  if (Carga[1] = '3') or (Carga[1] = '4') or (Carga[1] = '5') then
                    begin
                      LinhaArq := km + ',' + Carga + ',' + Df[1]+ ',' + Df[2]+ ',' + Df[3]+ ',' + Df[4]+ ',' + Df[5]+ ',' + Df[6]+ ',' + Df[7] + ',' + Tar + ',' + Tsup;
                      LinhaArq := LinhaArq + Bloc;
                      Writeln(ArqOut, LinhaArq);
                    end;
               end;
             CloseFile(ArqIn);
             CloseFile(ArqOut);
          end;
      end;
  end;
 if CheckBox2.Checked then
  begin
    Label9.Caption := 'Convertendo os arquivos de QI ...';
    Label9.Refresh;
    Bloc := ',Out. 2012,Laser';
    Excel := CreateOleObject('Excel.Application');
    Excel.Visible := False;
    for IFaixa := 1 to NFaixasMax do
      begin
        icont := 0;
        NomeArq := 'QI_Faixa ' + IntToStr(IFaixa);
        Arquivo := Dados + 'Temp\' + NomeTrecho + '\' + NomeArq + '.xls';
        if FileExists(Arquivo) then
          begin
            ArqCsv := Dados + 'Temp\IRI.csv';
            if FileExists(ArqCsv) then
              begin
                AssignFile(ArqOut, ArqCsv);
                Erase(ArqOut);
              end;
            FileCodeExcel := 1;
            Excel.Workbooks.Open(Arquivo, True, FileCodeExcel);
            Excel.Workbooks.Add;
            Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
            Excel.Workbooks[2].Sheets[1].PasteSpecial;
            FileCodeExcel := 6;
            Excel.Workbooks[2].Sheets[1].SaveAs(ArqCsv, FileCodeExcel);
            Excel.Workbooks[2].Saved := True;
            Excel.Workbooks.Close;
            Excel.Quit;
            { Grava em matriz os valores }
             AssignFile(ArqIn, ArqCsv);
             Reset(ArqIn);
             NFields := 10;
             for i := 1 to 17 do
               Readln(ArqIn, LinhaArq);
             while not Eof(ArqIn) do
               begin
                 Readln(ArqIn, LinhaArq);
                 j := 1;
                 for i := 1 to NFields do
                   Campo[i] := '';
                 for i := 1 to Length(LinhaArq) do
                   if LinhaArq[i] = ',' then
                     j := j + 1
                   else
                     Campo[j] := Campo[j] + LinhaArq[i];
                 if Campo[9] <> '' then
                   begin
                     icont := icont + 1;
                     if (Campo[9] <> '') and (Campo[9] <> ' ') and (Campo[9] <> '-') then
                       QIFx[IFaixa,icont] := StrToFloat(Campo[9])
                     else
                       QIFx[IFaixa,icont] := -1;
                     kmiFx[IFaixa,icont] := StrToFloat(Campo[2]);
                     kmfFx[IFaixa,icont] := StrToFloat(Campo[3]);
                   end;
               end;
             CloseFile(ArqIn);
             if IFaixa = 1 then icont1 := icont;
             if IFaixa = 2 then NLinhas := icont;
          end;
      end;
    if kmfFx[2,NLinhas] > kmiFx[2,1] then SentidoFx2 := 'Crescente' else SentidoFx2 := 'Decrescente';
    Trocou := True;
    while Trocou do
      begin
        Trocou := False;
        for i := 1 to icont1-1 do
          begin
            j := i+1;
            kmP := (kmiFx[1,i]+kmfFx[1,i])/2;
            kmP2 := (kmiFx[1,j]+kmfFx[1,j])/2;
            if SentidoFx2 = 'Crescente' then
              begin
                if kmP > kmP2 then
                  begin
                    Trocou := True;
                    QI := QIFx[1,i];
                    QIFx[1,i] := QIFx[1,j];
                    QIFx[1,j] := QI;
                    kmP := kmiFx[1,i];
                    kmiFx[1,i] := kmiFx[1,j];
                    kmiFx[1,j] := kmP;
                    kmP2 := kmfFx[1,i];
                    kmfFx[1,i] := kmfFx[1,j];
                    kmfFx[1,j] := kmP2;
                  end;
              end
            else
              begin
                if kmP < kmP2 then
                  begin
                    Trocou := True;
                    QI := QIFx[1,i];
                    QIFx[1,i] := QIFx[1,j];
                    QIFx[1,j] := QI;
                    kmP := kmiFx[1,i];
                    kmiFx[1,i] := kmiFx[1,j];
                    kmiFx[1,j] := kmP;
                    kmP2 := kmfFx[1,i];
                    kmfFx[1,i] := kmfFx[1,j];
                    kmfFx[1,j] := kmP2;
                  end;
              end;
          end;
      end;
    Arquivo := DadosAnoBase + 'QI\' + NomeTrecho + '.csv';
    AssignFile(ArqOut, Arquivo);
    Rewrite(ArqOut);
    LinhaArq := 'kmi,kmf,QI_Fx1,QI_Fx2,QI_Fx3,QI_Fx4,Data,Equipamento';
    Writeln(ArqOut, LinhaArq);
    for i := 1 to NLinhas do
      Writeln(ArqOut, FloatToStr(kmiFx[2,i]) + ',' + FloatToStr(kmfFx[2,i]) + ',' + FloatToStr(QIFx[1,i]) + ',' + FloatToStr(QIFx[2,i]) + ',-1,-1' + Bloc);
    CloseFile(ArqOut);
  end;
 if CheckBox3.Checked then
  begin
    Label9.Caption := 'Convertendo os arquivos de ATR ...';
    Label9.Refresh;
    Bloc := ',Out. 2012,Laser';
    Excel := CreateOleObject('Excel.Application');
    Excel.Visible := False;
    for IFaixa := 1 to NFaixasMax do
      begin
        icont := 0;
        NomeArq := 'ATR_Faixa ' + IntToStr(IFaixa);
        Arquivo := Dados + 'Temp\' + NomeTrecho + '\' + NomeArq + '.xls';
        if FileExists(Arquivo) then
          begin
            ArqCsv := Dados + 'Temp\RD.csv';
            if FileExists(ArqCsv) then
              begin
                AssignFile(ArqOut, ArqCsv);
                Erase(ArqOut);
              end;
            FileCodeExcel := 1;
            Excel.Workbooks.Open(Arquivo, True, FileCodeExcel);
            Excel.Workbooks.Add;
            Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
            Excel.Workbooks[2].Sheets[1].PasteSpecial;
            FileCodeExcel := 6;
            Excel.Workbooks[2].Sheets[1].SaveAs(ArqCsv, FileCodeExcel);
            Excel.Workbooks[2].Saved := True;
            Excel.Workbooks.Close;
            Excel.Quit;
            { Grava em matriz os valores }
             AssignFile(ArqIn, ArqCsv);
             Reset(ArqIn);
             NFields := 6;
             for i := 1 to 20 do
               Readln(ArqIn, LinhaArq);
             while not Eof(ArqIn) do
               begin
                 Readln(ArqIn, LinhaArq);
                 j := 1;
                 for i := 1 to NFields do
                   Campo[i] := '';
                 for i := 1 to Length(LinhaArq) do
                   if LinhaArq[i] = ',' then
                     j := j + 1
                   else
                     Campo[j] := Campo[j] + LinhaArq[i];
                 if Campo[4] <> '' then
                   begin
                     icont := icont + 1;
                     if (Campo[4] <> '') and (Campo[4] <> ' ') and (Campo[4] <> '-') then
                       ATResqFx[IFaixa,icont] := StrToFloat(Campo[4])
                     else
                       ATResqFx[IFaixa,icont] := -1;
                     if (Campo[5] <> '') and (Campo[5] <> ' ') and (Campo[5] <> '-') then
                       ATRdirFx[IFaixa,icont] := StrToFloat(Campo[5])
                     else
                       ATRdirFx[IFaixa,icont] := -1;
                     kmiFx[IFaixa,icont] := StrToFloat(Campo[2]);
                     kmfFx[IFaixa,icont] := StrToFloat(Campo[3]);
                   end;
               end;
             CloseFile(ArqIn);
             if IFaixa = 1 then icont1 := icont;
             if IFaixa = 2 then NLinhas := icont;
          end;
      end;
    if kmfFx[2,NLinhas] > kmiFx[2,1] then SentidoFx2 := 'Crescente' else SentidoFx2 := 'Decrescente';
    Trocou := True;
    while Trocou do
      begin
        Trocou := False;
        for i := 1 to icont1-1 do
          begin
            j := i+1;
            kmP := (kmiFx[1,i]+kmfFx[1,i])/2;
            kmP2 := (kmiFx[1,j]+kmfFx[1,j])/2;
            if SentidoFx2 = 'Crescente' then
              begin
                if kmP > kmP2 then
                  begin
                    Trocou := True;
                    QI := ATResqFx[1,i];
                    ATResqFx[1,i] := ATResqFx[1,j];
                    ATResqFx[1,j] := QI;
                    QI := ATRdirFx[1,i];
                    ATRdirFx[1,i] := ATRdirFx[1,j];
                    ATRdirFx[1,j] := QI;
                    kmP := kmiFx[1,i];
                    kmiFx[1,i] := kmiFx[1,j];
                    kmiFx[1,j] := kmP;
                    kmP2 := kmfFx[1,i];
                    kmfFx[1,i] := kmfFx[1,j];
                    kmfFx[1,j] := kmP2;
                  end;
              end
            else
              begin
                if kmP < kmP2 then
                  begin
                    Trocou := True;
                    QI := ATResqFx[1,i];
                    ATResqFx[1,i] := ATResqFx[1,j];
                    ATResqFx[1,j] := QI;
                    QI := ATRdirFx[1,i];
                    ATRdirFx[1,i] := ATRdirFx[1,j];
                    ATRdirFx[1,j] := QI;
                    kmP := kmiFx[1,i];
                    kmiFx[1,i] := kmiFx[1,j];
                    kmiFx[1,j] := kmP;
                    kmP2 := kmfFx[1,i];
                    kmfFx[1,i] := kmfFx[1,j];
                    kmfFx[1,j] := kmP2;
                  end;
              end;
          end;
      end;
    Arquivo := DadosAnoBase + 'ATR\' + NomeTrecho + '.csv';
    AssignFile(ArqOut, Arquivo);
    Rewrite(ArqOut);
    LinhaArq := 'km,ATResqFx1,ATRdirFx1,ATResqFx2,ATRdirFx2,ATResqFx3,ATRdirFx3,ATResqFx4,ATRdirFx4,Data,Equipamento';
    Writeln(ArqOut, LinhaArq);
    for i := 1 to NLinhas do
      begin
        kmP := (kmiFx[2,i]+kmfFx[2,i])/2;
        Writeln(ArqOut, FloatToStr(kmP) + ',' + FloatToStr(ATResqFx[1,i]) + ',' + FloatToStr(ATRdirFx[1,i]) + ',' + FloatToStr(ATResqFx[2,i]) + ',' + FloatToStr(ATRdirFx[2,i]) + ',-1,-1,-1,-1' + Bloc);
      end;
    CloseFile(ArqOut);
  end;
 end;
 Label9.Caption := '';
 Label9.Refresh;
 Screen.Cursor := crDefault;
end;

procedure TForm50.RadioGroup1Click(Sender: TObject);
var
  Arquivo, Programa, Dados, Calc, DadosAnoBase: string;
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
begin
 { Ano-base e subdiretrios }
   AssignFile(ArqDados, 'Diretor.dat');
   Reset(ArqDados);
   Readln(ArqDados, Ano);
   Readln(ArqDados, NPeriodos);
   Readln(ArqDados, Programa);
   Readln(ArqDados, Dados);
   Readln(ArqDados, Calc);
   Readln(ArqDados, DadosAnoBase);
   CloseFile(ArqDados);
  case RadioGroup1.ItemIndex of
     0: GroupBox1.Visible := False;
     1: GroupBox1.Visible := True;
     2:
       begin
         GroupBox1.Visible := True;
         Label5.Caption := 'Trecho:';
         ComboBox2.Items.LoadFromFile(DadosAnoBase + 'Trechos.dat');
         ComboBox2.Visible := True;
       end;
  end;
end;

initialization
  CoInitialize (nil);

end.
