unit Unit5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Db, Grids, DBGrids, DBTables, DBCtrls, Menus;

type
  TForm5 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Label1: TLabel;
    ComboBox1: TComboBox;
    DBNavigator1: TDBNavigator;
    Label3: TLabel;
    ComboBox3: TComboBox;
    Label2: TLabel;
    Memo1: TMemo;
    MainMenu1: TMainMenu;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Coluna1: TMenuItem;
    Clula1: TMenuItem;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure AvaliaoEstrutural1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Coluna1Click(Sender: TObject);
    procedure Clula1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure DBGrid1CellClick(Column: TColumn);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form5: TForm5;

implementation

{$R *.DFM}

uses Childwin, Unit10;

procedure TForm5.BitBtn1Click(Sender: TObject);
begin
  if CheckBox1.Checked = True then
    begin
      DataSource1.Edit;
      DataModule10.Table3.Post;
      DataModule10.Table3.Active := False;
    end;
  if CheckBox2.Checked = True then
    begin
      DataSource1.Edit;
      DataModule10.Table12.Post;
      DataModule10.Table12.Active := False;
    end;
  Close;
end;

procedure TForm5.AvaliaoEstrutural1Click(Sender: TObject);
begin
  MDIChild.AvaliaoEstrutural1Click(Sender);
end;

procedure TForm5.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Atualiza: string[3];
begin
  Label4.Visible := False;
  Label5.Visible := False;
  Label6.Visible := False;
  Memo1.Text := '';
  DataModule10.Table3.Active := False;
  DataModule10.Table12.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
  AssignFile(ArqDados, 'Acesso.dat');
  Reset(ArqDados);
  Readln(ArqDados, Atualiza);
  CloseFile(ArqDados);
  if Atualiza = 'Sim' then
    DBGrid1.ReadOnly := False
  else
    DBGrid1.ReadOnly := True;
end;

procedure TForm5.ComboBox3Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome: string[4];
  ArqDados, Arq: TextFile;
  Faixa: string[1];
begin
if ComboBox3.Text <> '' then
 begin
  Label5.Visible := False;
  Label6.Visible := False;
  Faixa := ComboBox3.Text;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox1.Text = Local then Trecho := Nome;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  if ComboBox1.Text <> '' then
    begin
      if CheckBox1.Checked = True then
        begin
          DataSource1.DataSet := DataModule10.Table3;
          DataModule10.Table3.Active := False;
          DataModule10.Table3.TableName := Dados + 'DFX_' + Trecho + Faixa + '_' + Year + '.dbf';
          DataModule10.Table3.Active := True;
          Label4.Caption := Trecho;
          Label4.Visible := True;
        end;
      if CheckBox2.Checked = True then
        begin
          DataSource1.DataSet := DataModule10.Table12;
          DataModule10.Table12.Active := False;
          DataModule10.Table12.TableName := Dados + 'MOD_' + Trecho + Faixa + '_' + Year + '.dbf';
          DataModule10.Table12.Active := True;
          Label4.Caption := Trecho;
          Label4.Visible := True;
        end;
    end;
 end
else
 Label4.Visible := False;
end;

procedure TForm5.Cut1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid1.SelectedField.AsString;
  DataSource1.Edit;
  DBGrid1.SelectedField.Clear;
  DataModule10.Table3.Post;
end;

procedure TForm5.Copy1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid1.SelectedField.AsString;
end;

procedure TForm5.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome: string[4];
  ArqDados, Arq: TextFile;
  Faixa: string[1];
begin
 if ComboBox1.Text <> '' then
  begin
   AssignFile(ArqDados, 'Diretor.dat');
   Reset(ArqDados);
   Readln(ArqDados, Ano);
   Readln(ArqDados, NPeriodos);
   Readln(ArqDados, Programa);
   Readln(ArqDados, Dados);
   Readln(ArqDados, Calc);
   Readln(ArqDados, DadosAnoBase);
   CloseFile(ArqDados);
   Year := IntToStr(Ano);
   Arquivo := DadosAnoBase + 'Trechos.dat';
   AssignFile(ArqDados, Arquivo);
   Reset(ArqDados);
   Arquivo := DadosAnoBase + 'Trechos.dsc';
   AssignFile(Arq, Arquivo);
   Reset(Arq);
   while Eof(ArqDados) = False do
     begin
       Readln(ArqDados, Local);
       Readln(Arq, Nome);
       if ComboBox1.Text = Local then Trecho := Nome;
     end;
   CloseFile(ArqDados);
   CloseFile(Arq);
   Label4.Caption := Trecho;
   Label4.Visible := True;
  end
 else
  Label4.Visible := False;
 ComboBox3.Text := '';
 Label5.Visible := False;
 Label6.Visible := False;
end;

procedure TForm5.Coluna1Click(Sender: TObject);
var
  i: SmallInt;
begin
  i := DBGrid1.SelectedField.Index;
  if CheckBox1.Checked = True then
   begin
    with DataModule10.Table3 do
      begin
        First;
        while not EOF do
          begin
            DataSource1.Edit;
            DBGrid1.Fields[i].AsString := Memo1.Text;
            Next;
          end;
        DataSource1.Edit;
        Post;
      end;
   end
  else
   begin
    with DataModule10.Table12 do
      begin
        First;
        while not EOF do
          begin
            DataSource1.Edit;
            DBGrid1.Fields[i].AsString := Memo1.Text;
            Next;
          end;
        DataSource1.Edit;
        Post;
      end;
   end;
end;

procedure TForm5.Clula1Click(Sender: TObject);
begin
  DataSource1.Edit;
  DBGrid1.SelectedField.AsString := Memo1.Text;
  if CheckBox1.Checked = True then
    DataModule10.Table3.Post
  else
    DataModule10.Table12.Post;
end;

procedure TForm5.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked = True then CheckBox2.Checked := False;
  if CheckBox1.Checked = False then CheckBox2.Checked := True;
  ComboBox3.Text := '';
end;

procedure TForm5.CheckBox2Click(Sender: TObject);
begin
  if CheckBox2.Checked = True then CheckBox1.Checked := False;
  if CheckBox2.Checked = False then CheckBox1.Checked := True;
  ComboBox3.Text := '';
end;

procedure TForm5.DBGrid1CellClick(Column: TColumn);
var
  Ano, NPeriodos, icont, NFields, i, j: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase, Local, Linha, Subtrecho,
    STH, kmi, kmf, SubSTH: string;
  Trecho, Nome: string[4];
  Coluna: SmallInt;
  Campo: array [1..50] of string[30];
begin
  Coluna := DBGrid1.SelectedField.Index;
  if Coluna = 0 then
    begin
      Label5.Visible := False;
      Label6.Visible := False;
      Subtrecho := DBGrid1.SelectedField.AsString;
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      Arquivo := DadosAnoBase + 'Trechos.dat';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Arquivo := DadosAnoBase + 'Trechos.dsc';
      AssignFile(Arq, Arquivo);
      Reset(Arq);
      while Eof(ArqDados) = False do
        begin
          Readln(ArqDados, Local);
          Readln(Arq, Nome);
          if ComboBox1.Text = Local then Trecho := Nome;
        end;
      CloseFile(ArqDados);
      CloseFile(Arq);
      Arquivo := Calc + 'Cadas' + Trecho + '.csv';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      icont := 0;
      NFields := 25;
      while not Eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          icont := icont + 1;
          j := 1;
          for i := 1 to NFields do
            Campo[i] := '';
          for i := 1 to Length(Linha) do
            begin
              if Linha[i] = ',' then
                j := j + 1
              else
               Campo[j] := Campo[j] + Linha[i];
            end;
          SubSTH := '';
          for i := 1 to Length(Campo[1]) do
            if Campo[1,i] <> '"' then SubSTH := SubSTH + Campo[1,i];
          if Subtrecho = SubSTH then
            begin
              STH := Campo[1];
              kmi := Campo[5];
              kmf := Campo[6];
            end;
        end;
      CloseFile(ArqDados);
      Label5.Caption := 'Subtrecho ==> Incio: km ' + kmi;
      Label5.Visible := True;
      Label6.Caption := 'Final: km ' + kmf;
      Label6.Visible := True;
    end;
end;

end.
