unit Unit49;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, DBCtrls, Mask, Db;

type
  TForm49 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn2: TBitBtn;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    ComboBox2: TComboBox;
    Label3: TLabel;
    Label4: TLabel;
    ComboBox3: TComboBox;
    ComboBox4: TComboBox;
    Panel3: TPanel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    ComboBox5: TComboBox;
    Label14: TLabel;
    BitBtn3: TBitBtn;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Label19: TLabel;
    ComboBox1: TComboBox;
    GroupBox4: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    Label20: TLabel;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    Label21: TLabel;
    Label22: TLabel;
    BitBtn1: TBitBtn;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    Button1: TButton;
    Label23: TLabel;
    Label24: TLabel;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    BitBtn8: TBitBtn;
    Label25: TLabel;
    procedure ConversodeDadosparaSubtrecho1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form49: TForm49;

implementation

uses Childwin, Unit10, ComObj, ActiveX, Unit94;

{$R *.DFM}

procedure TForm49.ConversodeDadosparaSubtrecho1Click(Sender: TObject);
begin
  MDIChild.ConversodeDadosparaSubtrecho1Click(Sender);
end;

procedure TForm49.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm49.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  Label25.Caption := '';
  Label20.Caption := '';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox2.Items.LoadFromFile(Arquivo);
  GroupBox4.Visible := False;
  Label7.Caption := '';
  Label8.Caption := '';
  Label10.Caption := '';
  Label11.Caption := '';
  Label12.Caption := '';
  Label13.Caption := '';
  Label14.Caption := '';
  ComboBox5.Visible := False;
  BitBtn3.Visible := False;
  GroupBox3.Visible := False;
  Label19.Caption := '';
  ComboBox1.Visible := False;
end;

procedure TForm49.BitBtn1Click(Sender: TObject);
var
  Trecho, Nome: string[4];
  Ano, NPeriodos, DOS, i, FileCodeExcel, j, Ifaixa, NFields, icont, jk: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, Parametro, DadosAnoBase, ConfReg, Linha: string;
  Excel: OleVariant;
  ArqDbf, ArqCsv: array [1..4] of string;
  Path, Local, Polo: string;
  Year: string[4];
  Faixa: string[1];
  source, destination: file;
  buffer: array [1..1024] of byte;
  readcnt, writecnt, NCasos: integer;
  scrname, destname: string;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Executa: Boolean;
  Faixas, JFaixa: array [1..4] of integer;
  Campo: array [1..100] of string;
begin
 Executa := True;
 if ComboBox2.Text = '' then Executa := False;
 if ComboBox4.Text = '' then Executa := False;
 if ComboBox3.Text = '' then Executa := False;
 if ComboBox3.Text = 'Deflexes' then
  begin
    if ComboBox5.Text = '' then Executa := False;
    if ComboBox1.Text = '' then Executa := False;
  end;
if ComboBox3.Text = 'Mdulos de Elasticidade das Camadas' then
  if ComboBox5.Text = '' then Executa := False;
if ComboBox3.Text = 'IGG' then
  begin
    i := 0;
    if CheckBox1.Checked = True then i := i + 1;
    if CheckBox2.Checked = True then i := i + 1;
    if CheckBox3.Checked = True then i := i + 1;
    if CheckBox4.Checked = True then i := i + 1;
    if i = 0 then Executa := False;
  end;
if ComboBox3.Text = 'LVD' then
  if ComboBox5.Text = '' then Executa := False;
if Executa then
 begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  for i := 1 to 4 do
    Faixas[i] := 0;
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox2.Text = Local then Trecho := Nome;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  Ifaixa := 0;
  if ComboBox3.Text = 'Afundamentos em Trilha de Roda' then
    begin
      Parametro := 'ATR';
      DataModule10.Table10.Active := False;
      ArqCsv[1] := Calc + 'ATR' + Trecho + '.csv';
      ArqDbf[1] := Dados + 'ATR_' + Trecho + '_' + Year + '.dbf';
      NCasos := 1;
    end;
  if ComboBox3.Text = 'Irregularidade Longitudinal' then
    begin
      Parametro := 'QI';
      DataModule10.Table5.Active := False;
      ArqCsv[1] := Calc + 'FUNC' + Trecho + '.csv';
      ArqDbf[1] := Dados + 'FUNC_' + Trecho + '_' + Year + '.dbf';
      NCasos := 1;
    end;
  if ComboBox3.Text = 'Deflexes' then
    begin
      Faixa := ComboBox5.Text;
      Ifaixa := StrToInt(Faixa);
      Parametro := 'DEFLEX';
      DataModule10.Table3.Active := False;
      ArqCsv[1] := Calc + 'DFX' + Trecho + Faixa + '.csv';
      ArqDbf[1] := Dados + 'DFX_' + Trecho + Faixa + '_' + Year + '.dbf';
      NCasos := 1;
      Arquivo := Calc + 'Unidade.dat';
      AssignFile(ArqDados, Arquivo);
      Rewrite(ArqDados);
      Writeln(ArqDados, ComboBox1.Text);
      CloseFile(ArqDados);
    end;
  if ComboBox3.Text = 'Mdulos de Elasticidade das Camadas' then
    begin
      Faixa := ComboBox5.Text;
      Ifaixa := StrToInt(Faixa);
      Parametro := 'MODULOS';
      DataModule10.Table12.Active := False;
      ArqCsv[1] := Calc + 'MOD' + Trecho + Faixa + '.csv';
      ArqDbf[1] := Dados + 'MOD_' + Trecho + Faixa + '_' + Year + '.dbf';
      NCasos := 1;
    end;
  if ComboBox3.Text = 'IGG' then
    begin
      Parametro := 'IGG';
      DataModule10.Table6.Active := False;
      Arquivo := Dados + 'Temp\' + 'Faixas.dat';
      AssignFile(ArqDados, Arquivo);
      Rewrite(ArqDados);
      if CheckBox1.Checked = True then Faixas[1] := 1 else Faixas[1] := 0;
      if CheckBox2.Checked = True then Faixas[2] := 1 else Faixas[2] := 0;
      if CheckBox3.Checked = True then Faixas[3] := 1 else Faixas[3] := 0;
      if CheckBox4.Checked = True then Faixas[4] := 1 else Faixas[4] := 0;
      NCasos := 0;
      for i := 1 to 4 do
        begin
          if Faixas[i] = 1 then
            begin
              Writeln(ArqDados, i);
              Ifaixa := i;
              NCasos := NCasos + 1;
              Faixa := IntToStr(i);
              JFaixa[NCasos] := i;
              ArqCsv[NCasos] := Calc + 'LVC' + Trecho + Faixa + '.CSV';
              ArqDbf[NCasos] := Dados + 'LVC_' + Trecho + Faixa + '_' + Year + '.dbf';
            end;
        end;
      CloseFile(ArqDados);
    end;
  if ComboBox3.Text = 'LVD' then
    begin
      Faixa := ComboBox5.Text;
      Ifaixa := StrToInt(Faixa);
      NCasos := 1;
      Parametro := 'LVD';
      DataModule10.Table14.Active := False;
      ArqCsv[NCasos] := Calc + 'SUP' + Trecho + Faixa + '.CSV';
      ArqDbf[NCasos] := Dados + 'SUP_' + Trecho + Faixa + '_' + Year + '.dbf';
    end;
  Arquivo := Calc + 'Medias.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Parametro);
  Writeln(ArqDados, Trecho);
  Writeln(ArqDados, ComboBox4.Text);
  Writeln(ArqDados, Ifaixa);
  CloseFile(ArqDados);
  { Executa o programa que calcula os parmetros mdios
    por Subtrecho Homogneo }
    Arquivo := 'DOS.DAT';
    if FileExists(Arquivo) then
      begin
        AssignFile(ArqDados, Arquivo);
        Erase(ArqDados)
      end;
    if ComboBox3.Text = 'IGG' then
      WinExec('IGG.exe /c', SW_HIDE)
    else
      WinExec('Medias.exe /c', SW_HIDE);
    Flag := 0;
    StartTime := now;
    NumSec := 3;
    repeat
      Application.ProcessMessages;
      if FileExists(Arquivo) then Flag := 1;
    until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  for i := 1 to NCasos do
    begin
      Arquivo := Dados + 'Temp\' + 'Caso.dat';
      AssignFile(ArqDados, Arquivo);
      Rewrite(ArqDados);
      Writeln(ArqDados, JFaixa[i]);
      Writeln(ArqDados, ArqCsv[i]);
      CloseFile(ArqDados);
      scrname := ArqCsv[i];
      destname := Dados + 'Temp\' + 'Temp.CSV';
      AssignFile(source, scrname);
      Try
         Reset(source, 1);
      Except
         Exit;
      end;
      AssignFile(destination, destname);
      Try
         Rewrite(destination, 1);
      Except
         Exit;
      end;
      Repeat
        BlockRead(source, buffer, sizeof(buffer), readcnt);
        Try
          BlockWrite(destination, buffer, readcnt, writecnt);
        Except
          Exit;
        end;
      until (readcnt=0) or (writecnt<>readcnt);
      CloseFile(destination);
      CloseFile(source);
      Arquivo := 'FLAG.DAT';
      if FileExists(Arquivo) then
        begin
          AssignFile(ArqDados, Arquivo);
          Erase(ArqDados)
        end;
      WinExec('Atualiza.exe /c', SW_HIDE);
      Flag := 0;
      StartTime := now;
      NumSec := 3;
      repeat
        Application.ProcessMessages;
        if FileExists(Arquivo) then Flag := 1;
       until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
    end;
  { Converte de CSV para DBF }
    for i := 1 to NCasos do
      begin
        if ArqDbf[i] = Dados + 'FUNC_' + Trecho + '_' + Year + '.dbf' then
          begin
            NFields := 7;
            AssignFile(Arq, ArqCsv[i]);
            Reset(Arq);
            Readln(Arq, Linha);
            with DataModule10.Table5 do
              begin
                Active := False;
                TableName := ArqDbf[i];
                CreateTable;
                Active := True;
                Edit;
                First;
              end;
            while not eof(Arq) do
              begin
                Readln(Arq, Linha);
                j := 1;
                for icont := 1 to NFields do
                  Campo[icont] := '';
                for icont := 1 to Length(Linha) do
                  begin
                    if Linha[icont] = ',' then
                      j := j + 1
                    else
                      if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
                  end;
                if ConfReg = 'Portuguese' then
                  begin
                    for j := 2 to 5 do
                      begin
                        for jk := 1 to Length(Campo[j]) do
                          if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                      end;
                  end;
                DataModule10.Table5.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                  StrToFloat(Campo[4]),StrToFloat(Campo[5]),Campo[6],Campo[7]]);
              end;
            DataModule10.Table5.Close;
            DataModule10.Table5.Active := False;
            CloseFile(Arq);
          end
        else
          if ArqDbf[i] = Dados + 'ATR_' + Trecho + '_' + Year + '.dbf' then
            begin
              NFields := 19;
              AssignFile(Arq, ArqCsv[i]);
              Reset(Arq);
              Readln(Arq, Linha);
              with DataModule10.Table10 do
                begin
                  Active := False;
                  TableName := ArqDbf[i];
                  CreateTable;
                  Active := True;
                  Edit;
                  First;
                end;
              while not eof(Arq) do
                begin
                  Readln(Arq, Linha);
                  j := 1;
                  for icont := 1 to NFields do
                    Campo[icont] := '';
                  for icont := 1 to Length(Linha) do
                    begin
                      if Linha[icont] = ',' then
                        j := j + 1
                      else
                        if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
                    end;
                  if ConfReg = 'Portuguese' then
                    begin
                      for j := 2 to 9 do
                        begin
                          for jk := 1 to Length(Campo[j]) do
                            if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                        end;
                      for j := 12 to 19 do
                        begin
                          for jk := 1 to Length(Campo[j]) do
                            if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                        end;
                    end;
                  DataModule10.Table10.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                    StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),StrToFloat(Campo[7]),
                    StrToFloat(Campo[8]),StrToFloat(Campo[9]),Campo[10],Campo[11],StrToFloat(Campo[12]),
                    StrToFloat(Campo[13]),StrToFloat(Campo[14]),StrToFloat(Campo[15]),StrToFloat(Campo[16]),
                    StrToFloat(Campo[17]),StrToFloat(Campo[18]),StrToFloat(Campo[19])]);
                end;
              DataModule10.Table10.Close;
              DataModule10.Table10.Active := False;
              CloseFile(Arq);
            end
          else
            if ArqDbf[i] = Dados + 'DFX_' + Trecho + Faixa + '_' + Year + '.dbf' then
              begin
                NFields := 22;
                AssignFile(Arq, ArqCsv[i]);
                Reset(Arq);
                Readln(Arq, Linha);
                with DataModule10.Table3 do
                  begin
                    Active := False;
                    TableName := ArqDbf[i];
                    CreateTable;
                    Active := True;
                    Edit;
                    First;
                  end;
                while not eof(Arq) do
                  begin
                    Readln(Arq, Linha);
                    j := 1;
                    for icont := 1 to NFields do
                      Campo[icont] := '';
                    for icont := 1 to Length(Linha) do
                      begin
                        if Linha[icont] = ',' then
                          j := j + 1
                        else
                          if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
                      end;
                    if ConfReg = 'Portuguese' then
                      begin
                        for j := 2 to 20 do
                          begin
                            for jk := 1 to Length(Campo[j]) do
                              if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                          end;
                      end;
                    DataModule10.Table3.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                      StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),StrToFloat(Campo[7]),
                      StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),StrToFloat(Campo[11]),
                      StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),StrToFloat(Campo[15]),
                      StrToFloat(Campo[16]),StrToFloat(Campo[17]),StrToFloat(Campo[18]),StrToFloat(Campo[19]),
                      StrToFloat(Campo[20]),Campo[21],Campo[22]]);
                  end;
                  DataModule10.Table3.Close;
                  DataModule10.Table3.Active := False;
                  CloseFile(Arq);
              end
            else
              if ArqDbf[i] = Dados + 'MOD_' + Trecho + Faixa + '_' + Year + '.dbf' then
                begin
                  NFields := 17;
                  AssignFile(Arq, ArqCsv[i]);
                  Reset(Arq);
                  Readln(Arq, Linha);
                  with DataModule10.Table12 do
                    begin
                      Active := False;
                      TableName := ArqDbf[i];
                      CreateTable;
                      Active := True;
                      Edit;
                      First;
                    end;
                  while not eof(Arq) do
                    begin
                      Readln(Arq, Linha);
                      j := 1;
                      for icont := 1 to NFields do
                        Campo[icont] := '';
                      for icont := 1 to Length(Linha) do
                        begin
                          if Linha[icont] = ',' then
                            j := j + 1
                          else
                            if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
                        end;
                      if ConfReg = 'Portuguese' then
                        begin
                          for j := 2 to 15 do
                            begin
                              for jk := 1 to Length(Campo[j]) do
                                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                            end;
                        end;
                      DataModule10.Table12.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                        StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),StrToFloat(Campo[7]),
                        StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),StrToFloat(Campo[11]),
                        StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),StrToFloat(Campo[15]),
                        Campo[16],Campo[17]]);
                    end;
                  DataModule10.Table12.Close;
                  DataModule10.Table12.Active := False;
                  CloseFile(Arq);
                end
              else
                if ArqDbf[i] = Dados + 'LVC_' + Trecho + Faixa + '_' + Year + '.dbf' then
                  begin
                    NFields := 39;
                    AssignFile(Arq, ArqCsv[i]);
                    Reset(Arq);
                    Readln(Arq, Linha);
                    with DataModule10.Table6 do
                      begin
                        Active := False;
                        TableName := ArqDbf[i];
                        CreateTable;
                        Active := True;
                        Edit;
                        First;
                      end;
                    while not eof(Arq) do
                      begin
                        Readln(Arq, Linha);
                        j := 1;
                        for icont := 1 to NFields do
                          Campo[icont] := '';
                        for icont := 1 to Length(Linha) do
                          begin
                            if Linha[icont] = ',' then
                              j := j + 1
                            else
                              if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
                          end;
                        if ConfReg = 'Portuguese' then
                          begin
                            for j := 2 to 4 do
                              begin
                                for jk := 1 to Length(Campo[j]) do
                                  if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                              end;
                            for j := 36 to 37 do
                              begin
                                for jk := 1 to Length(Campo[j]) do
                                  if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                              end;
                          end;
                        DataModule10.Table6.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                          StrToFloat(Campo[4]),Campo[5],Campo[6],Campo[7],Campo[8],Campo[9],Campo[10],Campo[11],
                          Campo[12],Campo[13],Campo[14],Campo[15],Campo[16],Campo[17],Campo[18],Campo[19],
                          Campo[20],Campo[21],Campo[22],Campo[23],Campo[24],Campo[25],Campo[26],Campo[27],
                          Campo[28],Campo[29],Campo[30],Campo[31],Campo[32],Campo[33],Campo[34],Campo[35],
                          StrToFloat(Campo[36]),StrToFloat(Campo[37]),Campo[38],Campo[39]]);
                      end;
                    DataModule10.Table6.Close;
                    DataModule10.Table6.Active := False;
                    CloseFile(Arq);
                  end;
      end;
  Screen.Cursor := crDefault;
  Close;
 end;
end;

procedure TForm49.ComboBox3Change(Sender: TObject);
var
  Trecho: string[4];
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, Nome, Path, DadosAnoBase: string;
begin
  GroupBox4.Visible := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  if ComboBox3.Text = 'Afundamentos em Trilha de Roda' then
    begin
      Nome := 'ATR.CSV';
      Label8.Caption := 'km, ATResq (Fx.1), ATRdir (Fx.1), ATResq (Fx.2), ATRdir (Fx.2), ATResq (Fx.3), ATRdir (Fx.3), ATResq (Fx.4), ATRdir (Fx.4), Data, Equip.';
      Label10.Caption := 'Atravs do comando: "Edit ATR.CSV" certifique-se de que o arquivo contm apenas as linhas necessrias.';
      Label11.Caption := 'Verifique tambm se no h campos em branco nas leituras de ATR.';
      Label13.Caption := '';
      Label14.Caption := 'A quilometragem em ATR.CSV deve estar de acordo com a do trecho.';
      ComboBox5.Visible := False;
      BitBtn3.Visible := False;
      GroupBox3.Visible := False;
      Label19.Caption := '';
      ComboBox1.Visible := False;
      Label12.Caption := 'O formato para o campo "Data" deve ser, por exemplo: "Mai. 2002".';
    end;
  if ComboBox3.Text = 'Irregularidade Longitudinal' then
    begin
      Nome := 'QI.CSV';
      Label8.Caption := 'kmi, kmf, QI (Faixa1), QI (Faixa2), QI (Faixa3), QI (Faixa4), Data, Equipamento';
      Label10.Caption := 'Atravs do comando: "Edit QI.CSV" certifique-se de que o arquivo contm apenas as linhas necessrias.';
      Label11.Caption := 'Verifique tambm se no h campos em branco nas leituras de QI.';
      Label13.Caption := '';
      Label14.Caption := 'A quilometragem em QI.CSV deve estar de acordo com a do trecho.';
      ComboBox5.Visible := False;
      BitBtn3.Visible := False;
      GroupBox3.Visible := False;
      Label19.Caption := '';
      ComboBox1.Visible := False;
      Label12.Caption := 'O formato para o campo "Data" deve ser, por exemplo: "Mai. 2002".';
    end;
  if ComboBox3.Text = 'Deflexes' then
    begin
      Nome := 'DEFLEX.CSV';
      Label8.Caption := 'km, Cargakgf, Dfi (i=1..7), Tar, Tsup, Ri (i=1..7), DiamPlaca, Data, Equipamento';
      Label10.Caption := 'Atravs do comando: "Edit DEFLEX.CSV" certifique-se de que o arquivo contm apenas as linhas necessrias.';
      Label11.Caption := 'Verifique tambm se no h campos em branco nas leituras.';
      Label13.Caption := 'Faixa de Trfego:';
      Label14.Caption := 'A quilometragem em DEFLEX.CSV deve estar de acordo com a do trecho.';
      ComboBox5.Visible := True;
      BitBtn3.Visible := True;
      GroupBox3.Visible := True;
      Label19.Caption := 'Unidade em que se encontram as deflexes:';
      ComboBox1.Visible := True;
      Label12.Caption := 'O formato para o campo "Data" deve ser, por exemplo: "Mai. 2002".';
    end;
  if ComboBox3.Text = 'Mdulos de Elasticidade das Camadas' then
    begin
      Nome := 'MODULOS.CSV';
      Label8.Caption := 'km, h1, E1, Temp, h2, E2, h3, E3, h4, E4, h5, E5, E1ref, D0ref, SN, Data, Equipamento';
      Label10.Caption := 'Atravs do comando: "Edit MODULOS.CSV" certifique-se de que o arquivo contm apenas as linhas necessrias.';
      Label11.Caption := 'Verifique tambm se no h campos em branco nas leituras.';
      Label13.Caption := 'Faixa de Trfego:';
      Label14.Caption := 'A quilometragem em MODULOS.CSV deve estar de acordo com a do trecho.';
      BitBtn3.Visible := False;
      GroupBox3.Visible := False;
      Label19.Caption := '';
      ComboBox1.Visible := False;
      ComboBox5.Visible := True;
      Label12.Caption := 'O formato para o campo "Data" deve ser, por exemplo: "Mai. 2002".';
    end;
  if ComboBox3.Text = 'IGG' then
    begin
      Nome := 'IGG.CSV';
      Label8.Caption := 'km, Seo, OK, LADO, FI, TTC, TTL, TLC, TLL, TRR, J, TB, JE, TBE, ALP, ATP, O, P, EX, D, R, ALC, ATC, E, TRImm, TREmm';
      Label10.Caption := 'Atravs do comando: "Edit IGG.CSV" certifique-se de que o arquivo contm apenas as linhas necessrias.';
      Label12.Caption := '';
      Label11.Caption := 'Faixas de trfego presentes em IGG.CSV:';
      GroupBox4.Visible := True;
      Label13.Caption := '';
      Label14.Caption := '';
      ComboBox5.Visible := False;
      BitBtn3.Visible := False;
      GroupBox3.Visible := False;
      Label19.Caption := '';
      ComboBox1.Visible := False;
    end;
  if ComboBox3.Text = 'LVD' then
    begin
      Nome := 'LVD.CSV';
      Label8.Caption := 'km, OK, FC1, FC2, FC3, ALP, ATP, O, P, EX, D, R, E, TRImm, TREmm, A_FC2, A_FC3, A_PA/RE, A_AT/ON, OBS';
      Label10.Caption := 'Atravs do comando: "Edit LVD.CSV" certifique-se de que o arquivo contm apenas as linhas necessrias.';
      Label11.Caption := 'Verifique tambm se no h campos em branco nas leituras.';
      Label13.Caption := 'Faixa de Trfego:';
      ComboBox5.Visible := True;
      Label14.Caption := '';
      BitBtn3.Visible := False;
      GroupBox3.Visible := False;
      Label19.Caption := '';
      ComboBox1.Visible := False;
    end;
  Label7.Caption := '...\Dados\Temp\' + Nome;
end;

procedure TForm49.BitBtn3Click(Sender: TObject);
const
  Length = 32;
  NDefs = 7;
  Passo = 4;
  PI = 3.141592654;
var
  Ano, NPeriodos: integer;
  ArqDados, ArqSaida: TextFile;
  Programa, Dados, Calc, Arquivo, Parametro, DadosAnoBase: string;
  NumSec, Flag, DOS, i, j, icol: SmallInt;
  StartTime: TDateTime;
  Linha: string[Length];
  Pressao, Raio, Carga, Df, x1, x2, y1, y2, x, y: single;
  D, R: array[1..NDefs] of string[Passo];
  km: string[8];
  Tsup, Tar: string[2];
  Param6: string[6];
  Diam: string[4];
begin
if ComboBox1.Text <> '' then
if Edit1.Text <> '' then
if Edit2.Text <> '' then
if Edit3.Text <> '' then
if Edit4.Text <> '' then
 begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := Dados + 'Temp\' + 'DEFLEX.FWD';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := Dados + 'Temp\' + 'DEFLEX.CSV';
  AssignFile(ArqSaida, Arquivo);
  Rewrite(ArqSaida);
  Writeln(ArqSaida, 'km,Carga (kgf),Df1,Df2,Df3,Df4,Df5,Df6,Df7,T Ar,T Pavim.,R1,R2,R3,R4,R5,R6,R7,D placa,Data,Equipamento');
  Readln(ArqDados, Linha);
  Raio := StrToFloat(Linha[1]+Linha[2]+Linha[3]) / 10;
  icol := 5;
  for j := 1 to NDefs do
    begin
      R[j] := '';
      for i := icol to (icol+Passo-1) do
        R[j] := R[j] + Linha[i];
      icol := icol + Passo;
      Df := StrToFloat(R[j]);
      Df := Df / 10;
      R[j] := FloatToStr(Df);
    end;
  while not Eof(ArqDados) do
    begin
      Readln(ArqDados, Linha);
      if Linha[1] = 'S' then
        begin
          km := '';
          for i := 2 to 10 do
            km := km + Linha[i];
          Tsup := Linha[21] + Linha[22];
          Tar := Linha[24] + Linha[25];
          Readln(ArqDados, Linha);
          while Linha[1] = 'R' do
            Readln(ArqDados, Linha);
          Pressao := StrToFloat(Linha[1]+Linha[2]+Linha[3]+Linha[4]);
          icol := 5;
          for j := 1 to NDefs do
            begin
              D[j] := '';
              for i := icol to (icol+Passo-1) do
                D[j] := D[j] + Linha[i];
              icol := icol + Passo;
              if ComboBox1.Text = 'micra' then
                begin
                  Df := StrToFloat(D[j]);
                  Df := Df / 10;
                  D[j] := FloatToStr(Df);
                end;
            end;
          Carga := (Pressao/100) * PI * (Raio*Raio);
          Param6 := FloatToStr(Carga);
          Diam := FloatToStr(2*Raio);
          { Correo do odmetro do FWD para km da rodovia }
            if Edit1.Text <> '' then
             begin
               x1 := StrToFloat(Edit1.Text);
               x2 := StrToFloat(Edit3.Text);
               y1 := StrToFloat(Edit2.Text);
               y2 := StrToFloat(Edit4.Text);
               x := StrToFloat(km);
               y := (x * (y2-y1) + (x2*y1-x1*y2)) / (x2-x1);
               km := FloatToStr(y);
            end;
          Writeln(ArqSaida, km, ',', Param6, ',', D[1], ',', D[2], ',',D[3], ',',D[4], ',',D[5], ',',D[6], ',',D[7], ',', Tar, ',', Tsup, ',', R[1], ',', R[2], ',',R[3], ',',R[4], ',',R[5], ',',R[6], ',',R[7], ',', Diam, ',', 'Mes. Ano', ',', 'FWD');
        end;
    end;
  CloseFile(ArqSaida);
  CloseFile(ArqDados);
  BitBtn3.Visible := False;
  GroupBox3.Visible := False;
  Label19.Caption := '';
  ComboBox1.Visible := False;
  Screen.Cursor := crDefault;
 end;
end;

procedure TForm49.ComboBox2Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Arquivo, Programa, Dados, Calc, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome: string[4];
  ArqDados, Arq: TextFile;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox2.Text = Local then Trecho := Nome;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  Label20.Caption := Trecho;
end;

procedure TForm49.BitBtn4Click(Sender: TObject);
var
  Ano, NPeriodos, DOS, i, j, FileCodeExcel, NCasos, NRodov, icont, NFields,
    IPar, IRodov, IFaixa, jk: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, Parametro, DadosAnoBase, Sentido, Linha,
    ArqTemp, LinhaX, LinhaY, ConfReg: string;
  Excel: OleVariant;
  ArqDbf, ArqCsv: array [1..4] of string;
  Year: string[4];
  Faixa: string[1];
  source, destination: file;
  buffer: array [1..1024] of byte;
  readcnt, writecnt: integer;
  scrname, destname: string;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Rodov: array [1..350] of string[4];
  Trecho: string[4];
  Campo: array [1..100] of string;
  kmi, kmf: Single;
  Executa: Boolean;
begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodov[i]);
  CloseFile(ArqDados);
  for IRodov := 1 to NRodov do
    begin
      Trecho := Rodov[IRodov];
      Arquivo := Calc + 'Cadas' + Trecho + '.csv';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      while not Eof(ArqDados) do
        Readln(ArqDados, Linha);
      CloseFile(ArqDados);
      j := 1;
      NFields := 25;
      for icont := 1 to NFields do
        Campo[icont] := '';
      for icont := 1 to Length(Linha) do
        begin
          if Linha[icont] = ',' then
            j := j + 1
          else
            Campo[j] := Campo[j] + Linha[icont];
        end;
      kmi := StrToFloat(Campo[5]);
      kmf := StrToFloat(Campo[6]);
      if kmf > kmi then Sentido := 'Crescente' else Sentido := 'Decrescente';
      { Parmetros com arquivos de dados por trecho }
      for IPar := 1 to 2 do
        begin
          Executa := False;
          case IPar of
               1:
                 begin
                   Arquivo := DadosAnoBase + 'QI\' + Trecho + '.csv';
                   if FileExists(Arquivo) then
                     begin
                       Parametro := 'QI';
                       DataModule10.Table5.Active := False;
                       ArqCsv[1] := Calc + 'FUNC' + Trecho + '.csv';
                       ArqDbf[1] := Dados + 'FUNC_' + Trecho + '_' + Year + '.dbf';
                       NCasos := 1;
                       Faixa := '';
                       Executa := True;
                     end;
                 end;
               2:
                 begin
                   Arquivo := DadosAnoBase + 'ATR\' + Trecho + '.csv';
                   if FileExists(Arquivo) then
                     begin
                       Parametro := 'ATR';
                       DataModule10.Table10.Active := False;
                       ArqCsv[1] := Calc + 'ATR' + Trecho + '.csv';
                       ArqDbf[1] := Dados + 'ATR_' + Trecho + '_' + Year + '.dbf';
                       NCasos := 1;
                       Faixa := '';
                       Executa := True;
                     end;
                 end;
          end;
          if Executa then
            begin
              scrname := Arquivo;
              destname := Dados + 'Temp\' + Parametro + '.CSV';
              AssignFile(source, scrname);
              Try
                Reset(source, 1);
              Except
                Exit;
              end;
              AssignFile(destination, destname);
              Try
                Rewrite(destination, 1);
              Except
                Exit;
              end;
              Repeat
                BlockRead(source, buffer, sizeof(buffer), readcnt);
                Try
                  BlockWrite(destination, buffer, readcnt, writecnt);
                Except
                  Exit;
                end;
              until (readcnt=0) or (writecnt<>readcnt);
              CloseFile(destination);
              CloseFile(source);
              Arquivo := Calc + 'Medias.dat';
              AssignFile(ArqDados, Arquivo);
              Rewrite(ArqDados);
              Writeln(ArqDados, Parametro);
              Writeln(ArqDados, Trecho);
              Writeln(ArqDados, Sentido);
              Writeln(ArqDados, Faixa);
              CloseFile(ArqDados);
              { Executa o programa que calcula os parmetros mdios
                por Subtrecho Homogneo }
                Arquivo := 'DOS.DAT';
                if FileExists(Arquivo) then
                  begin
                    AssignFile(ArqDados, Arquivo);
                    Erase(ArqDados)
                  end;
                if Parametro = 'QI' then
                  WinExec('CalcQI.exe /c', SW_HIDE)
                else
                  WinExec('ATR.exe /c', SW_HIDE);
                Flag := 0;
                StartTime := now;
                NumSec := 5;
                repeat
                  Application.ProcessMessages;
                  if FileExists(Arquivo) then Flag := 1;
                until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
              for i := 1 to NCasos do
                begin
                  scrname := ArqCsv[i];
                  destname := Dados + 'Temp\' + 'Temp.CSV';
                  AssignFile(source, scrname);
                  Try
                    Reset(source, 1);
                  Except
                    Exit;
                  end;
                  AssignFile(destination, destname);
                  Try
                    Rewrite(destination, 1);
                  Except
                    Exit;
                  end;
                  Repeat
                    BlockRead(source, buffer, sizeof(buffer), readcnt);
                    Try
                      BlockWrite(destination, buffer, readcnt, writecnt);
                    Except
                      Exit;
                    end;
                  until (readcnt=0) or (writecnt<>readcnt);
                  CloseFile(destination);
                  CloseFile(source);
                  Arquivo := 'FLAG.DAT';
                  if FileExists(Arquivo) then
                    begin
                      AssignFile(ArqDados, Arquivo);
                      Erase(ArqDados)
                    end;
                  WinExec('Atualiza.exe /c', SW_HIDE);
                  Flag := 0;
                  StartTime := now;
                  NumSec := 5;
                  repeat
                    Application.ProcessMessages;
                    if FileExists(Arquivo) then Flag := 1;
                  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
                end;
              { Converte de CSV para DBF }
              for i := 1 to NCasos do
                begin
                 if ArqDbf[i] = Dados + 'FUNC_' + Trecho + '_' + Year + '.dbf' then
                   begin
                    NFields := 7;
                    AssignFile(Arq, ArqCsv[i]);
                    Reset(Arq);
                    Readln(Arq, Linha);
                    with DataModule10.Table5 do
                      begin
                        Active := False;
                        TableName := ArqDbf[i];
                        CreateTable;
                        Active := True;
                        Edit;
                        First;
                      end;
                    while not eof(Arq) do
                      begin
                        Readln(Arq, Linha);
                        j := 1;
                        for icont := 1 to NFields do
                          Campo[icont] := '';
                        for icont := 1 to Length(Linha) do
                          begin
                            if Linha[icont] = ',' then
                              j := j + 1
                            else
                              if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
                          end;
                          if ConfReg = 'Portuguese' then
                            begin
                              for j := 2 to 5 do
                                begin
                                  for jk := 1 to Length(Campo[j]) do
                                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                                end;
                            end;
                          DataModule10.Table5.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                          StrToFloat(Campo[4]),StrToFloat(Campo[5]),Campo[6],Campo[7]]);
                      end;
                    DataModule10.Table5.Close;
                    DataModule10.Table5.Active := False;
                    CloseFile(Arq);
                   end
                  else
                   begin
                     NFields := 19;
                     AssignFile(Arq, ArqCsv[i]);
                     Reset(Arq);
                     Readln(Arq, Linha);
                     with DataModule10.Table10 do
                      begin
                        Active := False;
                        TableName := ArqDbf[i];
                        CreateTable;
                        Active := True;
                        Edit;
                        First;
                      end;
                    while not eof(Arq) do
                      begin
                        Readln(Arq, Linha);
                        j := 1;
                        for icont := 1 to NFields do
                          Campo[icont] := '';
                        for icont := 1 to Length(Linha) do
                          begin
                            if Linha[icont] = ',' then
                              j := j + 1
                            else
                              if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
                         end;
                          if ConfReg = 'Portuguese' then
                            begin
                              for j := 2 to 9 do
                                begin
                                  for jk := 1 to Length(Campo[j]) do
                                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                                end;
                              for j := 12 to 19 do
                                begin
                                  for jk := 1 to Length(Campo[j]) do
                                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                                end;

                            end;
                       DataModule10.Table10.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                         StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),StrToFloat(Campo[7]),
                         StrToFloat(Campo[8]),StrToFloat(Campo[9]),Campo[10],Campo[11],StrToFloat(Campo[12]),
                         StrToFloat(Campo[13]),StrToFloat(Campo[14]),StrToFloat(Campo[15]),StrToFloat(Campo[16]),
                         StrToFloat(Campo[17]),StrToFloat(Campo[18]),StrToFloat(Campo[19])]);
                      end;
                    DataModule10.Table10.Close;
                    DataModule10.Table10.Active := False;
                    CloseFile(Arq);
                   end;
                end;
            end;
        end;
     { Parmetros com arquivos por faixa de trfego }
      Arquivo := Calc + 'Unidade.dat';
      AssignFile(ArqDados, Arquivo);
      Rewrite(ArqDados);
      Writeln(ArqDados, '0,01 mm');
      CloseFile(ArqDados);
      for IPar := 1 to 3 do
       for IFaixa := 1 to 4 do
        begin
          Faixa := IntToStr(IFaixa);
          Executa := False;
          case IPar of
               1:
                 begin
                   Arquivo := DadosAnoBase + 'DEFLEX\' + Trecho + '_' + Faixa + '.csv';
                   if FileExists(Arquivo) then
                     begin
                       Executa := True;
                       Parametro := 'DEFLEX';
                       DataModule10.Table3.Active := False;
                       ArqCsv[1] := Calc + 'DFX' + Trecho + Faixa + '.csv';
                       ArqDbf[1] := Dados + 'DFX_' + Trecho + Faixa + '_' + Year + '.dbf';
                       NCasos := 1;
                     end;
                 end;
               2:
                 begin
                   ArqTemp := Dados + 'IGG_' + Trecho + Faixa + '_' + Year + '.dbf';
                   if FileExists(ArqTemp) then
                     begin
                       Arquivo := Calc + 'IGG' + Trecho + Faixa + '.csv';
                       AssignFile(ArqDados, Arquivo);
                       Rewrite(ArqDados);
                       Linha := 'km,Secao,LADO,OK,FI,TTC,TTL,TLC,TLL,TRR,J,TB,JE,TBE,ALP,ATP,O,P+E,EX,D,R,ALC,ATC,TRI,TRE,FC1,FC2,FC3,PA,AT/ON,DE,RE,EX,IGG';
                       NFields := 1;
                       for icont := 1 to Length(Linha) do
                         if Linha[icont] = ',' then NFields := NFields + 1;
                       Writeln(ArqDados, Linha);
                       with DataModule10.Table2 do
                         begin
                           Active := False;
                           TableName := ArqTemp;
                           Active := True;
                           First;
                           while not Eof do
                             begin
                               LinhaX := Fields.Fields[0].AsString;
                               Linha := '';
                               for jk := 1 to Length(LinhaX) do
                                 begin
                                   if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                                   Linha := Linha + LinhaX[jk];
                                 end;
                               for icont := 1 to NFields-1 do
                                 begin
                                   LinhaX := Fields.Fields[icont].AsString;
                                   LinhaY := '';
                                   for jk := 1 to Length(LinhaX) do
                                     begin
                                       if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                                       LinhaY := LinhaY + LinhaX[jk];
                                     end;
                                   Linha := Linha + ',' + LinhaY;
                                 end;
                               Writeln(ArqDados, Linha);
                               Next;
                             end;
                           Active := False;
                         end;
                       CloseFile(ArqDados);
                       Executa := True;
                       NCasos := 1;
                       Parametro := 'LVD';
                       DataModule10.Table18.Active := False;
                       ArqCsv[NCasos] := Calc + 'LVC' + Trecho + Faixa + '.csv';
                       ArqDbf[NCasos] := Dados + 'LVC_' + Trecho + Faixa + '_' + Year + '.dbf';
                     end;
                 end;
               3:
                 begin
                   Arquivo := DadosAnoBase + 'Modulos\' + Trecho + '_' + Faixa + '.csv';
                   if FileExists(Arquivo) then
                     begin
                       Executa := True;
                       Parametro := 'MODULOS';
                       DataModule10.Table12.Active := False;
                       ArqCsv[1] := Calc + 'MOD' + Trecho + Faixa + '.csv';
                       ArqDbf[1] := Dados + 'MOD_' + Trecho + Faixa + '_' + Year + '.dbf';
                       NCasos := 1;
                     end;
                 end;
          end;
          if Executa then
            begin
              scrname := Arquivo;
              destname := Dados + 'Temp\' + Parametro + '.csv';
              AssignFile(source, scrname);
              Try
                Reset(source, 1);
              Except
                Exit;
              end;
              AssignFile(destination, destname);
              Try
                Rewrite(destination, 1);
              Except
                Exit;
              end;
              Repeat
                BlockRead(source, buffer, sizeof(buffer), readcnt);
                Try
                  BlockWrite(destination, buffer, readcnt, writecnt);
                Except
                  Exit;
                end;
              until (readcnt=0) or (writecnt<>readcnt);
              CloseFile(destination);
              CloseFile(source);
              Arquivo := Calc + 'Medias.dat';
              AssignFile(ArqDados, Arquivo);
              Rewrite(ArqDados);
              Writeln(ArqDados, Parametro);
              Writeln(ArqDados, Trecho);
              Writeln(ArqDados, Sentido);
              Writeln(ArqDados, Faixa);
              CloseFile(ArqDados);
              { Executa o programa que calcula os parmetros mdios
                por Subtrecho Homogneo }
                Arquivo := 'DOS.DAT';
                if FileExists(Arquivo) then
                  begin
                    AssignFile(ArqDados, Arquivo);
                    Erase(ArqDados)
                  end;
                if Parametro = 'DEFLEX' then
                  WinExec('DEFLEX.exe /c', SW_HIDE)
                else
                  WinExec('LVDPRO08.exe /c', SW_HIDE);
                Flag := 0;
                StartTime := now;
                NumSec := 5;
                repeat
                  Application.ProcessMessages;
                  if FileExists(Arquivo) then Flag := 1;
                until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
              for i := 1 to NCasos do
                begin
                  scrname := ArqCsv[i];
                  destname := Dados + 'Temp\' + 'Temp.CSV';
                  AssignFile(source, scrname);
                  Try
                    Reset(source, 1);
                  Except
                    Exit;
                  end;
                  AssignFile(destination, destname);
                  Try
                    Rewrite(destination, 1);
                  Except
                    Exit;
                  end;
                  Repeat
                    BlockRead(source, buffer, sizeof(buffer), readcnt);
                    Try
                      BlockWrite(destination, buffer, readcnt, writecnt);
                    Except
                      Exit;
                    end;
                  until (readcnt=0) or (writecnt<>readcnt);
                  CloseFile(destination);
                  CloseFile(source);
                  Arquivo := 'FLAG.DAT';
                  if FileExists(Arquivo) then
                    begin
                      AssignFile(ArqDados, Arquivo);
                      Erase(ArqDados)
                    end;
                  WinExec('Atualiza.exe /c', SW_HIDE);
                  Flag := 0;
                  StartTime := now;
                  NumSec := 5;
                  repeat
                    Application.ProcessMessages;
                    if FileExists(Arquivo) then Flag := 1;
                  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
                end;
              { Converte de CSV para DBF }
                for i := 1 to NCasos do
                  begin
                    if ArqDbf[i] = Dados + 'DFX_' + Trecho + Faixa + '_' + Year + '.dbf' then
                      begin
                        NFields := 22;
                        AssignFile(Arq, ArqCsv[i]);
                        Reset(Arq);
                        Readln(Arq, Linha);
                        with DataModule10.Table3 do
                          begin
                            Active := False;
                            TableName := ArqDbf[i];
                            CreateTable;
                            Active := True;
                            Edit;
                            First;
                          end;
                        while not eof(Arq) do
                          begin
                            Readln(Arq, Linha);
                            j := 1;
                            for icont := 1 to NFields do
                              Campo[icont] := '';
                            for icont := 1 to Length(Linha) do
                              begin
                                if Linha[icont] = ',' then
                                  j := j + 1
                                else
                                  if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
                              end;
                            if ConfReg = 'Portuguese' then
                              begin
                                for j := 2 to 20 do
                                  begin
                                    for jk := 1 to Length(Campo[j]) do
                                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                                  end;
                              end;
                            DataModule10.Table3.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                              StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),StrToFloat(Campo[7]),
                              StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),StrToFloat(Campo[11]),
                              StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),StrToFloat(Campo[15]),
                              StrToFloat(Campo[16]),StrToFloat(Campo[17]),StrToFloat(Campo[18]),StrToFloat(Campo[19]),
                              StrToFloat(Campo[20]),Campo[21],Campo[22]]);
                          end;
                       DataModule10.Table3.Close;
                       DataModule10.Table3.Active := False;
                       CloseFile(Arq);
                      end
                    else
                      if ArqDbf[i] = Dados + 'MOD_' + Trecho + Faixa + '_' + Year + '.dbf' then
                        begin
                          NFields := 17;
                          AssignFile(Arq, ArqCsv[i]);
                          Reset(Arq);
                          Readln(Arq, Linha);
                          with DataModule10.Table12 do
                            begin
                              Active := False;
                              TableName := ArqDbf[i];
                              CreateTable;
                              Active := True;
                              Edit;
                              First;
                            end;
                          while not eof(Arq) do
                            begin
                              Readln(Arq, Linha);
                              j := 1;
                              for icont := 1 to NFields do
                                Campo[icont] := '';
                              for icont := 1 to Length(Linha) do
                                begin
                                  if Linha[icont] = ',' then
                                    j := j + 1
                                  else
                                    if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
                                end;
                              if ConfReg = 'Portuguese' then
                                begin
                                  for j := 2 to 15 do
                                    begin
                                      for jk := 1 to Length(Campo[j]) do
                                        if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                                    end;
                                end;
                              DataModule10.Table12.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                                StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),StrToFloat(Campo[7]),
                                StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),StrToFloat(Campo[11]),
                                StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),StrToFloat(Campo[15]),
                                Campo[16],Campo[17]]);
                            end;
                          DataModule10.Table12.Close;
                          DataModule10.Table12.Active := False;
                          CloseFile(Arq);
                        end
                      else
                        begin
                          NFields := 39;
                          AssignFile(Arq, ArqCsv[i]);
                          Reset(Arq);
                          Readln(Arq, Linha);
                          with DataModule10.Table6 do
                            begin
                              Active := False;
                              TableName := ArqDbf[i];
                              CreateTable;
                              Active := True;
                              Edit;
                              First;
                            end;
                          while not eof(Arq) do
                            begin
                              Readln(Arq, Linha);
                              j := 1;
                              for icont := 1 to NFields do
                                Campo[icont] := '';
                              for icont := 1 to Length(Linha) do
                                begin
                                  if Linha[icont] = ',' then
                                    j := j + 1
                                  else
                                    if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
                                end;
                              if ConfReg = 'Portuguese' then
                                begin
                                  for j := 2 to 4 do
                                    begin
                                      for jk := 1 to Length(Campo[j]) do
                                        if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                                    end;
                                  for j := 36 to 37 do
                                    begin
                                      for jk := 1 to Length(Campo[j]) do
                                        if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                                    end;
                                end;
                              DataModule10.Table6.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                                StrToFloat(Campo[4]),Campo[5],Campo[6],Campo[7],Campo[8],Campo[9],Campo[10],Campo[11],
                                Campo[12],Campo[13],Campo[14],Campo[15],Campo[16],Campo[17],Campo[18],Campo[19],
                                Campo[20],Campo[21],Campo[22],Campo[23],Campo[24],Campo[25],Campo[26],Campo[27],
                                Campo[28],Campo[29],Campo[30],Campo[31],Campo[32],Campo[33],Campo[34],Campo[35],
                                StrToFloat(Campo[36]),StrToFloat(Campo[37]),Campo[38],Campo[39]]);
                            end;
                          DataModule10.Table6.Close;
                          DataModule10.Table6.Active := False;
                          CloseFile(Arq);
                        end;
                  end;
            end;
        end;
    end;
  Screen.Cursor := crDefault;
  Close;
end;

procedure TForm49.BitBtn5Click(Sender: TObject);
const
  NLinhas = 6;
var
  Excel: OleVariant;
  i, j, Ano, NPeriodos, FileCodeExcel, NRodov, NSTH, NFields, isth, NPDG, jj,
    NCatTraf, k, IFaixa, Ncont, icont, jk, jl: integer;
  Arquivo, Programa, Dados, Calc, ArqDbf, ArqXls, ArqNomes, Linha, Path, Topo,
    TrafData, Path1, Path2, Linha1, ArqCsv, Linha2, LinhaBranca, DadosAnoBase,
    ConfReg: string;
  Rodovia, Rod: array [1..350] of string[4];
  Year: string[4];
  Codigo: string[5];
  ArqDados, Arq, Arq1: TextFile;
  ArqSai: array [1..4] of TextFile;
  Faixa: array [1..4] of string[1];
  Med: string[8];
  Pedagio: array[1..30] of string[8];
  ISent: array[1..30] of SmallInt;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Disco, Tipo, Rodov: string[4];
  Campo: array [1..100] of string;
  STH, kmi, kmf: string[15];
  IFX: array [1..4] of SmallInt;
begin
  Screen.Cursor := crHourglass;
  Faixa[1] := '1';
  Faixa[2] := '2';
  Faixa[3] := '3';
  Faixa[4] := '4';
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
    Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  Disco := '';
  for i := 1 to 3 do
    Disco := Disco + Programa;
   { Cdigos de identificao das rodovias que compem a rede }
    Arquivo := Dados + 'Rodovias.dat';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, NRodov);
    for i := 1 to NRodov do
      Readln(ArqDados, Rodovia[i]);
    CloseFile(ArqDados);
     Tipo := 'LVC';
     Path := Dados + 'Temp\';
     Path1 := Calc;
     Arquivo := Calc + 'TipoLev.dat';
     AssignFile(Arq, Arquivo);
     Rewrite(Arq);
     Writeln(Arq, Tipo);
     CloseFile(Arq);
     AssignFile(Arq, 'Rod.dat');
     Rewrite(Arq);
     { Converte as planilhas de XLS para CSV }
     Excel := CreateOleObject('Excel.Application');
     Excel.Visible := False;
     for i := 1 to NRodov do
      begin
       ArqXls := Path + 'LVC_' + Rodovia[i] + '.xls';
       if FileExists(ArqXls) then
       begin
        Writeln(Arq, Rodovia[i]);
        ArqCsv := Path1 + 'LVC' + Rodovia[i] + '.csv';
        if FileExists(ArqCsv) then
          begin
            AssignFile(ArqDados, ArqCsv);
            Erase(ArqDados)
          end;
        FileCodeExcel := 1;
        Excel.Workbooks.Open(ArqXls, True, FileCodeExcel);
        Excel.Workbooks.Add;
        Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
        Excel.Workbooks[2].Sheets[1].PasteSpecial;
        { FileCodeExcel := 3 para *.txt e := 6 para *.CSV }
        FileCodeExcel := 6;
        Excel.Workbooks[2].Sheets[1].SaveAs(ArqCsv, FileCodeExcel);
        Excel.Workbooks[1].Saved := True;
        Excel.Workbooks[2].Saved := True;
        Excel.Workbooks.Close;
       end;
      end;
     Excel.Quit;
     CloseFile(Arq);
     InvConv(ArqCsv);
     LinhaBranca := ',-1,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-1,-1,Nenhuma';
     Topo := 'STH,INICIO,FIM,PSR,CR1,CR2,CR3,BL1,BL2,BL3,TT1,TT2,TT3,TL1,TL2,TL3,TE1,TE2,TE3,TB1,TB2,TB3,P,D,DS,ER,BF,DC,R1,R2,R3,ATR,COR,EM,DP,PSR_ACOST,DEGRAU_CM,DATA,OBS';
     NFields := 4;
     AssignFile(Arq, 'Rod.dat');
     Reset(Arq);
     while not Eof(Arq) do
      begin
        Readln(Arq, Rodov);
        for j := 1 to 4 do
          begin
            Arquivo := Path1 + 'LVC' + Rodov + Faixa[j] + '.cs1';
            AssignFile(ArqSai[j], Arquivo);
            Rewrite(ArqSai[j]);
            Writeln(ArqSai[j], Topo);
          end;
        ArqCsv := Path1 + 'LVC' + Rodov + '.csv';
        AssignFile(ArqDados, ArqCsv);
        Reset(ArqDados);
        for j := 1 to NLinhas do
          Readln(ArqDados, Linha);
        Readln(ArqDados, Linha);
        j := 1;
        for k := 1 to 50 do
          Campo[k] := '';
        for k := 1 to Length(Linha) do
          if Linha[k] = ',' then
            j := j + 1
          else
            Campo[j] := Campo[j] + Linha[k];
        STH := Campo[1];
        kmi := Campo[2];
        kmf := Campo[3];
        IFaixa := StrToInt(Campo[4]);
        if IFaixa > 4 then ShowMessage(ArqCsv);
        if IFaixa < 1 then ShowMessage(ArqCsv);
        if Linha[Length(Linha)] = ',' then Linha := Linha + 'Nenhuma';
        Writeln(ArqSai[IFaixa], Linha);
        while not Eof(ArqDados) do
          begin
            Readln(ArqDados, Linha);
            if Linha[1] = ',' then
              begin
                IFaixa := StrToInt(Linha[4]);
                if IFaixa <= 4 then
                  if IFaixa >= 1 then
                    begin
                      Linha2 := '';
                      for k := 4 to Length(Linha) do
                        Linha2 := Linha2 + Linha[k];
                      Linha1 := STH + ',' + kmi + ',' + kmf + ',' + Linha2;
                      if Linha1[Length(Linha1)] = ',' then Linha1 := Linha1 + 'Nenhuma';
                      Writeln(ArqSai[IFaixa], Linha1);
                    end;
              end
            else
              begin
                for k := IFaixa + 1 to 4 do
                  begin
                    Linha2 := STH + ',' + kmi + ',' + kmf + ',' + IntToStr(k) + LinhaBranca;
                    Writeln(ArqSai[k], Linha2);
                  end;
                j := 1;
                for k := 1 to 50 do
                  Campo[k] := '';
                for k := 1 to Length(Linha) do
                  if Linha[k] = ',' then
                    j := j + 1
                  else
                    Campo[j] := Campo[j] + Linha[k];
                STH := Campo[1];
                kmi := Campo[2];
                kmf := Campo[3];
                IFaixa := StrToInt(Campo[4]);
                if IFaixa <= 4 then
                  if IFaixa >= 1 then
                    begin
                      if Linha[Length(Linha)] = ',' then Linha := Linha + 'Nenhuma';
                      Writeln(ArqSai[IFaixa], Linha);
                    end;
              end;
          end;
        for k := IFaixa + 1 to 4 do
          begin
            Linha2 := STH + ',' + kmi + ',' + kmf + ',' + IntToStr(k) + LinhaBranca;
            Writeln(ArqSai[k], Linha2);
          end;
        for j := 1 to 4 do
          CloseFile(ArqSai[j]);
        CloseFile(ArqDados);
      end;
     CloseFile(Arq);
     AssignFile(ArqDados, 'Dados.dat');
     Rewrite(ArqDados);
     Writeln(ArqDados, Path);
     Writeln(ArqDados, Path1);
     Writeln(ArqDados, Tipo);
     CloseFile(ArqDados);
     Arquivo := 'DOS.DAT';
     if FileExists(Arquivo) then
       begin
         AssignFile(ArqDados, Arquivo);
         Erase(ArqDados)
       end;
     WinExec('LVC.exe /c', SW_SHOW);
     Flag := 0;
     StartTime := now;
     NumSec := 3;
     repeat
       Application.ProcessMessages;
       if FileExists(Arquivo) then Flag := 1;
     until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
    AssignFile(Arq1, 'Rod.dat');
    Reset(Arq1);
    while not Eof(Arq1) do
     begin
      Readln(Arq1, Rodov);
       Ncont := 0;
       for j := 1 to 4 do
         begin
             ArqXls := Calc + Tipo + Rodov + Faixa[j] + '.cs2';
             AssignFile(ArqDados, ArqXls);
             Reset(ArqDados);
             Readln(ArqDados, Linha);
             if not Eof(ArqDados) then
               begin
                 Ncont := Ncont + 1;
                 IFX[Ncont] := j;
               end;
             CloseFile(ArqDados);
         end;
       for i := 1 to Ncont do
         begin
             j := IFX[i];
             ArqXls := Calc + Tipo + Rodov + Faixa[j] + '.cs2';
             Arquivo := Calc + Tipo + Rodov + Faixa[j] + '.csv';
             AssignFile(ArqDados, ArqXls);
             Reset(ArqDados);
             Readln(ArqDados, Linha);
             Linha1 := '';
             for k := 1 to Length(Linha) do
               if Linha[k] <> '"' then Linha1 := Linha1 + Linha[k];
             AssignFile(Arq, Arquivo);
             Rewrite(Arq);
             Writeln(Arq, Linha1);
             while not Eof(ArqDados) do
               begin
                 Readln(ArqDados, Linha);
                 Writeln(Arq, Linha);
               end;
             CloseFile(ArqDados);
             CloseFile(Arq);
         end;
     end;
     CloseFile(Arq1);
    { Converte de CSV para DBF }
      DataModule10.Table6.Active := False;
      AssignFile(Arq, 'Rod.dat');
      Reset(Arq);
      while not Eof(Arq) do
       begin
        Readln(Arq, Rodov);
        for j := 1 to 4 do
           begin
             Arquivo := Calc + Tipo + Rodov + Faixa[j] + '.csv';
             ArqDbf := Dados + Tipo + '_' + Rodov + Faixa[j] + '_' + Year + '.dbf';
             NFields := 39;
             AssignFile(ArqDados, Arquivo);
             Reset(ArqDados);
             Readln(ArqDados, Linha);
             with DataModule10.Table6 do
               begin
                 Active := False;
                 TableName := ArqDbf;
                 CreateTable;
                 Active := True;
                 Edit;
                 First;
               end;
             while not eof(ArqDados) do
               begin
                 Readln(ArqDados, Linha);
                 jj := 1;
                 for icont := 1 to NFields do
                   Campo[icont] := '';
                 for icont := 1 to Length(Linha) do
                   begin
                     if Linha[icont] = ',' then
                       jj := jj + 1
                     else
                       if Linha[icont] <> '"' then Campo[jj] := Campo[jj] + Linha[icont];
                   end;
                 if ConfReg = 'Portuguese' then
                   begin
                     for jl := 2 to 4 do
                       begin
                         for jk := 1 to Length(Campo[jl]) do
                           if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                       end;
                     for jl := 36 to 37 do
                       begin
                         for jk := 1 to Length(Campo[jl]) do
                           if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                       end;
                   end;
                 DataModule10.Table6.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                   StrToFloat(Campo[4]),Campo[5],Campo[6],Campo[7],Campo[8],Campo[9],Campo[10],Campo[11],
                   Campo[12],Campo[13],Campo[14],Campo[15],Campo[16],Campo[17],Campo[18],Campo[19],
                   Campo[20],Campo[21],Campo[22],Campo[23],Campo[24],Campo[25],Campo[26],Campo[27],
                   Campo[28],Campo[29],Campo[30],Campo[31],Campo[32],Campo[33],Campo[34],Campo[35],
                   StrToFloat(Campo[36]),StrToFloat(Campo[37]),Campo[38],Campo[39]]);
               end;
             DataModule10.Table6.Close;
             DataModule10.Table6.Active := False;
             CloseFile(ArqDados);
           end;
       end;
       CloseFile(Arq);
  Screen.Cursor := crDefault;
  Close;
end;

procedure TForm49.BitBtn6Click(Sender: TObject);
const
  NFaixasMax = 7;
  NLinhas = 5;
var
  Excel: OleVariant;
  i, j, Ano, NPeriodos, FileCodeExcel, NRodov, NSTH, NFields, isth, NPDG, jj,
    NCatTraf, k, IFaixa, icont, jk, jl: integer;
  Arquivo, Programa, Dados, Calc, ArqDbf, ArqXls, ArqNomes, Linha, Path, Topo,
    TrafData, Path1, Path2, Linha1, ArqCsv, Linha2, LinhaBranca, ConfReg,
    DadosAnoBase: string;
  Rodovia, Rod: array [1..350] of string[4];
  Year: string[4];
  Codigo: string[5];
  ArqDados, Arq, Arq1: TextFile;
  ArqSai: array [1..NFaixasMax] of TextFile;
  Faixa: array [1..NFaixasMax] of string[1];
  Med: string[8];
  Pedagio: array[1..30] of string[8];
  ISent: array[1..30] of SmallInt;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Disco, Tipo, Rodov: string[4];
  Campo: array [1..100] of string;
  STH, kmi, kmf: string[15];
begin
  Screen.Cursor := crHourglass;
  Faixa[1] := '1';
  Faixa[2] := '2';
  Faixa[3] := '3';
  Faixa[4] := '4';
  Faixa[5] := '5';
  Faixa[6] := '6';
  Faixa[7] := '7';
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
    Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  Disco := '';
  for i := 1 to 3 do
    Disco := Disco + Programa;
   { Cdigos de identificao das rodovias que compem a rede }
    Arquivo := Dados + 'Rodovias.dat';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, NRodov);
    for i := 1 to NRodov do
      Readln(ArqDados, Rodovia[i]);
    CloseFile(ArqDados);
     Tipo := 'LTR';
     Path := Dados + 'Temp\';
     Path1 := Calc;
     Arquivo := Calc + 'TipoLev.dat';
     AssignFile(Arq, Arquivo);
     Rewrite(Arq);
     Writeln(Arq, Tipo);
     CloseFile(Arq);
     AssignFile(Arq, 'Rod.dat');
     Rewrite(Arq);
     { Converte as planilhas de XLS para CSV }
     Excel := CreateOleObject('Excel.Application');
     Excel.Visible := False;
     for i := 1 to NRodov do
      begin
       ArqXls := Path + Tipo + '_' + Rodovia[i] + '.xls';
       if FileExists(ArqXls) then
       begin
        Writeln(Arq, Rodovia[i]);
        ArqCsv := Path1 + Tipo + Rodovia[i] + '.csv';
        if FileExists(ArqCsv) then
          begin
            AssignFile(ArqDados, ArqCsv);
            Erase(ArqDados)
          end;
        FileCodeExcel := 1;
        Excel.Workbooks.Open(ArqXls, True, FileCodeExcel);
        Excel.Workbooks.Add;
        Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
        Excel.Workbooks[2].Sheets[1].PasteSpecial;
        { FileCodeExcel := 3 para *.txt e := 6 para *.CSV }
        FileCodeExcel := 6;
        Excel.Workbooks[2].Sheets[1].SaveAs(ArqCsv, FileCodeExcel);
        Excel.Workbooks[1].Saved := True;
        Excel.Workbooks[2].Saved := True;
        Excel.Workbooks.Close;
       end;
      end;
     Excel.Quit;
     CloseFile(Arq);
     LinhaBranca := ',-1,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-1,-1,,,,,Nenhuma';
     Topo := 'STH,INICIO,FIM,PSR,CR1,CR2,CR3,BL1,BL2,BL3,TT1,TT2,TT3,TL1,TL2,TL3,TE1,TE2,TE3,TB1,TB2,TB3,P,D,DS,ER,BF,DC,R1,R2,R3,ATR,COR,EM,DP,EX,PSR_ACOST,DEGRAU_CM,TIPOSEC,TR,DP,P,OBS';
     NFields := 4;
     AssignFile(Arq, 'Rod.dat');
     Reset(Arq);
     while not Eof(Arq) do
      begin
        Readln(Arq, Rodov);
        for j := 1 to NFaixasMax do
          begin
            Arquivo := Path1 + Tipo + Rodov + Faixa[j] + '.csv';
            AssignFile(ArqSai[j], Arquivo);
            Rewrite(ArqSai[j]);
            Writeln(ArqSai[j], Topo);
          end;
        ArqCsv := Path1 + Tipo + Rodov + '.csv';
        AssignFile(ArqDados, ArqCsv);
        Reset(ArqDados);
        for j := 1 to NLinhas do
          Readln(ArqDados, Linha);
        Readln(ArqDados, Linha);
        j := 1;
        for k := 1 to 50 do
          Campo[k] := '';
        for k := 1 to Length(Linha) do
          if Linha[k] = ',' then
            j := j + 1
          else
            Campo[j] := Campo[j] + Linha[k];
        STH := Campo[1];
        kmi := Campo[2];
        kmf := Campo[3];
        IFaixa := StrToInt(Campo[4]);
        if IFaixa > NFaixasMax then ShowMessage(ArqCsv);
        if IFaixa < 1 then ShowMessage(ArqCsv);
        if Linha[Length(Linha)] = ',' then Linha := Linha + 'Nenhuma';
        Writeln(ArqSai[IFaixa], Linha);
        while not Eof(ArqDados) do
          begin
            Readln(ArqDados, Linha);
            if Linha[1] = ',' then
              begin
                IFaixa := StrToInt(Linha[4]);
                Linha2 := '';
                for k := 4 to Length(Linha) do
                  Linha2 := Linha2 + Linha[k];
                Linha1 := STH + ',' + kmi + ',' + kmf + ',' + Linha2;
                if Linha1[Length(Linha1)] = ',' then Linha1 := Linha1 + 'Nenhuma';
                Writeln(ArqSai[IFaixa], Linha1);
              end
            else
              begin
                for k := IFaixa + 1 to 4 do
                  begin
                    Linha2 := STH + ',' + kmi + ',' + kmf + ',' + IntToStr(k) + LinhaBranca;
                    Writeln(ArqSai[k], Linha2);
                  end;
                j := 1;
                for k := 1 to 50 do
                  Campo[k] := '';
                for k := 1 to Length(Linha) do
                  if Linha[k] = ',' then
                    j := j + 1
                  else
                    Campo[j] := Campo[j] + Linha[k];
                STH := Campo[1];
                kmi := Campo[2];
                kmf := Campo[3];
                IFaixa := StrToInt(Campo[4]);
                if IFaixa > 4 then ShowMessage(ArqCsv);
                if IFaixa < 1 then ShowMessage(ArqCsv);
                if Linha[Length(Linha)] = ',' then Linha := Linha + 'Nenhuma';
                Writeln(ArqSai[IFaixa], Linha);
              end;
          end;
        for k := IFaixa + 1 to 4 do
          begin
            Linha2 := STH + ',' + kmi + ',' + kmf + ',' + IntToStr(k) + LinhaBranca;
            Writeln(ArqSai[k], Linha2);
          end;
        for j := 1 to 4 do
          CloseFile(ArqSai[j]);
        CloseFile(ArqDados);
      end;
     CloseFile(Arq);
     AssignFile(ArqDados, 'Dados.dat');
     Rewrite(ArqDados);
     Writeln(ArqDados, Path);
     Writeln(ArqDados, Path1);
     Writeln(ArqDados, Tipo);
     CloseFile(ArqDados);
     Arquivo := 'DOS.DAT';
     if FileExists(Arquivo) then
       begin
         AssignFile(ArqDados, Arquivo);
         Erase(ArqDados)
       end;
     WinExec('LTR.exe /c', SW_SHOW);
     Flag := 0;
     StartTime := now;
     NumSec := 5;
     repeat
       Application.ProcessMessages;
       if FileExists(Arquivo) then Flag := 1;
     until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
    AssignFile(Arq1, 'Rod.dat');
    Reset(Arq1);
    while not Eof(Arq1) do
     begin
      Readln(Arq1, Rodov);
       for j := 1 to 4 do
         begin
             ArqXls := Calc + 'LVC' + Rodov + Faixa[j] + '.cs2';
             Arquivo := Calc + 'LVC' + Rodov + Faixa[j] + '.csv';
             AssignFile(ArqDados, ArqXls);
             Reset(ArqDados);
             Readln(ArqDados, Linha);
             Linha1 := '';
             for k := 1 to Length(Linha) do
               if Linha[k] <> '"' then Linha1 := Linha1 + Linha[k];
             AssignFile(Arq, Arquivo);
             Rewrite(Arq);
             Writeln(Arq, Linha1);
             while not Eof(ArqDados) do
               begin
                 Readln(ArqDados, Linha);
                 Writeln(Arq, Linha);
               end;
             CloseFile(ArqDados);
             CloseFile(Arq);
         end;
     end;
     CloseFile(Arq1);
    { Converte de CSV para DBF }
      Excel := CreateOleObject('Excel.Application');
      Excel.Visible := False;
      AssignFile(Arq, 'Rod.dat');
      Reset(Arq);
      while not Eof(Arq) do
       begin
        Readln(Arq, Rodov);
        for j := 1 to 4 do
           begin
             Arquivo := Calc + 'LVC' + Rodov + Faixa[j] + '.csv';
             ArqDbf := Dados + 'LVC' + '_' + Rodov + Faixa[j] + '_' + Year + '.dbf';
             NFields := 39;
             AssignFile(Arq, Arquivo);
             Reset(Arq);
             Readln(Arq, Linha);
             with DataModule10.Table6 do
               begin
                 Active := False;
                 TableName := ArqDbf;
                 CreateTable;
                 Active := True;
                 Edit;
                 First;
               end;
             while not eof(Arq) do
               begin
                 Readln(Arq, Linha);
                 jj := 1;
                 for icont := 1 to NFields do
                   Campo[icont] := '';
                 for icont := 1 to Length(Linha) do
                   begin
                     if Linha[icont] = ',' then
                       jj := jj + 1
                     else
                       if Linha[icont] <> '"' then Campo[jj] := Campo[jj] + Linha[icont];
                   end;
                 if ConfReg = 'Portuguese' then
                   begin
                     for jl := 2 to 4 do
                       begin
                         for jk := 1 to Length(Campo[jl]) do
                           if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                       end;
                     for jl := 36 to 37 do
                       begin
                         for jk := 1 to Length(Campo[jl]) do
                           if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                       end;
                   end;
                 DataModule10.Table6.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                   StrToFloat(Campo[4]),Campo[5],Campo[6],Campo[7],Campo[8],Campo[9],Campo[10],Campo[11],
                   Campo[12],Campo[13],Campo[14],Campo[15],Campo[16],Campo[17],Campo[18],Campo[19],
                   Campo[20],Campo[21],Campo[22],Campo[23],Campo[24],Campo[25],Campo[26],Campo[27],
                   Campo[28],Campo[29],Campo[30],Campo[31],Campo[32],Campo[33],Campo[34],Campo[35],
                   StrToFloat(Campo[36]),StrToFloat(Campo[37]),Campo[38],Campo[39]]);
               end;
             DataModule10.Table6.Close;
             DataModule10.Table6.Active := False;
             CloseFile(Arq);
           end;
       end;
       CloseFile(Arq);
  Screen.Cursor := crDefault;
  Close;
end;

procedure TForm49.BitBtn7Click(Sender: TObject);
var
  Ano, NPeriodos, i, NRodov: integer;
  Arquivo, Programa, Dados, Calc, DadosAnoBase, Tipo, UsaCs1: string;
  ArqDados, Arq: TextFile;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Rodovia, Rod: array [1..350] of string[4];
begin
  Screen.Cursor := crHourglass;
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
    Arquivo := Calc + 'TipoLev.dat';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Tipo);
    CloseFile(ArqDados);
    if CheckBox5.Checked then UsaCs1 := 'Sim' else UsaCs1 := 'No';
    Arquivo := Calc + 'UsaCs1.dat';
    AssignFile(ArqDados, Arquivo);
    Rewrite(ArqDados);
    Writeln(ArqDados, UsaCs1);
    CloseFile(ArqDados);
  { Cdigos de identificao das rodovias que compem a rede }
   Arquivo := Dados + 'Rodovias.dat';
   AssignFile(ArqDados, Arquivo);
   Reset(ArqDados);
   Readln(ArqDados, NRodov);
   AssignFile(Arq, Calc + 'Rod.dat');
   Rewrite(Arq);
   for i := 1 to NRodov do
     begin
       Readln(ArqDados, Rodovia[i]);
       Arquivo := Calc + Tipo + Rodovia[i] + '1.csv';
       if FileExists(Arquivo) then
         begin
           Arquivo := DadosAnoBase + 'ATR\' + Rodovia[i] + '.csv';
           if FileExists(Arquivo) then Writeln(Arq, Rodovia[i]);
         end;
     end;
   CloseFile(ArqDados);
   CloseFile(Arq);
   Arquivo := 'DOS.DAT';
   if FileExists(Arquivo) then
     begin
       AssignFile(ArqDados, Arquivo);
       Erase(ArqDados)
     end;
   WinExec('FichaIGG.exe /c', SW_HIDE);
   Flag := 0;
   StartTime := now;
   NumSec := 10;
   repeat
     Application.ProcessMessages;
     if FileExists(Arquivo) then Flag := 1;
   until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
   Arquivo := 'DOS2.DAT';
   if FileExists(Arquivo) then
     begin
       AssignFile(ArqDados, Arquivo);
       Erase(ArqDados)
     end;
   WinExec('CalcIGG.exe /c', SW_HIDE);
   Flag := 0;
   StartTime := now;
   NumSec := 10;
   repeat
     Application.ProcessMessages;
     if FileExists(Arquivo) then Flag := 1;
   until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  Screen.Cursor := crDefault;
  Close;
end;

procedure TForm49.Button1Click(Sender: TObject);
var
  Arquivo, Programa, Dados, Calc, DadosAnoBase, ArqOut: string;
  ArqDados: TextFile;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Ano, NPeriodos, NRodov, i: integer;
  Rodov: array [1..350] of string[4];
begin
  Screen.Cursor := crHourglass;
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodov[i]);
  CloseFile(ArqDados);
  for i := 1 to NRodov do
    begin
      Arquivo := DadosAnoBase + 'PCI\' + Rodov[i] + '.csv';
      if FileExists(Arquivo) then
        begin
          ArqOut := Calc + 'ArqPCI.dat';
          AssignFile(ArqDados, ArqOut);
          Rewrite(ArqDados);
          Writeln(ArqDados, Rodov[i]);
          CloseFile(ArqDados);
          Arquivo := 'DOS.DAT';
          if FileExists(Arquivo) then
            begin
              AssignFile(ArqDados, Arquivo);
              Erase(ArqDados)
            end;
          WinExec('PCI.exe /c', SW_HIDE);
          Flag := 0;
          StartTime := now;
          NumSec := 5;
          repeat
            Application.ProcessMessages;
            if FileExists(Arquivo) then Flag := 1;
          until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
        end;
    end;
  Screen.Cursor := crDefault;
end;

procedure TForm49.CheckBox5Click(Sender: TObject);
begin
  if CheckBox5.Checked = True then CheckBox6.Checked := False;
  if CheckBox5.Checked = False then CheckBox6.Checked := True;
end;

procedure TForm49.CheckBox6Click(Sender: TObject);
begin
  if CheckBox6.Checked = True then CheckBox5.Checked := False;
  if CheckBox6.Checked = False then CheckBox5.Checked := True;
end;

procedure TForm49.BitBtn8Click(Sender: TObject);
const
  NFaixasMax = 4;
var
  Excel: OleVariant;
  Ano, FileCodeExcel, NRodov, i, NPP, icont, j, IRodov, NFields, jcont, IFaixa,
    IPar: integer;
  ArqDados, ArqOut, Arq, ArqIn, ArqDel: TextFile;
  Programa, Dados, Calc, Arquivo, ArqXls, ArqCsv, Linha, DadosAnoBase, Dat, NomeArq,
    km, Carga, Bloc, Tar, Tsup, kmi, kmf, IRI, ATResq, ATRdir, PastaDados, LinhaOut,
    Pista, NFaixas, LargFaixa, LargAcost, TTm2, TBm2, TLm2, CR1m2, CR2m2, APLm2, DGm2,
    EXm2, AF1m2, AF2m2, AF3m2, PAm2, R1m2, R2m2, CORm2, DNm2, ArqDbf, Lado: string;
  QI, kminiFx3, kmfimFx3, LFx, LAc, Altitude, kmP, Dist: Single;
  Df: array [1..7] of string[10];
  Rodovia: array [1..300] of string[5];
  Year, Rodov: string[5];
  NumSec: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string[150];
  Trecho: string[7];
  Faixa: string[1];
  Achou: Boolean;
begin
{  Screen.Cursor := crHourglass;
  DataModule10.Table2.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, Programa);
  Readln(ArqDados, PastaDados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, Dados);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  { Cdigos de identificao das rodovias onde os pavimentos foram avaliados }
{  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  Dat := DadosAnoBase;
  Bloc := ',0,20,30,45,60,90,120,30,Fev. 2013,FWD';
  Excel := CreateOleObject('Excel.Application');
  Excel.Visible := False;
  for IRodov := 1 to NRodov do
    begin
     { Converte as planilhas Excel do FWD para *.csv }
{      for IFaixa := 1 to NFaixasMax do
       begin
         Trecho := TrechoDat[IRodov];
         NomeArq := 'FWD_' + Trecho + '_' + IntToStr(IFaixa);
         Arquivo := Dat + Trecho + '\FWD\' + NomeArq + '.xls';
         if FileExists(Arquivo) then
           begin
             ArqCsv := DadosAnoBase + 'Csv\Temp\' + Rodovia[IRodov] + '_' + IntToStr(IFaixa) + '.csv';
             if FileExists(ArqCsv) then
               begin
                 AssignFile(ArqOut, ArqCsv);
                 Erase(ArqOut);
               end;
             FileCodeExcel := 1;
             Excel.Workbooks.Open(Arquivo, True, FileCodeExcel);
             Excel.Workbooks.Add;
             Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
             Excel.Workbooks[2].Sheets[1].PasteSpecial;
             FileCodeExcel := 6;
             Excel.Workbooks[2].Sheets[1].SaveAs(ArqCsv, FileCodeExcel);
             Excel.Workbooks[2].Saved := True;
             Excel.Workbooks.Close;
             { Altera o formato dos dados }
{             Arquivo := DadosAnoBase + 'Csv\Deflex\' + Rodovia[IRodov] + '_' + IntToStr(IFaixa) + '.csv';
             AssignFile(ArqOut, Arquivo);
             Rewrite(ArqOut);
             Linha := 'km,Carga (kgf),Df1,Df2,Df3,Df4,Df5,Df6,Df7,Tar,Tsup,R1,R2,R3,R4,R5,R6,R7,D placa,Data,Equipamento';
             Writeln(ArqOut, Linha);
             AssignFile(ArqIn, ArqCsv);
             Reset(ArqIn);
             NFields := 15;
             for i := 1 to 5 do
               Readln(ArqIn, Linha);
               while not Eof(ArqIn) do
                 begin
                   Readln(ArqIn, Linha);
                   j := 1;
                   for i := 1 to NFields do
                     Campo[i] := '';
                   for i := 1 to Length(Linha) do
                     if Linha[i] = ',' then
                       j := j + 1
                     else
                      Campo[j] := Campo[j] + Linha[i];
                   km := '';
                   for i := 1 to Length(Campo[1]) do
                   begin
                     if Campo[1,i] <> ' ' then
                       if Campo[1,i] <> '+' then km := km + Campo[1,i] else km := km + '.';
                   end;
                 Carga := Campo[4];
                  for i := 1 to 7 do
                    Df[i] := Campo[4+i];
                  Tar := Campo[12];
                  Tsup := Campo[13];
                 if Length(Carga) >= 4 then
                   begin
                     Linha := km + ',' + Carga + ',' + Df[1]+ ',' + Df[2]+ ',' + Df[3]+ ',' + Df[4]+ ',' + Df[5]+ ',' + Df[6]+ ',' + Df[7] + ',' + Tar + ',' + Tsup;
                     Linha := Linha + Bloc;
                     Writeln(ArqOut, Linha);
                   end;
               end;
             CloseFile(ArqIn);
             CloseFile(ArqOut);
           end;
       end;
       Label25.Caption := 'Convertendo os arquivos de deflexes ...';
    end;
  ArqDbf := Calc + 'TercFaixas.dbf';
  if FileExists(ArqDbf) then
    begin
      AssignFile(ArqDel, ArqDbf);
      Erase(ArqDel);
    end;
  DataModule4.Table11.Active := False;
  DataModule4.Table11.TableName := ArqDbf;
  DataModule4.Table11.CreateTable;
  DataModule4.Table11.Active := True;
  DataModule4.Table11.Edit;
  DataModule4.Table11.First;
  Arquivo := Dat + 'Laser.txt';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while not Eof(Arq) do
    begin
     { Converte as planilhas Excel da Barra Laser para *.csv }
{       Readln(Arq, Linha);
       NFields := 3;
       j := 1;
       for i := 1 to NFields do
         Campo[i] := '';
       for i := 1 to Length(Linha) do
         if Linha[i] = ',' then
           j := j + 1
         else
           Campo[j] := Campo[j] + Linha[i];
       Trecho := Campo[1];
       NomeArq := Campo[2];
       IFaixa := StrToInt(Campo[3]);
       Rodov := 'T';
       for j := 4 to Length(Trecho) do
        Rodov := Rodov + Trecho[j];
       Achou := False;
       Arquivo := Dat + Trecho + '\Laser\IRI (200)_' + NomeArq + '.xls';
       if FileExists(Arquivo) then
         begin
           Achou := True;
           ArqXls := Arquivo;
         end;
       Arquivo := Dat + Trecho + '\Laser\IRI(200)_' + NomeArq + '.xls';
       if FileExists(Arquivo) then
         begin
           Achou := True;
           ArqXls := Arquivo;
         end;
       Arquivo := Dat + Trecho + '\Laser\IRI_' + NomeArq + '.xls';
       if FileExists(Arquivo) then
         begin
           Achou := True;
           ArqXls := Arquivo;
         end;
       Arquivo := Dat + Trecho + '\Laser\IRI (200) ' + NomeArq + '.xls';
       if FileExists(Arquivo) then
         begin
           Achou := True;
           ArqXls := Arquivo;
         end;
       if Achou then
         begin
           ArqCsv := DadosAnoBase + 'Csv\Temp\IRI_' + NomeArq + '.csv';
           if FileExists(ArqCsv) then
             begin
               AssignFile(ArqOut, ArqCsv);
               Erase(ArqOut);
             end;
           FileCodeExcel := 1;
           Excel.Workbooks.Open(ArqXls, True, FileCodeExcel);
           Excel.Workbooks.Add;
           Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
           Excel.Workbooks[2].Sheets[1].PasteSpecial;
           FileCodeExcel := 6;
           Excel.Workbooks[2].Sheets[1].SaveAs(ArqCsv, FileCodeExcel);
           Excel.Workbooks[2].Saved := True;
           Excel.Workbooks.Close;
         end;
       Achou := False;
       Arquivo := Dat + Trecho + '\Laser\ATR (10)_' + NomeArq + '.xls';
       if FileExists(Arquivo) then
         begin
           Achou := True;
           ArqXls := Arquivo;
         end;
       Arquivo := Dat + Trecho + '\Laser\ATR(10)_' + NomeArq + '.xls';
       if FileExists(Arquivo) then
         begin
           Achou := True;
           ArqXls := Arquivo;
         end;
       Arquivo := Dat + Trecho + '\Laser\ATR (10)_' + NomeArq + '.xls';
       if FileExists(Arquivo) then
         begin
           Achou := True;
           ArqXls := Arquivo;
         end;
       Arquivo := Dat + Trecho + '\Laser\ATR_' + NomeArq + '.xls';
       if FileExists(Arquivo) then
         begin
           Achou := True;
           ArqXls := Arquivo;
         end;
       Arquivo := Dat + Trecho + '\Laser\ATR (10) ' + NomeArq + '.xls';
       if FileExists(Arquivo) then
         begin
           Achou := True;
           ArqXls := Arquivo;
         end;
       if Achou then
         begin
           ArqCsv := DadosAnoBase + 'Csv\Temp\ATR_' + NomeArq + '.csv';
           if FileExists(ArqCsv) then
             begin
               AssignFile(ArqOut, ArqCsv);
               Erase(ArqOut);
             end;
           FileCodeExcel := 1;
           Excel.Workbooks.Open(ArqXls, True, FileCodeExcel);
           Excel.Workbooks.Add;
           Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
           Excel.Workbooks[2].Sheets[1].PasteSpecial;
           FileCodeExcel := 6;
           Excel.Workbooks[2].Sheets[1].SaveAs(ArqCsv, FileCodeExcel);
           Excel.Workbooks[2].Saved := True;
           Excel.Workbooks.Close;
         end;
     { Gera os arquivos *.csv da base de dados para a Barra Laser }
{     for IPar := 1 to 2 do
      begin
       if IPar = 1 then
        begin
          Arquivo := DadosAnoBase + 'Csv\Temp\IRI' + NomeArq + '.csv';
          ArqCsv := DadosAnoBase + 'Csv\Temp\IRI_' + NomeArq + '.csv';
        end
       else
        begin
          Arquivo := DadosAnoBase + 'Csv\Temp\ATR' + NomeArq + '.csv';
          ArqCsv := DadosAnoBase + 'Csv\Temp\ATR_' + NomeArq + '.csv';
        end;
       AssignFile(ArqOut, Arquivo);
       Rewrite(ArqOut);
       if not FileExists(ArqCsv) then ShowMessage('Arquivo no existe: ' + ArqCsv);
       AssignFile(ArqIn, ArqCsv);
       Reset(ArqIn);
       while not Eof(ArqIn) do
        begin
          Readln(ArqIn, Linha);
          if Linha <> '' then
            begin
              LinhaOut := '';
              Achou := False;
              for i := 1 to Length(Linha) do
                begin
                  if (Linha[i] = '"') and (Achou = False) then
                    Achou := True
                  else
                    begin
                      if Achou then
                        begin
                          if Linha[i] = ',' then
                            LinhaOut := LinhaOut + '.'
                          else
                            if Linha[i] = '"' then
                              Achou := False
                            else
                              if Linha[i] = '+' then LinhaOut := LinhaOut + '.' else LinhaOut := LinhaOut + Linha[i];
                        end
                      else
                        if Linha[i] = '+' then LinhaOut := LinhaOut + '.' else LinhaOut := LinhaOut + Linha[i];
                    end;
                end;
              Writeln(ArqOut, LinhaOut);
            end;
        end;
       CloseFile(ArqIn);
       CloseFile(ArqOut);
      end;
     { Irregularidade Longitudinal }
{       Arquivo := DadosAnoBase + 'Csv\QI\' + Rodov + '_' + IntToStr(IFaixa) + '.csv';
       ArqCsv := DadosAnoBase + 'Csv\Temp\IRI' + NomeArq + '.csv';
       Linha := 'kmini,kmfim,QI,Data,Equipamento';
       AssignFile(ArqOut, Arquivo);
       Rewrite(ArqOut);
       Writeln(ArqOut, Linha);
       if not FileExists(ArqCsv) then ShowMessage(ArqCsv);
       AssignFile(ArqIn, ArqCsv);
       Reset(ArqIn);
       NFields := 15;
       for i := 1 to 20 do
         Readln(ArqIn, Linha);
       while not Eof(ArqIn) do
        begin
         Readln(ArqIn, Linha);
         if Linha <> '' then
          begin
           j := 1;
           for i := 1 to NFields do
             Campo[i] := '';
           for i := 1 to Length(Linha) do
             if Linha[i] = ',' then
               j := j + 1
             else
               Campo[j] := Campo[j] + Linha[i];
              kmi := Campo[2];
              kmf := Campo[3];
              if (kmi <> '') and (kmf <> '') then
                begin
                  IRI := Campo[6];
                  if (IRI = '-') or (IRI = '') then QI := -1 else QI := 13 * StrToFloat(IRI);
                  Bloc := FloatToStr(QI) + ',' + 'Abr. 2012,Laser';
                  Linha := kmi + ',' + kmf + ',' + Bloc;
                  Writeln(ArqOut, Linha);
                end
          end;
        end;
       CloseFile(ArqIn);
       CloseFile(ArqOut);
     { Afundamentos em Trilha de Roda }
{       Arquivo := DadosAnoBase + 'Csv\ATR\' + Rodov + '_' + IntToStr(IFaixa) + '.csv';
       ArqCsv := DadosAnoBase + 'Csv\Temp\ATR' + NomeArq + '.csv';
       Linha := 'km,ATResq,ATRdir,Data,Equipamento';
       AssignFile(ArqOut, Arquivo);
       Rewrite(ArqOut);
       Writeln(ArqOut, Linha);
       if not FileExists(ArqCsv) then ShowMessage(ArqCsv);
       AssignFile(ArqIn, ArqCsv);
       Reset(ArqIn);
       icont := 0;
       NFields := 15;
       for i := 1 to 20 do
         Readln(ArqIn, Linha);
       while not Eof(ArqIn) do
        begin
         Readln(ArqIn, Linha);
         if Linha <> '' then
          begin
           j := 1;
           for i := 1 to NFields do
             Campo[i] := '';
           for i := 1 to Length(Linha) do
             if Linha[i] = ',' then
               j := j + 1
             else
               Campo[j] := Campo[j] + Linha[i];
              km := Campo[2];
              if (km <> '') and (km <> Null) then
                begin
                  if (Campo[3] = '-') or (Campo[3] = '') then ATResq := '-1' else ATResq := Campo[3];
                  if (Campo[4] = '-') or (Campo[4] = '') then ATRdir := '-1' else ATRdir := Campo[4];
                  Linha := km + ',' + ATResq + ',' + ATRdir + ',' + 'Abr. 2012,Laser';
                  kmP := StrToFloat(km);
                  if IFaixa > 2 then
                    begin
                      if icont = 0 then
                        begin
                          icont := icont + 1;
                          if (StrToFloat(ATResq) >= 0) and (StrToFloat(ATRdir) >= 0) then
                            begin
                              kminiFx3 := kmP;
                              kmfimFx3 := kmP;
                            end;
                        end
                      else
                        begin
                          Dist := 1000 * Abs(kmP-kmfimFx3);
                          if Dist > 50 then
                            begin
                              if IFaixa = 3 then Lado := 'Esquerdo' else Lado := 'Direito';
                              DataModule4.Table11.InsertRecord([Rodov, kminiFx3, kmfimFx3, Lado]);
                              icont := 0;
                              kminiFx3 := kmP;
                            end;
                          kmfimFx3 := kmP;
                        end;
                    end;
                  Writeln(ArqOut, Linha);
                end;
          end;
        end;
       CloseFile(ArqIn);
       CloseFile(ArqOut);
     Label25.Caption := 'Arquivos da barra laser do trecho ' + Rodov;
    end;
  CloseFile(Arq);
  DataModule4.Table11.Close;
  DataModule4.Table11.Active := False;
  Excel.Quit;
if Screen.Cursor = crHourglass then
 begin
   BitBtn5.Visible := False;
   AssignFile(ArqDados, 'Clear.bat');
   Rewrite(ArqDados);
   Arquivo := DadosAnoBase + 'Csv\Temp\*.csv';
   Writeln(ArqDados, 'Erase ', Arquivo);
   CloseFile(ArqDados);
   WinExec('Clear.bat /c', SW_HIDE);
   StartTime := now;
   NumSec := 5;
   repeat
     Application.ProcessMessages;
   until Now > StartTime + NumSec * (1/24/60/60);
   Screen.Cursor := crDefault;
 end;
}
end;

initialization
  CoInitialize (nil);

end.
