unit Unit47;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons;

type
  TForm47 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    GroupBox1: TGroupBox;
    Label8: TLabel;
    ComboBox8: TComboBox;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    Label2: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    BitBtn2: TBitBtn;
    procedure PlanoPlurianualdeInvestimentos1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form47: TForm47;

implementation

uses Childwin, Unit24, Unit48, Unit57, Unit64, Unit73, Unit74, Unit75,
  Unit76, Unit77;

{$R *.DFM}

procedure TForm47.PlanoPlurianualdeInvestimentos1Click(Sender: TObject);
begin
  MDIChild.PlanoPlurianualdeInvestimentos1Click(Sender);
end;

procedure TForm47.BitBtn1Click(Sender: TObject);
begin
  QRListForm6.MasterTable.Active := False;
  QRListForm11.MasterTable.Active := False;
  QRListForm14.MasterTable.Active := False;
  QRListForm19.MasterTable.Active := False;
  QRListForm20.MasterTable.Active := False;
  Close;
end;

procedure TForm47.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox8.Items.LoadFromFile(Arquivo);
end;

procedure TForm47.ComboBox1Change(Sender: TObject);
begin
  ComboBox8.Text := '';
end;

procedure TForm47.ComboBox2Change(Sender: TObject);
var
  Trecho: Boolean;
begin
  Trecho := True;
  if ComboBox2.Text = 'Custos das Intervenes por Trecho' then Trecho := False;
  if ComboBox2.Text = 'Parmetros de Configurao para a Rede' then Trecho := False;
  if ComboBox2.Text = 'Quantitativos dos Servios na Pista em toda a Rede' then Trecho := False;
  if ComboBox2.Text = 'Quantitativos dos Servios nos Acostamentos em toda a Rede' then Trecho := False;
  if not Trecho then
    begin
      ComboBox8.Visible := False;
      Label8.Caption := '';
    end
  else
    begin
      Label8.Caption := 'Trecho:';
      ComboBox8.Text := '';
      ComboBox8.Visible := True;
    end;
end;

procedure TForm47.BitBtn2Click(Sender: TObject);
var
  ArqDados, Arq: TextFile;
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, ArqDbf, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome, Estrategia: string[4];
begin
  if ComboBox1.Text <> '' then
    if ComboBox2.Text <> '' then
        begin
          AssignFile(ArqDados, 'Diretor.dat');
          Reset(ArqDados);
          Readln(ArqDados, Ano);
          Readln(ArqDados, NPeriodos);
          Readln(ArqDados, Programa);
          Readln(ArqDados, Dados);
          Readln(ArqDados, Calc);
          Readln(ArqDados, DadosAnoBase);
          CloseFile(ArqDados);
          Year := IntToStr(Ano);
          Arquivo := DadosAnoBase + 'Trechos.dat';
          AssignFile(ArqDados, Arquivo);
          Reset(ArqDados);
          Arquivo := DadosAnoBase + 'Trechos.dsc';
          AssignFile(Arq, Arquivo);
          Reset(Arq);
          while Eof(ArqDados) = False do
            begin
              Readln(ArqDados, Local);
              Readln(Arq, Nome);
              if ComboBox8.Text = Local then Trecho := Nome;
            end;
          CloseFile(ArqDados);
          CloseFile(Arq);
          Polo := '';
          if ComboBox1.Text = 'Necessidades Atuais de Manuteno' then Estrategia := 'NAT';
          if ComboBox1.Text = 'Estratgia-Base' then Estrategia := 'EB';
          if ComboBox1.Text = 'Estratgia sob Restries' then Estrategia := 'RO';
          Arquivo := Calc + 'Local.dat';
          AssignFile(ArqDados, Arquivo);
          Rewrite(ArqDados);
          Writeln(ArqDados, Polo);
          Writeln(ArqDados, ComboBox8.Text);
          Writeln(ArqDados, Trecho);
          Writeln(ArqDados, Estrategia);
          CloseFile(ArqDados);
          if ComboBox2.Text = 'Intervenes de Manuteno na Pista' then QRListForm6.Preview;
          if ComboBox2.Text = 'Intervenes de Manuteno nos Acostamentos' then
            begin
              QRListForm18.MasterTable.Active := False;
              QRListForm18.QRSysData1.Text := ComboBox1.Text;
              QRListForm18.QRLabel11.Caption := 'Trecho: ' + ComboBox8.Text;
              QRListForm18.QuickRep1.Preview;
            end;
          if ComboBox2.Text = 'Custos das Intervenes por Subtrecho' then QRListForm11.Preview;
          if ComboBox2.Text = 'Custos das Intervenes por Trecho' then
            begin
              QRListForm14.MasterTable.Active := False;
              QRListForm14.MasterTable.TableName := Estrategia + 'Custo.dbf';
              QRListForm14.QRSysData1.Text := 'Custos da ' + ComboBox1.Text;
              QRListForm14.QuickRep1.Preview;
            end;
          if ComboBox2.Text = 'Parmetros de Configurao para a Rede' then
            begin
              QRListForm17.QRSysData1.Text := ComboBox2.Text;
              QRListForm17.QRLabel1.Caption := ComboBox1.Text;
              QRListForm17.QuickRep1.Preview;
            end;
          if ComboBox2.Text = 'Parmetros de Configurao por Trecho' then
            begin
              QRListForm21.QRSysData1.Text := ComboBox2.Text;
              QRListForm21.QRLabel3.Caption := 'Trecho: ' + ComboBox8.Text;
              QRListForm21.QuickRep1.Preview;
            end;
          if ComboBox2.Text = 'Quantitativos dos Servios na Pista em toda a Rede' then
            begin
              QRListForm19.MasterTable.Active := False;
              QRListForm19.QRSysData1.Text := 'Quantitativos dos Servios na Pista';
              QRListForm19.QRLabel2.Caption := ComboBox1.Text;
              QRListForm19.MasterTable.TableName := Calc + Estrategia + 'Pista.dbf';
              QRListForm19.QRLabel14.Caption := '';
              QRListForm19.QuickRep1.Preview;
            end;
          if ComboBox2.Text = 'Quantitativos dos Servios nos Acostamentos em toda a Rede' then
            begin
              QRListForm20.MasterTable.Active := False;
              QRListForm20.QRSysData1.Text := 'Quantitativos dos Servios nos Acostamentos';
              QRListForm20.QRLabel3.Caption := ComboBox1.Text;
              QRListForm20.MasterTable.TableName := Calc + Estrategia + 'Acost.dbf';
              QRListForm20.QRLabel11.Caption := '';
              QRListForm20.QuickRep1.Preview;
            end;
          if ComboBox2.Text = 'Quantitativos dos Servios na Pista em um Trecho' then
            begin
              QRListForm19.MasterTable.Active := False;
              QRListForm19.QRSysData1.Text := 'Quantitativos dos Servios na Pista';
              QRListForm19.QRLabel2.Caption := ComboBox1.Text;
              QRListForm19.MasterTable.TableName := Calc + Estrategia + Trecho + 'PT.dbf';
              QRListForm19.QRLabel14.Caption := 'Trecho:' + ComboBox8.Text;
              QRListForm19.QuickRep1.Preview;
            end;
          if ComboBox2.Text = 'Quantitativos dos Servios nos Acostamentos em um Trecho' then
            begin
              QRListForm20.MasterTable.Active := False;
              QRListForm20.QRSysData1.Text := 'Quantitativos dos Servios nos Acostamentos';
              QRListForm20.QRLabel3.Caption := ComboBox1.Text;
              QRListForm20.MasterTable.TableName := Calc + Estrategia + Trecho + 'AC.dbf';
              QRListForm20.QRLabel11.Caption := 'Trecho:' + ComboBox8.Text;
              QRListForm20.QuickRep1.Preview;
            end;
        end;
end;

end.
