unit Unit35;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, TeEngine, Series, TeeProcs, Chart,
  DBChart;

type
  TForm35 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    GroupBox1: TGroupBox;
    BitBtn1: TBitBtn;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    ComboBox4: TComboBox;
    ComboBox5: TComboBox;
    DBChart1: TDBChart;
    Series1: TLineSeries;
    BitBtn2: TBitBtn;
    CheckBox1: TCheckBox;
    Label1: TLabel;
    ComboBox1: TComboBox;
    DBChart2: TDBChart;
    Series2: TLineSeries;
    Series3: TLineSeries;
    DBChart3: TDBChart;
    Series4: TLineSeries;
    Series5: TLineSeries;
    Series6: TLineSeries;
    DBChart4: TDBChart;
    Series7: TLineSeries;
    Series8: TLineSeries;
    Series9: TLineSeries;
    Series10: TLineSeries;
    DBChart5: TDBChart;
    Series11: TLineSeries;
    Series12: TLineSeries;
    Series13: TLineSeries;
    Series14: TLineSeries;
    Series15: TLineSeries;
    procedure VariaoaoLongodeumTrecho1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure ComboBox5Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form35: TForm35;

implementation

uses Childwin, Unit24, ComObj, ActiveX, Printers, Unit94;

{$R *.DFM}

procedure TForm35.VariaoaoLongodeumTrecho1Click(Sender: TObject);
begin
  MDIChild.VariaoaoLongodeumTrecho1Click(Sender);
end;

procedure TForm35.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm35.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  DBChart5.Hide;
  DBChart5.Visible := False;
  DBChart4.Hide;
  DBChart4.Visible := False;
  DBChart3.Hide;
  DBChart3.Visible := False;
  DBChart2.Hide;
  DBChart2.Visible := False;
  DBChart1.Hide;
  DBChart1.Visible := False;
  CheckBox1.Visible := False;
  BitBtn2.Visible := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox2.Items.LoadFromFile(Arquivo);
end;

procedure TForm35.ComboBox4Change(Sender: TObject);
var
  ArqDados: TextFile;
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Year: string[4];
begin
  CheckBox1.Visible := False;
  BitBtn2.Visible := False;
  ComboBox5.Text := '';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  { Carrega a lista de parmetros disponveis }
  if ComboBox4.Text = 'Trfego' then
    begin
      Arquivo := 'Trafego.dat';
      ComboBox5.Items.LoadFromFile(Arquivo);
    end;
  if ComboBox4.Text = 'Acostamentos' then
    begin
      Arquivo := 'Acostam.dat';
      ComboBox5.Items.LoadFromFile(Arquivo);
    end;
  if ComboBox4.Text = 'Dados Cadastrais' then
    begin
      Arquivo := 'Cadastro.dat';
      ComboBox5.Items.LoadFromFile(Arquivo);
    end;
  if ComboBox4.Text = 'Estado de Superfcie' then
    begin
      Arquivo := 'EstSup.dat';
      ComboBox5.Items.LoadFromFile(Arquivo);
    end;
  if ComboBox4.Text = 'Condio Funcional' then
    begin
      Arquivo := 'Funcio.dat';
      ComboBox5.Items.LoadFromFile(Arquivo);
    end;
  if ComboBox4.Text = 'Avaliao Estrutural' then
    begin
      Arquivo := 'Deflex.dat';
      ComboBox5.Items.LoadFromFile(Arquivo);
    end;
  if ComboBox4.Text = 'Estrutura do Pavimento' then
    begin
      Arquivo := 'Estr.dat';
      ComboBox5.Items.LoadFromFile(Arquivo);
    end;
end;

procedure TForm35.ComboBox5Change(Sender: TObject);
var
  ArqDados, Arq: TextFile;
  Ano, NPeriodos, i, j, icont, NFields, jk: integer;
  Programa, Dados, Calc, Arquivo, ArqDbf, Rede, Variavel, Param, TipoDado,
    Polo, Local, Modo, DadosAnoBase, Linha, ArqOut, ConfReg: string;
  Faixa: string[5];
  Year: string[4];
  Trecho, Nome: string[4];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string;
begin
if ComboBox5.Text <> '' then
 if ComboBox2.Text <> '' then
  if ComboBox3.Text <> '' then
  begin
   Screen.Cursor := crHourglass;
   Polo := '';
   CheckBox1.Visible := False;
   BitBtn2.Visible := False;
   DBChart1.Title.Text.Clear;
   DBChart2.Title.Text.Clear;
   DBChart3.Title.Text.Clear;
   DBChart4.Title.Text.Clear;
   DBChart5.Title.Text.Clear;
   Modo := 'Grafico';
   AssignFile(ArqDados, 'Diretor.dat');
   Reset(ArqDados);
   Readln(ArqDados, Ano);
   Readln(ArqDados, NPeriodos);
   Readln(ArqDados, Programa);
   Readln(ArqDados, Dados);
   Readln(ArqDados, Calc);
   Readln(ArqDados, DadosAnoBase);
   CloseFile(ArqDados);
   Year := IntToStr(Ano);
   AssignFile(ArqDados, 'Config.dat');
   Reset(ArqDados);
   Readln(ArqDados, ConfReg);
   CloseFile(ArqDados);
   Rede := 'Um Trecho';
   Faixa := ComboBox3.Text;
   TipoDado := ComboBox4.Text;
   Variavel := ComboBox5.Text;
   Arquivo := DadosAnoBase + 'Trechos.dat';
   AssignFile(ArqDados, Arquivo);
   Reset(ArqDados);
   Arquivo := DadosAnoBase + 'Trechos.dsc';
   AssignFile(Arq, Arquivo);
   Reset(Arq);
   while Eof(ArqDados) = False do
     begin
       Readln(ArqDados, Local);
       Readln(Arq, Nome);
       if ComboBox2.Text = Local then Trecho := Nome;
     end;
   CloseFile(ArqDados);
   CloseFile(Arq);
   DBChart1.Hide;
   DBChart2.Hide;
   DBChart3.Hide;
   DBChart4.Hide;
   DBChart5.Hide;
   DataModule24.Table13.Active := False;
   DataModule24.Table36.Active := False;
   Arquivo := Calc + 'ParamVar.dat';
   AssignFile(ArqDados, Arquivo);
   Rewrite(ArqDados);
   Writeln(ArqDados, Rede);
   Writeln(ArqDados, Polo);
   Writeln(ArqDados, Trecho);
   Writeln(ArqDados, Faixa);
   Writeln(ArqDados, TipoDado);
   Writeln(ArqDados, Variavel);
   Writeln(ArqDados, Modo);
   CloseFile(ArqDados);
   Arquivo := Calc + 'AnoVar.dat';
   AssignFile(ArqDados, Arquivo);
   Rewrite(ArqDados);
   Writeln(ArqDados, ComboBox1.Text);
   CloseFile(ArqDados);
  { Gera os arquivos contendo as snteses dos dados da condio atual }
    Arquivo := Calc + 'Var.dbf';
    if FileExists(Arquivo) then
      begin
        AssignFile(ArqDados, Arquivo);
        Erase(ArqDados)
      end;
    Arquivo := Calc + 'Var0.dbf';
    if FileExists(Arquivo) then
      begin
        AssignFile(ArqDados, Arquivo);
        Erase(ArqDados)
      end;
    if ComboBox1.Text = 'Atual' then
      begin
        Arquivo := Calc + 'Var.csv';
        ArqDbf := Calc + 'Var.dbf';
      end
    else
      begin
        Arquivo := Calc + 'Var0.csv';
        ArqDbf := Calc + 'Var0.dbf';
      end;
    if FileExists(Arquivo) then
      begin
        AssignFile(ArqDados, Arquivo);
        Erase(ArqDados)
      end;
    ArqOut := 'DOS.DAT';
    if FileExists(ArqOut) then
      begin
        AssignFile(ArqDados, ArqOut);
        Erase(ArqDados)
      end;
    if ComboBox1.Text = 'Atual' then
      WinExec('Atual.exe /c', SW_HIDE)
    else
      WinExec('Compara.exe /c', SW_HIDE);
    Flag := 0;
    repeat
      Application.ProcessMessages;
      if FileExists(ArqOut) then Flag := Flag + 1;
    until (Flag > 5);
  { Converte os arquivos CSV para DBF }
  if ComboBox1.Text = 'Atual' then
    begin
      NFields := 2;
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      with DataModule24.Table13 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
            end;
          if ConfReg = 'Portuguese' then
            begin
              for jk := 1 to Length(Campo[1]) do
                if Campo[1,jk] = '.' then Campo[1,jk] := ',';
              for jk := 1 to Length(Campo[2]) do
                if Campo[2,jk] = '.' then Campo[2,jk] := ',';
            end;
          DataModule24.Table13.InsertRecord([StrToFloat(Campo[1]),StrToFloat(Campo[2])]);
        end;
      DataModule24.Table13.Close;
      DataModule24.Table13.Active := False;
      CloseFile(ArqDados);
    end
  else
    begin
      NFields := 6;
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      with DataModule24.Table36 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
            end;
          if ConfReg = 'Portuguese' then
            begin
              for j := 1 to 6 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
            end;
          DataModule24.Table36.InsertRecord([StrToFloat(Campo[1]),StrToFloat(Campo[2]),
            StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6])]);
        end;
      DataModule24.Table36.Close;
      DataModule24.Table36.Active := False;
      CloseFile(ArqDados);
    end;
    Flag := 0;
    StartTime := now;
    NumSec := 5;
    repeat
      Application.ProcessMessages;
      if FileExists(ArqDbf) then Flag := Flag + 1;
    until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag > 10);
    { Ativa a tabela e aciona o grfico }
    if ComboBox1.Text = 'Atual' then
      begin
        DataModule24.Table13.Active := True;;
        DBChart1.Align := alClient;
        DBChart1.Title.Text.Append(ComboBox4.Text);
        Param := ComboBox5.Text + ' na faixa de trfego ' + ComboBox3.Text;
        DBChart1.Title.Text.Append(Param);
        DBChart1.Show;
      end
    else
      begin
        DataModule24.Table36.Active := True;;
        Param := ComboBox5.Text + ' na faixa de trfego ' + ComboBox3.Text;
        if ComboBox1.Text = 'Atual e anterior' then
          begin
            DBChart2.Align := alClient;
            DBChart2.Title.Text.Append(ComboBox4.Text);
            DBChart2.Title.Text.Append(Param);
            DBChart2.Show;
          end;
        if ComboBox1.Text = 'Ultimos 3 anos' then
          begin
            DBChart3.Align := alClient;
            DBChart3.Title.Text.Append(ComboBox4.Text);
            DBChart3.Title.Text.Append(Param);
            DBChart3.Show;
          end;
        if ComboBox1.Text = 'Ultimos 4 anos' then
          begin
            DBChart4.Align := alClient;
            DBChart4.Title.Text.Append(ComboBox4.Text);
            DBChart4.Title.Text.Append(Param);
            DBChart4.Show;
          end;
        if ComboBox1.Text = 'Ultimos 5 anos' then
          begin
            DBChart5.Align := alClient;
            DBChart5.Title.Text.Append(ComboBox4.Text);
            DBChart5.Title.Text.Append(Param);
            DBChart5.Show;
          end;
      end;
   BitBtn2.Visible := True;
   CheckBox1.Visible := True;
   Screen.Cursor := crDefault;
  end;
end;

procedure TForm35.BitBtn2Click(Sender: TObject);
var h,w:longint;
begin
  Screen.Cursor := crHourGlass; { <-- nice detail }
  try
    Printer.BeginDoc;       { <-- start printer job }
    try
      { now print some text on printer.canvas }
      With Printer.Canvas do
      begin
        Font.Name:='Arial';
        Font.Size:=10;             { <-- set the font size }
        Font.Style:=[];
        TextOut(0,0,ComboBox2.Text);   { <-- print some text }
      end;

      h:=Printer.PageHeight; { <-- get page height }
      w:=Printer.PageWidth;  { <-- get page width }

      { And now print the chart component... }
      DBChart1.PrintPartial(  Rect(  w div 10,          { <-- left margin }
                                   h div 3 ,          { <-- top margin }
                                   w - (w div 10),    { <-- right margin }
                                   h - (h div 10) )); { <-- bottom margin }


      { print more text.... }
      With Printer.Canvas do
      begin
        Font.Name:='Arial';
        Font.Size:=12;             { <-- set the font size }
        Font.Style:=[fsItalic];
        TextOut(0,60,ComboBox3.Text);   { <-- print some text }
      end;

      Printer.EndDoc; { <-- end job and print !! }
    except
      on Exception do  { just in case an error happens... }
      Begin
        Printer.Abort;
        Printer.EndDoc;
        Raise;       { <-- raise up the exception !!! }
      end;
    end;
  finally
    Screen.Cursor:=crDefault; { <-- restore cursor }
  end;
end;

procedure TForm35.ComboBox2Change(Sender: TObject);
begin
  ComboBox5.Text := '';
  CheckBox1.Visible := False;
  BitBtn2.Visible := False;
end;

procedure TForm35.ComboBox3Change(Sender: TObject);
begin
  ComboBox5.Text := '';
  CheckBox1.Visible := False;
  BitBtn2.Visible := False;
end;

procedure TForm35.CheckBox1Click(Sender: TObject);
begin
  if ComboBox1.Text = 'Atual' then DBChart1.View3D := CheckBox1.Checked;
  if ComboBox1.Text = 'Atual e anterior' then DBChart2.View3D := CheckBox1.Checked;
  if ComboBox1.Text = 'Ultimos 3 anos' then DBChart3.View3D := CheckBox1.Checked;
  if ComboBox1.Text = 'Ultimos 4 anos' then DBChart4.View3D := CheckBox1.Checked;
  if ComboBox1.Text = 'Ultimos 5 anos' then DBChart5.View3D := CheckBox1.Checked;
end;

procedure TForm35.ComboBox1Change(Sender: TObject);
begin
  ComboBox5.Text := '';
end;

initialization
  CoInitialize (nil);

end.
