unit Unit34;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, TeEngine, Series, TeeProcs, Chart, DBChart,
  TeeFunci;

type
  TForm34 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    GroupBox1: TGroupBox;
    GroupBox3: TGroupBox;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label2: TLabel;
    ComboBox2: TComboBox;
    Label3: TLabel;
    ComboBox3: TComboBox;
    DBChart1: TDBChart;
    Series1: TPieSeries;
    BitBtn2: TBitBtn;
    Timer1: TTimer;
    BitBtn3: TBitBtn;
    procedure NecessidadesdeManuteno1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    { Private declarations }
      DeltaZoom:Integer;
  public
    { Public declarations }
  end;

var
  Form34: TForm34;

implementation

uses Childwin, Unit24, ComObj, ActiveX, Printers, Unit94;

{$R *.DFM}

procedure TForm34.NecessidadesdeManuteno1Click(Sender: TObject);
begin
  MDIChild.NecessidadesdeManuteno1Click(Sender);
end;

procedure TForm34.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm34.ComboBox1Change(Sender: TObject);
var
  ArqDados: TextFile;
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo: string;
  Year: string[4];
begin
  ComboBox2.Text := '';
  ComboBox3.Text := '';
  if ComboBox1.Text = 'Necessidades atuais de manuteno' then
    begin
      Label2.Visible := False;
      ComboBox2.Visible := False;
    end
  else
    begin
      Label2.Visible := True;
      ComboBox2.Visible := True;
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      CloseFile(ArqDados);
      Year := IntToStr(Ano);
      Arquivo := Calc + 'Years.dat';
      ComboBox2.Items.LoadFromFile(Arquivo);
    end;
end;

procedure TForm34.FormShow(Sender: TObject);
begin
  BitBtn2.Visible := False;
  DBChart1.Hide;
  DBChart1.Visible := False;
  DataModule24.Table12.Active := False;
end;

procedure TForm34.ComboBox2Change(Sender: TObject);
begin
  BitBtn2.Visible := False;
  ComboBox3.Text := '';
end;

procedure TForm34.BitBtn2Click(Sender: TObject);
var
  h,w:longint;
begin
  Screen.Cursor := crHourGlass; { <-- nice detail }
  try
    Printer.BeginDoc;       { <-- start printer job }
    try
      { now print some text on printer.canvas }
      With Printer.Canvas do
      begin
        Font.Name:='Arial';
        Font.Size:=10;             { <-- set the font size }
        Font.Style:=[];
        TextOut(0,0,'Intervenes de Manuteno');   { <-- print some text }
      end;

      h:=Printer.PageHeight; { <-- get page height }
      w:=Printer.PageWidth;  { <-- get page width }

      { And now print the chart component... }
      DBChart1.PrintPartial(  Rect(  w div 10,          { <-- left margin }
                                   h div 3 ,          { <-- top margin }
                                   w - (w div 10),    { <-- right margin }
                                   h - (h div 10) )); { <-- bottom margin }


      { print more text.... }
      With Printer.Canvas do
      begin
        Font.Name:='Arial';
        Font.Size:=12;             { <-- set the font size }
        Font.Style:=[fsItalic];
        TextOut(0,60,'');   { <-- print some text }
      end;

      Printer.EndDoc; { <-- end job and print !! }
    except
      on Exception do  { just in case an error happens... }
      Begin
        Printer.Abort;
        Printer.EndDoc;
        Raise;       { <-- raise up the exception !!! }
      end;
    end;
  finally
    Screen.Cursor:=crDefault; { <-- restore cursor }
  end;
end;

procedure TForm34.FormActivate(Sender: TObject);
begin
  BitBtn2.Visible := False;
  DataModule24.Table12.Active := False;
end;

procedure TForm34.Timer1Timer(Sender: TObject);
var tmp:Integer;
begin
  Series1.Rotate(5);
  With Series1 do
  begin
    tmp:=Random(Count);
    if ExplodedSlice[tmp]>20 then
       ExplodedSlice[tmp]:=ExplodedSlice[tmp]-1
    else
       ExplodedSlice[tmp]:=ExplodedSlice[tmp]+1;
  end;
end;

procedure TForm34.BitBtn3Click(Sender: TObject);
var
  ArqDados: TextFile;
  Ano, NPeriodos, NPP, j, icont, NFields, jk: integer;
  Programa, Dados, Calc, Arquivo, AnoFaixa, Arq2, Linha, ConfReg: string;
  Year: string[4];
  Excel: OleVariant;
  FileCodeExcel: integer;
  NParams, Modo: integer;
  Arquivos, ArqDbf: array[1..20] of string;
  PP, inf: Single;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Executa: Boolean;
  Campo: array [1..100] of string;
begin
 if ComboBox1.Text <> 'Necessidades atuais de manuteno' then
  begin
   if ComboBox2.Text <> '' then Executa := True else Executa := False;
  end
 else
  Executa := True;
 if ComboBox3.Text = '' then Executa := False;
 if Executa then
 begin
  Screen.Cursor := crHourglass;
  BitBtn2.Visible := False;
  DataModule24.Table12.Active := False;
  DBChart1.Title.Text.Clear;
  NPP := 1;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  DBChart1.Hide;
  if ComboBox1.Text = 'Necessidades atuais de manuteno' then Modo := 5;
  if ComboBox1.Text = 'Evoluo sem investimentos' then
    begin
      Modo := 0;
      Ano := StrToInt(ComboBox2.Text);
    end;
  if ComboBox1.Text = 'Estratgia-base' then
    begin
      Modo := 1;
      Ano := StrToInt(ComboBox2.Text);
    end;
  if ComboBox1.Text = 'Estratgia sob restries oramentrias' then
    begin
      Modo := 2;
      Ano := StrToInt(ComboBox2.Text);
    end;
  Arquivo := Calc + 'Modo.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Modo);
  CloseFile(ArqDados);
  Arquivo := Calc + 'Ano.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Ano);
  Writeln(ArqDados, ComboBox3.Text);
  CloseFile(ArqDados);
  { Gera os arquivos contendo as snteses dos dados }
    Arquivo := Calc + 'Needs.dbf';
    if FileExists(Arquivo) then
      begin
        AssignFile(ArqDados, Arquivo);
        Erase(ArqDados)
      end;
    Arquivo := 'DOS.DAT';
    if FileExists(Arquivo) then
      begin
        AssignFile(ArqDados, Arquivo);
        Erase(ArqDados)
      end;
    WinExec('Needs.bat /c', SW_HIDE);
    Flag := 0;
    StartTime := now;
    NumSec := 3;
    repeat
      Application.ProcessMessages;
      if FileExists(Arquivo) then Flag := Flag + 1;
    until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag > 5);
  { Converte os arquivos CSV para DBF }
  Arquivo := Calc + 'Needs.csv';
  Arq2 := Calc + 'Needs.dbf';
  NFields := 2;
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, Linha);
  with DataModule24.Table12 do
    begin
      Active := False;
      TableName := Arq2;
      CreateTable;
      Active := True;
      Edit;
      First;
    end;
    while not eof(ArqDados) do
      begin
        Readln(ArqDados, Linha);
        j := 1;
        for icont := 1 to NFields do
          Campo[icont] := '';
        for icont := 1 to Length(Linha) do
          begin
            if Linha[icont] = ',' then
              j := j + 1
            else
              if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
          end;
        if ConfReg = 'Portuguese' then
          begin
            for jk := 1 to Length(Campo[2]) do
              if Campo[2,jk] = '.' then Campo[2,jk] := ',';
          end;
       DataModule24.Table12.InsertRecord([Campo[1],StrToFloat(Campo[2])]);
      end;
    DataModule24.Table12.Close;
    DataModule24.Table12.Active := False;
    CloseFile(ArqDados);
    Flag := 0;
    StartTime := now;
    NumSec := 3;
    repeat
      Application.ProcessMessages;
      if FileExists(Arq2) then Flag := Flag + 1;
    until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag > 5);
  { Ativa a tabela e aciona o grfico }
    DataModule24.Table12.Active := True;
    DBChart1.Title.Text.Append(ComboBox1.Text);
    if ComboBox1.Text = 'Necessidades atuais de manuteno' then
       AnoFaixa := 'Faixa de trfego: ' + ComboBox3.Text
    else
       AnoFaixa := 'Ano: ' + ComboBox2.Text + '    ' + 'Faixa de trfego: ' + ComboBox3.Text;
    DBChart1.Title.Text.Append(AnoFaixa);
    DBChart1.Show;
  BitBtn2.Visible := True;
  Screen.Cursor := crDefault;
 end;
end;

initialization
  CoInitialize (nil);

end.
