unit Unit33;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, TeEngine, Series, TeeProcs, Chart,
  DBChart, TeeFunci, DB, DBCtrls, Grids, DBGrids;

type
  TForm33 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    DBChart6: TDBChart;
    Series6: TPieSeries;
    Timer1: TTimer;
    Panel3: TPanel;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    DataSource1: TDataSource;
    Panel4: TPanel;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    ComboBox1: TComboBox;
    ComboBox4: TComboBox;
    ComboBox6: TComboBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    ComboBox7: TComboBox;
    ComboBox8: TComboBox;
    Panel5: TPanel;
    BitBtn4: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn1: TBitBtn;
    Label7: TLabel;
    Label8: TLabel;
    procedure CondioAtual1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure ComboBox6Change(Sender: TObject);
    procedure ComboBox8Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure ComboBox7Change(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
  private
    { Private declarations }
      DeltaZoom:Integer;
  public
    { Public declarations }
  end;

var
  Form33: TForm33;

implementation

uses Childwin, Unit24, ComObj, ActiveX, Printers, Unit94;

{$R *.DFM}

procedure TForm33.CondioAtual1Click(Sender: TObject);
begin
  MDIChild.CondioAtual1Click(Sender);
end;

procedure TForm33.BitBtn1Click(Sender: TObject);
begin
  DataModule24.Table9.Active := False;
  Close;
end;

procedure TForm33.ComboBox2Change(Sender: TObject);
var
  ArqDados: TextFile;
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Year: string[4];
begin
  BitBtn3.Visible := False;
  Label7.Caption := '';
  Label8.Caption := '';
  DBChart6.Hide;
  DBChart6.Visible := False;
  ComboBox3.Text := '';
  ComboBox8.Text := '';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  { Carrega a lista de parmetros disponveis }
  if ComboBox2.Text = 'Trfego' then
    begin
      Arquivo := 'Trafego.dat';
      ComboBox3.Items.LoadFromFile(Arquivo);
      Label9.Caption := '';
      Label10.Caption := '';
      ComboBox7.Visible := False;
      ComboBox8.Visible := False;
    end;
  if ComboBox2.Text = 'Acostamentos' then
    begin
      Arquivo := 'Acostam.dat';
      ComboBox3.Items.LoadFromFile(Arquivo);
      Label9.Caption := '';
      Label10.Caption := '';
      ComboBox7.Visible := False;
      ComboBox8.Visible := False;
    end;
  if ComboBox2.Text = 'Dados Cadastrais' then
    begin
      Arquivo := 'Cadastro.dat';
      ComboBox3.Items.LoadFromFile(Arquivo);
      Label9.Caption := '';
      Label10.Caption := '';
      ComboBox7.Visible := False;
      ComboBox8.Visible := False;
    end;
  if ComboBox2.Text = 'Estado de Superfcie' then
    begin
      Arquivo := 'EstSup.dat';
      ComboBox3.Items.LoadFromFile(Arquivo);
      Label9.Caption := 'Ano:';
      Label10.Caption := 'Referncia:';
      ComboBox7.Visible := True;
      ComboBox8.Visible := True;
    end;
  if ComboBox2.Text = 'Condio Funcional' then
    begin
      Arquivo := 'Funcio.dat';
      ComboBox3.Items.LoadFromFile(Arquivo);
      Label9.Caption := 'Ano:';
      Label10.Caption := 'Referncia:';
      ComboBox7.Visible := True;
      ComboBox8.Visible := True;
    end;
  if ComboBox2.Text = 'Avaliao Estrutural' then
    begin
      Arquivo := 'Deflex.dat';
      ComboBox3.Items.LoadFromFile(Arquivo);
      Label9.Caption := 'Ano:';
      Label10.Caption := 'Referncia:';
      ComboBox7.Visible := True;
      ComboBox8.Visible := True;
    end;
  if ComboBox2.Text = 'Estrutura do Pavimento' then
    begin
      Arquivo := 'Estrut.dat';
      ComboBox3.Items.LoadFromFile(Arquivo);
      Label9.Caption := '';
      Label10.Caption := '';
      ComboBox7.Visible := False;
      ComboBox8.Visible := False;
    end;
end;

procedure TForm33.ComboBox1Change(Sender: TObject);
var
  ArqDados: TextFile;
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase, ArqDbf: string;
  Year: string[4];
begin
  Panel3.Visible := False;
  BitBtn3.Visible := False;
  Label7.Caption := '';
  Label8.Caption := '';
  DBChart6.Hide;
  DBChart6.Visible := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  if ComboBox1.Text = 'Toda a Rede' then
    begin
      Label6.Visible := False;
      ComboBox6.Visible := False;
    end;
  if ComboBox1.Text = 'Um Trecho' then
    begin
      Label6.Visible := True;
      ComboBox6.Visible := True;
      Arquivo := DadosAnoBase + 'Trechos.dat';
      ComboBox6.Items.LoadFromFile(Arquivo);
    end;
  if ComboBox1.Text = 'Sub-rede' then
    begin
      Label6.Visible := False;
      ComboBox6.Visible := False;
      ArqDbf := Calc + 'SubRede.dbf';
      DataModule24.Table43.Active := False;
      DataModule24.Table43.TableName := ArqDbf;
      DataModule24.Table43.Active := True;
      Arquivo := DadosAnoBase + 'Trechos.dsc';
      DBGrid1.Columns[0].PickList.LoadFromFile(Arquivo);
      Panel3.Visible := True;
    end;
end;

procedure TForm33.FormShow(Sender: TObject);
begin
  Panel3.Visible := False;
  DataModule24.Table9.Active := False;
  BitBtn3.Visible := False;
  DBChart6.Hide;
  DBChart6.Visible := False;
  Label7.Caption := '';
  Label8.Caption := '';
  Label9.Visible := True;
  ComboBox7.Visible := True;
end;

procedure TForm33.ComboBox4Change(Sender: TObject);
begin
  BitBtn3.Visible := False;
  DBChart6.Hide;
  DBChart6.Visible := False;
  Label7.Caption := '';
  Label8.Caption := '';
end;

procedure TForm33.ComboBox6Change(Sender: TObject);
begin
  BitBtn3.Visible := False;
  DBChart6.Hide;
  DBChart6.Visible := False;
  Label7.Caption := '';
  Label8.Caption := '';
  Label9.Visible := False;
  ComboBox7.Visible := False;
end;

procedure TForm33.ComboBox8Change(Sender: TObject);
var
  ArqDados: TextFile;
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Year: string[4];
begin
  BitBtn3.Visible := False;
  Label7.Caption := '';
  Label8.Caption := '';
  if ComboBox8.Text = 'Condio Atual' then
    begin
      Label9.Visible := False;
      ComboBox7.Visible := False;
    end
  else
    begin
      Label9.Caption := 'Ano:';
      ComboBox7.Visible := True;
      Label9.Visible := True;
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      Year := IntToStr(Ano);
      Arquivo := Calc + 'Years.dat';
      ComboBox7.Items.LoadFromFile(Arquivo);
    end;
end;

procedure TForm33.BitBtn2Click(Sender: TObject);
var
  Excel: OleVariant;
  FileCodeExcel, NFields, j, icont, jk: integer;
  ArqDados, Arq: TextFile;
  Ano, NPeriodos: SmallInt;
  Programa, Dados, Calc, Arquivo, ArqDbf, Rede, Variavel, DadosAnoBase, Faixa,
    TipoDado, Polo, Local, Modo, Linha, ConfReg, Unidade, ArqCsv, LinhaX,
    LinhaY: string;
  Year: string[4];
  Trecho, Nome, Estrategia: string[4];
  Media: Single;
  Parametro: string[6];
  Par8: string[8];
  Par5: string[5];
  Executa: Boolean;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string;
begin
 Executa := True;
 if ComboBox1.Text = '' then Executa := False;
 if ComboBox4.Text = '' then Executa := False;
 if ComboBox2.Text = '' then Executa := False;
 if ComboBox3.Text = '' then Executa := False;
 if Executa then
 begin
 Screen.Cursor := crHourglass;
 AssignFile(ArqDados, 'Diretor.dat');
 Reset(ArqDados);
 Readln(ArqDados, Ano);
 Readln(ArqDados, NPeriodos);
 Readln(ArqDados, Programa);
 Readln(ArqDados, Dados);
 Readln(ArqDados, Calc);
 Readln(ArqDados, DadosAnoBase);
 CloseFile(ArqDados);
 if ComboBox1.Text = 'Sub-rede' then
 begin
  ArqCsv := Calc + 'SubRede.csv';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  { Converte de DBF para CSV }
  ArqDbf := Calc + 'SubRede.dbf';
  AssignFile(ArqDados, ArqCsv);
  Rewrite(ArqDados);
  Linha := 'TRECHO,KM_INI,KM_FIM';
  NFields := 1;
  for icont := 1 to Length(Linha) do
    if Linha[icont] = ',' then NFields := NFields + 1;
  Writeln(ArqDados, Linha);
  with DataModule24.Table43 do
    begin
      Active := False;
      TableName := ArqDbf;
      Active := True;
      First;
      while not Eof do
        begin
          LinhaX := Fields.Fields[0].AsString;
          Linha := '';
          for jk := 1 to Length(LinhaX) do
            begin
              if LinhaX[jk] = ',' then LinhaX[jk] := '.';
              Linha := Linha + LinhaX[jk];
            end;
          for icont := 1 to NFields-1 do
            begin
              LinhaX := Fields.Fields[icont].AsString;
              LinhaY := '';
              for jk := 1 to Length(LinhaX) do
                begin
                  if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                  LinhaY := LinhaY + LinhaX[jk];
                end;
              Linha := Linha + ',' + LinhaY;
            end;
          Writeln(ArqDados, Linha);
          Next;
        end;
      Active := False;
    end;
  CloseFile(ArqDados);
 end;
 BitBtn3.Visible := False;
 DataModule24.Table9.Active := False;
 Label7.Caption := '';
 Label8.Caption := '';
 DBChart6.Hide;
 DBChart6.Visible := False;
 DBChart6.Title.Text.Clear;
 AssignFile(ArqDados, 'Config.dat');
 Reset(ArqDados);
 Readln(ArqDados, ConfReg);
 CloseFile(ArqDados);
 Rede := ComboBox1.Text;
 Faixa := ComboBox4.Text;
 TipoDado := ComboBox2.Text;
 Variavel := ComboBox3.Text;
 Year := '';
 Arquivo := DadosAnoBase + 'Trechos.dat';
 AssignFile(ArqDados, Arquivo);
 Reset(ArqDados);
 Arquivo := DadosAnoBase + 'Trechos.dsc';
 AssignFile(Arq, Arquivo);
 Reset(Arq);
 while Eof(ArqDados) = False do
   begin
     Readln(ArqDados, Local);
     Readln(Arq, Nome);
     if ComboBox6.Text = Local then Trecho := Nome;
   end;
 CloseFile(ArqDados);
 CloseFile(Arq);
 Modo := '';
 if ComboBox3.Text = 'PSR' then
   begin
     Modo := 'Estrategia';
     Arquivo := Calc + 'Estrat.dat';
     AssignFile(ArqDados, Arquivo);
     Rewrite(ArqDados);
     Estrategia := 'EB';
     Writeln(ArqDados, Estrategia);
     CloseFile(ArqDados);
   end;
 if ComboBox8.Text = '' then Modo := 'Sintese';
 if ComboBox8.Text = 'Condio Atual' then Modo := 'Sintese';
 if Modo = '' then
   begin
     Modo := 'Estrategia';
     Arquivo := Calc + 'Estrat.dat';
     AssignFile(ArqDados, Arquivo);
     Rewrite(ArqDados);
     if ComboBox8.Text = 'Evoluo sem Investimentos' then
         Estrategia := 'EVO'
     else
       if ComboBox8.Text = 'Estratgia-Base' then
           Estrategia := 'EB'
       else
           Estrategia := 'RO';
     Writeln(ArqDados, Estrategia);
     Year := ComboBox7.Text;
     Writeln(ArqDados, Year);
     CloseFile(ArqDados);
   end;
 Arquivo := Calc + 'ParamVar.dat';
 AssignFile(ArqDados, Arquivo);
 Rewrite(ArqDados);
 Writeln(ArqDados, Rede);
 Writeln(ArqDados, Polo);
 Writeln(ArqDados, Trecho);
 Writeln(ArqDados, Faixa);
 Writeln(ArqDados, TipoDado);
 Writeln(ArqDados, Variavel);
 Writeln(ArqDados, Modo);
 CloseFile(ArqDados);
 { Gera o arquivo contendo a sntese dos dados da condio atual }
   Arquivo := Calc + 'Atual.dbf';
   if FileExists(Arquivo) then
     begin
       AssignFile(ArqDados, Arquivo);
       Erase(ArqDados)
     end;
   Arquivo := 'DOS.DAT';
   if FileExists(Arquivo) then
     begin
       AssignFile(ArqDados, Arquivo);
       Erase(ArqDados)
     end;
   WinExec('BDados.bat /c', SW_HIDE);
   Flag := 0;
   StartTime := now;
   NumSec := 3;
   repeat
     Application.ProcessMessages;
     if FileExists(Arquivo) then Flag := 1;
   until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Usa o Excel para converter os arquivos CSV para DBF }
  Arquivo := Calc + 'Atual.csv';
  ArqDbf := Calc + 'Atual.dbf';
  NFields := 2;
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, Linha);
  with DataModule24.Table9 do
    begin
      Active := False;
      TableName := ArqDbf;
      CreateTable;
      Active := True;
      Edit;
      First;
    end;
    while not eof(ArqDados) do
      begin
        Readln(ArqDados, Linha);
        j := 1;
        for icont := 1 to NFields do
          Campo[icont] := '';
        for icont := 1 to Length(Linha) do
          begin
            if Linha[icont] = ',' then
              j := j + 1
            else
              if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
          end;
        if ConfReg = 'Portuguese' then
          begin
            for jk := 1 to Length(Campo[2]) do
              if Campo[2,jk] = '.' then Campo[2,jk] := ',';
          end;
        DataModule24.Table9.InsertRecord([Campo[1],StrToFloat(Campo[2])]);
      end;
    DataModule24.Table9.Close;
    DataModule24.Table9.Active := False;
    CloseFile(ArqDados);
   Arquivo := Calc + 'Medias.csv';
   AssignFile(ArqDados, Arquivo);
   Reset(ArqDados);
   Readln(ArqDados, Media);
   CloseFile(ArqDados);
   if Media <> -1 then
     begin
       Label7.Caption := 'Valor Mdio =';
       if TipoDado = 'Trfego' then
         begin
           Par8 := FloatToStr(Media);
           Label8.Caption := Par8;
         end
       else
         begin
           Par5 := FloatToStr(Media);
           Label8.Caption := Par5;
         end;
       Unidade := '';
       if Variavel = 'Faixas de Trafego' then
         Unidade := 'faixas'
       else
         if Variavel = 'Idade' then
           Unidade := 'anos'
         else
           if Variavel = 'h1cm' then
             Unidade := 'cm'
           else
             if Variavel = 'QI' then
               Unidade := 'cont/km'
             else
               if Variavel = 'IRI' then
                 Unidade := 'm/km'
               else
                 if Variavel = 'ATR' then
                   Unidade := 'mm'
                 else
                   if Variavel = 'Trincamento' then
                     Unidade := '% da area'
                   else
                     if Variavel = 'FC-3' then
                       Unidade := '% da area'
                     else
                       if Variavel = 'Esl' then
                         Unidade := 'kgf/cm2'
                       else
                         if Variavel = 'Deflexao' then
                           Unidade := '(x 0.01 mm)'
                         else
                           if Variavel = 'Vida Restante' then
                             Unidade := 'anos'
                           else
                             if Variavel = 'VDM' then
                               Unidade := 'veculos/dia'
                             else
                             if Variavel = '' then Unidade := 'eixos equivalentes (AASHTO)';
       Label8.Caption := Label8.Caption + ' ' + Unidade;
     end;
 { Ativa a tabela e aciona o grfico }
   DataModule24.Table9.TableName := ArqDbf;
   DataModule24.Table9.Active := True;
   DBChart6.Align := alClient;
   if ComboBox1.Text = 'Um Trecho' then
        Local := ComboBox6.Text + '    ' + 'Faixa de trfego: ' + ComboBox4.Text
   else
        Local := ComboBox1.Text + '    ' + 'Faixa de trfego: ' + ComboBox4.Text;
   DBChart6.Title.Text.Append(Local);
   if ComboBox8.Text = 'Condio Atual' then
        Local := ComboBox8.Text
   else
        if ComboBox8.Visible = True then
             Local := ComboBox8.Text + '    ' + 'Ano: ' + ComboBox7.Text
        else
             Local := '';
   DBChart6.Title.Text.Append(Local);
   DBChart6.Show;
 BitBtn3.Visible := True;
 if ComboBox1.Text = 'Sub-rede' then DataModule24.Table43.Active := True;
 Screen.Cursor := crDefault;
 end;
end;

procedure TForm33.ComboBox3Change(Sender: TObject);
begin
  BitBtn3.Visible := False;
  Label7.Caption := '';
  Label8.Caption := '';
  ComboBox8.Text := '';
end;

procedure TForm33.ComboBox7Change(Sender: TObject);
begin
  BitBtn3.Visible := False;
  Label7.Caption := '';
  Label8.Caption := '';
end;

procedure TForm33.BitBtn3Click(Sender: TObject);
var h,w:longint;
begin
  Screen.Cursor := crHourGlass; { <-- nice detail }
  try
    Printer.BeginDoc;       { <-- start printer job }
    try
      { now print some text on printer.canvas }
      With Printer.Canvas do
      begin
        Font.Name:='Arial';
        Font.Size:=10;             { <-- set the font size }
        Font.Style:=[];
        TextOut(0,0,ComboBox2.Text);   { <-- print some text }
      end;

      h:=Printer.PageHeight; { <-- get page height }
      w:=Printer.PageWidth;  { <-- get page width }

      { And now print the chart component... }
      DBChart6.PrintPartial(  Rect(  w div 10,          { <-- left margin }
                                   h div 3 ,          { <-- top margin }
                                   w - (w div 10),    { <-- right margin }
                                   h - (h div 10) )); { <-- bottom margin }


      { print more text.... }
      With Printer.Canvas do
      begin
        Font.Name:='Arial';
        Font.Size:=12;             { <-- set the font size }
        Font.Style:=[fsItalic];
        TextOut(0,60,ComboBox3.Text);   { <-- print some text }
      end;

      Printer.EndDoc; { <-- end job and print !! }
    except
      on Exception do  { just in case an error happens... }
      Begin
        Printer.Abort;
        Printer.EndDoc;
        Raise;       { <-- raise up the exception !!! }
      end;
    end;
  finally
    Screen.Cursor:=crDefault; { <-- restore cursor }
  end;
end;

procedure TForm33.Timer1Timer(Sender: TObject);
var tmp:Integer;
begin
  Series6.Rotate(5);
  With Series6 do
  begin
    tmp:=Random(Count);
    if ExplodedSlice[tmp]>20 then
       ExplodedSlice[tmp]:=ExplodedSlice[tmp]-1
    else
       ExplodedSlice[tmp]:=ExplodedSlice[tmp]+1;
  end;
end;

procedure TForm33.BitBtn4Click(Sender: TObject);
var
  Excel: OleVariant;
  FileCodeExcel: Integer;
  ArqDados, Arq: TextFile;
  Ano, NPeriodos: SmallInt;
  Programa, Dados, Calc, Arquivo, ArqDbf, Rede, Variavel, DadosAnoBase: string;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := 'DOS.DAT';
  if FileExists(Arquivo) then
    begin
      AssignFile(ArqDados, Arquivo);
      Erase(ArqDados)
    end;
  WinExec('RelGer.bat /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 10;
  repeat
    Application.ProcessMessages;
    if FileExists(Arquivo) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Usa o Excel para abrir o arquivo CSV com os resultados }
    Arquivo := Calc + 'MediasTr.csv';
    Excel := CreateOleObject('Excel.Application');
    Excel.Visible := True;
    FileCodeExcel := 6;
    Excel.Workbooks.Open(Arquivo, True, FileCodeExcel);
 Screen.Cursor := crDefault;
end;

initialization
  CoInitialize (nil);

end.
