unit Unit32;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, DB, DBCtrls, Grids, DBGrids;

type
  TForm32 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    Panel3: TPanel;
    Panel4: TPanel;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    DataSource1: TDataSource;
    BitBtn2: TBitBtn;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    ComboBox1: TComboBox;
    Label4: TLabel;
    GroupBox3: TGroupBox;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Edit3: TEdit;
    Label8: TLabel;
    Button1: TButton;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    procedure GeraBasedeDados1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form32: TForm32;

implementation

uses Childwin, Unit94, Unit10, ComObj, ActiveX, Unit24;

{$R *.dfm}

procedure TForm32.GeraBasedeDados1Click(Sender: TObject);
begin
  MDIChild.GeraBasedeDados1Click(Sender);
end;

procedure TForm32.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm32.BitBtn2Click(Sender: TObject);
var
  ExtBase, ExtMin: Single;
  ArqDados, Arq, ArqOut: TextFile;
  Codigo: string[2];
  Year: string[4];
  Campo: array [1..200] of string;
  Arquivo, Programa, Dados, Calc, DadosAnoBase, ArqCsv, ArqDbf, Code, kmi,
    DescrTrecho, Linha, DTre, LinhaX, LinhaY, ConfReg: string;
  Ano, NPeriodos, NRodov, i1, i2, i, j, icont, NFields, jj, jk, jl: integer;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Atualiza: string[3];
  Rodovia: array [1..350] of string[4];
  Faixa: array [1..4] of string[1];
begin
 if Edit1.Text <> '' then
  if Edit2.Text <> '' then
   if Edit3.Text <> '' then
  begin
  Screen.Cursor := crHourglass;
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
    Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  Faixa[1] := '1';
  Faixa[2] := '2';
  Faixa[3] := '3';
  Faixa[4] := '4';
  ExtBase := StrToFloat(Edit1.Text);
  NRodov := StrToInt(Edit2.Text);
  ExtMin := StrToFloat(Edit3.Text);
  Arquivo := Calc + 'SCR.csv';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, Linha);
  NFields := 12;
  i := 0;
  while not Eof(ArqDados) do
    begin
      Readln(ArqDados, Linha);
      j := 1;
      for icont := 1 to NFields do
        Campo[icont] := '';
      for icont := 1 to Length(Linha) do
        if Linha[icont] = ',' then
          j := j + 1
        else
          if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
      i := i + 1;
      Rodovia[i] := Campo[1];
    end;
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Rewrite(Arq);
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, NRodov);
  for i := 1 to NRodov do
    begin
      Writeln(ArqDados, Rodovia[i]);
      Writeln(Arq, Rodovia[i]);
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  Arquivo := Dados + 'ParSCR.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, ExtBase);
  Writeln(ArqDados, NRodov);
  Writeln(ArqDados, ExtMin);
  CloseFile(ArqDados);
  Arquivo := Calc + 'SCR.csv';
  ArqCsv := Calc + 'SCRtrech.csv';
  AssignFile(Arq, ArqCsv);
  Rewrite(Arq);
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  while not eof(ArqDados) do
    begin
      Readln(ArqDados, Linha);
      Writeln(Arq, Linha);
    end;
  CloseFile(ArqDados);
  Linha := 'Fim,,,,,-1,-1,,0.0,0.0,,Nenhum';
  Writeln(Arq, Linha);
  CloseFile(Arq);
  if CheckBox4.Checked then
    begin
      Arquivo := 'DOS.DAT';
      if FileExists(Arquivo) then
        begin
          AssignFile(ArqDados, Arquivo);
          Erase(ArqDados)
        end;
      WinExec('ConvSCR.exe /c', SW_HIDE);
      Flag := 0;
      StartTime := now;
      NumSec := 7;
      repeat
        Application.ProcessMessages;
        if FileExists(Arquivo) then Flag := 1;
      until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
    end;
  for i := 1 to NRodov do
    begin
      ArqDbf := Dados + 'Cadas_' + Rodovia[i] + '_' + Year + '.dbf';
      ArqCsv := Calc + 'Cadas' + Rodovia[i] + '.csv';
      NFields := 25;
      AssignFile(ArqDados, ArqCsv);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      with DataModule10.Table2 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
            end;
          if ConfReg = 'Portuguese' then
            begin
              for j := 5 to 6 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
              for j := 8 to 14 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
              for j := 18 to 24 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
            end;
          DataModule10.Table2.InsertRecord([Campo[1],Campo[2],Campo[3],Campo[4],StrToFloat(Campo[5]),
            StrToFloat(Campo[6]),Campo[7],StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),
            StrToFloat(Campo[11]),StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),
            Campo[15],Campo[16],Campo[17],StrToFloat(Campo[18]),StrToFloat(Campo[19]),
            StrToFloat(Campo[20]),StrToFloat(Campo[21]),StrToFloat(Campo[22]),StrToFloat(Campo[23]),
            StrToFloat(Campo[24]),Campo[25]]);
        end;
      DataModule10.Table2.Close;
      DataModule10.Table2.Active := False;
      CloseFile(ArqDados);
    end;
  for i := 1 to NRodov do
    begin
      ArqDbf := Dados + 'Cadas_' + Rodovia[i] + '_' + Year + '.dbf';
      ArqCsv := Calc + 'Cadas' + Rodovia[i] + '.csv';
      AssignFile(ArqDados, ArqCsv);
      Rewrite(ArqDados);
      Linha := 'STH, RODOVIA, INICIO, FIM, KMINICIAL, KMFINAL, PISTA, NFAIXAS, PLUVMMANO, ALTM, PLATAFM, LARGPISTA, ACOSTLE, ACOSTLD, GEOVERT, GEOHORIZ, SECTIPO, FAIXA1M, FAIXA2M, FAIXA3M, FAIXA4M, DECTRANSV, RESTRCOTA, EXTPONTES, OBS';
      NFields := 1;
      for icont := 1 to Length(Linha) do
        if Linha[icont] = ',' then NFields := NFields + 1;
      Writeln(ArqDados, Linha);
      with DataModule10.Table2 do
        begin
          Active := False;
          TableName := ArqDbf;
          Active := True;
          First;
          while not Eof do
            begin
              LinhaX := Fields.Fields[0].AsString;
              Linha := '';
              for jk := 1 to Length(LinhaX) do
                begin
                  if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                  Linha := Linha + LinhaX[jk];
                end;
              for icont := 1 to NFields-1 do
                begin
                  LinhaX := Fields.Fields[icont].AsString;
                  LinhaY := '';
                  for jk := 1 to Length(LinhaX) do
                    begin
                      if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                      LinhaY := LinhaY + LinhaX[jk];
                    end;
                  Linha := Linha + ',' + LinhaY;
                end;
              Writeln(ArqDados, Linha);
              Next;
            end;
          Active := False;
        end;
      CloseFile(ArqDados);
    end;
  Arquivo := 'DOS.DAT';
  if FileExists(Arquivo) then
    begin
      AssignFile(ArqDados, Arquivo);
      Erase(ArqDados)
    end;
  WinExec('ConvEstr.exe /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 7;
  repeat
    Application.ProcessMessages;
    if FileExists(Arquivo) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  for i := 1 to NRodov do
    begin
      ArqDbf := Dados + 'Acost_' + Rodovia[i] + '_' + Year + '.dbf';
      ArqCsv := Calc + 'Acost' + Rodovia[i] + '.csv';
      NFields := 14;
      AssignFile(ArqDados, ArqCsv);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      with DataModule10.Table1 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
            end;
          if ConfReg = 'Portuguese' then
            begin
              j := 3;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 5;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 7;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 9;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 10;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 13;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
            end;
          DataModule10.Table1.InsertRecord([Campo[1],Campo[2],StrToFloat(Campo[3]),Campo[4],
            StrToFloat(Campo[5]),Campo[6],StrToFloat(Campo[7]),Campo[8],StrToFloat(Campo[9]),
            StrToFloat(Campo[10]),Campo[11],Campo[12],StrToFloat(Campo[13]),Campo[14]]);
        end;
      DataModule10.Table1.Close;
      DataModule10.Table1.Active := False;
      CloseFile(ArqDados);
      for j := 1 to 4 do
        begin
          ArqCsv := Calc + 'Estr' + Rodovia[i] + Faixa[j] + '.csv';
          ArqDbf := Dados + 'Estr' + '_' + Rodovia[i] + Faixa[j] + '_' + Year + '.dbf';
          NFields := 25;
          AssignFile(ArqDados, ArqCsv);
          Reset(ArqDados);
          Readln(ArqDados, Linha);
          with DataModule10.Table4 do
            begin
              Active := False;
              TableName := ArqDbf;
              CreateTable;
              Active := True;
              Edit;
              First;
            end;
          while not eof(ArqDados) do
            begin
              Readln(ArqDados, Linha);
              jj := 1;
              for icont := 1 to NFields do
                Campo[icont] := '';
              for icont := 1 to Length(Linha) do
                begin
                  if Linha[icont] = ',' then
                    jj := jj + 1
                  else
                    if Linha[icont] <> '"' then Campo[jj] := Campo[jj] + Linha[icont];
                end;
              if ConfReg = 'Portuguese' then
                begin
                  for jl := 4 to 8 do
                    begin
                      for jk := 1 to Length(Campo[jl]) do
                        if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                    end;
                  for jl := 10 to 12 do
                    begin
                      for jk := 1 to Length(Campo[jl]) do
                        if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                    end;
                  for jl := 14 to 16 do
                    begin
                      for jk := 1 to Length(Campo[jl]) do
                        if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                    end;
                  for jl := 18 to 20 do
                    begin
                      for jk := 1 to Length(Campo[jl]) do
                        if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                    end;
                  for jl := 22 to 25 do
                    begin
                      for jk := 1 to Length(Campo[jl]) do
                        if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                    end;
                end;
              DataModule10.Table4.InsertRecord([Campo[1],Campo[2],Campo[3],
                StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),
                StrToFloat(Campo[7]),StrToFloat(Campo[8]),Campo[9],StrToFloat(Campo[10]),
                StrToFloat(Campo[11]),StrToFloat(Campo[12]),Campo[13],StrToFloat(Campo[14]),
                StrToFloat(Campo[15]),StrToFloat(Campo[16]),Campo[17],StrToFloat(Campo[18]),
                StrToFloat(Campo[19]),Campo[20],StrToFloat(Campo[21]),StrToFloat(Campo[22]),
                StrToFloat(Campo[23]),StrToFloat(Campo[24]),StrToFloat(Campo[25])]);
            end;
          DataModule10.Table4.Close;
          DataModule10.Table4.Active := False;
          CloseFile(ArqDados);
        end;
    end;
  for i := 1 to NRodov do
   begin
    ArqDbf := Dados + 'Acost_' + Rodovia[i] + '_' + Year + '.dbf';
    ArqCsv := Calc + 'Acost' + Rodovia[i] + '.csv';
    AssignFile(ArqDados, ArqCsv);
    Rewrite(ArqDados);
    Linha := 'STH,USO,ANOREVEST,REVEST,H1CM,BASE,H2CM,SUBBASE,H3CM,DECTRANSV,SUPPISTA,SUPACOST,HLFREATM,INUNDTEMP';
    NFields := 1;
    for icont := 1 to Length(Linha) do
      if Linha[icont] = ',' then NFields := NFields + 1;
    Writeln(ArqDados, Linha);
    with DataModule10.Table1 do
    begin
      Active := False;
      TableName := ArqDbf;
      Active := True;
      First;
      while not Eof do
        begin
          LinhaX := Fields.Fields[0].AsString;
          Linha := '';
          for jk := 1 to Length(LinhaX) do
            begin
              if LinhaX[jk] = ',' then LinhaX[jk] := '.';
              Linha := Linha + LinhaX[jk];
            end;
          for icont := 1 to NFields-1 do
            begin
              LinhaX := Fields.Fields[icont].AsString;
              LinhaY := '';
              for jk := 1 to Length(LinhaX) do
                begin
                  if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                  LinhaY := LinhaY + LinhaX[jk];
                end;
              Linha := Linha + ',' + LinhaY;
            end;
          Writeln(ArqDados, Linha);
          Next;
        end;
      Active := False;
    end;
    CloseFile(ArqDados);
    for j := 1 to 4 do
    begin
        ArqCsv := Calc + 'Estr' + Rodovia[i] + Faixa[j] + '.csv';
        ArqDbf := Dados + 'Estr' + '_' + Rodovia[i] + Faixa[j] + '_' + Year + '.dbf';
        AssignFile(ArqDados, ArqCsv);
        Rewrite(ArqDados);
        Linha := 'STH,ANOREVEST,REVEST,MARSHALL,RTDIAMET,VAZIOSAR,TEORASF,H1ORIGCM,BASE,H2CM,CBRBASE,RCS28DBASE,SUBBASE,H3CM,CBRSUBBASE,RCS28DSUBB,REFSL,H4CM,CBRREFSL,SUBLEITO,CBRSL,LLSL,IPSL,PERCT200,PROFROCHA';
        NFields := 1;
        for icont := 1 to Length(Linha) do
          if Linha[icont] = ',' then NFields := NFields + 1;
        Writeln(ArqDados, Linha);
        with DataModule10.Table4 do
        begin
          Active := False;
          TableName := ArqDbf;
          Active := True;
          First;
          while not Eof do
          begin
            LinhaX := Fields.Fields[0].AsString;
            Linha := '';
            for jk := 1 to Length(LinhaX) do
              begin
                if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                Linha := Linha + LinhaX[jk];
              end;
            for icont := 1 to NFields-1 do
              begin
                LinhaX := Fields.Fields[icont].AsString;
                LinhaY := '';
                for jk := 1 to Length(LinhaX) do
                  begin
                    if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                    LinhaY := LinhaY + LinhaX[jk];
                  end;
                Linha := Linha + ',' + LinhaY;
              end;
            Writeln(ArqDados, Linha);
            Next;
          end;
          Active := False;
        end;
        CloseFile(ArqDados);
    end;
   end;
  AssignFile(ArqDados, 'STHS.CSV');
  Reset(ArqDados);
  Arquivo := Calc + 'STHS.DAT';
  AssignFile(Arq, Arquivo);
  Rewrite(Arq);
  while not Eof(ArqDados) do
    begin
      Readln(ArqDados, i1);
      Readln(ArqDados, i2);
      for j := i1 to i2 do
        begin
          if j < 10 then
            Code := '0000'
          else
            if j < 100 then
              Code := '000'
            else
              if j < 1000 then
                Code := '00'
              else
                if j < 10000 then
                  Code := '0'
                else
                  Code := '';
          ArqCsv := Calc + 'HM' + Code + IntToStr(j) + '.csv';
          Writeln(Arq, ArqCsv);
        end;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  ArqCsv := 'DOS2.DAT';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  WinExec('Hist.exe /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 10;
  repeat
    Application.ProcessMessages;
    if FileExists(ArqCsv) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Gera os arquivos Trechos.dat e Tre.dat }
  AssignFile(ArqDados, 'Arq.dat');
  Rewrite(ArqDados);
  Writeln(ArqDados, 1);
  CloseFile(ArqDados);
  NFields := 25;
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(Arq, Arquivo);
  Rewrite(Arq);
  Arquivo := DadosAnoBase + 'Tre.dat';
  AssignFile(ArqOut, Arquivo);
  Rewrite(ArqOut);
  for i := 1 to NRodov do
    begin
      ArqCsv := Calc + 'Cadas' + Rodovia[i] + '.csv';
      AssignFile(ArqDados, ArqCsv);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      Readln(ArqDados, Linha);
      j := 1;
      for icont := 1 to NFields do
        Campo[icont] := '';
      for icont := 1 to Length(Linha) do
        begin
          if Linha[icont] = ',' then
            j := j + 1
          else
            if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
        end;
      DescrTrecho := Campo[2] + ' [' + Campo[3];
      kmi := Campo[5];
      while not eof(ArqDados) do
        Readln(ArqDados, Linha);
      j := 1;
      for icont := 1 to NFields do
        Campo[icont] := '';
      for icont := 1 to Length(Linha) do
        begin
          if Linha[icont] = ',' then
            j := j + 1
          else
            if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
        end;
      DescrTrecho := DescrTrecho + ' - ' + Campo[4] + '] (km ' + kmi + ' ao km ' + Campo[6] + ')';
      Writeln(Arq, DescrTrecho);
      DTre := '';
      for j := 1 to Length(DescrTrecho) do
        if DescrTrecho[j] <> ',' then DTre := DTre + DescrTrecho[j];
      Writeln(ArqOut, DTre);
    end;
  CloseFile(Arq);
  CloseFile(ArqOut);
  Label3.Visible := True;
  ComboBox1.Visible := True;
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
  AssignFile(ArqDados, 'Acesso.dat');
  Reset(ArqDados);
  Readln(ArqDados, Atualiza);
  CloseFile(ArqDados);
  if Atualiza = 'Sim' then
    DBGrid1.ReadOnly := False
  else
    DBGrid1.ReadOnly := True;
  Screen.Cursor := crDefault;
  end;
end;

procedure TForm32.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome: string[4];
  ArqDados, Arq: TextFile;
begin
if ComboBox1.Text <> '' then
 begin
  DataModule10.Table2.Active := False;
  Label4.Visible := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox1.Text = Local then
        begin
          Trecho := Nome;
          Label4.Caption := Trecho;
          Label4.Visible := True;
          DataModule10.Table2.TableName := Dados + 'Cadas_' + Trecho + '_' + Year + '.dbf';
          DataModule10.Table2.Active := True;
        end;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
 end
else
 Label4.Visible := False;
end;

procedure TForm32.BitBtn3Click(Sender: TObject);
var
  ArqDados, Arq: TextFile;
  Arquivo, ArqCsv, ArqDbf, PathOut, PathDat, DadosAnoBase, Dados, Calc,
    Programa, Linha, ConfReg: string;
  Disco: string[1];
  Code, Year: string[4];
  i, j, i1, i2, AnoBase, Ano, NPeriodos, icont, NFields, jj, jk, jl: integer;
  Trecho: string[4];
  Tipo1: array [1..15] of string[5];
  Tipo2: array [1..15] of string[5];
  Faixa: array [1..4] of string[1];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..100] of string;
begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  PathOut := Dados;
  PathDat := Calc;
  Disco := PathDat[1];
  Faixa[1] := '1';
  Faixa[2] := '2';
  Faixa[3] := '3';
  Faixa[4] := '4';
  Tipo1[1] := 'Func';
  Tipo1[2] := 'ATR';
  Tipo1[3] := 'IRI';
  Tipo1[4] := 'Ampl';
  Tipo1[5] := 'Traf';
  Tipo2[1] := 'DFX';
  Tipo2[2] := 'MOD';
  Tipo2[3] := 'LVC';
  Tipo2[4] := 'SUP';
  if CheckBox1.Checked then
    begin
      ArqCsv := 'DOS.DAT';
      if FileExists(ArqCsv) then
        begin
          AssignFile(ArqDados, ArqCsv);
          Erase(ArqDados)
        end;
      WinExec('Geracsv.exe /c', SW_HIDE);
      Flag := 0;
      StartTime := now;
      NumSec := 10;
      repeat
        Application.ProcessMessages;
        if FileExists(ArqCsv) then Flag := 1;
      until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
    end;
  AssignFile(ArqDados, 'STHS.CSV');
  Reset(ArqDados);
  Arquivo := PathDat + 'STHS.DAT';
  AssignFile(Arq, Arquivo);
  Rewrite(Arq);
  while not Eof(ArqDados) do
    begin
      Readln(ArqDados, i1);
      Readln(ArqDados, i2);
      for j := i1 to i2 do
        begin
          if j < 10 then
            Code := '0000'
          else
            if j < 100 then
              Code := '000'
            else
              if j < 1000 then
                Code := '00'
              else
                if j < 10000 then
                  Code := '0'
                else
                  Code := '';
          ArqCsv := PathDat + 'HM' + Code + IntToStr(j) + '.csv';
          Writeln(Arq, ArqCsv);
        end;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  AssignFile(Arq, 'Arq.dat');
  Rewrite(Arq);
  Writeln(Arq, 1);
  CloseFile(Arq);
  Arquivo := DadosAnoBase + '\Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while not Eof(Arq) do
    begin
      Readln(Arq, Trecho);
      i1 := 1;
      i2 := 5;
      for i := i1 to i2 do
        begin
          ArqCsv := PathDat + Tipo1[i] + Trecho + '.csv';
          if i = 4 then
            ArqDbf := PathDat + Tipo1[i] + 'ia_' + Trecho + '.dbf'
          else
            ArqDbf := PathOut + Tipo1[i] + '_' + Trecho + '_' + Year + '.dbf';
          if i = 1 then
            begin
              NFields := 7;
              AssignFile(ArqDados, ArqCsv);
              Reset(ArqDados);
              Readln(ArqDados, Linha);
              with DataModule10.Table5 do
                begin
                  Active := False;
                  TableName := ArqDbf;
                  CreateTable;
                  Active := True;
                  Edit;
                  First;
                end;
              while not eof(ArqDados) do
                begin
                  Readln(ArqDados, Linha);
                  j := 1;
                  for icont := 1 to NFields do
                    Campo[icont] := '';
                  for icont := 1 to Length(Linha) do
                    begin
                      if Linha[icont] = ',' then
                        j := j + 1
                      else
                        if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
                    end;
                  if ConfReg = 'Portuguese' then
                    begin
                      for j := 2 to 5 do
                        begin
                          for jk := 1 to Length(Campo[j]) do
                            if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                        end;
                    end;
                  for icont := 1 to NFields do
                    begin
                      Linha := '';
                      for jl := 1 to Length(Campo[icont]) do
                        if Campo[icont, jl] <> '"' then Linha := Linha + Campo[icont, jl];
                      Campo[icont] := Linha;
                    end;
                  DataModule10.Table5.InsertRecord([Campo[1],StrToFloat(Campo[2]),
                    StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),
                    Campo[6],Campo[7]]);
                end;
              DataModule10.Table5.Close;
              DataModule10.Table5.Active := False;
              CloseFile(ArqDados);
            end
          else
            if i = 2 then
              begin
                NFields := 19;
                AssignFile(ArqDados, ArqCsv);
                Reset(ArqDados);
                Readln(ArqDados, Linha);
                with DataModule10.Table10 do
                  begin
                    Active := False;
                    TableName := ArqDbf;
                    CreateTable;
                    Active := True;
                    Edit;
                    First;
                  end;
                while not eof(ArqDados) do
                  begin
                    Readln(ArqDados, Linha);
                    j := 1;
                    for icont := 1 to NFields do
                      Campo[icont] := '';
                    for icont := 1 to Length(Linha) do
                      begin
                        if Linha[icont] = ',' then
                          j := j + 1
                        else
                          if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
                      end;
                    if ConfReg = 'Portuguese' then
                      begin
                        for j := 2 to 9 do
                          begin
                            for jk := 1 to Length(Campo[j]) do
                              if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                          end;
                        for j := 12 to 19 do
                          begin
                            for jk := 1 to Length(Campo[j]) do
                              if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                          end;
                      end;
                    for icont := 1 to NFields do
                      begin
                        Linha := '';
                        for jl := 1 to Length(Campo[icont]) do
                          if Campo[icont, jl] <> '"' then Linha := Linha + Campo[icont, jl];
                        Campo[icont] := Linha;
                      end;
                    DataModule10.Table10.InsertRecord([Campo[1],StrToFloat(Campo[2]),
                      StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),
                      StrToFloat(Campo[6]),StrToFloat(Campo[7]),StrToFloat(Campo[8]),
                      StrToFloat(Campo[9]),Campo[10],Campo[11],StrToFloat(Campo[12]),
                      StrToFloat(Campo[13]),StrToFloat(Campo[14]),StrToFloat(Campo[15]),
                      StrToFloat(Campo[16]),StrToFloat(Campo[17]),StrToFloat(Campo[18]),
                      StrToFloat(Campo[19])]);
                  end;
                DataModule10.Table10.Close;
                DataModule10.Table10.Active := False;
                CloseFile(ArqDados);
              end
            else
             if i = 3 then
               begin
                 NFields := 7;
                 AssignFile(ArqDados, ArqCsv);
                 Reset(ArqDados);
                 Readln(ArqDados, Linha);
                 with DataModule10.Table16 do
                   begin
                     Active := False;
                     TableName := ArqDbf;
                     CreateTable;
                     Active := True;
                     Edit;
                     First;
                   end;
                 while not eof(ArqDados) do
                   begin
                     Readln(ArqDados, Linha);
                     j := 1;
                     for icont := 1 to NFields do
                       Campo[icont] := '';
                     for icont := 1 to Length(Linha) do
                       begin
                         if Linha[icont] = ',' then
                           j := j + 1
                         else
                           if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
                       end;
                    if ConfReg = 'Portuguese' then
                      begin
                        for j := 2 to 5 do
                          begin
                            for jk := 1 to Length(Campo[j]) do
                              if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                          end;
                      end;
                    for icont := 1 to NFields do
                      begin
                        Linha := '';
                        for jl := 1 to Length(Campo[icont]) do
                          if Campo[icont, jl] <> '"' then Linha := Linha + Campo[icont, jl];
                        Campo[icont] := Linha;
                      end;
                    DataModule10.Table16.InsertRecord([Campo[1],StrToFloat(Campo[2]),
                      StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),
                      Campo[6],Campo[7]]);
                   end;
                 DataModule10.Table16.Close;
                 DataModule10.Table16.Active := False;
                 CloseFile(ArqDados);
               end
             else
               if i = 4 then
                 begin
                   NFields := 6;
                   AssignFile(ArqDados, ArqCsv);
                   Reset(ArqDados);
                   Readln(ArqDados, Linha);
                   with DataModule24.Table33 do
                     begin
                       Active := False;
                       TableName := ArqDbf;
                       CreateTable;
                       Active := True;
                       Edit;
                       First;
                     end;
                   while not eof(ArqDados) do
                     begin
                       Readln(ArqDados, Linha);
                       j := 1;
                       for icont := 1 to NFields do
                         Campo[icont] := '';
                       for icont := 1 to Length(Linha) do
                         begin
                           if Linha[icont] = ',' then
                             j := j + 1
                           else
                             if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
                         end;
                       if ConfReg = 'Portuguese' then
                         begin
                           for j := 2 to 6 do
                             begin
                               for jk := 1 to Length(Campo[j]) do
                                 if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                             end;
                         end;
                      for icont := 1 to NFields do
                        begin
                          Linha := '';
                          for jl := 1 to Length(Campo[icont]) do
                            if Campo[icont, jl] <> '"' then Linha := Linha + Campo[icont, jl];
                          Campo[icont] := Linha;
                        end;
                       DataModule24.Table33.InsertRecord([Campo[1],StrToFloat(Campo[2]),
                         StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5]),
                         StrToFloat(Campo[6])]);
                     end;
                   DataModule24.Table33.Close;
                   DataModule24.Table33.Active := False;
                   CloseFile(ArqDados);
                 end
               else
                 begin
                   NFields := 13;
                   AssignFile(ArqDados, ArqCsv);
                   Reset(ArqDados);
                   Readln(ArqDados, Linha);
                   with DataModule10.Table7 do
                     begin
                       Active := False;
                       TableName := ArqDbf;
                       CreateTable;
                       Active := True;
                       Edit;
                       First;
                     end;
                   while not eof(ArqDados) do
                     begin
                       Readln(ArqDados, Linha);
                       j := 1;
                       for icont := 1 to NFields do
                         Campo[icont] := '';
                       for icont := 1 to Length(Linha) do
                         begin
                           if Linha[icont] = ',' then
                             j := j + 1
                           else
                             if Linha[icont] <> '' then Campo[j] := Campo[j] + Linha[icont];
                         end;
                       if ConfReg = 'Portuguese' then
                         begin
                           for j := 3 to 13 do
                             begin
                               for jk := 1 to Length(Campo[j]) do
                                 if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                             end;
                         end;
                       for icont := 1 to NFields do
                        begin
                          Linha := '';
                          for jl := 1 to Length(Campo[icont]) do
                            if Campo[icont, jl] <> '"' then Linha := Linha + Campo[icont, jl];
                          Campo[icont] := Linha;
                        end;
                       DataModule10.Table7.InsertRecord([Campo[1],Campo[2],StrToFloat(Campo[3]),
                         StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),
                         StrToFloat(Campo[7]),StrToFloat(Campo[8]),StrToFloat(Campo[9]),
                         StrToFloat(Campo[10]),StrToFloat(Campo[11]),StrToFloat(Campo[12]),
                         StrToFloat(Campo[13])]);
                     end;
                   DataModule10.Table7.Close;
                   DataModule10.Table7.Active := False;
                   CloseFile(ArqDados);
                 end;
        end;
      i1 := 1;
      i2 := 4;
      for i := i1 to i2 do
        begin
          for j := 1 to 4 do
            begin
              ArqCsv := PathDat + Tipo2[i] + Trecho + Faixa[j] + '.csv';
              ArqDbf := PathOut + Tipo2[i] + '_' + Trecho + Faixa[j] + '_' + Year + '.dbf';
              if i = 1 then
                 begin
                   NFields := 22;
                   AssignFile(ArqDados, ArqCsv);
                   Reset(ArqDados);
                   Readln(ArqDados, Linha);
                   with DataModule10.Table3 do
                     begin
                       Active := False;
                       TableName := ArqDbf;
                       CreateTable;
                       Active := True;
                       Edit;
                       First;
                     end;
                   while not eof(ArqDados) do
                     begin
                       Readln(ArqDados, Linha);
                       jj := 1;
                       for icont := 1 to NFields do
                         Campo[icont] := '';
                       for icont := 1 to Length(Linha) do
                         begin
                           if Linha[icont] = ',' then
                             jj := jj + 1
                           else
                             if Linha[icont] <> '' then Campo[jj] := Campo[jj] + Linha[icont];
                         end;
                       if ConfReg = 'Portuguese' then
                         begin
                           for jl := 2 to 20 do
                             begin
                               for jk := 1 to Length(Campo[jl]) do
                                 if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                             end;
                         end;
                       for icont := 1 to NFields do
                        begin
                          Linha := '';
                          for jl := 1 to Length(Campo[icont]) do
                            if Campo[icont, jl] <> '"' then Linha := Linha + Campo[icont, jl];
                          Campo[icont] := Linha;
                        end;
                       DataModule10.Table3.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                         StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),
                         StrToFloat(Campo[7]),StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),
                         StrToFloat(Campo[11]),StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),
                         StrToFloat(Campo[15]),StrToFloat(Campo[16]),StrToFloat(Campo[17]),StrToFloat(Campo[18]),
                         StrToFloat(Campo[19]),StrToFloat(Campo[20]),Campo[21],Campo[22]]);
                     end;
                   DataModule10.Table3.Close;
                   DataModule10.Table3.Active := False;
                   CloseFile(ArqDados);
                 end
              else
                if i = 2 then
                  begin
                    NFields := 17;
                    AssignFile(ArqDados, ArqCsv);
                    Reset(ArqDados);
                    Readln(ArqDados, Linha);
                    with DataModule10.Table12 do
                      begin
                        Active := False;
                        TableName := ArqDbf;
                        CreateTable;
                        Active := True;
                        Edit;
                        First;
                      end;
                    while not eof(ArqDados) do
                      begin
                        Readln(ArqDados, Linha);
                        jj := 1;
                        for icont := 1 to NFields do
                          Campo[icont] := '';
                        for icont := 1 to Length(Linha) do
                          begin
                            if Linha[icont] = ',' then
                              jj := jj + 1
                            else
                              if Linha[icont] <> '' then Campo[jj] := Campo[jj] + Linha[icont];
                          end;
                        if ConfReg = 'Portuguese' then
                          begin
                            for jl := 2 to 15 do
                              begin
                                for jk := 1 to Length(Campo[jl]) do
                                  if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                              end;
                          end;
                       for icont := 1 to NFields do
                        begin
                          Linha := '';
                          for jl := 1 to Length(Campo[icont]) do
                            if Campo[icont, jl] <> '"' then Linha := Linha + Campo[icont, jl];
                          Campo[icont] := Linha;
                        end;
                        DataModule10.Table12.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                          StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),
                          StrToFloat(Campo[7]),StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),
                          StrToFloat(Campo[11]),StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),
                          StrToFloat(Campo[15]),Campo[16],Campo[17]]);
                      end;
                    DataModule10.Table12.Close;
                    DataModule10.Table12.Active := False;
                    CloseFile(ArqDados);
                  end
                else
                  if i = 3 then
                    begin
                      NFields := 39;
                      AssignFile(ArqDados, ArqCsv);
                      Reset(ArqDados);
                      Readln(ArqDados, Linha);
                      with DataModule10.Table6 do
                        begin
                          Active := False;
                          TableName := ArqDbf;
                          CreateTable;
                          Active := True;
                          Edit;
                          First;
                        end;
                      while not eof(ArqDados) do
                        begin
                          Readln(ArqDados, Linha);
                          jj := 1;
                          for icont := 1 to NFields do
                            Campo[icont] := '';
                          for icont := 1 to Length(Linha) do
                            begin
                              if Linha[icont] = ',' then
                                jj := jj + 1
                              else
                                if Linha[icont] <> '' then Campo[jj] := Campo[jj] + Linha[icont];
                            end;
                          if ConfReg = 'Portuguese' then
                            begin
                              for jl := 2 to 4 do
                                begin
                                  for jk := 1 to Length(Campo[jl]) do
                                    if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                                end;
                              for jl := 36 to 37 do
                                begin
                                  for jk := 1 to Length(Campo[jl]) do
                                    if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                                end;
                            end;
                          for icont := 1 to NFields do
                           begin
                            Linha := '';
                            for jl := 1 to Length(Campo[icont]) do
                              if Campo[icont, jl] <> '"' then Linha := Linha + Campo[icont, jl];
                            Campo[icont] := Linha;
                           end;
                          DataModule10.Table6.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                            StrToFloat(Campo[4]),Campo[5],Campo[6],Campo[7],Campo[8],Campo[9],
                            Campo[10],Campo[11],Campo[12],Campo[13],Campo[14],Campo[15],
                            Campo[16],Campo[17],Campo[18],Campo[19],Campo[20],Campo[21],
                            Campo[22],Campo[23],Campo[24],Campo[25],Campo[26],Campo[27],
                            Campo[28],Campo[29],Campo[30],Campo[31],Campo[32],Campo[33],
                            Campo[34],Campo[35],StrToFloat(Campo[36]),StrToFloat(Campo[37]),
                            Campo[38],Campo[39]]);
                        end;
                      DataModule10.Table6.Close;
                      DataModule10.Table6.Active := False;
                      CloseFile(ArqDados);
                    end
                  else
                    begin
                      NFields := 26;
                      AssignFile(ArqDados, ArqCsv);
                      Reset(ArqDados);
                      Readln(ArqDados, Linha);
                      with DataModule10.Table17 do
                        begin
                          Active := False;
                          TableName := ArqDbf;
                          CreateTable;
                          Active := True;
                          Edit;
                          First;
                        end;
                      while not eof(ArqDados) do
                        begin
                          Readln(ArqDados, Linha);
                          jj := 1;
                          for icont := 1 to NFields do
                            Campo[icont] := '';
                          for icont := 1 to Length(Linha) do
                            begin
                              if Linha[icont] = ',' then
                                jj := jj + 1
                              else
                                if Linha[icont] <> '' then Campo[jj] := Campo[jj] + Linha[icont];
                            end;
                          if ConfReg = 'Portuguese' then
                            begin
                              for jl := 2 to 4 do
                                begin
                                  for jk := 1 to Length(Campo[jl]) do
                                    if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                                end;
                              for jl := 23 to 24 do
                                begin
                                  for jk := 1 to Length(Campo[jl]) do
                                    if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                                end;
                            end;
                          for icont := 1 to NFields do
                            begin
                              Linha := '';
                              for jl := 1 to Length(Campo[icont]) do
                                if Campo[icont, jl] <> '"' then Linha := Linha + Campo[icont, jl];
                              Campo[icont] := Linha;
                            end;
                          DataModule10.Table17.InsertRecord([Campo[1],StrToFloat(Campo[2]),StrToFloat(Campo[3]),
                            StrToFloat(Campo[4]),Campo[5],Campo[6],Campo[7],Campo[8],Campo[9],
                            Campo[10],Campo[11],Campo[12],Campo[13],Campo[14],Campo[15],
                            Campo[16],Campo[17],Campo[18],Campo[19],Campo[20],Campo[21],
                            Campo[22],StrToFloat(Campo[23]),StrToFloat(Campo[24]),
                            Campo[25],Campo[26]]);
                        end;
                      DataModule10.Table17.Close;
                      DataModule10.Table17.Active := False;
                      CloseFile(ArqDados);
                    end;
            end;
        end;
    end;
  CloseFile(Arq);
  AssignFile(Arq, 'STHS.CSV');
  Reset(Arq);
  while not Eof(Arq) do
   begin
    Readln(Arq, i1);
    Readln(Arq, i2);
    for j := i1 to i2 do
      begin
        if j < 10 then
          Code := '0000'
        else
          if j < 100 then
            Code := '000'
          else
            if j < 1000 then
              Code := '00'
            else
              if j < 10000 then
                Code := '0'
              else
                Code := '';
        ArqCsv := PathDat + 'HM' + Code + IntToStr(j) + '.csv';
        ArqDbf := PathOut + 'HistMan\HM_' + Code + IntToStr(j) + '.dbf';
        NFields := 19;
        AssignFile(ArqDados, ArqCsv);
        Reset(ArqDados);
        Readln(ArqDados, Linha);
        with DataModule10.Table9 do
          begin
            Active := False;
            TableName := ArqDbf;
            CreateTable;
            Active := True;
            Edit;
            First;
          end;
        while not eof(ArqDados) do
          begin
            Readln(ArqDados, Linha);
            jj := 1;
            for icont := 1 to NFields do
              Campo[icont] := '';
            for icont := 1 to Length(Linha) do
              begin
                if Linha[icont] = ',' then
                  jj := jj + 1
                else
                  if Linha[icont] <> '' then Campo[jj] := Campo[jj] + Linha[icont];
              end;
            if ConfReg = 'Portuguese' then
              begin
                for jl := 5 to 7 do
                  begin
                    for jk := 1 to Length(Campo[jl]) do
                      if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                  end;
                for jl := 9 to 11 do
                  begin
                    for jk := 1 to Length(Campo[jl]) do
                      if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                  end;
                for jl := 13 to 15 do
                  begin
                    for jk := 1 to Length(Campo[jl]) do
                      if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                  end;
                for jl := 17 to 19 do
                  begin
                    for jk := 1 to Length(Campo[jl]) do
                      if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                  end;
              end;
            for icont := 1 to NFields do
              begin
                Linha := '';
                for jl := 1 to Length(Campo[icont]) do
                  if Campo[icont, jl] <> '"' then Linha := Linha + Campo[icont, jl];
                Campo[icont] := Linha;
              end;
            DataModule10.Table9.InsertRecord([Campo[1],Campo[2],Campo[3],Campo[4],StrToFloat(Campo[5]),
              StrToFloat(Campo[6]),StrToFloat(Campo[7]),Campo[8],StrToFloat(Campo[9]),StrToFloat(Campo[10]),
              StrToFloat(Campo[11]),Campo[12],StrToFloat(Campo[13]),StrToFloat(Campo[14]),
              StrToFloat(Campo[15]),Campo[16],
              StrToFloat(Campo[17]),StrToFloat(Campo[18]),StrToFloat(Campo[19])]);
          end;
        DataModule10.Table9.Close;
        DataModule10.Table9.Active := False;
        CloseFile(ArqDados);
      end;
   end;
  CloseFile(Arq);
  Screen.Cursor := crDefault;
end;

procedure TForm32.BitBtn4Click(Sender: TObject);
var
  ArqDados: TextFile;
  Year: string[4];
  Campo: array [1..30] of string;
  Arquivo, Programa, Dados, Calc, DadosAnoBase, ArqCsv, ArqDbf, Code, kmi,
    DescrTrecho, Linha: string;
  Ano, NPeriodos, NRodov, i1, i2, i, j, icont, NFields: integer;
  Rodovia: array [1..350] of string[4];
begin
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
    Year := IntToStr(Ano);
  Label3.Visible := True;
  ComboBox1.Visible := True;
  DataModule10.Table2.Active := False;
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
end;

procedure TForm32.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked = True then CheckBox2.Checked := False;
  if CheckBox1.Checked = False then CheckBox2.Checked := True;
end;

procedure TForm32.CheckBox2Click(Sender: TObject);
begin
  if CheckBox2.Checked = True then CheckBox1.Checked := False;
  if CheckBox2.Checked = False then CheckBox1.Checked := True;
end;

procedure TForm32.FormShow(Sender: TObject);
begin
  Label4.Caption := '';
  Button1.Visible := True;
  BitBtn2.Visible := False;
end;

procedure TForm32.Button1Click(Sender: TObject);
var
  ExtBase, ExtMin: Single;
  ArqDados, Arq, ArqOut: TextFile;
  Codigo: string[2];
  Year: string[4];
  Campo: array [1..200] of string;
  Arquivo, Programa, Dados, Calc, DadosAnoBase, ArqCsv, ArqDbf, Code, kmi,
    DescrTrecho, Linha, DTre, LinhaX, LinhaY, ConfReg: string;
  Ano, NPeriodos, NRodov, i1, i2, i, j, icont, NFields, jj, jk, jl: integer;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Atualiza: string[3];
  Rodovia: array [1..350] of string[4];
  Faixa: array [1..4] of string[1];
begin
 if Edit2.Text <> '' then
 begin
  Screen.Cursor := crHourglass;
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
    Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  Faixa[1] := '1';
  Faixa[2] := '2';
  Faixa[3] := '3';
  Faixa[4] := '4';
  NRodov := StrToInt(Edit2.Text);
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  Arquivo := Dados + 'ParSCR.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, ExtBase);
  Writeln(ArqDados, NRodov);
  Writeln(ArqDados, ExtMin);
  CloseFile(ArqDados);
  Arquivo := 'DOS.DAT';
  if FileExists(Arquivo) then
    begin
      AssignFile(ArqDados, Arquivo);
      Erase(ArqDados)
    end;
  WinExec('Conv2.exe /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 7;
  repeat
    Application.ProcessMessages;
    if FileExists(Arquivo) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  for i := 1 to NRodov do
    begin
      ArqDbf := Dados + 'Cadas_' + Rodovia[i] + '_' + Year + '.dbf';
      ArqCsv := Calc + 'Cadas' + Rodovia[i] + '.csv';
      NFields := 25;
      AssignFile(ArqDados, ArqCsv);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      with DataModule10.Table2 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
            end;
          if ConfReg = 'Portuguese' then
            begin
              for j := 5 to 6 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
              for j := 8 to 14 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
              for j := 18 to 24 do
                begin
                  for jk := 1 to Length(Campo[j]) do
                    if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                end;
            end;
          DataModule10.Table2.InsertRecord([Campo[1],Campo[2],Campo[3],Campo[4],StrToFloat(Campo[5]),
            StrToFloat(Campo[6]),Campo[7],StrToFloat(Campo[8]),StrToFloat(Campo[9]),StrToFloat(Campo[10]),
            StrToFloat(Campo[11]),StrToFloat(Campo[12]),StrToFloat(Campo[13]),StrToFloat(Campo[14]),
            Campo[15],Campo[16],Campo[17],StrToFloat(Campo[18]),StrToFloat(Campo[19]),
            StrToFloat(Campo[20]),StrToFloat(Campo[21]),StrToFloat(Campo[22]),StrToFloat(Campo[23]),
            StrToFloat(Campo[24]),Campo[25]]);
        end;
      DataModule10.Table2.Close;
      DataModule10.Table2.Active := False;
      CloseFile(ArqDados);
    end;
  for i := 1 to NRodov do
    begin
      ArqDbf := Dados + 'Cadas_' + Rodovia[i] + '_' + Year + '.dbf';
      ArqCsv := Calc + 'Cadas' + Rodovia[i] + '.csv';
      AssignFile(ArqDados, ArqCsv);
      Rewrite(ArqDados);
      Linha := 'STH, RODOVIA, INICIO, FIM, KMINICIAL, KMFINAL, PISTA, NFAIXAS, PLUVMMANO, ALTM, PLATAFM, LARGPISTA, ACOSTLE, ACOSTLD, GEOVERT, GEOHORIZ, SECTIPO, FAIXA1M, FAIXA2M, FAIXA3M, FAIXA4M, DECTRANSV, RESTRCOTA, EXTPONTES, OBS';
      NFields := 1;
      for icont := 1 to Length(Linha) do
        if Linha[icont] = ',' then NFields := NFields + 1;
      Writeln(ArqDados, Linha);
      with DataModule10.Table2 do
        begin
          Active := False;
          TableName := ArqDbf;
          Active := True;
          First;
          while not Eof do
            begin
              LinhaX := Fields.Fields[0].AsString;
              Linha := '';
              for jk := 1 to Length(LinhaX) do
                begin
                  if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                  Linha := Linha + LinhaX[jk];
                end;
              for icont := 1 to NFields-1 do
                begin
                  LinhaX := Fields.Fields[icont].AsString;
                  LinhaY := '';
                  for jk := 1 to Length(LinhaX) do
                    begin
                      if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                      LinhaY := LinhaY + LinhaX[jk];
                    end;
                  Linha := Linha + ',' + LinhaY;
                end;
              Writeln(ArqDados, Linha);
              Next;
            end;
          Active := False;
        end;
      CloseFile(ArqDados);
    end;
  Arquivo := 'DOS.DAT';
  if FileExists(Arquivo) then
    begin
      AssignFile(ArqDados, Arquivo);
      Erase(ArqDados)
    end;
  WinExec('ConvEstr.exe /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 7;
  repeat
    Application.ProcessMessages;
    if FileExists(Arquivo) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  for i := 1 to NRodov do
    begin
      ArqDbf := Dados + 'Acost_' + Rodovia[i] + '_' + Year + '.dbf';
      ArqCsv := Calc + 'Acost' + Rodovia[i] + '.csv';
      NFields := 14;
      AssignFile(ArqDados, ArqCsv);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      with DataModule10.Table1 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
            end;
          if ConfReg = 'Portuguese' then
            begin
              j := 3;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 5;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 7;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 9;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 10;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
              j := 13;
              for jk := 1 to Length(Campo[j]) do
                if Campo[j,jk] = '.' then Campo[j,jk] := ',';
            end;
          DataModule10.Table1.InsertRecord([Campo[1],Campo[2],StrToFloat(Campo[3]),Campo[4],
            StrToFloat(Campo[5]),Campo[6],StrToFloat(Campo[7]),Campo[8],StrToFloat(Campo[9]),
            StrToFloat(Campo[10]),Campo[11],Campo[12],StrToFloat(Campo[13]),Campo[14]]);
        end;
      DataModule10.Table1.Close;
      DataModule10.Table1.Active := False;
      CloseFile(ArqDados);
      for j := 1 to 4 do
        begin
          ArqCsv := Calc + 'Estr' + Rodovia[i] + Faixa[j] + '.csv';
          ArqDbf := Dados + 'Estr' + '_' + Rodovia[i] + Faixa[j] + '_' + Year + '.dbf';
          NFields := 25;
          AssignFile(ArqDados, ArqCsv);
          Reset(ArqDados);
          Readln(ArqDados, Linha);
          with DataModule10.Table4 do
            begin
              Active := False;
              TableName := ArqDbf;
              CreateTable;
              Active := True;
              Edit;
              First;
            end;
          while not eof(ArqDados) do
            begin
              Readln(ArqDados, Linha);
              jj := 1;
              for icont := 1 to NFields do
                Campo[icont] := '';
              for icont := 1 to Length(Linha) do
                begin
                  if Linha[icont] = ',' then
                    jj := jj + 1
                  else
                    if Linha[icont] <> '"' then Campo[jj] := Campo[jj] + Linha[icont];
                end;
              if ConfReg = 'Portuguese' then
                begin
                  for jl := 4 to 8 do
                    begin
                      for jk := 1 to Length(Campo[jl]) do
                        if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                    end;
                  for jl := 10 to 12 do
                    begin
                      for jk := 1 to Length(Campo[jl]) do
                        if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                    end;
                  for jl := 14 to 16 do
                    begin
                      for jk := 1 to Length(Campo[jl]) do
                        if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                    end;
                  for jl := 18 to 20 do
                    begin
                      for jk := 1 to Length(Campo[jl]) do
                        if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                    end;
                  for jl := 22 to 25 do
                    begin
                      for jk := 1 to Length(Campo[jl]) do
                        if Campo[jl,jk] = '.' then Campo[jl,jk] := ',';
                    end;
                end;
              DataModule10.Table4.InsertRecord([Campo[1],Campo[2],Campo[3],
                StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),
                StrToFloat(Campo[7]),StrToFloat(Campo[8]),Campo[9],StrToFloat(Campo[10]),
                StrToFloat(Campo[11]),StrToFloat(Campo[12]),Campo[13],StrToFloat(Campo[14]),
                StrToFloat(Campo[15]),StrToFloat(Campo[16]),Campo[17],StrToFloat(Campo[18]),
                StrToFloat(Campo[19]),Campo[20],StrToFloat(Campo[21]),StrToFloat(Campo[22]),
                StrToFloat(Campo[23]),StrToFloat(Campo[24]),StrToFloat(Campo[25])]);
            end;
          DataModule10.Table4.Close;
          DataModule10.Table4.Active := False;
          CloseFile(ArqDados);
        end;
    end;
  for i := 1 to NRodov do
   begin
    ArqDbf := Dados + 'Acost_' + Rodovia[i] + '_' + Year + '.dbf';
    ArqCsv := Calc + 'Acost' + Rodovia[i] + '.csv';
    AssignFile(ArqDados, ArqCsv);
    Rewrite(ArqDados);
    Linha := 'STH,USO,ANOREVEST,REVEST,H1CM,BASE,H2CM,SUBBASE,H3CM,DECTRANSV,SUPPISTA,SUPACOST,HLFREATM,INUNDTEMP';
    NFields := 1;
    for icont := 1 to Length(Linha) do
      if Linha[icont] = ',' then NFields := NFields + 1;
    Writeln(ArqDados, Linha);
    with DataModule10.Table1 do
    begin
      Active := False;
      TableName := ArqDbf;
      Active := True;
      First;
      while not Eof do
        begin
          LinhaX := Fields.Fields[0].AsString;
          Linha := '';
          for jk := 1 to Length(LinhaX) do
            begin
              if LinhaX[jk] = ',' then LinhaX[jk] := '.';
              Linha := Linha + LinhaX[jk];
            end;
          for icont := 1 to NFields-1 do
            begin
              LinhaX := Fields.Fields[icont].AsString;
              LinhaY := '';
              for jk := 1 to Length(LinhaX) do
                begin
                  if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                  LinhaY := LinhaY + LinhaX[jk];
                end;
              Linha := Linha + ',' + LinhaY;
            end;
          Writeln(ArqDados, Linha);
          Next;
        end;
      Active := False;
    end;
    CloseFile(ArqDados);
    for j := 1 to 4 do
    begin
        ArqCsv := Calc + 'Estr' + Rodovia[i] + Faixa[j] + '.csv';
        ArqDbf := Dados + 'Estr' + '_' + Rodovia[i] + Faixa[j] + '_' + Year + '.dbf';
        AssignFile(ArqDados, ArqCsv);
        Rewrite(ArqDados);
        Linha := 'STH,ANOREVEST,REVEST,MARSHALL,RTDIAMET,VAZIOSAR,TEORASF,H1ORIGCM,BASE,H2CM,CBRBASE,RCS28DBASE,SUBBASE,H3CM,CBRSUBBASE,RCS28DSUBB,REFSL,H4CM,CBRREFSL,SUBLEITO,CBRSL,LLSL,IPSL,PERCT200,PROFROCHA';
        NFields := 1;
        for icont := 1 to Length(Linha) do
          if Linha[icont] = ',' then NFields := NFields + 1;
        Writeln(ArqDados, Linha);
        with DataModule10.Table4 do
        begin
          Active := False;
          TableName := ArqDbf;
          Active := True;
          First;
          while not Eof do
          begin
            LinhaX := Fields.Fields[0].AsString;
            Linha := '';
            for jk := 1 to Length(LinhaX) do
              begin
                if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                Linha := Linha + LinhaX[jk];
              end;
            for icont := 1 to NFields-1 do
              begin
                LinhaX := Fields.Fields[icont].AsString;
                LinhaY := '';
                for jk := 1 to Length(LinhaX) do
                  begin
                    if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                    LinhaY := LinhaY + LinhaX[jk];
                  end;
                Linha := Linha + ',' + LinhaY;
              end;
            Writeln(ArqDados, Linha);
            Next;
          end;
          Active := False;
        end;
        CloseFile(ArqDados);
    end;
   end;
  AssignFile(ArqDados, 'STHS.CSV');
  Reset(ArqDados);
  Arquivo := Calc + 'STHS.DAT';
  AssignFile(Arq, Arquivo);
  Rewrite(Arq);
  while not Eof(ArqDados) do
    begin
      Readln(ArqDados, i1);
      Readln(ArqDados, i2);
      for j := i1 to i2 do
        begin
          if j < 10 then
            Code := '0000'
          else
            if j < 100 then
              Code := '000'
            else
              if j < 1000 then
                Code := '00'
              else
                if j < 10000 then
                  Code := '0'
                else
                  Code := '';
          ArqCsv := Calc + 'HM' + Code + IntToStr(j) + '.csv';
          Writeln(Arq, ArqCsv);
        end;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  ArqCsv := 'DOS2.DAT';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  WinExec('Hist2.exe /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 10;
  repeat
    Application.ProcessMessages;
    if FileExists(ArqCsv) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Gera os arquivos Trechos.dat e Tre.dat }
  AssignFile(ArqDados, 'Arq.dat');
  Rewrite(ArqDados);
  Writeln(ArqDados, 1);
  CloseFile(ArqDados);
  Label3.Visible := True;
  ComboBox1.Visible := True;
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
  AssignFile(ArqDados, 'Acesso.dat');
  Reset(ArqDados);
  Readln(ArqDados, Atualiza);
  CloseFile(ArqDados);
  if Atualiza = 'Sim' then
    DBGrid1.ReadOnly := False
  else
    DBGrid1.ReadOnly := True;
  Screen.Cursor := crDefault;
 end;
end;

procedure TForm32.CheckBox3Click(Sender: TObject);
begin
  if CheckBox3.Checked = True then
    begin
      CheckBox4.Checked := False;
      Button1.Visible := True;
      BitBtn2.Visible := False;
    end;
  if CheckBox3.Checked = False then
    begin
      CheckBox4.Checked := True;
      Button1.Visible := False;
      BitBtn2.Visible := True;
    end;
end;

procedure TForm32.CheckBox4Click(Sender: TObject);
begin
  if CheckBox4.Checked = True then CheckBox3.Checked := False;
  if CheckBox4.Checked = False then CheckBox3.Checked := True;
end;

initialization
  CoInitialize (nil);

end.
