unit Unit31;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, DB, Grids, DBGrids, Buttons, ExtCtrls;

type
  TForm31 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    BitBtn3: TBitBtn;
    Label2: TLabel;
    ComboBox1: TComboBox;
    procedure GDT1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form31: TForm31;

implementation

uses Childwin, ComObj, ActiveX, Unit95, Unit94;

{$R *.dfm}

procedure TForm31.GDT1Click(Sender: TObject);
begin
  MDIChild.GDT1Click(Sender);
end;

procedure TForm31.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm31.CheckBox1Click(Sender: TObject);
var
  ArqDados: TextFile;
  Arquivo, Programa, Dados, Calc, DadosAnoBase: string;
  Ano, NPeriodos: integer;
begin
  if CheckBox1.Checked = True then CheckBox2.Checked := False;
  if CheckBox1.Checked = False then CheckBox2.Checked := True;
  ComboBox1.Text := '';
 { Ano-base e subdiretrios }
   AssignFile(ArqDados, 'Diretor.dat');
   Reset(ArqDados);
   Readln(ArqDados, Ano);
   Readln(ArqDados, NPeriodos);
   Readln(ArqDados, Programa);
   Readln(ArqDados, Dados);
   Readln(ArqDados, Calc);
   Readln(ArqDados, DadosAnoBase);
   CloseFile(ArqDados);
 if CheckBox1.Checked then
   begin
     Arquivo := Dados + 'Importa\GDT.dat';
     ComboBox1.Items.LoadFromFile(Arquivo);
     BitBtn3.Visible := False;
   end;
end;

procedure TForm31.CheckBox2Click(Sender: TObject);
var
  ArqDados: TextFile;
  Arquivo, Programa, Dados, Calc, DadosAnoBase: string;
  Ano, NPeriodos: integer;
begin
  if CheckBox2.Checked = True then CheckBox1.Checked := False;
  if CheckBox2.Checked = False then CheckBox1.Checked := True;
  ComboBox1.Text := '';
 { Ano-base e subdiretrios }
   AssignFile(ArqDados, 'Diretor.dat');
   Reset(ArqDados);
   Readln(ArqDados, Ano);
   Readln(ArqDados, NPeriodos);
   Readln(ArqDados, Programa);
   Readln(ArqDados, Dados);
   Readln(ArqDados, Calc);
   Readln(ArqDados, DadosAnoBase);
   CloseFile(ArqDados);
 if CheckBox2.Checked then
   begin
     Arquivo := Dados + 'Importa\CUBE.dat';
     ComboBox1.Items.LoadFromFile(Arquivo);
     BitBtn3.Visible := True;
   end;
end;

procedure TForm31.FormShow(Sender: TObject);
var
  ArqDados: TextFile;
  Arquivo, Programa, Dados, Calc, DadosAnoBase, ArqXls: string;
  Ano, NPeriodos, i: integer;
begin
 BitBtn3.Visible := False;
 DataModule95.Table3.Active := False;
 { Ano-base e subdiretrios }
   AssignFile(ArqDados, 'Diretor.dat');
   Reset(ArqDados);
   Readln(ArqDados, Ano);
   Readln(ArqDados, NPeriodos);
   Readln(ArqDados, Programa);
   Readln(ArqDados, Dados);
   Readln(ArqDados, Calc);
   Readln(ArqDados, DadosAnoBase);
   CloseFile(ArqDados);
 Arquivo := Dados + 'Importa\GDT.dat';
 AssignFile(ArqDados, Arquivo);
 Rewrite(ArqDados);
 for i := 2007 to Ano do
   begin
     ArqXls := Dados + 'Importa\ArquivoGDT_VMDA' + IntToStr(i) +'.xls';
     if FileExists(ArqXls) then Writeln(ArqDados, IntToStr(i));
   end;
 CloseFile(ArqDados);
 Arquivo := Dados + 'Importa\CUBE.dat';
 AssignFile(ArqDados, Arquivo);
 Rewrite(ArqDados);
 for i := Ano to Ano+NPeriodos do
   begin
     ArqXls := Dados + 'Importa\ArquivoCUBE_VMDA' + IntToStr(i) +'.dbf';
     if FileExists(ArqXls) then Writeln(ArqDados, IntToStr(i));
   end;
 CloseFile(ArqDados);
end;

procedure TForm31.BitBtn3Click(Sender: TObject);
var
  Excel: OleVariant;
  ArqDados: TextFile;
  Year: string[4];
  Arquivo, Programa, Dados, Calc, DadosAnoBase, ArqXls, ArqDbf, ArqCsv: string;
  FileCodeExcel, Ano, NPeriodos, NRodov: integer;
  Rodovia: array [1..350] of string[4];
begin
 if ComboBox1.Text <> '' then
  begin
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
    Year := IntToStr(Ano);
    ArqXls := Dados + 'Importa\ArquivoGDT_VMDA' + ComboBox1.Text +'.xls';
    if FileExists(ArqXls) then
      begin
        ArqCsv := Calc + 'VDM.csv';
        if FileExists(ArqCsv) then
          begin
            AssignFile(ArqDados, ArqCsv);
            Erase(ArqDados);
          end;
        Excel := CreateOleObject('Excel.Application');
        Excel.Visible := False;
        FileCodeExcel := 1;
        Excel.Workbooks.Open(ArqXls, True, FileCodeExcel);
        Excel.Workbooks.Add;
        Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
        Excel.Workbooks[2].Sheets[1].PasteSpecial;
        FileCodeExcel := 6;
        Excel.Workbooks[2].Sheets[1].SaveAs(ArqCsv, FileCodeExcel);
        Excel.Workbooks[2].Saved := True;
        Excel.Workbooks.Close;
        Excel.Quit;
      end;
    DataModule95.Table3.Active := False;
    ArqDbf := Dados + 'Importa\ArquivoCUBE_VMDA' + ComboBox1.Text + '.DBF';
    if FileExists(ArqDbf) then
      begin
        ArqCsv := Calc + 'ProjTraf.csv';
        Dbf2Csv(ArqDbf, ArqCsv);
      end;
  end;
end;

procedure TForm31.ComboBox1Change(Sender: TObject);
var
  Excel: OleVariant;
  ArqDados: TextFile;
  Year: string[4];
  Arquivo, Programa, Dados, Calc, DadosAnoBase, ArqXls, ArqDbf: string;
  FileCodeExcel, Ano, NPeriodos, NRodov: integer;
  Rodovia: array [1..350] of string[4];
begin
 if ComboBox1.Text <> '' then
  begin
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
    Year := IntToStr(Ano);
    if CheckBox1.Checked then
      begin
        ArqXls := Dados + 'Importa\ArquivoGDT_VMDA' + ComboBox1.Text +'.xls';
        if FileExists(ArqXls) then
          begin
            Excel := CreateOleObject('Excel.Application');
            Excel.Visible := True;
            FileCodeExcel := 1;
            Excel.Workbooks.Open(ArqXls, True, FileCodeExcel);
          end
        else
          ShowMessage('Arquivo no existe!');
      end
    else
      begin
        DataModule95.Table3.Active := False;
        ArqDbf := Dados + 'Importa\ArquivoCUBE_VMDA' + ComboBox1.Text + '.DBF';
        if FileExists(ArqDbf) then
          begin
            DataModule95.Table3.TableName := ArqDbf;
            DataModule95.Table3.Active := True;
          end
        else
          ShowMessage('Arquivo no existe!');
      end;
  end;
end;

initialization
  CoInitialize (nil);

end.
