unit Unit30;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, DB, Grids, DBGrids, DBCtrls, Mask,
  Menus;

type
  TForm30 = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label15: TLabel;
    ComboBox4: TComboBox;
    Panel6: TPanel;
    Label16: TLabel;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Label17: TLabel;
    ComboBox1: TComboBox;
    MainMenu1: TMainMenu;
    Edit1: TMenuItem;
    GeraTabelas1: TMenuItem;
    Recortar1: TMenuItem;
    Copiar1: TMenuItem;
    Colar1: TMenuItem;
    Clula1: TMenuItem;
    Coluna1: TMenuItem;
    Memo1: TMemo;
    BitBtn3: TBitBtn;
    DBGrid2: TDBGrid;
    DataSource2: TDataSource;
    DBGrid3: TDBGrid;
    DataSource3: TDataSource;
    DBGrid4: TDBGrid;
    DataSource4: TDataSource;
    DBGrid5: TDBGrid;
    DataSource5: TDataSource;
    procedure OACOAE1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure Recortar1Click(Sender: TObject);
    procedure Copiar1Click(Sender: TObject);
    procedure Clula1Click(Sender: TObject);
    procedure Coluna1Click(Sender: TObject);
    procedure GeraTabelas1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form30: TForm30;

implementation

uses Childwin, Unit11, Unit94;

{$R *.dfm}

procedure TForm30.OACOAE1Click(Sender: TObject);
begin
  MDIChild.OACOAE1Click(Sender);
end;

procedure TForm30.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm30.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  DBGrid1.Visible := False;
  DBGrid2.Visible := False;
  DBGrid3.Visible := False;
  DBGrid4.Visible := False;
  DBGrid5.Visible := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox4.Items.LoadFromFile(Arquivo);
end;

procedure TForm30.ComboBox3Change(Sender: TObject);
begin
{ }
end;

procedure TForm30.ComboBox4Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Arquivo, Programa, Dados, Calc, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome: string[4];
  ArqDados, Arq: TextFile;
begin
 if ComboBox4.Text <> '' then
  begin
   Label16.Visible := False;
   AssignFile(ArqDados, 'Diretor.dat');
   Reset(ArqDados);
   Readln(ArqDados, Ano);
   Readln(ArqDados, NPeriodos);
   Readln(ArqDados, Programa);
   Readln(ArqDados, Dados);
   Readln(ArqDados, Calc);
   Readln(ArqDados, DadosAnoBase);
   CloseFile(ArqDados);
   Year := IntToStr(Ano);
   Arquivo := DadosAnoBase + 'Trechos.dat';
   AssignFile(ArqDados, Arquivo);
   Reset(ArqDados);
   Arquivo := DadosAnoBase + 'Trechos.dsc';
   AssignFile(Arq, Arquivo);
   Reset(Arq);
   while Eof(ArqDados) = False do
     begin
       Readln(ArqDados, Local);
       Readln(Arq, Nome);
       if ComboBox4.Text = Local then Trecho := Nome;
     end;
   CloseFile(ArqDados);
   CloseFile(Arq);
   if ComboBox4.Text <> '' then
     begin
       if ComboBox1.Text = 'Pavimentos' then
         begin
           DataModule11.Table1.Active := False;
           DataModule11.Table1.TableName := Dados + 'SAM\PAV_' + Trecho + '_' + Year + '.dbf';
           DataModule11.Table1.Active := True;
         end
       else
         if ComboBox1.Text = 'Obras de Arte Especiais' then
           begin
             DataModule11.Table2.Active := False;
             DataModule11.Table2.TableName := Dados + 'SAM\OAE_' + Trecho + '_' + Year + '.dbf';
             DataModule11.Table2.Active := True;
           end
         else
           if ComboBox1.Text = 'Obras de Arte Correntes' then
             begin
               DataModule11.Table3.Active := False;
               DataModule11.Table3.TableName := Dados + 'SAM\OAC_' + Trecho + '_' + Year + '.dbf';
               DataModule11.Table3.Active := True;
             end
           else
             if ComboBox1.Text = 'Drenagem' then
               begin
                 DataModule11.Table4.Active := False;
                 DataModule11.Table4.TableName := Dados + 'SAM\DRG_' + Trecho + '_' + Year + '.dbf';
                 DataModule11.Table4.Active := True;
               end
             else
               begin
                 DataModule11.Table5.Active := False;
                 DataModule11.Table5.TableName := Dados + 'SAM\OUT_' + Trecho + '_' + Year + '.dbf';
                 DataModule11.Table5.Active := True;
               end;
       Label16.Caption := Trecho;
       Label16.Visible := True;
     end;
  end;
end;

procedure TForm30.Recortar1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid1.SelectedField.AsString;
  DataSource1.Edit;
  DBGrid1.SelectedField.Clear;
  DataModule11.Table1.Post;
end;

procedure TForm30.Copiar1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid1.SelectedField.AsString;
end;

procedure TForm30.Clula1Click(Sender: TObject);
begin
  DataSource1.Edit;
  DBGrid1.SelectedField.AsString := Memo1.Text;
  DataModule11.Table1.Post;
end;

procedure TForm30.Coluna1Click(Sender: TObject);
var
  i: SmallInt;
begin
  i := DBGrid1.SelectedField.Index;
  with DataModule11.Table1 do
    begin
      First;
      while not EOF do
        begin
          DataSource1.Edit;
          DBGrid1.Fields[i].AsString := Memo1.Text;
          Next;
        end;
      DataSource1.Edit;
      Post;
    end;
end;

procedure TForm30.GeraTabelas1Click(Sender: TObject);
var
  ArqDados, Arq: TextFile;
  Arquivo, ArqCsv, ArqDbf, PathOut, PathDat, DadosAnoBase, Dados, Calc,
    Programa, ChangeType: string;
  Code, Year: string[4];
  i, j, i1, i2, AnoBase, Ano, NPeriodos: integer;
  Trecho: string[4];
  Tipo1: array [1..15] of string[5];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  PathOut := Dados + 'SAM\';
  PathDat := Calc;
  Tipo1[1] := 'PAV';
  Tipo1[2] := 'OAE';
  Tipo1[3] := 'OAC';
  Tipo1[4] := 'DRG';
  Tipo1[5] := 'OUT';
  ArqCsv := 'DOS.DAT';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  WinExec('GeraSAM.exe /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 10;
  repeat
    Application.ProcessMessages;
    if FileExists(ArqCsv) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  Arquivo := DadosAnoBase + '\Trechos.dsc';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  AssignFile(Arq, 'Arq.dat');
  Rewrite(Arq);
  Writeln(Arq, 1);
  CloseFile(Arq);
  while not Eof(ArqDados) do
    begin
      Readln(ArqDados, Trecho);
      i1 := 1;
      i2 := 5;
      for i := i1 to i2 do
        begin
          ArqCsv := PathDat + Tipo1[i] + Trecho + '.csv';
          ArqDbf := PathOut + Tipo1[i] + '_' + Trecho + '_' + Year + '.dbf';
          if i = 1 then
            ChangeType := ' /CT:ELEMENTO=C(26) /CT:TIPOINTERV=C(70) /CT:UNID=C(4)'
          else
            if i = 2 then
              ChangeType := ' /CT:ELEMENTO=C(26) /CT:TIPOINTERV=C(70) /CT:UNID=C(4)'
            else
             if i = 3 then
               ChangeType := ' /CT:ELEMENTO=C(26) /CT:TIPOINTERV=C(70) /CT:UNID=C(4)'
             else
               if i = 4 then
                 ChangeType := ' /CT:ELEMENTO=C(26) /CT:TIPOINTERV=C(70) /CT:UNID=C(4)'
               else
                 ChangeType := ' /CT:ELEMENTO=C(26) /CT:TIPOINTERV=C(70) /CT:UNID=C(4)';
          Csv2Dbf(ArqCsv, ArqDbf, ChangeType);
        end;
    end;
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + '\Trechos.dsc';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  while not Eof(ArqDados) do
    begin
      Readln(ArqDados, Trecho);
      i1 := 1;
      i2 := 5;
      for i := i1 to i2 do
        begin
          ArqDbf := PathOut + Tipo1[i] + '_' + Trecho + '_' + Year + '.dbf';
          if i = 1 then
            begin
              DataModule11.Table1.Active := False;
              DataModule11.Table1.TableName := ArqDbf;
              DataModule11.Table1.Active := True;
              DataModule11.Table1.Edit;
              DataModule11.Table1.First;
              DataModule11.Table1.Delete;
              DataModule11.Table1.Active := False;
            end
            else
              if i = 2 then
                begin
                  DataModule11.Table2.Active := False;
                  DataModule11.Table2.TableName := ArqDbf;
                  DataModule11.Table2.Active := True;
                  DataModule11.Table2.Edit;
                  DataModule11.Table2.First;
                  DataModule11.Table2.Delete;
                  DataModule11.Table2.Active := False;
                end
              else
                if i = 3 then
                  begin
                    DataModule11.Table3.Active := False;
                    DataModule11.Table3.TableName := ArqDbf;
                    DataModule11.Table3.Active := True;
                    DataModule11.Table3.Edit;
                    DataModule11.Table3.First;
                    DataModule11.Table3.Delete;
                    DataModule11.Table3.Active := False;
                  end
                else
                  if i = 4 then
                    begin
                      DataModule11.Table4.Active := False;
                      DataModule11.Table4.TableName := ArqDbf;
                      DataModule11.Table4.Active := True;
                      DataModule11.Table4.Edit;
                      DataModule11.Table4.First;
                      DataModule11.Table4.Delete;
                      DataModule11.Table4.Active := False;
                    end
                  else
                    begin
                      DataModule11.Table5.Active := False;
                      DataModule11.Table5.TableName := ArqDbf;
                      DataModule11.Table5.Active := True;
                      DataModule11.Table5.Edit;
                      DataModule11.Table5.First;
                      DataModule11.Table5.Delete;
                      DataModule11.Table5.Active := False;
                    end;
        end;
    end;
  CloseFile(ArqDados);
  Screen.Cursor := crDefault;
end;

procedure TForm30.ComboBox1Change(Sender: TObject);
begin
 DBGrid1.Visible := False;
 DBGrid2.Visible := False;
 DBGrid3.Visible := False;
 DBGrid4.Visible := False;
 DBGrid5.Visible := False;
 DataModule11.Table1.Active := False;
 DataModule11.Table2.Active := False;
 DataModule11.Table3.Active := False;
 DataModule11.Table4.Active := False;
 DataModule11.Table5.Active := False;
 ComboBox4.Text := '';
 Label16.Visible := False;
 if ComboBox1.Text <> '' then
  begin
   if ComboBox1.Text = 'Pavimentos' then
     begin
       DBGrid1.Align := alClient;
       DBGrid1.Visible := True;
     end
   else
     if ComboBox1.Text = 'Obras de Arte Especiais' then
       begin
         DBGrid2.Align := alClient;
         DBGrid2.Visible := True;
       end
     else
      if ComboBox1.Text = 'Obras de Arte Correntes' then
        begin
          DBGrid3.Align := alClient;
          DBGrid3.Visible := True;
        end
      else
        if ComboBox1.Text = 'Drenagem' then
          begin
            DBGrid4.Align := alClient;
            DBGrid4.Visible := True;
          end
        else
          begin
            DBGrid5.Align := alClient;
            DBGrid5.Visible := True;
          end;
 end;
end;

procedure TForm30.BitBtn3Click(Sender: TObject);
begin
  DataSource1.DataSet.Insert;
end;

procedure TForm30.BitBtn2Click(Sender: TObject);
var
  ArqDados, Arq: TextFile;
  Arquivo, ArqCsv, ArqDbf, PathOut, PathDat, DadosAnoBase, Dados, Calc,
    Programa, ChangeType: string;
  Code, Year: string[4];
  i, j, i1, i2, AnoBase, Ano, NPeriodos: integer;
  Trecho: string[4];
  Tipo1: array [1..15] of string[5];
begin
  Screen.Cursor := crHourglass;
  DataModule11.Table1.Active := False;
  DataModule11.Table2.Active := False;
  DataModule11.Table3.Active := False;
  DataModule11.Table4.Active := False;
  DataModule11.Table5.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  PathOut := Dados + 'SAM\';
  PathDat := Calc;
  Tipo1[1] := 'PAV';
  Tipo1[2] := 'OAE';
  Tipo1[3] := 'OAC';
  Tipo1[4] := 'DRG';
  Tipo1[5] := 'OUT';
  Arquivo := DadosAnoBase + '\Trechos.dsc';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  AssignFile(Arq, 'Arq.dat');
  Rewrite(Arq);
  Writeln(Arq, 1);
  CloseFile(Arq);
  while not Eof(ArqDados) do
    begin
      Readln(ArqDados, Trecho);
      i1 := 1;
      i2 := 5;
      for i := i1 to i2 do
        begin
          ArqCsv := PathDat + Tipo1[i] + Trecho + '.csv';
          ArqDbf := PathOut + Tipo1[i] + '_' + Trecho + '_' + Year + '.dbf';
          Dbf2Csv(ArqDbf, ArqCsv);
        end;
    end;
  CloseFile(ArqDados);
  Screen.Cursor := crDefault;
end;

end.
