unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Grids, DBGrids, Db, DBTables, DBCtrls, Menus;

type
  TForm3 = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    Panel2: TPanel;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    ComboBox1: TComboBox;
    Label1: TLabel;
    DBNavigator1: TDBNavigator;
    MainMenu1: TMainMenu;
    Cut1: TMenuItem;
    Cut2: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Memo1: TMemo;
    Label2: TLabel;
    Coluna1: TMenuItem;
    Clula1: TMenuItem;
    Label3: TLabel;
    Label4: TLabel;
    ComboBox2: TComboBox;
    procedure DadosCadastrais1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Cut2Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Coluna1Click(Sender: TObject);
    procedure Clula1Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.DFM}

uses Childwin, Unit10;

procedure TForm3.DadosCadastrais1Click(Sender: TObject);
begin
  MDIChild.DadosCadastrais1Click(Sender);
end;

procedure TForm3.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Arquivo, Programa, Dados, Calc, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome: string[4];
  ArqDados, Arq: TextFile;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox1.Text = Local then Trecho := Nome;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  if ComboBox1.Text <> '' then
    begin
      DataModule10.Table2.Active := False;
      DataModule10.Table2.TableName := Dados + 'CADAS_' + Trecho + '_' + Year + '.dbf';
      DataModule10.Table2.Active := True;
      Label3.Caption := Trecho;
      Label3.Visible := True;
    end;
end;

procedure TForm3.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Atualiza, Disco: string[3];
  SGP: string[5];
begin
  Label3.Visible := False;
  Memo1.Text := '';
  DataModule10.Table2.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Label4.Visible := False;
  ComboBox2.Visible := False;
  AssignFile(ArqDados, 'Sistema.dat');
  Reset(ArqDados);
  Readln(ArqDados, SGP);
  CloseFile(ArqDados);
  if SGP = 'SGP15' then
    begin
      Arquivo := Disco + SGP + '\Bairros.txt';
      ComboBox2.Items.LoadFromFile(Arquivo);
      Label4.Visible := True;
      ComboBox2.Visible := True;
    end;
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
  AssignFile(ArqDados, 'Acesso.dat');
  Reset(ArqDados);
  Readln(ArqDados, Atualiza);
  CloseFile(ArqDados);
  if Atualiza = 'Sim' then
    DBGrid1.ReadOnly := False
  else
    DBGrid1.ReadOnly := True;
end;

procedure TForm3.BitBtn1Click(Sender: TObject);
begin
  DataSource1.Edit;
  DataModule10.Table2.Post;
  DataModule10.Table2.Active := False;
  Close;
end;

procedure TForm3.Cut2Click(Sender: TObject);
begin
  Memo1.Text := DBGrid1.SelectedField.AsString;
  DataSource1.Edit;
  DBGrid1.SelectedField.Clear;
  DataModule10.Table2.Post;
end;

procedure TForm3.Copy1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid1.SelectedField.AsString;
end;

procedure TForm3.Coluna1Click(Sender: TObject);
var
  i: SmallInt;
begin
  i := DBGrid1.SelectedField.Index;
  with DataModule10.Table2 do
    begin
      First;
      while not EOF do
        begin
          DataSource1.Edit;
          DBGrid1.Fields[i].AsString := Memo1.Text;
          Next;
        end;
      DataSource1.Edit;
      Post;
    end;
end;

procedure TForm3.Clula1Click(Sender: TObject);
begin
  DataSource1.Edit;
  DBGrid1.SelectedField.AsString := Memo1.Text;
  DataModule10.Table2.Post;
end;

procedure TForm3.ComboBox2Change(Sender: TObject);
var
  Arquivo: string;
begin
  DataModule10.Table15.Active := False;
  Arquivo := ComboBox2.Text + '.dbf';
  DataModule10.Table15.TableName := Arquivo;
  DataModule10.Table15.Active := True;
end;

end.
