unit Unit29;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, Grids, DBGrids, StdCtrls, Buttons, ExtCtrls, DBCtrls;

type
  TForm29 = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    Panel2: TPanel;
    DataSource1: TDataSource;
    Label1: TLabel;
    ComboBox1: TComboBox;
    BitBtn2: TBitBtn;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    DataSource2: TDataSource;
    DBNavigator1: TDBNavigator;
    procedure SCR1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure DBGrid1CellClick(Column: TColumn);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form29: TForm29;

implementation

uses Childwin, Unit95, Unit96, Unit94;

{$R *.dfm}

procedure TForm29.SCR1Click(Sender: TObject);
begin
  MDIChild.SCR1Click(Sender);
end;

procedure TForm29.BitBtn1Click(Sender: TObject);
begin
  DataModule95.Table1.Active := False;
  DataModule95.Table2.Active := False;
  Close;
end;

procedure TForm29.FormShow(Sender: TObject);
begin
  DBGrid1.Visible := False;
  DBGrid2.Visible := False;
  DataModule95.Table1.Active := False;
  DataModule95.Table2.Active := False;
end;

procedure TForm29.ComboBox1Change(Sender: TObject);
begin
  DBGrid1.Visible := False;
  DBGrid2.Visible := False;
  DataModule95.Table1.Active := False;
  DataModule95.Table2.Active := False;
  if ComboBox1.Text = 'Trechos Rodovirios' then
    begin
     DBGrid1.Visible := True;
     DBGrid1.Align := alClient;
     DataModule95.Table1.Active := True;
     DBNavigator1.DataSource := DataSource1;
    end;
  if ComboBox1.Text = 'Estrutura do Pavimento' then
    begin
      DBGrid2.Visible := True;
      DBGrid2.Align := alClient;
      DataModule95.Table2.Active := True;
      DBNavigator1.DataSource := DataSource2;
    end;
end;

procedure TForm29.DBGrid1CellClick(Column: TColumn);
var
  Subtrecho: string[5];
  Coluna: SmallInt;
  ArqDados: TextFile;
  Year: string[4];
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase, Path, Trecho: string;
begin
  Coluna := DBGrid1.SelectedField.Index;
  if Coluna = 1 then
    begin
      Trecho := DBGrid1.SelectedField.AsString;
      { Ano-base e subdiretrios }
        AssignFile(ArqDados, 'Diretor.dat');
        Reset(ArqDados);
        Readln(ArqDados, Ano);
        Readln(ArqDados, NPeriodos);
        Readln(ArqDados, Programa);
        Readln(ArqDados, Dados);
        Readln(ArqDados, Calc);
        Readln(ArqDados, DadosAnoBase);
        CloseFile(ArqDados);
        Year := IntToStr(Ano);
      { Carrega a foto do subtrecho }
        Path := Dados + 'Importa\Fotos\FinalTrecho' + Trecho + '.jpg';
        if FileExists(Path) then
          begin
            AssignFile(ArqDados, 'Trecho.dat');
            Rewrite(ArqDados);
            Writeln(ArqDados, Trecho);
            Writeln(ArqDados, Path);
            CloseFile(ArqDados);
            TOKBottomDlg4.Create(Self);
          end;
    end;
end;

procedure TForm29.BitBtn2Click(Sender: TObject);
var
  ArqDados: TextFile;
  Arquivo, Programa, Dados, Calc, DadosAnoBase, ArqDbf, ChangeType,
    ArqCsv: string;
  Ano, NPeriodos: integer;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
begin
  Screen.Cursor := crHourglass;
  { Ano-base e subdiretrios }
    AssignFile(ArqDados, 'Diretor.dat');
    Reset(ArqDados);
    Readln(ArqDados, Ano);
    Readln(ArqDados, NPeriodos);
    Readln(ArqDados, Programa);
    Readln(ArqDados, Dados);
    Readln(ArqDados, Calc);
    Readln(ArqDados, DadosAnoBase);
    CloseFile(ArqDados);
  if ComboBox1.Text = 'Trechos Rodovirios' then
    begin
      DataModule95.Table1.Active := False;
      DataModule95.Table1.Close;
      Arquivo := Calc + 'SCR.csv';
      ArqDbf := Dados + 'Importa\SCR_Trechos.dbf';
    end
  else
    begin
      DataModule95.Table2.Active := False;
      DataModule95.Table2.Close;
      Arquivo := Calc + 'SCRestr.csv';
      ArqDbf := Dados + 'Importa\SCR_Estruturas.dbf';
    end;
  Dbf2Csv(ArqDbf, Arquivo);
  { Gera arquivo de clulas de anlise para o HDM }
    ArqCsv := 'DOS.DAT';
    if FileExists(ArqCsv) then
      begin
        AssignFile(ArqDados, ArqCsv);
        Erase(ArqDados)
      end;
    WinExec('HDMcells.exe /c', SW_HIDE);
    Flag := 0;
    StartTime := now;
    NumSec := 3;
    repeat
      Application.ProcessMessages;
      if FileExists(ArqCsv) then Flag := 1;
    until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
    ArqCsv := Calc + 'CelHDM.csv';
    ArqDbf := Dados + 'Importa\CelHDM.dbf';
    ChangeType := ' /CT:TRECHO=C(7)  /CT:SGRODOVIA=C(10)';
    Csv2Dbf(ArqCsv, ArqDbf, ChangeType);
  Screen.Cursor := crDefault;
  Close;
end;

end.
