unit Unit28;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Grids, DBGrids, DBCtrls, Db, Menus;

type
  TForm28 = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Panel2: TPanel;
    Panel3: TPanel;
    Label41: TLabel;
    ComboBox1: TComboBox;
    Panel4: TPanel;
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    GroupBox2: TGroupBox;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    DataSource2: TDataSource;
    DBGrid2: TDBGrid;
    Label12: TLabel;
    Label13: TLabel;
    BitBtn3: TBitBtn;
    Label4: TLabel;
    Edit3: TEdit;
    Panel5: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    DBGrid3: TDBGrid;
    DataSource3: TDataSource;
    DBNavigator2: TDBNavigator;
    BitBtn4: TBitBtn;
    MainMenu1: TMainMenu;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Clula1: TMenuItem;
    Coluna1: TMenuItem;
    Label3: TLabel;
    Memo1: TMemo;
    procedure EstratgiassobRestriesOramentrias1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Coluna1Click(Sender: TObject);
    procedure Clula1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form28: TForm28;

implementation

uses Childwin, Unit24, ComObj, ActiveX, Unit10, Unit86, Unit94;

{$R *.DFM}

procedure TForm28.EstratgiassobRestriesOramentrias1Click(
  Sender: TObject);
begin
  MDIChild.EstratgiassobRestriesOramentrias1Click(Sender);
end;

procedure TForm28.BitBtn2Click(Sender: TObject);
begin
  DataModule24.Table5.Active := False;
  DataModule24.Table15.Active := False;
  DataModule10.Table11.Active := False;
  Close;
end;

procedure TForm28.BitBtn1Click(Sender: TObject);
const
  NRodovMax = 150;
var
  Excel: OleVariant;
  Ano, NPeriodos, i, Modo, FileCodeExcel, NRodov, Code, NPP, j, icont, NFields,
    NPolos, jk: integer;
  ArqDados: TextFile;
  PPmin, PPmax, PSI0, Ocorr0, VR0, inf: Single;
  Custo, PSI, Ocorr, VR, Deficit: array [1..50] of Single;
  CustoPolo: array [1..NRodovMax, 1..50] of Single;
  Programa, Dados, Calc, Arquivo, ArqDbf, ArqCsv, DadosAnoBase, Linha, ConfReg: string;
  Rodovia: array [1..NRodovMax] of string[4];
  Campo: array [1..100] of string;
  Year: string[4];
  Parametro, VRat: string[5];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
begin
  Screen.Cursor := crHourglass;
  Modo := 2;
  DataModule24.Table5.Active := False;
  DataModule24.Table15.Active := False;
  BitBtn4.Visible := False;
  NPP := 1;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  Arquivo := Calc + 'Restric.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, ComboBox2.Text);
  CloseFile(ArqDados);
  { Cdigos de identificao das rodovias que compem a rede }
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  NPolos := NRodov;
  { Gera os arquivos de dados a serem acessados por Estrateg.bas }
    Arquivo := Calc + 'Modo.dat';
    AssignFile(ArqDados, Arquivo);
    Rewrite(ArqDados);
    Writeln(ArqDados, Modo);
    CloseFile(ArqDados);
    Arquivo := Calc + 'DadoEstr.dat';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Modo);
    Readln(ArqDados, PPmin);
    Readln(ArqDados, PPmax);
    Readln(ArqDados, NPP);
    Readln(ArqDados, inf);
    CloseFile(ArqDados);
    Modo := 2;
    Arquivo := Calc + 'DadoEstr.dat';
    AssignFile(ArqDados, Arquivo);
    Rewrite(ArqDados);
    Writeln(ArqDados, Modo);
    Writeln(ArqDados, PPmin);
    Writeln(ArqDados, PPmax);
    Writeln(ArqDados, NPP);
    VirgDot(Edit3.Text);
    Writeln(ArqDados, VarDot);
    CloseFile(ArqDados);
    Arquivo := Calc + 'Restric.dat';
    AssignFile(ArqDados, Arquivo);
    Rewrite(ArqDados);
    Writeln(ArqDados, ComboBox2.Text);
    CloseFile(ArqDados);
  { Executa o programa Estrateg.bas para determinao das
    necessidades atuais de manuteno e apaga os arquivos
    *.xls e *.dbf existentes }
    ArqCsv := 'DOS.DAT';
    if FileExists(ArqCsv) then
      begin
        AssignFile(ArqDados, ArqCsv);
        Erase(ArqDados)
      end;
    WinExec('ArqRO.bat /c', SW_SHOW);
    Flag := 0;
    StartTime := now;
    NumSec := 7;
    repeat
      Application.ProcessMessages;
      if FileExists(ArqCsv) then Flag := 1;
    until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Converte os arquivos de sada *.CSV em *.DBF }
    for i := 1 to NRodov do
      begin
        ArqCsv := Calc + 'RO' + Rodovia[i] + '.csv';
        ArqDbf := Calc + 'RO' + Rodovia[i] + '.dbf';
        NFields := 22;
        AssignFile(ArqDados, ArqCsv);
        Reset(ArqDados);
        Readln(ArqDados, Linha);
        with DataModule24.Table5 do
          begin
            Active := False;
            TableName := ArqDbf;
            CreateTable;
            Active := True;
            Edit;
            First;
          end;
        while not eof(ArqDados) do
          begin
            Readln(ArqDados, Linha);
            j := 1;
            for icont := 1 to NFields do
              Campo[icont] := '';
            for icont := 1 to Length(Linha) do
              begin
                if Linha[icont] = ',' then
                  j := j + 1
                else
                  if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
              end;
            if ConfReg = 'Portuguese' then
              begin
                for j := 3 to 4 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 6 to 7 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 9 to 10 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 12 to 13 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 15 to 16 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 18 to 19 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 21 to 22 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
              end;
            DataModule24.Table5.InsertRecord([Campo[1],Campo[2],StrToFloat(Campo[3]),
              StrToFloat(Campo[4]),Campo[5],StrToFloat(Campo[6]),StrToFloat(Campo[7]),
              Campo[8],StrToFloat(Campo[9]),StrToFloat(Campo[10]),
              Campo[11],StrToFloat(Campo[12]),StrToFloat(Campo[13]),
              Campo[14],StrToFloat(Campo[15]),StrToFloat(Campo[16]),
              Campo[17],StrToFloat(Campo[18]),StrToFloat(Campo[19]),
              Campo[20],StrToFloat(Campo[21]),StrToFloat(Campo[22])]);
          end;
        DataModule24.Table5.Close;
        DataModule24.Table5.Active := False;
        CloseFile(ArqDados);
      end;
    for i := 1 to NRodov do
      begin
        ArqCsv := Calc + 'RO' + 'CT' + Rodovia[i] + '.csv';
        ArqDbf := Calc + 'RO' + 'CT' + Rodovia[i] + '.dbf';
        NFields := 10;
        AssignFile(ArqDados, ArqCsv);
        Reset(ArqDados);
        Readln(ArqDados, Linha);
        with DataModule24.Table45 do
          begin
            Active := False;
            TableName := ArqDbf;
            CreateTable;
            Active := True;
            Edit;
            First;
          end;
        while not eof(ArqDados) do
          begin
            Readln(ArqDados, Linha);
            j := 1;
            for icont := 1 to NFields do
              Campo[icont] := '';
            for icont := 1 to Length(Linha) do
              begin
                if Linha[icont] = ',' then
                  j := j + 1
                else
                  if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
              end;
            if ConfReg = 'Portuguese' then
              begin
                for j := 3 to 10 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
              end;
            DataModule24.Table45.InsertRecord([Campo[1],Campo[2],StrToFloat(Campo[3]),
              StrToFloat(Campo[4]),StrToFloat(Campo[5]),StrToFloat(Campo[6]),
              StrToFloat(Campo[7]),StrToFloat(Campo[8]),StrToFloat(Campo[9]),
              StrToFloat(Campo[10])]);
          end;
        DataModule24.Table45.Close;
        DataModule24.Table45.Active := False;
        CloseFile(ArqDados);
        {
        ArqCsv := Calc + 'RO' + Rodovia[i] + 'PT.csv';
        ArqDbf := Calc + 'RO' + Rodovia[i] + 'PT.dbf';
        ChangeType := ' /CT:Ano=C(5)';
        Csv2Dbf(ArqCsv, ArqDbf, ChangeType);
        ArqCsv := Calc + 'RO' + Rodovia[i] + 'AC.csv';
        ArqDbf := Calc + 'RO' + Rodovia[i] + 'AC.dbf';
        ChangeType := ' /CT:Ano=C(5)';
        Csv2Dbf(ArqCsv, ArqDbf, ChangeType);
        }
      end;
  { L os custos de manuteno previstos }
    Arquivo := Calc + 'CustoRO.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    for i := 1 to NPeriodos do
      begin
        Readln(ArqDados, Custo[i]);
        Readln(ArqDados, Deficit[i]);
        for j := 1 to NPolos do
          Readln(ArqDados, CustoPolo[j,i]);
      end;
    CloseFile(ArqDados);
  { L o PSI mdio da rede que foi previsto }
    Arquivo := Calc + 'PSIRO.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, PSI0);
    Parametro := FloatToStr(PSI0);
    Label9.Caption := Parametro;
    for i := 1 to NPeriodos do
      Readln(ArqDados, PSI[i]);
    CloseFile(ArqDados);
  { L as ocorrncias previstas na rede }
    Arquivo := Calc + 'NPSIRO.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Ocorr0);
    Parametro := FloatToStr(Ocorr0);
    Label10.Caption := Parametro;
    for i := 1 to NPeriodos do
      Readln(ArqDados, Ocorr[i]);
    CloseFile(ArqDados);
  { L a Vida Restante mdia da rede }
    Arquivo := Calc + 'VRRO.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, VR0);
    VRat := FloatToStr(VR0);
    Label13.Caption := VRat;
    for i := 1 to NPeriodos do
      Readln(ArqDados, VR[i]);
    CloseFile(ArqDados);
  { Gera a tabela contendo os resultados }
    { Converte de CSV para DBF }
      ArqCsv := Calc + 'Results.csv';
      ArqDbf := Calc + 'ResRO.dbf';
      NFields := 5;
      AssignFile(ArqDados, ArqCsv);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      with DataModule24.Table15 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
            end;
            if ConfReg = 'Portuguese' then
              begin
                for j := 2 to 5 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
              end;
          DataModule24.Table15.InsertRecord([Campo[1],StrToFloat(Campo[2]),
            StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5])]);
        end;
      DataModule24.Table15.Close;
      DataModule24.Table15.Active := False;
      CloseFile(ArqDados);
  ArqDbf := Calc + 'ResRO.dbf';
  DataModule24.Table15.TableName := ArqDbf;
  DataModule24.Table15.Active := True;
  Label41.Caption := 'Trecho:';
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
  ComboBox1.Visible := True;
  Excel := CreateOleObject('Excel.Application');
  Excel.Visible := False;
  FileCodeExcel := 1;
  ArqCsv := Calc + 'PPI_Estratgia sob Restries.xls';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  NovoPath := Calc + 'PPI.xls';
  Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
  FileCodeExcel := 6;
  for i := 1 to NRodov do
    begin
      ArqCsv := Calc + 'RO' + Rodovia[i];
      Converte2(ArqCsv);
      Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
      Excel.Workbooks[1+i].Sheets[1].UsedRange.Copy;
      Excel.Workbooks[1].Sheets[i].PasteSpecial;
    end;
  NovoPath := Calc + 'PPI_Estratgia sob Restries.xls';
  FileCodeExcel := 1;
  Excel.Workbooks[1].SaveAs(NovoPath, FileCodeExcel);
  Excel.Quit;
  for i := 1 to NRodov do
   begin
    ArqCsv := Calc + 'Parmetros_Trecho ' + Rodovia[i] + '.xls';
    if FileExists(ArqCsv) then
      begin
        AssignFile(ArqDados, ArqCsv);
        Erase(ArqDados)
      end;
    Excel := CreateOleObject('Excel.Application');
    Excel.Visible := False;
    NovoPath := Programa + 'Param.xls';
    FileCodeExcel := 1;
    Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
    FileCodeExcel := 6;
    for j := 1 to NPeriodos do
     begin
       ArqCsv := Calc + 'PAR_' + Rodovia[i] + ' ' + IntToStr(j);
       Converte2(ArqCsv);
       Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
       Excel.Workbooks[1+j].Sheets[1].UsedRange.Copy;
       Excel.Workbooks[1].Sheets[j].PasteSpecial;
     end;
    NovoPath := Calc + 'Parmetros_Trecho ' + Rodovia[i] + '.xls';
    FileCodeExcel := 1;
    Excel.Workbooks[1].SaveAs(NovoPath, FileCodeExcel);
    Excel.Quit;
   end;
  Excel := CreateOleObject('Excel.Application');
  Excel.Visible := True;
  Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
  FileCodeExcel := 6;
  ArqCsv := Calc + 'ROpista';
  Converte2(ArqCsv);
  Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
  ArqCsv := Calc + 'ROcusto';
  Converte2(ArqCsv);
  Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
  ArqCsv := Calc + 'ROacost';
  Converte2(ArqCsv);
  Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
  ArqCsv := Calc + 'RO_Pista_Interv';
  Converte2(ArqCsv);
  Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
  ArqCsv := Calc + 'RO_Acost_Interv';
  Converte2(ArqCsv);
  Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
  ArqCsv := Calc + 'Results';
  Converte2(ArqCsv);
  Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
  NovoPath := Calc + 'PPI_Estratgia sob Restries.xls';
  Excel.Workbooks.Open(NovoPath, True, FileCodeExcel);
  Screen.Cursor := crDefault;
end;

procedure TForm28.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  ArqDados, Arq: TextFile;
  Trecho, Nome: string[4];
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox1.Text = Local then Trecho := Nome;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  if ComboBox1.Text <> '' then
    begin
      DataModule24.Table5.Active := False;
      DataModule24.Table5.TableName := Calc + 'RO' + Trecho + '.dbf';
      DataModule24.Table5.Active := True;
    end;
end;

procedure TForm28.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Path, Modo, Local, Arquivo, DadosAnoBase: string;
  ArqDados: TextFile;
begin
  DBGrid3.ReadOnly := False;
  Memo1.Text := '';
{
  BitBtn1.Visible := False;
}
  Label41.Caption := '';
  ComboBox1.Visible := False;
  DataModule24.Table5.Active := False;
  DataModule24.Table15.Active := False;
  DataModule10.Table11.Active := False;
  Label9.Caption := '';
  Label10.Caption := '';
  Label13.Caption := '';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Path := DadosAnoBase + 'Trechos.dat';
  ComboBox3.Items.LoadFromFile(Path);
end;

procedure TForm28.ComboBox2Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  DataModule10.Table11.Active := False;
  BitBtn4.Visible := True;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  if ComboBox2.Text = 'Para toda a rede' then
    begin
      Label2.Visible := False;
      ComboBox3.Visible := False;
      DataModule10.Table11.TableName := Dados + 'ROrede.dbf';
      DataModule10.Table11.Active := True;
    end
  else
    begin
      Label2.Visible := True;
      ComboBox3.Visible := True;
      Arquivo := DadosAnoBase + 'Trechos.dat';
      ComboBox3.Items.LoadFromFile(Arquivo);
    end;
end;

procedure TForm28.BitBtn3Click(Sender: TObject);
const
  NRodovmax = 150;
var
  Ano, NPeriodos, i, Modo, NRodov, Code, NPP, j, NPolos: integer;
  ArqDados: TextFile;
  PP, PSI0, Ocorr0, VR0, inf: Single;
  Custo, PSI, Ocorr, VR, Deficit: array [1..100] of Single;
  CustoPolo: array [1..NRodovMax, 1..100] of Single;
  Programa, Dados, Calc, Arquivo, ArqDbf, ArqCsv, Local, ModoRestric,
    DadosAnoBase: string;
  Rodovia: array [1..NRodovMax] of string[4];
  Year: string[4];
  Parametro, VRat: string[5];
begin
  BitBtn1.Visible := True;
  Label41.Caption := 'Trecho:';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := Calc + 'DadoEstr.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, Modo);
  Readln(ArqDados, PP);
  Readln(ArqDados, PP);
  Readln(ArqDados, NPP);
  Readln(ArqDados, inf);
  CloseFile(ArqDados);
  Edit3.Text := FloatToStr(inf);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
  ComboBox1.Visible := True;
  NPolos := 0;
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      NPolos := NPolos + 1;
    end;
  CloseFile(ArqDados);
  Arquivo := Calc + 'Restric.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, ModoRestric);
  CloseFile(ArqDados);
  ComboBox2.Text := ModoRestric;
  if ComboBox2.Text = 'Para toda a rede' then
    begin
      Label2.Visible := False;
      ComboBox3.Visible := False;
      DataModule10.Table11.TableName := Dados + 'ROrede.dbf';
      DataModule10.Table11.Active := True;
    end
  else
    begin
      Label2.Visible := True;
      ComboBox3.Visible := True;
      Arquivo := DadosAnoBase + 'Trechos.dat';
      ComboBox3.Items.LoadFromFile(Arquivo);
    end;
  { L os custos de manuteno previstos }
    Arquivo := Calc + 'CustoRO.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    for i := 1 to NPeriodos do
      begin
        Readln(ArqDados, Custo[i]);
        Readln(ArqDados, Deficit[i]);
        for j := 1 to NPolos do
          Readln(ArqDados, CustoPolo[j,i]);
      end;
    CloseFile(ArqDados);
  { L o PSI mdio da rede que foi previsto }
    Arquivo := Calc + 'PSIRO.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, PSI0);
    Parametro := FloatToStr(PSI0);
    Label9.Caption := Parametro;
    for i := 1 to NPeriodos do
      Readln(ArqDados, PSI[i]);
    CloseFile(ArqDados);
  { L as ocorrncias previstas na rede }
    Arquivo := Calc + 'NPSIRO.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Ocorr0);
    Parametro := FloatToStr(Ocorr0);
    Label10.Caption := Parametro;
    for i := 1 to NPeriodos do
      Readln(ArqDados, Ocorr[i]);
    CloseFile(ArqDados);
  { L a Vida Restante mdia da rede }
    Arquivo := Calc + 'VRRO.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, VR0);
    VRat := FloatToStr(VR0);
    Label13.Caption := VRat;
    for i := 1 to NPeriodos do
      Readln(ArqDados, VR[i]);
    CloseFile(ArqDados);
  ArqDbf := Calc + 'ResRO.dbf';
  DataModule24.Table15.Active := False;
  DataModule24.Table15.TableName := ArqDbf;
  DataModule24.Table15.Active := True;
end;

procedure TForm28.ComboBox3Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, Local, DadosAnoBase: string;
  Trecho, Nome: string[4];
begin
  if ComboBox3.Text <> '' then
    begin
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      Arquivo := DadosAnoBase + 'Trechos.dat';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Arquivo := DadosAnoBase + 'Trechos.dsc';
      AssignFile(Arq, Arquivo);
      Reset(Arq);
      while Eof(ArqDados) = False do
        begin
          Readln(ArqDados, Local);
          Readln(Arq, Nome);
          if ComboBox3.Text = Local then Trecho := Nome;
        end;
      CloseFile(ArqDados);
      CloseFile(Arq);
      DataModule10.Table11.Active := False;
      DataModule10.Table11.TableName := Dados + 'ROtre' + Trecho + '.dbf';
      DataModule10.Table11.Active := True;
    end;
end;

procedure TForm28.BitBtn4Click(Sender: TObject);
var
  Excel: OleVariant;
  Ano, NPeriodos, FileCodeExcel, icont, NFields, jk: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, ArqDbf, ArqCsv, Local, DadosAnoBase, Linha,
    LinhaX, LinhaY: string;
  Trecho, Nome: string[4];
begin
  Screen.Cursor := crHourglass;
  BitBtn1.Visible := True;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  DataModule10.Table11.Active := False;
  if ComboBox2.Text = 'Para toda a rede' then
    begin
      ArqDbf := Dados + 'ROrede.dbf';
      ArqCsv := Calc + 'ROrede.csv';
      BitBtn4.Visible := False;
    end
  else
    begin
      Arquivo := DadosAnoBase + 'Trechos.dat';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Arquivo := DadosAnoBase + 'Trechos.dsc';
      AssignFile(Arq, Arquivo);
      Reset(Arq);
      while Eof(ArqDados) = False do
        begin
          Readln(ArqDados, Local);
          Readln(Arq, Nome);
          if ComboBox3.Text = Local then Trecho := Nome;
        end;
      CloseFile(ArqDados);
      CloseFile(Arq);
      ArqDbf := Dados + 'ROtre' + Trecho + '.dbf';
      ArqCsv := Calc + 'ROtre' + Trecho + '.csv';
    end;
  { Converte de DBF para CSV }
  AssignFile(ArqDados, ArqCsv);
  Rewrite(ArqDados);
  Linha := 'ANO,VALOR,PP_ANOS,PSIt,QIcrit';
  NFields := 1;
  for icont := 1 to Length(Linha) do
    if Linha[icont] = ',' then NFields := NFields + 1;
  Writeln(ArqDados, Linha);
  with DataModule10.Table11 do
    begin
      Active := False;
      TableName := ArqDbf;
      Active := True;
      First;
      while not Eof do
        begin
          LinhaX := Fields.Fields[0].AsString;
          Linha := '';
          for jk := 1 to Length(LinhaX) do
            begin
              if LinhaX[jk] = ',' then LinhaX[jk] := '.';
              Linha := Linha + LinhaX[jk];
            end;
          for icont := 1 to NFields-1 do
            begin
              LinhaX := Fields.Fields[icont].AsString;
              LinhaY := '';
              for jk := 1 to Length(LinhaX) do
                begin
                  if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                  LinhaY := LinhaY + LinhaX[jk];
                end;
              Linha := Linha + ',' + LinhaY;
            end;
          Writeln(ArqDados, Linha);
          Next;
        end;
      Active := False;
    end;
  CloseFile(ArqDados);
  Screen.Cursor := crDefault;
end;

procedure TForm28.Button1Click(Sender: TObject);
var
  Excel: OleVariant;
  Ano, NPeriodos, FileCodeExcel, NRodov, i, Modo, NPP, icont, j, IRodov,
    NFields, NTrechos: integer;
  ArqDados, ArqOut: TextFile;
  Programa, Dados, Calc, Arquivo, ArqXls, ArqCsv, ArqXlsNovo, Linha: string;
  Rodovia: array [1..350] of string[4];
  Year, AnoAtual: string[4];
  PPmin, PPmax, inf: Single;
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
  Campo: array [1..70] of string[15];
  AnoEstrat, STH, Iniciokm, Finalkm, AcostLE, HRACLE, H2ACLE, MedidaF1, Hfrescm1,
    HReccm1, MedidaF2, Hfrescm2, HReccm2, MedidaF3, Hfrescm3, HReccm3, MedidaF4,
    Hfrescm4,HReccm4,AcostLD,HRACLD,H2ACLD, DadosAnoBase: string;
  Trecho: array [1..60] of integer;
  Inverte: Boolean;
begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  { Cdigos de identificao das rodovias que compem a rede }
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  Arquivo := Calc + 'DadoEstr.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, Modo);
  Readln(ArqDados, PPmin);
  Readln(ArqDados, PPmax);
  Readln(ArqDados, NPP);
  Readln(ArqDados, inf);
  CloseFile(ArqDados);
  Modo := 2;
  Arquivo := Calc + 'DadoEstr.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Modo);
  Writeln(ArqDados, PPmin);
  Writeln(ArqDados, PPmax);
  Writeln(ArqDados, NPP);
  Writeln(ArqDados, inf);
  CloseFile(ArqDados);
  ArqCsv := 'DOS.DAT';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  WinExec('Unifilar.bat /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 10;
  repeat
    Application.ProcessMessages;
    if FileExists(ArqCsv) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Lista dos trechos onde a ordem dos subtrechos deve ser invertida }
  Arquivo := Dados + 'Inverte.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NTrechos);
  for i := 1 to NTrechos do
    Readln(ArqDados, Trecho[i]);
  CloseFile(ArqDados);
  NFields := 22;
  for IRodov := 1 to NRodov do
    begin
      AnoAtual := IntToStr(Ano+1);
      STH := 'Subtrecho:';
      Iniciokm := 'km';
      AcostLE := 'Acost. LE';
      HRACLE := 'HR LE';
      H2ACLE := 'H2 LE';
      MedidaF1 := 'Faixa 1';
      Hfrescm1 := 'hc Fx1';
      HReccm1 := 'HR Fx1';
      MedidaF2 := 'Faixa 2';
      Hfrescm2 := 'hc Fx2';
      HReccm2 := 'HR Fx2';
      MedidaF3 := 'Faixa 3';
      Hfrescm3 := 'hc Fx3';
      HReccm3 := 'HR Fx3';
      MedidaF4 := 'Faixa 4';
      Hfrescm4 := 'hc Fx4';
      HReccm4 := 'HR Fx4';
      AcostLD := 'Acost. LD';
      HRACLD := 'HR LD';
      H2ACLD := 'H2 LD';
      Arquivo := Calc + 'RO' + Rodovia[IRodov] + '.csv';
      AssignFile(ArqDados, Arquivo);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      Readln(ArqDados, Linha);
      j := 1;
      for i := 1 to NFields do
        Campo[i] := '';
      for i := 1 to Length(Linha) do
        begin
          if Linha[i] = ',' then
            j := j + 1
          else
            if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
        end;
      AnoEstrat := Campo[1];
      STH := STH + ',' + Campo[2];
      Iniciokm := Iniciokm + ',' + Campo[3];
      Finalkm := Finalkm + ',' + Campo[4];
      AcostLE := AcostLE + ',' + Campo[5];
      HRACLE := HRACLE + ',' + Campo[6];
      H2ACLE := H2ACLE + ',' + Campo[7];
      MedidaF1 := MedidaF1 + ',' + Campo[8];
      Hfrescm1 := Hfrescm1 + ',' + Campo[9];
      HReccm1 := HReccm1 + ',' + Campo[10];
      MedidaF2 := MedidaF2 + ',' + Campo[11];
      Hfrescm2 := Hfrescm2 + ',' + Campo[12];
      HReccm2 := HReccm2 + ',' + Campo[13];
      MedidaF3 := MedidaF3 + ',' + Campo[14];
      Hfrescm3 := Hfrescm3 + ',' + Campo[15];
      HReccm3 := HReccm3 + ',' + Campo[16];
      MedidaF4 := MedidaF4 + ',' + Campo[17];
      Hfrescm4 := Hfrescm4 + ',' + Campo[18];
      HReccm4 := HReccm4 + ',' + Campo[19];
      AcostLD := AcostLD + ',' + Campo[20];
      HRACLD := HRACLD + ',' + Campo[21];
      H2ACLD := H2ACLD + ',' + Campo[22];
      while not Eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for i := 1 to NFields do
            Campo[i] := '';
          for i := 1 to Length(Linha) do
            begin
              if Linha[i] = ',' then
                j := j + 1
              else
                if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
            end;
          AnoEstrat := Campo[1];
          if AnoAtual = AnoEstrat then
            begin
              STH := STH + ',' + Campo[2];
              Iniciokm := Iniciokm + ',' + Campo[3];
              Finalkm := Finalkm + ',' + Campo[4];
              AcostLE := AcostLE + ',' + Campo[5];
              HRACLE := HRACLE + ',' + Campo[6];
              H2ACLE := H2ACLE + ',' + Campo[7];
              MedidaF1 := MedidaF1 + ',' + Campo[8];
              Hfrescm1 := Hfrescm1 + ',' + Campo[9];
              HReccm1 := HReccm1 + ',' + Campo[10];
              MedidaF2 := MedidaF2 + ',' + Campo[11];
              Hfrescm2 := Hfrescm2 + ',' + Campo[12];
              HReccm2 := HReccm2 + ',' + Campo[13];
              MedidaF3 := MedidaF3 + ',' + Campo[14];
              Hfrescm3 := Hfrescm3 + ',' + Campo[15];
              HReccm3 := HReccm3 + ',' + Campo[16];
              MedidaF4 := MedidaF4 + ',' + Campo[17];
              Hfrescm4 := Hfrescm4 + ',' + Campo[18];
              HReccm4 := HReccm4 + ',' + Campo[19];
              AcostLD := AcostLD + ',' + Campo[20];
              HRACLD := HRACLD + ',' + Campo[21];
              H2ACLD := H2ACLD + ',' + Campo[22];
            end
          else
            begin
              ArqCsv := Calc + 'MDRO' + Rodovia[IRodov] + '_' + AnoAtual + '.csv';
              AssignFile(ArqOut, ArqCsv);
              Rewrite(ArqOut);
              Writeln(ArqOut, STH);
              Writeln(ArqOut, Iniciokm);
              Writeln(ArqOut, AcostLE);
              Writeln(ArqOut, HRACLE);
              Writeln(ArqOut, H2ACLE);
              Writeln(ArqOut, MedidaF1);
              Writeln(ArqOut, Hfrescm1);
              Writeln(ArqOut, HReccm1);
              Writeln(ArqOut, MedidaF2);
              Writeln(ArqOut, Hfrescm2);
              Writeln(ArqOut, HReccm2);
              Writeln(ArqOut, MedidaF3);
              Writeln(ArqOut, Hfrescm3);
              Writeln(ArqOut, HReccm3);
              Writeln(ArqOut, MedidaF4);
              Writeln(ArqOut, Hfrescm4);
              Writeln(ArqOut, HReccm4);
              Writeln(ArqOut, AcostLD);
              Writeln(ArqOut, HRACLD);
              Writeln(ArqOut, H2ACLD);
              CloseFile(ArqOut);
              STH := 'Subtrecho:';
              Iniciokm := 'km';
              AcostLE := 'Acost. LE';
              HRACLE := 'HR LE';
              H2ACLE := 'H2 LE';
              MedidaF1 := 'Faixa 1';
              Hfrescm1 := 'hc Fx1';
              HReccm1 := 'HR Fx1';
              MedidaF2 := 'Faixa 2';
              Hfrescm2 := 'hc Fx2';
              HReccm2 := 'HR Fx2';
              MedidaF3 := 'Faixa 3';
              Hfrescm3 := 'hc Fx3';
              HReccm3 := 'HR Fx3';
              MedidaF4 := 'Faixa 4';
              Hfrescm4 := 'hc Fx4';
              HReccm4 := 'HR Fx4';
              AcostLD := 'Acost. LD';
              HRACLD := 'HR LD';
              H2ACLD := 'H2 LD';
              STH := STH + ',' + Campo[2];
              Iniciokm := Iniciokm + ',' + Campo[3];
              Finalkm := Finalkm + ',' + Campo[4];
              AcostLE := AcostLE + ',' + Campo[5];
              HRACLE := HRACLE + ',' + Campo[6];
              H2ACLE := H2ACLE + ',' + Campo[7];
              MedidaF1 := MedidaF1 + ',' + Campo[8];
              Hfrescm1 := Hfrescm1 + ',' + Campo[9];
              HReccm1 := HReccm1 + ',' + Campo[10];
              MedidaF2 := MedidaF2 + ',' + Campo[11];
              Hfrescm2 := Hfrescm2 + ',' + Campo[12];
              HReccm2 := HReccm2 + ',' + Campo[13];
              MedidaF3 := MedidaF3 + ',' + Campo[14];
              Hfrescm3 := Hfrescm3 + ',' + Campo[15];
              HReccm3 := HReccm3 + ',' + Campo[16];
              MedidaF4 := MedidaF4 + ',' + Campo[17];
              Hfrescm4 := Hfrescm4 + ',' + Campo[18];
              HReccm4 := HReccm4 + ',' + Campo[19];
              AcostLD := AcostLD + ',' + Campo[20];
              HRACLD := HRACLD + ',' + Campo[21];
              H2ACLD := H2ACLD + ',' + Campo[22];
              AnoAtual := AnoEstrat;
            end;
        end;
      CloseFile(ArqDados);
      ArqCsv := Calc + 'MDRO' + Rodovia[IRodov] + '_' + AnoAtual + '.csv';
      AssignFile(ArqOut, ArqCsv);
      Rewrite(ArqOut);
      Writeln(ArqOut, STH);
      Writeln(ArqOut, Iniciokm);
      Writeln(ArqOut, AcostLE);
      Writeln(ArqOut, HRACLE);
      Writeln(ArqOut, H2ACLE);
      Writeln(ArqOut, MedidaF1);
      Writeln(ArqOut, Hfrescm1);
      Writeln(ArqOut, HReccm1);
      Writeln(ArqOut, MedidaF2);
      Writeln(ArqOut, Hfrescm2);
      Writeln(ArqOut, HReccm2);
      Writeln(ArqOut, MedidaF3);
      Writeln(ArqOut, Hfrescm3);
      Writeln(ArqOut, HReccm3);
      Writeln(ArqOut, MedidaF4);
      Writeln(ArqOut, Hfrescm4);
      Writeln(ArqOut, HReccm4);
      Writeln(ArqOut, AcostLD);
      Writeln(ArqOut, HRACLD);
      Writeln(ArqOut, H2ACLD);
      CloseFile(ArqOut);
    end;
  { Insere os arquivo *.csv gerados nas planilhas Excel dos unifilares }
    Excel := CreateOleObject('Excel.Application');
    Excel.Visible := False;
    for i := 1 to NRodov do
      begin
        for j := 1 to NPeriodos do
          begin
            AnoAtual := IntToStr(Ano+j);
            ArqXlsNovo := Calc + 'Unifilares\' + 'Unifilar_RO' + Rodovia[i] + '_' + AnoAtual + '.xls';
            if FileExists(ArqXlsNovo) then
              begin
                AssignFile(ArqDados, ArqXlsNovo);
                Erase(ArqDados);
              end;
            ArqXls := Dados + Year + '\Unifilar\' + 'Unifilar_' + Rodovia[i] + '.xls';
            if FileExists(ArqXls) then
              begin
                ArqCsv := Calc + 'PP' + Rodovia[i] + '1.csv';
                FileCodeExcel := 6;
                Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
                FileCodeExcel := 1;
                Excel.Workbooks.Open(ArqXls, True, FileCodeExcel);
                Excel.Workbooks[1].Sheets[1].UsedRange.Copy;
                Excel.Workbooks[2].Sheets[1].PasteSpecial;
                ArqCsv := Calc + 'PP' + Rodovia[i] + '2.csv';
                FileCodeExcel := 6;
                Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
                Excel.Workbooks[3].Sheets[1].UsedRange.Copy;
                Excel.Workbooks[2].Sheets[2].PasteSpecial;
                ArqCsv := Calc + 'CRO' + Rodovia[i] + IntToStr(j) + '.csv';
                FileCodeExcel := 6;
                Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
                Excel.Workbooks[4].Sheets[1].UsedRange.Copy;
                Excel.Workbooks[2].Sheets[3].PasteSpecial;
                ArqCsv := Calc + 'MDRO' + Rodovia[i] + '_' + AnoAtual + '.csv';
                FileCodeExcel := 6;
                Excel.Workbooks.Open(ArqCsv, True, FileCodeExcel);
                Excel.Workbooks[5].Sheets[1].UsedRange.Copy;
                Excel.Workbooks[2].Sheets[4].PasteSpecial;
                FileCodeExcel := 1;
                Excel.Workbooks[2].Sheets[1].SaveAs(ArqXlsNovo, FileCodeExcel);
                Excel.Workbooks[2].Saved := True;
                Excel.Workbooks.Close;
              end;
          end;
      end;
    Excel.Quit;
  Screen.Cursor := crDefault;
end;

procedure TForm28.Cut1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid3.SelectedField.AsString;
  DataSource3.Edit;
  DBGrid3.SelectedField.Clear;
  DataModule10.Table11.Post;
end;

procedure TForm28.Copy1Click(Sender: TObject);
begin
  Memo1.Text := DBGrid3.SelectedField.AsString;
end;

procedure TForm28.Coluna1Click(Sender: TObject);
var
  i: SmallInt;
begin
  i := DBGrid3.SelectedField.Index;
  with DataModule10.Table11 do
    begin
      First;
      while not EOF do
        begin
          DataSource3.Edit;
          DBGrid3.Fields[i].AsString := Memo1.Text;
          Next;
        end;
      DataSource3.Edit;
      Post;
    end;
end;

procedure TForm28.Clula1Click(Sender: TObject);
begin
  DataSource3.Edit;
  DBGrid3.SelectedField.AsString := Memo1.Text;
  DataModule10.Table11.Post;
end;

initialization
  CoInitialize (nil);

end.
