unit Unit26;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Db, Grids, DBGrids, DBCtrls;

type
  TForm26 = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    ComboBox1: TComboBox;
    Label39: TLabel;
    DBGrid2: TDBGrid;
    DataSource2: TDataSource;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    BitBtn3: TBitBtn;
    Label9: TLabel;
    Edit2: TEdit;
    procedure PrevisodoDesempenhoFuturo1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form26: TForm26;

implementation

uses Childwin, Unit24, ComObj, ActiveX, Unit94;

{$R *.DFM}

procedure TForm26.PrevisodoDesempenhoFuturo1Click(Sender: TObject);
begin
  MDIChild.PrevisodoDesempenhoFuturo1Click(Sender);
end;

procedure TForm26.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm26.BitBtn1Click(Sender: TObject);
const
  NPolos = 7;
  NRodovMax = 150;
var
  Excel: OleVariant;
  Ano, NPeriodos, i, Modo, FileCodeExcel, NRodov, Code, NPP, j, NFields, icont,
    jk: integer;
  ArqDados: TextFile;
  Custo0, PSI0, Ocorr0, VR0: Single;
  Custo, PSI, Ocorr, VR, Deficit: array [0..100] of Single;
  CustoPolo: array [1..NRodovMax, 0..100] of Single;
  Programa, Dados, Calc, Arquivo, ArqDbf, ArqCsv, DadosAnoBase, Linha, ConfReg: string;
  Rodovia: array [1..NRodovMax] of string[4];
  Year: string[4];
  Campo: array [1..100] of string;
  Oc0, VRat: string[5];
  PS0: string[4];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
begin
  Screen.Cursor := crHourglass;
  NPP := 1;
  DataModule24.Table3.Active := False;
  DataModule24.Table11.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  AssignFile(ArqDados, 'Config.dat');
  Reset(ArqDados);
  Readln(ArqDados, ConfReg);
  CloseFile(ArqDados);
  { Cdigos de identificao das rodovias que compem a rede }
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  { Gera os arquivos de dados a serem acessados por Estrateg.bas }
    Modo := 0;
    Arquivo := Calc + 'Modo.dat';
    AssignFile(ArqDados, Arquivo);
    Rewrite(ArqDados);
    Writeln(ArqDados, Modo);
    CloseFile(ArqDados);
    Arquivo := Calc + 'Dados.dat';
    AssignFile(ArqDados, Arquivo);
    Rewrite(ArqDados);
    Writeln(ArqDados, Modo);
    VirgDot(Edit1.Text);
    Writeln(ArqDados, VarDot);
    Writeln(ArqDados, VarDot);
    Writeln(ArqDados, NPP);
    VirgDot(Edit2.Text);
    Writeln(ArqDados, VarDot);
    CloseFile(ArqDados);
  { Executa o programa Estrateg.bas para determinao das
    necessidades atuais de manuteno }
  { Apaga os arquivos *.xls e *.dbf existentes }
    ArqCsv := 'DOS.DAT';
    if FileExists(ArqCsv) then
      begin
        AssignFile(ArqDados, ArqCsv);
        Erase(ArqDados)
      end;
    WinExec('ArqEvo.bat /c', SW_SHOW);
    Flag := 0;
    StartTime := now;
    NumSec := 7;
    repeat
      Application.ProcessMessages;
      if FileExists(ArqCsv) then Flag := 1;
    until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  { Converte de CSV para DBF }
    for i := 1 to NRodov do
      begin
        ArqCsv := Calc + 'Evo' + Rodovia[i] + '.csv';
        ArqDbf := Calc + 'Evo' + Rodovia[i] + '.dbf';
        NFields := 22;
        AssignFile(ArqDados, ArqCsv);
        Reset(ArqDados);
        Readln(ArqDados, Linha);
        with DataModule24.Table3 do
          begin
            Active := False;
            TableName := ArqDbf;
            CreateTable;
            Active := True;
            Edit;
            First;
          end;
        while not eof(ArqDados) do
          begin
            Readln(ArqDados, Linha);
            j := 1;
            for icont := 1 to NFields do
              Campo[icont] := '';
            for icont := 1 to Length(Linha) do
              begin
                if Linha[icont] = ',' then
                  j := j + 1
                else
                  if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
              end;
            if ConfReg = 'Portuguese' then
              begin
                for j := 3 to 4 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 6 to 7 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 9 to 10 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 12 to 13 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 15 to 16 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 18 to 19 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
                for j := 21 to 22 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
              end;
            DataModule24.Table3.InsertRecord([Campo[1],Campo[2],StrToFloat(Campo[3]),
              StrToFloat(Campo[4]),Campo[5],StrToFloat(Campo[6]),StrToFloat(Campo[7]),
              Campo[8],StrToFloat(Campo[9]),StrToFloat(Campo[10]),
              Campo[11],StrToFloat(Campo[12]),StrToFloat(Campo[13]),
              Campo[14],StrToFloat(Campo[15]),StrToFloat(Campo[16]),
              Campo[17],StrToFloat(Campo[18]),StrToFloat(Campo[19]),
              Campo[20],StrToFloat(Campo[21]),StrToFloat(Campo[22])]);
          end;
        DataModule24.Table3.Close;
        DataModule24.Table3.Active := False;
        CloseFile(ArqDados);
      end;
  { L os custos de manuteno previstos }
  { No Ano 0 }
    Arquivo := Calc + 'CustoNAT.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Custo0);
    Custo0 := Int(Custo0);
    Readln(ArqDados, Deficit[0]);
    Label6.Caption := FloatToStr(Deficit[0]);
    for i := 1 to NPolos do
      Readln(ArqDados, CustoPolo[i,0]);
    CloseFile(ArqDados);
   { Ao Longo do Tempo }
    Arquivo := Calc + 'CustoEVO.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    for i := 1 to NPeriodos do
      begin
        Readln(ArqDados, Custo[i]);
        Readln(ArqDados, Deficit[i]);
        for j := 1 to NPolos do
          Readln(ArqDados, CustoPolo[j,i]);
      end;
    CloseFile(ArqDados);
  { L o PSI mdio da rede que foi previsto }
    Arquivo := Calc + 'PSISI.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, PSI0);
    PS0 := FloatToStr(PSI0);
    Label7.Caption := PS0;
    for i := 1 to NPeriodos do
      Readln(ArqDados, PSI[i]);
    CloseFile(ArqDados);
  { L as ocorrncias previstas na rede }
    Arquivo := Calc + 'NPSISI.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Ocorr0);
    Oc0 := FloatToStr(Ocorr0);
    Label8.Caption := Oc0;
    for i := 1 to NPeriodos do
      Readln(ArqDados, Ocorr[i]);
    CloseFile(ArqDados);
  { L a Vida Restante mdia da rede }
    Arquivo := Calc + 'VRSI.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, VR0);
    VRat := FloatToStr(VR0);
    Label11.Caption := VRat;
    for i := 1 to NPeriodos do
      Readln(ArqDados, VR[i]);
    CloseFile(ArqDados);
  { Gera a tabela contendo os resultados }
    { Converte de CSV para DBF }
      ArqCsv := Calc + 'Results.csv';
      ArqDbf := Calc + 'ResSI.dbf';
      NFields := 5;
      AssignFile(ArqDados, ArqCsv);
      Reset(ArqDados);
      Readln(ArqDados, Linha);
      with DataModule24.Table11 do
        begin
          Active := False;
          TableName := ArqDbf;
          CreateTable;
          Active := True;
          Edit;
          First;
        end;
      while not eof(ArqDados) do
        begin
          Readln(ArqDados, Linha);
          j := 1;
          for icont := 1 to NFields do
            Campo[icont] := '';
          for icont := 1 to Length(Linha) do
            begin
              if Linha[icont] = ',' then
                j := j + 1
              else
                if Linha[icont] <> '"' then Campo[j] := Campo[j] + Linha[icont];
            end;
            if ConfReg = 'Portuguese' then
              begin
                for j := 2 to 5 do
                  begin
                    for jk := 1 to Length(Campo[j]) do
                      if Campo[j,jk] = '.' then Campo[j,jk] := ',';
                  end;
              end;
          DataModule24.Table11.InsertRecord([Campo[1],StrToFloat(Campo[2]),
            StrToFloat(Campo[3]),StrToFloat(Campo[4]),StrToFloat(Campo[5])]);
        end;
      DataModule24.Table11.Close;
      DataModule24.Table11.Active := False;
      CloseFile(ArqDados);
   {
      ArqCsv := Calc + 'EVOPista.csv';
      ArqDbf := Calc + 'EVOPista.dbf';
      ChangeType := ' /CT:Ano=C(5)';
      Csv2Dbf(ArqCsv, ArqDbf, ChangeType);
      ArqCsv := Calc + 'EVOAcost.csv';
      ArqDbf := Calc + 'EVOAcost.dbf';
      ChangeType := ' /CT:Ano=C(5)';
      Csv2Dbf(ArqCsv, ArqDbf, ChangeType);
    }
  DataModule24.Table11.Active := True;
  Label39.Caption := 'Trecho:';
  ComboBox1.Visible := True;
  Screen.Cursor := crDefault;
end;

procedure TForm26.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  ArqDados, Arq: TextFile;
  Trecho, Nome: string[4];
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox1.Text = Local then Trecho := Nome;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  if ComboBox1.Text <> '' then
    begin
      DataModule24.Table3.Active := False;
      DataModule24.Table3.TableName := Calc + 'Evo' + Trecho + '.dbf';
      DataModule24.Table3.Active := True;
    end;
end;

procedure TForm26.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  Label39.Caption := '';
  ComboBox1.Visible := False;
  Label6.Caption := '';
  Label7.Caption := '';
  Label8.Caption := '';
  Label11.Caption := '';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox1.Items.LoadFromFile(Arquivo);
  DataModule24.Table3.Active := False;
  DataModule24.Table11.Active := False;
end;

procedure TForm26.BitBtn3Click(Sender: TObject);
const
  NPolos = 7;
  NRodovMax = 150;
var
  Ano, NPeriodos, i, Modo, NRodov, Code, NPP, j: integer;
  ArqDados: TextFile;
  PP, Custo0, PSI0, Ocorr0, VR0, inf, VUmin: Single;
  Custo, PSI, Ocorr, VR, Deficit: array [0..100] of Single;
  CustoPolo: array [1..NRodovMax, 0..100] of Real;
  Programa, Dados, Calc, Arquivo, ArqDbf, ArqCsv, DadosAnoBase: string;
  Rodovia: array [1..NRodovMax] of string[4];
  Year: string[4];
  Oc0, VRat: string[5];
  PS0: string[4];
begin
  Label39.Caption := 'Trecho:';
  ComboBox1.Visible := True;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  { L os custos de manuteno previstos }
  { No Ano 0 }
    Arquivo := Calc + 'CustoNAT.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Custo0);
    Custo0 := Int(Custo0);
    Readln(ArqDados, Deficit[0]);
    Label6.Caption := FloatToStr(Deficit[0]);
    for i := 1 to NPolos do
      Readln(ArqDados, CustoPolo[i,0]);
    CloseFile(ArqDados);
   { Ao Longo do Tempo }
    Arquivo := Calc + 'CustoEVO.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    for i := 1 to NPeriodos do
      begin
        Readln(ArqDados, Custo[i]);
        Readln(ArqDados, Deficit[i]);
        for j := 1 to NPolos do
          Readln(ArqDados, CustoPolo[j,i]);
      end;
    CloseFile(ArqDados);
  { L o PSI mdio da rede que foi previsto }
    Arquivo := Calc + 'PSISI.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, PSI0);
    PS0 := FloatToStr(PSI0);
    Label7.Caption := PS0;
    for i := 1 to NPeriodos do
      Readln(ArqDados, PSI[i]);
    CloseFile(ArqDados);
  { L as ocorrncias previstas na rede }
    Arquivo := Calc + 'NPSISI.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Ocorr0);
    Oc0 := FloatToStr(Ocorr0);
    Label8.Caption := Oc0;
    for i := 1 to NPeriodos do
      Readln(ArqDados, Ocorr[i]);
    CloseFile(ArqDados);
  { L a Vida Restante mdia da rede }
    Arquivo := Calc + 'VRSI.out';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, VR0);
    VRat := FloatToStr(VR0);
    Label11.Caption := VRat;
    for i := 1 to NPeriodos do
      Readln(ArqDados, VR[i]);
    CloseFile(ArqDados);
    Arquivo := Calc + 'Dados.dat';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Modo);
    Readln(ArqDados, VUmin);
    Readln(ArqDados, PP);
    Readln(ArqDados, NPP);
    Readln(ArqDados, inf);
    CloseFile(ArqDados);
    Edit1.Text := FloatToStr(PP);
    Edit2.Text := FloatToStr(inf);
    ArqDbf := Calc + 'ResSI.dbf';
    DataModule24.Table11.Active := False;
    DataModule24.Table11.TableName := ArqDbf;
    DataModule24.Table11.Active := True;
end;

initialization
  CoInitialize (nil);

end.
