unit Unit20;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, DB, Grids, DBGrids, DBCtrls;

type
  TForm20 = class(TForm)
    Panel1: TPanel;
    Panel3: TPanel;
    GroupBox1: TGroupBox;
    Label4: TLabel;
    Label7: TLabel;
    Edit2: TEdit;
    Edit5: TEdit;
    Label9: TLabel;
    ComboBox1: TComboBox;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Panel2: TPanel;
    BitBtn3: TBitBtn;
    Label2: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    BitBtn1: TBitBtn;
    Panel4: TPanel;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    DataSource1: TDataSource;
    Edit3: TEdit;
    ComboBox2: TComboBox;
    procedure ModelosdePrevisodeDesempenho1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form20: TForm20;

implementation

uses Childwin, Unit24, ComObj, ActiveX, Unit94;

{$R *.DFM}

procedure TForm20.ModelosdePrevisodeDesempenho1Click(Sender: TObject);
begin
  MDIChild.ModelosdePrevisodeDesempenho1Click(Sender);
end;

procedure TForm20.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm20.BitBtn1Click(Sender: TObject);
var
  ArqDados: TextFile;
  Ano, NPeriodos, Code, i, j, NModelos: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Year: string[4];
  A0, A1, A2, Se: array [1..50] of Single;
  CamadaRest: array [1..50] of string;
  Coef: array [1..10] of string;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := Programa + 'ModSF.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NModelos);
  j := 0;
  for i := 1 to NModelos do
    begin
      Readln(ArqDados, CamadaRest[i]);
      Readln(ArqDados, A0[i]);
      Readln(ArqDados, A1[i]);
      Readln(ArqDados, A2[i]);
      Readln(ArqDados, Se[i]);
      if CamadaRest[i] = ComboBox1.Text then j := i;
    end;
  CloseFile(ArqDados);
  if j > 0 then
    begin
     Arquivo := Programa + 'Modelos.dat';
     AssignFile(ArqDados, Arquivo);
     Rewrite(ArqDados);
     Writeln(ArqDados, NModelos);
     for i := 1 to NModelos do
       begin
         Writeln(ArqDados, CamadaRest[i]);
         if j = i then
           begin
             CamadaRest[j] := ComboBox1.Text;
             VirgDot(Edit2.Text);
             if ComboBox2.Text = 'Com fibras' then
               begin
                 A0[i] := 3.1;
                 Writeln(ArqDados, A0[i]);
               end
             else
               Writeln(ArqDados, VarDot);
             VirgDot(Edit1.Text);
             Writeln(ArqDados, VarDot);
             VirgDot(Edit5.Text);
             Writeln(ArqDados, VarDot);
             VirgDot(Edit3.Text);
             Writeln(ArqDados, VarDot);
           end
         else
           begin
             Writeln(ArqDados, A0[i]);
             Writeln(ArqDados, A1[i]);
             Writeln(ArqDados, A2[i]);
             Writeln(ArqDados, Se[i]);
           end;
       end;
      CloseFile(ArqDados);
    end;
  Edit1.Text := '';
  Edit2.Text := '';
  Edit5.Text := '';
  Edit3.Text := '';
end;

procedure TForm20.FormShow(Sender: TObject);
var
  ArqDados: TextFile;
  Ano, NPeriodos: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Year: string[4];
begin
  ComboBox2.Visible := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := Programa + 'MODELS.DAT';
  ComboBox1.Items.LoadFromFile(Arquivo);
  DBGrid1.Columns[0].PickList.LoadFromFile(DadosAnoBase + 'Trechos.dsc');
  DBGrid1.Columns[1].PickList.LoadFromFile(Programa + 'Models.dat');
  DataModule24.Table31.Active := False;
  DataModule24.Table31.TableName := Calc + 'CPtrecho.dbf';
  DataModule24.Table31.Active := True;
end;

procedure TForm20.ComboBox1Change(Sender: TObject);
var
  ArqDados: TextFile;
  Ano, NPeriodos, NModelos, i, j, Code: integer;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
  Year: string[4];
  A0, A1, A2, Se: array [1..50] of Single;
  CamadaRest: array [1..50] of string;
  Parametro: string[8];
begin
  ComboBox2.Visible := False;
  if ComboBox1.Text = 'Micro-CA Delgado' then ComboBox2.Visible := True;
  if ComboBox1.Text = 'Micro-CA Normal' then ComboBox2.Visible := True;
  if ComboBox1.Text = 'Micro-CA Espesso' then ComboBox2.Visible := True;
  Edit1.Text := '';
  Edit2.Text := '';
  Edit5.Text := '';
  Edit3.Text := '';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := Programa + 'ModSF.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NModelos);
  j := 0;
  for i := 1 to NModelos do
    begin
      Readln(ArqDados, CamadaRest[i]);
      Readln(ArqDados, A0[i]);
      Readln(ArqDados, A1[i]);
      Readln(ArqDados, A2[i]);
      Readln(ArqDados, Se[i]);
      if CamadaRest[i] = ComboBox1.Text then j := i;
    end;
  CloseFile(ArqDados);
  if j > 0 then
    begin
      Parametro := FloatToStr(A0[j]);
      Edit2.Text := Parametro;
      Parametro := FloatToStr(A2[j]);
      Edit1.Text := Parametro;
      Parametro := FloatToStr(A1[j]);
      Edit5.Text := Parametro;
      Parametro := FloatToStr(Se[j]);
      Edit3.Text := Parametro;
    end;
end;

procedure TForm20.BitBtn3Click(Sender: TObject);
var
  Excel: OleVariant;
  Ano, NPeriodos, FileCodeExcel, icont, NFields, jk: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, ArqCsv, DadosAnoBase, Linha, LinhaX,
    LinhaY: string;
  Year: string[4];
begin
  Screen.Cursor := crHourglass;
  DataSource1.Edit;
  DataModule24.Table31.Post;
  DataModule24.Table31.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  { Gera o arquivo *.csv correspondente }
  ArqCsv := Calc + 'CPtrecho.csv';
  Arquivo := Calc + 'CPtrecho.dbf';
  AssignFile(ArqDados, ArqCsv);
  Rewrite(ArqDados);
  Linha := 'TRECHO, TIPO, H_(CM)';
  NFields := 1;
  for icont := 1 to Length(Linha) do
    if Linha[icont] = ',' then NFields := NFields + 1;
  Writeln(ArqDados, Linha);
  with DataModule24.Table31 do
    begin
      Active := False;
      TableName := Arquivo;
      Active := True;
      First;
      while not Eof do
        begin
          LinhaX := Fields.Fields[0].AsString;
          Linha := '';
          for jk := 1 to Length(LinhaX) do
            begin
              if LinhaX[jk] = ',' then LinhaX[jk] := '.';
              Linha := Linha + LinhaX[jk];
            end;
          for icont := 1 to NFields-1 do
            begin
              LinhaX := Fields.Fields[icont].AsString;
              LinhaY := '';
              for jk := 1 to Length(LinhaX) do
                begin
                  if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                  LinhaY := LinhaY + LinhaX[jk];
                end;
              Linha := Linha + ',' + LinhaY;
            end;
          Writeln(ArqDados, Linha);
          Next;
        end;
      Active := False;
    end;
  CloseFile(ArqDados);
  Screen.Cursor := crDefault;
  Close;
end;

initialization
  CoInitialize (nil);

end.
