unit Unit15;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Db, DBCtrls, Grids, DBGrids;

type
  TForm15 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Label2: TLabel;
    ComboBox2: TComboBox;
    DataSource3: TDataSource;
    Panel3: TPanel;
    DBGrid3: TDBGrid;
    BitBtn1: TBitBtn;
    BitBtn3: TBitBtn;
    Label1: TLabel;
    ComboBox1: TComboBox;
    DBNavigator1: TDBNavigator;
    Label3: TLabel;
    procedure CustosUnitrios1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form15: TForm15;

implementation

uses Childwin, Unit51, ComObj, ActiveX, Unit94;

{$R *.DFM}

procedure TForm15.CustosUnitrios1Click(Sender: TObject);
begin
  MDIChild.CustosUnitrios1Click(Sender);
end;

procedure TForm15.FormShow(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  Label3.Caption := '';
  BitBtn1.Visible := False;
  DataModule51.Table1.Active := False;
  Label2.Visible := False;
  ComboBox2.Visible := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  ComboBox2.Items.LoadFromFile(Arquivo);
end;

procedure TForm15.ComboBox2Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, Polo, Local, DadosAnoBase: string;
  Year: string[4];
  Trecho, Nome: string[4];
begin
 if ComboBox2.Text <> '' then
 begin
  Label3.Caption := '';
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      Readln(ArqDados, Local);
      Readln(Arq, Nome);
      if ComboBox2.Text = Local then
        begin
          Trecho := Nome;
          Label3.Caption := Nome;
        end;
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  DataModule51.Table1.Active := False;
  DataModule51.Table1.TableName := Dados + 'Custos\COST_' + Trecho + '_' + Year + '.dbf';
  DataModule51.Table1.Active := True;
  BitBtn1.Visible := True;
 end;
end;

procedure TForm15.BitBtn1Click(Sender: TObject);
var
  Excel: OleVariant;
  Ano, NPeriodos, FileCodeExcel, NRodov, i, NFields, icont, jk: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, Polo, Local, Path, DadosAnoBase, Linha,
    ArqCsv, LinhaX, LinhaY: string;
  Year: string[4];
  Trecho: string[4];
  Nome: array [1..500] of string[4];
  NumSec: SmallInt;
  StartTime: TDateTime;
begin
  Screen.Cursor := crHourglass;
  DataSource3.Edit;
  DataModule51.Table1.Post;
  DataModule51.Table1.Active := False;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(Ano);
  Arquivo := DadosAnoBase + 'Trechos.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  NRodov := 0;
  Arquivo := DadosAnoBase + 'Trechos.dsc';
  AssignFile(Arq, Arquivo);
  Reset(Arq);
  while Eof(ArqDados) = False do
    begin
      NRodov := NRodov + 1;
      Readln(ArqDados, Local);
      Readln(Arq, Nome[NRodov]);
      if ComboBox2.Text = Local then Trecho := Nome[NRodov];
    end;
  CloseFile(ArqDados);
  CloseFile(Arq);
  if ComboBox1.Text = 'Para toda a rede' then
   begin
     for i := 1 to NRodov do
       begin
         Trecho := Nome[i];
         { Gera o arquivo *.csv correspondente }
           Arquivo := Dados + 'Custos\COST_' + Year + '.dbf';
           ArqCsv := Calc + 'COST' + Trecho + '.csv';
           AssignFile(ArqDados, ArqCsv);
           Rewrite(ArqDados);
           Linha := 'ITEM,CUSTO,UNIDADE';
           NFields := 1;
           for icont := 1 to Length(Linha) do
             if Linha[icont] = ',' then NFields := NFields + 1;
           Writeln(ArqDados, Linha);
           with DataModule51.Table1 do
             begin
               Active := False;
               TableName := Arquivo;
               Active := True;
               First;
               while not Eof do
                 begin
                   LinhaX := Fields.Fields[0].AsString;
                   Linha := '';
                   for jk := 1 to Length(LinhaX) do
                     begin
                       if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                       Linha := Linha + LinhaX[jk];
                     end;
                   for icont := 1 to NFields-1 do
                     begin
                       LinhaX := Fields.Fields[icont].AsString;
                       LinhaY := '';
                       for jk := 1 to Length(LinhaX) do
                         begin
                           if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                           LinhaY := LinhaY + LinhaX[jk];
                         end;
                       Linha := Linha + ',' + LinhaY;
                     end;
                   Writeln(ArqDados, Linha);
                   Next;
                end;
              Active := False;
            end;
           CloseFile(ArqDados);
       end;
   end
  else
   { Gera o arquivo *.csv correspondente }
   if ComboBox2.Text <> '' then
    begin
      Arquivo := Dados + 'Custos\COST_' + Trecho + '_' + Year + '.dbf';
      ArqCsv := Calc + 'COST' + Trecho + '.csv';
      AssignFile(ArqDados, ArqCsv);
      Rewrite(ArqDados);
      Linha := 'ITEM,CUSTO,UNIDADE';
      NFields := 1;
      for icont := 1 to Length(Linha) do
        if Linha[icont] = ',' then NFields := NFields + 1;
      Writeln(ArqDados, Linha);
      with DataModule51.Table1 do
        begin
          Active := False;
          TableName := Arquivo;
          Active := True;
          First;
          while not Eof do
            begin
              LinhaX := Fields.Fields[0].AsString;
              Linha := '';
              for jk := 1 to Length(LinhaX) do
                begin
                  if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                  Linha := Linha + LinhaX[jk];
                end;
              for icont := 1 to NFields-1 do
                begin
                  LinhaX := Fields.Fields[icont].AsString;
                  LinhaY := '';
                  for jk := 1 to Length(LinhaX) do
                    begin
                      if LinhaX[jk] = ',' then LinhaX[jk] := '.';
                      LinhaY := LinhaY + LinhaX[jk];
                    end;
                  Linha := Linha + ',' + LinhaY;
                end;
              Writeln(ArqDados, Linha);
              Next;
            end;
          Active := False;
        end;
      CloseFile(ArqDados);
    end;
  BitBtn1.Visible := False;
  Screen.Cursor := crDefault;
end;

procedure TForm15.BitBtn3Click(Sender: TObject);
begin
  DataSource3.Edit;
  DataModule51.Table1.Post;
  DataModule51.Table1.Active := False;
  Close;
end;

procedure TForm15.ComboBox1Change(Sender: TObject);
var
  Ano, NPeriodos: integer;
  ArqDados, Arq: TextFile;
  Programa, Dados, Calc, Arquivo, Local, DadosAnoBase: string;
  Year: string[4];
begin
  ComboBox2.Text := '';
  if ComboBox1.Text = 'Por trecho' then
    begin
      Label2.Visible := True;
      ComboBox2.Visible := True;
      DataModule51.Table1.Active := False;
    end
  else
    begin
      Label3.Caption := '';
      Label2.Visible := False;
      ComboBox2.Visible := False;
      AssignFile(ArqDados, 'Diretor.dat');
      Reset(ArqDados);
      Readln(ArqDados, Ano);
      Readln(ArqDados, NPeriodos);
      Readln(ArqDados, Programa);
      Readln(ArqDados, Dados);
      Readln(ArqDados, Calc);
      Readln(ArqDados, DadosAnoBase);
      CloseFile(ArqDados);
      Year := IntToStr(Ano);
      DataModule51.Table1.Active := False;
      DataModule51.Table1.TableName := Dados + 'Custos\COST_' + Year + '.dbf';
      DataModule51.Table1.Active := True;
      BitBtn1.Visible := True;
    end;
end;

initialization
  CoInitialize (nil);

end.
