unit Unit12;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, DB, Grids, DBGrids, DBCtrls;

type
  TForm12 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label2: TLabel;
    ComboBox2: TComboBox;
    BitBtn1: TBitBtn;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    DBGrid2: TDBGrid;
    DataSource2: TDataSource;
    DBGrid3: TDBGrid;
    DataSource3: TDataSource;
    DBGrid4: TDBGrid;
    DataSource4: TDataSource;
    DBGrid5: TDBGrid;
    DataSource5: TDataSource;
    DBNavigator1: TDBNavigator;
    BitBtn2: TBitBtn;
    procedure SAMPlanejamento1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form12: TForm12;

implementation

uses Childwin, Unit11, Unit94;

{$R *.dfm}

procedure TForm12.SAMPlanejamento1Click(Sender: TObject);
begin
  MDIChild.SAMPlanejamento1Click(Sender);
end;

procedure TForm12.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm12.FormShow(Sender: TObject);
var
  Ano, NPeriodos, i: integer;
  ArqDados: TextFile;
  Programa, Dados, Calc, Arquivo, DadosAnoBase: string;
begin
  DataModule11.Table6.Active := false;
  DataModule11.Table7.Active := false;
  DataModule11.Table8.Active := false;
  DataModule11.Table9.Active := false;
  DataModule11.Table10.Active := false;
  DBGrid1.Visible := false;
  DBGrid2.Visible := false;
  DBGrid3.Visible := false;
  DBGrid4.Visible := false;
  DBGrid5.Visible := false;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, Ano);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Arquivo := Calc + 'AnosSAM.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  for i := 0 to Nperiodos do
    if i = 0 then
      Writeln(ArqDados, 'Atual')
    else
      Writeln(ArqDados, IntToStr(i+Ano));
  CloseFile(ArqDados);
  ComboBox1.Items.LoadFromFile(Arquivo);
end;

procedure TForm12.ComboBox1Change(Sender: TObject);
var
  ArqDados, Arq: TextFile;
  Arquivo, ArqCsv, ArqDbf, PathOut, PathDat, DadosAnoBase, Dados, Calc,
    Programa, ChangeType: string;
  Code, Year: string[4];
  i, j, i1, i2, AnoBase, Ano, NPeriodos: integer;
  Trecho: string[4];
  Tipo1: array [1..15] of string[5];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
begin
  Screen.Cursor := crHourglass;
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, AnoBase);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(AnoBase);
  PathOut := Dados + 'SAM\';
  PathDat := Calc;
  Tipo1[1] := 'PAV';
  Tipo1[2] := 'OAE';
  Tipo1[3] := 'OAC';
  Tipo1[4] := 'DRG';
  Tipo1[5] := 'OUT';
  if ComboBox1.Text = 'Atual' then Ano := 0 else Ano := StrToInt(ComboBox1.Text);
  Arquivo := Calc + 'AnoQut.dat';
  AssignFile(ArqDados, Arquivo);
  Rewrite(ArqDados);
  Writeln(ArqDados, Ano);
  CloseFile(ArqDados);
  ArqCsv := 'DOS.DAT';
  if FileExists(ArqCsv) then
    begin
      AssignFile(ArqDados, ArqCsv);
      Erase(ArqDados)
    end;
  WinExec('QuantServ.exe /c', SW_HIDE);
  Flag := 0;
  StartTime := now;
  NumSec := 10;
  repeat
    Application.ProcessMessages;
    if FileExists(ArqCsv) then Flag := 1;
  until (Now > StartTime + NumSec * (1/24/60/60)) and (Flag = 1);
  Arquivo := DadosAnoBase + '\Trechos.dsc';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  AssignFile(Arq, 'Arq.dat');
  Rewrite(Arq);
  Writeln(Arq, 1);
  CloseFile(Arq);
  while not Eof(ArqDados) do
    begin
      Readln(ArqDados, Trecho);
      i1 := 1;
      i2 := 5;
      for i := i1 to i2 do
        begin
          ArqCsv := PathDat + 'Qut' + Tipo1[i] + IntToStr(Ano) + '.csv';
          ArqDbf := PathOut + 'Qut_' + Tipo1[i] + '_' + IntToStr(Ano) + '.dbf';
          ChangeType := ' /CT:TRECHO=C(7)';
          Csv2Dbf(ArqCsv, ArqDbf, ChangeType);
        end;
    end;
  CloseFile(ArqDados);
  i1 := 1;
  i2 := 5;
  for i := i1 to i2 do
    begin
      ArqDbf := PathOut + 'Qut_' + Tipo1[i] + '_' + IntToStr(Ano) + '.dbf';
          if i = 1 then
            begin
              DataModule11.Table6.Active := False;
              DataModule11.Table6.TableName := ArqDbf;
              DataModule11.Table6.Active := True;
              DataModule11.Table6.Edit;
              DataModule11.Table6.First;
              DataModule11.Table6.Delete;
              DataModule11.Table6.Active := False;
            end
            else
              if i = 2 then
                begin
                  DataModule11.Table7.Active := False;
                  DataModule11.Table7.TableName := ArqDbf;
                  DataModule11.Table7.Active := True;
                  DataModule11.Table7.Edit;
                  DataModule11.Table7.First;
                  DataModule11.Table7.Delete;
                  DataModule11.Table7.Active := False;
                end
              else
                if i = 3 then
                  begin
                    DataModule11.Table8.Active := False;
                    DataModule11.Table8.TableName := ArqDbf;
                    DataModule11.Table8.Active := True;
                    DataModule11.Table8.Edit;
                    DataModule11.Table8.First;
                    DataModule11.Table8.Delete;
                    DataModule11.Table8.Active := False;
                  end
                else
                  if i = 4 then
                    begin
                      DataModule11.Table9.Active := False;
                      DataModule11.Table9.TableName := ArqDbf;
                      DataModule11.Table9.Active := True;
                      DataModule11.Table9.Edit;
                      DataModule11.Table9.First;
                      DataModule11.Table9.Delete;
                      DataModule11.Table9.Active := False;
                    end
                  else
                    begin
                      DataModule11.Table10.Active := False;
                      DataModule11.Table10.TableName := ArqDbf;
                      DataModule11.Table10.Active := True;
                      DataModule11.Table10.Edit;
                      DataModule11.Table10.First;
                      DataModule11.Table10.Delete;
                      DataModule11.Table10.Active := False;
                    end;
    end;
  Screen.Cursor := crDefault;
end;

procedure TForm12.ComboBox2Change(Sender: TObject);
var
  ArqDados, Arq: TextFile;
  Arquivo, ArqCsv, ArqDbf, PathOut, PathDat, DadosAnoBase, Dados, Calc,
    Programa, ChangeType: string;
  Code, Year: string[4];
  i, j, i1, i2, AnoBase, Ano, NPeriodos: integer;
  Trecho: string[4];
  Tipo1: array [1..15] of string[5];
  NumSec, Flag: SmallInt;
  StartTime: TDateTime;
begin
if ComboBox1.Text <> '' then
 if ComboBox2.Text <> '' then
  begin
   AssignFile(ArqDados, 'Diretor.dat');
   Reset(ArqDados);
   Readln(ArqDados, AnoBase);
   Readln(ArqDados, NPeriodos);
   Readln(ArqDados, Programa);
   Readln(ArqDados, Dados);
   Readln(ArqDados, Calc);
   Readln(ArqDados, DadosAnoBase);
   CloseFile(ArqDados);
   Year := IntToStr(AnoBase);
   PathOut := Dados + 'SAM\';
   DBGrid1.Visible := False;
   DBGrid2.Visible := False;
   DBGrid3.Visible := False;
   DBGrid4.Visible := False;
   DBGrid5.Visible := False;
   DataModule11.Table6.Active := False;
   DataModule11.Table7.Active := False;
   DataModule11.Table8.Active := False;
   DataModule11.Table9.Active := False;
   DataModule11.Table10.Active := False;
   if ComboBox1.Text = 'Atual' then Ano := 0 else Ano := StrToInt(ComboBox1.Text);
   if ComboBox2.Text = 'Pavimentos' then
     begin
       ArqDbf := PathOut + 'Qut_' + 'PAV_' + IntToStr(Ano) + '.dbf';
       DataModule11.Table6.TableName := ArqDbf;
       DataModule11.Table6.Active := True;
       DBGrid1.Align := alClient;
       DBGrid1.Visible := True;
       DBNavigator1.DataSource := DataSource1;
     end
   else
     if ComboBox2.Text = 'Obras de Arte Especiais' then
       begin
         ArqDbf := PathOut + 'Qut_' + 'OAE_' + IntToStr(Ano) + '.dbf';
         DataModule11.Table7.TableName := ArqDbf;
         DataModule11.Table7.Active := True;
         DBGrid2.Align := alClient;
         DBGrid2.Visible := True;
         DBNavigator1.DataSource := DataSource2;
       end
     else
      if ComboBox2.Text = 'Obras de Arte Correntes' then
        begin
          ArqDbf := PathOut + 'Qut_' + 'OAC_' + IntToStr(Ano) + '.dbf';
          DataModule11.Table8.TableName := ArqDbf;
          DataModule11.Table8.Active := True;
          DBGrid3.Align := alClient;
          DBGrid3.Visible := True;
          DBNavigator1.DataSource := DataSource3;
        end
      else
        if ComboBox2.Text = 'Drenagem' then
          begin
            ArqDbf := PathOut + 'Qut_' + 'DRG_' + IntToStr(Ano) + '.dbf';
            DataModule11.Table9.TableName := ArqDbf;
            DataModule11.Table9.Active := True;
            DBGrid4.Align := alClient;
            DBGrid4.Visible := True;
            DBNavigator1.DataSource := DataSource4;
          end
        else
          begin
            ArqDbf := PathOut + 'Qut_' + 'OUT_' + IntToStr(Ano) + '.dbf';
            DataModule11.Table10.TableName := ArqDbf;
            DataModule11.Table10.Active := True;
            DBGrid5.Align := alClient;
            DBGrid5.Visible := True;
            DBNavigator1.DataSource := DataSource5;
          end;
 end;
end;

procedure TForm12.BitBtn2Click(Sender: TObject);
begin
  ComboBox1.Text := 'Atual';
end;

end.
