CLS

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4
DIM CustoP(NRODOV), ConserP(NRODOV), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
DIM Revest$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
DIM FCnovorede(NRODOV), FCrecaprede(NRODOV), FCmicroCA(NRODOV)
DIM FC0novorede(NRODOV), FC0recaprede(NRODOV), FC0microCA(NRODOV)
DIM FC2novorede(NRODOV), FC2recaprede(NRODOV), FC2microCA(NRODOV)
DIM HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax), RepPerct(NFaixasMax)
DIM ICalib(NFaixasMax), Trecho$(NRODOV), D0(NFaixasMax), MRfound(NFaixasMax)
DIM PSIacost(NFaixasMax), DegrauAcost(NFaixasMax), MedidaAcost$(NFaixasMax)
DIM HRAC(NFaixasMax), H2AC(NFaixasMax), CustoAcost(NFaixasMax), CTotal(NRODOV)
DIM MatCP$(NRODOV), HRCP(NRODOV), CamadaRest$(NRODOV), A0rest(NRODOV)
DIM A2rest(NRODOV), A1rest(NRODOV), RLcost(NFaixasMax), SErest(NRODOV)
DIM Ano(2), Year$(2)

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Leitura dos codigos numericos que identificam os Subtrechos Homogeneos:
DIM Code(NRODOV, NSTHMAX), NSTHI(NRODOV)
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "CODE" + Rodov$(I) + ".STH"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, NSTHI(I)
    FOR J = 1 TO NSTHI(I)
        INPUT #1, Code(I, J)
    NEXT J
    CLOSE #1
NEXT I

' Constantes
PI# = 3.141592654#

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), VRmed(NPeriodos)
DIM Idade(NFaixasMax), PSIat(2000, NFaixasMax), Nano(NFaixasMax)
DIM RestrAnual(NPeriodos), RestrPolo(NRODOV, NPeriodos), IPRIOR(2000, NFaixasMax)
DIM PSImed(NPeriodos), Aream2(2000, NFaixasMax), CustoFaixa(NFaixasMax)
DIM MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax), AreaAcost(2000, NFaixasMax)
DIM PSImedSTH(2000), Npsi(NPeriodos), NFaixas(2000), QIFx1(NFaixasMax), QIFx2(NFaixasMax)
DIM IRI0(NFaixasMax), ALPHA(NFaixasMax)

CLS
PRINT
PRINT "                        * * * * * * * * * * * * * * * * * * * * * * * * * "
PRINT "                        *  ANALISA O DESEMPENHO DO ULTIMO RECAPEAMENTO  * "
PRINT "                        * * * * * * * * * * * * * * * * * * * * * * * * * "
PRINT

OPEN "Anos12.dat" FOR INPUT AS #1
INPUT #1, Ano(1)
INPUT #1, Ano(2)
CLOSE #1

FOR I = 1 TO 2
    x = 0
    OPEN "Nums.csv" FOR INPUT AS #1
    WHILE Ano(I) > x
        INPUT #1, x, xx$
    WEND
    CLOSE #1
    Year$(I) = xx$
NEXT I

FcMin = 0.3
FcMax = 1.05
Passo = 0.001
NPassos = (FcMax - FcMin) / Passo

ARQ$ = CALC$ + "FcRecap.csv"
OPEN ARQ$ FOR OUTPUT AS #15
WRITE #15, "Trecho", "STH", "kmi", "kmf", "Faixa", "Fc", "Erro (%)", "Hrecap (cm)", "QI_ano1", "QI_ano2", "Nano (AASHTO)", "Idade (anos)"
ARQUIVO$ = CALC$ + "ANO" + STR$(Ano(1)) + "\ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1

ARQUIVO$ = CALC$ + "ANO" + STR$(Ano(2)) + "\ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #2

ISTH = 0
FOR IRodov = 1 TO NRODOV
    PRINT "Trecho: "; Rodov$(IRodov)
    ARQUIVO$ = CALC$ + "FUNC" + Rodov$(IRodov) + Year$(1) + ".csv"
    OPEN ARQUIVO$ FOR INPUT AS #3
    LINE INPUT #3, LINHA$
    ARQUIVO$ = CALC$ + "FUNC" + Rodov$(IRodov) + Year$(2) + ".csv"
    OPEN ARQUIVO$ FOR INPUT AS #4
    LINE INPUT #4, LINHA$
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #1, STH, NFaixas(ISTH), kmi, kmf, FatorVDM, FatorTraf
        INPUT #2, STH, NFaixas(ISTH), kmi, kmf, FatorVDM, FatorTraf
        INPUT #3, SubT$, QIFx1(1), QIFx1(2), QIFx1(3), QIFx1(4), Dat1$, Equip1$
        INPUT #4, SubT$, QIFx2(1), QIFx2(2), QIFx2(3), QIFx2(4), Dat2$, Equip2$
        FOR IFaixa = 1 TO NFaixas(ISTH)
            INPUT #1, IFX, H1REV(1), HrecExist(1), Idade(1), SN(1), QImed(1), Nano(1), IRI0(IFX), Nacum(IFX), Revest$(1), ALFAIGG(IFX)
            INPUT #1, PSIat(ISTH, 1), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(1), MRfound(1)
            INPUT #1, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(1), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(1)
            INPUT #2, IFX, H1REV(2), HrecExist(2), Idade(2), SN(2), QImed(2), Nano(2), IRI0(IFX), Nacum(IFX), Revest$(2), ALFAIGG(IFX)
            INPUT #2, PSIat(ISTH, 2), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(2), MRfound(2)
            INPUT #2, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(2), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(2)
            QImed(1) = QIFx1(IFaixa)
            QImed(2) = QIFx2(IFaixa)
            Executa$ = "S"
            IF Revest$(2) = "CCP" THEN Executa$ = "N"
            IF Nano(2) <= 0 THEN Executa$ = "N"
            IF D0(2) <= 0 THEN Executa$ = "N"
            IF QImed(1) <= 0 THEN Executa$ = "N"
            IF QImed(2) <= 0 THEN Executa$ = "N"
            DeltaQIobs = QImed(2) - QImed(1)
            IF DeltaQIobs <= 0 THEN Executa$ = "N"
            IF Idade(2) <= 1 THEN Executa$ = "N"
            IF HrecExist(2) < 2.5 THEN Executa$ = "N"
            IF Executa$ = "S" THEN
                IF DeltaQIobs > 0 THEN
                    Fc = FcMin
                    ErroMin = 100000.0
                    FOR I = 1 TO NPassos
                        GOSUB 100
                        Erro = 100 * ABS(DeltaQI - DeltaQIobs) / DeltaQIobs
                        IF Erro < ErroMin THEN
                            FcOt = Fc
                            ErroMin = Erro
                        END IF
                        Fc = Fc + Passo
                    NEXT I
                    IF ErroMin < 5 THEN WRITE #15, Rodov$(IRodov), STH, kmi, kmf, IFaixa, FcOt, ErroMin, HrecExist(2), QImed(1), QImed(2), Nano(2), Idade(2)
                END IF
            END IF
        NEXT IFaixa
    NEXT ISUB
    CLOSE #3, #4
NEXT IRodov
INPUT #1, PSImed(0), Npsi(0), VRmed(0)
INPUT #1, AreaTotal, NUnidAnalise
INPUT #2, PSImed(0), Npsi(0), VRmed(0)
INPUT #2, AreaTotal, NUnidAnalise
CLOSE #1, #2
CLOSE #15

OPEN "DOS.DAT" FOR OUTPUT AS #1
WRITE #1, 1
CLOSE #1

SYSTEM

' - - - - - - - - - - - - - - - - - - -
100 ' -                                   -
' - Modelo de Previsao de Desempenho  -
' -        (saida: DeltaQI)           -
' - - - - - - - - - - - - - - - - - - -
' Condicoes Iniciais Fixadas
PCR4 = 10
QI0 = QImed(1) - DeltaQIobs
IF QI0 < 10 THEN QI0 = 10
PSI0 = 5 * EXP(-QI0 / 71.5)
HR = HrecExist(2) / Fc
TYcr2A = 2.54 * EXP(.0157 * HR * 10 - .0141 * PCR4)
TYcr2B = 10.8 * EXP(-1.21 * (D0(2) / 100) - 1.02 * (Nano(2) / 1000000!) * (D0(2) / 100))
T0cr2 = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
SNrecap = .44 * HR / 2.54
MR = MRfound(2) / .0703
BETA = .4 + (1094 / ((SNrecap + 1) ^ 5.19))
DPSI = PSI0 - 2.5
W18 = (((SNrecap + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
PSIold = 5 * EXP(-QImed(1) / 71.5)
PSIatual = PSIold
DeltaT = 0.1
Age = Idade(2)
Tempo = Ano(1)
WHILE Tempo < Ano(2)
    IF Age <= T0cr2 THEN
        ALFA = 0.05 * ALFAA
    ELSE
        ALFA = 0.1 * ALFAA
    END IF
    DeltaN = Nano(2) * DeltaT / 1000000
    DeltaPSI = ALFA * DeltaN * PSIatual * LOG(PSIatual / 5)
    PSIatual = PSIatual + DeltaPSI
    IF PSIatual < 0.1 THEN PSIatual = 0.1
    Age = Age + DeltaT
    Tempo = Tempo + DeltaT
WEND
DeltaQI = 71.5 * LOG(5 / PSIatual) - QImed(1)
RETURN
