CLS

PRINT
PRINT "        ANALISE DAS BACIAS DE DEFLEXOES       "
PRINT

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

OPEN "ARQUIVO.DAT" FOR INPUT AS #1
INPUT #1, TRECHO$
INPUT #1, h1cm
INPUT #1, HTcm
CLOSE #1
ARQDADOS$ = DadosAnoBase$ + "Deflex\" + TRECHO$ + ".CSV"
ARQSAIDA$ = CALC$ + TRECHO$ + ".CSV"

NP = 63: NDIV = 10000
DIM r(NP), D(NP), Leit(NP), E2(NDIV), DEFLEX(NP), DIST(NP), X(7), Df(7)
DIM S(50), T(50), A(50, 50)

E2MIN = 100: E2MAX = 10000
PASSO = (E2MAX - E2MIN) / (NDIV - 1)
E2(1) = E2MIN
FOR II = 2 TO NDIV
    E2(II) = E2(II - 1) + PASSO
NEXT II

PI# = 3.141592654#
Tref = 21.1

OPEN ARQDADOS$ FOR INPUT AS #1
LINE INPUT #1, LINHA$

OPEN ARQSAIDA$ FOR OUTPUT AS #2
WRITE #2, "km", "Df1", "SN", "MRsl"

WHILE NOT EOF(1)

    INPUT #1, km, Cargakgf
    NBAC = 0
    FOR I = 1 TO 7
        INPUT #1, Df(I)
        IF Df(I) > 0 THEN NBAC = NBAC + 1
    NEXT I
    INPUT #1, Tar, Tsup
    FOR I = 1 TO 7
        INPUT #1, X(I)
    NEXT I
    INPUT #1, Dplaca, DAT$, Equipamento$

    ' Modulo de elasticidade do solo de subleito
    RAIO = Dplaca / 2
    AREA = PI# * (RAIO ^ 2)
    PRESSAO = Cargakgf / AREA
    Rc = RAIO + (3 / 2) * HTcm
    MRsl = 0
    ICONT = 0
    FOR I = 1 TO 7
        IF X(I) >= Rc THEN
            MR = (700 / 774) * (1 - (.4 ^ 2)) * PRESSAO * (RAIO ^ 2) / (X(I) * (Df(I) / 1000))
            ICONT = ICONT + 1
            MRsl = MRsl + MR
        END IF
    NEXT I
    IF ICONT > 0 THEN
        MRsl = MRsl / ICONT
    ELSE
        MRsl = MR
    END IF

    ' Parametros da mistura obtidos atraves de correlacoes
    PNT = 55
    PAC = 5!
    TRB = 153.19 * (PNT ^ -.2596)
    VB = PAC / .434
    VISC = 29508.2 * (PNT ^ -2.1939)
    PTS = ((LOG(800) / LOG(10)) - (LOG(PNT) / LOG(10))) / (TRB - 25)

    ' Modulo dinamico em compressao (T.A.I.)
    DELTATC = 30 / 1000
    TMIX = 1.8 * Tsup + 32
    GOSUB 1000
    E1 = EACKGF
    IF E1 < 15000 THEN E1 = 15000

    TMIX = 1.8 * Tref + 32
    GOSUB 1000
    E1ref = EACKGF

    ' Calculo de E2 para reproduzir a deflexao de campo
    ERROMIN = 1E+30
    EE1 = E1
    Q = 4100
    PRESSAO = 5.6
    RAIO = (Q / (PRESSAO * PI#)) ^ .5
    HH1 = h1cm
    FOR II = 1 TO NDIV
        EE2 = E2(II)
        GOSUB 200
        ERRO = 100 * ABS(DIEST - Df(1)) / Df(1)
        IF ERRO < ERROMIN THEN
            ERROMIN = ERRO
            E2OT = EE2
        END IF
    NEXT II

    ' Calculo da deflexao na temperatura e na carga de referencia
    EE1 = E1ref
    EE2 = E2OT
    Q = 4100
    PRESSAO = 5.6
    HH1 = h1cm
    GOSUB 200
    IF Df(1) > 15 THEN
        Df1Ref = DIEST
    ELSE
        IF Tsup > Tref + 12 THEN
            Df1Ref = (DIEST + Df(1)) / 2
        ELSE
            Df1Ref = Df(1)
        END IF
    END IF

    ' Calculo do Numero Estrutural pela formula de Rohde (1994)
    ' Deflexao a 1.5HT da carga sob 40 kN
    r = 1.5 * HTcm
    IF (r > X(4) AND r < X(5)) THEN
        i2 = 5
    ELSE
        IF (r > X(5) AND r < X(6)) THEN
            i2 = 6
        ELSE
            i2 = 7
        END IF
    END IF
    i1 = i2 - 1
    X2 = X(i2)
    X1 = X(i1)
    Y1 = Df(i1)
    Y2 = Df(i2)
    Dif = X2 - X1
    Dsl = ((X2 * Y1 - X1 * Y2) / Dif) + ((Y2 - Y1) / Dif) * r
    Dsl = Dsl * (4100! / Cargakgf)
    SIP = 10 * (Df1Ref - Dsl)
    HP = 10 * HTcm
    K1 = .4728
    K2 = -.481
    K3 = .7581
    IF SIP > 0! THEN
        SN = K1 * (SIP ^ K2) * (HP ^ K3)
    ELSE
        SN = -1
    END IF

    WRITE #2, km, Df1Ref, SN, MRsl

WEND
CLOSE #1, #2

SYSTEM

1000 ' * * * * * * * * * * * * * * * * * * * * * * * *
' *    MODULO DINAMICO EM COMPRESSAO (T.A.I.)   *
' *                 (Subrotina)                 *
' *  Dados: DELTATC, TMIX, P200, VV, PAC, VISC  *
' * * * * * * * * * * * * * * * * * * * * * * * *
FREQ = 1 / DELTATC
W = 2 * PI# * FREQ
TF = TMIX
TT = TF ^ (1.3 + .49825 * (LOG(FREQ) / LOG(10)))
EAC = 5.553833 + .028829 * (P200 / (FREQ ^ .17033)) - .03476 * VV
EAC = EAC + .070377 * VISC + .000005 * TT * (PAC ^ .5)
EAC = EAC - .00189 * (TT * (PAC ^ .5) / (FREQ ^ 1.1))
EAC = EAC + .931757 * (1 / (FREQ ^ .02774))
EACPSI = 10 ^ EAC
EACKSI = EACPSI / 1000
EACKGF = EACPSI * .0703
RETURN

200 ' - - - - - - - - - - - - - - - - - - - -
' -  Formula do Guia da AASHTO (1993)   -
' -             (Subrotina)             -
' - - - - - - - - - - - - - - - - - - - -
MR = EE2
D = HH1
EP = EE1
BLOC1 = (1 + ((D / RAIO) * ((EP / MR) ^ (1 / 3))) ^ 2) ^ .5
BLOC2 = 1 - (1 / ((1 + ((D / RAIO) ^ 2)) ^ .5))
D0B = 1.5 * PRESSAO * RAIO * ((1 / (MR * BLOC1)) + (BLOC2 / EP))
DIEST = 1000 * D0B
RETURN

