CLS

PRINT
PRINT "    REFORCO EM FUNCAO DA VIDA RESTANTE DOS PAVIMENTOS   "
PRINT

PI# = 3.141592654#
' Funcao densidade de probabilidade para Fc
DIM Nc(4), NQI(4), NS(4)
Nc(1) = 50: NS(1) = 0: NQI(1) = 0
Nc(2) = 85: NS(2) = 1.04: NQI(2) = 1.08
Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.6038
Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.35

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DADOSANOBASE$
CLOSE #1

OPEN "SISTEMA.DAT" FOR INPUT AS #1
INPUT #1, SGP$
CLOSE #1

OPEN "DISCO.DAT" FOR INPUT AS #1
INPUT #1, DISCO$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DADOSANOBASE$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodovia$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodovia$(I)
NEXT I
CLOSE #1

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Criterios complementares para as arvores de decisao
ARQUIVO$ = CALC$ + "CRITERIO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TRcrit
INPUT #1, QIcrit
INPUT #1, ATRcrit
INPUT #1, ATRITOcrit
INPUT #1, IGGcrit
CLOSE #1

ARQUIVO$ = CALC$ + "TipoLev.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TipoLev$
CLOSE #1

ARQ$ = CALC$ + "REF.DAT"
OPEN ARQ$ FOR INPUT AS #1
INPUT #1, TRECHO$
INPUT #1, Faixa
INPUT #1, PP
INPUT #1, Nconf
INPUT #1, TAXA
INPUT #1, PSIt
INPUT #1, GrTraf$
INPUT #1, RestrGreide$
CLOSE #1

SELECT CASE Faixa
    CASE 1: Faixa$ = "1"
    CASE 2: Faixa$ = "2"
    CASE 3: Faixa$ = "3"
    CASE 4: Faixa$ = "4"
    CASE ELSE
        PRINT "ERRO"
END SELECT

ARQUIVO$ = CALC$ + "RefVR" + TRECHO$ + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #2
WRITE #2, "STH", "km", "HR (cm)", "Tipo"

' Analisa cada bacia do FWD

ARQUIVO$ = CALC$ + "VR" + TRECHO$ + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
WHILE NOT EOF(1)

    INPUT #1, Subtrecho, km, VR, DF0, EpOt, Eslot, SN, SNC, QIa, VRqi, RDatual, VRatr, TR23, VRtr, IGGatual, VRigg, QI6, IGG6, ATR6, RDS6, TR6
    PRINT km

    Medida$ = ""
    IF VR >= 3 THEN

        HR = 0

    ELSE

        ' Aplica os Modelos para Previsao de Desempenho para o calculo da espessura da camada de reforco em CBUQ
 
        ' Modelo do HDM-III para irregularidade
        ' IRI = (IRI0 + 725 * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
        FcIRImed = 1: SigmaIRI = .48
        IF Nconf <= Nc(2) THEN
            I1 = 1: I2 = 2
        ELSE
            IF Nconf <= Nc(3) THEN
                I1 = 2: I2 = 3
            ELSE
                I1 = 3: I2 = 4
            END IF
        END IF
        Ngauss = ((Nc(I2) * NS(I1) - Nc(I1) * NS(I2)) + Nconf * (NS(I2) - NS(I1))) / (Nc(I2) - Nc(I1))
        Niri = ((Nc(I2) * NQI(I1) - Nc(I1) * NQI(I2)) + Nconf * (NQI(I2) - NQI(I1))) / (Nc(I2) - Nc(I1))
        FcIRI = FcIRImed + Niri * SigmaIRI
        GOSUB 300
        NP = 0
        FOR I = 1 TO PP
            Nano = NanoAASHTO * ((1 + (TAXA / 100)) ^ I)
            NP = NP + Nano
        NEXT I
        NE4 = NP / 1.0E6
        ' Recapeamento simples necessario
        HR = 0.1
        hc = 0
        QIf = QIcrit
        WHILE QIf >= QIcrit
            GOSUB 6900
            IRI0 = QIest / 13
            SNCef = SNC + (0.44 * HR - 0.30 * hc) / 2.54
            IRIf = (IRI0 + FcIRI * 725 * ((1 + SNCef) ^ -4.99) * NE4) * EXP(.0153 * PP)
            QIf = 13 * IRIf
            HR = HR + 0.1
            hc = 0
        WEND
        IF HR <= 1 THEN
            Medida$ = "Micro"
            HR = 1
        ELSE
            IF HR > 10 THEN
                Medida$ = "REC"
                HR = 0
            ELSE
                Medida$ = "FR+CBUQ"
                ' Recapeamento em CBUQ apos fresagem
                HR = 3
                hc = HR
                QIf = QIcrit
                WHILE QIf >= QIcrit
                    GOSUB 6900
                    IRI0 = QIest / 13
                    SNCef = SNC + (0.44 * HR - 0.30 * hc) / 2.54
                    IRIf = (IRI0 + FcIRI * 725 * ((1 + SNCef) ^ -4.99) * NE4) * EXP(.0153 * PP)
                    QIf = 13 * IRIf
                    HR = HR + 0.1
                    hc = HR
                WEND
                IF HR > 10 THEN
                    Medida$ = "REC"
                    HR = 0
                END IF
            END IF
        END IF

    END IF
    WRITE #2, Subtrecho, km, INT(10 * HR) / 10, Medida$

WEND
CLOSE #1, #2

SYSTEM

300 '
' - - - - - - - - - - - - - - - - - - -
' -  Leitura da Base de Dados do SGP  -
' - - - - - - - - - - - - - - - - - - -
Trincado$ = "N"
ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #5
ISTH = 0
AgePav = -1
FOR IRodov = 1 TO NRODOV
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #5, Subtr, NFX, KM1, KM2, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFX
            INPUT #5, IFX, h1, HrecExist, Idade, SN, QImed, Nano, IRI0, Nacum, REVEST$, ALFAIGG
            INPUT #5, PSIat, Aream2, VidaRes, VDMUni, PSInovo, Heff, IRec, ICalib, D0, MRfound
            INPUT #5, ALPHA0, ALPHA, ALPHA2, AreaAcost, PSIacost, DegrauAcost, T0, TR23, CBRsl, CamBase$, VDMc, ATRmed
            IF (Subtr = Subtrecho AND IFX = Faixa) THEN
                H1REV = h1
                Rev$ = REVEST$
                AgePav = Idade
                NanoAASHTO = Nano
            END IF
        NEXT IFaixa
    NEXT ISUB
NEXT IRodov
INPUT #5, PSImed(0), Npsi(0), VRmed(0)
INPUT #5, AreaTotal, NUnidAnalise
CLOSE #5
RETURN

6900 '
' - - - - - - - - - - - - - - - - - - - -
' -   Irregularidade apos Recapeamento  -
' -        (Subrotina do HDM-III)       -
' -   Dados: HR, hc, QIa                -
' -   Saida: QIest                      -
' - - - - - - - - - - - - - - - - - - - -
QIest = QIa
IF QIest > 19 THEN
    QIB = 19! + ((QIest - 19!) / (.602 * hc + 1))
ELSE
    QIB = QIest
END IF
H0 = 10 * HR
IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
IF H0 < 40 THEN X = H0 ELSE X = 40
HOV = 3 - ((H0L + X) / 40)
X1 = 19.42 - .78 * QIBL - .068 * H0
IF H0 > 20 THEN Y = H0 - 20 ELSE Y = 0
X2 = -19.5 - .008 * QIBL * Y
IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
IF DQI > 0 THEN DQI = 0
QIest = QIB + DQI
RETURN
