CLS

PRINT
PRINT "    PROJETO DE RECAPEAMENTO POR MEIO DE MODELOS EMPIRICOS  "
PRINT

' Condicao terminal do pavimento ao final do periodo de projeto
TRc = 20
QIadm = 35
ATRmax = 7

Dc(1) = 30
Dc(2) = 45
Dc(3) = 65
Nyear(1) = .3
Nyear(2) = 1
Nyear(3) = 3
PCR4(1) = 5: ATRexist(1) = 2
PCR4(2) = 20: ATRexist(2) = 5
PCR4(3) = 50: ATRexist(3) = 10
QI(1) = 20
QI(2) = 35
QI(3) = 50

OPEN "RECAP.CSV" FOR OUTPUT AS #1
WRITE #1, "QI", "Nc(%)", "Dc", "Nano", "TR(%)", "HRcm 5 anos", "HRcm 7 anos", "HRcm 10 anos"

Nc(1) = 50: NS(1) = 0: NQI(1) = 0: NATR(1) = 0: NTR(1) = 0
Nc(2) = 85: NS(2) = 1.04: NQI(2) = 1.08: NATR(2) = 1.1428: NTR(2) = 1.013
Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.6038: NATR(3) = 1.52: NTR(3) = 1.14
Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.35: NATR(4) = 1.99: NTR(4) = 1.348
FcIRImed = 1.883: SigmaIRI = 1.905
FcATRmed = 1.2464: SigmaATR = .8204

FOR IQI = 1 TO 3

    FOR INC = 1 TO 4

        FcIRI = FcIRImed + NQI(INC) * SigmaIRI
        FcATR = FcATRmed + NATR(INC) * SigmaATR

        FOR IDC = 1 TO 3

            SNCexist = ((Dc(IDC) / 100) / 6.5) ^ (-1 / 1.6)

            FOR IN = 1 TO 3

                FOR ITR = 1 TO 3

                    HR5 = -1: ErroMin5 = 1E+30
                    HR7 = -1: ErroMin7 = 1E+30
                    HR10 = -1: ErroMin10 = 1E+30
                    HR = 2!
                    FOR I = 1 TO 200
                        D0 = Dc(IDC) * 10 ^ (-HR / 40)
                        SNC = SNCexist + .44 * (HR / 2.54)
                        TYcr2A = 2.54 * EXP(.0157 * HR * 10 - .0141 * PCR4(ITR))
                        TYcr2B = 10.8 * EXP(-1.21 * (D0 / 100) - 1.02 * Nyear(IN) * (D0 / 100))
                        TYcr2 = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
                        IF HR < 5 THEN
                            FcMed = .31566 * (HR ^ 1.15146)
                            Sigma = (.7242 / 2) * FcMed
                            Fc = FcMed - NTR(INC) * Sigma
                        ELSE
                            FcMed = 2
                            Sigma = .7242
                            Fc = FcMed - NTR(INC) * Sigma
                        END IF
                        TYcr2 = Fc * TYcr2
                        V1 = 5
                        V2 = 7.6
                        dTRdt = PCR4(ITR) / TYcr2
                        IF dTRdt < V1 THEN dTRdt = V1
                        IF TRc > 30 THEN dTRdt = (V2 / V1) * dTRdt
                        DeltaT = TRc / dTRdt
                        VsTrinc = DeltaT + TYcr2

                        ' Modelo para irregularidade
                        ' HDM: IRI = (IRI0 + 725 * Fc * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
                        HC = 0
                        QIest = QI(IQI)
                        HRec = HR
                        GOSUB 6900
                        QI0 = QIest
                        VsQI = 0
                        QIt = QI0
                        DeltaT = .1
                        WHILE QIt < QIadm
                            VsQI = VsQI + DeltaT
                            DeltaIRI = (.0153 * (QIt / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear(IN) * EXP(.0153 * VsQI)) * DeltaT
                            QIt = QIt + DeltaIRI * 13
                        WEND
                        IF VsQI < VsTrinc THEN Vs = VsQI ELSE Vs = VsTrinc

                        ' Modelo para afundamentos em trilha de roda
                        MMP = .123: RH = 1
                        VsATR = 0: DeltaT = .5
                        ATR = .15 * ATRexist(ITR)
                        IF HR > 7.5 THEN ATR = .15 * ATR
                        WHILE (ATR < ATRmax AND VsATR < Vs)
                            VsATR = VsATR + DeltaT
                            Nacum = Nyear(IN) * 1000000! * VsATR
                            IF VsATR <= TYcr2 THEN
                                CRX = 0
                            ELSE
                                IF VsATR < VsTrinc THEN
                                    CRX = TRc / 2
                                ELSE
                                    CRX = TRc
                                END IF
                            END IF
                            ERM = .0902 + .0384 * (D0 / 100) - .009 * RH + .00158 * MMP * CRX
                            ATRref = FcATR * (VsATR ^ .166) * (SNC ^ -.502) * (Nacum ^ ERM)
                        WEND
                        IF VsATR < Vs THEN Vs = VsATR

                        ERRO5 = 100 * ABS(Vs - 5) / 5
                        IF ERRO5 < ErroMin5 THEN
                            IF Vs >= 5 THEN
                                ErroMin5 = ERRO5
                                HR5 = HR
                            END IF
                        END IF
                        ERRO7 = 100 * ABS(Vs - 7) / 7
                        IF ERRO7 < ErroMin7 THEN
                            IF Vs >= 7 THEN
                                ErroMin7 = ERRO7
                                HR7 = HR
                            END IF
                        END IF
                        ERRO10 = 100 * ABS(Vs - 10) / 10
                        IF ERRO10 < ErroMin10 THEN
                            IF Vs >= 10 THEN
                                ErroMin10 = ERRO10
                                HR10 = HR
                            END IF
                        END IF
                        HR = HR + .1
                    NEXT I
                    WRITE #1, QI(IQI), Nc(INC), Dc(IDC), Nyear(IN), PCR4(ITR), INT(10 * HR5) / 10, INT(10 * HR7) / 10, INT(10 * HR10) / 10

                NEXT ITR
            NEXT IN
        NEXT IDC
    NEXT INC
NEXT IQI
CLOSE #1

SYSTEM

6900 ' - - - - - - - - - - - - - - - - - - - -
' -   Irregularidade apos Recapeamento  -
' -        (Subrotina do HDM-III)       -
' -   Dados: HRec, HC, QIest            -
' -   Saida: QIest                      -
' - - - - - - - - - - - - - - - - - - - -
IF QIest > 19 THEN
    QIB = 19! + ((QIest - 19!) / (.602 * HC + 1))
ELSE
    QIB = QIest
END IF
H0 = 10 * HRec
IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
IF H0 < 40 THEN X = H0 ELSE X = 40
HOV = 3 - ((H0L + X) / 40)
X1 = 19.42 - .78 * QIBL - .068 * H0
IF H0 > 20 THEN Y = H0 - 20 ELSE Y = 0
X2 = -19.5 - .008 * QIBL * Y
IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
IF DQI > 0 THEN DQI = 0
QIest = QIB + DQI
RETURN

