CLS

' Funcao densidade de probabilidade para Fc
DIM Nc(4), NQI(4), NS(4)
Nc(1) = 50: NS(1) = 0: NQI(1) = 0
Nc(2) = 85: NS(2) = 1.04: NQI(2) = 1.08
Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.6038
Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.35

OPEN "SISTEMA.DAT" FOR INPUT AS #1
INPUT #1, SGP$
CLOSE #1
SGP$ = UCASE$(SGP$)
SELECT CASE SGP$
    CASE "SGPC\", "SGPL\", "SGPM\", "SGP3\", "SGP4\", "SGP5\", "SGP6\", "SGP7\", "SGP8\", "SGP9\"
    CASE "SGP10", "SGP11", "SGP12", "SGP13", "SGP14", "SGP15", "SGP16", "SGP17", "SGP18"
        SGP$ = SGP$ + "\"
    CASE ELSE
        PRINT "ERRO"
END SELECT

OPEN "DISCO.DAT" FOR INPUT AS #1
INPUT #1, Disco$
CLOSE #1

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4: NPolos = NRODOV
DIM CustoP(NPolos), ConserP(NPolos), UltCamada$(NFaixasMax), SN(NFaixasMax, 100)
DIM REVEST$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax)
DIM HRef(NFaixasMax), Heff(NFaixasMax), VDMUni(NFaixasMax), IRec(NFaixasMax)
DIM FCnovorede(NRODOV), FCrecaprede(NRODOV), FCmicroCA(NRODOV)
DIM FC0novorede(NRODOV), FC0recaprede(NRODOV), FC0microCA(NRODOV)
DIM FC2novorede(NRODOV), FC2recaprede(NRODOV), FC2microCA(NRODOV)
DIM ICalib(NFaixasMax), Trecho$(NRODOV), D0(NFaixasMax, 100), MRfound(NFaixasMax)
DIM PSIacost(NFaixasMax), DegrauAcost(NFaixasMax), MedidaAcost$(NFaixasMax)
DIM HRAC(NFaixasMax), H2AC(NFaixasMax), CustoAcost(NFaixasMax)
DIM MatCP$(NRODOV), HRCP(NRODOV), CamadaRest$(NRODOV)
DIM A0rest(NRODOV), A1rest(NRODOV), A2rest(NRODOV), SErest(NRODOV)

' Tipos de dados de que a base de dados e' composta:
ARQUIVO$ = DADOS$ + "TIPODADO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, Ndados
DIM DADO$(15)
FOR I = 1 TO Ndados
    INPUT #1, DADO$(I)
NEXT I
CLOSE #1
Ndados = Ndados - 2
NTIPOSDADOS = Ndados
FOR IFX = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "SUP"
NEXT IFX

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Leitura dos codigos numericos que identificam os Subtrechos Homogeneos:
DIM Code(NRODOV, NSTHMAX), NSTHI(NRODOV)
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "CODE" + Rodov$(I) + ".STH"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, NSTHI(I)
    FOR J = 1 TO NSTHI(I)
        INPUT #1, Code(I, J)
    NEXT J
    CLOSE #1
NEXT I

' Arquivo de configuracao do problema a ser analisado:
ARQUIVO$ = CALC$ + "DADOS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
INPUT #1, PPmin
INPUT #1, PPmax
INPUT #1, NPP
INPUT #1, inflacao
CLOSE #1
PP = PPmax

' Fatores de calibracao medios da rede
ARQUIVO$ = CALC$ + "CALIB.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FCnovorede(I), FCrecaprede(I), FCmicroCA(I)
NEXT I
INPUT #1, Rede$, FCnovo, FCrecap, FCmicro
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB0.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FC0novorede(I), FC0recaprede(I), FC0microCA(I)
NEXT I
INPUT #1, Rede$, FC0novo, FC0recap, FC0micro
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB2.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FC2novorede(I), FC2recaprede(I), FC2microCA(I)
NEXT I
INPUT #1, Rede$, FC2novo, FC2recap, FC2micro
CLOSE #1

' Parametros para o Indice de Prioridade (gerados em Estrat1.bas)
ARQUIVO$ = CALC$ + "IP.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, VDMmin, VDMmax
INPUT #1, PSIminRede, PSImaxRede
CLOSE #1
IPFORC0 = 1000

' Modelos de previsao de desempenho para conserva pesada
ARQUIVO$ = CALC$ + "CPtrecho.csv"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR IRodov = 1 TO NRODOV
    INPUT #1, TrechoDescr$, MatCP$(IRodov), HRCP(IRodov)
    ARQUIVO$ = PROGRAMA$ + "MODELOS.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #2
    INPUT #2, NMODELOS
    FOR J = 1 TO NMODELOS
        INPUT #2, CRest$
        INPUT #2, A0
        INPUT #2, A1
        INPUT #2, A2
        INPUT #2, Se
        IF CRest$ = MatCP$(IRodov) THEN
            CamadaRest$(IRodov) = CRest$
            A0rest(IRodov) = A0
            A1rest(IRodov) = A1
            A2rest(IRodov) = A2
            SErest(IRodov) = Se
        END IF
    NEXT J
    CLOSE #2
NEXT IRodov
CLOSE #1

' Percentagem da area que deve receber reparos localizados (CL)
DIM PSIitemCL(15), ARepCL(15)
ARQUIVO$ = CALC$ + "REPAROS.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
NitensCL = 0
WHILE NOT EOF(1)
    NitensCL = NitensCL + 1
    INPUT #1, PSIitemCL(NitensCL), ARepCL(NitensCL)
WEND
CLOSE #1

' Parametros para medir o desempenho das estrategias (Ocorrencias em %) e
' criterio para Priorizacao das Restauracoes sob Restricoes Orcamentarias
ARQUIVO$ = CALC$ + "PARAM.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, PSIref
INPUT #1, PTRAF
INPUT #1, PPSI
INPUT #1, Nconf
CLOSE #1
IF Nconf <= Nc(2) THEN
    I1 = 1: I2 = 2
ELSE
    IF Nconf <= Nc(3) THEN
        I1 = 2: I2 = 3
    ELSE
        I1 = 3: I2 = 4
    END IF
END IF
NpsiMod = ((Nc(I2) * NS(I1) - Nc(I1) * NS(I2)) + Nconf * (NS(I2) - NS(I1))) / (Nc(I2) - Nc(I1))
FcIRImed = 1.883: SigmaIRI = 1.905
Ngauss = ((Nc(I2) * NS(I1) - Nc(I1) * NS(I2)) + Nconf * (NS(I2) - NS(I1))) / (Nc(I2) - Nc(I1))
Niri = ((Nc(I2) * NQI(I1) - Nc(I1) * NQI(I2)) + Nconf * (NQI(I2) - NQI(I1))) / (Nc(I2) - Nc(I1))
FcIRI = FcIRImed + Niri * SigmaIRI

ARQUIVO$ = CALC$ + "NC.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NivelAnalise$
INPUT #1, ZRmpd, S0mpd
CLOSE #1
ArqDados$ = CALC$ + "ESTSTHS0.DAT"
IF NivelAnalise$ = "Projeto" THEN
    ArqDados$ = CALC$ + "EST0.DAT"
    ARQUIVO$ = CALC$ + "Npontos.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #11
END IF

' Criterios complementares para as arvores de decisao
ARQUIVO$ = CALC$ + "CRITERIO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TRcrit
INPUT #1, QIcrit
INPUT #1, ATRcrit
INPUT #1, ATRITOcrit
INPUT #1, UsaModulos$
INPUT #1, IGGcrit
INPUT #1, PSIf
CLOSE #1

' Constantes
NPSITMAX = 11
PI# = 3.141592654#
QREF = 4100

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I
N = NSTH * 4
DIM Npontos(N)

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), VRmed(NPeriodos)
DIM Idade(NFaixasMax), PSIat(NSTH, NFaixasMax), NANO(NFaixasMax), PPrest(NPeriodos)
DIM RestrAnual(NPeriodos), RestrPolo(NPolos, NPeriodos), IPRIOR(NSTH, NFaixasMax)
DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), CustoFaixa(NFaixasMax)
DIM MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax), DIAGS$(NFaixasMax)
DIM PSImedSTH(NSTH), VSMIN(NPP), NPSI(NPeriodos), PSIt(NPSITMAX), NFaixas(NSTH)
DIM IRI0(NFaixasMax), ALPHA(NFaixasMax), CustoPolo(NPolos, NPeriodos), AreaAcost(NSTH, NFaixasMax)
DIM EXECF(NSTH, NFaixasMax), NewRestP(NPolos), CustoCLP(NPolos), Deficit(NPeriodos)
DIM IPMAXPolo(NPolos), STHPRIPolo(NPolos), CostPr(NPolos), CUSTOT(NPeriodos)
   
SELECT CASE MODO
    CASE 0
        MODOANALISE$ = "EVOLUI"
        VSMIN(1) = PP
        ARQ$ = "EVO"
    CASE 5
        MODOANALISE$ = "NECESSIDADES"
        VSMIN(1) = PP
        NPeriodos = 1
        ARQ$ = "NAT"
    CASE ELSE
        PRINT "ERRO"
END SELECT

IPSIT = 1
IPP = 1
  
CLS
PRINT
PRINT "                        * * * * * * * * * * * * * * * "
PRINT "                        *  ANALISA A CONDICAO ATUAL *  "
PRINT "                        * * * * * * * * * * * * * * * "

' Inicializacao de variaveis
FOR I = 0 TO NPeriodos
    NPSI(I) = 0
NEXT I

OPEN ArqDados$ FOR INPUT AS #12
ANO = 0
ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #13

ISTH = 0
ICONT = 0
FOR IRodov = 1 TO NRODOV

    ARQUIVO$ = CALC$ + ARQ$ + "CT" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #15
    WRITE #15, "ANO", "STH", "KMI", "KMF", "Custo", "Custo 1", "Custo 2", "Custo 3", "Custo 4", "Acost."
    CLOSE #15

    ARQUIVO$ = CALC$ + "X" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #15
    WRITE #15, "STH", "KMI", "KMF", "Faixa 1", "HR1_cm", "Faixa 2", "HR2_cm", "Faixa 3", "HR3_cm", "Faixa 4", "HR4_cm"
    CLOSE #15

    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFaixas(ISTH)
            ICONT = ICONT + 1
            IF NivelAnalise$ = "Projeto" THEN INPUT #11, Npontos(ICONT) ELSE Npontos(ICONT) = 1
            FOR II = 1 TO Npontos(ICONT)
                INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX, II), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
                INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX, II), MRfound(IFX)
                INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
            NEXT II
        NEXT IFaixa
        WRITE #13, STH, KMI, KMF
        FOR IFX = 1 TO NFaixas(ISTH)
            JJ = ICONT - NFaixas(ISTH) + 1
            FOR II = 1 TO Npontos(JJ)
                Restaurado$(IFX) = "Nao"
                UltCamada$(IFX) = REVEST$(IFX)
                HRef(IFX) = HrecExist(IFX)
                GOSUB 700
            NEXT II
        NEXT IFX
    NEXT ISUB

NEXT IRodov
           
INPUT #12, PSImed(0), NPSI(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
WRITE #13, PSImed(0), NPSI(0), VRmed(0)
WRITE #13, AreaTotal, NUnidAnalise
CLOSE #12, #13
IF NivelAnalise$ = "Projeto" THEN CLOSE #11

' * * * * * * * * * * * * *
' * Geracao da Estrategia *
' * * * * * * * * * * * * *

TotalArea = 0
NUnid = 0

ARQUIVO$ = CALC$ + ARQ$ + STR$(0) + ".DAT"
OPEN ARQUIVO$ FOR INPUT AS #12

ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #10

ARQUIVO$ = CALC$ + "DIAGS.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #11

ISTH = 0
IJCONT = 0
FOR IRodov = 1 TO NRODOV

    ' Parametros que definem as Arvores de Decisao:
    ARQUIVO$ = CALC$ + "ARV" + Rodov$(IRodov) + ".dat"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, IDScrit
    INPUT #1, PSRcrit
    INPUT #1, HRmin
    INPUT #1, HRmax
    INPUT #1, PSIf
    INPUT #1, DEGRAUadm
    INPUT #1, HCmin
    INPUT #1, VUMin
    INPUT #1, QI0adm
    INPUT #1, HbaseAcost
    INPUT #1, RepPerct
    CLOSE #1

    ' PSI terminal para necessidade de restaurar o pavimento
    NPSIT = 1
    PSIt(1) = PSIf

    ' Estado de Superficie no Ano-Base
    FOR IFX = 1 TO NFaixasMax
        SELECT CASE IFX
            CASE 1: Faixa$ = "1"
            CASE 2: Faixa$ = "2"
            CASE 3: Faixa$ = "3"
            CASE 4: Faixa$ = "4"
            CASE ELSE: PRINT "ERRO"
        END SELECT
        ISUP = Ndados + IFX
        ARQUIVO$ = CALC$ + "SUP" + Rodov$(IRodov) + Faixa$ + ".DAT"
        OPEN ARQUIVO$ FOR INPUT AS #ISUP
        ISUPout = ISUP - 4
        ARQUIVO$ = Disco$ + SGP$ + "Docs\Params\" + "LVC" + Rodov$(IRodov) + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #ISUPout
        LINE INPUT #ISUPout, LINHA$
        LINE INPUT #ISUPout, LINHA$
    NEXT IFX

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        ISTH = ISTH + 1
        ' Inicializacao de parametros a cada ano
        FOR IFaixa = 1 TO NFaixasMax
            MedidaF$(IFaixa) = ""
            Hfres(IFaixa) = 0
            Hrec(IFaixa) = 0
            CustoFaixa(IFaixa) = 0
            MedidaAcost$(IFaixa) = ""
            HRAC(IFaixa) = 0
            H2AC(IFaixa) = 0
            CustoAcost(IFaixa) = 0
        NEXT IFaixa
        PSImedSTH(ISTH) = 0

        INPUT #12, STH, KMI, KMF

        FOR IFaixa = 1 TO NFaixas(ISTH)
            GOSUB 600
            ' Indice de Prioridade
            IPRIOR(ISTH, IFaixa) = 0
        NEXT IFaixa

        ' - - - - - - - - - - - - - - - - - - - - - - -
        ' - Necessidades de Manutencao da Rede no Ano -
        ' - - - - - - - - - - - - - - - - - - - - - - -

        RestSTH$ = "Nao"
        'AplicaCP$ = "Sim"
        FOR IFaixa = 1 TO NFaixasMax

            ISUP = Ndados + IFaixa
            ISUPout = ISUP - 4
            IF IFaixa <= NFaixas(ISTH) THEN

                IJJ = IJCONT - NFaixas(ISTH) + 1
                FOR IJ = 1 TO Npontos(IJJ)

                    ' Durabilidade esperada para a medida especificada como Conserva Pesada
                    NP = 1000000! * EXP((A0rest(IRodov) + A2rest(IRodov) * SN(IFaixa, IJ) - (PSIf + NpsiMod * SErest(IRodov))) / A1rest(IRodov))
                    VSCP = NP / NANO(IFaixa)

                    ' Estado de Superficie no Ano-Base
                    INPUT #ISUP, STH, KMINI, KMFIM, PSR, CR$, BL$, TT$
                    INPUT #ISUP, TL$, TE$, TB$, P$, D$, DS$
                    INPUT #ISUP, ER$, BF$, DC$, R$, ATR$, COR$
                    INPUT #ISUP, EM$, DP$, EL$, PSRACOST, DEGRAUCM, OBS$, ATR

                    INPUT #ISUPout, KMI, KMF, IGGE, ICPF, IES, TR23, TR2, TR3

                    Age = Idade(IFaixa)
                    PSI = PSIat(ISTH, IFaixa)
                    QI = QImed(IFaixa)
                    Nyear = NANO(IFaixa)
                    H1 = H1REV(IFaixa)
                    DC = D0(IFaixa, IJ)
                    IDS = IGG(IFaixa)

                    ' Necessidade de reforco estrutural:
                    VR = VidaRes(IFaixa)
                    IF (Age >= 0 AND Age < 1) THEN PP = VSMIN(IPP) ELSE PP = VSMIN(IPP) - VR
                    IF PP < .5 THEN PP = .5
                    GOSUB 1200
                    HREFORCO(IFaixa) = HRMPD

                    IF Age >= 0 THEN
                        IF PSIat(ISTH, IFaixa) < 0 THEN
                            PSIat(ISTH, IFaixa) = .5
                            PSIacost(IFaixa) = .5
                            PSI = PSIat(ISTH, IFaixa)
                            IDS = 450
                        END IF
                        GOSUB 1000
                    ELSE
                        Medida$ = "CR"
                        HR = 0
                        HC = 0
                    END IF

                    IF HC > 0 THEN
                        RES = HC - INT(HC)
                        IF RES >= .5 THEN INCR = 1 ELSE INCR = 0
                        HC = INT(HC) + INCR
                    END IF
                    IF (HR > 0 AND Medida$ <> "CP") THEN
                        RES = HR - INT(HR)
                        IF RES >= .5 THEN INCR = 1 ELSE INCR = 0
                        HR = INT(HR) + INCR
                    END IF
                    MedidaF$(IFaixa) = Medida$
                    Hfres(IFaixa) = HC
                    Hrec(IFaixa) = HR
                    DIAGS$(IFaixa) = DIAGNOSTICO$

                    'IF (Medida$ = "CR" OR Medida$ = "CL") THEN AplicaCP$ = "Nao"

                    IF (MedidaF$(IFaixa) = "RS" OR MedidaF$(IFaixa) = "MF+RC" OR MedidaF$(IFaixa) = "FR+RC" OR MedidaF$(IFaixa) = "RRV" OR MedidaF$(IFaixa) = "RRP" OR MedidaF$(IFaixa) = "RRT") THEN RestSTH$ = "Sim"

                    ARQUIVO$ = CALC$ + "X" + Rodov$(IRodov) + ".CSV"
                    OPEN ARQUIVO$ FOR APPEND AS #15
                    WRITE #15, STH, KMI, KMF, MedidaF$(1), Hrec(1), MedidaF$(2), Hrec(2), MedidaF$(3), Hrec(3), MedidaF$(4), Hrec(4)
                    CLOSE #15

                NEXT IJ

            ELSE

                LINE INPUT #ISUP, LINHA$
                LINE INPUT #ISUPout, LINHA$

            END IF
         
        NEXT IFaixa

    NEXT ISUB

    FOR IFX = 1 TO NFaixasMax
        ISUP = Ndados + IFX
        ISUPout = ISUP - 4
        CLOSE #ISUP
        CLOSE #ISUPout
    NEXT IFX

NEXT IRodov

INPUT #12, PSImed(0), NPSI(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
CLOSE #4, #10, #11, #12

SYSTEM

600 '
IJCONT = IJCONT + 1
FOR IJ = 1 TO Npontos(IJCONT)
    INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX, IJ), MRfound(IFX)
    INPUT #12, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX, IJ), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), ALFAIGG(IFX), ATRmed(IFX)
    INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX)
NEXT IJ
RETURN

700 '
WRITE #13, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX, II), MRfound(IFX)
WRITE #13, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX, II), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), ALFAIGG(IFX), ATRmed(IFX)
WRITE #13, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX)
RETURN

1000 ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -              Necessidades Atuais de Manutencao              -
' -                         (Subrotina)                         -
' -  Dados: PSI, H1, VR, QI, Age, NYEAR, VSMIN(IPP),            -
' -         Estado de Superficie, Parametros de decisao, HRDP,  -
' -         HRTR, H1TR, H2DP, HRQI, HRMPD                       -
' -  Saida: Medida$, HC, HR, DIAGNOSTICO$, H1NOVO, H2NOVO       -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Medida$ = ""
HC = 0!
DIAGNOSTICO$ = ""
H1NOVO = 0
H2NOVO = 0
' Deciso quanto  categoria de interveno requerida
IF MODO = 5 THEN VRMINrec = PPmin ELSE VRMINrec = .1
IF PSI <= PSIt(IPSIT) THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Deve ser restaurado devido ao baixo Indice de Serventia."
IF ATRmed(IFaixa) > ATRcrit THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Pavimento deve ser restaurado devido aos afundamentos em trilha de roda excessivos."
IF QI > QIcrit THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Pavimento deve ser restaurado devido `a irregularidade elevada."
IF TR23 > TRcrit THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Pavimento deve ser restaurado devido ao trincamento excessivo."
IF IGG(IFaixa) > IGGcrit THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Pavimento deve ser restaurado devido ao IGG em nivel inaceitavel."
IF DIAGNOSTICO$ = "" THEN
    CATEGORIA$ = "CONSERVACAO"
ELSE
    CATEGORIA$ = "RESTAURACAO"
    IF VR < VRMINrec THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Pavimento deve ser restaurado devido `a vida restante insuficiente."
    ' Espessura de recapeamento necessaria
    HR = HRMPD
    IRest = 0
    IF (ATRmed(IFaixa) > ATRcrit OR ATR$ = "A3") THEN
        IF HRDP > HR THEN
            HR = HRDP
            IRest = 1
        END IF
    END IF
    IF HRTR > HR THEN
        HR = HRTR
        IRest = 2
    END IF
    IF HRQI > HR THEN
        HR = HRQI
        IRest = 3
    END IF
    IF HRatr > HR THEN IRest = 4
    SELECT CASE IRest
        CASE 0
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pela perda de serventia."
        CASE 1
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada por deformacoes plasticas."
        CASE 2
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pelo trincamento por fadiga."
        CASE 3
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pela reducao da irregularidade ao valor admissivel pos-restauracao."
        CASE 4
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pela eliminacao dos afundamentos em trilha de roda."
        CASE ELSE
            PRINT "ERRO: codigo invalido!"
    END SELECT
    IF H1 >= 6! THEN
        Fresavel$ = "Sim"
        HCMAX = H1 - 3
    ELSE
        Fresavel$ = "Nao"
    END IF
    IF (PSIacost(IFaixa) >= 3! AND DegrauAcost(IFaixa) <= DEGRAUadm) THEN
        Fresar$ = "Sim"
    ELSE
        Fresar$ = "Nao"
    END IF
    IF (CR$ = "A2" OR CR$ = "A3" OR CR$ = "M3" OR BL$ = "A3" OR TT$ = "A3" OR TL$ = "A3") THEN
        ICRACK = 1
    ELSE
        ICRACK = 0
    END IF
    IF (ATRmed(IFaixa) > 15 OR COR$ = "A3" OR EM$ = "A3" OR DP$ = "A3" OR EL$ = "A3") THEN
        IDP = 1
    ELSE
        IDP = 0
    END IF
    IF HR < HRmin THEN HR = HRmin
END IF


' Detalhamento da Medida$ a ser aplicada
         
IF CATEGORIA$ = "CONSERVACAO" THEN

    IF UltCamada$(IFaixa) = "CCP" THEN

        IF PSR > 4! THEN
            Medida$ = "CR"
            DIAGNOSTICO$ = "Pavimento nao apresenta defeitos severos que requeiram intervencao imediata."
        ELSE
            Medida$ = "CL"
            DIAGNOSTICO$ = "Devem ser executados reparos em areas localizadas onde ha' problemas."
        END IF

    ELSE

        IF VR < VRMINrec THEN
            DIAGNOSTICO$ = DIAGNOSTICO$ + "Pavimento deve ser restaurado devido `a vida restante insuficiente."
            IF VSCP >= VUMin THEN
                Medida$ = "CP"
                HR = HRCP(IRodov)
                HC = 0!
            ELSE
                CATEGORIA$ = "RESTAURACAO"
                DIAGNOSTICO$ = "Vida restante insuficiente justifica aplicacao de Conserva Pesada, mas a medida selecionada para CP nao deve ter durabilidade aceitavel."
            END IF
        ELSE
            IF (D$ = "A3" OR DS$ = "A") THEN
                DIAGNOSTICO$ = "Deve ser aplicada capa selante devido ao desgaste e ou desagregacao superficial."
                IF VSCP >= VUMin THEN
                    Medida$ = "CP"
                    HR = HRCP(IRodov)
                    HC = 0!
                ELSE
                    CATEGORIA$ = "RESTAURACAO"
                    DIAGNOSTICO$ = "Nivel de deterioracao atual justifica aplicacao de Conserva Pesada, em carater corretivo e preventivo, mas a medida selecionada para CP nao deve ter durabilidade aceitavel."
                END IF
            ELSE
                IF TR23 > 10 THEN
                    DIAGNOSTICO$ = "Deve ser aplicada capa selante devido `as trincas existentes."
                    IF VSCP >= VUMin THEN
                        Medida$ = "CP"
                        HR = HRCP(IRodov)
                        HC = 0!
                    ELSE
                        Medida$ = "ST"
                        DIAGNOSTICO$ = "Nivel de deterioracao atual justifica aplicacao de Conserva Pesada, em carater corretivo e preventivo, mas a medida selecionada para CP nao deve ter durabilidade aceitavel."
                    END IF
                ELSE
                    IF (BL$ = "B3" OR CR$ = "B2" OR CR$ = "M2" OR BL$ = "M2" OR TT$ = "B3" OR TT$ = "M3" OR TL$ = "B3" OR TL$ = "M3") THEN
                        DIAGNOSTICO$ = "Deve ser feita selagem das trincas severas existentes."
                        Medida$ = "ST"
                    ELSE
                        IF (DP$ = "B3" OR EL$ = "B3" OR CR$ = "B3" OR P$ = "B3" OR P$ = "B2" OR P$ = "B1") THEN
                            DIAGNOSTICO$ = "Devem ser executados reparos em areas localizadas onde ha' deterioracao severa."
                            Medida$ = "CL"
                        ELSE
                            IF (PSR < 4! OR IDS > 20) THEN
                                DIAGNOSTICO$ = "Devem ser executados reparos em areas localizadas onde ha' deterioracao severa."
                                Medida$ = "CL"
                            ELSE
                                DIAGNOSTICO$ = "Pavimento nao apresenta defeitos severos que requeiram intervencao imediata."
                                Medida$ = "CR"
                            END IF
                        END IF
                    END IF
                END IF
            END IF
        END IF

    END IF

END IF

IF CATEGORIA$ = "RESTAURACAO" THEN

    IF UltCamada$(IFaixa) = "CCP" THEN

        IF PSI < 1.5 THEN
            CATEGORIA$ = "RECONSTRUCAO"
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Pavimento deve ser reconstruido devido `a deterioracao de superficie severa."
            Medida$ = "RRT"
            H1NOVO = H1
            H2NOVO = 15
            HR = H1
            HC = H1NOVO + H2NOVO + 20
        ELSE
            CATEGORIA$ = "RESTAURACAO"
            HRreflex = 10
            IF HRMPD < HRreflex THEN
                HR = HRreflex
                DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pelo trincamento por reflexao."
            ELSE
                HR = HRMPD
                DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pelo modelo de previsao de desempenho."
            END IF
            Medida$ = "MF+RC"
            HC = 0
        END IF

    ELSE

        IF (PSI < PSRcrit AND IDS > IDScrit) THEN

            CATEGORIA$ = "RECONSTRUCAO"
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Pavimento deve ser reconstruido devido `a deterioracao de superficie severa."
            IF Age < 3 THEN
                DIAGNOSTICO$ = DIAGNOSTICO$ + " Causa da deterioracao prematura deve ser deficiencia de natureza construtiva."
            ELSE
                IF Age > 20 THEN
                    DIAGNOSTICO$ = DIAGNOSTICO$ + " A causa deve estar em ter o pavimento permanecido um longo tempo em condicao ruim."
                ELSE
                    IF HRDP > 15! THEN
                        DIAGNOSTICO$ = DIAGNOSTICO$ + " Deve haver deficiencia estrutural em termos de protecao contra deformacoes plasticas."
                    ELSE
                        IF HRTR > 7! THEN
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Deve haver deficiencia estrutural em termos de protecao do revestimento contra trincamento por fadiga."
                        ELSE
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " A causa da deterioracao excessiva deve ser pesquisada."
                        END IF
                    END IF
                END IF
            END IF
            IF (TE$ = "A3" OR DC$ = "A3" OR COR$ = "A3" OR EM$ = "A3") THEN
                IF BF$ = "A3" THEN
                    DIAGNOSTICO$ = DIAGNOSTICO$ + " Ha' problemas no revestimento, e a base foi deteriorada pela entrada de agua atraves das trincas."
                    Medida$ = "RRP"
                    H1NOVO = H1TR
                    H2NOVO = H2DP
                    HR = H1NOVO
                    HC = H1NOVO + H2NOVO
                ELSE
                    DIAGNOSTICO$ = DIAGNOSTICO$ + " Deterioracao deve estar confinada ao revestimento."
                    Medida$ = "RRV"
                    H1NOVO = H1TR
                    HR = H1NOVO
                    HC = H1NOVO
                END IF
            ELSE
                DIAGNOSTICO$ = DIAGNOSTICO$ + " Causa da deterioracao excessiva deve ser pesquisada nas camadas mais profundas do pavimento."
                Medida$ = "RRT"
                H1NOVO = H1TR
                H2NOVO = H2DP
                HR = H1NOVO
                HC = H1NOVO + H2NOVO + 20
            END IF

        ELSE

            CATEGORIA$ = "RESTAURACAO"
            IF IDP = 1 THEN
                IF Fresavel$ = "Sim" THEN
                    Medida$ = "FR+RC"
                    IF HR > HCMAX THEN
                        HC = HCMAX
                        DIAGNOSTICO$ = DIAGNOSTICO$ + " Maxima espessura fresavel nao permite FR+RC sem elevacao de greide."
                    ELSE
                        HC = HR
                        DIAGNOSTICO$ = DIAGNOSTICO$ + " Maxima espessura fresavel permite FR+RC sem elevacao de greide."
                    END IF
                    IF HC < HCmin THEN HC = HCmin
                ELSE
                    Medida$ = "MF+RC"
                    HC = 0
                    DIAGNOSTICO$ = DIAGNOSTICO$ + " Reperfilagem e' recomendavel devido aos afundamentos em trilha de roda. O revestimento existente nao e' fresavel."
                END IF
            ELSE
                IF ICRACK = 1 THEN
                    IF Fresar$ = "Nao" THEN
                        Medida$ = "MF+RC"
                        HC = 0
                        DIAGNOSTICO$ = DIAGNOSTICO$ + " Massa Fina e' recomendavel antes do recapeamento devido ao trincamento excessivo."
                    ELSE
                        IF Fresavel$ = "Sim" THEN
                            Medida$ = "FR+RC"
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Fresagem e' recomendavel devido ao trincamento excessivo do revestimento."
                            IF HR > HCMAX THEN
                                HC = HCMAX
                                DIAGNOSTICO$ = DIAGNOSTICO$ + " Maxima espessura fresavel nao permite FR+RC sem elevacao de greide."
                            ELSE
                                HC = HR
                            END IF
                            IF HC < HCmin THEN HC = HCmin
                        ELSE
                            Medida$ = "MF+RC"
                            HC = 0
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Massa Fina e' recomendavel antes do recapeamento devido ao trincamento excessivo e por nao ser o revestimento fresavel."
                        END IF
                    END IF
                ELSE
                    HC = 0
                    DIAGNOSTICO$ = DIAGNOSTICO$ + " Nao ha' deterioracao severa que inviabilize o recapeamento simples em espessuras delgadas."
                    IF IRest = 4 THEN
                        IF HR = HRmin THEN
                            Medida$ = "RS"
                            IF HR < HRatr THEN HR = HRatr
                        ELSE
                            Medida$ = "MF+RC"
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Reperfilagem foi indicada devido aos afundamentos em trilha de roda."
                        END IF
                    ELSE
                        IF VSCP >= VUMin THEN
                            Medida$ = "CP"
                            HR = HRCP(IRodov)
                            HC = 0!
                        ELSE
                            Medida$ = "RS"
                        END IF
                    END IF
                END IF
            END IF

            IF HR > HRmax THEN
                CATEGORIA$ = "RECONSTRUCAO"
                DIAGNOSTICO$ = DIAGNOSTICO$ + " Pavimento deve ser parcialmente reconstruido devido `a elevada espessura da camada de recapeamento em CBUQ que e' necessaria."
                Medida$ = "RRP"
                H1NOVO = H1TR
                H2NOVO = H2DP
                HR = H1NOVO
                HC = H1NOVO + H2NOVO
            END IF

        END IF

    END IF

END IF

IF (Medida$ = "CR" OR Medida$ = "CL" OR Medida$ = "ST") THEN HR = 0

RETURN

1200 ' - - - - - - - - - - - - - - - - - - - - - - - - -
' -       Necessidades de Reforco Estrutural      -
' -                  (Subrotina)                  -
' -  Dados: H1, HT, NYEAR, PP, DC, QI             -
' -  Saida: HRDP, HRTR, H1TR, H2DP, HRMPD         -
' - - - - - - - - - - - - - - - - - - - - - - - - -
' Espessura de reforco efetiva existente
P = 4100 / (PI# * 30 * 30 / 4)
E = 2 * (1 - .33 * .33) * P * (30 / 2) / (DC / 1000)
MR = E / .0703
A1 = .44
IF VR > 0 THEN
    PERIODO = VR
    GOSUB 6700
    SNP = A1 * .5 / 2.54
    NP = 0
    WHILE NP < NPA
        SNP = SNP + .05
        HRmodel = 2.54 * SNP / A1
        QIest = QI
        HR = HRmodel
        HC = 0
        GOSUB 6900
        IC = 1
        QIx = QIest
        GOSUB 1300
    WEND
    Heff(IFaixa) = HRmodel
ELSE
    Heff(IFaixa) = 0
END IF

' Espessura de reforco em CBUQ requerida pelo modelo de previsao de desempenho
PERIODO = PP
GOSUB 6700
SNP = A1 * .5 / 2.54
NP = 0
WHILE NP < NPA
    SNP = SNP + .05
    HRmodel = 2.54 * SNP / A1
    HR = HRmodel
    HC = 0
    QIest = QI
    GOSUB 6900
    IC = 2
    QIx = QIest
    GOSUB 1300
WEND
HRMPD = HRmodel
IF HRMPD < 0 THEN HRMPD = 0
IF UltCamada$(IFaixa) = "CCP" THEN
    HRreflex = 1.364 * PP
    IF HRreflex > HRMPD THEN HRMPD = HRreflex
END IF

' Revestimento requerido pelo Metodo do DNER
NPUSACE = 3 * NPA
H1TR = 4.4608 + 2.131 * LOG(NPUSACE)
IF H1TR < HRmin THEN H1TR = HRmin
HRTR = H1TR - H1
IF HRTR < 0 THEN HRTR = 0
' Camada de Base pelo modelo de previsao de desempenho
SNP = .5
NP = 0
WHILE NP < NPA
    SNP = SNP + .05
    IC = 3
    QIx = 15
    GOSUB 1300
WEND
H2DP = (2.54 * SNP - .44 * H1TR) / .14
IF H2DP < 12 THEN H2DP = 12

' Espessura de recapeamento requerida para eliminar ATR
ATRadm = 1
IF ATRmed(IFaixa) > ATRadm THEN
    Nrecaps = LOG(ATRadm / ATRmed(IFaixa)) / LOG(.15)
    IF Nrecaps < 1 THEN
        NR = 1
    ELSE
        NR = Nrecaps - INT(Nrecaps)
        IF NR > .2 THEN NR = INT(Nrecaps) + 1 ELSE NR = INT(Nrecaps)
    END IF
ELSE
    NR = 0
END IF
HRatr = NR * HRmin

RETURN

1300 '
PSIQI = 5 * EXP(-QIx / 71.5)
PSR = 5
PSI0 = (PSIQI + PSR) / 2
IF PSI0 > 4.95 THEN PSI0 = 4.95
DPSI = PSI0 - 2.5
IF DPSI > 0 THEN
    BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
    W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
    W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
    ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
    IF IC = 3 THEN
        LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
        SNC = SNP + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
        TYcr2 = 4.21 * EXP(.139 * SNC - 17.1 * ((NANO(IFaixa) / 1000000!) / (SNC ^ 2)))
        FC0 = FC0novo
    ELSE
        Hrec = 2.54 * SNP / .44
        PCR4 = 5
        TYcr2A = 2.54 * EXP(.0157 * Hrec * 10 - .0141 * PCR4)
        TYcr2B = 10.8 * EXP(-1.21 * (DC / 100) - 1.02 * (NANO(IFaixa) / 1000000!) * (DC / 100))
        TYcr2 = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
        IF IC = 1 THEN FC0 = ALPHA0(IFaixa) ELSE FC0 = FC0recap
    END IF
    Nf = TYcr2 * FC0 * NANO(IFaixa) / 1000000!
    PSIx = PSI0
    DeltaT = .1
    DeltaN = DeltaT * NANO(IFaixa) / 1000000!
    NP = 0
    WHILE (PSIx > PSIf AND NP < 500)
        NP = NP + DeltaN
        SELECT CASE IC
            CASE 1
                IF Restaurado$(IFaixa) = "Sim" THEN
                    IF NP < Nf THEN
                        FC = FCrecap
                    ELSE
                        FC = FC2recap
                    END IF
                ELSE
                    IF IRec(IFaixa) = 1 THEN
                        IF ICalib(IFaixa) = 1 THEN
                            IF NP < Nf THEN
                                FC = ALPHA(IFaixa)
                            ELSE
                                FC = ALPHA2(IFaixa)
                            END IF
                        ELSE
                            IF NP < Nf THEN
                                FC = FCrecaprede(IRodov)
                            ELSE
                                FC = FC2recaprede(IRodov)
                            END IF
                        END IF
                    ELSE
                        IF NP < Nf THEN
                            FC = FCrecaprede(IRodov)
                        ELSE
                            FC = FC2recaprede(IRodov)
                        END IF
                    END IF
                END IF
            CASE 2
                IF NP < Nf THEN
                    FC = FCrecap
                ELSE
                    FC = FC2recap
                END IF
            CASE 3
                IF NP < Nf THEN
                    FC = FCnovo
                ELSE
                    FC = FC2novo
                END IF
            CASE ELSE
                PRINT "ERRO"
        END SELECT
        ALFA = ALFAA * FC
        DeltaPSI = ALFA * DeltaN * PSIx * LOG(PSIx / 5)
        VRmax = 64.43 * (5 ^ -.76) * ((HRmodel / 2.54) ^ .37)
        VRmin = 64.43 * (25 ^ -.76) * ((HRmodel / 2.54) ^ .37)
        GOSUB 6600
        IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
        IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
        PSIx = PSIx + DeltaPSI
    WEND
END IF
RETURN

3050 ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -      Evolucao da Condicao do Pavimento apos um Ano    -
' -                      (Subrotina)                      -
' -  Dados: H1REV, SN, Nacum, CBRSL, PSI, IRI0(IFaixa),   -
' -         ALPHA(IFaixa), Nano, QImed, HRef(IFaixa),     -
' -         IRec(IFaixa), ATRmed, TR23                    -
' -  Saida: PSI, QImed, IGG, TR23, ATRmed                 -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
TRmin = 10
DeltaT = .1
Nyear = NANO(IFaixa) / 1000000!
DeltaN = DeltaT * Nyear
PT = 2.5
DPSI = PSInovo(IFaixa) - PT
NE4 = Nacum(IFaixa) / 1000000!
Nac = Nacum(IFaixa)
TTIME = Idade(IFaixa)
IF PSI <= 4.5 THEN
    IGG(IFaixa) = ALFAIGG(IFaixa) * ((((4.5 / PSI) - 1) / .007635) ^ (1 / 1.065))
    IF IGG(IFaixa) > 500 THEN IGG(IFaixa) = 500
ELSE
    IGG(IFaixa) = 0
END IF
IF (Idade(IFaixa) > 20 AND ATRmed(IFaixa) > 12) THEN COMP = .7 ELSE COMP = 1
LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
SNC = SN(IFaixa, IJ) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
PSR = 2 * PSI - PSIQI
FOR II = 1 TO 10
    ' Evolucao do PSI
    Nac = Idade(IFaixa) * NANO(IFaixa)
    Nf = T0(IFaixa) * ALPHA0(IFaixa) * NANO(IFaixa)
    IF TR23(IFaixa) < TRmin THEN
        ALFA = ALPHA(IFaixa)
    ELSE
        ALFA = ALPHA2(IFaixa)
    END IF
    IF IRec(IFaixa) = 0 THEN
        MR = 100 * CBRSL(IFaixa) / .0703
        VRmax = 25
        VRmin = 5
        BETA = .4 + (1094 / ((SN(IFaixa, IJ) + 1) ^ 5.19))
        W18# = (((SN(IFaixa, IJ) + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
        W18# = 10 ^ (-ZRmpd * S0mpd) * W18# * ((MR / 3000) ^ 2.32) / 1000000!
        ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo(IFaixa) / 5))
        DeltaPSI = ALFA * ALFAA * DeltaN * PSI * LOG(PSI / 5)
    ELSE
        IF UltCamada$(IFaixa) = "CBUQ" THEN
            VRmax = 64.43 * (5 ^ -.76) * ((HrecExist(IFaixa) / 2.54) ^ .37)
            VRmin = 64.43 * (25 ^ -.76) * ((HrecExist(IFaixa) / 2.54) ^ .37)
        ELSE
            VRmax = 8
            VRmin = 2
        END IF
        SNrecap = .44 * HRef(IFaixa) / 2.54
        MR = MRfound(IFaixa) / .0703
        BETA = .4 + (1094 / ((SNrecap + 1) ^ 5.19))
        W18# = (((SNrecap + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
        W18# = 10 ^ (-ZRmpd * S0mpd) * W18# * ((MR / 3000) ^ 2.32) / 1000000!
        ALFAA = (1 / W18#) * LOG(LOG(2.5 / 5) / LOG(PSInovo(IFaixa) / 5))
        DeltaPSI = ALFA * ALFAA * DeltaN * PSI * LOG(PSI / 5)
    END IF
    GOSUB 6600
    GOSUB 6800
    PSI = PSI + DeltaPSI
    IF PSI < .5 THEN PSI = .5
    ' Modelo do HDM-III para irregularidade
    NE4 = NE4 + DeltaT * Nyear
    TTIME = TTIME + DeltaT
    'IRI = (IRI0 + 725 * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
    DeltaIRI = (.0153 * (QImed(IFaixa) / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear * EXP(.0153 * TTIME)) * DeltaT
    QImed(IFaixa) = QImed(IFaixa) + 13 * DeltaIRI
    ' Evolucao do IGG e do PSR
    PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
    PSRat = 2 * PSI - PSIQI
    DeltaPSR = PSRat - PSR
    DeltaIGG = DeltaPSR * (-61.844 - IGG) / (.616 + PSR)
    IGG(IFaixa) = IGG(IFaixa) + DeltaIGG
    PSR = PSRat
    Nac = Nac + DeltaT * NANO(IFaixa)
    TR = TR23(IFaixa)
    ATR = ATRmed(IFaixa)
    GOSUB 3100
    TR23(IFaixa) = TR
    ATRmed(IFaixa) = ATR
NEXT II
RETURN

3100 '
' Evolucao do trincamento severo
IF IRec(IFaixa) = 0 THEN
    RH = 0
    FcATRmed = 1.3492: SigmaATR = .5612
    SELECT CASE CamBase$(IFaixa)
        CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP"
            V1 = 8.7: V2 = 12.5
        CASE ELSE
            V1 = 6.3: V2 = 8.7
    END SELECT
ELSE
    RH = 1
    IF UltCamada$(IFaixa) = "CBUQ" THEN
        V1 = 5: V2 = 7.6
        FcATRmed = 1.2464: SigmaATR = .8204
    ELSE
        V1 = 5 / T0(IFaixa)
        IF V1 < 5 THEN V1 = 5
        V2 = (31 / 10.2) * V1
        FcATRmed = 1.8168: SigmaATR = .8717
    END IF
END IF
IF TR > 0 THEN
    IF TR > 30 THEN dTRdt = V2 ELSE dTRdt = V1
    TR = TR + dTRdt * DeltaT
ELSE
    dTRdt = V1
    IF Nac > Nf THEN TR = TR + dTRdt * DeltaT
END IF
IF TR > 100 THEN TR = 100
' Evolucao dos afundamentos em trilha de roda
MMP = .123
FcATR = FcATRmed + Ngauss * SigmaATR
ERM = .0902 + .0384 * (D0(IFaixa, IJ) / 100) - .009 * RH + .00158 * MMP * TR
dATR = (.166 * FcATR * (COMP ^ -2.3) * (TTIME ^ (.166 - 1)) * (SNC ^ -.502) * (Nac ^ ERM) + ERM * ATR * (Nyear / NE4)) * DeltaT
ATR = ATR + dATR
RETURN

6600 ' - - - - - - - - - - - -
' -  Subrotina Auxiliar -
' - - - - - - - - - - - -
dPSIdtmin = 2! / VRmax
dPSIdtmax = 2! / VRmin
DPSImin = dPSIdtmin * DeltaT
DPSImax = dPSIdtmax * DeltaT
RETURN

6800 ' - - - - - - - - - - - -
' -  Subrotina Auxiliar -
' - - - - - - - - - - - -
IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
RETURN

6700 ' - - - - - - - - - - - - -
' -   Trafego de Projeto  -
' -      (Subrotina)      -
' - - - - - - - - - - - - -
NPA = 0
PER = INT(PERIODO)
FOR IAA = 1 TO PER
    NPA = NPA + (FatorTraf ^ IAA)
NEXT IAA
NPA = NPA + (FatorTraf ^ (PERIODO - PER))
NPA = NPA * Nyear / 1000000!
RETURN

6900 ' - - - - - - - - - - - - - - - - - - - -
' -   Irregularidade apos Recapeamento  -
' -        (Subrotina do HDM-III)       -
' -   Dados: HR, HC, QIest, QI0adm      -
' -   Saida: QIest                      -
' - - - - - - - - - - - - - - - - - - - -
IF QIest > 19 THEN
    QIB = 19! + ((QIest - 19!) / (.602 * HC + 1))
ELSE
    QIB = QIest
END IF
IF QI0adm > 0 THEN
    DQI = QI0adm - QIB
ELSE
    H0 = 10 * HR
    IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
    IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
    IF H0 < 40 THEN X = H0 ELSE X = 40
    HOV = 3 - ((H0L + X) / 40)
    X1 = 19.42 - .78 * QIBL - .068 * H0
    IF H0 > 20 THEN y = H0 - 20 ELSE y = 0
    X2 = -19.5 - .008 * QIBL * y
    IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
    IF DQI > 0 THEN DQI = 0
END IF
QIest = QIB + DQI
RETURN

