CLS

OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
ARQUIVO$ = DadosAnoBase$ + "TRE.DAT"
OPEN ARQUIVO$ FOR INPUT AS #2
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV), Rodovia$(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
    INPUT #2, Rodovia$(I)
NEXT I
CLOSE #1, #2

' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4
DIM CustoP(NRODOV), ConserP(NRODOV), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
DIM REVEST$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
DIM FCnovorede(NRODOV), FCrecaprede(NRODOV), FCccprede(NRODOV)
DIM HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax), ICalib(NFaixasMax)
DIM D0(NFaixasMax), MRfound(NFaixasMax), PSIacost(NFaixasMax), DegrauAcost(NFaixasMax)
DIM MedidaAcost$(NFaixasMax), HRAC(NFaixasMax), H2AC(NFaixasMax), CustoAcost(NFaixasMax)
DIM CTotal(NRODOV), HRCP(NRODOV), CamadaRest$(NRODOV), A0rest(NRODOV)
DIM PSR0rest(NRODOV), MatCP$(NRODOV), B0rest(NRODOV)

' Numero de Subtrechos Homogeneos por rodovia e
' numero total de Subtrechos Homogeneos da rede
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
NSTH = 0
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
    NSTH = NSTH + NSTHRODOV(I)
NEXT I
CLOSE #1

' Constantes
PI# = 3.141592654#

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), VRmed(NPeriodos)
DIM Idade(NFaixasMax), PSIat(NSTH, NFaixasMax), NANO(NFaixasMax), PPrest(NPeriodos)
DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), CustoFaixa(NFaixasMax)
DIM MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax), AreaAcost(NSTH, NFaixasMax)
DIM PSImedSTH(NSTH), NPSI(NPeriodos), NFaixas(NSTH)
DIM IRI0(NFaixasMax), ALPHA(NFaixasMax)

ARQUIVO$ = CALC$ + "PESOS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, Param$
INPUT #1, PesoICO
INPUT #1, PesoIVD
CLOSE #1

' Funcao densidade de probabilidade para Fc
DIM Nc(4), NQI(4), NS(4)
Nc(1) = 50: NS(1) = 0: NQI(1) = 0
Nc(2) = 85: NS(2) = 1.04: NQI(2) = .89
Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.31
Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.09
  
ARQUIVO$ = CALC$ + "PARAM.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, PSIref
INPUT #1, PTRAF
INPUT #1, PPSI
INPUT #1, Nconf
CLOSE #1
IF Nconf <= Nc(2) THEN
    Ic1 = 1: Ic2 = 2
ELSE
    IF Nconf <= Nc(3) THEN
        Ic1 = 2: Ic2 = 3
    ELSE
        Ic1 = 3: Ic2 = 4
    END IF
END IF
NpsiMod = ((Nc(Ic2) * NS(Ic1) - Nc(Ic1) * NS(Ic2)) + Nconf * (NS(Ic2) - NS(Ic1))) / (Nc(Ic2) - Nc(Ic1))

ARQUIVO$ = CALC$ + "IDS.OUT"
OPEN ARQUIVO$ FOR INPUT AS #14

MaxVEL = -1
MinVEL = 1E+30
MaxCOV = -1
MinCOV = 1E+30
ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ARQUIVO$ = CALC$ + "NAT.CSV"
OPEN ARQUIVO$ FOR INPUT AS #7
LINE INPUT #7, LINHA$
ISTH = 0
FOR IRodov = 1 TO NRODOV
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFaixas(ISTH)
            INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
            Restaurado$(IFX) = "Nao"
            IF REVEST$(IFX) = "CCP" THEN UltCamada$(IFX) = "CCP" ELSE UltCamada$(IFX) = "CBUQ"
            HRef(IFX) = HrecExist(IFX)
            PSI = PSIat(ISTH, IFX)
            IF Idade(IFX) >= 0 THEN GOSUB 3000
            PSId = PSI
            VEL = PSIat(ISTH, IFX) - PSId
            COV = .00001 * (QImed(IFX) ^ 2) + .0031 * QImed(IFX) + 1.0091
            COV = COV * (VDMUni(IFX) / 1000)
            IF VEL > MaxVEL THEN MaxVEL = VEL
            IF VEL < MinVEL THEN MinVEL = VEL
            IF COV > MaxCOV THEN MaxCOV = COV
            IF COV < MinCOV THEN MinCOV = COV
        NEXT IFaixa
    NEXT ISUB
NEXT IRodov
INPUT #12, PSImed(0), NPSI(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
CLOSE #12, #7
  
ARQUIVO$ = CALC$ + "NAT.CSV"
OPEN ARQUIVO$ FOR INPUT AS #7
LINE INPUT #7, LINHA$
Nunits = 0
ISTH = 0
FOR IRodov = 1 TO NRODOV
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #7, y, J, KMIni, KMFim, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(2), HRAC(2), H2AC(2)
        FOR IFX = 1 TO NFaixas(ISTH)
            IF (MedidaF$(IFX) = "" OR MedidaF$(IFX) = "CR" OR MedidaF$(IFX) = "CL" OR MedidaF$(IFX) = "ST") THEN

            ELSE
                Nunits = Nunits + 1
            END IF
        NEXT IFX
    NEXT ISUB
NEXT IRodov
CLOSE #7

NParams = 7
DIM ITrecho(Nunits), SubTH(Nunits), Faixa(Nunits), ICustop(Nunits)
DIM IVelD(Nunits), IP(Nunits), Inicio(Nunits), Fim(Nunits)
DIM Sol$(Nunits), HC(Nunits), HR(Nunits), Par(NParams, Nunits)
 
ARQUIVO$ = CALC$ + "NAT.CSV"
OPEN ARQUIVO$ FOR INPUT AS #7
LINE INPUT #7, LINHA$

ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ISTH = 0
ICONT = 0
FOR IRodov = 1 TO NRODOV

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        ISTH = ISTH + 1
        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        INPUT #7, y, J, KMIni, KMFim, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(2), HRAC(2), H2AC(2)
        INPUT #14, ISTHH, IGG(1), IGG(2), IGG(3), IGG(4), TR23(1), TR23(2), TR23(3), TR23(4), TR3(1), TR3(2), TR3(3), TR3(4)

        FOR IFaixa = 1 TO NFaixas(ISTH)

            INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)

            IF (MedidaF$(IFX) = "CR" OR MedidaF$(IFX) = "CL" OR MedidaF$(IFX) = "ST") THEN

            ELSE

                Restaurado$(IFX) = "Nao"
                IF REVEST$(IFX) = "CCP" THEN UltCamada$(IFX) = "CCP" ELSE UltCamada$(IFX) = "CBUQ"
                HRef(IFX) = HrecExist(IFX)
                ICONT = ICONT + 1
                PSI = PSIat(ISTH, IFX)
                GOSUB 3000
                PSId = PSI
                VEL = PSIat(ISTH, IFX) - PSId
                COV = .00001 * (QImed(IFX) ^ 2) + .0031 * QImed(IFX) + 1.0091
                COV = COV * (VDMUni(IFX) / 1000)
                IVD = 100 * (VEL - MinVEL) / (MaxVEL - MinVEL)
                ICO = 100 * (COV - MinCOV) / (MaxCOV - MinCOV)
                Par(4, ICONT) = IGG(IFaixa)
                Par(3, ICONT) = QImed(IFaixa)
                Par(2, ICONT) = PSIat(ISTH, IFaixa)
                Par(6, ICONT) = ATRmed(IFaixa)
                Par(1, ICONT) = VidaRes(IFaixa)
                Par(5, ICONT) = TR23(IFaixa)
                Par(7, ICONT) = Idade(IFaixa)
                SELECT CASE Param$
                    CASE "IGG"
                        IP(ICONT) = IGG(IFaixa)
                    CASE "QI"
                        IP(ICONT) = QImed(IFaixa)
                    CASE "PSI"
                        IP(ICONT) = PSIat(ISTH, IFaixa)
                    CASE "ATR"
                        IP(ICONT) = ATRmed(IFaixa)
                    CASE "Vida Restante"
                        IP(ICONT) = VidaRes(IFaixa)
                    CASE "Trincamento"
                        Par(5, ICONT) = TR23(IFaixa)
                        IP(ICONT) = TR23(IFaixa)
                    CASE ELSE
                        IP(ICONT) = (PesoICO * ICO + PesoIVD * IVD) / (PesoICO + PesoIVD)
                END SELECT
                ITrecho(ICONT) = IRodov
                SubTH(ICONT) = STH
                Faixa(ICONT) = IFaixa
                ICustop(ICONT) = ICO
                IVelD(ICONT) = IVD
                Inicio(ICONT) = KMI
                Fim(ICONT) = KMF
                Sol$(ICONT) = MedidaF$(IFaixa)
                HC(ICONT) = Hfres(IFaixa)
                HR(ICONT) = Hrec(IFaixa)

            END IF

        NEXT IFaixa

    NEXT ISUB
NEXT IRodov
INPUT #12, PSImed(0), NPSI(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
CLOSE #12, #7

' * * * * * * * * * * *
' * Faz a Priorizacao *
' * * * * * * * * * * *

ARQUIVO$ = CALC$ + "PRIOR.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #15
WRITE #15, "Trecho", "STH", "kmi", "kmf", "Faixa", "Medida", "HCcm", "HRcm", "VRanos", "PSI", "QI", "IGG", "TR23", "ATR", "IP", "ICO", "IVD", "Idade"
    
ARQUIVO$ = CALC$ + "PRIOR2.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #13
WRITE #13, "Trecho", "Rodovia", "STH", "kmi", "kmf", "Faixa", "Medida", "HC_cm", "HR_cm", "VR_anos", "PSI", "QI", "IGG", "TR23", "ATR", "IP", "Idade"
    
Fim$ = "N"
WHILE Fim$ = "N"
    J = 0
    FOR I = 1 TO ICONT - 1
        IF IP(I + 1) > IP(I) THEN
            J = J + 1
            IP1 = IP(I + 1)
            IP(I + 1) = IP(I)
            IP(I) = IP1
            ITR = ITrecho(I + 1)
            ITrecho(I + 1) = ITrecho(I)
            ITrecho(I) = ITR
            STH = SubTH(I + 1)
            SubTH(I + 1) = SubTH(I)
            SubTH(I) = STH
            FX = Faixa(I + 1)
            Faixa(I + 1) = Faixa(I)
            Faixa(I) = FX
            ICO = ICustop(I + 1)
            ICustop(I + 1) = ICustop(I)
            ICustop(I) = ICO
            IVD = IVelD(I + 1)
            IVelD(I + 1) = IVelD(I)
            IVelD(I) = IVD
            Ini = Inicio(I + 1)
            Inicio(I + 1) = Inicio(I)
            Inicio(I) = Ini
            Final = Fim(I + 1)
            Fim(I + 1) = Fim(I)
            Fim(I) = Final
            Medida$ = Sol$(I + 1)
            Sol$(I + 1) = Sol$(I)
            Sol$(I) = Medida$
            Hfresa = HC(I + 1)
            HC(I + 1) = HC(I)
            HC(I) = Hfresa
            Hrecap = HR(I + 1)
            HR(I + 1) = HR(I)
            HR(I) = Hrecap
            FOR IPAR = 1 TO NParams
                Parametro = Par(IPAR, I + 1)
                Par(IPAR, I + 1) = Par(IPAR, I)
                Par(IPAR, I) = Parametro
            NEXT IPAR
        END IF

    NEXT I
    IF J = 0 THEN Fim$ = "S"
WEND
FOR I = 1 TO ICONT
    IP(I) = (PesoICO * ICustop(I) + PesoIVD * IVelD(I)) / (PesoICO + PesoIVD)
    IRodov = ITrecho(I)
    temp$ = "&, &, ###.###, ###.###, &, &, ###.###, ###.###, ###.###, ###.###, ###.###, ###.###, ###.###, ###.###, ###.###, ###.###, ###.###, ###.###"
    FOR JJ = 1 TO NParams
        IF Par(JJ, I) < 0.001 THEN Par(JJ, I) = 0
    NEXT JJ
    PRINT #15, USING temp$; Rodov$(IRodov); STR$(SubTH(I)); Inicio(I); Fim(I); STR$(Faixa(I)); Sol$(I); INT(1000 * HC(I)) / 1000; INT(1000 * HR(I)) / 1000; INT(1000 * Par(1, I)) / 1000; INT(1000 * Par(2, I)) / 1000; INT(1000 * Par(3, I)) / 1000; INT(1000 * Par(4, I)) / 1000; INT(1000 * Par(5, I)) / 1000; INT(1000 * Par(6, I)) / 1000; INT(1000 * IP(I)) / 1000; INT(1000 * ICustop(I)) / 1000; INT(1000 * IVelD(I)) / 1000; INT(1000 * Par(7, I)) / 1000
    WRITE #13, Rodov$(IRodov), Rodovia$(IRodov), SubTH(I), Inicio(I), Fim(I), Faixa(I), Sol$(I), HC(I), HR(I), Par(1, I), Par(2, I), Par(3, I), Par(4, I), Par(5, I), Par(6, I), IP(I), Par(7, I)
NEXT I
CLOSE #15

SYSTEM

3000 ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -      Evolucao da Condicao do Pavimento apos um Ano    -
' -                      (Subrotina)                      -
' -  Dados: H1REV, SN, Nacum, CBRSL, PSI, IRI0(IFaixa),   -
' -         ALPHA(IFaixa), Nano, QImed, HRef(IFaixa),     -
' -         IRec(IFaixa), ATRmed, TR23                    -
' -  Saida: PSI, QImed, IGG, TR23, ATRmed                 -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
FcIRImed = .6622: SigmaIRI = .6955
Niri = ((Nc(Ic2) * NQI(Ic1) - Nc(Ic1) * NQI(Ic2)) + Nconf * (NQI(Ic2) - NQI(Ic1))) / (Nc(Ic2) - Nc(Ic1))
Nt = ((Nc(Ic2) * NS(Ic1) - Nc(Ic1) * NS(Ic2)) + Nconf * (NS(Ic2) - NS(Ic1))) / (Nc(Ic2) - Nc(Ic1))
FcIRI = FcIRImed + Niri * SigmaIRI
TRmin = 10
DeltaT = .1
Nyear = NANO(IFaixa) / 1000000!
DeltaN = DeltaT * Nyear
PT = 2.5
DPSI = PSInovo(IFaixa) - PT
NE4 = Nacum(IFaixa) / 1000000!
TTIME = Idade(IFaixa)
IF PSI <= 4.5 THEN
    IGG(IFaixa) = ALFAIGG(IFaixa) * ((((4.5 / PSI) - 1) / .007635) ^ (1 / 1.065))
ELSE
    IGG(IFaixa) = 0
END IF
IF (Idade(IFaixa) > 20 AND ATRmed(IFaixa) > 12) THEN COMP = .7 ELSE COMP = 1
LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
PSR = 2 * PSI - PSIQI
FOR II = 1 TO 10
    ' Evolucao do PSI
    Nac = Idade(IFaixa) * NANO(IFaixa)
    Nf = T0(IFaixa) * ALPHA0(IFaixa) * NANO(IFaixa)
    IF TR23(IFaixa) < TRmin THEN
        ALFA = ALPHA(IFaixa)
    ELSE
        ALFA = ALPHA2(IFaixa)
    END IF
    IF IRec(IFaixa) = 0 THEN
        MR = 100 * CBRSL(IFaixa) / .0703
        VRmax = 25
        VRmin = 5
        BETA = .4 + (1094 / ((SN(IFaixa) + 1) ^ 5.19))
        W18# = (((SN(IFaixa) + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
        W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
        ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo(IFaixa) / 5))
        DeltaPSI = ALFA * ALFAA * DeltaN * PSI * LOG(PSI / 5)
    ELSE
        IF UltCamada$(IFaixa) = "CBUQ" THEN
            VRmax = 64.43 * (5 ^ -.76) * ((HrecExist(IFaixa) / 2.54) ^ .37)
            VRmin = 64.43 * (25 ^ -.76) * ((HrecExist(IFaixa) / 2.54) ^ .37)
            SNrecap = .44 * HRef(IFaixa) / 2.54
            MR = MRfound(IFaixa) / .0703
            BETA = .4 + (1094 / ((SNrecap + 1) ^ 5.19))
            W18# = (((SNrecap + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAA = (1 / W18#) * LOG(LOG(2.5 / 5) / LOG(PSInovo(IFaixa) / 5))
            DeltaPSI = ALFA * ALFAA * DeltaN * PSI * LOG(PSI / 5)
        ELSE
            VRmax = 10
            VRmin = 3
            DeltaPSI = -A1rest(IRodov) * DeltaN / EXP((A0rest(IRodov) + A2rest(IRodov) * SN(IFaixa) - (PSI + NpsiMod * SErest(IRodov))) / A1rest(IRodov))
        END IF
    END IF
    GOSUB 6600
    GOSUB 6800
    PSI = PSI + DeltaPSI
    IF PSI < .5 THEN PSI = .5
    ' Modelo do HDM-III para irregularidade
    NE4 = NE4 + DeltaT * Nyear
    TTIME = TTIME + DeltaT
    'IRI = (IRI0 + 725 * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
    DeltaIRI = (.0153 * (QImed(IFaixa) / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear * EXP(.0153 * TTIME)) * DeltaT
    QImed(IFaixa) = QImed(IFaixa) + 13 * DeltaIRI
    ' Evolucao do IGG e do PSR
    PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
    PSRat = 2 * PSI - PSIQI
    DeltaPSR = PSRat - PSR
    DeltaIGG = DeltaPSR * (-61.844 - IGG) / (.616 + PSR)
    IGG(IFaixa) = IGG(IFaixa) + DeltaIGG
    PSR = PSRat
    ' Evolucao do trincamento severo
    IF IRec(IFaixa) = 0 THEN
        RH = 0
        FcATRmed = 5.2942: SigmaATR = 2.1954
        SELECT CASE CamBase$(IFaixa)
            CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP"
                V1 = 8.7: V2 = 12.5
            CASE ELSE
                V1 = 6.3: V2 = 8.7
        END SELECT
    ELSE
        RH = 1
        IF UltCamada$(IFaixa) = "CBUQ" THEN
            V1 = 5: V2 = 7.6
            FcATRmed = 5.1017: SigmaATR = 3.1858
        ELSE
            V1 = 5 / T0(IFaixa)
            IF V1 < 5 THEN V1 = 5
            V2 = (31 / 10.2) * V1
            FcATRmed = 6.8533: SigmaATR = 3.386
        END IF
    END IF
    IF TR23(IFaixa) > 0 THEN
        IF TR23(IFaixa) > 30 THEN dTRdt = V2 ELSE dTRdt = V1
        TR23(IFaixa) = TR23(IFaixa) + dTRdt * DeltaT
    ELSE
        dTRdt = V1
        IF Nac > Nf THEN TR23(IFaixa) = TR23(IFaixa) + dTRdt * DeltaT
    END IF
    IF TR23(IFaixa) > 100 THEN TR23(IFaixa) = 100
    ' Evolucao dos afundamentos em trilha de roda
    FcATR = FcATRmed + Nt * SigmaATR
    NE4 = NE4 + DeltaT * Nyear
    ERM = .0902 + .0384 * (D0(IFaixa) / 100) - .009 * RH + .00158 * MMP * TR23(IFaixa)
    dATR = (.166 * FcATR * (COMP ^ -2.3) * (TTIME ^ (.166 - 1)) * (SNC ^ -.502) * (NE4 ^ ERM) + ERM * ATRmed(IFaixa) * (Nyear / NE4)) * DeltaT
    ATRmed(IFaixa) = ATRmed(IFaixa) + dATR
NEXT II
RETURN

6600 ' - - - - - - - - - - - -
' -  Subrotina Auxiliar -
' - - - - - - - - - - - -
dPSIdtmin = 2! / VRmax
dPSIdtmax = 2! / VRmin
DPSImin = dPSIdtmin * DeltaT
DPSImax = dPSIdtmax * DeltaT
RETURN

6800 ' - - - - - - - - - - - -
' -  Subrotina Auxiliar -
' - - - - - - - - - - - -
IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
RETURN


