CLS

NFaixasMax = 4
  
OPEN "SISTEMA.DAT" FOR INPUT AS #1
INPUT #1, SGP$
CLOSE #1
SGP$ = UCASE$(SGP$)

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Dados dos Segmentos Homogeneos
ARQ$ = CALC$ + "SegHom.csv"
OPEN ARQ$ FOR INPUT AS #11
LINE INPUT #11, LINHA$
  
' Criterios de Desempenho
ARQ$ = CALC$ + "Par.dat"
OPEN ARQ$ FOR INPUT AS #1
INPUT #1, IRIadmBom
INPUT #1, ATRadmBom
INPUT #1, IGGadmBom
INPUT #1, TR3admBom
INPUT #1, PPbom
INPUT #1, IRIadmReg
INPUT #1, ATRadmReg
INPUT #1, IGGadmReg
INPUT #1, TR3admReg
INPUT #1, RecFunc$
CLOSE #1
PP = PPbom
FatorDadm = 1.4
RecFunc$ = UCASE$(RecFunc$)

' Pesos no QIDcs
Piri = 25
Pigg = 25
Patr = 20
Pparger = 20
Pdrensup = 10
' Pesos no QIDmp
Pdeflex = 40
Poae = 40
Pdrensubt = 20
' Seguranca
Picrit = 34
Psinvert = 33
Psinhorz = 33
    
IF ANOBASE <= 2009 THEN
    AREAmax = 80
ELSE
    IF ANOBASE = 2010 THEN
        AREAmax = 60
    ELSE
        IF ANOBASE = 2011 THEN
            AREAmax = 30
        ELSE
            AREAmax = 0
        END IF
    END IF
END IF
QIadmBom = 13 * IRIadmBom
QIadmReg = 13 * IRIadmReg

ARQ$ = CALC$ + "QID.CSV"
OPEN ARQ$ FOR OUTPUT AS #15
WRITE #15, "Segmento", "IRI", "OK_IRI?", "ATR", "OK_ATR?", "IGG", "OK_IGG?", "D0", "Dadm", "OK_D0?", "TR3", "OK_TR3?", "QIDcs", "QIDmp", "QIDop"

ARQ$ = CALC$ + "QIDarea.CSV"
OPEN ARQ$ FOR OUTPUT AS #13
WRITE #13, "Segmento", "AREA_IRI", "AREA_DEFLEX"

ARQ$ = CALC$ + "IDS.OUT"
OPEN ARQ$ FOR INPUT AS #10

ARQ$ = CALC$ + "QIDdeflex.csv"
OPEN ARQ$ FOR OUTPUT AS #16
WRITE #16, "Segmento", "STH", "kmi", "kmf", "Faixa", "NPusace", "UltRecap", "Dadm", "D0", "Bom", "Regular", "Ruim"

ARQ$ = CALC$ + "DeflexQID.csv"
OPEN ARQ$ FOR OUTPUT AS #17
WRITE #17, "Segmento", "Dadm", "D0", "D0/Dadm", "Conceito"

' - - - - - - - - - - - - - - - -
' -  PARAMETROS DE CONFIGURACAO -
' - - - - - - - - - - - - - - - -

DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), VRmed(NPeriodos)
DIM Idade(NFaixasMax), PSIat(NFaixasMax), NANO(NFaixasMax), PPrest(NPeriodos)
DIM PSImed(NPeriodos), Aream2(NFaixasMax), CustoFaixa(NFaixasMax)
DIM MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax), AreaAcost(NFaixasMax)
DIM PSImedSTH(1000), Npsi(NPeriodos)
DIM IRI0(NFaixasMax), ALPHA(NFaixasMax)
DIM PSIrest(NPeriodos), QIrest(NPeriodos)

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRodov
DIM Rodov$(NRodov), NSTHRODOV(NRodov)
FOR I = 1 TO NRodov
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

IF SGP$ = "SGP16" THEN NTrechos = 20 ELSE NTrechos = NRodov
  
ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
  
QID = 0
ExtRede = 0
QIDiri = 0
QIDatr = 0
QIDparger = 0
QIDds = 0
QIDdeflex = 0
QIDoae = 0
QIDdrensubt = 0
QIDopRede = 0
  
FOR IRodov = 1 TO NTrechos

    ARQUIVO$ = CALC$ + "Nec" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    LINE INPUT #1, LINHA$

    FOR IFX = 1 TO NFaixasMax
        SELECT CASE IFX
            CASE 1: Faixa$ = "1"
            CASE 2: Faixa$ = "2"
            CASE 3: Faixa$ = "3"
            CASE 4: Faixa$ = "4"
            CASE ELSE
                PRINT "ERRO: faixa de trafego No identificada em ", Rodov$(IRodov)
        END SELECT
        ISUP = 1 + IFX
        ARQUIVO$ = CALC$ + "SUP" + Rodov$(IRodov) + Faixa$ + ".DAT"
        OPEN ARQUIVO$ FOR INPUT AS #ISUP
    NEXT IFX

    QImedTrecho = 0
    D0medTrecho = 0
    ExtTrecho = 0
    ATRmedTrecho = 0
    IGGmedTrecho = 0
    TR3medTrecho = 0
    DadmMed = 0
    AREAdeflex = 0
    AREAiri = 0

    WHILE NOT EOF(1)
        INPUT #1, STH, KMI, KMF, PSIat(1), VI(1), IGG(1), Idade(1), PSIat(2), VI(2), IGG(2), Idade(2), PSIat(3), VI(3), IGG(3), Idade(3), PSIat(4), VI(4), IGG(4), Idade(4), D0(1), D0(2), D0(3), D0(4), QI(1), QI(2), QI(3), QI(4)
        INPUT #10, ISTH, IGG(1), IGG(2), IGG(3), IGG(4), TR23(1), TR23(2), TR23(3), TR23(4), TR3(1), TR3(2), TR3(3), TR3(4)
        INPUT #12, STH, NFaixas, KMI, KMF, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFaixas
            INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
            INPUT #12, PSIat(IFX), Aream2(IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
        NEXT IFaixa
        QImed = 0
        D0med = 0
        ATRmed = 0
        IGGmed = 0
        TR3med = 0
        EXTsth = 0
        FOR IFX = 1 TO NFaixasMax
            ISUP = 1 + IFX
            INPUT #ISUP, STH, KMIni, KMFim, PSR(IFX), CR$(IFX), BL$(IFX), TT$(IFX)
            INPUT #ISUP, TL$(IFX), TE$(IFX), TB$(IFX), P$(IFX), D$(IFX), DS$(IFX)
            INPUT #ISUP, ER$(IFX), BF$(IFX), DC$(IFX), R$(IFX), ATR$(IFX), COR$(IFX)
            INPUT #ISUP, EM$(IFX), DP$(IFX), EL$(IFX), PSRACOST(IFX), DEGRAUCM(IFX), OBS$(IFX), ATRmed(IFX)
            IF IFX <= NFaixas THEN
                EXTkm = ABS(KMFim - KMIni)
                EXTsth = EXTsth + EXTkm
                QImed = QImed + QI(IFX) * EXTkm
                D0med = D0med + D0(IFX) * EXTkm
                ATRmed = ATRmed + ATRmed(IFX) * EXTkm
                IGGmed = IGGmed + IGG(IFX) * EXTkm
                TR3med = TR3med + TR3(IFX) * EXTkm
                ' Areas em que No ocorre atendimento ao criterio de irregularidade
                IF QI(IFX) > QIadm THEN AREAiri = AREAiri + EXTkm
                ' Verifica as Deflexoes
                Np = PP * NANO(IFX) * 3
                Dadm = 10 ^ (3.148 - .188 * LOG(Np) / LOG(10))
                FATOR = 1
                UltRecap$ = "CBUQ"
                IF REVEST$(IFX) <> "CBUQ" THEN
                    IF (HrecExist(IFX) > 1.7 AND HrecExist(IFX) < 3) THEN
                        FATOR = 2
                        UltRecap$ = "TSD"
                        Dadm = 10 ^ (3.01 - .176 * LOG(Np) / LOG(10))
                    END IF
                END IF
                Dadm = FATOR * Dadm
                DadmMed = DadmMed + Dadm * EXTkm
                IF D0(IFX) > Dadm THEN AREAdeflex = AREAdeflex + EXTkm
                IBom = 0
                IReg = 0
                IRuim = 0
                IF D0(IFX) < Dadm THEN
                    IBom = 1
                ELSE
                    IF D0(IFX) < 1.4 * Dadm THEN
                        IReg = 1
                    ELSE
                        IRuim = 1
                    END IF
                END IF
                WRITE #16, IRodov, STH, KMIni, KMFim, IFX, Np, UltRecap$, Dadm, D0(IFX), IBom, IReg, IRuim
            END IF
        NEXT IFX
        IF NFaixas > 0 THEN
            QImed = QImed / EXTsth
            D0med = D0med / EXTsth
            ATRmed = ATRmed / EXTsth
            IGGmed = IGGmed / EXTsth
            TR3med = TR3med / EXTsth
        ELSE
            PRINT "Erro: faltam as medidas de irregularidade"
        END IF
        ExtTrecho = ExtTrecho + EXTsth
        QImedTrecho = QImedTrecho + QImed * EXTsth
        D0medTrecho = D0medTrecho + D0med * EXTsth
        ATRmedTrecho = ATRmedTrecho + ATRmed * EXTsth
        IGGmedTrecho = IGGmedTrecho + IGGmed * EXTsth
        TR3medTrecho = TR3medTrecho + TR3med * EXTsth
    WEND
    CLOSE #1
    FOR IFX = 1 TO NFaixasMax
        ISUP = 1 + IFX
        CLOSE #ISUP
    NEXT IFX

    IGGmedTrecho = IGGmedTrecho / ExtTrecho
    DadmMed = DadmMed / ExtTrecho
    TR3medTrecho = TR3medTrecho / ExtTrecho
    AREAiri = 100 * AREAiri / ExtTrecho
    QImedTrecho = QImedTrecho / ExtTrecho
    ATRmedTrecho = ATRmedTrecho / ExtTrecho
    D0medTrecho = D0medTrecho / ExtTrecho
    RelDeflex = D0medTrecho / DadmMed
    IF RelDeflex < 1 THEN
        ConcDeflex$ = "Bom"
    ELSE
        IF RelDeflex < 1.4 THEN ConcDeflex$ = "Regular" ELSE ConcDeflex$ = "Ruim"
    END IF
    WRITE #17, IRodov, DadmMed, D0medTrecho, RelDeflex, ConcDeflex$

    INPUT #11, SEGH, km$, Panelas$, DRGsup$, RetrReflet, PlacasVer, PlacasOk, RecEstr$, NServ$, IC2007, ICrit, ParGerais$, OAE$, DrenSubt$
    ParGerais$ = UCASE$(ParGerais$)
    RecEstr$ = UCASE$(RecEstr$)
    NServ$ = UCASE$(NServ$)
    OAE$ = UCASE$(OAE$)
    IF ICrit >= 4 THEN
        IC$ = "BOM"
    ELSE
        IF ICrit >= 3 THEN
            IC$ = "REGULAR"
        ELSE
            IC$ = "RUIM"
        END IF
    END IF
    Panelas$ = UCASE$(Panelas$)
    IF Panelas$ = "SIM" THEN BP = 0 ELSE BP = 1
    DRGsup$ = UCASE$(DRGsup$)
    IF DRGsup$ = "BOM" THEN DrenSup = 10 ELSE DrenSup = 0
    SNHORIZ$ = "BOM"
    SELECT CASE SNHORIZ$
        CASE "BOM": SinHoriz = 10
        CASE "REGULAR": SinHoriz = 5
        CASE "RUIM": SinHoriz = 0
        CASE ELSE
            PRINT "ERRO"
    END SELECT
    SNVERT$ = "BOM"
    SELECT CASE SNVERT$
        CASE "BOM": SinVert = 10
        CASE "REGULAR": SinVert = 5
        CASE "RUIM": SinVert = 0
        CASE ELSE
            PRINT "ERRO"
    END SELECT

    AtIGG$ = ""
    AtDeflex$ = ""

    ' Efeito da Irregularidade
    IF QImedTrecho <= QIadmBom THEN
        I = 10
        AtIRI$ = "Bom"
    ELSE
        IF QImedTrecho < QIadmReg THEN
            IF AREAiri <= AREAmax THEN
                I = 10
                AtIRI$ = "Bom"
            ELSE
                I = 5
                AtIRI$ = "Regular"
            END IF
        ELSE
            I = 0
            AtIRI$ = "Ruim"
        END IF
    END IF
    QIDiri = I * Piri
    IRI = QImedTrecho / 13

    ' Efeito dos afundamentos em trilha de roda
    IF ATRmedTrecho <= ATRadmBom THEN
        J = 10
        AtATR$ = "Bom"
    ELSE
        IF ATRmedTrecho < ATRadmReg THEN
            J = 5
            AtATR$ = "Regular"
        ELSE
            J = 0
            AtATR$ = "Ruim"
        END IF
    END IF
    QIDatr = J * Patr

    ' Efeito do IGG
    IF RecEstr$ = "SIM" THEN
        IF IGGmedTrecho <= IGGadmBom THEN
            K = 10
            AtIGG$ = "Bom"
        ELSE
            IF IGGmedTrecho < IGGadmReg THEN
                K = 5
                AtIGG$ = "Regular"
            ELSE
                K = 0
                AtIGG$ = "Ruim"
            END IF
        END IF
    ELSE
        K = 10
    END IF
    QIDigg = K * Pigg

    ' Parametros Gerais
    IF TR3medTrecho <= TR3admBom THEN
        L = 10
        AtTR3$ = "Bom"
    ELSE
        IF TR3medTrecho <= TR3admBom THEN
            L = 5
            AtTR3$ = "Regular"
        ELSE
            L = 0
            AtTR3$ = "Ruim"
        END IF
    END IF
    IF ParGerais$ = "BOM" THEN L = 10 ELSE L = 0
    QIDparger = L * Pparger

    ' Drenagem Superficial
    QIDds = DrenSup * Pdrensup

    ' Efeito das Deflexoes
    IF RecEstr$ = "SIM" THEN
        IF D0medTrecho <= DadmMed THEN
            N = 10
            AtDeflex$ = "Bom"
        ELSE
            IF D0medTrecho < FatorDadm * DadmMed THEN
                IF AREAdeflex <= AREAmax THEN
                    N = 10
                    AtDeflex$ = "Bom"
                ELSE
                    N = 5
                    AtDeflex$ = "Regular"
                END IF
            ELSE
                N = 0
                AtDeflex$ = "Ruim"
            END IF
        END IF
    ELSE
        N = 10
    END IF
    QIDdeflex = N * Pdeflex

    ' Obras de Arte Especiais
    IF OAE$ = "BOM" THEN O = 10 ELSE O = 0
    QIDoae = O * Poae

    ' Drenagem Subterranea
    IF DrenSubt$ = "BOM" THEN P = 10 ELSE P = 0
    QIDdrensubt = P * Pdrensubt

    ' Indice Critico
    SELECT CASE IC$
        CASE "BOM"
            QIDic = 10
        CASE "REGULAR"
            QIDic = 5
        CASE "RUIM"
            QIDic = 0
        CASE ELSE
            PRINT "ERRO"
    END SELECT

    ' Calculo do QID
    ' Nota de Seguranca
    NotaSeg = (SinHoriz * Psinhorz + SinVert * Psinvert + QIDic * Picrit) / 100
    ' Nota da Condicao de Superficie
    QIDcs = BP * (QIDiri + QIDatr + QIDigg + QIDparger + QIDds) / (Piri + Patr + Pigg + Pparger + Pdrensup)
    ' Manutencao Patrimonial
    QIDmp = (QIDdeflex + QIDoae + QIDdrensubt) / (Pdeflex + Poae + Pdrensubt)
    ' Nota Operacional
    IF RecFunc$ = "CONCLUIDA" THEN
        QIDop = (QIDcs + QIDmp) / 2
    ELSE
        QIDop = .4 * NotaSeg + .6 * QIDcs
    END IF

    ' Efeito do Nivel de Servico
    IF NServ$ = "ATENDE" THEN
        QIDopRede = QIDopRede + QIDop * ExtTrecho
    END IF
    ExtRede = ExtRede + ExtTrecho

    QIDop = INT(100 * QIDop) / 100
    WRITE #15, IRodov, INT(100 * IRI) / 100, AtIRI$, INT(100 * ATRmedTrecho) / 100, AtATR$, INT(IGGmedTrecho), AtIGG$, INT(100 * D0medTrecho) / 100, INT(100 * Dadm) / 100, AtDeflex$, INT(10 * TR3medTrecho) / 10, AtTR3$, QIDcs, QIDmp, QIDop
    WRITE #13, IRodov, AREAiri, AREAdeflex

NEXT IRodov
INPUT #12, PSImed(0), Npsi(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
CLOSE #12, #13, #11

' Parametros Gerais para a Rede
QIDopRede = QIDopRede / ExtRede
ARQ$ = CALC$ + "ParGer.dat"
OPEN ARQ$ FOR INPUT AS #1
INPUT #1, Ambiental
INPUT #1, Financeira
INPUT #1, Social
CLOSE #1

' QID final
QID = .7 * QIDopRede + .1 * Ambiental + .1 * Financeira + .1 * Social
IF QID > 5 THEN
    Q% = INT(QID)
    RESTO = QID - Q%
    IF RESTO <= .5 THEN SOMA = 1 ELSE SOMA = 2
    QID = Q% + .5 * SOMA
END IF
  
' Imprime o Resultado Final
ARQ$ = CALC$ + "QID.OUT"
OPEN ARQ$ FOR OUTPUT AS #14
WRITE #14, INT(10 * QID) / 10
WRITE #14, NotaSeg
WRITE #14, QIDcs
CLOSE #14

WRITE #15,
WRITE #15, "QID = ", INT(10 * QID) / 10
WRITE #15, " Nota de Seguranca = ", NotaSeg
WRITE #15, " Nota de Condicao de Superficie = ", QIDcs
CLOSE #15
CLOSE #16, #17

SYSTEM
