CLS

' - - - - - - - - - - - - - - - -
' -  PARAMETROS DE CONFIGURACAO -
' - - - - - - - - - - - - - - - -

OPEN "SISTEMA.DAT" FOR INPUT AS #1
INPUT #1, SGP$
CLOSE #1
SGP$ = UCASE$(SGP$)

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DADOSANOBASE$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DADOSANOBASE$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Codigos de indentificacao das Pracas de Pedagio nos arquivos a serem gerados
ARQUIVO$ = DADOSANOBASE$ + "PEDAGIOS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NPDG
INPUT #1, NCatTraf
ARQUIVO$ = DADOSANOBASE$ + "PEDG.DAT"
OPEN ARQUIVO$ FOR INPUT AS #2
LINE INPUT #2, LINHA$
DIM Cat(NCatTraf), VolAnual(NPDG, NCatTraf), Pdg$(NPDG), ISent(NPDG)
DIM PdgNome$(NPDG), Volume(NCatTraf)
FOR I = 1 TO NPDG
    INPUT #1, PdgNome$(I)
    INPUT #1, ISent(I)
    INPUT #2, Pdg$(I)
NEXT I
CLOSE #1, #2
FOR J = 1 TO NPDG
    FOR I = 1 TO NCatTraf
        VolAnual(J, I) = 0
        Volume(I) = 0
    NEXT I
NEXT J

' Gera os arquivos referentes `as pracas de pedagio

OPEN "TRAFDATA.DAT" FOR INPUT AS #2
INPUT #2, NTRAF
FOR ITRAF = 1 TO NTRAF

    INPUT #2, TRAFDAT$

    ARQUIVO$ = TRAFDAT$ + "Pedagios.csv"
    OPEN ARQUIVO$ FOR INPUT AS #1
    LINE INPUT #1, LINHA$
    GOSUB 100
    Praca$ = UCASE$(Praca$)
    Praca1$ = Praca$
    GOSUB 1000

    FOR I = 1 TO NCatTraf
        VolAnual(IPDG, I) = VolAnual(IPDG, I) + Cat(I) / ISent(IPDG)
    NEXT I

    WHILE EOF(1) = False

        GOSUB 100
        Praca$ = UCASE$(Praca$)
        IF Praca$ <> Praca1$ THEN
            GOSUB 1000
            Praca1$ = Praca$
        END IF

        FOR I = 1 TO NCatTraf
            VolAnual(IPDG, I) = VolAnual(IPDG, I) + Cat(I) / ISent(IPDG)
        NEXT I

    WEND
    CLOSE #1

NEXT ITRAF
CLOSE #2

FOR IPDG = 1 TO NPDG
    Pedagio$ = Pdg$(IPDG)
    ARQUIVO$ = CALC$ + Pedagio$ + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #12
    WRITE #12, "Categoria", "VolAnual"
    FOR I = 1 TO NCatTraf
        Volume(I) = Volume(I) + VolAnual(IPDG, I)
        VolAnual(IPDG, I) = VolAnual(IPDG, I) / NTRAF
        WRITE #12, I, VolAnual(IPDG, I)
    NEXT I
    CLOSE #12
NEXT IPDG

ARQUIVO$ = CALC$ + "VOLUME.OUT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, NCatTraf
FOR I = 1 TO NCatTraf
    WRITE #1, Volume(I)
NEXT I
CLOSE #1

SYSTEM

100 '
'- - - - - - - - - - - - - -
'-  Categorias de Veiculos -
'- - - - - - - - - - - - - -
SELECT CASE SGP$
    CASE "SGP42"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4), Cat(5)
        INPUT #1, Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11)
        INPUT #1, Cat(12), Cat(13), Cat(14)
    CASE "SGP3\"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4), Cat(5)
        INPUT #1, Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11)
        INPUT #1, Cat(12), Cat(13), Cat(14), Cat(15), Total
    CASE "SGP5\", "SGP13", "SGP16"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4), Cat(5)
        INPUT #1, Cat(6), Cat(7), Cat(8), Cat(9), Cat(10)
    CASE "SGP23"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4), Cat(5)
        INPUT #1, Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11)
        INPUT #1, Cat(12), Cat(13), Cat(14)
    CASE "SGP22"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4), Cat(5)
        INPUT #1, Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11), Cat(12)
    CASE "SGP14"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4), Cat(5), Cat(6), Cat(7), Cat(8)
    CASE "SGPC\", "SGPL\", "SGPM\", "SGP8\", "SGP10", "SGP11"
        INPUT #1, Praca$, Sentido$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4)
        INPUT #1, Cat(5), Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11)
        INPUT #1, Cat(12), Cat(13), Cat(14), Cat(15), Total
    CASE "SGP17"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4)
        INPUT #1, Cat(5), Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11)
        INPUT #1, Cat(12), Cat(13), Total
    CASE "SGP4\"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4)
        INPUT #1, Cat(5), Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11)
        INPUT #1, Cat(12), Cat(13), Cat(14), Cat(15), Total
    CASE "SGP9\"
        INPUT #1, Praca$, Sent$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4)
        INPUT #1, Cat(5), Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11)
        INPUT #1, Cat(12), Cat(13), Cat(14), Cat(15), Total
    CASE "SGP6\"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4)
        INPUT #1, Cat(5), Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11)
    CASE "SGP43"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4)
        INPUT #1, Cat(5), Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11), Cat(12), Total
    CASE "SGP46", "SGP47", "SGP48"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4)
        INPUT #1, Cat(5), Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11), Cat(12), Cat(13)
    CASE "SGP49", "SGP50"
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4), Cat(5)
        INPUT #1, Cat(6), Cat(7), Cat(8), Cat(9), Cat(10), Cat(11), Cat(12)
    CASE ELSE
        INPUT #1, Praca$, DAT$, Cat(1), Cat(2), Cat(3), Cat(4), Cat(5)
        INPUT #1, Cat(6), Cat(7), Cat(8)
END SELECT
RETURN

1000 '
' - - - - - - - - - - - -
' -  Pracas de Pedagio  -
' -     (Subrotina)     -
' - - - - - - - - - - - -
SELECT CASE SGP$

    CASE "SGP3\"
        SELECT CASE Praca$
            CASE "P1", "P 1", "PP1", "PP 1"
                IPDG = 1
            CASE "P2", "P 2", "PP2", "PP 2"
                IPDG = 2
            CASE "P3", "P 3", "PP3", "PP 3"
                IPDG = 3
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP13"
        SELECT CASE Praca$
            CASE "LIMEIRA-A NORTE"
                IPDG = 1
            CASE "LIMEIRA-A SUL"
                IPDG = 2
            CASE "LIMEIRA-B NORTE"
                IPDG = 3
            CASE "LIMEIRA-B SUL"
                IPDG = 4
            CASE "NOVA ODESSA NORTE"
                IPDG = 5
            CASE "NOVA ODESSA SUL"
                IPDG = 6
            CASE "VALINHOS SUL"
                IPDG = 7
            CASE "VALINHOS NORTE"
                IPDG = 8
            CASE "PERUS NORTE"
                IPDG = 9
            CASE "PERUS SUL"
                IPDG = 10
            CASE "SUMARE NORTE"
                IPDG = 11
            CASE "SUMARE SUL"
                IPDG = 12
            CASE "ITUPEVA NORTE"
                IPDG = 13
            CASE "ITUPEVA SUL"
                IPDG = 14
            CASE "CAMPO LIMPO"
                IPDG = 15
            CASE "CAIEIRAS"
                IPDG = 16
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP14"
        SELECT CASE Praca$
            CASE "OSASCO"
                IPDG = 1
            CASE "BARUERI"
                IPDG = 2
            CASE "ITAPEVI"
                IPDG = 3
            CASE "ITU"
                IPDG = 4
            CASE "SOROCABA"
                IPDG = 5
            CASE "SAO ROQUE"
                IPDG = 6
            CASE "ALUMINIO"
                IPDG = 7
            CASE "A. DA SERRA (OESTE)"
                IPDG = 8
            CASE "A. DA SERRA (LESTE)"
                IPDG = 9
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP5\"
        SELECT CASE Praca$
            CASE "BOITUVA"
                IPDG = 1
            CASE "INDAIATUBA"
                IPDG = 2
            CASE "RIO CLARO", "RIOCLARO"
                IPDG = 3
            CASE "RIO DAS PEDRAS", "RIODASPEDRAS", "RIO DASPEDRAS", "RIODAS PEDRAS"
                IPDG = 4
            CASE "ITUPEVA"
                IPDG = 5
            CASE "PORTO FELIZ", "PORTOFELIZ"
                IPDG = 6
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP17"
        SELECT CASE Praca$
            CASE "PRUDENTOPOLIS"
                IPDG = 1
            CASE "IRATI"
                IPDG = 2
            CASE "PORTO AMAZONAS"
                IPDG = 3
            CASE "IMBITUVA"
                IPDG = 4
            CASE "LAPA"
                IPDG = 5
            CASE ELSE
                PRINT "ERRO"
        END SELECT
     
    CASE "SGP8\"
        SELECT CASE Praca$
            CASE "PASSO FUNDO"
                IPDG = 1
            CASE "SOLEDADE"
                IPDG = 2
            CASE "SARANDI"
                IPDG = 3
            CASE "PANAMBI"
                IPDG = 4
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP4\"
        SELECT CASE Praca$
            CASE "CONTAGEM"
                IPDG = 0
            CASE "RETIRO"
                IPDG = 1
            CASE "CRISTAL"
                IPDG = 2
            CASE "PAVAO", "PAVO", "PAVO"
                IPDG = 3
            CASE "CAPAO SECO", "CAPO SECO", "CAPO SECO"
                IPDG = 4
            CASE "GLORIA", "GLRIA", "GLRIA"
                IPDG = 5
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGPC\", "SGPL\", "SGPM\"
        SELECT CASE Praca$
            CASE "BOA VISTA DO SUL"
                IPDG = 1
            CASE "CRUZEIRO DO SUL"
                IPDG = 2
            CASE "ELDORADO"
                IPDG = 3
            CASE "ENCANTADO"
                IPDG = 4
            CASE "FARROUPILHA"
                IPDG = 5
            CASE "FAZENDA VILANOVA", "FAZENDA VILA NOVA"
                IPDG = 6
            CASE "FLORES DA CUNHA"
                IPDG = 7
            CASE "GUAIBA", "GUABA", "GUABA"
                IPDG = 8
            CASE "PANTANO GRANDE", "PANTANO"
                IPDG = 9
            CASE "PICADA MAY", "PICADA"
                IPDG = 10
            CASE "SO MARCOS", "SAO MARCOS", "SO MARCOS"
                IPDG = 11
            CASE "TAMANDU", "TAMANDUA", "TAMANDU"
                IPDG = 12
            CASE "VIAMO", "VIAMAO", "VIAMO"
                IPDG = 13
            CASE "VILA CRISTINA"
                IPDG = 14
            CASE ELSE
                PRINT "Pedagio desconhecido: "; Praca$
                PRINT "ERRO"
        END SELECT

    CASE "SGP16"
        SELECT CASE Praca$
            CASE "P1", "P 1", "PP1", "PP 1"
                IPDG = 1
            CASE "P2", "P 2", "PP2", "PP 2"
                IPDG = 2
            CASE "P3", "P 3", "PP3", "PP 3"
                IPDG = 3
            CASE "P4", "P 4", "PP4", "PP 4"
                IPDG = 4
            CASE "P5", "P 5", "PP5", "PP 5"
                IPDG = 5
            CASE "P6", "P 6", "PP6", "PP 6"
                IPDG = 6
            CASE ELSE
                PRINT "ERRO"
        END SELECT
     
    CASE "SGP18"
        SELECT CASE Praca$
            CASE "DIADEMA"
                IPDG = 1
            CASE "ELDORADO"
                IPDG = 2
            CASE "BATISTINI"
                IPDG = 3
            CASE "PIRATININGA"
                IPDG = 4
            CASE "RIACHO GRANDE"
                IPDG = 5
            CASE "SANTOS"
                IPDG = 6
            CASE "SAO VICENTE"
                IPDG = 7
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGMBD"
        SELECT CASE Praca$
            CASE "P1", "P 1", "PP1", "PP 1"
                IPDG = 1
            CASE "P2", "P 2", "PP2", "PP 2"
                IPDG = 2
            CASE "P3", "P 3", "PP3", "PP 3"
                IPDG = 3
            CASE "P4", "P 4", "PP4", "PP 4"
                IPDG = 4
            CASE "P5", "P 5", "PP5", "PP 5"
                IPDG = 5
            CASE "P6", "P 6", "PP6", "PP 6"
                IPDG = 6
            CASE "P7", "P 7", "PP7", "PP 7"
                IPDG = 7
            CASE "P8", "P 8", "PP8", "PP 8"
                IPDG = 8
            CASE "P9", "P 9", "PP9", "PP 9"
                IPDG = 9
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP19"
        SELECT CASE Praca$
            CASE "MONTE MOR"
                IPDG = 1
            CASE "RAFARD"
                IPDG = 2
            CASE "CONCHAS"
                IPDG = 3
            CASE "ANHEMBI"
                IPDG = 4
            CASE "BOTUCATU"
                IPDG = 5
            CASE "AREIOPOLIS"
                IPDG = 6
            CASE "AGUDOS"
                IPDG = 7
            CASE "SALTO"
                IPDG = 8
            CASE "RIO DAS PEDRAS"
                IPDG = 9
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP20", "SGP37", "SGP51"
        SELECT CASE Praca$
            CASE "PIRATININGA"
                IPDG = 1
            CASE "SANTA CRUZ DO RIO PARDO"
                IPDG = 2
            CASE "OURINHOS"
                IPDG = 3
            CASE "PALMITAL"
                IPDG = 4
            CASE "ASSIS"
                IPDG = 5
            CASE "RANCHARIA"
                IPDG = 6
            CASE "TACIBA"
                IPDG = 7
            CASE "PRESIDENTE BERNARDES"
                IPDG = 8
            CASE "CAIUA"
                IPDG = 9
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP21"
        SELECT CASE Praca$
            CASE "ITAQUAQUECETUBA"
                IPDG = 1
            CASE "GUARAREMA"
                IPDG = 2
            CASE "S. J. DOS CAMPOS"
                IPDG = 3
            CASE "CACAPAVA"
                IPDG = 4
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP22"
        SELECT CASE Praca$
            CASE "AVAI"
                IPDG = 1
            CASE "PIRAJUI"
                IPDG = 2
            CASE "PROMISSAO"
                IPDG = 3
            CASE "GLICERIO"
                IPDG = 4
            CASE "RUBIACEA"
                IPDG = 5
            CASE "LAVINIA"
                IPDG = 6
            CASE "GUARACAI"
                IPDG = 7
            CASE "CASTILHO"
                IPDG = 8
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP9\"
        SELECT CASE Praca$
            CASE "VENANCIO AIRES"
                IPDG = 1
            CASE "CANDELARIA"
                IPDG = 2
            CASE "RIO PARDO"
                IPDG = 3
            CASE ELSE
                PRINT "ERRO"
        END SELECT
     
    CASE "SGP10"
        SELECT CASE Praca$
            CASE "TRES COROAS"
                IPDG = 1
            CASE "GRAMADO"
                IPDG = 2
            CASE "SAO FRANCISCO DE PAULA"
                IPDG = 3
            CASE ELSE
                PRINT Praca$
                PRINT "ERRO"
        END SELECT

    CASE "SGP6\"
        SELECT CASE Praca$
            CASE "SAO MIGUEL"
                IPDG = 1
            CASE "CEU AZUL"
                IPDG = 2
            CASE "CASCAVEL"
                IPDG = 3
            CASE "LARANJEIRAS"
                IPDG = 4
            CASE "CANDOI"
                IPDG = 5
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP11"
        SELECT CASE Praca$
            CASE "DIVISA"
                IPDG = 1
            CASE "CAMPESTRE"
                IPDG = 2
            CASE "LAGOA"
                IPDG = 3
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP23"
        SELECT CASE Praca$
            CASE "P1_KM 35"
                IPDG = 1
            CASE "P2_KM 97"
                IPDG = 2
            CASE "P3_KM 184"
                IPDG = 3
            CASE "P4_KM 267"
                IPDG = 4
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP25"
        SELECT CASE Praca$
            CASE "P1_KM 598"
                IPDG = 1
            CASE "P2_KM 549"
                IPDG = 2
            CASE "P3_KM 480.7"
                IPDG = 3
            CASE "P4_KM 567.7"
                IPDG = 4
            CASE "P5_KM 698.7"
                IPDG = 5
            CASE "P6_KM 773.6"
                IPDG = 6
            CASE "P7_KM 875.5"
                IPDG = 7
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP34", "SGP44"
        SELECT CASE Praca$
            CASE "LOUVEIRA"
                IPDG = 1
            CASE "IGARATA"
                IPDG = 2
            CASE "JUNDIAI"
                IPDG = 3
            CASE "ATIBAIA"
                IPDG = 4
            CASE "ITATIBA"
                IPDG = 5
            CASE "PAULINIA A"
                IPDG = 6
            CASE "PAULINIA B"
                IPDG = 7
            CASE "ENGENHEIRO COELHO"
                IPDG = 8
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP29"
        SELECT CASE Praca$
            CASE "JAGUARIUNA"
                IPDG = 1
            CASE "ESTIVA"
                IPDG = 2
            CASE "CASA BRANCA"
                IPDG = 3
            CASE "MOCOCA"
                IPDG = 4
            CASE "E.S. DO PINHAL"
                IPDG = 5
            CASE "S.J. BOA VISTA"
                IPDG = 6
            CASE "A. PRATA"
                IPDG = 7
            CASE "ITOBI"
                IPDG = 8
            CASE "SP-344"
                IPDG = 9
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE "SGP32"
        SELECT CASE Praca$
            CASE "P1_ITIQUIRA"
                IPDG = 1
            CASE "P2_RONDONOPOLIS"
                IPDG = 2
            CASE "P3_CAMPO VERDE"
                IPDG = 3
            CASE "P4_STO. ANTONIO LEVERGER"
                IPDG = 4
            CASE "P5_JANGADA"
                IPDG = 5
            CASE "P6_NOBRES"
                IPDG = 6
            CASE "P7_NOVA MUTUM"
                IPDG = 7
            CASE "P8_LUCAS DO RIO VERDE"
                IPDG = 8
            CASE "P9_SORRISO"
                IPDG = 9
            CASE ELSE
                PRINT "ERRO"
        END SELECT

    CASE ELSE
        SELECT CASE Praca$
            CASE "P1"
                IPDG = 1
            CASE "P2"
                IPDG = 2
            CASE "P3"
                IPDG = 3
            CASE "P4"
                IPDG = 4
            CASE "P5"
                IPDG = 5
            CASE "P6"
                IPDG = 6
            CASE "P7"
                IPDG = 7
            CASE "P8"
                IPDG = 8
            CASE "P9"
                IPDG = 9
            CASE "P10"
                IPDG = 10
            CASE "P11"
                IPDG = 11
            CASE "P12"
                IPDG = 12
            CASE "P13"
                IPDG = 13
            CASE "P14"
                IPDG = 14
            CASE "P15"
                IPDG = 15
            CASE "P16"
                IPDG = 16
            CASE "P17"
                IPDG = 17
            CASE "P18"
                IPDG = 18
            CASE "P19"
                IPDG = 19
            CASE "P20"
                IPDG = 20
            CASE "P21"
                IPDG = 21
            CASE "P22"
                IPDG = 22
            CASE "P23"
                IPDG = 23
            CASE "P24"
                IPDG = 24
            CASE "P25"
                IPDG = 25
            CASE "P26"
                IPDG = 26
            CASE "P27"
                IPDG = 27
            CASE "P28"
                IPDG = 28
            CASE "P29"
                IPDG = 29
            CASE "P30"
                IPDG = 30
            CASE "P31"
                IPDG = 31
            CASE "P32"
                IPDG = 32
            CASE "P33"
                IPDG = 33
            CASE "P34"
                IPDG = 34
            CASE "P35"
                IPDG = 35
            CASE "P36"
                IPDG = 36
            CASE "P37"
                IPDG = 37
            CASE "P38"
                IPDG = 38
            CASE "P39"
                IPDG = 39
            CASE "P40"
                IPDG = 40
            CASE "P41"
                IPDG = 41
            CASE "P42"
                IPDG = 42
            CASE "P43"
                IPDG = 43
            CASE "P44"
                IPDG = 44
            CASE ELSE
                PRINT "ERRO"
                BEEP
        END SELECT

END SELECT

Pedagio$ = Pdg$(IPDG)
RETURN

