CLS

PRINT
PRINT "    PARAMETROS MEDIOS AO LONGO DO TEMPO     "
PRINT

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRodov
DIM Rodov$(NRodov), NSTHRODOV(NRodov)
FOR I = 1 TO NRodov
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NPolos = NRodov: NFaixasMax = 4: NClasses = 39
DIM CustoFaixa(NFaixasMax), MedidaAcost$(NFaixasMax), HRAC(NFaixasMax)
DIM H2AC(NFaixasMax), MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax)
DIM CustoP(NPolos), ConserP(NPolos), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
DIM REVEST$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
DIM HREFORCO(NFaixasMax), HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax)
DIM ICalib(NFaixasMax), D0(NFaixasMax), MRfound(NFaixasMax), IGG(NFaixasMax)
DIM DegrauAcost(NFaixasMax), CustoAcost(NFaixasMax), ClasseInterv(30, NClasses)

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRodov
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRodov
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), VRmed(NPeriodos)
DIM Idade(NFaixasMax), PSIat(NSTH, NFaixasMax), NANO(NFaixasMax), PPrest(NPeriodos)
DIM RestrAnual(NPeriodos), RestrPolo(NPolos, NPeriodos), IPRIOR(NSTH, NFaixasMax)
DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), AreaAcost(NSTH, NFaixasMax)
DIM PSImedSTH(NSTH), VSMIN(NPP), NPSI(NPeriodos), PSIt(1), NFaixas(NSTH)
DIM IRI0(NFaixasMax), ALPHA(NFaixasMax), CustoPolo(NPolos, NPeriodos)
DIM EXECF(NSTH, NFaixasMax), NewRestP(NPolos), CustoCLP(NPolos), Deficit(NPeriodos)
DIM IPMAXPolo(NPolos), STHPRIPolo(NPolos), CostPr(NPolos), CUSTOT(NPeriodos)
DIM STH(NSTHMAX), PSIacost(NSTH, NFaixasMax), COV(NPeriodos, NRodov)

' Arquivo de configuracao do problema a ser analisado:
ARQUIVO$ = CALC$ + "MODO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
CLOSE #1
 
SELECT CASE MODO
    CASE 1
        ARQUIVO$ = CALC$ + "DadoEstr.dat"
        MODOANALISE$ = "EstratBase"
        ARQ$ = "EB"
        NPer = NPeriodos
    CASE 2
        ARQUIVO$ = CALC$ + "DadoEstr.dat"
        MODOANALISE$ = "EstratRO"
        ARQ$ = "RO"
        NPer = NPeriodos
    CASE 0
        ARQUIVO$ = CALC$ + "Dados.dat"
        MODOANALISE$ = "EVOLUI"
        ARQ$ = "EVO"
        NPer = NPeriodos
    CASE 5
        ARQUIVO$ = CALC$ + "Dados.dat"
        MODOANALISE$ = "NECESSIDADES"
        ARQ$ = "NAT"
        NPer = 1
    CASE ELSE
        PRINT "ERRO"
END SELECT
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
INPUT #1, PPmin
INPUT #1, PPmax
INPUT #1, NPP
INPUT #1, inflacao
CLOSE #1

ARQOUT$ = CALC$ + "PROT.OUT"
OPEN ARQOUT$ FOR INPUT AS #2
FOR IANO = 1 TO NPer
    INPUT #2, CUSTOT(IANO)
NEXT IANO
CLOSE #2

' Parametros para medir o desempenho das estrategias (Ocorrencias em %) e
' criterio para Priorizacao das Restauracoes sob Restricoes Orcamentarias
ARQUIVO$ = CALC$ + "PARAM.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, PSIref
INPUT #1, PTRAF
INPUT #1, PPSI
INPUT #1, Nconf
CLOSE #1

ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ISTH = 0
FOR IRodov = 1 TO NRodov
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFaixas(ISTH)
            INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(ISTH, IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
        NEXT IFaixa
    NEXT ISUB
NEXT IRodov
INPUT #12, PSImed(0), NPSI(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
CLOSE #12
   
FOR ANO = 1 TO NPer

    TotalArea = 0
    NUnid = 0
    PSImed(ANO) = 0
    VRmed(ANO) = 0
    NPSI(ANO) = 0

    ANOcal = ANOBASE + ANO
    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12

    ISTH = 0
    FOR IR = 1 TO NRodov

        ARQUIVO$ = CALC$ + "PAR_" + Rodov$(IR) + STR$(ANO) + ".csv"
        OPEN ARQUIVO$ FOR OUTPUT AS #15
        WRITE #15, "KMI", "KMF", "QI_Fx1", "QI_Fx2", "QI_Fx3", "QI_Fx4", "IGG_Fx1", "IGG_Fx2", "IGG_Fx3", "IGG_Fx4", "ATR_Fx1", "ATR_Fx2", "ATR_Fx3", "ATR_Fx4", "TR_Fx1", "TR_Fx2", "TR_Fx3", "TR_Fx4"

        FOR ISUB = 1 TO NSTHRODOV(IR)
            ISTH = ISTH + 1
            PSImedSTH(ISTH) = 0
            INPUT #12, Subtrecho, KMI, KMF
            FOR IFaixa = 1 TO NFaixasMax
                QImed(IFaixa) = -1
                IGG(IFaixa) = -1
                ATRmed(IFaixa) = -1
                TR23(IFaixa) = -1
            NEXT IFaixa
            FOR IFaixa = 1 TO NFaixas(ISTH)
                INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
                INPUT #12, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), ALFAIGG(IFX), ATRmed(IFX)
                INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(ISTH, IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX)
                IF Idade(IFaixa) >= 0 THEN
                    IF PSIat(ISTH, IFaixa) < PSIref THEN NPSI(ANO) = NPSI(ANO) + 1
                    PSImedSTH(ISTH) = PSImedSTH(ISTH) + PSIat(ISTH, IFaixa) * Aream2(ISTH, IFaixa)
                    VRmed(ANO) = VRmed(ANO) + Aream2(ISTH, IFaixa) * VidaRes(IFaixa)
                    TotalArea = TotalArea + Aream2(ISTH, IFaixa)
                    NUnid = NUnid + 1
                END IF
                PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
                PSR = 2 * PSIat(ISTH, IFX) - PSIQI
                IGG(IFaixa) = (309.22 - 61.844 * PSR) / (PSR + 0.616)
            NEXT IFaixa
            PSImed(ANO) = PSImed(ANO) + PSImedSTH(ISTH)
            WRITE #15, KMI, KMF, INT(100 * QImed(1)) / 100, INT(100 * QImed(2)) / 100, INT(100 * QImed(3)) / 100, INT(100 * QImed(4)) / 100, INT(100 * IGG(1)) / 100, INT(100 * IGG(2)) / 100, INT(100 * IGG(3)) / 100, INT(100 * IGG(4)) / 100, INT(100 * ATRmed(1)) / 100, INT(100 * ATRmed(2)) / 100, INT(100 * ATRmed(3)) / 100, INT(100 * ATRmed(4)) / 100, INT(100 * TR23(1)) / 100, INT(100 * TR23(2)) / 100, INT(100 * TR23(3)) / 100, INT(100 * TR23(4)) / 100
        NEXT ISUB
        CLOSE #15

    NEXT IR
    INPUT #12, PSImed(0), NPSI(0), VRmed(0)
    INPUT #12, AreaTotal, NUnidAnalise
    CLOSE #12

    NPSI(ANO) = 100 * NPSI(ANO) / NUnid
    PSImed(ANO) = PSImed(ANO) / TotalArea
    VRmed(ANO) = VRmed(ANO) / TotalArea

NEXT ANO

' - - - - - - - - - - - - - - -
' -  Arquivos de Saida Finais -
' - - - - - - - - - - - - - - -
  
ARQPSI$ = CALC$ + "PSI" + ARQ$ + ".out"
ARQNPSI$ = CALC$ + "NPSI" + ARQ$ + ".out"
ARQVR$ = CALC$ + "VR" + ARQ$ + ".out"

OPEN ARQPSI$ FOR OUTPUT AS #2
OPEN ARQNPSI$ FOR OUTPUT AS #3
OPEN ARQVR$ FOR OUTPUT AS #5

FOR IANO = 0 TO NPeriodos
    WRITE #2, PSImed(IANO)
    WRITE #3, NPSI(IANO)
    WRITE #5, VRmed(IANO)
NEXT IANO
CLOSE #2, #3, #5

SYSTEM
