
' - - - - - - - - - - - - - - - -
' -  PARAMETROS DE CONFIGURACAO -
' - - - - - - - - - - - - - - - -
  
NParams = 10: NFaixasMax = 4
DIM Perct(NParams), MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax)
DIM NFaixas(3000), MedidaAcost$(2), HRAC(2), H2AC(2)

CLS

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Tipos de dados de que a base de dados e' composta:
ARQUIVO$ = DADOS$ + "TIPODADO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NDADOS
DIM DADO$(15)
FOR I = 1 TO NDADOS
    INPUT #1, DADO$(I)
NEXT I
CLOSE #1
NTIPOSDADOS = NDADOS
FOR IFx = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "SUP"
NEXT IFx
FOR IFx = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "DFX"
NEXT IFx

FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + DADO$(2) + Rodov$(I) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    NSTH = 0
    WHILE EOF(1) = FALSE
        LINE INPUT #1, LINHA$
        NSTH = NSTH + 1
    WEND
    NSTH = NSTH - 1
    NSTHRODOV(I) = NSTH
    CLOSE #1
NEXT I

ARQUIVO$ = CALC$ + "Ano.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, Year%
INPUT #1, FaixaTraf$
CLOSE #1

SELECT CASE FaixaTraf$
    CASE "Todas", ""
        Faixa = 0
    CASE "1"
        Faixa = 1
    CASE "2"
        Faixa = 2
    CASE "3"
        Faixa = 3
    CASE "4"
        Faixa = 4
    CASE ELSE
        PRINT "ERRO"
END SELECT
  
ARQUIVO$ = CALC$ + "Modo.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO%
CLOSE #1

FOR I = 1 TO NParams
    Perct(I) = 0
NEXT I
  
NUnidAnalise = 0
ISTH = 0
FOR IRodov = 1 TO NRODOV
    ARQUIVO$ = CALC$ + DADO$(2) + Rodov$(IRodov) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #2
    LINE INPUT #2, LINHA$
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #2, STH$, Rodov$, INI$, FIM$, KMINI, KMFIM, PISTA$
        INPUT #2, NFaixas(ISTH), PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
        INPUT #2, GEOVERT$, GEOHORIZ$, SECTIPO$, FX1, FX2, FX3, FX4, DECTRA, RESTR, ExtPontes, OBS$
    NEXT ISUB
    CLOSE #2
NEXT IRodov

ISTH = 0
FOR IRodov = 1 TO NRODOV

    SELECT CASE MODO%
        CASE 0
            ' Evolucao da condicao dos pavimentos
            ARQUIVO$ = CALC$ + "EVO" + Rodov$(IRodov) + ".CSV"
            OPEN ARQUIVO$ FOR INPUT AS #10
            LINE INPUT #10, LINHA$
        CASE 1
            ' Estrategia-base
            ARQUIVO$ = CALC$ + "EB" + Rodov$(IRodov) + ".CSV"
            OPEN ARQUIVO$ FOR INPUT AS #10
            LINE INPUT #10, LINHA$
        CASE 2
            ' Estrategia sob restricoes orcamentarias
            ARQUIVO$ = CALC$ + "RO" + Rodov$(IRodov) + ".CSV"
            OPEN ARQUIVO$ FOR INPUT AS #10
            LINE INPUT #10, LINHA$
        CASE 5
            ' Necessidades atuais de manutencao
            ARQUIVO$ = CALC$ + "NAT" + Rodov$(IRodov) + ".CSV"
            OPEN ARQUIVO$ FOR INPUT AS #10
            LINE INPUT #10, LINHA$
            NPeriodos = 1
        CASE ELSE
            PRINT "ERRO"
    END SELECT

    FOR IANO = 1 TO NPeriodos

        FOR ISUB = 1 TO NSTHRODOV(IRodov)

            SELECT CASE MODO%
                CASE 0
                    ' Evolucao da condicao dos pavimentos sem investimentos
                    INPUT #10, ANO%, JSUB, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(2), HRAC(2), H2AC(2)
                CASE 1
                    ' Estrategia-base
                    INPUT #10, ANO%, JSUB, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(2), HRAC(2), H2AC(2)
                CASE 2
                    ' Estrategia sob restricoes orcamentarias
                    INPUT #10, ANO%, JSUB, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(2), HRAC(2), H2AC(2)
                CASE 5
                    ' Necessidades atuais de manutencao
                    INPUT #10, ANO%, JSUB, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(2), HRAC(2), H2AC(2)
                    ANO% = Year%
                CASE ELSE
                    PRINT "ERRO"
            END SELECT

            IF ANO% = Year% THEN

                ISTH = ISTH + 1
                IF (Faixa = 0) THEN
                 
                    NUnidAnalise = NUnidAnalise + NFaixas(ISTH)
                    FOR IFaixa = 1 TO NFaixas(ISTH)

                        SELECT CASE MedidaF$(IFaixa)
                            CASE "CR": J = 1
                            CASE "CL": J = 2
                            CASE "CP", "FR+CP", "MF+CP": J = 3
                            CASE "FR+RC": J = 4
                            CASE "RRP": J = 5
                            CASE "RRT": J = 6
                            CASE "ST": J = 7
                            CASE "RRV": J = 8
                            CASE "RS": J = 9
                            CASE "MF+RC": J = 10
                            CASE ELSE
                                PRINT "ERRO"
                                PRINT Rodov$(IRodov), IFaixa
                                PRINT MedidaF$(IFaixa)
                        END SELECT
                        Perct(J) = Perct(J) + 1

                    NEXT IFaixa

                ELSE
                 
                    IF (Faixa <= NFaixas(ISTH)) THEN

                        NUnidAnalise = NUnidAnalise + 1
                        SELECT CASE MedidaF$(Faixa)
                            CASE "CR": J = 1
                            CASE "CL": J = 2
                            CASE "CP", "FR+CP", "MF+CP": J = 3
                            CASE "FR+RC": J = 4
                            CASE "RRP": J = 5
                            CASE "RRT": J = 6
                            CASE "ST": J = 7
                            CASE "RRV": J = 8
                            CASE "RS": J = 9
                            CASE "MF+RC": J = 10
                            CASE ELSE
                                PRINT "ERRO"
                                PRINT Rodov$(IRodov), IFaixa
                                PRINT MedidaF$(Faixa)
                        END SELECT
                        Perct(J) = Perct(J) + 1

                    END IF
                END IF

            END IF

        NEXT ISUB

    NEXT IANO
    CLOSE #10

NEXT IRodov

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

FOR I = 1 TO NParams
    Perct(I) = 100 * Perct(I) / NUnidAnalise
NEXT I
 
ARQUIVO$ = CALC$ + "Needs.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #1
temp$ = "&, ###.###"
WRITE #1, "Medida", "Perct"
PRINT #1, USING temp$; "CR"; Perct(1)
PRINT #1, USING temp$; "CL"; Perct(2)
PRINT #1, USING temp$; "CP"; Perct(3)
PRINT #1, USING temp$; "FR+RC"; Perct(4)
PRINT #1, USING temp$; "RRP"; Perct(5)
PRINT #1, USING temp$; "RRT"; Perct(6)
PRINT #1, USING temp$; "ST"; Perct(7)
PRINT #1, USING temp$; "RRV"; Perct(8)
PRINT #1, USING temp$; "RS"; Perct(9)
PRINT #1, USING temp$; "MF+RC"; Perct(10)
CLOSE #1

ARQUIVO$ = CALC$ + "Needs.out"
OPEN ARQUIVO$ FOR OUTPUT AS #1
FOR I = 1 TO NParams
    WRITE #1, Perct(I)
NEXT I
CLOSE #1

OPEN "DOS.DAT" FOR OUTPUT AS #1
WRITE #1, 1
CLOSE #1

SYSTEM

