CLS

PRINT
PRINT "   DADOS PARA O DESENVOLVIMENTO DE MODELOS DE DESEMPENHO   "
PRINT

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

ARQOUT$ = CALC$ + "MPDFLEX.csv"
OPEN ARQOUT$ FOR OUTPUT AS #15
WRITE #15, "STH", "Faixa", "HR", "H1", "IDADE", "N", "PSI", "QI", "TR", "IGG", "ATR", "NANO", "D0", "SN", "ESL", "FcHDMt0", "FcHDMatr", "QI0_HDM"

ARQOUT$ = CALC$ + "MPDREC.csv"
OPEN ARQOUT$ FOR OUTPUT AS #14
WRITE #14, "STH", "Faixa", "HR", "H1", "IDADE", "N", "PSI", "QI", "TR", "IGG", "ATR", "NANO", "D0", "SN", "ESL", "FcHDMt0", "FcHDMatr", "QI0_HDM"

ARQOUT$ = CALC$ + "MPDMIC.csv"
OPEN ARQOUT$ FOR OUTPUT AS #11
WRITE #11, "STH", "Faixa", "HR", "H1", "IDADE", "N", "PSI", "QI", "TR", "IGG", "ATR", "NANO", "D0", "SN", "ESL", "FcHDMt0", "FcHDMatr", "QI0_HDM"

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1
 
' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

DIM NFaixas(NSTH)
NFaixasMax = 4

ARQUIVO$ = CALC$ + "IDS.OUT"
OPEN ARQUIVO$ FOR INPUT AS #17

ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ISTH = 0
FOR IRodov = 1 TO NRODOV

    FOR IFX = 1 TO NFaixasMax
        SELECT CASE IFX
            CASE 1: Faixa$ = "1"
            CASE 2: Faixa$ = "2"
            CASE 3: Faixa$ = "3"
            CASE 4: Faixa$ = "4"
            CASE ELSE: PRINT "ERRO"
        END SELECT
        ISUP = IFX
        ARQUIVO$ = CALC$ + "SUP" + Rodov$(IRodov) + Faixa$ + ".DAT"
        OPEN ARQUIVO$ FOR INPUT AS #ISUP
    NEXT IFX

    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #17, ISTHH, IGG(1), IGG(2), IGG(3), IGG(4), TR23(1), TR23(2), TR23(3), TR23(4), TR3(1), TR3(2), TR3(3), TR3(4)
        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        FOR IFX = 1 TO NFaixasMax
            ISUP = IFX
            ' Estado de Superficie no Ano-Base
            INPUT #ISUP, STH, KMINI, KMFIM, PSR, CR$, BL$, TT$
            INPUT #ISUP, TL$, TE$, TB$, P$, D$, DS$
            INPUT #ISUP, ER$, BF$, DC$, R$, ATR$, COR$
            INPUT #ISUP, EM$, DP$, EL$, PSRACOST, DEGRAUCM, OBS$, ATRmed(IFX)
        NEXT IFX
        FOR IFaixa = 1 TO NFaixas(ISTH)
            INPUT #12, IFX, H1REV, HrecExist, Idade, SN, QImed, NANO, IRI0, Nacum, REVEST$, ALFAIGG
            INPUT #12, PSIat, Aream2, VidaRes, VDMUni, PSInovo, Heff, IRec, ICalib, D0, MRfound
            INPUT #12, ALPHA0, ALPHA, ALPHA2, AreaAcost, PSIacost, DegrauAcost, T0, TR, CBRSL, CamBase$, VDMc, ATRmed
            Nyear = NANO / 1000000!
            Nac = Idade * Nyear
            Nacum = Nac * 1000000!
            ' QI no HDM-III
            QI0 = 13 * IRI0
            IF QI0 < 6 THEN QI0 = -1
            LCBR = LOG(CBRSL) / LOG(10)
            SNC = SN + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
            'IRI = (IRI0 + 725 * ((1 + SNC) ^ -4.99) * Nac) * EXP(.0153 * Idade)
            'QI = 13 * IRI
            ' ATR no HDM-III
            MMP = .123
            ERM = .0902 + .0384 * (D0 / 100) - .009 * IRec + .00158 * MMP * TR
            ATR = (Idade ^ .166) * (SNC ^ -.502) * (Nacum ^ ERM)
            IF ATRmed(IFaixa) > 0 THEN
                FcHDMatr = ATRmed(IFaixa) / ATR
            ELSE
                FcHDMatr = -1
            END IF
            IF IRec = 0 THEN
                IF REVEST$ = "CBUQ" THEN
                    BASE$ = UCASE$(BASE$)
                    V1 = 8.7: V2 = 12.5
                    SELECT CASE BASE$
                        CASE "BGTC"
                            CMOD = 120000 / 10000!
                            TYcr2 = 1.11 * EXP(.035 * H1REV * 10 + .371 * LOG(CMOD) - .418 * LOG(D0 / 100) - 2.87 * Nyear * (D0 / 100))
                        CASE "SOLO-CIMENTO"
                            CMOD = 70000 / 10000!
                            TYcr2 = 1.11 * EXP(.035 * H1REV * 10 + .371 * LOG(CMOD) - .418 * LOG(D0 / 100) - 2.87 * Nyear * (D0 / 100))
                        CASE "SOLO-CAL"
                            CMOD = 50000 / 10000!
                            TYcr2 = 1.11 * EXP(.035 * H1REV * 10 + .371 * LOG(CMOD) - .418 * LOG(D0 / 100) - 2.87 * Nyear * (D0 / 100))
                        CASE "CCP"
                            CMOD = 280000 / 10000!
                            TYcr2 = 1.11 * EXP(.035 * H1REV * 10 + .371 * LOG(CMOD) - .418 * LOG(D0 / 100) - 2.87 * Nyear * (D0 / 100))
                        CASE ELSE
                            TYcr2 = 4.21 * EXP(.139 * SNC - 17.1 * (Nyear / (SNC ^ 2)))
                            V1 = 6.3: V2 = 8.7
                    END SELECT
                    Nf = TYcr2 * NANO
                    IF TR > 0 THEN
                        IF TR < 30 THEN
                            dTRdt = V1
                        ELSE
                            dTRdt = V2
                        END IF
                        DELTAT = TR / dTRdt
                        DeltaN = DELTAT * NANO
                        Nfrec = Nacum - DeltaN
                        IF Nfrec > 0 THEN FcHDMt0 = Nfrec / (TYcr2 * NANO) ELSE FcHDMt0 = -1
                    ELSE
                        IF Nacum < Nf THEN FcHDMt0 = 1 ELSE FcHDMt0 = -1
                    END IF
                    TR = INT(10 * TR) / 10
                    IGG(IFaixa) = INT(IGG(IFaixa))
                    NANO = INT(NANO)
                    D0 = INT(10 * D0) / 10
                    SN = INT(100 * SN) / 100
                    MRfound = INT(MRfound)
                    FcHDMt0 = INT(1000 * FcHDMt0) / 1000
                    FcHDMatr = INT(1000 * FcHDMatr) / 1000
                    QI0 = INT(10 * QI0) / 10
                    WRITE #15, STH, IFaixa, INT(10 * HrecExist) / 10, INT(10 * H1REV) / 10, INT(100 * Idade) / 100, INT(100 * Nac) / 100, INT(100 * PSIat) / 100, INT(10 * QImed) / 10, TR, IGG(IFaixa), ATRmed(IFaixa), NANO, D0, SN, MRfound, FcHDMt0, FcHDMatr, QI0
                END IF
            ELSE
                PCR4 = TR3(IFaixa)
                TYcr2A = 2.54 * EXP(.0157 * HrecExist * 10 - .0141 * PCR4)
                TYcr2B = 10.8 * EXP(-1.21 * (D0 / 100) - 1.02 * Nyear * (D0 / 100))
                TYcr2 = (1 * TYcr2A + 1.3 * TYcr2B) / (1 + 1.3)
                IF REVEST$ = "CBUQ" THEN
                    V1 = 5: V2 = 7.6
                ELSE
                    V1 = 10.2: V2 = 31
                END IF
                Nf = TYcr2 * NANO
                IF TR > 0 THEN
                    IF TR < 30 THEN
                        dTRdt = V1
                    ELSE
                        dTRdt = V2
                    END IF
                    DELTAT = TR / dTRdt
                    DeltaN = DELTAT * NANO
                    Nfrec = Nacum - DeltaN
                    IF Nfrec > 0 THEN FcHDMt0 = Nfrec / (TYcr2 * NANO) ELSE FcHDMt0 = -1
                ELSE
                    IF Nacum < Nf THEN FcHDMt0 = 1 ELSE FcHDMt0 = -1
                END IF
                TR = INT(10 * TR) / 10
                IGG(IFaixa) = INT(IGG(IFaixa))
                NANO = INT(NANO)
                D0 = INT(10 * D0) / 10
                SN = INT(100 * SN) / 100
                MRfound = INT(MRfound)
                FcHDMt0 = INT(1000 * FcHDMt0) / 1000
                FcHDMatr = INT(1000 * FcHDMatr) / 1000
                QI0 = INT(10 * QI0) / 10
                H = INT(10 * HrecExist) / 10
                H1 = INT(10 * H1REV) / 10
                Age = INT(100 * Idade) / 100
                IF REVEST$ = "CBUQ" THEN
                    WRITE #14, STH, IFaixa, H, H1, Age, INT(100 * Nac) / 100, INT(100 * PSIat) / 100, INT(10 * QImed) / 10, TR, IGG(IFaixa), ATRmed(IFaixa), NANO, D0, SN, MRfound, FcHDMt0, FcHDMatr, QI0
                ELSE
                    WRITE #11, STH, IFaixa, H, H1, Age, INT(100 * Nac) / 100, INT(100 * PSIat) / 100, INT(10 * QImed) / 10, TR, IGG(IFaixa), ATRmed(IFaixa), NANO, D0, SN, MRfound, FcHDMt0, FcHDMatr, QI0
                END IF
            END IF
        NEXT IFaixa
    NEXT ISUB
    CLOSE #1, #2, #3, #4
NEXT IRodov
INPUT #12, PSImed0, NPSI0, VRmed0
INPUT #12, AreaTotal, NUnidAnalise
CLOSE #12, #15, #17

SYSTEM

