CLS

PRINT
PRINT "    APLICACAO DE MICRO-CA POR MEIO DE MODELOS EMPIRICOS  "
PRINT

' Condicao terminal do pavimento ao final do periodo de projeto
TRc = 20
QIadm = 35
ATRmax = 7
PSImin = 3

Dc(1) = 25
Dc(2) = 35
Dc(3) = 45
Nyear(1) = .3
Nyear(2) = 1
Nyear(3) = 3
PCR4(1) = 3
PCR4(2) = 7
PCR4(3) = 15
QI(1) = 15
QI(2) = 25
QI(3) = 35

OPEN "MICRO.CSV" FOR OUTPUT AS #1
WRITE #1, "QI", "Nc(%)", "Dc", "Nano", "TR(%)", "HRcm 4 anos", "HRcm 5 anos", "HRcm 6 anos"

Nc(1) = 50: NS(1) = 0: NQI(1) = 0: NATR(1) = 0
Nc(2) = 85: NS(2) = 1.04: NQI(2) = .55: NATR(2) = .94
Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.22: NATR(3) = 1.348
Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.11: NATR(4) = 2!
FcIRImed = .45: SigmaIRI = .9827
FcATRmed = 1.882: SigmaATR = 1.099
FcMedTR = .873: SigmaTR = .338

FOR IQI = 1 TO 3

    FOR INC = 1 TO 4

        FcIRI = FcIRImed + NQI(INC) * SigmaIRI
        FcATR = FcATRmed + NATR(INC) * SigmaATR

        FOR IDC = 1 TO 3

            SNCexist = ((Dc(IDC) / 100) / 6.5) ^ (-1 / 1.6)

            FOR IN = 1 TO 3

                FOR ITR = 1 TO 3

                    HR6 = -1: ErroMin6 = 1E+30
                    HR4 = -1: ErroMin4 = 1E+30
                    HR5 = -1: ErroMin5 = 1E+30
                    HR = .5
                    FOR I = 1 TO 35

                        D0 = Dc(IDC) * 10 ^ (-HR / 40)
                        SNC = SNCexist + .44 * (HR / 2.54)
                        TYcr2A = 2.54 * EXP(.0157 * HR * 10 - .0141 * PCR4(ITR))
                        TYcr2B = 10.8 * EXP(-1.21 * (D0 / 100) - 1.02 * Nyear(IN) * (D0 / 100))
                        TYcr2 = (1 * TYcr2A + 1.3 * TYcr2B) / (1 + 1.3)
                        FcMed = FcMedTR
                        Sigma = SigmaTR
                        Fc = FcMed - NS(INC) * Sigma
                        TYcr2 = Fc * TYcr2
                        V1 = 10.2: V2 = 31
                        dTRdt = PCR4(ITR) / TYcr2
                        'IF dTRdt < V1 THEN dTRdt = V1
                        IF TRc > 30 THEN dTRdt = (V2 / V1) * dTRdt
                        DeltaT = TRc / dTRdt
                        VsTrinc = DeltaT + TYcr2

                        ' Modelo para irregularidade
                        ' HDM: IRI = (IRI0 + 725 * Fc * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
                        HC = 0
                        QIest = QI(IQI)
                        HRec = HR
                        GOSUB 6900
                        QI0 = QIest
                        VsQI = 0
                        QIt = QI0
                        DeltaT = .1
                        WHILE QIt < QIadm
                            VsQI = VsQI + DeltaT
                            DeltaIRI = (.0153 * (QIt / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear(IN) * EXP(.0153 * VsQI)) * DeltaT
                            QIt = QIt + DeltaIRI * 13
                        WEND
                        IF VsQI < VsTrinc THEN Vs = VsQI ELSE Vs = VsTrinc

                        ' Modelo para afundamentos em trilha de roda
                        MMP = .123: RH = 1
                        VsATR = 0: DeltaT = .5
                        ATR = 0
                        WHILE (ATR < ATRmax AND VsATR < Vs)
                            VsATR = VsATR + DeltaT
                            Nacum = Nyear(IN) * 1000000! * VsATR
                            IF VsATR <= TYcr2 THEN
                                CRX = 0
                            ELSE
                                IF VsATR < VsTrinc THEN
                                    CRX = TRc / 2
                                ELSE
                                    CRX = TRc
                                END IF
                            END IF
                            ERM = .0902 + .0384 * (D0 / 100) - .009 * RH + .00158 * MMP * CRX
                            ATRref = FcATR * (VsATR ^ .166) * (SNC ^ -.502) * (Nacum ^ ERM)
                        WEND
                        IF VsATR < Vs THEN Vs = VsATR

                        ' Modelo para Indice de Serventia
                        LCBR = LOG(10) / LOG(10)
                        SNexist = SNCexist - (3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43)
                        SN = SNexist + .44 * (HR / 2.54)
                        VsPSI = 0: DeltaT = .5
                        HC = 0
                        QIest = QI(IQI)
                        HRec = HR
                        GOSUB 6900
                        QI0 = QIest
                        PSIQI = 5! * EXP(-QI0 / 71.5)
                        PSR = 5
                        PSI = (PSR + PSIQI) / 2
                        IF PSI > 4.95 THEN PSI = 4.95
                        IF PSI <= 2.5 THEN PSI = 2.55
                        SigmaPSI = .402
                        WHILE (PSI > PSImin AND VsPSI < 10)
                            VsPSI = VsPSI + DeltaT
                            Nacum = Nyear(IN) * VsPSI
                            PSImed = 2.7297 - .1312 * LOG(Nacum) + .2852 * SN
                            PSI = PSImed - NS(INC) * SigmaPSI
                        WEND

                        IF VsPSI < VsQI THEN Vs = VsPSI ELSE Vs = VsQI
                        IF VsTrinc < Vs THEN Vs = VsTrinc

                        ERRO5 = 100 * ABS(Vs - 5) / 5
                        IF ERRO5 < ErroMin5 THEN
                            IF Vs >= 5 THEN
                                ErroMin5 = ERRO5
                                HR5 = HR
                            END IF
                        END IF
                        ERRO6 = 100 * ABS(Vs - 6) / 6
                        IF ERRO6 < ErroMin6 THEN
                            IF Vs >= 6 THEN
                                ErroMin6 = ERRO6
                                HR6 = HR
                            END IF
                        END IF
                        ERRO4 = 100 * ABS(Vs - 4) / 4
                        IF ERRO4 < ErroMin4 THEN
                            IF Vs >= 4 THEN
                                ErroMin4 = ERRO4
                                HR4 = HR
                            END IF
                        END IF
                        HR = HR + .1

                    NEXT I
                    WRITE #1, QI(IQI), Nc(INC), Dc(IDC), Nyear(IN), PCR4(ITR), INT(10 * HR4) / 10, INT(10 * HR5) / 10, INT(10 * HR6) / 10

                NEXT ITR
            NEXT IN
        NEXT IDC
    NEXT INC
NEXT IQI
CLOSE #1

SYSTEM

6900 ' - - - - - - - - - - - - - - - - - - - -
' -   Irregularidade apos Recapeamento  -
' -        (Subrotina do HDM-III)       -
' -   Dados: HRec, HC, QIest            -
' -   Saida: QIest                      -
' - - - - - - - - - - - - - - - - - - - -
IF QIest > 19 THEN
    QIB = 19! + ((QIest - 19!) / (.602 * HC + 1))
ELSE
    QIB = QIest
END IF
H0 = 10 * HRec
IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
IF H0 < 40 THEN X = H0 ELSE X = 40
HOV = 3 - ((H0L + X) / 40)
X1 = 19.42 - .78 * QIBL - .068 * H0
IF H0 > 20 THEN Y = H0 - 20 ELSE Y = 0
X2 = -19.5 - .008 * QIBL * Y
IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
IF DQI > 0 THEN DQI = 0
QIest = QIB + DQI
RETURN


