CLS

PRINT
PRINT "    PROJETO DE RESTAURACAO POR MEIO DE MODELOS EMPIRICOS  "
PRINT

' Condicao terminal do pavimento ao final do periodo de projeto
TRc = 20
QIadm = 35
ATRmax = 7
PSImin = 3
IGGmax = 50

' Condicao atual do pavimento
Dc = 45
PCR4 = 10
QI = 35
ATRexist = 7

' Dados de projeto
PP = 5
INC = 2
Nano = 500000!

Nc(1) = 50: NQI(1) = 0: NATR(1) = 0: NTR(1) = 0
Nc(2) = 85: NQI(2) = .198: NATR(2) = 1.1428: NTR(2) = .9693
Nc(3) = 90: NQI(3) = .681: NATR(3) = 1.52: NTR(3) = 1.55
Nc(4) = 95: NQI(4) = 1.84: NATR(4) = 1.99: NTR(4) = 2.306
FcIRImed = .5523: SigmaIRI = 1.4435
FcATRmed = 1.483: SigmaATR = 1.079
FcTRmed = 1.184: SigmaTR = .5

FcIRI = FcIRImed + NQI(INC) * SigmaIRI
FcATR = FcATRmed + NATR(INC) * SigmaATR

SNCexist = ((Dc / 100) / 6.5) ^ (-1 / 1.6)
Nyear = Nano / 1000000!

HR10 = -1: ErroMin10 = 1E+30
HR = 2!
FOR I = 1 TO 200

    D0 = Dc * 10 ^ (-HR / 40)
    SNC = SNCexist + .44 * (HR / 2.54)
    TYcr2A = 2.54 * EXP(.0157 * HR * 10 - .0141 * PCR4)
    TYcr2B = 10.8 * EXP(-1.21 * (D0 / 100) - 1.02 * Nyear * (D0 / 100))
    TYcr2 = (1 * TYcr2A + 1.3 * TYcr2B) / (1 + 1.3)
    Fc = FcTRmed - NTR(INC) * SigmaTR
    TYcr2 = Fc * TYcr2
    V1 = 5
    V2 = 7.6
    dTRdt = PCR4 / TYcr2
    IF dTRdt < V1 THEN dTRdt = V1
    IF TRc > 30 THEN dTRdt = (V2 / V1) * dTRdt
    DeltaT = TRc / dTRdt
    VsTrinc = DeltaT + TYcr2

    ' Modelo para irregularidade
    ' HDM: IRI = (IRI0 + 725 * Fc * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
    HC = 0
    QIest = QI
    HRec = HR
    GOSUB 6900
    QI0 = QIest
    VsQI = 0
    QIt = QI0
    DeltaT = .1
    WHILE QIt < QIadm
        VsQI = VsQI + DeltaT
        DeltaIRI = (.0153 * (QIt / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear * EXP(.0153 * VsQI)) * DeltaT
        QIt = QIt + DeltaIRI * 13
    WEND
    IF VsQI < VsTrinc THEN Vs = VsQI ELSE Vs = VsTrinc

    ' Modelo para afundamentos em trilha de roda
    MMP = .123: RH = 1
    VsATR = 0: DeltaT = .5
    ATR = .15 * ATRexist
    IF HR > 7.5 THEN ATR = .15 * ATR
    WHILE (ATR < ATRmax AND VsATR < Vs)
        VsATR = VsATR + DeltaT
        Nacum = Nyear * 1000000! * VsATR
        IF VsATR <= TYcr2 THEN
            CRX = 0
        ELSE
            IF VsATR < VsTrinc THEN
                CRX = TRc / 2
            ELSE
                CRX = TRc
            END IF
        END IF
        ERM = .0902 + .0384 * (D0 / 100) - .009 * RH + .00158 * MMP * CRX
        ATRref = FcATR * (VsATR ^ .166) * (SNC ^ -.502) * (Nacum ^ ERM)
    WEND
    IF VsATR < Vs THEN Vs = VsATR

    ERRO10 = 100 * ABS(Vs - PP) / PP
    IF ERRO10 < ErroMin10 THEN
        IF Vs >= PP THEN
            ErroMin10 = ERRO10
            HR10 = INT(10 * HR) / 10
        END IF
    END IF
    HR = HR + .1

NEXT I
   
PRINT
PRINT "HR (cm) = "; HR10
PRINT

PRINT
PRINT "      CAPA SELANTE COM FIBRAS  "
PRINT

Nc(1) = 50: NS(1) = 0: NQI(1) = 0: NATR(1) = 0
Nc(2) = 85: NS(2) = 1.04: NQI(2) = .55: NATR(2) = .94
Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.22: NATR(3) = 1.348
Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.11: NATR(4) = 2!
FcIRImed = .45: SigmaIRI = .9827
FcATRmed = 1.882: SigmaATR = 1.099
FcMedTR = .873: SigmaTR = .338

FcIRI = FcIRImed + NQI(INC) * SigmaIRI
FcATR = FcATRmed + NATR(INC) * SigmaATR

SNCexist = ((Dc / 100) / 6.5) ^ (-1 / 1.6)

HR5 = -1: ErroMin5 = 1E+30
HR = .5
FOR I = 1 TO 40

    D0 = Dc * 10 ^ (-HR / 40)
    SNC = SNCexist + .44 * (HR / 2.54)
    TYcr2A = 2.54 * EXP(.0157 * HR * 10 - .0141 * PCR4)
    TYcr2B = 10.8 * EXP(-1.21 * (D0 / 100) - 1.02 * Nyear * (D0 / 100))
    TYcr2 = (1 * TYcr2A + 1.3 * TYcr2B) / (1 + 1.3)
    FcMed = FcMedTR
    Sigma = SigmaTR
    Fc = FcMed - NS(INC) * Sigma
    TYcr2 = Fc * TYcr2
    V1 = 10.2: V2 = 31
    dTRdt = PCR4 / TYcr2
    'IF dTRdt < V1 THEN dTRdt = V1
    IF TRc > 30 THEN dTRdt = (V2 / V1) * dTRdt
    DeltaT = TRc / dTRdt
    VsTrinc = DeltaT + TYcr2

    ' Modelo para irregularidade
    ' HDM: IRI = (IRI0 + 725 * Fc * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
    HC = 0
    QIest = QI
    HRec = HR
    GOSUB 6900
    QI0 = QIest
    VsQI = 0
    QIt = QI0
    DeltaT = .1
    WHILE QIt < QIadm
        VsQI = VsQI + DeltaT
        DeltaIRI = (.0153 * (QIt / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear * EXP(.0153 * VsQI)) * DeltaT
        QIt = QIt + DeltaIRI * 13
    WEND
    IF VsQI < VsTrinc THEN Vs = VsQI ELSE Vs = VsTrinc
 
    ' Modelo para afundamentos em trilha de roda
    MMP = .123: RH = 1
    VsATR = 0: DeltaT = .5
    ATR = 0
    WHILE (ATR < ATRmax AND VsATR < Vs)
        VsATR = VsATR + DeltaT
        Nacum = Nyear * 1000000! * VsATR
        IF VsATR <= TYcr2 THEN
            CRX = 0
        ELSE
            IF VsATR < VsTrinc THEN
                CRX = TRc / 2
            ELSE
                CRX = TRc
            END IF
        END IF
        ERM = .0902 + .0384 * (D0 / 100) - .009 * RH + .00158 * MMP * CRX
        ATRref = FcATR * (VsATR ^ .166) * (SNC ^ -.502) * (Nacum ^ ERM)
    WEND
    IF VsATR < Vs THEN Vs = VsATR

    ' Modelo para Indice de Serventia
    VsPSI = 0: DeltaT = .5
    HC = 0
    QIest = QI
    HRec = HR
    GOSUB 6900
    QI0 = QIest
    PSIQI = 5! * EXP(-QI0 / 71.5)
    PSR = 5
    PSI = (PSR + PSIQI) / 2
    IF PSI > 4.95 THEN PSI = 4.95
    IF PSI <= 2.5 THEN PSI = 2.55
    SigmaPSI = .2436
    WHILE (PSI > PSImin AND VsPSI < 1.1 * PP)
        VsPSI = VsPSI + DeltaT
        Nacum = Nyear * VsPSI
        PSImed = 3.27 - .0128 * Dc * LOG(Nacum) + .6173 * HR
        PSI = PSImed - NS(INC) * SigmaPSI
    WEND

    ' Modelo para IGG
    SigmaIGG = 7.6
    VsIGG = 0
    IGG = 0
    WHILE IGG < IGGmax
        VsIGG = VsIGG + DeltaT
        Nacum = Nyear * VsIGG
        IGGmed = 32.317 + .45772 * Dc * LOG(Nacum) - 19.93 * HR
        IGG = IGGmed + NS(INC) * SigmaIGG
    WEND

    IF VsPSI < VsQI THEN Vs = VsPSI ELSE Vs = VsQI
    IF VsTrinc < Vs THEN Vs = VsTrinc
    IF VsIGG < Vs THEN Vs = VsIGG

    ERRO5 = 100 * ABS(Vs - PP) / PP
    IF ERRO5 < ErroMin5 THEN
        IF Vs >= PP THEN
            ErroMin5 = ERRO5
            HR5 = INT(10 * HR) / 10
        END IF
    END IF
    HR = HR + .1

NEXT I
 
IF HR5 > 0 THEN
    IF HR5 < 1.8 THEN
        Med$ = "Micro"
    ELSE
        IF HR5 < 2 THEN
            Med$ = "Cape Seal ou TSD"
        ELSE
            Med$ = "TSD+Micro"
        END IF
    END IF
    PRINT
    PRINT " Medida = "; Med$; " com "; HR5; "cm"
    PRINT
ELSE
    PRINT
    PRINT "Capa selante com fibras nao eh aplicavel"
    PRINT
END IF

PRINT
PRINT "      APLICACAO DE CAPA SELANTE  "
PRINT

Nc(1) = 50: NS(1) = 0: NQI(1) = 0: NATR(1) = 0
Nc(2) = 85: NS(2) = 1.04: NQI(2) = .55: NATR(2) = .94
Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.22: NATR(3) = 1.348
Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.11: NATR(4) = 2!
FcIRImed = .45: SigmaIRI = .9827
FcATRmed = 1.882: SigmaATR = 1.099
FcMedTR = .873: SigmaTR = .338

FcIRI = FcIRImed + NQI(INC) * SigmaIRI
FcATR = FcATRmed + NATR(INC) * SigmaATR

SNCexist = ((Dc / 100) / 6.5) ^ (-1 / 1.6)

HR5 = -1: ErroMin5 = 1E+30
HR = .5
FOR I = 1 TO 40

    D0 = Dc * 10 ^ (-HR / 40)
    SNC = SNCexist + .44 * (HR / 2.54)
    TYcr2A = 2.54 * EXP(.0157 * HR * 10 - .0141 * PCR4)
    TYcr2B = 10.8 * EXP(-1.21 * (D0 / 100) - 1.02 * Nyear * (D0 / 100))
    TYcr2 = (1 * TYcr2A + 1.3 * TYcr2B) / (1 + 1.3)
    FcMed = FcMedTR
    Sigma = SigmaTR
    Fc = FcMed - NS(INC) * Sigma
    TYcr2 = Fc * TYcr2
    V1 = 10.2: V2 = 31
    dTRdt = PCR4 / TYcr2
    'IF dTRdt < V1 THEN dTRdt = V1
    IF TRc > 30 THEN dTRdt = (V2 / V1) * dTRdt
    DeltaT = TRc / dTRdt
    VsTrinc = DeltaT + TYcr2

    ' Modelo para irregularidade
    ' HDM: IRI = (IRI0 + 725 * Fc * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
    HC = 0
    QIest = QI
    HRec = HR
    GOSUB 6900
    QI0 = QIest
    VsQI = 0
    QIt = QI0
    DeltaT = .1
    WHILE QIt < QIadm
        VsQI = VsQI + DeltaT
        DeltaIRI = (.0153 * (QIt / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear * EXP(.0153 * VsQI)) * DeltaT
        QIt = QIt + DeltaIRI * 13
    WEND
    IF VsQI < VsTrinc THEN Vs = VsQI ELSE Vs = VsTrinc

    ' Modelo para afundamentos em trilha de roda
    MMP = .123: RH = 1
    VsATR = 0: DeltaT = .5
    ATR = 0
    WHILE (ATR < ATRmax AND VsATR < Vs)
        VsATR = VsATR + DeltaT
        Nacum = Nyear * 1000000! * VsATR
        IF VsATR <= TYcr2 THEN
            CRX = 0
        ELSE
            IF VsATR < VsTrinc THEN
                CRX = TRc / 2
            ELSE
                CRX = TRc
            END IF
        END IF
        ERM = .0902 + .0384 * (D0 / 100) - .009 * RH + .00158 * MMP * CRX
        ATRref = FcATR * (VsATR ^ .166) * (SNC ^ -.502) * (Nacum ^ ERM)
    WEND
    IF VsATR < Vs THEN Vs = VsATR

    ' Modelo para Indice de Serventia
    LCBR = LOG(10) / LOG(10)
    SNexist = SNCexist - (3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43)
    SN = SNexist + .44 * (HR / 2.54)
    VsPSI = 0: DeltaT = .5
    HC = 0
    QIest = QI
    HRec = HR
    GOSUB 6900
    QI0 = QIest
    PSIQI = 5! * EXP(-QI0 / 71.5)
    PSR = 5
    PSI = (PSR + PSIQI) / 2
    IF PSI > 4.95 THEN PSI = 4.95
    IF PSI <= 2.5 THEN PSI = 2.55
    'SigmaPSI = .402
    SigmaPSI = .4101
    WHILE (PSI > PSImin AND VsPSI < 1.1 * PP)
        VsPSI = VsPSI + DeltaT
        Nacum = Nyear * VsPSI
        'PSImed = 2.7297 - .1312 * LOG(Nacum) + .2852 * SN
        PSImed = 3.9668 - .0463 * VsPSI - .00106 * Dc * LOG(Nano) + .22483 * HR
        PSI = PSImed - NS(INC) * SigmaPSI
    WEND

    IF VsPSI < VsQI THEN Vs = VsPSI ELSE Vs = VsQI
    IF VsTrinc < Vs THEN Vs = VsTrinc

    ERRO5 = 100 * ABS(Vs - PP) / PP
    IF ERRO5 < ErroMin5 THEN
        IF Vs >= PP THEN
            ErroMin5 = ERRO5
            HR5 = INT(10 * HR) / 10
        END IF
    END IF
    HR = HR + .1

NEXT I
   
IF HR5 > 0 THEN
    IF HR5 < 1.8 THEN
        Med$ = "Micro"
    ELSE
        IF HR5 < 2 THEN
            Med$ = "Cape Seal ou TSD"
        ELSE
            Med$ = "TSD+Micro"
        END IF
    END IF
    PRINT
    PRINT " Medida = "; Med$; " com "; HR5; "cm"
    PRINT
ELSE
    PRINT
    PRINT "Capa selante nao eh aplicavel"
    PRINT
END IF

SYSTEM

6900 ' - - - - - - - - - - - - - - - - - - - -
' -   Irregularidade apos Recapeamento  -
' -        (Subrotina do HDM-III)       -
' -   Dados: HRec, HC, QIest            -
' -   Saida: QIest                      -
' - - - - - - - - - - - - - - - - - - - -
IF QIest > 19 THEN
    QIB = 19! + ((QIest - 19!) / (.602 * HC + 1))
ELSE
    QIB = QIest
END IF
H0 = 10 * HRec
IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
IF H0 < 40 THEN X = H0 ELSE X = 40
HOV = 3 - ((H0L + X) / 40)
X1 = 19.42 - .78 * QIBL - .068 * H0
IF H0 > 20 THEN Y = H0 - 20 ELSE Y = 0
X2 = -19.5 - .008 * QIBL * Y
IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
IF DQI > 0 THEN DQI = 0
QIest = QIB + DQI
RETURN


