CLS

A$ = ":= "
' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4: NPolos = 50: NRodovMax = NPolos
DIM CustoP(NPolos), ConserP(NPolos), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
DIM REVEST$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
DIM HREFORCO(NFaixasMax), HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax)
DIM ICalib(NFaixasMax), D0(NFaixasMax), MRfound(NFaixasMax)
DIM PSIacost(NFaixasMax), DegrauAcost(NFaixasMax), MedidaAcost$(NFaixasMax)
DIM HRAC(NFaixasMax), H2AC(NFaixasMax), CustoAcost(NFaixasMax)

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Leitura dos codigos numericos que identificam os Subtrechos Homogeneos:
DIM Code(NRODOV, NSTHMAX), NSTHI(NRODOV)
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "CODE" + Rodov$(I) + ".STH"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, NSTHI(I)
    FOR J = 1 TO NSTHI(I)
        INPUT #1, Code(I, J)
    NEXT J
    CLOSE #1
NEXT I

' Arquivo de configuracao do problema a ser analisado:
ARQUIVO$ = CALC$ + "MODO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
CLOSE #1

' Parametros para medir o desempenho das estrategias (Ocorrencias em %) e
' criterio para Priorizacao das Restauracoes sob Restricoes Orcamentarias
ARQUIVO$ = CALC$ + "PARAM.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, PSIref
INPUT #1, PTRAF
INPUT #1, PPSI
INPUT #1, Nconf
CLOSE #1

' Fatores de calibracao medios da rede
ARQUIVO$ = CALC$ + "CALIB.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, FCnovo
INPUT #1, FCrecap
INPUT #1, FCccp
CLOSE #1

' Parametros para o Indice de Prioridade (gerados em Estrat1.bas)
ARQUIVO$ = CALC$ + "IP.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, VDMmin, VDMmax
INPUT #1, PSIminRede, PSImaxRede
CLOSE #1
IPFORC0 = 1000

' Constantes
PI# = 3.141592654#
QREF = 4100

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), VRmed(NPeriodos)
DIM Idade(NFaixasMax), PSIat(NSTH, NFaixasMax), Nano(NFaixasMax), PPrest(NPeriodos)
DIM RestrAnual(NPeriodos), RestrPolo(NPolos, NPeriodos), IPRIOR(NSTH, NFaixasMax)
DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), CustoFaixa(NFaixasMax)
DIM MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax), AreaAcost(NSTH, NFaixasMax)
DIM PSImedSTH(NSTH), VSMIN(NPP), NPSI(NPeriodos), PSIt(1), NFaixas(NSTH)
DIM IRI0(NFaixasMax), ALPHA(NFaixasMax)
DIM EXECF(NSTH, NFaixasMax), NewRestP(NPolos), CustoCLP(NPolos), Deficit(NPeriodos)
DIM IPMAXPolo(NPolos), STHPRIPolo(NPolos), CostPr(NPolos), CUSTOT(NPeriodos)

CLS
PRINT
PRINT "                        * * * * * * * * * * * * *  "
PRINT "                        *   MEMORIA DE CALCULO  *  "
PRINT "                        * * * * * * * * * * * * *  "

' * * * * * * * * * * * * *
' * Leitura da Estrategia *
' * * * * * * * * * * * * *

' Subtrecho selecionado
ARQUIVO$ = CALC$ + "MEMSTH.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, STHMEM
INPUT #1, FaixaMem
CLOSE #1

' Arquivos de saida
    
ARQUIVO$ = CALC$ + "MEMSTH.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #2
WRITE #2, "Item", "Valor"

ARQUIVO$ = CALC$ + "STH.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #3
WRITE #3, "Ano", "PSI", "VR"
WRITE #3, 2050.5, 3.55, 5.47

SELECT CASE MODO
    CASE 0
        MODOANALISE$ = "EVOLUI"
        ARQ$ = "EVO"
    CASE 1
        MODOANALISE$ = "EstratBase"
        ARQ$ = "EB"
    CASE 2
        MODOANALISE$ = "EstratRO"
        ARQ$ = "RO"
    CASE ELSE
        PRINT "ERRO"
END SELECT
  
ARQUIVO$ = CALC$ + "MEM1.DAT"
OPEN ARQUIVO$ FOR INPUT AS #16

ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ISTH = 0
FOR IRodov = 1 TO NRODOV
    IPolo = IRodov
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFaixas(ISTH)
            INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
        NEXT IFaixa
        IF STH = STHMEM THEN
            IF IRec(FaixaMem) = 1 THEN Rest$ = "Sim" ELSE Rest$ = "Nao"
            WRITE #2, "Pavimento ja' foi restaurado ?", A$ + Rest$
            'IF REVEST$(FaixaMem) = "CCP" THEN
            '       WRITE #2, "Espessura da placa de CCP (in) para a calibracao", A$ + STR$(SNcalib(FaixaMem))
            'ELSE
            '       WRITE #2, "Numero estrutural para a calibracao", A$ + STR$(SNcalib(FaixaMem))
            'END IF
            Efund = MRfound(FaixaMem)
            WRITE #2, "Modulo de resiliencia da fundacao (kgf/cm2)", A$ + STR$(Efund)
            IF ICalib(FaixaMem) = 1 THEN Calib$ = "Sim" ELSE Calib$ = "Nao"
            WRITE #2, "Foi possivel calibrar o M.P.D. neste caso ?", A$ + Calib$
        END IF
    NEXT ISUB
NEXT IRodov
INPUT #12, PSImed(0), NPSI(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
CLOSE #12, #16
  
IF (MODO = 1 OR MODO = 2) THEN
    ARQUIVO$ = CALC$ + ARQ$ + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #14
    LINE INPUT #14, LINHA$
END IF
  
FOR ANO = 0 TO NPeriodos

    PRINT "                   Ano = "; ANO
    ANOcal = ANOBASE + ANO

    WRITE #2, "Ano", A$ + STR$(ANOcal)

    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12

    ISTH = 0
    FOR IRodov = 1 TO NRODOV

        ' Parametros que definem as Arvores de Decisao:
        ARQUIVO$ = CALC$ + "ARV" + Rodov$(IRodov) + ".dat"
        OPEN ARQUIVO$ FOR INPUT AS #1
        INPUT #1, IDScrit
        INPUT #1, PSRcrit
        INPUT #1, HRMIN
        INPUT #1, HRMAX
        INPUT #1, PSIf
        INPUT #1, DEGRAUadm
        INPUT #1, HCMIN
        INPUT #1, VUMin
        INPUT #1, QI0adm
        INPUT #1, HbaseAcost
        CLOSE #1

        IPolo = IRodov
     
        FOR ISUB = 1 TO NSTHRODOV(IRodov)

            ISTH = ISTH + 1
            INPUT #12, STH, KMI, KMF
            FOR IFaixa = 1 TO NFaixas(ISTH)
                INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
                INPUT #12, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), Nacum(IFX), ALFAIGG(IFX), ATRmed(IFX)
                INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX)
                ' Indice de Prioridade
                IPSI = 100 * (PSImaxRede - PSIat(ISTH, IFaixa)) / (PSImaxRede - PSIminRede)
                ITRAF = 100 * (VDMUni(IFaixa) - VDMmin) / (VDMmax - VDMmin)
                IPRIOR(ISTH, IFaixa) = (PTRAF * ITRAF + PPSI * IPSI) / (PTRAF + PPSI)
                IF IPRIOR(ISTH, IFaixa < 0) THEN IPRIOR(ISTH, IFaixa) = .5
            NEXT IFaixa

            IF ANO > 0 THEN
                SELECT CASE MODO
                    CASE 0
                        Medida$ = ""
                        HR = 0
                        HC = 0
                    CASE 1, 2
                        INPUT #14, Y, J, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(2), HRAC(2), H2AC(2)
                        Medida$ = MedidaF$(FaixaMem)
                        HR = Hrec(FaixaMem)
                        HC = Hfres(FaixaMem)
                    CASE ELSE
                        PRINT "ERRO"
                END SELECT
            END IF

            IF STH = STHMEM THEN

                WRITE #3, ANOcal, PSIat(ISTH, FaixaMem), VidaRes(FaixaMem)

                WRITE #2, "PSI", A$ + STR$(PSIat(ISTH, FaixaMem))
                WRITE #2, "Vida Restante (anos)", A$ + STR$(VidaRes(FaixaMem))
                WRITE #2, "Idade desde a ultima restauracao (anos)", A$ + STR$(Idade(FaixaMem))
                WRITE #2, "HR efetiva (cm)", A$ + STR$(Heff(FaixaMem))
                WRITE #2, "Fator de Calibracao atual", A$ + STR$(ALPHA(FaixaMem))
                WRITE #2, "Ultima camada aplicada", A$ + UltCamada$(FaixaMem)
                WRITE #2, "        Espessura (cm)", A$ + STR$(HrecExist(FaixaMem))
                WRITE #2, "Espessura total do revestimento existente (cm)", A$ + STR$(H1REV(FaixaMem))
                WRITE #2, "QI (cont/km)", A$ + STR$(QImed(FaixaMem))
                WRITE #2, "Nano (AASHTO)", A$ + STR$(INT(Nano(FaixaMem)))
                WRITE #2, "Numero Estrutural (AASHTO)", A$ + STR$(SN(FaixaMem))
                IF ANO > 0 THEN
                    WRITE #2, "Medida aplicada", A$ + Medida$
                    WRITE #2, "       HR (cm)", A$ + STR$(HR)
                    WRITE #2, "       HC (cm)", A$ + STR$(HC)
                END IF
                WRITE #2, "Indice de Prioridade", A$ + STR$(IPRIOR(ISTH, FaixaMem))
                WRITE #2, "Deflexao do pavimento (0.01 mm) = ", A$ + STR$(D0(FaixaMem))
                WRITE #2, "Modulo de elasticidade da fundacao (kgf/cm2) = ", A$ + STR$(MRfound(FaixaMem))

            END IF

        NEXT ISUB
    NEXT IRodov

    INPUT #12, PSImed(0), NPSI(0), VRmed(0)
    INPUT #12, AreaTotal, NUnidAnalise
    CLOSE #12
 
NEXT ANO
CLOSE #2, #3
IF (MODO = 1 OR MODO = 2) THEN CLOSE #14

SYSTEM

