CLS

PI# = 3.141592654#
DIM R(18), Z(18)
V = 1
DIM X(V + 2), S(V + 2), T(V + 2), A(V + 2, V + 2)
DIM Nconf(4), NS(4)
Nconf(1) = 50: NS(1) = 0
Nconf(2) = 85: NS(2) = 1.04
Nconf(3) = 90: NS(3) = 1.29
Nconf(4) = 95: NS(4) = 1.65

PRINT
PRINT "    REFORCO ESTRUTURAL DOS SUBTRECHOS HOMOGENEOS   "
PRINT

NFaixasMax = 4

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DADOSANOBASE$
CLOSE #1

ARQUIVO$ = CALC$ + "TipoLev.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TipoLev$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DADOSANOBASE$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodovia$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodovia$(I)
NEXT I
CLOSE #1

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Criterios complementares para as arvores de decisao
ARQUIVO$ = CALC$ + "CRITERIO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TRcrit
INPUT #1, QIcrit
INPUT #1, ATRcrit
INPUT #1, ATRITOcrit
INPUT #1, IGGcrit
CLOSE #1

ARQ$ = CALC$ + "REF.DAT"
OPEN ARQ$ FOR INPUT AS #1
INPUT #1, TRECHO$
INPUT #1, Faixa
INPUT #1, PP
INPUT #1, NC
INPUT #1, TAXA
INPUT #1, PSIt
INPUT #1, GrTraf$
INPUT #1, RestrGreide$
CLOSE #1

GOSUB 5

ARQUIVO$ = CALC$ + "REF" + TRECHO$ + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #13
WRITE #13, "Subtrecho", "HRestr medio (cm)", "HRfunc medio (cm)", "Desvio_HR func.", "N pontos", "SN", "CBRsl", "SNC"

ARQUIVO$ = CALC$ + "CADAS" + TRECHO$ + ".CSV"
OPEN ARQUIVO$ FOR INPUT AS #4
LINE INPUT #4, LINHA$

WHILE NOT EOF(4)

    INPUT #4, STH, Rodov$, INI$, FIM$, KMI, KMF, PISTA$
    INPUT #4, NFaixas, PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
    INPUT #4, GEOVERT$, GEOHORIZ$, SECTIPO$, FX(1), FX(2), FX(3), FX(4), DECTRA, RESTR, ExtPontes, OBS$

    N = 0
    HRmed = 0
    HRfuncMed = 0
    Desvio = 0
    SNmed = 0
    SNCmed = 0
    CBRslMed = 0

    ARQUIVO$ = CALC$ + "HR" + TRECHO$ + Faixa$ + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    LINE INPUT #1, LINHA$
    WHILE NOT EOF(1)
        INPUT #1, Subtrecho, km, DF0, Dadm11, HRestr, CamCrit$, HRfunc, Medida$, hc, HR, h2, Acost$, hcac, HRac, h2ac, SNtotal, Hrev, Hbase, Hsub, Href, E1ref, E1, E2, Ebase, E3, MRsl, JDR, Eccp, Kef
        Achou$ = "N"
        IF KMF > KMI THEN
            IF (KMI <= km AND km <= KMF) THEN Achou$ = "S"
        ELSE
            IF (KMI >= km AND km >= KMF) THEN Achou$ = "S"
        END IF
        IF Achou$ = "S" THEN
            N = N + 1
            HRmed = HRmed + HRestr
            HRfuncMed = HRfuncMed + HRfunc
            Desvio = Desvio + (HRfunc ^ 2)
            CBRsl = MRsl / 100
            IF CBRsl < 3 THEN CBRsl = 3
            IF CBRsl > 30 THEN CBRsl = 30
            LCBR = LOG(CBRsl) / LOG(10)
            SNC = SNtotal + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
            SNmed = SNmed + SNtotal
            SNCmed = SNCmed + SNC
            CBRslMed = CBRslMed + CBRsl
        END IF
    WEND
    CLOSE #1
    IF N > 0 THEN
        HRmed = HRmed / N
        HRfuncMed = HRfuncMed / N
        IF N > 1 THEN
            Desvio = SQR((Desvio - N * HRfuncMed * HRfuncMed) / (N - 1))
        ELSE
            Desvio = 0
        END IF
        SNmed = SNmed / N
        SNCmed = SNCmed / N
        CBRslMed = CBRslMed / N
        WRITE #13, STH, HRmed, HRfuncMed, Desvio, N, SNmed, CBRslMed, SNCmed
    END IF

WEND
CLOSE #4, #13

SYSTEM


5 SELECT CASE Faixa
    CASE 1: Faixa$ = "1"
    CASE 2: Faixa$ = "2"
    CASE 3: Faixa$ = "3"
    CASE 4: Faixa$ = "4"
    CASE ELSE
        PRINT "ERRO"
END SELECT
RETURN
