CLS

    ' - - - - - - - - - - - - - - - - - - - - - - - - - - -
    ' -   Calibracao do Modelo de Previsao de Desempenho  -
    ' - - - - - - - - - - - - - - - - - - - - - - - - - - -
     
      FOR IFaixa = 1 TO NFaixas
         
          Age = Idade(IFaixa)
          IF Age <= 0 THEN
                 ARQUIVO$ = CALC$ + "DEPURA.DAT"
                 OPEN ARQUIVO$ FOR APPEND AS #16
                 WRITE #16, "ERRO na idade do pavimento do Subtrecho No.: ", STH, " na faixa de trafego ", IFaixa
                 CLOSE #16
                 IDepura = IDepura + 1
          END IF

          PSI = PSIat(ISTH, IFaixa)
          Nacum(IFaixa) = Age * NANO(IFaixa)
          NE4 = Nacum(IFaixa) / 1000000!
          NYEAR = NANO(IFaixa) / 1000000!
          H1 = H1REV(IFaixa)
          IF SN(IFaixa) = 0 THEN SN(IFaixa) = .44 * (H1 / 2.54) + .14 * (H2CM / 2.54) + .11 * (H3CM / 2.54) + .07 * (H4CM / 2.54)
          LCBR = LOG(CBRSL) / LOG(10)
          SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
          IF NANO(IFaixa) <= 0 THEN
                 ARQUIVO$ = CALC$ + "DEPURA.DAT"
                 OPEN ARQUIVO$ FOR APPEND AS #16
                 WRITE #16, "ERRO no trafego do Subtrecho No.: ", STH, " na faixa de trafego ", IFaixa
                 CLOSE #16
                 IDepura = IDepura + 1
          END IF

          ' Modelo: PSI = f(t)
            ' Valor de Alfa requerido pelo pavimento existente
              IF NE4 <= 0 THEN
                 ALFAL = 1
              ELSE
                 IF (PSI <= 0 OR PSI >= 5) THEN
                    ARQUIVO$ = CALC$ + "DEPURA.DAT"
                    OPEN ARQUIVO$ FOR APPEND AS #16
                    WRITE #16, "ERRO no PSI do Subtrecho No.: ", STH, " na faixa de trafego ", IFaixa
                    CLOSE #16
                    IDepura = IDepura + 1
                    ALFAL = 1
                 ELSE
                    ALFAL = (1 / NE4) * LOG(LOG(PSI / 5) / LOG(PSInovo / 5))
                 END IF
              END IF
            PT = 2.5
            DPSI = PSInovo - PT
            SNcalib = SN(IFaixa)
            MR = 100 * CBRSL / .0703
            BETA = .4 + (1094 / ((SNcalib + 1) ^ 5.19))
            W18# = (((SNcalib + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
            FCmin = FCminCA
            FCmax = FCmaxCA
            ' Valor de Alfa pelo Guia da AASHTO
              ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo / 5))
            ' Calibracao pelo HDM-III
              ALFAnew(IFaixa) = 1! * ALFAA
            IF IRest(IFaixa) = 1 THEN
               IF HrecExist(IFaixa) <= 0 THEN
                        ARQUIVO$ = CALC$ + "DEPURA.DAT"
                        OPEN ARQUIVO$ FOR APPEND AS #16
                        WRITE #16, "ERRO na espessura do ultimo recapeamento do Subtrecho No.: ", STH, " na faixa de trafego ", IFaixa
                        CLOSE #16
                        IDepura = IDepura + 1
               ELSE
                        SELECT CASE REVEST$(IFaixa)
                               CASE "CBUQ"
                                            A1 = .44
                                            FCmin = FCminRecap
                                            FCmax = FCmaxRecap
                               CASE "MICRO"
                                            A1 = .47
                                            FCmin = FCminMicro
                                            FCmax = FCmaxMicro
                               CASE ELSE
                                    PRINT "ERRO": STOP
                        END SELECT
                        SNcalib = A1 * HrecExist(IFaixa) / 2.54
                        GOSUB 6800
                        MR = E / .0703
                        BETA = .4 + (1094 / ((SNcalib + 1) ^ 5.19))
                        W18# = (((SNcalib + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                        W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
                        ' Valor de Alfa pelo Guia da AASHTO
                          ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo / 5))
                        ' Calibracao pelo HDM-III
                          ALFA(IFaixa) = 1! * ALFAA
               END IF
            ELSE
                ALFA(IFaixa) = ALFAnew(IFaixa)
            END IF
           
    ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    ' -  Vida Restante e Espessura Eefetiva do Recapeamento Existente -
    ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

              IF ICalib(IFaixa) = 0 THEN
                 IF IRest(IFaixa) = 0 THEN
                    ALPHA(IFaixa) = FCnovorede(IRodov)
                    FChr = FCrecaprede(IRodov)
                 ELSE
                    FChr = FCrecaprede(IRodov)
                    IF REVEST$(IFaixa) = "CBUQ" THEN
                            ALPHA(IFaixa) = FCrecaprede(IRodov)
                     ELSE
                            ALPHA(IFaixa) = FCmicrorede(IRodov)
                     END IF
                 END IF
              ELSE
                 IF IRest(IFaixa) = 0 THEN
                       FChr = FCrecaprede(IRodov)
                 ELSE
                       FChr = ALPHA(IFaixa)
                 END IF
              END IF
              ALFAG = ALFA(IFaixa) * ALPHA(IFaixa)
              ' Estimativa da Vida Restante
                NYEAR = NANO(IFaixa) / 1000000!
                Age = Idade(IFaixa)
                QI = QImed(IFaixa)
                GOSUB 6000
                VidaRes(IFaixa) = VR
                VRmed = VRmed + VR * Aream2(ISTH, IFaixa)
              ' Espessura efetiva de reforco existente
                PSI = PSIat(ISTH, IFaixa)
                NYEAR = NANO(IFaixa)
                GOSUB 1700

       ' Necessidade de reforco estrutural:
         VR = VidaRes(IFaixa)
         TempoRestante = NPeriodos - ANO
         IF TempoRestante > VSMIN THEN
            IF (Age >= 0 AND Age < 1) THEN PP = VSMIN ELSE PP = VSMIN - VR
         ELSE
            PP = TempoRestante + VRminFinal
         END IF
         IF PP < .5 THEN PP = .5
         GOSUB 1200
         HREFORCO(IFaixa) = HRMPD


END

6700 ' - - - - - - - - - - - - -
     ' -   Trafego de Projeto  -
     ' -      (Subrotina)      -
     ' - - - - - - - - - - - - -
       NPA = 0
       PER = INT(PERIODO)
       FOR IAA = 1 TO PER
           NPA = NPA + (FatorTraf ^ IAA)
       NEXT IAA
       NPA = NPA + (FatorTraf ^ (PERIODO - PER))
       NPA = NPA * NYEAR / 1000000!
       RETURN

6900 ' - - - - - - - - - - - - - - - - - - - -
     ' -   Irregularidade apos Recapeamento  -
     ' -        (Subrotina do HDM-III)       -
     ' -   Dados: HR, HC, QIest, QI0adm      -
     ' -   Saida: QIest                      -
     ' - - - - - - - - - - - - - - - - - - - -
       IF QIest > 19 THEN
                          QIB = 19! + ((QIest - 19!) / (.602 * HC + 1))
       ELSE
                          QIB = QIest
       END IF
       IF QI0adm > 0 THEN
                          DQI = QI0adm - QIB
       ELSE
                          H0 = 10 * HR
                          IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
                          IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
                          IF H0 < 40 THEN X = H0 ELSE X = 40
                          HOV = 3 - ((H0L + X) / 40)
                          X1 = 19.42 - .78 * QIBL - .068 * H0
                          IF H0 > 20 THEN Y = H0 - 20 ELSE Y = 0
                          X2 = -19.5 - .008 * QIBL * Y
                          IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
                          IF DQI > 0 THEN DQI = 0
       END IF
       QIest = QIB + DQI
       RETURN



3000 ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -      Evolucao da Condicao do Pavimento apos um Ano    -
     ' -                      (Subrotina)                      -
     ' -  Dados: H1REV, SN, Nacum, CBRSL, PSI, IRI0(IFaixa),   -
     ' -         ALPHA(IFaixa), Nano, QImed, HRef(IFaixa),     -
     ' -         IRec(IFaixa)                                  -
     ' -  Saida: PSI, QImed                                    -
     ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
       
       DELTAT = 1
       NYEAR = Nano(IFaixa) / 1000000!
    
       ' Evolucao do PSI:
         DELTAN = DELTAT * NYEAR
         PT = 2.5
         DPSI = PSInovo(IFaixa) - PT
         IF IRec(IFaixa) = 0 THEN
              
            MR = 100 * CBRSL / .0703
            VRmax = 25
            VRmin = 2
            BETA = .4 + (1094 / ((SN(IFaixa) + 1) ^ 5.19))
            W18# = (((SN(IFaixa) + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo(IFaixa) / 5))
            ALFA = ALFAA * ALPHA(IFaixa)
            DeltaPSI = ALFA * DELTAN * PSI * LOG(PSI / 5)
         
         ELSE

            IF UltCamada$(IFaixa) = "CBUQ" THEN
                 VRmax = 25
                 VRmin = 2
                 SNrecap = .44 * HRef(IFaixa) / 2.54
                 MR = MRfound(IFaixa) / .0703
                 BETA = .4 + (1094 / ((SNrecap + 1) ^ 5.19))
                 W18# = (((SNrecap + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                 W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
                 ALFAA = (1 / W18#) * LOG(LOG(2.5 / 5) / LOG(PSInovo(IFaixa) / 5))
                 ALFA = ALFAA * ALPHA(IFaixa)
                 DeltaPSI = ALFA * DELTAN * PSI * LOG(PSI / 5)
            ELSE
                 VRmax = 12
                 VRmin = 1
                 DeltaPSI = -(A0rest(IRodov) + B0rest(IRodov) * D0(IFaixa)) * DELTAN
            END IF

         END IF
         dPSIdtmin = 2! / VRmax
         dPSIdtmax = 2! / VRmin
         DPSImin = dPSIdtmin * DELTAT
         DPSImax = dPSIdtmax * DELTAT
         IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
         IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
         ' Evolucao da Irregularidade:
           IF PSI < 1.5 THEN PSIcrit = 1.5 ELSE PSIcrit = PSI
           DQI = -71.5 * DeltaPSI / PSIcrit
           QImed(IFaixa) = QImed(IFaixa) + DQI
         PSI = PSI + DeltaPSI
         IF PSI < 1 THEN PSI = 1

     RETURN


6500 ' - - - - - - - - - - - - - - - - - - - - - - - -
     ' -    Calculo da Vida Residual do Pavimento    -
     ' -                 (Subrotina)                 -
     ' -  Dados: PSI, PSIf, ALPHA(IFaixa), QIest     -
     ' -  Saida: VR                                  -
     ' - - - - - - - - - - - - - - - - - - - - - - - -
       DELTAT = .1
       NYEAR = Nano(IFaixa) / 1000000!
       IF UltCamada$(IFaixa) = "CBUQ" THEN
          VRmax = 25
          VRmin = 2
          dPSIdtmin = 2! / VRmax
          dPSIdtmax = 2! / VRmin
          DPSImin = dPSIdtmin * DELTAT
          DPSImax = dPSIdtmax * DELTAT
          DPSI = PSInovo(IFaixa) - 2.5
          IF HrecExist(IFaixa) = 0 THEN
                 BETA = .4 + (1094 / ((SN(IFaixa) + 1) ^ 5.19))
                 MR = 100 * CBRSL / .0703
                 W18 = (((SN(IFaixa) + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                 W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
          ELSE
                 SNrecap = .44 * HRef(IFaixa) / 2.54
                 MR = MRfound(IFaixa) / .0703
                 BETA = .4 + (1094 / ((SNrecap + 1) ^ 5.19))
                 W18 = (((SNrecap + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                 W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
          END IF
          ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSInovo(IFaixa) / 5))
          ALFA = ALFAA * ALPHA(IFaixa)

          VR = 0
          PSIatual = PSI
          IF PSIatual > PSIf THEN
             WHILE (PSIatual > PSIf AND VR < VRmax AND QIest < QIcrit)
                   VR = VR + DELTAT
                   DELTAN = DELTAT * NYEAR * (FatorTraf ^ VR)
                   DeltaPSI = ALFA * DELTAN * PSIatual * LOG(PSIatual / 5)
                   IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
                   IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
                   PSIatual = PSIatual + DeltaPSI
                   IF PSIatual < 1.5 THEN PSIcrit = 1.5 ELSE PSIcrit = PSIatual
                   DQI = -71.5 * DeltaPSI / PSIcrit
                   QIest = QIest + DQI
             WEND
          END IF
       ELSE
              VRmax = 7
              VRmin = 1
              dPSIdtmin = 2! / VRmax
              dPSIdtmax = 2! / VRmin
              DPSImin = dPSIdtmin * DELTAT
              DPSImax = dPSIdtmax * DELTAT
              VR = 0
              PSIatual = PSI
              IF PSIatual > PSIf THEN
                 DELTAN = DELTAT * NYEAR * (FatorTraf ^ VR)
                 WHILE (PSIatual > PSIf AND VR < VRmax)
                       VR = VR + DELTAT
                       DeltaPSI = -(A0rest(IRodov) + B0rest(IRodov) * D0(IFaixa)) * DELTAN
                       IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
                       IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
                       PSIatual = PSIatual + DeltaPSI
                 WEND
              END IF
       END IF
       IF VR = DELTAT THEN VR = 0
       RETURN


1200 ' - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -       Necessidades de Reforco Estrutural      -
     ' -                  (Subrotina)                  -
     ' -  Dados: H1, HT, CBRSL, NYEAR, PP, DC, QI      -
     ' -  Saida: HRDP, HRTR, H1TR, H2DP, HRMPD         -
     ' - - - - - - - - - - - - - - - - - - - - - - - - -
    
     ' Espessura de reforco efetiva existente
       IF Restaurado$(IFaixa) = "Sim" THEN
              FCovl = FCrecap
       ELSE
              IF IRec(IFaixa) = 1 THEN
                     IF ICalib(IFaixa) = 1 THEN
                            FCovl = ALPHA(IFaixa)
                     ELSE
                            FCovl = FCrecaprede(IRodov)
                     END IF
              ELSE
                     FCovl = FCrecaprede(IRodov)
              END IF
       END IF
       P = 4100 / (PI# * 30 * 30 / 4)
       E = 2 * (1 - .33 * .33) * P * (30 / 2) / (DC / 1000)
       MR = E / .0703
       A1 = .44
       IF VR > 0 THEN
          PERIODO = VR
          GOSUB 6700
          SNP = A1 * .5 / 2.54
          NP = 0
          WHILE NP < NPA
                SNP = SNP + .05
                HRmodel = 2.54 * SNP / A1
                QIest = QI
                HR = HRmodel
                HC = 0
                GOSUB 6900
                QID = QIest
                PSIQI = 5 * EXP(-QID / 71.5)
                PSR = 5
                PSI0 = (PSIQI + PSR) / 2
                IF PSI0 > 4.95 THEN PSI0 = 4.95
                DPSI = PSI0 - 2.5
                IF DPSI > 0 THEN
                   BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                   W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                   W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
                   ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
                   ALFA = ALFAA * FCovl
                   NP = (1 / ALFA) * LOG(LOG(PSIf / 5) / LOG(PSI0 / 5))
                END IF
          WEND
          Heff(IFaixa) = HRmodel
       ELSE
          Heff(IFaixa) = 0
       END IF

     ' Espessura de reforco em CBUQ requerida pelo modelo de previsao de desempenho
       PERIODO = PP
       GOSUB 6700
       SNP = A1 * .5 / 2.54
       NP = 0
       WHILE NP < NPA
             SNP = SNP + .05
             HRmodel = 2.54 * SNP / A1
             HR = HRmodel
             HC = 0
             QIest = QI
             GOSUB 6900
             PSI0 = (5 * EXP(-QIest / 71.5) + 5) / 2
             IF PSI0 > 4.95 THEN PSI0 = 4.95
             DPSI = PSI0 - 2.5
             IF DPSI > 0 THEN
                BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
                ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
                ALFA = ALFAA * FCrecap
                NP = (1 / ALFA) * LOG(LOG(PSIf / 5) / LOG(PSI0 / 5))
             END IF
       WEND
       HRMPD = HRmodel
       IF HRMPD < 0 THEN HRMPD = 0
       IF UltCamada$(IFaixa) = "CCP" THEN
               HRreflex = 1.364 * PP
               IF HRreflex > HRMPD THEN HRMPD = HRreflex
       END IF

       ' Revestimento requerido pelo Metodo do DNER
         NPUSACE = 3 * NPA
         H1TR = 4.4608 + 2.131 * LOG(NPUSACE)
         IF H1TR < HRmin THEN H1TR = HRmin
         HRTR = H1TR - H1
         IF HRTR < 0 THEN HRTR = 0
       ' Camada de Base pelo modelo de previsao de desempenho
         SNP = .5
         NP = 0
         WHILE NP < NPA
               SNP = SNP + .05
               PSI0 = (5 * EXP(-15 / 71.5) + 5) / 2
               DPSI = PSI0 - 2.5
               IF DPSI > 0 THEN
                  MR = 100 * CBRSL / .0703
                  BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                  W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                  W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
                  ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
                  ALFA = ALFAA * FCnovo
                  NP = (1 / ALFA) * LOG(LOG(PSIf / 5) / LOG(PSI0 / 5))
               END IF
         WEND
         H2DP = (2.54 * SNP - .44 * H1TR) / .14
         IF H2DP < 12 THEN H2DP = 12

       ' Espessura de recapeamento requerida para eliminar ATR
         ATRadm = 1
         IF ATRmed > ATRadm THEN
               Nrecaps = LOG(ATRadm / ATRmed) / LOG(.15)
               IF Nrecaps < 1 THEN
                    NR = 1
               ELSE
                    NR = Nrecaps - INT(Nrecaps)
                    IF NR > .2 THEN NR = INT(Nrecaps) + 1 ELSE NR = INT(Nrecaps)
               END IF
         ELSE
               NR = 0
         END IF
         HRatr = NR * HRmin

    RETURN



1700 ' - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -     Espessura de reforco efetiva existente    -
     ' -                  (Subrotina)                  -
     ' - - - - - - - - - - - - - - - - - - - - - - - - -
       A1 = .44
       IF VR > 0 THEN
          IPER = INT(VR)
          NANO = NYEAR / 1000000!
          IF VR > 1 THEN
             NPA = NANO
             FOR IVR = 2 TO IPER
                 NANO = NANO * (1 + (FatorTraf / 100))
                 NPA = NPA + NANO
             NEXT IVR
             NPA = NPA + NANO * (VR - IPER)
          ELSE
             NPA = NANO * VR
          END IF
          SNP = A1 * .5 / 2.54
          NP = 0
          WHILE NP < NPA
                SNP = SNP + .01
                HRmodel = 2.54 * SNP / A1
                IF QI > 19 THEN
                                QId = 19 + ((QI - 19) / (.602 * HRmodel + 1))
                ELSE
                                QId = QI
                END IF
                PSIQI = 5 * EXP(-QId / 71.5)
                PSR = 5
                PSI0 = (PSIQI + PSR) / 2
                IF PSI0 > 4.95 THEN PSI0 = 4.95
                DPSI = PSI0 - 2.5
                IF DPSI > 0 THEN
                   B = 30
                   P = QREF / (PI# * B * B / 4)
                   E = 2 * (1 - .33 * .33) * P * (B / 2) / (D0(IFaixa) / 1000)
                   MR = E / .0703
                   BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                   W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                   W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
                   ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
                   ALFA = ALFAA * FChr
                   NP = (1 / ALFA) * LOG(LOG(PSIf / 5) / LOG(PSI0 / 5))
                END IF
          WEND
          Heff(IFaixa) = HRmodel
       ELSE
          Heff(IFaixa) = 0
       END IF
       RETURN


6000 ' - - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -      Calculo da Vida Residual do Pavimento      -
     ' -                   (Subrotina)                   -
     ' -  Dados: PSI, PSIf, ALFAG, NYEAR, Age, QI        -
     ' -  Saida: VR, IVR                                 -
     ' - - - - - - - - - - - - - - - - - - - - - - - - - -
       VR = 0
       DELTAT = .1
       IF REVEST$(IFaixa) = "CBUQ" THEN
             VRmax = 25
             VRmin = 3
       ELSE
             VRmax = 10
             VRmin = 2
       END IF
       ' VS em termos de PSI
       dPSIdtmin = 2! / VRmax
       dPSIdtmax = 2! / VRmin
       DPSImin = dPSIdtmin * DELTAT
       DPSImax = dPSIdtmax * DELTAT
       PSIatual = PSIat(ISTH, IFaixa)
       IF PSIatual > PSIf THEN
          WHILE (PSIatual > PSIf AND QI < QIcrit)
                VR = VR + DELTAT
                DELTAN = DELTAT * NYEAR * (FatorTraf ^ VR)
                SELECT CASE UltRest$(IFaixa)
                       CASE "TSS"
                                     JCP = 1
                                     DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
                       CASE "LAMA ASF.", "LAMA ASFALTICA"
                                     JCP = 2
                                     DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
                       'CASE "MICROCA", "MICRO CA"
                       '              JCP = 6
                       '              DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
                       '              DeltaPSI = DeltaPSI * 1.2 / HrecExist(IFaixa)
                       CASE "TSD"
                                     JCP = 7
                                     DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
                       CASE "CP"
                                     JCP = 4
                                     DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
                       CASE "TST"
                                     JCP = 8
                                     DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
                       CASE "PMF"
                                     JCP = 3
                                     DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
                       CASE ELSE
                                     DeltaPSI = ALFAG * DELTAN * PSIatual * LOG(PSIatual / 5)
                END SELECT
                IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
                IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
                PSIatual = PSIatual + DeltaPSI
                IF PSIatual < 1.5 THEN PSIcrit = 1.5 ELSE PSIcrit = PSIatual
                DQI = -71.5 * DeltaPSI / PSIcrit
                QI = QI + DQI
          WEND
       END IF
       IF VR = DELTAT THEN VR = 0
       IF (Age > 0 AND Age < VRmax) THEN VRmax = VRmax - Age
       IF VR > VRmax THEN
                          VR = VRmax
                          IVR = 1
       ELSE
                          IVR = 0
       END IF
       RETURN


6800 ' - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -  Modulo de Elasticidade da Camada Subjacente  -
     ' -                  (Subrotina)                  -
     ' - - - - - - - - - - - - - - - - - - - - - - - - -
       B = 15
       P = QREF / (PI# * B * B)
       'DCantigo = D0(IFaixa) * 10 ^ (HrecExist(IFaixa) / 40)
       'E = 2 * (1 - .35 * .35) * P * B / (DCantigo / 1000)
       EP = 30000
       ERROABS = 100
       MR = 1000
       WHILE ERROABS > 1!
             DELTA = 1 + ((HrecExist(IFaixa) / B) * ((EP / MR) ^ (1 / 3))) ^ 2
             DELTA = 1 / (MR * (DELTA ^ (1 / 2)))
             BLOC = (1 - (1 / ((1 + ((HrecExist(IFaixa) / B) ^ 2)) ^ .5))) / EP
             DELTA = 1.5 * P * B * (DELTA + BLOC)
             DELTA = 1000 * DELTA
             ERRO = (DELTA - D0(IFaixa)) / D0(IFaixa)
             FATOR = 1 + .3 * ERRO
             MR = MR * FATOR
             ERROABS = 100 * ABS(ERRO)
       WEND
       E = MR
       RETURN

