CLS

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Definicao de PSI dada pelo usuario
OPEN "DEFPSI.DAT" FOR INPUT AS #1
INPUT #1, DEFPSI
CLOSE #1

' Fatores de Calibracao do Modelo AASHTO-HDM
OPEN "FcAASHTOHDM.csv" FOR INPUT AS #1
LINE INPUT #1, LINHA$
INPUT #1, Tipo$, FcPavNovoPSISL, FcPavNovoPSISB, FcPavNovoPSIBS, CfRecapPSI
INPUT #1, Tipo$, FcPavNovoSCISL, FcPavNovoSCISB, FcPavNovoSCIBS, CfRecapSCI
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4
DIM CustoP(NRODOV), ConserP(NRODOV), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
DIM Revest$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
DIM FCnovorede(NRODOV), FCrecaprede(NRODOV), FCmicroCA(NRODOV), FX(NFaixasMax)
DIM FC0novorede(NRODOV), FC0recaprede(NRODOV), FC0microCA(NRODOV)
DIM FC2novorede(NRODOV), FC2recaprede(NRODOV), FC2microCA(NRODOV)
DIM HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax), RepPerct(NFaixasMax)
DIM ICalib(NFaixasMax), Trecho$(NRODOV), D0(NFaixasMax), MRfound(NFaixasMax)
DIM PSIacost(NFaixasMax), DegrauAcost(NFaixasMax), MedidaAcost$(NFaixasMax)
DIM HRAC(NFaixasMax), H2AC(NFaixasMax), CustoAcost(NFaixasMax), CTotal(NRODOV)
DIM MatCP$(NRODOV), HRCP(NRODOV), CamadaRest$(NRODOV), A0rest(NRODOV)
DIM A2rest(NRODOV), A1rest(NRODOV), RLcost(NFaixasMax), SErest(NRODOV)

' Funcao densidade de probabilidade para Fc
DIM Nc(4), NQI(4), NS(4)
Nc(1) = 50: NS(1) = 0: NQI(1) = 0
Nc(2) = 85: NS(2) = 1.04: NQI(2) = 1.08
Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.6038
Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.35

' Modelo do Guia da AASHTO
NZR = 18
DIM NG(NZR), RLB(NZR)
NG(1) = 0: RLB(1) = 50
NG(2) = .253: RLB(2) = 60
NG(3) = .524: RLB(3) = 70
NG(4) = .674: RLB(4) = 75
NG(5) = .841: RLB(5) = 80
NG(6) = 1.037: RLB(6) = 85
NG(7) = 1.282: RLB(7) = 90
NG(8) = 1.34: RLB(8) = 91
NG(9) = 1.405: RLB(9) = 92
NG(10) = 1.476: RLB(10) = 93
NG(11) = 1.555: RLB(11) = 94
NG(12) = 1.645: RLB(12) = 95
NG(13) = 1.751: RLB(13) = 96
NG(14) = 1.881: RLB(14) = 97
NG(15) = 2.054: RLB(15) = 98
NG(16) = 2.327: RLB(16) = 99
NG(17) = 3.09: RLB(17) = 99.9
NG(18) = 3.75: RLB(18) = 99.99

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Leitura dos codigos numericos que identificam os Subtrechos Homogeneos:
DIM Code(NRODOV, NSTHMAX), NSTHI(NRODOV)
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "CODE" + Rodov$(I) + ".STH"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, NSTHI(I)
    FOR J = 1 TO NSTHI(I)
        INPUT #1, Code(I, J)
    NEXT J
    CLOSE #1
NEXT I

' Arquivo de configuracao do problema a ser analisado:
ARQUIVO$ = CALC$ + "DadoEstr.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
INPUT #1, PP
INPUT #1, PPmax
INPUT #1, NPP
INPUT #1, inflacao
CLOSE #1
ARQUIVO$ = CALC$ + "VRMIN.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, VRminFinal
INPUT #1, DeflexMax
INPUT #1, AnoDeflexMax
CLOSE #1

' Modelos de previsao de desempenho para conserva pesada
ARQUIVO$ = CALC$ + "CPtrecho.csv"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR IRodov = 1 TO NRODOV
    INPUT #1, TrechoDescr$, MatCP$(IRodov), HRCP(IRodov)
    ARQUIVO$ = PROGRAMA$ + "MODELOS.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #2
    INPUT #2, NMODELOS
    FOR J = 1 TO NMODELOS
        INPUT #2, CRest$
        INPUT #2, A0
        INPUT #2, A1
        INPUT #2, A2
        INPUT #2, Se
        IF CRest$ = MatCP$(IRodov) THEN
            CamadaRest$(IRodov) = CRest$
            A0rest(IRodov) = A0
            A1rest(IRodov) = A1
            A2rest(IRodov) = A2
            SErest(IRodov) = Se
        END IF
    NEXT J
    CLOSE #2
NEXT IRodov
CLOSE #1

' Fatores de calibracao medios da rede
ARQUIVO$ = CALC$ + "CALIB.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FCnovorede(I), FCrecaprede(I), FCmicroCA(I)
NEXT I
INPUT #1, Rede$, FCnovo, FCrecap, FCmicro
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB0.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FC0novorede(I), FC0recaprede(I), FC0microCA(I)
NEXT I
INPUT #1, Rede$, FC0novo, FC0recap, FC0micro
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB2.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FC2novorede(I), FC2recaprede(I), FC2microCA(I)
NEXT I
INPUT #1, Rede$, FC2novo, FC2recap, FC2micro
CLOSE #1

' Percentagem da area que deve receber reparos localizados (CL)
DIM PSIitemCL(15), ARepCL(15)
ARQUIVO$ = CALC$ + "REPAROS.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
NitensCL = 0
WHILE NOT EOF(1)
    NitensCL = NitensCL + 1
    INPUT #1, PSIitemCL(NitensCL), ARepCL(NitensCL)
WEND
CLOSE #1

' Parametros para medir o desempenho das estrategias (Ocorrencias em %) e
' criterio para Priorizacao das Restauracoes sob Restricoes Orcamentarias
ARQUIVO$ = CALC$ + "PARAM.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, PSIref
INPUT #1, PTRAF
INPUT #1, PPSI
INPUT #1, Nconf
INPUT #1, QIref
INPUT #1, IGGref
INPUT #1, ATRref
INPUT #1, TRref
CLOSE #1

' Criterios complementares para as arvores de decisao
ARQUIVO$ = CALC$ + "CRITERIO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TRcrit
INPUT #1, QIcrit
INPUT #1, ATRcrit
INPUT #1, ATRITOcrit
INPUT #1, UsaModulos$
INPUT #1, IGGcrit
INPUT #1, IdadeMin
CLOSE #1
SCIcrit = (309.22 - 0.616 * IGGcrit) / (61.844 + IGGcrit)

ARQUIVO$ = CALC$ + "S0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, GrauTraf$
CLOSE #1
SELECT CASE GrauTraf$
    CASE "Alto": S0mpd = .5
    CASE "Baixo": S0mpd = .3
    CASE ELSE: S0mpd = .4
END SELECT

' Constantes
PI# = 3.141592654#

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), VRmed(NPeriodos)
DIM Idade(NFaixasMax), PSIat(7000, NFaixasMax), Nano(NFaixasMax)
DIM RestrAnual(NPeriodos), RestrPolo(NRODOV, NPeriodos), IPRIOR(7000, NFaixasMax)
DIM PSImed(NPeriodos), Aream2(7000, NFaixasMax), CustoFaixa(NFaixasMax)
DIM MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax), AreaAcost(7000, NFaixasMax)
DIM PSImedSTH(7000), Npsi(NPeriodos), NFaixas(7000)
DIM IRI0(NFaixasMax), ALPHA(NFaixasMax), CustoPolo(NRODOV, NPeriodos)
DIM EXECF(7000, NFaixasMax), NewRestP(NRODOV), CustoCLP(NRODOV), Deficit(NPeriodos)
DIM IPMAXPolo(NRODOV), STHPRIPolo(NRODOV), CostPr(NRODOV), CUSTOT(NPeriodos)
DIM PPrest(NRODOV + 1, NPeriodos), PSIrest(NRODOV + 1, NPeriodos), QIrest(NRODOV + 1, NPeriodos)

SELECT CASE MODO
    CASE 1
        RedeRestric$ = "Para toda a rede"
        FOR I = 1 TO NPeriodos
            RestrAnual(I) = 1E+30
        NEXT I
        VSMIN = PP
        ARQ$ = "EB"
    CASE 2
        ARQUIVO$ = CALC$ + "RESTRIC.DAT"
        OPEN ARQUIVO$ FOR INPUT AS #8
        LINE INPUT #8, RedeRestric$
        CLOSE #8
        IF RedeRestric$ = "Para toda a rede" THEN
            ARQUIVO$ = CALC$ + "ROrede.csv"
            OPEN ARQUIVO$ FOR INPUT AS #8
            LINE INPUT #8, LINHA$
            FOR I = 1 TO NPeriodos
                INPUT #8, ANO, RestrAnual(I), PPrest(0, I), PSIrest(0, I), QIrest(0, I)
            NEXT I
            CLOSE #8
        ELSE
            FOR IRodov = 1 TO NRODOV
                ARQUIVO$ = CALC$ + "ROtre" + Rodov$(IRodov) + ".csv"
                OPEN ARQUIVO$ FOR INPUT AS #8
                LINE INPUT #8, LINHA$
                FOR I = 1 TO NPeriodos
                    INPUT #8, ANO, RestrPolo(IRodov, I), PPrest(IRodov, I), PSIrest(IRodov, I), QIrest(IRodov, I)
                NEXT I
                CLOSE #8
            NEXT IRodov
        END IF
        ARQ$ = "RO"
    CASE ELSE
        PRINT "ERRO"
END SELECT
ARQUIVO$ = CALC$ + ARQ$ + ".CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #14
WRITE #14, "Ano", "STH", "Iniciokm", "Finalkm", "AcostLE", "HRLE", "H2LE", "MedidaF1", "Hfrescm1", "HReccm1", "MedidaF2", "Hfrescm2", "HReccm2", "MedidaF3", "Hfrescm3", "HReccm3", "MedidaF4", "Hfrescm4", "HReccm4", "AcostLD", "HRLD", "H2LD"

CLS
PRINT
PRINT "                        * * * * * * * * * * * * *  "
PRINT "                        *  GERA AS ESTRATEGIAS  *  "
PRINT "                        * * * * * * * * * * * * *  "
PRINT

PRINT "- Primeiro ano para aplicar apenas camadas delgadas ( 1 a "; NPeriodos; ") = "
INPUT AnoDelgada1
PRINT "- Ultimo ano para aplicar apenas camadas delgadas ( 1 a "; NPeriodos; ") = "
INPUT AnoDelgada2
INPUT "- Tipo de CBUQ a ser adotado (Conv/Pol/AB) = "; UsaCBUQpol$
UsaCBUQpol$ = UCASE$(UsaCBUQpol$)
PRINT "- Ano a partir do qual muda o valor de Nc ( 2 a "; NPeriodos; ") = "
INPUT AnoNovoNc
IF (AnoNovoNc > 1 AND AnoNovoNc <= NPeriodos) THEN
    INPUT "- Novo valor de Nc (%) = "; NcNovo
ELSE
    NcNovo = Nconf
END IF
PRINT

' Parametros para o Indice de Prioridade (gerados em Estrat1.bas)
ARQUIVO$ = CALC$ + "IP.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, VDMmin, VDMmax
INPUT #1, PSIminRede, PSImaxRede
CLOSE #1

ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ANO = 0
ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #13

ISTH = 0
FOR IRodov = 1 TO NRODOV

    ARQUIVO$ = CALC$ + ARQ$ + "CT" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #15
    WRITE #15, "ANO", "STH", "KMI", "KMF", "Custo", "Custo1", "Custo2", "Custo3", "Custo4", "Acost"
    CLOSE #15
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFaixas(ISTH)
            INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), Nacum(IFX), Revest$(IFX), ALFAIGG(IFX)
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
        NEXT IFaixa
        WRITE #13, STH, KMI, KMF
        FOR IFX = 1 TO NFaixas(ISTH)
            Restaurado$(IFX) = "Nao"
            IF Revest$(IFX) = "CCP" THEN
                UltCamada$(IFX) = "CCP"
                HRef(IFX) = H1REV(IFX)
            ELSE
                UltCamada$(IFX) = "CBUQ"
                HRef(IFX) = HrecExist(IFX)
            END IF
            GOSUB 700
        NEXT IFX
    NEXT ISUB

NEXT IRodov
GOSUB 800

' * * * * * * * * * * * * *
' * Geracao da Estrategia *
' * * * * * * * * * * * * *

FOR ANO = 1 TO NPeriodos

    PRINT "                   Ano = "; ANO
    ANOcal = ANOBASE + ANO
    CustoTotal = 0
    CustoConserva = 0
    PSImed(ANO) = 0
    VRmed(ANO) = 0
    FOR IPole = 1 TO NRODOV
        CustoP(IPole) = 0
        ConserP(IPole) = 0
    NEXT IPole
    TotalArea = 0
    NUnid = 0

    IF ANO >= AnoNovoNc THEN Nconf = NcNovo
    IF Nconf <= Nc(2) THEN
        I1 = 1: I2 = 2
    ELSE
        IF Nconf <= Nc(3) THEN
            I1 = 2: I2 = 3
        ELSE
            I1 = 3: I2 = 4
        END IF
    END IF
    NpsiMod = ((Nc(I2) * NS(I1) - Nc(I1) * NS(I2)) + Nconf * (NS(I2) - NS(I1))) / (Nc(I2) - Nc(I1))
    Ngauss = ((Nc(I2) * NS(I1) - Nc(I1) * NS(I2)) + Nconf * (NS(I2) - NS(I1))) / (Nc(I2) - Nc(I1))
    Niri = ((Nc(I2) * NQI(I1) - Nc(I1) * NQI(I2)) + Nconf * (NQI(I2) - NQI(I1))) / (Nc(I2) - Nc(I1))

    IF Nconf > 50 THEN
        IF Nconf <= RLB(2) THEN
            I1 = 1: I2 = 2
        ELSE
            IF Nconf <= RLB(3) THEN
                I1 = 2: I2 = 3
            ELSE
                IF Nconf <= RLB(4) THEN
                    I1 = 3: I2 = 4
                ELSE
                    IF Nconf <= RLB(5) THEN
                        I1 = 4: I2 = 5
                    ELSE
                        IF Nconf <= RLB(6) THEN
                            I1 = 5: I2 = 6
                        ELSE
                            IF Nconf <= RLB(7) THEN
                                I1 = 6: I2 = 7
                            ELSE
                                IF Nconf <= RLB(8) THEN
                                    I1 = 7: I2 = 8
                                ELSE
                                    IF Nconf <= RLB(9) THEN
                                        I1 = 8: I2 = 9
                                    ELSE
                                        IF Nconf <= RLB(10) THEN
                                            I1 = 9: I2 = 10
                                        ELSE
                                            IF Nconf <= RLB(11) THEN
                                                I1 = 10: I2 = 11
                                            ELSE
                                                IF Nconf <= RLB(12) THEN
                                                    I1 = 11: I2 = 12
                                                ELSE
                                                    IF Nconf <= RLB(13) THEN
                                                        I1 = 12: I2 = 13
                                                    ELSE
                                                        IF Nconf <= RLB(14) THEN
                                                            I1 = 13: I2 = 14
                                                        ELSE
                                                            IF Nconf <= RLB(15) THEN
                                                                I1 = 14: I2 = 15
                                                            ELSE
                                                                IF Nconf <= RLB(16) THEN
                                                                    I1 = 15: I2 = 16
                                                                ELSE
                                                                    IF Nconf <= RLB(17) THEN
                                                                        I1 = 16: I2 = 17
                                                                    ELSE
                                                                        I1 = 17: I2 = 18
                                                                    END IF
                                                                END IF
                                                            END IF
                                                        END IF
                                                    END IF
                                                END IF
                                            END IF
                                        END IF
                                    END IF
                                END IF
                            END IF
                        END IF
                    END IF
                END IF
            END IF
        END IF
        ZRmpd = ((RLB(I2) * NG(I1) - RLB(I1) * NG(I2)) + Nconf * (NG(I2) - NG(I1))) / (RLB(I2) - RLB(I1))
    ELSE
        ZRmpd = 0
    END IF

    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO - 1) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12
    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #13

    ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #10

    ISTH = 0
    FOR IRodov = 1 TO NRODOV

        ARQUIVO$ = CALC$ + "Cadas" + Rodov$(IRodov) + ".dat"
        OPEN ARQUIVO$ FOR INPUT AS #2
        LINE INPUT #2, LINHA$

        IPolo = IRodov
        ' Parametros que definem as Arvores de Decisao:
        ARQUIVO$ = CALC$ + "ARV" + Rodov$(IRodov) + ".dat"
        OPEN ARQUIVO$ FOR INPUT AS #1
        INPUT #1, IDScrit
        INPUT #1, PSRcrit
        INPUT #1, HRmin
        INPUT #1, HRmax
        INPUT #1, PSIt
        INPUT #1, DEGRAUadm
        INPUT #1, HCmin
        INPUT #1, HCMAXgeral
        INPUT #1, VUMin
        INPUT #1, QI0adm
        INPUT #1, HbaseAcost
        INPUT #1, RepFres
        INPUT #1, TipoRevAcost$
        INPUT #1, SART$
        CLOSE #1
        SELECT CASE SART$
            CASE "MF3"
                HRMF = 3
            CASE "MF4"
                HRMF = 4
            CASE ELSE
                HRMF = 2
        END SELECT
        PSIf = PSIt
        IF MODO = 2 THEN
            IF RedeRestric$ = "Para toda a rede" THEN
                QIcrit = QIrest(0, ANO)
                IF PSIt <> PSIrest(0, ANO) THEN PSIf = PSIrest(0, ANO)
                VSMIN = PPrest(0, ANO)
            ELSE
                QIcrit = QIrest(IRodov, ANO)
                IF PSIt < PSIrest(IRodov, ANO) THEN PSIf = PSIrest(IRodov, ANO)
                VSMIN = PPrest(IRodov, ANO)
            END IF
        END IF
        IF VUMin < VSMIN THEN VUMin = VSMIN

        ' Estado de Superficie no Ano-Base
        NDADOS = 5
        FOR IFX = 1 TO NFaixasMax
            SELECT CASE IFX
                CASE 1: Faixa$ = "1"
                CASE 2: Faixa$ = "2"
                CASE 3: Faixa$ = "3"
                CASE 4: Faixa$ = "4"
                CASE ELSE: PRINT "ERRO"
            END SELECT
            ISUP = NDADOS + IFX
            ARQUIVO$ = CALC$ + "SUP" + Rodov$(IRodov) + Faixa$ + ".DAT"
            OPEN ARQUIVO$ FOR INPUT AS #ISUP
        NEXT IFX

        FOR ISUB = 1 TO NSTHRODOV(IRodov)

            ISTH = ISTH + 1

            INPUT #2, Subtrecho$, Rodov$, INI$, FIM$, KMI, KMF, PISTA$
            INPUT #2, NFX, PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
            INPUT #2, GEOVERT$, GEOHORIZ$, SECTIPO$, FX(1), FX(2), FX(3), FX(4), DECTRA, RESTR, ExtPontes, OBS$
            PISTA$ = UCASE$(PISTA$)

            ' Inicializacao de parametros a cada ano
            FOR IFaixa = 1 TO NFaixasMax
                MedidaF$(IFaixa) = ""
                Hfres(IFaixa) = 0
                Hrec(IFaixa) = 0
                CustoFaixa(IFaixa) = 0
                MedidaAcost$(IFaixa) = ""
                HRAC(IFaixa) = 0
                H2AC(IFaixa) = 0
                CustoAcost(IFaixa) = 0
            NEXT IFaixa
            PSImedSTH(ISTH) = 0

            INPUT #12, STH, KMI, KMF

            FOR IFaixa = 1 TO NFaixas(ISTH)
                GOSUB 600
                ' Indice de Prioridade
                IPSI = 100 * (PSImaxRede - PSIat(ISTH, IFaixa)) / (PSImaxRede - PSIminRede)
                ITRAF = 100 * (VDMUni(IFaixa) - VDMmin) / (VDMmax - VDMmin)
                IPRIOR(ISTH, IFaixa) = (PTRAF * ITRAF + PPSI * IPSI) / (PTRAF + PPSI)
            NEXT IFaixa

            ' Verifica alteracao de trafego devido a ampliacoes de pistas
            ARQUIVO$ = CALC$ + "Duplic.dat"
            OPEN ARQUIVO$ FOR INPUT AS #15
            WHILE NOT EOF(15)
                INPUT #15, STHampl, AnoAmplia, VDMc(1), VDMc(2), VDMc(3), VDMc(4)
                IF (STHampl = STH AND AnoAmplia = ANO) THEN
                    FOR IFaixa = 1 TO NFaixas(ISTH)
                        VDMUni(IFaixa) = VDMUni(IFaixa) / 2
                        Nano(IFaixa) = Nano(IFaixa) * (VDMc(IFaixa) / 100)
                    NEXT IFaixa
                END IF
            WEND
            CLOSE #15

            ' - - - - - - - - - - - - - - - - - - - - - - - - - -
            ' -  Evolucao da Condicao do Pavimento apos um Ano  -
            ' - - - - - - - - - - - - - - - - - - - - - - - - - -

            FOR IFaixa = 1 TO NFaixas(ISTH)

                Idade(IFaixa) = Idade(IFaixa) + 1
                Nano(IFaixa) = Nano(IFaixa) * FatorTraf
                Nacum(IFaixa) = Nacum(IFaixa) + Nano(IFaixa)
                VDMUni(IFaixa) = VDMUni(IFaixa) * FatorVDM
                IF Nano(IFaixa) <= 0 THEN
                    PRINT "Erro no trafego no trecho "; Rodov$(IRodov); ", subtrecho "; STH; " na faixa "; IFaixa
                END IF

                IF Idade(IFaixa) >= 0 THEN
                    VidaRes(IFaixa) = VidaRes(IFaixa) - 1
                    IF VidaRes(IFaixa) < 0 THEN VidaRes(IFaixa) = 0
                    PSI = PSIat(ISTH, IFaixa)
                    GOSUB 3000
                    PSIat(ISTH, IFaixa) = PSI
                    IF PSI <= PSIf THEN VidaRes(IFaixa) = 0
                    TR = TR23(IFaixa)
                    ATR = ATRmed(IFaixa)
                    PSIQIe = 5! * EXP(-QImed(IFaixa) / 71.5)
                    PSRest = 2 * PSIat(ISTH, IFaixa) - PSIQIe
                    IF PSRest < 0.5 THEN PSRest = 0.5
                    IGG = (309.22 - 61.844 * PSRest) / (PSRest + 0.616)
                    IF (PSI < PSIref OR QImed(IFaixa) > QIref OR IGG > IGGref OR ATR > ATRref OR TR > TRref) THEN
                        Npsi(ANO) = Npsi(ANO) + 1
                    END IF
                    PSImedSTH(ISTH) = PSImedSTH(ISTH) + PSIat(ISTH, IFaixa) * Aream2(ISTH, IFaixa)
                    VRmed(ANO) = VRmed(ANO) + Aream2(ISTH, IFaixa) * VidaRes(IFaixa)
                    TotalArea = TotalArea + Aream2(ISTH, IFaixa)
                    NUnid = NUnid + 1
                END IF

            NEXT IFaixa

            ' - - - - - - - - - - - - - - - - - - - - - - -
            ' - Necessidades de Manutencao da Rede no Ano -
            ' - - - - - - - - - - - - - - - - - - - - - - -

            Executa$ = "Sim"
            FOR IFaixa = 1 TO NFaixasMax

                ISUP = NDADOS + IFaixa
                IF IFaixa <= NFaixas(ISTH) THEN

                    Medida$ = ""
                    IF Idade(IFaixa) < 0 THEN Executa$ = "Nao"

                    ' Durabilidade esperada para a medida especificada como Conserva Pesada
                    MedCP$ = ""
                    MedCPbest$ = ""
                    DeltaT = .1
                    DeltaN = DeltaT * Nano(IFaixa) / 1000000!
                    ' Efeito dos reparos preliminares ao recapeamento
                    HR = 4
                    HC = HR
                    QIest = QImed(IFaixa)
                    GOSUB 6900
                    RedQI = QImed(IFaixa) - QIest
                    QIest = QImed(IFaixa) - (RepPerct(IFaixa) / 100) * RedQI

                    ' Medida tipo CP
                    HR = HRCP(IRodov)
                    HC = 0
                    GOSUB 300
                    IF VSCP >= VUMin THEN
                        MedCP$ = "CP"
                        MedCPbest$ = MedCP$
                    ELSE
                        ' Medida tipo FR+CP
                        HR = HRCP(IRodov)
                        HC = HR
                        QIest = QImed(IFaixa)
                        GOSUB 300
                        IF VSCP >= VUMin THEN
                            MedCP$ = "FR+CP"
                            MedCPbest$ = MedCP$
                        ELSE
                            ' Medida tipo MF+CP
                            HR = HRCP(IRodov) + HRMF
                            HC = 0
                            QIest = QImed(IFaixa)
                            GOSUB 300
                            IF VSCP >= VUMin THEN
                                IF SART$ <> "RSUP20" THEN
                                    MedCP$ = "MF+CP"
                                ELSE
                                    MedCP$ = "RSUP+CP"
                                END IF
                                MedCPbest$ = MedCP$
                            ELSE
                                IF SART$ <> "RSUP20" THEN
                                    MedCPbest$ = "MF+CP"
                                ELSE
                                    MedCPbest$ = "RSUP+CP"
                                END IF
                            END IF
                        END IF
                    END IF

                    ' Estado de Superficie no Ano-Base
                    INPUT #ISUP, SH$, KMINI, KMFIM, PSR, CR$, BL$, TT$
                    INPUT #ISUP, TL$, TE$, TB$, P$, D$, DS$
                    INPUT #ISUP, ER$, BF$, Dc$, R$, ATR$, COR$
                    INPUT #ISUP, EM$, DP$, EL$, PSRACOST, DEGRAUCM, OBS$, ATR

                    ' Solucoes Forcadas (impostas pelo usuario para o periodo de analise)
                    SELECT CASE IFaixa
                        CASE 1: FXX$ = "1"
                        CASE 2: FXX$ = "2"
                        CASE 3: FXX$ = "3"
                        CASE 4: FXX$ = "4"
                        CASE ELSE
                            PRINT "ERRO"
                    END SELECT
                    RLcost(IFaixa) = 0
                    ARQUIVO$ = CALC$ + "Sol" + Rodov$(IRodov) + FXX$ + ".csv"
                    OPEN ARQUIVO$ FOR INPUT AS #1
                    LINE INPUT #1, LINHA$
                    Achou$ = "Nao"
                    IPFORC = 1000
                    WHILE (EOF(1) = False AND Achou$ = "Nao")
                        INPUT #1, TrechoForc$, STHForc, AnoForc, MedForc$, HCForc, HRForc, RLm2, RLcost(IFaixa)
                        IF (STH = STHForc AND ANOcal = AnoForc) THEN
                            RLperct = RLm2 / Aream2(ISTH, IFaixa)
                            MedidaF$(IFaixa) = MedForc$
                            Hfres(IFaixa) = HCForc
                            Hrec(IFaixa) = HRForc
                            Medida$ = MedForc$
                            IPRIOR(ISTH, IFaixa) = IPFORC
                            IPFORC = IPFORC + 1
                            Achou$ = "Sim"
                            PSIat(ISTH, IFaixa) = PSIat(ISTH, IFaixa) + RLperct * (4.8 - PSIat(ISTH, IFaixa))
                            QImed(IFaixa) = QImed(IFaixa) + RLperct * (12 - QImed(IFaixa))
                        END IF
                    WEND
                    CLOSE #1
                    IF (Achou$ = "Sim" AND Medida$ = "Restaura") THEN Achou$ = "Nao"

                    Age = Idade(IFaixa)
                    PSI = PSIat(ISTH, IFaixa)
                    QI = QImed(IFaixa)
                    PSIQI = 5 * EXP(-QI / 71.5)
                    PSR = 2 * PSI - PSIQI
                    Nyear = Nano(IFaixa)
                    H1 = H1REV(IFaixa)
                    Dc = D0(IFaixa)
                    IDS = IGG(IFaixa)

                    IF Achou$ = "Nao" THEN

                        IF Age >= 0 THEN

                            ' Necessidade de reforco estrutural:
                            VR = VidaRes(IFaixa)
                            TempoRestante = NPeriodos - ANO
                            IF TempoRestante > VSMIN THEN
                                IF (Age >= 0 AND Age < 1) THEN PP = VSMIN ELSE PP = VSMIN - VR
                            ELSE
                                PP = TempoRestante + VRminFinal
                            END IF
                            IF PP < .5 THEN PP = .5
                            GOSUB 1200

                            ' Condiciona o uso de CP aos casos onde HR requerida  < HRmin
                            IF HRMPD >= HRmin THEN MedCP$ = ""

                            GOSUB 1000
                            IF HC > 0 THEN
                                RES = HC - INT(HC)
                                IF RES >= .5 THEN INCR = 1 ELSE INCR = 0
                                HC = INT(HC) + INCR
                            END IF
                            IF (HR > 0 AND Medida$ <> "CP" AND Medida$ <> "FR+CP" AND Medida$ <> "MF+CP" AND Medida$ <> "RSUP+CP" AND Medida$ <> "FR+MF+CP") THEN
                                IF UsaCBUQpol$ = "POL" THEN
                                    HR = 0.65 * HR
                                ELSE
                                    IF UsaCBUQpol$ = "AB" THEN HR = 0.7 * HR
                                END IF
                                IF HR < HRmin THEN
                                    HR = HRmin
                                ELSE
                                    RES = HR - INT(HR)
                                    IF RES >= .5 THEN INCR = 1 ELSE INCR = 0
                                    HR = INT(HR) + INCR
                                END IF
                            END IF

                        ELSE

                            Medida$ = "CR"
                            HR = 0
                            HC = 0

                        END IF

                        MedidaF$(IFaixa) = Medida$
                        Hfres(IFaixa) = HC
                        Hrec(IFaixa) = HR

                    END IF

                ELSE
                    LINE INPUT #ISUP, LINHA$
                END IF

                ' Evolucao da condicao dos acostamentos apos um ano
                IF PSIacost(IFaixa) > 0 THEN
                    PSIacost(IFaixa) = PSIacost(IFaixa) - .1
                    IF PSIacost(IFaixa) < 0 THEN PSIacost(IFaixa) = 0
                END IF

            NEXT IFaixa

            ' Compatibiliza a geometria entre as faixas de trafego (incluindo os acostamentos)
            IF Executa$ = "Sim" THEN GOSUB 8000
            RestSTH$ = "Nao"
            FOR IFaixa = 1 TO NFaixas(ISTH)
                RestSTH$ = "Sim"
                IF (MedidaF$(IFaixa) = "" OR MedidaF$(IFaixa) = "CR" OR MedidaF$(IFaixa) = "CL" OR MedidaF$(IFaixa) = "ST") THEN RestSTH$ = "Nao"
            NEXT IFaixa

            ' Solucoes Forcadas para os acostamentos
            FOR IFaixa = 1 TO NFaixas(ISTH)
                IF RestSTH$ = "Nao" THEN
                    MedidaAcost$(IFaixa) = "CR"
                    HRAC(IFaixa) = 0
                    H2AC(IFaixa) = 0
                END IF
                ARQUIVO$ = CALC$ + "AcosForc.csv"
                OPEN ARQUIVO$ FOR INPUT AS #1
                LINE INPUT #1, LINHA$
                WHILE EOF(1) = False
                    INPUT #1, TrechoForc$, STHForc, AnoForc, FaixaForc, MedForc$, HCForc, HRForc
                    IF (STH = STHForc AND ANOcal = AnoForc AND IFaixa = FaixaForc) THEN
                        MedidaAcost$(IFaixa) = MedForc$
                        HRAC(IFaixa) = HRForc
                        H2AC(IFaixa) = HCForc
                    END IF
                WEND
                CLOSE #1
            NEXT IFaixa

            ' Leitura dos Custos Unitarios
            GOSUB 500

            FOR IFaixa = 1 TO NFaixas(ISTH)

                Medida$ = MedidaF$(IFaixa)
                IF RLcost(IFaixa) = 0 THEN GOSUB 5000 ELSE Custo = RLcost(IFaixa)
                CustoFaixa(IFaixa) = Custo
                CustoTotal = CustoTotal + Custo
                IF (Medida$ = "" OR Medida$ = "CR" OR Medida$ = "CL" OR Medida$ = "ST") THEN
                    CustoConserva = CustoConserva + Custo
                    ConserP(IPolo) = ConserP(IPolo) + Custo
                END IF
                CustoP(IPolo) = CustoP(IPolo) + Custo

                ' Custo da Intervencao nos Acostamentos
                GOSUB 2000
                CustoAcost(IFaixa) = Custo * AreaAcost(ISTH, IFaixa)
                CustoTotal = CustoTotal + CustoAcost(IFaixa)
                CustoP(IPolo) = CustoP(IPolo) + CustoAcost(IFaixa)
                IF (MedidaF$(IFaixa) = "CR" OR MedidaF$(IFaixa) = "CL" OR MedidaF$(IFaixa) = "ST") THEN
                    CustoConserva = CustoConserva + CustoAcost(IFaixa)
                    ConserP(IPolo) = ConserP(IPolo) + CustoAcost(IFaixa)
                END IF

            NEXT IFaixa

            WRITE #13, STH, KMI, KMF
            FOR IFX = 1 TO NFaixas(ISTH)
                GOSUB 700
                WRITE #10, STH, CustoFaixa(IFX), MedidaF$(IFX), Hfres(IFX), Hrec(IFX), CustoAcost(IFX), MedidaAcost$(IFX), HRAC(IFX), H2AC(IFX)
            NEXT IFX

        NEXT ISUB

        FOR IFX = 1 TO NFaixasMax
            ISUP = NDADOS + IFX
            CLOSE #ISUP
        NEXT IFX
        CLOSE #2

    NEXT IRodov
    Deficit(ANO) = CustoTotal
    GOSUB 800
    CLOSE #4, #10

    ' - - - - - - - - - - - - - - - - - - - - - - -
    ' -  Define os Segmentos a serem Restaurados  -
    ' - - - - - - - - - - - - - - - - - - - - - - -
    IF RedeRestric$ = "Para toda a rede" THEN
        IF RestrAnual(ANO) >= CustoTotal THEN Prioriza$ = "Nao" ELSE Prioriza$ = "Sim"
        PRINT "                          R.O. = "; RestrAnual(ANO); "      Custo ="; CustoTotal
    ELSE
        Prioriza$ = "Nao"
        FOR IPole = 1 TO NRODOV
            IF RestrPolo(IPole, ANO) < CustoP(IPole) THEN Prioriza$ = "Sim"
        NEXT IPole
    END IF

    IF Prioriza$ = "Nao" THEN

        ' Todas as restauracoes necessarias serao executadas
        PRINT "                          Nao ha necessidade de priorizacao."
        ISTH = 0
        FOR IRodov = 1 TO NRODOV
            FOR ISUB = 1 TO NSTHRODOV(IRodov)
                ISTH = ISTH + 1
                FOR IFaixa = 1 TO NFaixas(ISTH)
                    EXECF(ISTH, IFaixa) = 1
                NEXT IFaixa
            NEXT ISUB
        NEXT IRodov

        CUSTOT(ANO) = CustoTotal
        FOR IPole = 1 TO NRODOV
            CustoPolo(IPole, ANO) = CustoP(IPole)
        NEXT IPole

    ELSE

        ' Deve ser aplicada a priorizacao para as restauracoes
        PRINT "                    Aplicando a priorizacao..."

        IF RedeRestric$ = "Para toda a rede" THEN
            NovaRestr = RestrAnual(ANO) - CustoConserva
        ELSE
            FOR IPole = 1 TO NRODOV
                NewRestP(IPole) = RestrPolo(IPole, ANO) - ConserP(IPole)
            NEXT IPole
        END IF
        CustoCL = 0!
        FOR IPole = 1 TO NRODOV
            CustoCLP(IPole) = 0
        NEXT IPole

        FOR ICONTROL = 1 TO 7
         
            CUSTOT(ANO) = CustoConserva
            TotalCost = CUSTOT(ANO) + CustoCL
            FOR IPole = 1 TO NRODOV
                CustoPolo(IPole, ANO) = ConserP(IPole)
                CTotal(IPole) = CustoPolo(IPole, ANO) + CustoCLP(IPole)
            NEXT IPole
            IF RedeRestric$ = "Para toda a rede" THEN
                IF TotalCost < RestrAnual(ANO) THEN
                    TERMINOU$ = "Nao"
                ELSE
                    TERMINOU$ = "Sim"
                END IF
            ELSE
                Conclude$ = "Sim"
                FOR IPole = 1 TO NRODOV
                    IF CTotal(IPole) < RestrPolo(IPole, ANO) THEN Conclude$ = "Nao"
                NEXT IPole
                IF Conclude$ = "Sim" THEN TERMINOU$ = "Sim" ELSE TERMINOU$ = "Nao"
            END IF

            ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
            OPEN ARQUIVO$ FOR INPUT AS #6
            ISTH = 0
            FOR IRodov = 1 TO NRODOV
                FOR ISUB = 1 TO NSTHRODOV(IRodov)
                    ISTH = ISTH + 1
                    FOR IFaixa = 1 TO NFaixas(ISTH)
                        INPUT #6, STH, CustoFaixa(IFaixa), MedidaF$(IFaixa), Hfres(IFaixa), Hrec(IFaixa), CustoAcost(IFaixa), MedidaAcost$(IFaixa), HRAC(IFaixa), H2AC(IFaixa)
                        Medida$ = MedidaF$(IFaixa)
                        IF (Medida$ = "CR" OR Medida$ = "CL" OR Medida$ = "ST") THEN
                            EXECF(ISTH, IFaixa) = 1
                        ELSE
                            EXECF(ISTH, IFaixa) = 0
                        END IF
                    NEXT IFaixa
                NEXT ISUB
            NEXT IRodov
            CLOSE #6

            WHILE TERMINOU$ = "Nao"

                ' Encontra o segmento de maxima prioridade
                IPMAX = 0
                STHPRIOR = 0
                FOR IPole = 1 TO NRODOV
                    IPMAXPolo(IPole) = 0
                    STHPRIPolo(IPole) = 0
                NEXT IPole
                ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
                OPEN ARQUIVO$ FOR INPUT AS #6
                ISTH = 0
                FOR IRodov = 1 TO NRODOV
                    IPolo = IRodov
                    FOR ISUB = 1 TO NSTHRODOV(IRodov)
                        ISTH = ISTH + 1
                        FOR IFaixa = 1 TO NFaixas(ISTH)
                            INPUT #6, STH, CustoFaixa(IFaixa), MedidaF$(IFaixa), Hfres(IFaixa), Hrec(IFaixa), CustoAcost(IFaixa), MedidaAcost$(IFaixa), HRAC(IFaixa), H2AC(IFaixa)
                        NEXT IFaixa
                        FOR IFaixa = 1 TO NFaixas(ISTH)
                            IF RedeRestric$ = "Para toda a rede" THEN
                                IF (IPRIOR(ISTH, IFaixa) > IPMAX AND EXECF(ISTH, IFaixa) = 0) THEN
                                    IPMAX = IPRIOR(ISTH, IFaixa)
                                    STHPRIOR = ISTH
                                    IPoloPrior = IPolo
                                    CustoPrior = 0
                                    FOR IFX = 1 TO NFaixas(ISTH)
                                        IF EXECF(ISTH, IFX) = 0 THEN
                                            CustoPrior = CustoPrior + CustoFaixa(IFX) + CustoAcost(IFX)
                                        END IF
                                    NEXT IFX
                                END IF
                            ELSE
                                IF (IPRIOR(ISTH, IFaixa) > IPMAXPolo(IPolo) AND EXECF(ISTH, IFaixa) = 0) THEN
                                    IPMAXPolo(IPolo) = IPRIOR(ISTH, IFaixa)
                                    STHPRIPolo(IPolo) = ISTH
                                    CostPr(IPolo) = 0
                                    FOR IFX = 1 TO NFaixas(ISTH)
                                        IF EXECF(ISTH, IFX) = 0 THEN
                                            CostPr(IPolo) = CostPr(IPolo) + CustoFaixa(IFX) + CustoAcost(IFX)
                                        END IF
                                    NEXT IFX
                                END IF
                            END IF
                        NEXT IFaixa
                    NEXT ISUB
                NEXT IRodov
                CLOSE #6

                ' Verifica se o segmento de maxima prioridade pode ser restaurado:
                IF RedeRestric$ = "Para toda a rede" THEN

                    IF STHPRIOR = 0 THEN
                        TERMINOU$ = "Sim"
                    ELSE
                        IF NovaRestr >= CustoPrior THEN
                            ' Aciona a restauracao:
                            NovaRestr = NovaRestr - CustoPrior
                            FOR IFX = 1 TO NFaixas(STHPRIOR)
                                EXECF(STHPRIOR, IFX) = 1
                            NEXT IFX
                            CUSTOT(ANO) = CUSTOT(ANO) + CustoPrior
                            CustoPolo(IPoloPrior, ANO) = CustoPolo(IPoloPrior, ANO) + CustoPrior
                        ELSE
                            ' Elimina o segmento prioritario neste ano, a fim de
                            ' se verificar se o proximo colocado deste ANO pode ser
                            ' restaurado:
                            FOR IFX = 1 TO NFaixas(STHPRIOR)
                                IPRIOR(STHPRIOR, IFX) = -1
                            NEXT IFX
                        END IF
                    END IF
                    IF NovaRestr <= 0 THEN TERMINOU$ = "Sim"

                ELSE

                    SOMA = 0
                    FOR IPole = 1 TO NRODOV
                        SOMA = SOMA + STHPRIPolo(IPole)
                    NEXT IPole
                    IF SOMA = 0 THEN TERMINOU$ = "Sim"

                    IF TERMINOU$ = "Nao" THEN
                        FOR IPole = 1 TO NRODOV
                            IF STHPRIPolo(IPole) > 0 THEN
                                IF NewRestP(IPole) >= CostPr(IPole) THEN
                                    ' Aciona a restauracao:
                                    NewRestP(IPole) = NewRestP(IPole) - CostPr(IPole)
                                    FOR IFX = 1 TO NFaixas(STHPRIPolo(IPole))
                                        EXECF(STHPRIPolo(IPole), IFX) = 1
                                    NEXT IFX
                                    CUSTOT(ANO) = CUSTOT(ANO) + CostPr(IPole)
                                    CustoPolo(IPole, ANO) = CustoPolo(IPole, ANO) + CostPr(IPole)
                                ELSE
                                    ' Elimina o segmento prioritario neste ano, a fim de
                                    ' se verificar se o proximo colocado deste ANO pode ser
                                    ' restaurado:
                                    FOR IFX = 1 TO NFaixas(STHPRIPolo(IPole))
                                        IPRIOR(STHPRIPolo(IPole), IFX) = -1
                                    NEXT IFX
                                END IF
                            END IF
                        NEXT IPole
                        Conclude$ = "Sim"
                        FOR IPole = 1 TO NRODOV
                            IF NewRestP(IPole) > 0 THEN Conclude$ = "Nao"
                        NEXT IPole
                        IF Conclude$ = "Sim" THEN TERMINOU$ = "Sim"

                    END IF

                END IF

            WEND

            ' Exclui o custo de CL da restricao orcamentaria nos segmentos nao
            ' priorizados que deveriam ser restaurados:
            CustoCL = 0!
            FOR IPole = 1 TO NRODOV
                CustoCLP(IPole) = 0
            NEXT IPole
            ISTH = 0
            FOR IRodov = 1 TO NRODOV
                IPolo = IRodov
                ' Leitura dos Custos Unitarios
                GOSUB 500
                FOR ISUB = 1 TO NSTHRODOV(IRodov)
                    ISTH = ISTH + 1
                    FOR IFaixa = 1 TO NFaixas(ISTH)
                        IF EXECF(ISTH, IFaixa) = 0 THEN
                            Medida$ = "CL"
                            GOSUB 5000
                            CustoCL = CustoCL + Custo
                            CustoCLP(IPolo) = CustoCLP(IPolo) + Custo
                        END IF
                    NEXT IFaixa
                NEXT ISUB
            NEXT IRodov
            ' Refaz a priorizacao com a restricao orcamentaria ajustada
            IF RedeRestric$ = "Para toda a rede" THEN
                NovaRestr = RestrAnual(ANO) - CustoConserva - CustoCL
            ELSE
                FOR IPole = 1 TO NRODOV
                    NewRestP(IPole) = RestrPolo(IPole, ANO) - ConserP(IPole) - CustoCLP(IPole)
                NEXT IPole
            END IF

        NEXT ICONTROL
        CUSTOT(ANO) = CUSTOT(ANO) + CustoCL
        FOR IPole = 1 TO NRODOV
            CustoPolo(IPole, ANO) = CustoPolo(IPole, ANO) + CustoCLP(IPole)
        NEXT IPole

    END IF
    PRINT "Custo Total apos otimizacao = "; CUSTOT(ANO)

    ' - - - - - - - - - - - - - - - - - - -
    ' -  Aplica as Intervencoes Indicadas -
    ' - - - - - - - - - - - - - - - - - - -
    ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #6
    ARQUIVO$ = CALC$ + "MED.DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #15
    ISTH = 0
    FOR IRodov = 1 TO NRODOV
        ' Leitura dos Custos Unitarios
        GOSUB 500
        FOR ISUB = 1 TO NSTHRODOV(IRodov)
            ISTH = ISTH + 1
            FOR IFaixa = 1 TO NFaixas(ISTH)
                INPUT #6, STH, CustoFaixa(IFaixa), MedidaF$(IFaixa), Hfres(IFaixa), Hrec(IFaixa), CustoAcost(IFaixa), MedidaAcost$(IFaixa), HRAC(IFaixa), H2AC(IFaixa)
            NEXT IFaixa
            ' Muda a medida para CL (reparo emergencial) onde nao foi priorizado
            FOR IFaixa = 1 TO NFaixas(ISTH)
                IF EXECF(ISTH, IFaixa) = 0 THEN
                    MedidaF$(IFaixa) = "CL"
                    Hfres(IFaixa) = 0
                    Hrec(IFaixa) = 0
                    MedidaAcost$(IFaixa) = "CR"
                    HRAC(IFaixa) = 0
                    H2AC(IFaixa) = 0
                    Medida$ = MedidaF$(IFaixa)
                    GOSUB 5000
                    CustoFaixa(IFaixa) = Custo
                    ' Custo da Intervencao nos Acostamentos
                    CustoAcost(IFaixa) = 0!
                END IF
            NEXT IFaixa
            FOR IFaixa = 1 TO NFaixas(ISTH)
                WRITE #15, STH, CustoFaixa(IFaixa), MedidaF$(IFaixa), Hfres(IFaixa), Hrec(IFaixa), CustoAcost(IFaixa), MedidaAcost$(IFaixa), HRAC(IFaixa), H2AC(IFaixa)
            NEXT IFaixa
        NEXT ISUB
    NEXT IRodov
    CLOSE #6, #15

    ' Altera a condicao do pavimento devido `a intervencao

    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12
    ARQUIVO$ = CALC$ + "ESTSTHS2.DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #13

    ARQUIVO$ = CALC$ + "MED.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #6

    ISTH = 0
    FOR IRodov = 1 TO NRODOV

        FOR ISUB = 1 TO NSTHRODOV(IRodov)

            ISTH = ISTH + 1

            FOR IFaixa = 1 TO NFaixasMax
                CustoFaixa(IFaixa) = 0
                CustoAcost(IFaixa) = 0
            NEXT IFaixa

            INPUT #12, STH, KMI, KMF
            FOR IFaixa = 1 TO NFaixas(ISTH)

                GOSUB 600
                INPUT #6, STH, CustoFaixa(IFaixa), MedidaF$(IFaixa), Hfres(IFaixa), Hrec(IFaixa), CustoAcost(IFaixa), MedidaAcost$(IFaixa), HRAC(IFaixa), H2AC(IFaixa)

                Medida$ = MedidaF$(IFaixa)
                PSI = PSIat(ISTH, IFaixa)
                QIest = QImed(IFaixa)
                ' Efeitos dos reparos com fresadora antes do recapeamento
                IF (Medida$ = "RS" OR Medida$ = "CP") THEN
                    HR = 4
                    HC = HR
                    GOSUB 6900
                    RedQI = QImed(IFaixa) - QIest
                    QIest = QImed(IFaixa) - (RepPerct(IFaixa) / 100) * RedQI
                    IF PSI < 4.8 THEN PSI = PSI + (4.8 - PSI) * (RepPerct(IFaixa) / 100)
                END IF
                Area = Aream2(ISTH, IFaixa)
                HR = Hrec(IFaixa)
                HC = Hfres(IFaixa)
                VDM = VDMUni(IFaixa)
                Age = Idade(IFaixa)
                H1 = H1REV(IFaixa)

                IF UltCamada$(IFaixa) = "CCP" THEN
                    IF Medida$ = "CL" THEN
                        IF QIest >= QIcrit THEN
                            QIest = 25
                        ELSE
                            IF QIest > 25 THEN QIest = 0.7 * QIest
                        END IF
                        PSIQI = 5! * EXP(-QIest / 71.5)
                        IDS = 0.3 * IDS
                        PSIids = (309.22 - .616 * IDS) / (61.844 + IDS)
                        PSI = (PSIids + PSIQI) / 2
                        TR23(IFaixa) = 0
                    END IF
                ELSE
                    IF (Medida$ <> "CR" AND Medida$ <> "ST" AND Medida$ <> "CL") THEN GOSUB 4000
                END IF

                Idade(IFaixa) = Age
                PSIat(ISTH, IFaixa) = PSI
                QImed(IFaixa) = QIest
                H1REV(IFaixa) = H1

                ' Vida Residual do Pavimento
                PSI = PSIat(ISTH, IFaixa)
                IF (MedidaF$(IFaixa) <> "CR" AND MedidaF$(IFaixa) <> "ST") THEN
                    IF MedidaF$(IFaixa) <> "CL" THEN
                        H1 = H1REV(IFaixa)
                        Age = Idade(IFaixa)
                        GOSUB 6500
                        VidaRes(IFaixa) = VR
                    ELSE
                        IF UltCamada$(IFaixa) = "CCP" THEN
                            H1 = H1REV(IFaixa)
                            Age = Idade(IFaixa)
                            GOSUB 6500
                            VidaRes(IFaixa) = VR
                        END IF
                    END IF
                END IF

                IF Idade(IFaixa) >= 0 THEN
                    VRmed(ANO) = VRmed(ANO) + Aream2(ISTH, IFaixa) * VidaRes(IFaixa)
                    IF PSIat(ISTH, IFaixa) < PSIref THEN Npsi(ANO) = Npsi(ANO) + 1
                    PSImedSTH(ISTH) = PSImedSTH(ISTH) + Aream2(ISTH, IFaixa) * PSIat(ISTH, IFaixa)
                END IF

                ' Intervencao nos Acostamentos
                SELECT CASE MedidaAcost$(IFaixa)
                    CASE "", "CR", "CL"
                    CASE "TSS", "TSD", "CP"
                        PSIacost(IFaixa) = 4.2
                        DegrauAcost(IFaixa) = 0
                    CASE ELSE
                        PSIacost(IFaixa) = 4.5
                        DegrauAcost(IFaixa) = 0
                END SELECT

            NEXT IFaixa

            WRITE #13, STH, KMI, KMF
            FOR IFX = 1 TO NFaixas(ISTH)
                GOSUB 700
            NEXT IFX

            PSImed(ANO) = PSImed(ANO) + PSImedSTH(ISTH)
            J = Code(IRodov, ISUB)
            Y = ANO + ANOBASE
            N = NFaixas(ISTH)

            FOR IFaixa = 1 TO NFaixasMax
                IF IFaixa > NFaixas(ISTH) THEN
                    MedidaF$(IFaixa) = ""
                    Hfres(IFaixa) = 0
                    Hrec(IFaixa) = 0
                END IF
            NEXT IFaixa

            WRITE #14, Y, J, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(N), HRAC(N), H2AC(N)

            CustoSTH = 0
            CustoAc = 0
            FOR IFaixa = 1 TO NFaixas(ISTH)
                CustoSTH = CustoSTH + CustoFaixa(IFaixa) + CustoAcost(IFaixa)
                CustoAc = CustoAc + CustoAcost(IFaixa)
            NEXT IFaixa

            ARQUIVO$ = CALC$ + ARQ$ + "CT" + Rodov$(IRodov) + ".CSV"
            OPEN ARQUIVO$ FOR APPEND AS #15
            WRITE #15, Y, J, KMI, KMF, CustoSTH, CustoFaixa(1), CustoFaixa(2), CustoFaixa(3), CustoFaixa(4), CustoAc
            CLOSE #15

        NEXT ISUB
    NEXT IRodov
    GOSUB 800
    CLOSE #6

    ARQUIVO$ = CALC$ + "ESTSTHS2.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12
    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #13

    VDMmin = 1E+20: VDMmax = 0
    PSIminRede = 5!: PSImaxRede = 0
    ISTH = 0
    FOR IRodov = 1 TO NRODOV
        FOR ISUB = 1 TO NSTHRODOV(IRodov)
            ISTH = ISTH + 1
            INPUT #12, STH, KMI, KMF
            FOR IFaixa = 1 TO NFaixas(ISTH)
                GOSUB 600
                IF VDMUni(IFX) > VDMmax THEN VDMmax = VDMUni(IFX)
                IF VDMUni(IFX) < VDMmin THEN VDMmin = VDMUni(IFX)
                IF PSIat(ISTH, IFX) > PSImaxRede THEN PSImaxRede = PSIat(ISTH, IFX)
                IF PSIat(ISTH, IFX) < PSIminRede THEN PSIminRede = PSIat(ISTH, IFX)
            NEXT IFaixa
            WRITE #13, STH, KMI, KMF
            FOR IFX = 1 TO NFaixas(ISTH)
                GOSUB 700
            NEXT IFX
        NEXT ISUB
    NEXT IRodov
    GOSUB 800

    ' Fator 2 nas formulas abaixo se deve `a media entre antes e depois
    ' das intervencoes programadas para o ANO:
    Npsi(ANO) = 100 * Npsi(ANO) / (2 * NUnid)
    PSImed(ANO) = PSImed(ANO) / (2 * TotalArea)
    VRmed(ANO) = VRmed(ANO) / (2 * TotalArea)

    ' - - - - - - - - - - - - - - -
    ' - Passa para o ano seguinte -
    ' - - - - - - - - - - - - - - -
NEXT ANO
CLOSE #14

' - - - - - - - - - - - - - - -
' -  Arquivos de Saida Finais -
' - - - - - - - - - - - - - - -
   
ARQUIVO$ = CALC$ + "Results.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #4
WRITE #4, "ANO", "CUSTO", "PSIMEDIO", "OCORR", "VRANOS"
 
ARQCUSTO$ = CALC$ + "Custo" + ARQ$ + ".out"
OPEN ARQCUSTO$ FOR OUTPUT AS #1

FOR IANO = 1 TO NPeriodos
    Deficit(IANO) = Deficit(IANO) - CUSTOT(IANO)
    WRITE #1, CUSTOT(IANO)
    WRITE #1, Deficit(IANO)
    FOR IPolo = 1 TO NRODOV
        WRITE #1, CustoPolo(IPolo, IANO)
    NEXT IPolo
    ANO = ANOBASE + IANO
    temp$ = "&, #######.###, #.##, ###.##, ###.##"
    PRINT #4, USING temp$; STR$(ANO); (CUSTOT(IANO) / 1000); PSImed(IANO); Npsi(IANO); VRmed(IANO)
NEXT IANO
CLOSE #1, #4

ARQOUT$ = CALC$ + "PROT.OUT"
OPEN ARQOUT$ FOR OUTPUT AS #1
FOR IANO = 1 TO NPeriodos
    WRITE #1, CUSTOT(IANO)
NEXT IANO
CLOSE #1

SYSTEM


300 '
' - - - - - - - - - - - - - - - - - - - - - - - - - -
' -  Vida de servico prevista em medidas do tipo CP -
' - - - - - - - - - - - - - - - - - - - - - - - - - -
GOSUB 6900
PSIQI = 5! * EXP(-QIest / 71.5)
PSI = (5 + PSIQI) / 2
LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
SNCrec = SNC + (0.44 * (HR - HC) / 2.54)
VSCP = 0
QI = QIest
IGGest = 0
PSRest = 5
Achou$ = "N"
WHILE (Achou$ = "N" AND VSCP < 10)
    VSCP = VSCP + DeltaT
    DeltaPSI = -A1rest(IRodov) * DeltaN / EXP((A0rest(IRodov) + A2rest(IRodov) * SN(IFaixa) - (PSI + NpsiMod * SErest(IRodov))) / A1rest(IRodov))
    PSI = PSI + DeltaPSI
    QI = 13 * EXP(0.0153 * VSCP) * ((QIest / 13) + 725 * ((1 + SNCrec) ^ -4.99) * (Nano(IFaixa) / 1000000!) * VSCP)
    ' Evolucao do IGG e do PSR
    PSIQIe = 5! * EXP(-QI / 71.5)
    PSRe = 2 * PSI - PSIQIe
    IF PSRe < 0.5 THEN PSRe = 0.5
    DeltaPSR = PSRe - PSRest
    DeltaIGG = DeltaPSR * (-61.844 - IGGest) / (.616 + PSRest)
    IGGest = IGGest + DeltaIGG
    PSRest = PSRe
    IF (PSI < PSIf OR QI > QIcrit OR IGGest > IGGcrit) THEN Achou$ = "S"
WEND
RETURN


600 '
INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
INPUT #12, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), Nacum(IFX), ALFAIGG(IFX), ATRmed(IFX)
INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX)
RETURN

700 '
WRITE #13, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
WRITE #13, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), Nacum(IFX), ALFAIGG(IFX), ATRmed(IFX)
WRITE #13, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX)
RETURN

800 '
INPUT #12, PSImed(0), Npsi(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
WRITE #13, PSImed(0), Npsi(0), VRmed(0)
WRITE #13, AreaTotal, NUnidAnalise
CLOSE #12, #13
RETURN

500 '
' - - - - - - - - - - - -
' -  Custos Unitarios   -
' -     (Subrotina)     -
' - - - - - - - - - - - -
ARQUIVO$ = CALC$ + "C" + Rodov$(IRodov) + STR$(ANO) + ".CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, CBUQm3
'IF UsaCBUQpol$ = "S" THEN CBUQm3 = CBUQm3 * 1.14
INPUT #1, Reperf
INPUT #1, Fresagemm3
INPUT #1, BGm3
INPUT #1, Remocao
INPUT #1, CRkmAno
INPUT #1, CLm2
INPUT #1, MICROCA4m2
INPUT #1, MICROCA7m2
INPUT #1, MICROCA12m2
INPUT #1, TSSm2
INPUT #1, TSDm3
INPUT #1, TSTm3
INPUT #1, Pintura
INPUT #1, Selagem
INPUT #1, PMFm3
INPUT #1, LamaD
INPUT #1, LamaM
INPUT #1, LamaG
INPUT #1, BaseAcostm3
INPUT #1, TSSpolm2
INPUT #1, TSDpolm3
INPUT #1, TSTpolm3
INPUT #1, CapeSealm3
INPUT #1, Imprimam2
INPUT #1, CamReciclm3
CLOSE #1
RETURN

5000 '
' - - - - - - - - - - - - - - - - - - - - - - -
' -       Custo da Medida de Manutencao       -
' -                (Subrotina)                -
' -  Dados: Medida$, HC, HR, Area, PSI, VDM   -
' -  Saida: Custo                             -
' - - - - - - - - - - - - - - - - - - - - - - -
SELECT CASE Medida$
    CASE "CP", "FR+CP", "MF+CP", "FR+MF+CP", "RSUP+CP"
        SELECT CASE CamadaRest$(IRodov)
            CASE "Lama Asfaltica Delgada": Custo = LamaD
            CASE "Lama Asfaltica Media": Custo = LamaM
            CASE "Lama Asfaltica Grossa": Custo = LamaG
            CASE "Micro-CA Delgado": Custo = MICROCA4m2
            CASE "Micro-CA Normal": Custo = MICROCA7m2
            CASE "Micro-CA Espesso": Custo = MICROCA12m2
            CASE "TSD": Custo = TSDm3 * (Hrec(IFaixa) / 100)
            CASE "TST": Custo = TSTm3 * (Hrec(IFaixa) / 100)
            CASE "TSD com Polimero (18 mm)": Custo = TSDpolm3 * (Hrec(IFaixa) / 100)
            CASE "Cape Seal (TSS+Micro)": Custo = CapeSealm3 * (Hrec(IFaixa) / 100)
            CASE ELSE
                PRINT "ERRO: tipo nao identificado ==> "; CamadaRest$(IRodov)
                B$ = "": WHILE B$ = "": B$ = INKEY$: WEND
        END SELECT
        Custo = Custo + Fresagemm3 * (Hfres(IFaixa) / 100)
        IF (Medida$ = "MF+CP" OR Medida$ = "FR+MF+CP") THEN Custo = Custo + Pintura + Reperf * (HRMF / 2)
    CASE "CR", ""
        Custo = 0
    CASE "CL", "ST"
        PSI = PSIat(ISTH, IFaixa)
        I1 = 0
        FOR ICL = 1 TO (NitensCL - 1)
            IF (PSI <= PSIitemCL(ICL) AND PSI > PSIitemCL(ICL + 1)) THEN
                I1 = ICL
                I2 = ICL + 1
            END IF
        NEXT ICL
        IF PSI <= PSIitemCL(NitensCL) THEN
            I1 = NitensCL - 1
            I2 = NitensCL
        END IF
        IF I1 = 0 THEN
            PerctReparos = 0
        ELSE
            Y1 = ARepCL(I1)
            Y2 = ARepCL(I2)
            X1 = PSIitemCL(I1)
            X2 = PSIitemCL(I2)
            PerctReparos = ((X2 * Y1 - X1 * Y2) / (X2 - X1)) + ((Y2 - Y1) * PSI / (X2 - X1))
        END IF
        IF Medida$ = "ST" THEN
            PerctReparos = .1 * PerctReparos
            IF PerctReparos > 1! THEN PerctReparos = 1!
            Custo = Selagem * PerctReparos / 100
        ELSE
            IF PerctReparos > ARepCL(NitensCL) THEN PerctReparos = ARepCL(NitensCL)
            Custo = CLm2 * PerctReparos / 100
        END IF
    CASE "RS", "RSUP+RC"
        GOSUB 5100
        Custo = (Hrec(IFaixa) / 100) * CBUQm3 + Ncamadas * Pintura
    CASE "MF+RC"
        GOSUB 5100
        Custo = (Hrec(IFaixa) / 100) * CBUQm3 + (Ncamadas + 1) * Pintura + Reperf * (HRMF / 2)
    CASE "FR+RC", "RRV", "FR+MF+RC"
        GOSUB 5100
        Custo = (Hrec(IFaixa) / 100) * CBUQm3 + Fresagemm3 * (Hfres(IFaixa) / 100) + Ncamadas * Pintura + Reperf * (HRMF / 2)
    CASE "RRP"
        GOSUB 5100
        Custo = Remocao * Hfres(IFaixa) / 100
        H2CM = Hfres(IFaixa) - Hrec(IFaixa)
        Custo = Custo + (Hrec(IFaixa) / 100) * CBUQm3 + (H2CM / 100) * BGm3 + Ncamadas * Pintura + Imprimam2
    CASE "RRT"
        GOSUB 5100
        Custo = Remocao * Hfres(IFaixa) / 100
        H2CM = Hfres(IFaixa) - Hrec(IFaixa) - 20
        Custo = Custo + (Hrec(IFaixa) / 100) * CBUQm3 + (H2CM / 100) * BGm3 + Ncamadas * Pintura + Imprimam2
    CASE "RECL"
        Custo = CamReciclm3 * Hfres(IFaixa) / 100
        H2CM = Hfres(IFaixa)
        IF Hrec(IFaixa) > 2.5 THEN
            GOSUB 5100
            Custo = Custo + (Hrec(IFaixa) / 100) * CBUQm3 + Ncamadas * Pintura
        ELSE
            Custo = Custo + (Hrec(IFaixa) / 100) * TSDm3
        END IF
    CASE ELSE
        PRINT "ERRO: medida nao identificada ==> "; Medida$
        B$ = "": WHILE B$ = "": B$ = INKEY$: WEND
END SELECT
IF (Idade(IFaixa) < 0 OR Aream2(ISTH, IFaixa) <= 0) THEN
    Custo = 0
ELSE
    Custo = Custo + ABS(KMF - KMI) * CRkmAno / Aream2(ISTH, IFaixa)
END IF
SELECT CASE Medida$
    CASE "RS", "CP"
        IF RepFres < 0 THEN
            IF TR23(IFaixa) < 50 THEN
                RepPerct(IFaixa) = TR23(IFaixa)
            ELSE
                RepPerct(IFaixa) = 20
            END IF
        ELSE
            RepPerct(IFaixa) = RepFres
        END IF
        IF Nano(IFaixa) < 500000! THEN
            HCrepFres = 3
        ELSE
            IF Nano(IFaixa) < 1000000! THEN
                HCrepFres = 4
            ELSE
                HCrepFres = 5
            END IF
        END IF
        Custo = Custo + (RepPerct(IFaixa) / 100) * ((HCrepFres / 100) * CBUQm3 + Fresagemm3 * (HCrepFres / 100) + Pintura)
    CASE "RSUP+RC", "RSUP+CP"
        RepPerct(IFaixa) = 20
        IF Nano(IFaixa) < 500000! THEN
            HCrepFres = 3
        ELSE
            IF Nano(IFaixa) < 1000000! THEN
                HCrepFres = 4
            ELSE
                HCrepFres = 5
            END IF
        END IF
        Custo = Custo + (RepPerct(IFaixa) / 100) * ((HCrepFres / 100) * CBUQm3 + Fresagemm3 * (HCrepFres / 100) + Pintura)
    CASE ELSE
END SELECT
Custo = Custo * Aream2(ISTH, IFaixa)
RETURN

5100 '
' - - - - - - - - - - - - -
' -   Subrotina Auxiliar  -
' - - - - - - - - - - - - -
IF Hrec(IFaixa) <= 7.5 THEN
    Ncamadas = 1
ELSE
    IF Hrec(IFaixa) <= 15 THEN
        Ncamadas = 2
    ELSE
        Ncamadas = 3
    END IF
END IF
RETURN


1000 '
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -              Necessidades Atuais de Manutencao              -
' -                         (Subrotina)                         -
' -  Dados: PSI, H1, VR, QI, Age, NYEAR, VSMIN,                 -
' -         Estado de Superficie, Parametros de decisao,        -
' -         HRTR, H1TR, H2DP, HRQI, HRMPD                       -
' -  Saida: Medida$, HC, HR, H1NOVO, H2NOVO                     -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
HC = 0
HR = HRMPD
HCMAX = H1 - 3
IF HCMAX > HCMAXgeral THEN HCMAX = HCMAXgeral
IF HCMAX < HCmin THEN
    HCMAX = 0
    Fresavel$ = "Nao"
ELSE
    Fresavel$ = "Sim"
END IF
IF (PSIacost(IFaixa) >= 3! AND DegrauAcost(IFaixa) <= DEGRAUadm) THEN
    Fresar$ = "Sim"
ELSE
    Fresar$ = "Nao"
END IF
IF HR < HRmin THEN HR = HRmin
IF HR > HRmax THEN HR = HRmax

' Deciso quanto  categoria de interveno requerida
IF Restaurado$(IFaixa) = "Nao" THEN

    CATEGORIA$ = "CONSERVACAO"
    IF Age > IdadeMin THEN
        IF (IGG(IFaixa) > IGGcrit OR ATRmed(IFaixa) > ATRcrit OR QI > QIcrit OR PSI <= PSIf OR Medida$ = "Restaura") THEN
            CATEGORIA$ = "RESTAURACAO"
        END IF
    END IF

    IRest = 0
    IF HRTR > HR THEN
        HR = HRTR
        IRest = 2
    END IF
    IF HRatr > HR THEN
        IRest = 4
        HR = HRatr
    END IF

    ' Detalhamento da Medida$ a ser aplicada
    IF CATEGORIA$ = "CONSERVACAO" THEN

        IF UltCamada$(IFaixa) = "CCP" THEN

            IF PSR > 4! THEN Medida$ = "CR" ELSE Medida$ = "CL"

        ELSE

            IF (D$ = "A3" OR DS$ = "A" OR TR23(IFaixa) > 15) THEN
                IF MedCP$ <> "" THEN
                    Medida$ = MedCP$
                    HR = HRCP(IRodov)
                    IF MedCP$ = "FR+CP" THEN HC = HR ELSE HC = 0!
                ELSE
                    Medida$ = "CL"
                END IF
            ELSE
                IF (BL$ = "B3" OR CR$ = "B2" OR CR$ = "M2" OR BL$ = "M2" OR TT$ = "B3" OR TT$ = "M3" OR TL$ = "B3" OR TL$ = "M3") THEN
                    Medida$ = "ST"
                ELSE
                    IF (DP$ = "B3" OR EL$ = "B3" OR CR$ = "B3" OR P$ = "B3" OR P$ = "B2" OR P$ = "B1") THEN
                        Medida$ = "CL"
                    ELSE
                        IF (PSR < 4! OR IDS > 20) THEN
                            Medida$ = "CL"
                        ELSE
                            Medida$ = "CR"
                        END IF
                    END IF
                END IF
            END IF

        END IF

    ELSE

        IF UltCamada$(IFaixa) = "CCP" THEN

            Medida$ = "CL"
            'IF PSI < 1.5 THEN
            '       CATEGORIA$ = "RECONSTRUCAO"
            '       Medida$ = "RRT"
            '       H1NOVO = H1
            '       H2NOVO = 15
            '       HR = H1
            '       HC = H1NOVO + H2NOVO + 20
            'ELSE
            '       CATEGORIA$ = "RESTAURACAO"
            '       HRreflex = 10
            '       IF HRMPD < HRreflex THEN HR = HRreflex ELSE HR = HRMPD
            '       Medida$ = "MF+RC"
            '       HC = 0
            'END IF
         
        ELSE

            IF (PSI < PSRcrit AND IDS > IDScrit) THEN
             
                CATEGORIA$ = "RECONSTRUCAO"
                IF (TE$ = "A3" OR Dc$ = "A3" OR COR$ = "A3" OR EM$ = "A3") THEN
                    Medida$ = "RRP"
                    H1NOVO = H1TR
                    H2NOVO = H2DP
                    HR = H1NOVO
                    HC = H1NOVO + H2NOVO
                ELSE
                    Medida$ = "RRT"
                    H1NOVO = H1TR
                    H2NOVO = H2DP
                    HR = H1NOVO
                    HC = H1NOVO + H2NOVO + 20
                END IF

            ELSE

                CATEGORIA$ = "RESTAURACAO"

                IF (ANO >= AnoDelgada1 AND ANO <= AnoDelgada2) THEN
                    Medida$ = MedCPbest$
                    HR = HRCP(IRodov)
                    IF MedCPbest$ = "FR+CP" THEN HC = HR ELSE HC = 0!
                ELSE
                    HC = 0
                    Trincado$ = "N"
                    IF (CR$ = "A2" OR CR$ = "A3" OR CR$ = "M2" OR CR$ = "M3") THEN Trincado$ = "S"
                    IF (BL$ = "A3" OR BL$ = "M3") THEN Trincado$ = "S"
                    IF (TT$ = "A2" OR TT$ = "A3" OR TT$ = "M2" OR TT$ = "M3") THEN Trincado$ = "S"
                    IF (TL$ = "A2" OR TL$ = "A3" OR TL$ = "M2" OR TL$ = "M3") THEN Trincado$ = "S"
                    IF Trincado$ = "S" THEN
                        IF MedCP$ = "" THEN
                            IF SART$ <> "RSUP20" THEN Medida$ = "MF+RC" ELSE Medida$ = "RSUP+RC"
                        ELSE
                            IF SART$ <> "RSUP20" THEN Medida$ = "MF+CP" ELSE Medida$ = "RSUP+CP"
                            HR = HRCP(IRodov)
                        END IF
                    ELSE
                        IF (COR$ = "A3" OR DP$ = "A3" OR EL$ = "A3") THEN
                            IF (ATRmed(IFaixa) > 12 OR ATR$ = "A3") THEN
                                IF Fresavel$ = "Sim" THEN
                                    IF MedCP$ = "" THEN
                                        Medida$ = "FR+RC"
                                        IF HR > HCMAX THEN
                                            HC = HCMAX
                                        ELSE
                                            HC = HR
                                        END IF
                                        IF HC < HCmin THEN HC = HCmin
                                    ELSE
                                        Medida$ = "FR+CP"
                                        HR = HRCP(IRodov)
                                        HC = HR
                                    END IF
                                ELSE
                                    IF MedCP$ = "" THEN
                                        IF SART$ <> "RSUP20" THEN Medida$ = "MF+RC" ELSE Medida$ = "RSUP+RC"
                                    ELSE
                                        IF SART$ <> "RSUP20" THEN Medida$ = "MF+CP" ELSE Medida$ = "RSUP+CP"
                                        HR = HRCP(IRodov)
                                    END IF
                                END IF
                            ELSE
                                IF MedCP$ = "" THEN
                                    IF SART$ <> "RSUP20" THEN Medida$ = "MF+RC" ELSE Medida$ = "RSUP+RC"
                                ELSE
                                    IF SART$ <> "RSUP20" THEN Medida$ = "MF+CP" ELSE Medida$ = "RSUP+CP"
                                    HR = HRCP(IRodov)
                                END IF
                            END IF
                        ELSE
                            IF (ATRmed(IFaixa) > 12 OR ATR$ = "A3") THEN
                                IF Fresavel$ = "Sim" THEN
                                    IF MedCP$ = "" THEN
                                        Medida$ = "FR+RC"
                                        IF HR > HCMAX THEN
                                            HC = HCMAX
                                        ELSE
                                            HC = HR
                                        END IF
                                        IF HC < HCmin THEN HC = HCmin
                                    ELSE
                                        Medida$ = "FR+CP"
                                        HR = HRCP(IRodov)
                                        HC = HR
                                    END IF
                                ELSE
                                    IF MedCP$ = "" THEN
                                        IF SART$ <> "RSUP20" THEN Medida$ = "MF+RC" ELSE Medida$ = "RSUP+RC"
                                    ELSE
                                        IF SART$ <> "RSUP20" THEN Medida$ = "MF+CP" ELSE Medida$ = "RSUP+CP"
                                        HR = HRCP(IRodov)
                                    END IF
                                END IF
                            ELSE
                                IF MedCP$ = "" THEN
                                    Medida$ = "RS"
                                ELSE
                                    Medida$ = "CP"
                                    HR = HRCP(IRodov)
                                END IF
                            END IF
                        END IF
                    END IF
                END IF

            END IF
         
        END IF

    END IF

ELSE

    Refor$ = "N"
    IF ANO = NPeriodos THEN
        IF (PSI <= PSIf OR QI > QIcrit OR VR < VRminFinal OR Medida$ = "Restaura") THEN Interv$ = "S" ELSE Interv$ = "N"
        IF HRdeflex > HR THEN
            HR = HRdeflex
            Interv$ = "S"
            Refor$ = "S"
        END IF
    ELSE
        IF (PSI <= PSIf OR QI > QIcrit OR Medida$ = "Restaura") THEN Interv$ = "S" ELSE Interv$ = "N"
    END IF
    IF Interv$ = "S" THEN
        IF PSI > PSRcrit THEN
            HC = 0!
            IF (MedCP$ <> "" AND Refor$ = "N") THEN
                Medida$ = MedCP$
                HR = HRCP(IRodov)
                IF MedCP$ = "FR+CP" THEN HC = HR ELSE HC = 0!
            ELSE
                IF (ANO >= AnoDelgada1 AND ANO <= AnoDelgada2) THEN
                    Medida$ = MedCPbest$
                    HR = HRCP(IRodov)
                    IF MedCPbest$ = "FR+CP" THEN HC = HR ELSE HC = 0!
                ELSE
                    IF IGG(IFaixa) < 80 THEN
                        Medida$ = "RS"
                    ELSE
                        IF SART$ <> "RSUP20" THEN Medida$ = "MF+RC" ELSE Medida$ = "RSUP+RC"
                    END IF
                END IF
            END IF
        ELSE
            Medida$ = "RRP"
            H1NOVO = H1TR
            H2NOVO = H2DP
            HR = H1NOVO
            HC = H1NOVO + H2NOVO
        END IF
    ELSE
        IF PSI >= 3.5 THEN
            Medida$ = "CR"
        ELSE
            Medida$ = "CL"
        END IF
    END IF

END IF
IF (Medida$ = "CR" OR Medida$ = "CL" OR Medida$ = "ST") THEN HR = 0

RETURN


1200 '
' - - - - - - - - - - - - - - - - - - - - - - - - -
' -       Necessidades de Reforco Estrutural      -
' -                  (Subrotina)                  -
' -  Dados: H1, HT, NYEAR, PP, DC, QI             -
' -  Saida: HRTR, H1TR, H2DP, HRMPD               -
' - - - - - - - - - - - - - - - - - - - - - - - - -
' Espessura de reforco efetiva existente
P = 4100 / (PI# * 30 * 30 / 4)
E = 2 * (1 - .33 * .33) * P * (30 / 2) / (Dc / 1000)
MR = E / .0703
A1 = .44
IF VR > 0 THEN
    PERIODO = VR
    GOSUB 6700
    SNP = A1 * .5 / 2.54
    HRmodel = 2.54 * SNP / A1
    NP = 0
    WHILE (NP < NPA AND HRmodel < HRmax)
        SNP = SNP + .05
        HRmodel = 2.54 * SNP / A1
        QIest = QI
        HR = HRmodel
        HC = 0
        GOSUB 6900
        QIx = QIest
        IC = 1
        GOSUB 1300
    WEND
    Heff(IFaixa) = HRmodel
ELSE
    Heff(IFaixa) = 0
END IF

' Espessura de reforco em CBUQ requerida pelo modelo de previsao de desempenho
PERIODO = PP
GOSUB 6700
SNP = A1 * .5 / 2.54
HRmodel = 2.54 * SNP / A1
NP = 0
WHILE (NP < NPA AND HRmodel < HRmax)
    SNP = SNP + .05
    HRmodel = 2.54 * SNP / A1
    QIest = QI
    HR = HRmodel
    HC = 0
    GOSUB 6900
    QIx = QIest
    IC = 2
    GOSUB 1300
WEND
HRMPD = HRmodel
IF HRMPD < 0 THEN HRMPD = 0
IF UltCamada$(IFaixa) = "CCP" THEN
    HRreflex = 1.364 * PP
    IF HRreflex > HRMPD THEN HRMPD = HRreflex
END IF

' Espessura minima de recapeamento para manter o QI abaixo do valor admissivel
' Fatores de Calibracao do Modelo AASHTO-HDM
Fc0PSI = 0.958
Fc1PSI = 0.84
SCI0 = 4.971
Fc0SCI = 0.923
Fc1SCI = 0.564
IF Nano(IFaixa) < 9.0E4 THEN Fc2SCI = 0.828 ELSE Fc2SCI = 1.766
HR = 0.4
HC = 0
QIf = QIcrit
MR = 2 * (1 - 0.35 * 0.35) * 5.6 * 15 / (D0(IFaixa) / 1000)
E1ef = 44352 * EXP(-0.03 * TR23(IFaixa))
MRef = ((MR + 2 * E1ef) / 3) / 0.0703
DeltaT = 1
WHILE (QIf >= QIcrit AND HR < HRmax)
    HR = HR + .1
    QIest = QI
    GOSUB 6900
    PSI0ah = 5 * EXP(-QIest / 71.5)
    IF PSI0ah >= 4.99 THEN PSI0ah = 4.99
    IF PSI0ah > 2.5 THEN
        SNP = A1 * HR / 2.54
        BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
        DPSI = PSI0ah - 2.5
        W18# = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
        W18# = 10 ^ (-ZRmpd * S0mpd) * W18# * ((MRef / 3000) ^ 2.32) / 1000000!
        ALFAah# = Fc1PSI * (1 / W18#) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
        IF ALFAah# * NPA < 80 THEN
            PSIah# = 5 * ((PSI0ah / 5) ^ EXP(ALFAah# * NPA))
            QIf = 71.5 * LOG(5 / PSIah#)
        END IF
    END IF
WEND
IF HRMPD < HR THEN HRMPD = HR

' Espessura minima de recapeamento para manter o IGG abaixo do valor admissivel
HR = 0.4
HC = 0
IGGf = IGGcrit
DeltaT = 1
WHILE (IGGf >= IGGcrit AND HR < HRmax)
    HR = HR + .1
    ' Modelo AASHTO-HDM para IGG
    SCI0 = 4.97
    PCR4 = 5
    TYcr2A = 2.54 * EXP(.0157 * HR * 10 - .0141 * PCR4)
    Dc = D0(IFaixa) * (10 ^ (-HR / 40))
    TYcr2B = 10.8 * EXP(-1.21 * (Dc / 100) - 1.02 * (Nano(IFaixa) / 1000000!) * (Dc / 100))
    TYcr2 = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
    Alfa1 = 2.9818E5 * (TYcr2 ^ -0.6296) / Nano(IFaixa)
    IF Alfa1 <= 2.645 THEN Alfa2 = 1.6298 * (Alfa1 ^ 0.498) ELSE Alfa2 = Alfa1
    VsSCI = 0
    SCI = SCI0
    DeltaTS = 0.5
    WHILE VsSCI < PP
        VsSCI = VsSCI + DeltaTS
        IF VsSCI <= TYcr2 THEN AlfaSCI = Alfa1 ELSE AlfaSCI = Alfa2
        DeltaN = (Nano(IFaixa) / 1000000!) * DeltaTS
        DeltaSCI = AlfaSCI * DeltaN * SCI * LOG(SCI / 5)
        SCI = SCI + DeltaSCI
        IF SCI < 0.5 THEN SCI = 0.5
    WEND
    IGGf = (309.22 - 61.844 * SCI) / (SCI + 0.616)
WEND
IF HRMPD < HR THEN HRMPD = HR

' Revestimento requerido pelo Metodo do DNER
NPUSACE = 3 * NPA
H1TR = 4.4608 + 2.131 * LOG(NPUSACE)
IF H1TR < HRmin THEN H1TR = HRmin
HRTR = H1TR - H1
IF HRTR < 0 THEN HRTR = 0
' Camada de Base pelo modelo de previsao de desempenho
SNP = .5
NP = 0
WHILE (NP < NPA AND SNP < 12)
    SNP = SNP + .05
    IC = 3
    QIx = 15
    GOSUB 1300
WEND
H2DP = (2.54 * SNP - .44 * H1TR) / .14
IF H2DP < 12 THEN H2DP = 12

' Espessura de recapeamento requerida para eliminar ATR
ATRadm = 1
IF ATRmed(IFaixa) > ATRadm THEN
    Nrecaps = LOG(ATRadm / ATRmed(IFaixa)) / LOG(.15)
    IF Nrecaps < 1 THEN
        NR = 1
    ELSE
        NR = Nrecaps - INT(Nrecaps)
        IF NR > .2 THEN NR = INT(Nrecaps) + 1 ELSE NR = INT(Nrecaps)
    END IF
ELSE
    NR = 0
END IF
HRatr = NR * HRmin

' Espessura de recapeamento para controle de deflexoes
IF ANO >= AnoDeflexMax THEN
    HRdeflex = 40 * LOG(D0(IFaixa) / DeflexMax) / LOG(10)
ELSE
    HRdeflex = 0
END IF

RETURN


1300 '
' - - - - - - - - - - - -
' -  Subrotina Auxiliar -
' - - - - - - - - - - - -
PSIQI = 5 * EXP(-QIx / 71.5)
PSR = 5
PSI0 = (PSIQI + PSR) / 2
IF PSI0 > 4.95 THEN PSI0 = 4.95
DPSI = PSI0 - 2.5
IF DPSI > 0 THEN
    BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
    W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
    W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
    ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
    IF IC = 3 THEN
        LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
        SNC = SNP + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
        TYcr2 = 4.21 * EXP(.139 * SNC - 17.1 * ((Nano(IFaixa) / 1000000!) / (SNC ^ 2)))
        FC0 = FC0novo
    ELSE
        Hrec = 2.54 * SNP / .44
        PCR4 = 5
        TYcr2A = 2.54 * EXP(.0157 * Hrec * 10 - .0141 * PCR4)
        TYcr2B = 10.8 * EXP(-1.21 * (Dc / 100) - 1.02 * (Nano(IFaixa) / 1000000!) * (Dc / 100))
        TYcr2 = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
        IF IC = 1 THEN FC0 = ALPHA0(IFaixa) ELSE FC0 = FC0recap
    END IF
    Nf = TYcr2 * FC0 * Nano(IFaixa) / 1000000!
    PSIx = PSI0
    DeltaT = .1
    DeltaN = DeltaT * Nano(IFaixa) / 1000000!
    NP = 0
    WHILE PSIx > PSIf
        NP = NP + DeltaN
        SELECT CASE IC
            CASE 1
                IF Restaurado$(IFaixa) = "Sim" THEN
                    IF NP < Nf THEN
                        FC = FCrecap
                    ELSE
                        FC = FC2recap
                    END IF
                ELSE
                    IF IRec(IFaixa) = 1 THEN
                        IF ICalib(IFaixa) = 1 THEN
                            IF NP < Nf THEN
                                FC = ALPHA(IFaixa)
                            ELSE
                                FC = ALPHA2(IFaixa)
                            END IF
                        ELSE
                            IF NP < Nf THEN
                                FC = FCrecaprede(IRodov)
                            ELSE
                                FC = FC2recaprede(IRodov)
                            END IF
                        END IF
                    ELSE
                        IF NP < Nf THEN
                            FC = FCrecaprede(IRodov)
                        ELSE
                            FC = FC2recaprede(IRodov)
                        END IF
                    END IF
                END IF
            CASE 2
                IF NP < Nf THEN
                    FC = FCrecap
                ELSE
                    FC = FC2recap
                END IF
            CASE 3
                IF NP < Nf THEN
                    FC = FCnovo
                ELSE
                    FC = FC2novo
                END IF
            CASE ELSE
                PRINT "ERRO"
        END SELECT
        ALFA = ALFAA * FC
        DeltaPSI = (ALFA / 10 ^ (-ZRmpd * S0mpd)) * DeltaN * PSIx * LOG(PSIx / 5)
        VRmax = 64.43 * (5 ^ -.76) * ((HRmodel / 2.54) ^ .37)
        VRmin = 64.43 * (25 ^ -.76) * ((HRmodel / 2.54) ^ .37)
        dPSIdtmin = 2! / VRmax
        dPSIdtmax = 2! / VRmin
        DPSImin = dPSIdtmin * DeltaT
        DPSImax = dPSIdtmax * DeltaT
        IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
        IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
        PSIx = PSIx + DeltaPSI
    WEND
END IF
RETURN


2000 '
' - - - - - - - - - - - - - - - - - -
' -  INTERVENCAO NOS ACOSTAMENTOS   -
' -           (Subrotina)           -
' - - - - - - - - - - - - - - - - - -
SELECT CASE MedidaAcost$(IFaixa)
    CASE "CR", ""
        Custo = 0
    CASE "CL", "ST"
        PerctReparos = 100 * EXP(-2.3026 * PSIacost(IFaixa))
        Custo = (.5 * CLm2) * PerctReparos / 100
    CASE "CP"
        Custo = MICROCA12m2
    CASE "TSS"
        Custo = TSSm2
    CASE "TSD"
        Custo = TSDm2
    CASE "PMF"
        Custo = (HRAC(IFaixa) / 100) * PMFm3 + Pintura
    CASE "CBUQ", "RS", "RSUP+RC"
        Custo = (HRAC(IFaixa) / 100) * CBUQm3 + Pintura
    CASE "RRP", "RRT"
        Custo = (Remocao * H2AC(IFaixa) / 100) + TSDm2 + (H2AC(IFaixa) / 100) * BaseAcostm3 + Imprimam2
    CASE "RECL"
        Custo = (CamReciclm3 * H2AC(IFaixa) / 100) + TSDm2 + Imprimam2
    CASE "FR+CP", "MF+CP", "FR+MF+CP", "RSUP+CP"
        SELECT CASE CamadaRest$(IRodov)
            CASE "Lama Asfaltica Delgada": Custo = LamaD
            CASE "Lama Asfaltica Media": Custo = LamaM
            CASE "Lama Asfaltica Grossa": Custo = LamaG
            CASE "Micro-CA Delgado": Custo = MICROCA4m2
            CASE "Micro-CA Normal": Custo = MICROCA7m2
            CASE "Micro-CA Espesso": Custo = MICROCA12m2
            CASE "TSD": Custo = TSDm3 * (HRAC(IFaixa) / 100)
            CASE "TST": Custo = TSTm3 * (HRAC(IFaixa) / 100)
            CASE "TSD com Polimero (18 mm)": Custo = TSDpolm3 * (HRAC(IFaixa) / 100)
            CASE "Cape Seal (TSS+Micro)": Custo = CapeSealm3 * (HRAC(IFaixa) / 100)
            CASE ELSE
                PRINT "ERRO: tipo nao identificado ==> "; CamadaRest$(IRodov)
                B$ = "": WHILE B$ = "": B$ = INKEY$: WEND
        END SELECT
        Custo = Custo + Fresagemm3 * (H2AC(IFaixa) / 100)
        IF (Medida$ = "MF+CP" OR Medida$ = "FR+MF+CP") THEN Custo = Custo + Pintura + Reperf * (HRMF / 2)
    CASE "MF+RC"
        GOSUB 5100
        Custo = (HRAC(IFaixa) / 100) * CBUQm3 + (Ncamadas + 1) * Pintura + Reperf * (HRMF / 2)
    CASE "FR+RC", "RRV", "FR+MF+RC"
        GOSUB 5100
        Custo = (HRAC(IFaixa) / 100) * CBUQm3 + Fresagemm3 * (H2AC(IFaixa) / 100) + Ncamadas * Pintura + Reperf * (HRMF / 2)
    CASE ELSE
        PRINT "ERRO: Medida desconhecida no acostamento = "; MedidaAcost$(IFaixa); " na faixa "; IFaixa
END SELECT
RETURN


3000 '
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -      Evolucao da Condicao do Pavimento apos um Ano    -
' -                      (Subrotina)                      -
' -  Dados: H1REV, SN, Nacum, CBRSL, PSI, IRI0(IFaixa),   -
' -         ALPHA(IFaixa), Nano, QImed, HRef(IFaixa),     -
' -         IRec(IFaixa), ATRmed, TR23                    -
' -  Saida: PSI, QImed, IGG, TR23, ATRmed                 -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
IF PSI <= 4.5 THEN
    IGG(IFaixa) = ALFAIGG(IFaixa) * ((((4.5 / PSI) - 1) / .007635) ^ (1 / 1.065))
    IF IGG(IFaixa) > 500 THEN IGG(IFaixa) = 500
ELSE
    IGG(IFaixa) = 0
END IF
PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
PSR = 2 * PSI - PSIQI
IF UltCamada$(IFaixa) = "CCP" THEN
    IGGat = (309.22 - 61.844 * PSR) / (PSR + 0.616)
    ' Dados
    Epsi = 100 * CBRSL(IFaixa) / 0.0703
    K = Epsi / 19.4
    RTF = 640
    Dcm = H1REV(IFaixa)
    D = Dcm / 2.54
    PT = 2.5
    J = 3.2
    CD = 1
    PSI0 = 4.5
    ' Correlacoes
    RTFMPA = RTF * .0703 / 10
    RCS = 10 * ((RTFMPA / .56) ^ 1.67)
    EC = 15110 * (RCS ^ .5)
    EC = EC / .0703
    ' Parametros complementares
    DPSI = PSI0 - PT
    ZR = ZRmpd
    S0 = S0mpd
    ' Modelo
    W18# = 215.63 * J * ((D ^ .75) - (18.42 / ((EC / K) ^ .25)))
    W18# = (4.22 - .32 * PT) * LOG(RTF * CD * ((D ^ .75) - 1.132) / W18#) / LOG(10)
    A# = (LOG(DPSI / (4.5 - 1.5)) / LOG(10)) / (1 + (1.624E+07 / ((D + 1) ^ 8.46)))
    W18# = W18# + A# - .06 + 7.35 * (LOG(D + 1) / LOG(10)) + ZR * S0
    W18# = (10 ^ W18#) / 1.E6
    ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSI0 / 5))
    FcCCP = 0.3
    ALFA = FcCCP * ALFAA
    Nyear = Nano(IFaixa) / 1000000!
    DeltaN = Nyear
    DeltaPSI = ALFA * DeltaN * PSI * LOG(PSI / 5)
    IF PSI < -1 * DeltaPSI THEN DeltaPSI = -PSI
    DeltaQI = (-71.5 / ((PSI + PSI + DeltaPSI) / 2)) * DeltaPSI
    QImed(IFaixa) = QImed(IFaixa) + DeltaQI
    PSI = PSI + DeltaPSI
    IF PSI < .5 THEN PSI = .5
    ' Evolucao do IGG e do PSR
    PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
    PSRat = 2 * PSI - PSIQI
    IF PSRat < 1.0 THEN PSRat = 1.0
    'DeltaPSR = PSRat - PSR
    'DeltaIGG = DeltaPSR * (-61.844 - IGG(IFaixa)) / (.616 + PSR)
    'IGG(IFaixa) = IGG(IFaixa) + DeltaIGG
    IGG(IFaixa) = (309.22 - 61.844 * PSRat) / (PSRat + 0.616)
    IF IGG(IFaixa) > 450 THEN IGG(IFaixa) = 450
    DeltaIGG = IGG(IFaixa) - IGGat
    DeltaTR = DeltaIGG * (5 / 30)
    TR23(IFaixa) = TR23(IFaixa) + DeltaTR
    IF TR23(IFaixa) > 100 THEN TR23(IFaixa) = 100
    ATRmed(IFaixa) = 0
ELSE
    TRmin = 10
    DeltaT = .1
    Nyear = Nano(IFaixa) / 1000000!
    DeltaN = DeltaT * Nyear
    PT = 2.5
    DPSI = PSInovo(IFaixa) - PT
    NE4 = Nacum(IFaixa) / 1000000!
    Nac = Nacum(IFaixa)
    TTIME = Idade(IFaixa)
    IF (Idade(IFaixa) > 20 AND ATRmed(IFaixa) > 12) THEN COMP = .7 ELSE COMP = 1
    LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
    SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
    FOR II = 1 TO 10
        ' Evolucao do PSI
        Nac = Idade(IFaixa) * Nano(IFaixa)
        Nf = T0(IFaixa) * ALPHA0(IFaixa) * Nano(IFaixa)
        IF TR23(IFaixa) < TRmin THEN
            ALFA = ALPHA(IFaixa)
        ELSE
            ALFA = ALPHA2(IFaixa)
        END IF
        IF IRec(IFaixa) = 0 THEN
            FcIRImed = 1: SigmaIRI = .48
            MR = 100 * CBRSL(IFaixa) / .0703
            VRmax = 25
            VRmin = 5
            SNx = SN(IFaixa)
            GOSUB 3050
        ELSE
            FcIRImed = 1.883: SigmaIRI = 1.905
            IF UltCamada$(IFaixa) = "CBUQ" THEN
                VRmax = 64.43 * (5 ^ -.76) * ((HrecExist(IFaixa) / 2.54) ^ .37)
                VRmin = 64.43 * (25 ^ -.76) * ((HrecExist(IFaixa) / 2.54) ^ .37)
                SNrecap = .44 * HRef(IFaixa) / 2.54
                MR = MRfound(IFaixa) / .0703
                SNx = SNrecap
                GOSUB 3050
            ELSE
                VRmax = 10
                VRmin = 2
                DeltaPSI = -A1rest(IRodov) * DeltaN / EXP((A0rest(IRodov) + A2rest(IRodov) * SN(IFaixa) - (PSI + NpsiMod * SErest(IRodov))) / A1rest(IRodov))
            END IF
        END IF
        dPSIdtmin = 2! / VRmax
        dPSIdtmax = 2! / VRmin
        DPSImin = dPSIdtmin * DeltaT
        DPSImax = dPSIdtmax * DeltaT
        IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
        IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
        PSI = PSI + DeltaPSI
        IF PSI < .5 THEN PSI = .5
        ' - - - - - - - - - - - - - - - - - - - - -
        ' - Modelo AASHTO-HDM para irregularidade -
        ' - - - - - - - - - - - - - - - - - - - - -
        IF DEFPSI = 0 THEN
            PSI0ah = 2 * PSInovo(IFaixa) - 5
            IF PSI0ah < 2.55 THEN PSI0ah = 2.55
        ELSE
            PSI0ah = PSInovo(IFaixa)
        END IF
        DPSI = PSI0ah - 2.5
        IF DPSI <= 0.5 THEN DPSI = 0.5
        PSIah = 5 * EXP(-QImed(IFaixa) / 71.5)
        IF PSIah < 0.5 THEN PSIah = 0.5
        IF IRec(IFaixa) = 0 THEN
            ' Analise do subleito
            MR = 100 * CBRSL(IFaixa) / .0703
            SNP = SN(IFaixa)
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAah = FcPavNovoPSISL * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
            DeltaPSI = ALFAah * DeltaT * Nyear * PSIah * LOG(PSIah / 5)
            DeltaQI = (-71.5 / PSIah) * DeltaPSI
            IF DeltaQI > 2 THEN DeltaQI = 2
            QImed(IFaixa) = QImed(IFaixa) + DeltaQI
        ELSE
            IF HrecExist(IFaixa) < 3 THEN
                ' Modelo do HDM-III para irregularidade em caso de CP
                NE4 = NE4 + DeltaT * Nyear
                TTIME = TTIME + DeltaT
                'IRI = (IRI0 + 725 * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
                FcIRI = FcIRImed + Niri * SigmaIRI
                DeltaIRI = (.0153 * (QImed(IFaixa) / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear * EXP(.0153 * TTIME)) * DeltaT
                QImed(IFaixa) = QImed(IFaixa) + 13 * DeltaIRI
            ELSE
                MR = MRfound(IFaixa) / .0703
                SNP = CfRecapPSI * 0.44 * HrecExist(IFaixa) / 2.54
                BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
                ALFAah = FcPavNovoPSIBS * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
                DeltaPSI = ALFAah * DeltaT * Nyear * PSIah * LOG(PSIah / 5)
                DeltaQI = (-71.5 / PSIah) * DeltaPSI
                IF DeltaQI > 2 THEN DeltaQI = 2
                QImed(IFaixa) = QImed(IFaixa) + DeltaQI
            END IF
        END IF
        ' - - - - - - - - - - - - - - -
        ' -  Evolucao do IGG e do PSR -
        ' - - - - - - - - - - - - - - -
        SCI = (309.22 - .616 * IGG(IFaixa)) / (61.844 + IGG(IFaixa))
        SCI0 = 4.97
        DPSI = SCI0 - 2.5
        IF IRec(IFaixa) = 0 THEN
            ' Analise do subleito
            MR = 100 * CBRSL(IFaixa) / .0703
            SNP = SN(IFaixa)
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAah = FcPavNovoSCISL * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(SCI0 / 5))
            ' Analise da camada de base
            SELECT CASE CamBase$(IFaixa)
                CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP", "SC", "CCR"
                CASE "MB", "PMF", "PMQ", "CBUQ", "CBUQ+PMQ", "CBUQ+PMF"
                CASE ELSE
                    CBRbase = 80
                    MR = 20 * CBRbase / .0703
                    SNP = 0.44 * H1REV(IFaixa) / 2.54
                    BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                    W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                    W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
                    ALFAahbs = FcPavNovoSCIBS * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(SCI0 / 5))
                    IF ALFAahbs > ALFAah THEN ALFAah = ALFAahbs
            END SELECT
        ELSE
            ALFAah = (10 ^ (ZRmpd * S0mpd)) * LOG(10.676 / T0(IFaixa)) / (1.222E-6 * Nano(IFaixa))
        END IF
        DeltaSCI = ALFAah * DeltaT * Nyear * SCI * LOG(SCI / 5)
        DeltaIGG = DeltaSCI * (-61.844 - IGG(IFaixa)) / (.616 + SCI)
        IGG(IFaixa) = IGG(IFaixa) + DeltaIGG
        IF IGG(IFaixa) > 350 THEN IGG(IFaixa) = 350
        PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
        PSRat = 2 * PSI - PSIQI
        IF PSRat < 1.5 THEN PSRat = 1.5
        DeltaPSR = PSRat - PSR
        PSR = PSRat
        Nac = Nac + DeltaT * Nano(IFaixa)
        TR = TR23(IFaixa)
        ATR = ATRmed(IFaixa)
        GOSUB 3100
        TR23(IFaixa) = TR
        ATRmed(IFaixa) = ATR
    NEXT II
END IF
RETURN

3050 '
BETA = .4 + (1094 / ((SNx + 1) ^ 5.19))
W18# = (((SNx + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo(IFaixa) / 5))
DeltaPSI = (ALFA / 10 ^ (-ZRmpd * S0mpd)) * ALFAA * DeltaN * PSI * LOG(PSI / 5)
RETURN

3100 '
' Evolucao do trincamento severo
IF IRec(IFaixa) = 0 THEN
    RH = 0
    FcATRmed = 1.3492: SigmaATR = .5612
    SELECT CASE CamBase$(IFaixa)
        CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP", "SC", "CCR"
            V1 = 8.7: V2 = 12.5
        CASE ELSE
            V1 = 6.3: V2 = 8.7
    END SELECT
ELSE
    RH = 1
    IF UltCamada$(IFaixa) = "CBUQ" THEN
        V1 = 5: V2 = 7.6
        FcATRmed = 1.2464: SigmaATR = .8204
    ELSE
        V1 = 5 / T0(IFaixa)
        IF V1 < 5 THEN V1 = 5
        V2 = (31 / 10.2) * V1
        FcATRmed = 1.8168: SigmaATR = .8717
    END IF
END IF
IF TTIME <= T0(IFaixa) THEN
    dTRdt = 0
ELSE
    IF TR > 0 THEN
        IF TR > 30 THEN dTRdt = V2 ELSE dTRdt = V1
    ELSE
        dTRdt = V1
    END IF
END IF
TR = TR + dTRdt * DeltaT
IF TR > 100 THEN TR = 100
' Evolucao dos afundamentos em trilha de roda
MMP = .123
FcATR = FcATRmed + Ngauss * SigmaATR
ERM = .0902 + .0384 * (D0(IFaixa) / 100) - .009 * RH + .00158 * MMP * TR
dATR = (.166 * FcATR * (COMP ^ -2.3) * (TTIME ^ (.166 - 1)) * (SNC ^ -.502) * (Nac ^ ERM) + ERM * ATR * (Nyear / NE4)) * DeltaT
ATR = ATR + dATR
RETURN


4000 '
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -         Aplicacao da Medida de Manutencao Indicada        -
' -                        (Subrotina)                        -
' -   Dados: Medida$, PSI, ATR, QIest, HR, HC, H1             -
' -   Saida: PSI, ATR, TR, QIest, Age, HR, H1, SN             -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
PCR4 = TR23(IFaixa)
Nacum(IFaixa) = 0
Age = 0!
IDS = 0
TR23(IFaixa) = 0
SELECT CASE Medida$
    CASE "RRP", "RRT", "RECL"
        QIest = 15
        IRI0(IFaixa) = QIest / 13
        IF Medida$ = "RRP" THEN
            SNnovo = SN(IFaixa) - HC * 0.14 / 2.54
            IF SNnovo < 0 THEN SNnovo = 0
            SNnovo = ((.44 * HR + .14 * (HC - HR)) / 2.54) + SNnovo
        ELSE
            IF Medida$ = "RRT" THEN
                SNnovo = (.44 * HR + .14 * (HC - HR - 20)) / 2.54
                IF CBRSL(IFaixa) < 10 THEN CBRSL(IFaixa) = 10
            ELSE
                SNnovo = SN(IFaixa)
            END IF
        END IF
        LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
        SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
        D0(IFaixa) = 100 * 6.5 * (SNC ^ -1.6)
        UltCamada$(IFaixa) = "CBUQ"
        Restaurado$(IFaixa) = "Sim"
        ALPHA(IFaixa) = .75
        ALPHA0(IFaixa) = 1
        ALPHA2(IFaixa) = 4
        HrecExist(IFaixa) = 0
        HRef(IFaixa) = HR
        IRec(IFaixa) = 0
        T0(IFaixa) = 4.21 * EXP(.139 * SNC - 17.1 * ((Nano(IFaixa) / 1000000!) / (SNC ^ 2)))
        ATRmed(IFaixa) = 0
        H1 = HR
    CASE "RS", "FR+RC", "MF+RC", "RSUP+RC", "FR+MF+RC"
        IF UsaCBUQpol$ = "POL" THEN
            HR = HR / 0.65
        ELSE
            IF UsaCBUQpol$ = "AB" THEN HR = HR / 0.7
        END IF
        GOSUB 6900
        SN(IFaixa) = SN(IFaixa) + ((.44 * HR - .35 * HC) / 2.54)
        IRI0(IFaixa) = QIest / 13
        H1 = H1 + HR - HC
        UltCamada$(IFaixa) = "CBUQ"
        Restaurado$(IFaixa) = "Sim"
        ALPHA(IFaixa) = FCrecap
        ALPHA0(IFaixa) = FC0recap
        ALPHA2(IFaixa) = FC2recap
        IF HC < HrecExist(IFaixa) THEN
            HRef(IFaixa) = HR + Heff(IFaixa)
        ELSE
            HRef(IFaixa) = HR
        END IF
        HrecExist(IFaixa) = HR
        Dc = D0(IFaixa) * (10 ^ (HC / 40))
        P = 4100 / (PI# * 30 * 30 / 4)
        MRfound(IFaixa) = 2 * (1 - .33 * .33) * P * (30 / 2) / (Dc / 1000)
        D0(IFaixa) = Dc * (10 ^ (-HR / 40))
        IRec(IFaixa) = 1
        IF Medida$ = "MF+RC" THEN PCR4 = .15 * PCR4
        TYcr2A = 2.54 * EXP(.0157 * HrecExist(IFaixa) * 10 - .0141 * PCR4)
        TYcr2B = 10.8 * EXP(-1.21 * (D0(IFaixa) / 100) - 1.02 * (Nano(IFaixa) / 1000000!) * (D0(IFaixa) / 100))
        T0(IFaixa) = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
        ATRmed(IFaixa) = ATRmed(IFaixa) * .15
        IF UsaCBUQpol$ = "POL" THEN
            HR = 0.65 * HR
        ELSE
            IF UsaCBUQpol$ = "AB" THEN HR = 0.7 * HR
        END IF
        IF HR < HRmin THEN HR = HRmin
    CASE "CP", "FR+CP", "MF+CP", "RSUP+CP", "FR+MF+CP"
        HR = HRCP(IRodov)
        HC = 0
        IF Medida$ = "FR+CP" THEN
            HC = HR
            ATRmed(IFaixa) = ATRmed(IFaixa) * .15
        ELSE
            IF Medida$ = "CP" THEN
                ATRmed(IFaixa) = ATRmed(IFaixa) - 10 * HR * .5
                IF ATRmed(IFaixa) < 0 THEN ATRmed(IFaixa) = 0
            ELSE
                ATRmed(IFaixa) = 0
                HR = HR + HRMF
            END IF
        END IF
        GOSUB 6900
        ' Efeito estrutural
        H1 = H1 + HR - HC
        UltCamada$(IFaixa) = CamadaRest$(IRodov)
        Restaurado$(IFaixa) = "Sim"
        IRec(IFaixa) = 1
        ALPHA(IFaixa) = FCmicro
        ALPHA0(IFaixa) = FC0micro
        ALPHA2(IFaixa) = FC2micro
        IF (Medida$ = "MF+CP" OR Medida$ = "RSUP+CP") THEN PCR4 = .15 * PCR4
        TYcr2A = 2.54 * EXP(.0157 * HR * 10 - .0141 * PCR4)
        TYcr2B = 10.8 * EXP(-1.21 * (D0(IFaixa) / 100) - 1.02 * (Nano(IFaixa) / 1000000!) * (D0(IFaixa) / 100))
        T0(IFaixa) = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
    CASE ELSE
        PRINT "ERRO: medida nao identificada ==> "; Medida$
        B$ = "": WHILE B$ = "": B$ = INKEY$: WEND
END SELECT
PSIQI = 5! * EXP(-QIest / 71.5)
PSI = (5 + PSIQI) / 2
IF PSI > 4.95 THEN PSI = 4.95
IF PSI < 2.55 THEN PSI = 2.55
PSInovo(IFaixa) = PSI
RETURN


6500 '
' - - - - - - - - - - - - - - - - - - - - - - -
' -    Calculo da Vida Residual do Pavimento  -
' -                 (Subrotina)               -
' -  Dados: PSI, PSIf, ALPHA(IFaixa), QIest   -
' -  Saida: VR                                -
' - - - - - - - - - - - - - - - - - - - - - - -
COMP = 1
DeltaT = .1
Nyear = Nano(IFaixa) / 1000000!
Nac = Idade(IFaixa) * Nano(IFaixa)
Nf = T0(IFaixa) * ALPHA0(IFaixa) * Nano(IFaixa)
NE4 = Nac / 1000000!
TTIME = Idade(IFaixa)
LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
IF UltCamada$(IFaixa) = "CBUQ" THEN
    DPSI = PSInovo(IFaixa) - 2.5
    IF HrecExist(IFaixa) = 0 THEN
        FcIRImed = 1: SigmaIRI = .48
        VRmax = 25
        VRmin = 5
        BETA = .4 + (1094 / ((SN(IFaixa) + 1) ^ 5.19))
        MR = 100 * CBRSL(IFaixa) / .0703
        W18 = (((SN(IFaixa) + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
        W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
    ELSE
        FcIRImed = 1.883: SigmaIRI = 1.905
        VRmax = 64.43 * (5 ^ -.76) * ((HrecExist(IFaixa) / 2.54) ^ .37)
        VRmin = 64.43 * (25 ^ -.76) * ((HrecExist(IFaixa) / 2.54) ^ .37)
        SNrecap = .44 * HRef(IFaixa) / 2.54
        MR = MRfound(IFaixa) / .0703
        BETA = .4 + (1094 / ((SNrecap + 1) ^ 5.19))
        W18 = (((SNrecap + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
        W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
    END IF
    ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSInovo(IFaixa) / 5))
    Icaso = 1
ELSE
    IF UltCamada$(IFaixa) = "CCP" THEN
        VRmax = 50
        VRmin = 10
        ' Dados
        K = 200
        RTF = 640
        Dcm = H1REV(IFaixa)
        D = Dcm / 2.54
        PT = 2.5
        J = 3.2
        CD = 1
        PSI0 = 4.5
        ' Correlacoes
        RTFMPA = RTF * .0703 / 10
        RCS = 10 * ((RTFMPA / .56) ^ 1.67)
        EC = 15110 * (RCS ^ .5)
        EC = EC / .0703
        ' Parametros complementares
        DPSI = PSI0 - PT
        ZR = ZRmpd
        S0 = S0mpd
        ' Modelo
        W18 = 215.63 * J * ((D ^ .75) - (18.42 / ((EC / K) ^ .25)))
        W18 = (4.22 - .32 * PT) * LOG(RTF * CD * ((D ^ .75) - 1.132) / W18) / LOG(10)
        A# = (LOG(DPSI / (4.5 - 1.5)) / LOG(10)) / (1 + (1.624E+07 / ((D + 1) ^ 8.46)))
        W18 = W18 + A# - .06 + 7.35 * (LOG(D + 1) / LOG(10)) + ZR * S0
        W18 = (10 ^ W18) / 1.E6
        ALFAA = (1 / W18) * LOG(LOG(PT / 5) / LOG(PSI0 / 5))
        Icaso = 3
    ELSE
        VRmax = 10
        VRmin = 2
        Icaso = 2
    END IF
END IF
dPSIdtmin = 2! / VRmax
dPSIdtmax = 2! / VRmin
DPSImin = dPSIdtmin * DeltaT
DPSImax = dPSIdtmax * DeltaT
VR = 0
PSIatual = PSI
TR = TR23(IFaixa)
ATR = ATRmed(IFaixa)
PSIQIe = 5! * EXP(-QIest / 71.5)
PSRest = 2 * PSIatual - PSIQIe
IF PSRest < 0.5 THEN PSRest = 0.5
IGGest = (309.22 - 61.844 * PSRest) / (PSRest + 0.616)
IF IGGest < 0.5 THEN IGGest = 0.5
IF IGGest > 500 THEN IGGest = 500
WHILE (VR < VRmax AND IGGest < IGGcrit AND PSIatual > PSIf AND QIest < QIcrit AND TR < TRcrit AND ATR < ATRcrit)
    VR = VR + DeltaT
    DeltaN = DeltaT * Nyear * (FatorTraf ^ VR)
    IF Icaso = 1 THEN
        Nac = Nac + DeltaT * Nano(IFaixa)
        IF Nac < Nf THEN
            ALFA = ALPHA(IFaixa)
        ELSE
            ALFA = ALPHA2(IFaixa)
        END IF
        DeltaPSI = (ALFA / 10 ^ (-ZRmpd * S0mpd)) * ALFAA * DeltaN * PSIatual * LOG(PSIatual / 5)
    ELSE
        IF Icaso = 2 THEN
            DeltaPSI = -A1rest(IRodov) * DeltaN / EXP((A0rest(IRodov) + A2rest(IRodov) * SN(IFaixa) - (PSIatual + NpsiMod * SErest(IRodov))) / A1rest(IRodov))
        ELSE
            FcCCP = 0.3
            ALFA = FcCCP * ALFAA
            DeltaPSI = ALFA * DeltaN * PSIatual * LOG(PSIatual / 5)
            PSIold = PSIatual
        END IF
    END IF
    IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
    IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
    PSIatual = PSIatual + DeltaPSI
    IF PSIatual < 0.5 THEN PSIatual = 0.5
    IF Icaso < 3 THEN
        TTIME = TTIME + DeltaT
        ' - - - - - - - - - - - - - - - - - - - - -
        ' - Modelo AASHTO-HDM para irregularidade -
        ' - - - - - - - - - - - - - - - - - - - - -
        IF DEFPSI = 0 THEN
            PSI0ah = 2 * PSInovo(IFaixa) - 5
            IF PSI0ah < 2.55 THEN PSI0ah = 2.55
        ELSE
            PSI0ah = PSInovo(IFaixa)
        END IF
        DPSI = PSI0ah - 2.5
        IF DPSI <= 0.5 THEN DPSI = 0.5
        PSIah = 5 * EXP(-QIest / 71.5)
        IF PSIah < 0.5 THEN PSIah = 0.5
        IF IRec(IFaixa) = 0 THEN
            ' Analise do subleito
            MR = 100 * CBRSL(IFaixa) / .0703
            SNP = SN(IFaixa)
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAah = FcPavNovoPSISL * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
            ' Analise da camada de base
            SELECT CASE CamBase$(IFaixa)
                CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP", "SC", "CCR"
                CASE "MB", "PMF", "PMQ", "CBUQ", "CBUQ+PMQ", "CBUQ+PMF"
                CASE ELSE
                    CBRbase = 80
                    MR = 20 * CBRbase / .0703
                    SNP = 0.44 * H1REV(IFaixa) / 2.54
                    BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                    W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                    W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
                    ALFAahbs = FcPavNovoSCIBS * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(SCI0 / 5))
                    IF ALFAahbs > ALFAah THEN ALFAah = ALFAahbs
            END SELECT
            DeltaPSI = ALFAah * DeltaT * Nyear * PSIah * LOG(PSIah / 5)
            DeltaQI = (-71.5 / PSIah) * DeltaPSI
            QIest = QIest + DeltaQI
        ELSE
            IF HrecExist(IFaixa) < 3 THEN
                ' Modelo do HDM-III para irregularidade para o caso de CP
                ' IRI = (IRI0 + 725 * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
                FcIRI = FcIRImed + Niri * SigmaIRI
                DeltaIRI = (.0153 * (QIest / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear * EXP(.0153 * TTIME)) * DeltaT
                QIest = QIest + 13 * DeltaIRI
            ELSE
                MR = MRfound(IFaixa) / .0703
                SNP = CfRecapPSI * 0.44 * HrecExist(IFaixa) / 2.54
                BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
                ALFAah = FcPavNovoPSIBS * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
                DeltaPSI = ALFAah * DeltaT * Nyear * PSIah * LOG(PSIah / 5)
                DeltaQI = (-71.5 / PSIah) * DeltaPSI
                QIest = QIest + DeltaQI
            END IF
        END IF
        ' - - - - - - - - - - - - - - - - -
        ' -  Modelo AASHTO-HDM para o IGG -
        ' - - - - - - - - - - - - - - - - -
        SCI = (309.22 - .616 * IGGest) / (61.844 + IGGest)
        SCI0 = 4.97
        DPSI = SCI0 - 2.5
        IF IRec(IFaixa) = 0 THEN
            ' Analise do subleito
            MR = 100 * CBRSL(IFaixa) / .0703
            SNP = SN(IFaixa)
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAah = FcPavNovoSCISL * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(SCI0 / 5))
            ' Analise da camada de base
            SELECT CASE CamBase$(IFaixa)
                CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP", "SC", "CCR"
                CASE "MB", "PMF", "PMQ", "CBUQ", "CBUQ+PMQ", "CBUQ+PMF"
                CASE ELSE
                    CBRbase = 80
                    MR = 20 * CBRbase / .0703
                    SNP = 0.44 * H1REV(IFaixa) / 2.54
                    BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                    W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                    W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
                    ALFAahbs = FcPavNovoSCIBS * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(SCI0 / 5))
                    IF ALFAahbs > ALFAah THEN ALFAah = ALFAahbs
            END SELECT
        ELSE
            ALFAah = (10 ^ (ZRmpd * S0mpd)) * LOG(10.676 / T0(IFaixa)) / (1.222E-6 * Nano(IFaixa))
        END IF
        DeltaSCI = ALFAah * DeltaT * Nyear * SCI * LOG(SCI / 5)
        DeltaIGG = DeltaSCI * (-61.844 - IGGest) / (.616 + SCI)
        IGGest = IGGest + DeltaIGG
        IF IGGest < 0.5 THEN IGGest = 0.5
        IF IGGest > 500 THEN IGGest = 500
        ' Trincamento e Afundamentos em Trilha de Roda
        NE4 = NE4 + DeltaT * Nyear
        GOSUB 3100
        ' Evolucao do PSR
        PSIQIe = 5! * EXP(-QIest / 71.5)
        PSRe = 2 * PSIatual - PSIQIe
        IF PSRe < 0.5 THEN PSRe = 0.5
        DeltaPSR = PSRe - PSRest
        PSRest = PSRe
    ELSE
        DeltaQI = (-71.5 / ((PSIatual + PSIold) / 2)) * DeltaPSI
        QIest = QIest + DeltaQI
        ' Evolucao do IGG e do PSR
        PSIQIe = 5! * EXP(-QIest / 71.5)
        PSRe = 2 * PSIatual - PSIQIe
        IF PSRe < 0.5 THEN PSRe = 0.5
        DeltaPSR = PSRe - PSRest
        DeltaIGG = DeltaPSR * (-61.844 - IGGest) / (.616 + PSRest)
        IGGest = IGGest + DeltaIGG
        PSRest = PSRe
        DeltaTR = DeltaIGG * (5 / 30)
        TR = TR + DeltaTR
        IF TR > 100 THEN TR = 100
        ATR = 0
    END IF
WEND
IF VR = DeltaT THEN VR = 0
RETURN
  

8000 '
' - - - - - - - - - - - - - - - - - - - - - - -
' -  Compatibilizacao Geometrica de Solucoes  -
' -          entre Faixas de Trafego          -
' -                (Subrotina)                -
' - - - - - - - - - - - - - - - - - - - - - - -
CotaMax = 0
FaixaMax = 1
FOR IFaixa = 1 TO NFaixas(ISTH)
    SELECT CASE MedidaF$(IFaixa)
        CASE "RS", "CP", "RSUP+RC", "RSUP+CP"
            Cota = Hrec(IFaixa)
        CASE "FR+RC", "FR+CP"
            Cota = Hrec(IFaixa) - Hfres(IFaixa)
            IF Cota < 0 THEN Cota = 0
        CASE "MF+RC", "MF+CP", "FR+MF+RC", "FR+MF+CP"
            Cota = Hrec(IFaixa) + HRMF
        CASE ELSE
            Cota = 0
    END SELECT
    CotaFaixa(IFaixa) = Cota
    IF CotaFaixa(IFaixa) > CotaMax THEN
        CotaMax = CotaFaixa(IFaixa)
        FaixaMax = IFaixa
    END IF
NEXT IFaixa
Compat$ = "Nao"
FOR IFaixa = 1 TO NFaixas(ISTH)
    IF CotaFaixa(IFaixa) < CotaMax THEN Compat$ = "Sim"
NEXT IFaixa
FOR IFaixa = 1 TO NFaixas(ISTH)
    IF IPRIOR(ISTH, IFaixa) >= IPFORC THEN Compat$ = "Nao"
NEXT IFaixa
IF (Compat$ = "Nao" OR Achou$ = "Sim") THEN 8100
' Tenta compatibilizar a faixa de maxima elevacao de greide com as demais
FOR IFaixa = 1 TO NFaixas(ISTH)
    Delta = CotaMax - CotaFaixa(IFaixa)
    IF Delta > 0 THEN
        SELECT CASE MedidaF$(FaixaMax)
            CASE "RS", "FR+RC", "MF+RC", "RSUP+RC", "FR+MF+RC"
                DeltaL = Delta - (HRmin - HRCP(IRodov))
                SELECT CASE MedidaF$(IFaixa)
                    CASE "CR", "CL", "ST", ""
                        IF Delta >= HRmin THEN
                            MedidaF$(IFaixa) = "RS"
                            Hfres(IFaixa) = 0
                            Hrec(IFaixa) = Delta
                        ELSE
                            MedidaF$(IFaixa) = "FR+RC"
                            Hfres(IFaixa) = HRmin - Delta
                            Hrec(IFaixa) = HRmin
                            IF Hfres(IFaixa) < HCmin THEN
                                MedidaF$(IFaixa) = "RS"
                                Hfres(IFaixa) = 0
                            END IF
                        END IF
                    CASE "CP", "RSUP+CP"
                        IF DeltaL >= 0 THEN
                            MedidaF$(IFaixa) = "RS"
                            Hfres(IFaixa) = 0
                            Hrec(IFaixa) = DeltaL + HRmin
                        ELSE
                            MedidaF$(IFaixa) = "FR+RC"
                            Hfres(IFaixa) = -DeltaL
                            Hrec(IFaixa) = HRmin
                            IF Hfres(IFaixa) < HCmin THEN
                                MedidaF$(IFaixa) = "RS"
                                Hfres(IFaixa) = 0
                            END IF
                        END IF
                    CASE "FR+CP"
                        MedidaF$(IFaixa) = "FR+RC"
                        Hrec(IFaixa) = HRmin
                        IF DeltaL >= 0 THEN
                            HFx = Hrec(IFaixa) + DeltaL
                            IF HFx <= HRmax THEN
                                Hrec(IFaixa) = HFx
                                IF Hfres(IFaixa) < HCmin THEN
                                    MedidaF$(IFaixa) = "RS"
                                    Hfres(IFaixa) = 0
                                END IF
                            ELSE
                                Hfres(IFaixa) = Hfres(FaixaMax)
                                Hrec(IFaixa) = Hrec(FaixaMax)
                                MedidaF$(IFaixa) = MedidaF$(FaixaMax)
                            END IF
                        ELSE
                            Hfres(IFaixa) = Hfres(IFaixa) - DeltaL
                            IF Hfres(IFaixa) < HCmin THEN
                                MedidaF$(IFaixa) = "RS"
                                Hfres(IFaixa) = 0
                            END IF
                        END IF
                    CASE "MF+CP", "FR+MF+CP"
                        IF DeltaL >= 0 THEN
                            MedidaF$(IFaixa) = "MF+RC"
                            Hrec(IFaixa) = HRmin + DeltaL
                        ELSE
                            MedidaF$(IFaixa) = "RS"
                            Hrec(IFaixa) = Delta + HRCP(IRodov) + 2
                        END IF
                    CASE "RS", "MF+RC", "FR+RC", "RSUP+RC", "FR+MF+RC"
                        Hrec(IFaixa) = Hrec(IFaixa) + Delta
                    CASE "RRV", "RRP", "RRT", "RECL"

                    CASE ELSE
                        PRINT "ERRO: medida nao identificada = "; MedidaF$(IFaixa)
                        B$ = "": WHILE B$ = "": B$ = INKEY$: WEND
                END SELECT
            CASE "CP", "FR+CP", "MF+CP", "RSUP+CP", "FR+MF+CP"
                MedidaF$(IFaixa) = MedidaF$(FaixaMax)
                Hrec(IFaixa) = Hrec(FaixaMax)
                Hfres(IFaixa) = Hfres(FaixaMax)
            CASE ELSE
                PRINT "ERRO. Medida desconhecida: "; MedidaF$(FaixaMax)
        END SELECT
    END IF
NEXT IFaixa
8100 ' Solucao para os Acostamentos, apos a compatibilizacao da pista
CotaMax = 0
FOR IFaixa = 1 TO NFaixas(ISTH)
    SELECT CASE MedidaF$(IFaixa)
        CASE "RS", "CP", "RSUP+RC", "RSUP+CP"
            Cota = Hrec(IFaixa)
        CASE "FR+RC", "FR+CP"
            Cota = Hrec(IFaixa) - Hfres(IFaixa)
            IF Cota < 0 THEN Cota = 0
        CASE "MF+RC", "MF+CP", "FR+MF+RC", "FR+MF+CP"
            Cota = Hrec(IFaixa) + HRMF
        CASE ELSE
            Cota = 0
    END SELECT
    CotaFaixa(IFaixa) = Cota
    IF CotaFaixa(IFaixa) > CotaMax THEN CotaMax = CotaFaixa(IFaixa)
NEXT IFaixa
FOR IFaixa = 1 TO NFaixas(ISTH)
    IF (PISTA$ = "DUPLA" AND IFaixa = 1) THEN
        MedidaAcost$(IFaixa) = MedidaF$(IFaixa)
        HRAC(IFaixa) = Hrec(IFaixa)
        H2AC(IFaixa) = Hfres(IFaixa)
    ELSE
        IF DegrauAcost(IFaixa) >= 0 THEN HRACOST = CotaMax + DegrauAcost(IFaixa) ELSE HRACOST = CotaMax
        IF HRACOST <= DEGRAUadm THEN
            HRAC(IFaixa) = 0
            IF PSIacost(IFaixa) >= 3.5 THEN MedidaAcost$(IFaixa) = "CR" ELSE MedidaAcost$(IFaixa) = "CL"
        ELSE
            IF HRACOST <= (DEGRAUadm + 1.2) THEN
                HRAC(IFaixa) = 1.2
                IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN MedidaAcost$(IFaixa) = "TSS" ELSE MedidaAcost$(IFaixa) = "CP"
            ELSE
                IF HRACOST <= (DEGRAUadm + 2!) THEN
                    HRAC(IFaixa) = 2!
                    IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN MedidaAcost$(IFaixa) = "TSD" ELSE MedidaAcost$(IFaixa) = "CBUQ"
                ELSE
                    IF HRACOST <= (DEGRAUadm + 14!) THEN
                        IF PSIacost(IFaixa) >= 2! THEN
                            IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN MedidaAcost$(IFaixa) = "PMF" ELSE MedidaAcost$(IFaixa) = "CBUQ"
                            HRAC(IFaixa) = HRACOST - DEGRAUadm
                        ELSE
                            MedidaAcost$(IFaixa) = "RRP"
                            H2AC(IFaixa) = HbaseAcost
                            IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN HRAC(IFaixa) = 2.5 ELSE HRAC(IFaixa) = 4
                        END IF
                    ELSE
                        MedidaAcost$(IFaixa) = "RRT"
                        H2AC(IFaixa) = (HRACOST - DEGRAUadm) - HRAC(IFaixa)
                        IF H2AC(IFaixa) < 12 THEN H2AC(IFaixa) = 12
                        IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN HRAC(IFaixa) = 2.5 ELSE HRAC(IFaixa) = 4
                    END IF
                END IF
            END IF
        END IF
        IF PSIacost(IFaixa) = -1 THEN
            MedidaAcost$(IFaixa) = "CR"
            HRAC(IFaixa) = 0
            H2AC(IFaixa) = 0
        END IF
    END IF
NEXT IFaixa
RETURN


6700 '
' - - - - - - - - - - - - -
' -   Trafego de Projeto  -
' -      (Subrotina)      -
' - - - - - - - - - - - - -
NPA = 0
IF PERIODO < 1 THEN PERIODO = 1
PER = INT(PERIODO)
FOR IAA = 1 TO PER
    NPA = NPA + (FatorTraf ^ IAA)
NEXT IAA
NPA = NPA * Nyear / 1000000!
RETURN


6900 '
' - - - - - - - - - - - - - - - - - - - -
' -   Irregularidade apos Recapeamento  -
' -        (Subrotina do HDM-III)       -
' -   Dados: HR, HC, QIest, QI0adm      -
' -   Saida: QIest                      -
' - - - - - - - - - - - - - - - - - - - -
IF QIest > 19 THEN
    QIB = 19! + ((QIest - 19!) / (.602 * HC + 1))
ELSE
    QIB = QIest
END IF
IF QI0adm > 0 THEN
    DQI = QI0adm - QIB
ELSE
    H0 = 10 * HR
    IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
    IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
    IF H0 < 40 THEN X = H0 ELSE X = 40
    HOV = 3 - ((H0L + X) / 40)
    X1 = 19.42 - .78 * QIBL - .068 * H0
    IF H0 > 20 THEN Y = H0 - 20 ELSE Y = 0
    X2 = -19.5 - .008 * QIBL * Y
    IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
    IF DQI > 0 THEN DQI = 0
END IF
QIest = QIB + DQI
RETURN
