procedure Estrategia;
const
   NFaixasMax = 4;
   NRodovMax = 50;
   NSTHmax := 5000;
   NPeriodosMax := 40;
   PI := 3.141592654;
var
  AnoBase, NPeriodos, i, Modo, NRodov, Code, NPP, j, NPolos, NSTHMAXIMO,
    IRodov, NFields, NMODELOS, NitensCL, NSTH, NPSIT, Ano: integer;
  ArqDados, ArqIn, ArqOut: TextFile;
  PP, inflacao, VRminFinal, PPmax, Arest, Brest, PSRrest: Single;
  Custo, PSI, Ocorr, VR, VRmed, PPrest, PSImed, RestrAnual, Deficit,
    CUSTOT: array [1..NPeriodosMax] of Single;
  CustoPolo, RestrPolo: array [1..NRodovMax, 1..NPeriodosMax] of Single;
  Programa, Dados, Calc, Arquivo, ArqDbf, ArqCsv, DadosAnoBase, Linha,
    CRest, RedeRestric: string;
  Rodovia: array [1..NRodovMax] of string[3];
  ARQ: string[3];
  Year: string[4];
  Parametro, VRat: string[5];
  CustoP, ConserP: array [1..NRodovMax] of Single;
  VDMUni, Nacum, VidaRes, CotaFaixa, RLcost: array [1..NFaixasMax] of Single;
  ALFAIGG, PSInovo, SN, HREFORCO, HRef, Heff, D0, MRfound, PSIacost,
    DegrauAcost, HRAC, H2AC, CustoAcost, QImed, H1REV, HrecExist, Idade, Nano,
    Hfres, Hrec, CustoFaixa, IRI0, ALPHA: array [1..NFaixasMax] of Single;
  UltCamada, REVEST, Restaurado, MedidaAcost, MedidaF: array [1..NFaixasMax] of string;
  ICalib, IRec: array [1..NFaixasMax] of integer;
  PSIat, Aream2, AreaAcost: array [1..NSTHmax, 1..NFaixasMax] of Single;
  IPRIOR, EXECF: array [1..NSTHmax, 1..NFaixasMax] of integer;
  PSImedSTH: array [1..NSTHmax] of Single;
  NFaixas: array [1..NSTHmax] of integer;
  Trecho, MatCP, CamadaRest: array [1..NRodovMax] of string;
  IPMAXPolo, STHPRIPolo, NSTHI, NSTHRODOV: array [1..NRodovMax] of integer;
  CostPr, NewRestP, CustoCLP, CTotal, FCnovorede, FCrecaprede, FCmicroCA,
    FC0novorede, FC0recaprede, FC0microCA, FC2novorede, FC2recaprede,
    FC2microCA, HRCP, A0rest, PSR0rest, B0rest: array [1..NRodovMax] of Single;
  Code: array [1..NRodovMax, 1..NSTHmax] of integer;
  Campo: array [1..70] of string[15];
  PSIitemCL, ARepCL: array [1..20] of Single;
begin
  AssignFile(ArqDados, 'Diretor.dat');
  Reset(ArqDados);
  Readln(ArqDados, AnoBase);
  Readln(ArqDados, NPeriodos);
  Readln(ArqDados, Programa);
  Readln(ArqDados, Dados);
  Readln(ArqDados, Calc);
  Readln(ArqDados, DadosAnoBase);
  CloseFile(ArqDados);
  Year := IntToStr(AnoBase);
  { Cdigos de identificao das rodovias que compem a rede }
  Arquivo := DadosAnoBase + 'Rodovias.dat';
  AssignFile(ArqDados, Arquivo);
  Reset(ArqDados);
  Readln(ArqDados, NRodov);
  for i := 1 to NRodov do
    Readln(ArqDados, Rodovia[i]);
  CloseFile(ArqDados);
  NPolos := NRodov;
  { Arquivos de dados }
    Arquivo := Calc + 'Dados.dat';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Modo);
    Readln(ArqDados, PP);
    Readln(ArqDados, PPmax);
    Readln(ArqDados, NPP);
    Readln(ArqDados, inflacao);
    CloseFile(ArqDados);
    Arquivo := Calc + 'VRmin.dat';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, VRminFinal);
    CloseFile(ArqDados);
  { Numero de Subtrechos Homogeneos por rodovia }
    Arquivo := Calc + 'NSTHROD.OUT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, NSTHMAXIMO);
    for i := 1 to NRODOV do
      Readln(ArqDados, NSTHRODOV[i]);
    CloseFile(ArqDados);
  { Leitura dos codigos numericos que identificam os Subtrechos Homogeneos }
    for i := 1 to NRODOV do
      begin
        Arquivo := Calc + 'CODE' + Rodov[i] + '.STH';
        AssignFile(ArqDados, Arquivo);
        Readln(ArqDados, NSTHI[i]);
        for j := 1 to NSTHI[i] do
            Readln(ArqDados, Code[i, j]);
        CloseFile(ArqDados);
      end;
  { Modelos de previsao de desempenho para conserva pesada }
    Arquivo := Calc + 'CPtrecho.csv';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Linha);
    for IRodov := 1 to NRODOV do
      begin
        Readln(ArqDados, Linha);
        NFields := 3;
        j := 1;
        for i := 1 to NFields do
          Campo[i] := '';
        for i := 1 to Length(Linha) do
          begin
            if Linha[i] = ',' then
              j := j + 1
            else
              if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
          end;
        TrechoDescr := Campo[1];
        MatCP[IRodov] := Campo[2];
        HRCP[IRodov] := StrToFloat(Campo[3]);
        Arquivo := Programa + 'MODELOS.DAT';
        AssignFile(ArqIn, Arquivo);
        Reset(ArqIn);
        Readln(ArqIn, NMODELOS);
        for j := 1 to NMODELOS do
          begin
            Readln(ArqIn, CRest);
            Readln(ArqIn, Arest);
            Readln(ArqIn, Brest);
            Readln(ArqIn, PSRrest);
            if CRest = MatCP[IRodov] then
              begin
                CamadaRest[IRodov] := CRest;
                A0rest[IRodov] := Arest;
                B0rest[IRodov] := Brest;
                PSR0rest[IRodov] := PSRrest;
              end;
          end;
        CloseFile(ArqIn);
      end;
    CloseFile(ArqDados);
  { Fatores de calibracao medios da rede }
    Arquivo := Calc + 'CALIB.CSV';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Linha);
    for i := 1 to NRODOV do
      begin
        Readln(ArqDados, Linha);
        NFields := 4;
        j := 1;
        for i := 1 to NFields do
          Campo[i] := '';
        for i := 1 to Length(Linha) do
          begin
            if Linha[i] = ',' then
              j := j + 1
            else
              if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
          end;
        Trecho[i] := Campo[1];
        FCnovorede[i] := StrToFloat(Campo[2]);
        FCrecaprede[i] := StrToFloat(Campo[3]);
        FCmicroCA[i] := StrToFloat(Campo[4]);
      end;
    Readln(ArqDados, Linha);
    NFields := 4;
    j := 1;
    for i := 1 to NFields do
      Campo[i] := '';
    for i := 1 to Length(Linha) do
      begin
        if Linha[i] = ',' then
          j := j + 1
        else
          if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
      end;
    Rede := Campo[1];
    FCnovo := StrToFloat(Campo[2]);
    FCrecap := StrToFloat(Campo[3]);
    FCmicro := StrToFloat(Campo[4]);
    CloseFile(ArqDados);
    Arquivo := Calc + 'CALIB0.CSV';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Linha);
    for i := 1 to NRODOV do
      begin
        Readln(ArqDados, Linha);
        NFields := 4;
        j := 1;
        for i := 1 to NFields do
          Campo[i] := '';
        for i := 1 to Length(Linha) do
          begin
            if Linha[i] = ',' then
              j := j + 1
            else
              if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
          end;
        Trecho[i] := Campo[1];
        FC0novorede[i] := StrToFloat(Campo[2]);
        FC0recaprede[i] := StrToFloat(Campo[3]);
        FC0microCA[i] := StrToFloat(Campo[4]);
      end;
    Readln(ArqDados, Linha);
    NFields := 4;
    j := 1;
    for i := 1 to NFields do
      Campo[i] := '';
    for i := 1 to Length(Linha) do
      begin
        if Linha[i] = ',' then
          j := j + 1
        else
          if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
      end;
     Rede := Campo[1];
     FC0novo := StrToFloat(Campo[2]);
     FC0recap := StrToFloat(Campo[3]);
     FC0micro := StrToFloat(Campo[4]);
     CloseFile(ArqDados);
    Arquivo := Calc + 'CALIB2.CSV';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Linha);
    for i := 1 to NRODOV do
      begin
        Readln(ArqDados, Linha);
        NFields := 4;
        j := 1;
        for i := 1 to NFields do
          Campo[i] := '';
        for i := 1 to Length(Linha) do
          begin
            if Linha[i] = ',' then
              j := j + 1
            else
              if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
          end;
        Trecho[i] := Campo[1];
        FC2novorede[i] := StrToFloat(Campo[2]);
        FC2recaprede[i] := StrToFloat(Campo[3]);
        FC2microCA[i] := StrToFloat(Campo[4]);
      end;
    Readln(ArqDados, Linha);
    NFields := 4;
    j := 1;
    for i := 1 to NFields do
      Campo[i] := '';
    for i := 1 to Length(Linha) do
      begin
        if Linha[i] = ',' then
          j := j + 1
        else
          if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
      end;
    Rede := Campo[1];
    FC2novo := StrToFloat(Campo[2]);
    FC2recap := StrToFloat(Campo[3]);
    FC2micro := StrToFloat(Campo[4]);
    CloseFile(ArqDados);
  { Percentagem da area que deve receber reparos localizados, CL }
    Arquivo := Calc + 'REPAROS.CSV';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, Linha);
    NitensCL := 0;
    while not Eof(ArqDados)
      begin
        NitensCL := NitensCL + 1;
        Readln(ArqDados, Linha);
        NFields := 2;
        j := 1;
        for i := 1 to NFields do
          Campo[i] := '';
        for i := 1 to Length(Linha) do
          begin
            if Linha[i] = ',' then
              j := j + 1
            else
              if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
          end;
        PSIitemCL[NitensCL] := StrToFloat(Campo[1]);
        ARepCL[NitensCL] := StrToFloat(Campo[2]);
      end;
    CloseFile(ArqDados);
  { Parametros para medir o desempenho das estrategias [Ocorrencias em %] e
    criterio para Priorizacao das Restauracoes sob Restricoes Orcamentarias }
    Arquivo := Calc + 'PARAM.DAT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, PSIref);
    Readln(ArqDados, PTRAF);
    Readln(ArqDados, PPSI);
    CloseFile(ArqDados);
  { Criterios complementares para as arvores de decisao }
    Arquivo := Calc + 'CRITERIO.DAT';
    AssignFile(ArqDados, Arquivo);
    Reset(ArqDados);
    Readln(ArqDados, TRcrit);
    Readln(ArqDados, QIcrit);
    Readln(ArqDados, ATRcrit);
    Readln(ArqDados, ATRITOcrit);
    CloseFile(ArqDados);
  { Numero total de Subtrechos Homogeneos da rede }
    NSTH := 0;
    for i := 1 to NRODOV do
      NSTH := NSTH + NSTHRODOV[i];
  { Restricoes Orcamentarias }
    NPSIT := 1;
    case Modo of
         1:
                      RedeRestric := 'Para toda a rede';
                      for i := 1 to NPeriodos do
                        RestrAnual[i] := 1E+30;
                      VSMIN := PP;
                      ARQ := 'EB';
         2:
                      Arquivo := Calc + 'RESTRIC.DAT';
                      AssignFile(ArqDados, Arquivo);
                      Reset(ArqDados);
                      Readln(ArqDados, Linha);
                      Readln(ArqDados, RedeRestric);
                      CloseFile(ArqDados);
                      if RedeRestric = 'Para toda a rede' then
                         begin
                           Arquivo := Calc + 'ROrede.csv';
                           AssignFile(ArqDados, Arquivo);
                           Reset(ArqDados);
                           Readln(ArqDados, Linha);
                           for i := 1 to NPeriodos do
                             begin
                               Readln(ArqDados, Linha);
                               NFields := 3;
                               j := 1;
                               for i := 1 to NFields do
                                 Campo[i] := '';
                               for i := 1 to Length(Linha) do
                                 begin
                                   if Linha[i] = ',' then
                                     j := j + 1
                                   else
                                     if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
                                 end;
                               Ano := StrToInt(Campo[1]);
                               RestrAnual[i] := StrToFloat(Campo[2]);
                               PPrest[i] := StrToFloat(Campo[3]);
                             end;
                           CloseFile(ArqDados);
                         end
                      else
                         begin
                           for IRodov := 1 to NRODOV do
                             begin
                               Arquivo := Calc + 'ROtre' + Rodov[IRodov] + '.csv';
                               AssignFile(ArqDados, Arquivo);
                               Reset(ArqDados);
                               Readln(ArqDados, Linha);
                               for i := 1 to NPeriodos do
                                 begin
                                   Readln(ArqDados, Linha);
                                   NFields := 3;
                                   j := 1;
                                   for i := 1 to NFields do
                                     Campo[i] := '';
                                   for i := 1 to Length(Linha) do
                                     begin
                                       if Linha[i] = ',' then
                                         j := j + 1
                                       else
                                         if Linha[i] <> '"' then Campo[j] := Campo[j] + Linha[i];
                                     end;
                                   ANO := StrToInt(Campo[1]);
                                   RestrPolo[IRodov, i] := StrToFloat(Campo[2]);
                                   PPrest[i] := StrToFloat(Campo[3]);
                               NEXT I
                               CloseFile(ArqDados);
                           NEXT IRodov
                         end;
                      ARQ := 'RO';
         else:
                      Writeln('ERRO');
    end;
    Arquivo := Calc + ARQ + '.CSV';
    AssignFile(ArqOut, Arquivo);
    Rewrite(ArqOut);
    Writeln(ArqOut, 'Ano,', 'STH,', 'Iniciokm,', 'Finalkm,', 'AcostLE,', 'HRLE,', 'H2LE,', 'MedidaF1,', 'Hfrescm1,', 'HReccm1,', 'MedidaF2,', 'Hfrescm2,', 'HReccm2,', 'MedidaF3,', 'Hfrescm3,', 'HReccm3,', 'MedidaF4,', 'Hfrescm4,', 'HReccm4,', 'AcostLD,', 'HRLD,', 'H2LD,');



end

{
   CLS
   PRINT
   PRINT '                        * * * * * * * * * * * * *  '
   PRINT '                        *  GERA AS ESTRATEGIAS  *  '
   PRINT '                        * * * * * * * * * * * * *  '

   ' Parametros para o Indice de Prioridade [gerados em Estrat1.bas]
     Arquivo := Calc + 'IP.DAT'
     AssignFile(ArqDados, Arquivo); FOR Readln( AS #1
     Readln(ArqDados, VDMmin, VDMmax
     Readln(ArqDados, PSIminRede, PSImaxRede
     CloseFile(ArqDados);1

   Arquivo := Calc + 'ESTSTHS0.DAT'
    AssignFile(ArqDados, Arquivo); FOR Readln( AS #12
   ANO := 0
   Arquivo := Calc + ARQ + STR[ANO] + '.DAT'
    AssignFile(ArqDados, Arquivo); FOR OUTPUT AS #13

   ISTH := 0
   FOR IRodov := 1 TO NRODOV
      
       Arquivo := Calc + ARQ + 'CT' + Rodov[IRodov] + '.CSV'
       AssignFile(ArqDados, Arquivo); FOR OUTPUT AS #15
       WRITE #15, 'ANO', 'STH', 'KMI', 'KMF', 'Custo', 'Custo 1', 'Custo 2', 'Custo 3', 'Custo 4', 'Acost.'
       CloseFile(ArqDados);15
       FOR ISUB := 1 TO NSTHRODOV[IRodov]
           ISTH := ISTH + 1
           Readln(ArqDados2, STH, NFaixas[ISTH], KMI, KMF, CBRSL, FatorVDM, FatorTraf, BASE
           FOR ifaixa := 1 TO NFaixas[ISTH]
               Readln(ArqDados2, ifX, H1REV[ifX], HrecExist[ifX], Idade[ifX], SN[ifX], QImed[ifX], Nano[ifX], IRI0[ifX], ALPHA[ifX], Nacum[ifX], REVEST[ifX], ALFAIGG[ifX]
               Readln(ArqDados2, PSIat[ISTH, ifX], Aream2[ISTH, ifX], VidaRes[ifX], VDMUni[ifX], PSInovo[ifX], Heff[ifX], IRec[ifX], ICalib[ifX], D0[ifX], MRfound[ifX]
               Readln(ArqDados2, AreaAcost[ISTH, ifX], PSIacost[ifX], DegrauAcost[ifX]
           NEXT ifaixa
           WRITE #13, STH, KMI, KMF, CBRSL
           FOR ifX := 1 TO NFaixas[ISTH]
               Restaurado[ifX] := 'Nao'
               UltCamada[ifX] := 'CBUQ'
               HRef[ifX] := HrecExist[ifX]
               WRITE #13, STH, ifX, PSIat[ISTH, ifX], Aream2[ISTH, ifX], VidaRes[ifX], Restaurado[ifX], UltCamada[ifX], VDMUni[ifX], PSInovo[ifX], HRef[ifX], Heff[ifX], IRec[ifX], ICalib[ifX], D0[ifX], MRfound[ifX]
               WRITE #13, H1REV[ifX], HrecExist[ifX], Idade[ifX], SN[ifX], QImed[ifX], Nano[ifX], IRI0[ifX], ALPHA[ifX], Nacum[ifX], ALFAIGG[ifX]
               WRITE #13, AreaAcost[ISTH, ifX], PSIacost[ifX], DegrauAcost[ifX]
           NEXT ifX
       NEXT ISUB
   
   NEXT IRodov
 
   Readln(ArqDados2, PSImed[0], NPSI[0], VRmed[0]
   Readln(ArqDados2, AreaTotal, NUnidAnalise
   WRITE #13, PSImed[0], NPSI[0], VRmed[0]
   WRITE #13, AreaTotal, NUnidAnalise
   CloseFile(ArqDados);12, #13

  ' * * * * * * * * * * * * *
  ' * Geracao da Estrategia *
  ' * * * * * * * * * * * * *

  FOR ANO := 1 TO NPeriodos
   
     PRINT '                   Ano := '; ANO
     ANOcal := ANOBASE + ANO
     CustoTotal := 0
     CustoConserva := 0
     PSImed[ANO] := 0
     VRmed[ANO] := 0
     FOR IPole := 1 TO NPolos
         CustoP[IPole] := 0
         ConserP[IPole] := 0
     NEXT IPole
     if Modo := 2 then VSMIN := PPrest[ANO]
     TotalArea := 0
     NUnid := 0

     Arquivo := Calc + ARQ + STR[ANO - 1] + '.DAT'
      AssignFile(ArqDados, Arquivo); FOR Readln( AS #12
     Arquivo := Calc + ARQ + STR[ANO] + '.DAT'
      AssignFile(ArqDados, Arquivo); FOR OUTPUT AS #13

     Arquivo := Calc + 'MEDIDAS.DAT'
      AssignFile(ArqDados, Arquivo); FOR OUTPUT AS #10

   ISTH := 0
   FOR IRodov := 1 TO NRODOV

       ' Parametros que definem as Arvores de Decisao:
         Arquivo := Calc + 'ARV' + Rodov[IRodov] + '.dat'
         AssignFile(ArqDados, Arquivo); FOR Readln( AS #1
              Readln(ArqDados, IDScrit
              Readln(ArqDados, PSRcrit
              Readln(ArqDados, HRmin
              Readln(ArqDados, HRMAX
              Readln(ArqDados, PSif
              Readln(ArqDados, DEGRAUadm
              Readln(ArqDados, HCMIN
              Readln(ArqDados, VUMin
              Readln(ArqDados, QI0adm
              Readln(ArqDados, HbaseAcost
         CloseFile(ArqDados);1
       
       GOSUB 7000
     
      ' Estado de Superficie no Ano-Base
        NDADOS := 5
        FOR ifX := 1 TO NFaixasMax
            SELECT CASE ifX
                   CASE 1: Faixa := '1'
                   CASE 2: Faixa := '2'
                   CASE 3: Faixa := '3'
                   CASE 4: Faixa := '4'
                   CASE ELSE: PRINT 'ERRO': STOP
            END SELECT
            ISUP := NDADOS + ifX
            Arquivo := Calc + 'SUP' + Rodov[IRodov] + Faixa + '.DAT'
            AssignFile(ArqDados, Arquivo); FOR Readln( AS #ISUP
            ISUPout := ISUP - 4
            Arquivo := Programa + 'Docs\Params\' + 'LVC' + Rodov[IRodov] + Faixa + '.CSV'
            AssignFile(ArqDados, Arquivo); FOR Readln( AS #ISUPout
                 LINE Readln( #ISUPout, LINHA
                 LINE Readln( #ISUPout, LINHA
        NEXT ifX

    FOR ISUB := 1 TO NSTHRODOV[IRodov]

        ISTH := ISTH + 1
        ' Inicializacao de parametros a cada ano
          FOR ifaixa := 1 TO NFaixasMax
              MedidaF[ifaixa] := ''
              Hfres[ifaixa] := 0
              Hrec[ifaixa] := 0
              CustoFaixa[ifaixa] := 0
              MedidaAcost[ifaixa] := ''
              HRAC[ifaixa] := 0
              H2AC[ifaixa] := 0
              CustoAcost[ifaixa] := 0
          NEXT ifaixa
          PSImedSTH[ISTH] := 0
        
        Readln(ArqDados2, STH, KMI, KMF, CBRSL

        FOR ifaixa := 1 TO NFaixas[ISTH]
            
            Readln(ArqDados2, STH, ifX, PSIat[ISTH, ifX], Aream2[ISTH, ifX], VidaRes[ifX], Restaurado[ifX], UltCamada[ifX], VDMUni[ifX], PSInovo[ifX], HRef[ifX], Heff[ifX], IRec[ifX], ICalib[ifX], D0[ifX], MRfound[ifX]
            Readln(ArqDados2, H1REV[ifX], HrecExist[ifX], Idade[ifX], SN[ifX], QImed[ifX], Nano[ifX], IRI0[ifX], ALPHA[ifX], Nacum[ifX], ALFAIGG[ifX]
            Readln(ArqDados2, AreaAcost[ISTH, ifX], PSIacost[ifX], DegrauAcost[ifX]

            ' Indice de Prioridade
              IPSI := 100 * [PSImaxRede - PSIat[ISTH, ifaixa]] / [PSImaxRede - PSIminRede]
              ITRAF := 100 * [VDMUni[ifaixa] - VDMmin] / [VDMmax - VDMmin]
              IPRIOR[ISTH, ifaixa] := [PTRAF * ITRAF + PPSI * IPSI] / [PTRAF + PPSI]
              if IPRIOR[ISTH, ifaixa] < 0 then IPRIOR[ISTH, ifaixa] := .5

        NEXT ifaixa

        ' Verifica alteracao de trafego devido a ampliacoes de pistas
          Arquivo := Calc + 'Duplic.dat'
          AssignFile(ArqDados, Arquivo); FOR Readln( AS #15
               WHILE NOT EOF[15]
                     Readln(ArqDados5, STHampl, AnoAmplia, VDMC[1], VDMC[2], VDMC[3], VDMC[4]
                     if (STHampl := STH AND AnoAmplia := ANO] then
                        FOR ifaixa := 1 TO NFaixas[ISTH]
                            VDMUni[ifaixa] := VDMUni[ifaixa] / 2
                            Nano[ifaixa] := Nano[ifaixa] * [VDMC[ifaixa] / 100]
                        NEXT ifaixa
                     end;
               WEND
          CloseFile(ArqDados);15

       ' - - - - - - - - - - - - - - - - - - - - - - - - - -
       ' -  Evolucao da Condicao do Pavimento apos um Ano  -
       ' - - - - - - - - - - - - - - - - - - - - - - - - - -

         FOR ifaixa := 1 TO NFaixas[ISTH]
          
           VidaRes[ifaixa] := VidaRes[ifaixa] - 1
           if VidaRes[ifaixa] < 0 then VidaRes[ifaixa] := 0
          
           Idade[ifaixa] := Idade[ifaixa] + 1
           PSI := PSIat[ISTH, ifaixa]
           Nano[ifaixa] := Nano[ifaixa] * FatorTraf
           Nacum[ifaixa] := Nacum[ifaixa] + Nano[ifaixa]
           VDMUni[ifaixa] := VDMUni[ifaixa] * FatorVDM
           
           GOSUB 3000

           PSIat[ISTH, ifaixa] := PSI
           if PSI <:= PSif then VidaRes[ifaixa] := 0

           if Idade[ifaixa] >:= 0 then
              if PSIat[ISTH, ifaixa] < PSIref then NPSI[ANO] := NPSI[ANO] + 1
              PSImedSTH[ISTH] := PSImedSTH[ISTH] + PSIat[ISTH, ifaixa] * Aream2[ISTH, ifaixa]
              VRmed[ANO] := VRmed[ANO] + Aream2[ISTH, ifaixa] * VidaRes[ifaixa]
              TotalArea := TotalArea + Aream2[ISTH, ifaixa]
              NUnid := NUnid + 1
           end;

         NEXT ifaixa

    ' - - - - - - - - - - - - - - - - - - - - - - -
    ' - Necessidades de Manutencao da Rede no Ano -
    ' - - - - - - - - - - - - - - - - - - - - - - -
    
     FOR ifaixa := 1 TO NFaixasMax
       
         ISUP := NDADOS + ifaixa
         ISUPout := ISUP - 4
         if ifaixa <:= NFaixas[ISTH] then

            ' Durabilidade esperada para a medida especificada como Conserva Pesada
              NP := 1000000! * [PSR0rest[IRodov] - PSIt[IPSIT]] / [A0rest[IRodov] + B0rest[IRodov] * D0[ifaixa]]
              VSCP := NP / Nano[ifaixa]
           
            ' Estado de Superficie no Ano-Base
              Readln( #ISUP, STH, KMINI, KMFIM, PSR, CR, BL, TT
              Readln( #ISUP, TL, TE, TB, P, D, DS
              Readln( #ISUP, ER, BF, DC, R, ATR, COR
              Readln( #ISUP, EM, DP, EL, PSRACOST, DEGRAUCM, OBS, ATRmed

              Readln( #ISUPout, KMI, KMF, IGGE, ICPF, IES, TR23, TR2, TR3

            ' Solucoes Forcadas [impostas pelo usuario para o periodo de analise]
              RLcost[ifaixa] := 0
              Arquivo := Calc + 'SolForc.csv'
              AssignFile(ArqDados, Arquivo); FOR Readln( AS #1
              LINE Readln(ArqDados, LINHA
              Achou := 'Nao'
              IPFORC := 1000
              WHILE [EOF[1] := False AND Achou := 'Nao']
                    Readln(ArqDados, TrechoForc, STHForc, AnoForc, FaixaForc, MedForc, HCForc, HRForc, RLm2, RLcost[FaixaForc]
                    if (STH := STHForc AND ANOcal := AnoForc AND ifaixa := FaixaForc] then
                       RLperct := RLm2 / Aream2[ISTH, ifaixa]
                       MedidaF[ifaixa] := MedForc
                       Hfres[ifaixa] := HCForc
                       Hrec[ifaixa] := HRForc
                       Medida := MedForc
                       HC := Hfres[ifaixa]
                       HR := Hrec[ifaixa]
                       IPRIOR[ISTH, ifaixa] := IPFORC
                       IPFORC := IPFORC + 1
                       Achou := 'Sim'
                       PSIat[ISTH, ifaixa] := PSIat[ISTH, ifaixa] + RLperct * [4.5 - PSIat[ISTH, ifaixa]]
                       QImed[ifaixa] := QImed[ifaixa] + RLperct * [19 - QImed[ifaixa]]
                    end;
              WEND
              CloseFile(ArqDados);1

            Age := Idade[ifaixa]
            PSI := PSIat[ISTH, ifaixa]
            QI := QImed[ifaixa]
            PSIQI := 5 * EXP[-QI / 71.5]
            PSR := 2 * PSI - PSIQI
            NYEAR := Nano[ifaixa]
            H1 := H1REV[ifaixa]
            DC := D0[ifaixa]
            ' Correlacao PSI x IDS
              PSImax := 4.5
              if PSI <:= PSImax then
                   IDS := ALFAIGG[ifaixa] * [[[[PSImax / PSI] - 1] / .007635] ^ [1 / 1.065]]
              ELSE
                   IDS := 0
              end;

            if Achou := 'Nao' then
               
               ' Necessidade de reforco estrutural:
                 VR := VidaRes[ifaixa]
                 TempoRestante := NPeriodos - ANO
                 if TempoRestante > VSMIN then
                    if (Age >:= 0 AND Age < 1] then PP := VSMIN ELSE PP := VSMIN - VR
                 ELSE
                    PP := TempoRestante + VRminFinal
                 end;
                 if PP < .5 then PP := .5
                 GOSUB 1200
                 HREFORCO[ifaixa] := HRMPD

                if Age >:= 0 then
                       if PSIat[ISTH, ifaixa] < 0 then
                              PSIat[ISTH, ifaixa] := .5
                              PSIacost[ifaixa] := .5
                              PSI := PSIat[ISTH, ifaixa]
                              IDS := 450
                       end;
                       GOSUB 1000
                ELSE
                       Medida := 'CR'
                       HR := 0
                       HC := 0
                end;

                if HC > 0 then
                   RES := HC - INT[HC]
                   if RES >:= .5 then INCR := 1 ELSE INCR := 0
                   HC := INT[HC] + INCR
                end;
                if (HR > 0 AND Medida <> 'CP'] then
                   RES := HR - INT[HR]
                   if RES >:= .5 then INCR := 1 ELSE INCR := 0
                   HR := INT[HR] + INCR
                end;
        
                MedidaF[ifaixa] := Medida
                Hfres[ifaixa] := HC
                Hrec[ifaixa] := HR

            end;

         ELSE

              LINE Readln( #ISUP, LINHA
              LINE Readln( #ISUPout, LINHA

         end;

         ' Evolucao da condicao dos acostamentos apos um ano
           if PSIacost[ifaixa] > 3.5 then
                 DPSI := .05
           ELSE
                 if PSIacost[ifaixa] > 2! then DPSI := .1 ELSE DPSI := .2
           end;
           PSIacost[ifaixa] := PSIacost[ifaixa] - DPSI
           if PSIacost[ifaixa] < 0 then PSIacost[ifaixa] := 0
     
     NEXT ifaixa
   
     ' Compatibiliza a geometria entre as faixas de trafego [incluindo os acostamentos]
       GOSUB 8000
       RestSTH := 'Nao'
       FOR ifaixa := 1 TO NFaixas[ISTH]
           if (MedidaF[ifaixa] := 'FR+CP' OR MedidaF[ifaixa] := 'RS' OR MedidaF[ifaixa] := 'MF+RC' OR MedidaF[ifaixa] := 'FR+RC' OR MedidaF[ifaixa] := 'RRV' OR MedidaF[ifaixa] := 'RRP' OR MedidaF[ifaixa] := 'RRT'] then
                  RestSTH := 'Sim'
           end;
       NEXT ifaixa

       ' Solucoes Forcadas para os acostamentos
         FOR ifaixa := 1 TO NFaixas[ISTH]
             if RestSTH := 'Nao' then
                MedidaAcost[ifaixa] := 'CR'
                HRAC[ifaixa] := 0
                H2AC[ifaixa] := 0
             end;
             Arquivo := Calc + 'AcosForc.csv'
             AssignFile(ArqDados, Arquivo); FOR Readln( AS #1
             LINE Readln(ArqDados, LINHA
             WHILE EOF[1] := False
                   Readln(ArqDados, TrechoForc, STHForc, AnoForc, FaixaForc, MedForc, HCForc, HRForc
                   if (STH := STHForc AND ANOcal := AnoForc AND ifaixa := FaixaForc] then
                      MedidaAcost[ifaixa] := MedForc
                      HRAC[ifaixa] := HRForc
                      H2AC[ifaixa] := HCForc
                   end;
             WEND
             CloseFile(ArqDados);1
         NEXT ifaixa

     ' Leitura dos Custos Unitarios
       GOSUB 500

     FOR ifaixa := 1 TO NFaixas[ISTH]
        
         Medida := MedidaF[ifaixa]
         GOSUB 5000

         CustoFaixa[ifaixa] := Custo
         CustoTotal := CustoTotal + Custo
         if (Medida := 'CR' OR Medida := 'CL' OR Medida := 'ST'] then
            CustoConserva := CustoConserva + Custo
            ConserP[IPolo] := ConserP[IPolo] + Custo
         end;
         CustoP[IPolo] := CustoP[IPolo] + Custo

         ' Custo da Intervencao nos Acostamentos
           GOSUB 2000
           CustoAcost[ifaixa] := Custo * AreaAcost[ISTH, ifaixa]
           CustoTotal := CustoTotal + CustoAcost[ifaixa]
           CustoP[IPolo] := CustoP[IPolo] + CustoAcost[ifaixa]
           if (MedidaAcost[ifaixa] := 'CR' OR MedidaAcost[ifaixa] := 'CL' OR MedidaAcost[ifaixa] := 'ST'] then
                  CustoConserva := CustoConserva + CustoAcost[ifaixa]
                  ConserP[IPolo] := ConserP[IPolo] + CustoAcost[ifaixa]
           end;
     
     NEXT ifaixa

     WRITE #13, STH, KMI, KMF, CBRSL
     FOR ifX := 1 TO NFaixas[ISTH]
         WRITE #13, STH, ifX, PSIat[ISTH, ifX], Aream2[ISTH, ifX], VidaRes[ifX], Restaurado[ifX], UltCamada[ifX], VDMUni[ifX], PSInovo[ifX], HRef[ifX], Heff[ifX], IRec[ifX], ICalib[ifX], D0[ifX], MRfound[ifX]
         WRITE #13, H1REV[ifX], HrecExist[ifX], Idade[ifX], SN[ifX], QImed[ifX], Nano[ifX], IRI0[ifX], ALPHA[ifX], Nacum[ifX], ALFAIGG[ifX]
         WRITE #13, AreaAcost[ISTH, ifX], PSIacost[ifX], DegrauAcost[ifX]
         WRITE #10, STH, CustoFaixa[ifX], MedidaF[ifX], Hfres[ifX], Hrec[ifX], CustoAcost[ifX], MedidaAcost[ifX], HRAC[ifX], H2AC[ifX]
     NEXT ifX

    NEXT ISUB

    FOR ifX := 1 TO NFaixasMax
        ISUP := NDADOS + ifX
        ISUPout := ISUP - 4
        CloseFile(ArqDados);ISUP
        CloseFile(ArqDados);ISUPout
    NEXT ifX

   NEXT IRodov
   Deficit[ANO] := CustoTotal
  
   Readln(ArqDados2, PSImed[0], NPSI[0], VRmed[0]
   Readln(ArqDados2, AreaTotal, NUnidAnalise
   WRITE #13, PSImed[0], NPSI[0], VRmed[0]
   WRITE #13, AreaTotal, NUnidAnalise
   CloseFile(ArqDados);4, #12, #13, #10

    ' - - - - - - - - - - - - - - - - - - - - - - -
    ' -  Define os Segmentos a serem Restaurados  -
    ' - - - - - - - - - - - - - - - - - - - - - - -
    PRINT '                          R.O. := '; RestrAnual[ANO]; '      Custo :='; CustoTotal
   
    if RedeRestric := 'Para toda a rede' then
         if RestrAnual[ANO] >:= CustoTotal then Prioriza := 'Nao' ELSE Prioriza := 'Sim'
    ELSE
         Prioriza := 'Nao'
         FOR IPole := 1 TO NPolos
             if RestrPolo[IPole, ANO] < CustoP[IPole] then Prioriza := 'Sim'
         NEXT IPole
    end;
    
    if Prioriza := 'Nao' then
        
     ' Todas as restauracoes necessarias serao executadas
       PRINT '                          Nao ha necessidade de priorizacao.'
       ISTH := 0
       FOR IRodov := 1 TO NRODOV
           FOR ISUB := 1 TO NSTHRODOV[IRodov]
               ISTH := ISTH + 1
               FOR ifaixa := 1 TO NFaixas[ISTH]
                   EXECF[ISTH, ifaixa] := 1
               NEXT ifaixa
           NEXT ISUB
       NEXT IRodov

       CUSTOT[ANO] := CustoTotal
       FOR IPole := 1 TO NPolos
           CustoPolo[IPole, ANO] := CustoP[IPole]
       NEXT IPole

    ELSE
       
     ' Deve ser aplicada a priorizacao para as restauracoes
       PRINT '                    Aplicando a priorizacao...'

     if RedeRestric := 'Para toda a rede' then
            NovaRestr := RestrAnual[ANO] - CustoConserva
     ELSE
            FOR IPole := 1 TO NPolos
                NewRestP[IPole] := RestrPolo[IPole, ANO] - ConserP[IPole]
            NEXT IPole
     end;
     CustoCL := 0!
     FOR IPole := 1 TO NPolos
         CustoCLP[IPole] := 0
     NEXT IPole
    
     FOR ICONTROL := 1 TO 4
         
       CUSTOT[ANO] := CustoConserva
       TotalCost := CUSTOT[ANO] + CustoCL
       FOR IPole := 1 TO NPolos
           CustoPolo[IPole, ANO] := ConserP[IPole]
           CTotal[IPole] := CustoPolo[IPole, ANO] + CustoCLP[IPole]
       NEXT IPole
       if RedeRestric := 'Para toda a rede' then
            if TotalCost < RestrAnual[ANO] then
                 TERMINOU := 'Nao'
            ELSE
                 TERMINOU := 'Sim'
            end;
       ELSE
            Conclude := 'Sim'
            FOR IPole := 1 TO NPolos
                if CTotal[IPole] < RestrPolo[IPole, ANO] then Conclude := 'Nao'
            NEXT IPole
            if Conclude := 'Sim' then TERMINOU := 'Sim' ELSE TERMINOU := 'Nao'
       end;

       Arquivo := Calc + 'MEDIDAS.DAT'
       AssignFile(ArqDados, Arquivo); FOR Readln( AS #6
       ISTH := 0
       FOR IRodov := 1 TO NRODOV
        FOR ISUB := 1 TO NSTHRODOV[IRodov]
         ISTH := ISTH + 1
         FOR ifaixa := 1 TO NFaixas[ISTH]
             Readln( #6, STH, CustoFaixa[ifaixa], MedidaF[ifaixa], Hfres[ifaixa], Hrec[ifaixa], CustoAcost[ifaixa], MedidaAcost[ifaixa], HRAC[ifaixa], H2AC[ifaixa]
             Medida := MedidaF[ifaixa]
             if (Medida := 'CR' OR Medida := 'CL' OR Medida := 'ST'] then
                    EXECF[ISTH, ifaixa] := 1
             ELSE
                    EXECF[ISTH, ifaixa] := 0
             end;
         NEXT ifaixa
        NEXT ISUB
       NEXT IRodov
       CloseFile(ArqDados);6

     ' Encontra o segmento de maxima prioridade
       WHILE TERMINOU := 'Nao'

         IPMAX := 0
         STHPRIOR := 0
         FOR IPole := 1 TO NPolos
             IPMAXPolo[IPole] := 0
             STHPRIPolo[IPole] := 0
         NEXT IPole
         Arquivo := Calc + 'MEDIDAS.DAT'
         AssignFile(ArqDados, Arquivo); FOR Readln( AS #6
         ISTH := 0
         FOR IRodov := 1 TO NRODOV
          GOSUB 7000
          FOR ISUB := 1 TO NSTHRODOV[IRodov]
           ISTH := ISTH + 1
           FOR ifaixa := 1 TO NFaixas[ISTH]
             Readln( #6, STH, CustoFaixa[ifaixa], MedidaF[ifaixa], Hfres[ifaixa], Hrec[ifaixa], CustoAcost[ifaixa], MedidaAcost[ifaixa], HRAC[ifaixa], H2AC[ifaixa]
           NEXT ifaixa
                
             FOR ifaixa := 1 TO NFaixas[ISTH]
                
               if RedeRestric := 'Para toda a rede' then

                  if (IPRIOR[ISTH, ifaixa] > IPMAX AND EXECF[ISTH, ifaixa] := 0] then
                     IPMAX := IPRIOR[ISTH, ifaixa]
                     STHPRIOR := ISTH
                     IPoloPrior := IPolo
                     CustoPrior := 0
                     FOR ifX := 1 TO NFaixas[ISTH]
                         CustoPrior := CustoPrior + CustoFaixa[ifX] + CustoAcost[ifX]
                     NEXT ifX
                  end;
                   
               ELSE
                     
                  if (IPRIOR[ISTH, ifaixa] > IPMAXPolo[IPolo] AND EXECF[ISTH, ifaixa] := 0] then
                     IPMAXPolo[IPolo] := IPRIOR[ISTH, ifaixa]
                     STHPRIPolo[IPolo] := ISTH
                     CostPr[IPolo] := 0
                     FOR ifX := 1 TO NFaixas[ISTH]
                         CostPr[IPolo] := CostPr[IPolo] + CustoFaixa[ifX] + CustoAcost[ifX]
                     NEXT ifX
                  end;

               end;

             NEXT ifaixa
          NEXT ISUB
         NEXT IRodov
         CloseFile(ArqDados);6
        
         ' Verifica se o segmento de maxima prioridade pode ser restaurado:
           if RedeRestric := 'Para toda a rede' then
                   
              if STHPRIOR := 0 then
                     TERMINOU := 'Sim'
              ELSE
                     if NovaRestr >:= CustoPrior then
                         ' Aciona a restauracao:
                           NovaRestr := NovaRestr - CustoPrior
                           FOR ifX := 1 TO NFaixas[STHPRIOR]
                               EXECF[STHPRIOR, ifX] := 1
                           NEXT ifX
                           CUSTOT[ANO] := CUSTOT[ANO] + CustoPrior
                           CustoPolo[IPoloPrior, ANO] := CustoPolo[IPoloPrior, ANO] + CustoPrior
                     ELSE
                         ' Elimina o segmento prioritario neste ano, a fim de
                         ' se verificar se o proximo colocado deste ANO pode ser
                         ' restaurado:
                           FOR ifX := 1 TO NFaixas[STHPRIOR]
                               IPRIOR[STHPRIOR, ifX] := -1
                           NEXT ifX
                     end;
              end;
              if NovaRestr <:= 0 then TERMINOU := 'Sim'
                
           ELSE

              SOMA := 0
              FOR IPole := 1 TO NPolos
                  SOMA := SOMA + STHPRIPolo[IPole]
              NEXT IPole
              if SOMA := 0 then TERMINOU := 'Sim'
             
              if TERMINOU := 'Nao' then
                 FOR IPole := 1 TO NPolos
                   if STHPRIPolo[IPole] > 0 then
                     if NewRestP[IPole] >:= CostPr[IPole] then
                         ' Aciona a restauracao:
                           NewRestP[IPole] := NewRestP[IPole] - CostPr[IPole]
                           FOR ifX := 1 TO NFaixas[STHPRIPolo[IPole]]
                               EXECF[STHPRIPolo[IPole], ifX] := 1
                           NEXT ifX
                           CUSTOT[ANO] := CUSTOT[ANO] + CostPr[IPole]
                           CustoPolo[IPole, ANO] := CustoPolo[IPole, ANO] + CostPr[IPole]
                     ELSE
                         ' Elimina o segmento prioritario neste ano, a fim de
                         ' se verificar se o proximo colocado deste ANO pode ser
                         ' restaurado:
                           FOR ifX := 1 TO NFaixas[STHPRIPolo[IPole]]
                               IPRIOR[STHPRIPolo[IPole], ifX] := -1
                           NEXT ifX
                     end;
                   end;
                 NEXT IPole
                 Conclude := 'Sim'
                 FOR IPole := 1 TO NPolos
                     if NewRestP[IPole] > 0 then Conclude := 'Nao'
                 NEXT IPole
                 if Conclude := 'Sim' then TERMINOU := 'Sim'

              end;
                
           end;
           
       WEND

       ' Exclui o custo de CL da restricao orcamentaria nos segmentos nao
       ' priorizados que deveriam ser restaurados:
           CustoCL := 0!
           FOR IPole := 1 TO NPolos
               CustoCLP[IPole] := 0
           NEXT IPole
           ISTH := 0
           FOR IRodov := 1 TO NRODOV
            
             GOSUB 7000

             ' Leitura dos Custos Unitarios
               GOSUB 500

             FOR ISUB := 1 TO NSTHRODOV[IRodov]
                 ISTH := ISTH + 1
                 FOR ifaixa := 1 TO NFaixas[ISTH]
                     if EXECF[ISTH, ifaixa] := 0 then
                               Medida := 'CL'
                               GOSUB 5000
                               CustoCL := CustoCL + Custo
                               CustoCLP[IPolo] := CustoCLP[IPolo] + Custo
                     end;
                 NEXT ifaixa
             NEXT ISUB
           NEXT IRodov
           ' Refaz a priorizacao com a restricao orcamentaria ajustada
             if RedeRestric := 'Para toda a rede' then
                NovaRestr := RestrAnual[ANO] - CustoConserva - CustoCL
             ELSE
                FOR IPole := 1 TO NPolos
                    NewRestP[IPole] := RestrPolo[IPole, ANO] - ConserP[IPole] - CustoCLP[IPole]
                NEXT IPole
             end;

     NEXT ICONTROL
     CUSTOT[ANO] := CUSTOT[ANO] + CustoCL
     FOR IPole := 1 TO NPolos
           CustoPolo[IPole, ANO] := CustoPolo[IPole, ANO] + CustoCLP[IPole]
     NEXT IPole

    end;
    PRINT 'Custo Total apos otimizacao := '; CUSTOT[ANO]
   
   ' - - - - - - - - - - - - - - - - - - -
   ' -  Aplica as Intervencoes Indicadas -
   ' - - - - - - - - - - - - - - - - - - -
     Arquivo := Calc + 'MEDIDAS.DAT'
     AssignFile(ArqDados, Arquivo); FOR Readln( AS #6
     Arquivo := Calc + 'MED.DAT'
     AssignFile(ArqDados, Arquivo); FOR OUTPUT AS #15
     ISTH := 0
     FOR IRodov := 1 TO NRODOV
        
         GOSUB 7000

         ' Leitura dos Custos Unitarios
           GOSUB 500

         FOR ISUB := 1 TO NSTHRODOV[IRodov]
             ISTH := ISTH + 1
             FOR ifaixa := 1 TO NFaixas[ISTH]
                 Readln( #6, STH, CustoFaixa[ifaixa], MedidaF[ifaixa], Hfres[ifaixa], Hrec[ifaixa], CustoAcost[ifaixa], MedidaAcost[ifaixa], HRAC[ifaixa], H2AC[ifaixa]
             NEXT ifaixa
             ' Muda a medida para CL [reparo emergencial] onde nao foi priorizado
               FOR ifaixa := 1 TO NFaixas[ISTH]
                   if EXECF[ISTH, ifaixa] := 0 then
                          
                           MedidaF[ifaixa] := 'CL'
                           Hfres[ifaixa] := 0
                           Hrec[ifaixa] := 0
                           MedidaAcost[ifaixa] := 'CR'
                           HRAC[ifaixa] := 0
                           H2AC[ifaixa] := 0
                            
                           Medida := MedidaF[ifaixa]
                           GOSUB 5000
                           CustoFaixa[ifaixa] := Custo

                           ' Custo da Intervencao nos Acostamentos
                             CustoAcost[ifaixa] := 0!

                   end;
               NEXT ifaixa
               FOR ifaixa := 1 TO NFaixas[ISTH]
                   WRITE #15, STH, CustoFaixa[ifaixa], MedidaF[ifaixa], Hfres[ifaixa], Hrec[ifaixa], CustoAcost[ifaixa], MedidaAcost[ifaixa], HRAC[ifaixa], H2AC[ifaixa]
               NEXT ifaixa

         NEXT ISUB
     NEXT IRodov
     CloseFile(ArqDados);6, #15

 ' Altera a condicao do pavimento devido `a intervencao

   Arquivo := Calc + ARQ + STR[ANO] + '.DAT'
    AssignFile(ArqDados, Arquivo); FOR Readln( AS #12
   Arquivo := Calc + 'ESTSTHS2.DAT'
     AssignFile(ArqDados, Arquivo); FOR OUTPUT AS #13

   Arquivo := Calc + 'MED.DAT'
    AssignFile(ArqDados, Arquivo); FOR Readln( AS #6

   ISTH := 0
   FOR IRodov := 1 TO NRODOV
       
    GOSUB 7000
    FOR ISUB := 1 TO NSTHRODOV[IRodov]

     ISTH := ISTH + 1

     FOR ifaixa := 1 TO NFaixasMax
         CustoFaixa[ifaixa] := 0
         CustoAcost[ifaixa] := 0
     NEXT ifaixa

     Readln(ArqDados2, STH, KMI, KMF, CBRSL
     FOR ifaixa := 1 TO NFaixas[ISTH]
         
         Readln(ArqDados2, STH, ifX, PSIat[ISTH, ifX], Aream2[ISTH, ifX], VidaRes[ifX], Restaurado[ifX], UltCamada[ifX], VDMUni[ifX], PSInovo[ifX], HRef[ifX], Heff[ifX], IRec[ifX], ICalib[ifX], D0[ifX], MRfound[ifX]
         Readln(ArqDados2, H1REV[ifX], HrecExist[ifX], Idade[ifX], SN[ifX], QImed[ifX], Nano[ifX], IRI0[ifX], ALPHA[ifX], Nacum[ifX], ALFAIGG[ifX]
         Readln(ArqDados2, AreaAcost[ISTH, ifX], PSIacost[ifX], DegrauAcost[ifX]
         Readln( #6, STH, CustoFaixa[ifaixa], MedidaF[ifaixa], Hfres[ifaixa], Hrec[ifaixa], CustoAcost[ifaixa], MedidaAcost[ifaixa], HRAC[ifaixa], H2AC[ifaixa]
              
              Area := Aream2[ISTH, ifaixa]
              HR := Hrec[ifaixa]
              HC := Hfres[ifaixa]
              Medida := MedidaF[ifaixa]
              VDM := VDMUni[ifaixa]
              Age := Idade[ifaixa]
              PSI := PSIat[ISTH, ifaixa]
              QIest := QImed[ifaixa]
              H1 := H1REV[ifaixa]
              
              GOSUB 4000
              
              Idade[ifaixa] := Age
              PSIat[ISTH, ifaixa] := PSI
              QImed[ifaixa] := QIest
              H1REV[ifaixa] := H1

         ' Vida Residual do Pavimento
           PSI := PSIat[ISTH, ifaixa]
           if (MedidaF[ifaixa] <> 'CR' AND MedidaF[ifaixa] <> 'CL' AND MedidaF[ifaixa] <> 'ST'] then
              PSI := PSIat[ISTH, ifaixa]
              H1 := H1REV[ifaixa]
              Age := Idade[ifaixa]
              GOSUB 6500
              VidaRes[ifaixa] := VR
           end;

         if Idade[ifaixa] >:= 0 then
            VRmed[ANO] := VRmed[ANO] + Aream2[ISTH, ifaixa] * VidaRes[ifaixa]
            if PSIat[ISTH, ifaixa] < PSIref then NPSI[ANO] := NPSI[ANO] + 1
            PSImedSTH[ISTH] := PSImedSTH[ISTH] + Aream2[ISTH, ifaixa] * PSIat[ISTH, ifaixa]
         end;
        
         ' Intervencao nos Acostamentos
           SELECT CASE MedidaAcost[ifaixa]
                  CASE 'CR', 'CL'
                  CASE 'TSS', 'TSD'
                                        PSIacost[ifaixa] := 4.2
                                        DegrauAcost[ifaixa] := 0
                  CASE 'PMF', 'RRP', 'RRT'
                                        PSIacost[ifaixa] := 4.5
                                        DegrauAcost[ifaixa] := 0
                  CASE ELSE
                                        PRINT 'ERRO: Medida := '; MedidaAcost: STOP
           END SELECT

     NEXT ifaixa
    
     WRITE #13, STH, KMI, KMF, CBRSL
     FOR ifX := 1 TO NFaixas[ISTH]
         WRITE #13, STH, ifX, PSIat[ISTH, ifX], Aream2[ISTH, ifX], VidaRes[ifX], Restaurado[ifX], UltCamada[ifX], VDMUni[ifX], PSInovo[ifX], HRef[ifX], Heff[ifX], IRec[ifX], ICalib[ifX], D0[ifX], MRfound[ifX]
         WRITE #13, H1REV[ifX], HrecExist[ifX], Idade[ifX], SN[ifX], QImed[ifX], Nano[ifX], IRI0[ifX], ALPHA[ifX], Nacum[ifX], ALFAIGG[ifX]
         WRITE #13, AreaAcost[ISTH, ifX], PSIacost[ifX], DegrauAcost[ifX]
     NEXT ifX

     PSImed[ANO] := PSImed[ANO] + PSImedSTH[ISTH]
     J := Code[IRodov, ISUB]
     Y := ANO + ANOBASE
     N := NFaixas[ISTH]
    
     FOR ifaixa := 1 TO NFaixasMax
         if ifaixa > NFaixas[ISTH] then
                 MedidaF[ifaixa] := ''
                 Hfres[ifaixa] := 0
                 Hrec[ifaixa] := 0
         end;
     NEXT ifaixa

     WRITE #14, Y, J, KMI, KMF, MedidaAcost[1], HRAC[1], H2AC[1], MedidaF[1], Hfres[1], Hrec[1], MedidaF[2], Hfres[2], Hrec[2], MedidaF[3], Hfres[3], Hrec[3], MedidaF[4], Hfres[4], Hrec[4], MedidaAcost[N], HRAC[N], H2AC[N]
 
     CustoSTH := 0
     CustoAc := 0
     FOR ifaixa := 1 TO NFaixas[ISTH]
         CustoSTH := CustoSTH + CustoFaixa[ifaixa] + CustoAcost[ifaixa]
         CustoAc := CustoAc + CustoAcost[ifaixa]
     NEXT ifaixa
    
     Arquivo := Calc + ARQ + 'CT' + Rodov[IRodov] + '.CSV'
     AssignFile(ArqDados, Arquivo); FOR APPEND AS #15
     WRITE #15, Y, J, KMI, KMF, CustoSTH, CustoFaixa[1], CustoFaixa[2], CustoFaixa[3], CustoFaixa[4], CustoAc
     CloseFile(ArqDados);15

    NEXT ISUB
   NEXT IRodov
  
   Readln(ArqDados2, PSImed[0], NPSI[0], VRmed[0]
   Readln(ArqDados2, AreaTotal, NUnidAnalise
   WRITE #13, PSImed[0], NPSI[0], VRmed[0]
   WRITE #13, AreaTotal, NUnidAnalise
   CloseFile(ArqDados);6, #12, #13

   Arquivo := Calc + 'ESTSTHS2.DAT'
    AssignFile(ArqDados, Arquivo); FOR Readln( AS #12
   Arquivo := Calc + ARQ + STR[ANO] + '.DAT'
    AssignFile(ArqDados, Arquivo); FOR OUTPUT AS #13

   VDMmin := 1E+20: VDMmax := 0
   PSIminRede := 5!: PSImaxRede := 0
   ISTH := 0
   FOR IRodov := 1 TO NRODOV
       FOR ISUB := 1 TO NSTHRODOV[IRodov]
           ISTH := ISTH + 1
           Readln(ArqDados2, STH, KMI, KMF, CBRSL
           FOR ifaixa := 1 TO NFaixas[ISTH]
               Readln(ArqDados2, STH, ifX, PSIat[ISTH, ifX], Aream2[ISTH, ifX], VidaRes[ifX], Restaurado[ifX], UltCamada[ifX], VDMUni[ifX], PSInovo[ifX], HRef[ifX], Heff[ifX], IRec[ifX], ICalib[ifX], D0[ifX], MRfound[ifX]
               Readln(ArqDados2, H1REV[ifX], HrecExist[ifX], Idade[ifX], SN[ifX], QImed[ifX], Nano[ifX], IRI0[ifX], ALPHA[ifX], Nacum[ifX], ALFAIGG[ifX]
               Readln(ArqDados2, AreaAcost[ISTH, ifX], PSIacost[ifX], DegrauAcost[ifX]
               if VDMUni[ifX] > VDMmax then VDMmax := VDMUni[ifX]
               if VDMUni[ifX] < VDMmin then VDMmin := VDMUni[ifX]
               if PSIat[ISTH, ifX] > PSImaxRede then PSImaxRede := PSIat[ISTH, ifX]
               if PSIat[ISTH, ifX] < PSIminRede then PSIminRede := PSIat[ISTH, ifX]
           NEXT ifaixa
           WRITE #13, STH, KMI, KMF, CBRSL
           FOR ifX := 1 TO NFaixas[ISTH]
               WRITE #13, STH, ifX, PSIat[ISTH, ifX], Aream2[ISTH, ifX], VidaRes[ifX], Restaurado[ifX], UltCamada[ifX], VDMUni[ifX], PSInovo[ifX], HRef[ifX], Heff[ifX], IRec[ifX], ICalib[ifX], D0[ifX], MRfound[ifX]
               WRITE #13, H1REV[ifX], HrecExist[ifX], Idade[ifX], SN[ifX], QImed[ifX], Nano[ifX], IRI0[ifX], ALPHA[ifX], Nacum[ifX], ALFAIGG[ifX]
               WRITE #13, AreaAcost[ISTH, ifX], PSIacost[ifX], DegrauAcost[ifX]
           NEXT ifX
       NEXT ISUB
   NEXT IRodov
  
   Readln(ArqDados2, PSImed[0], NPSI[0], VRmed[0]
   Readln(ArqDados2, AreaTotal, NUnidAnalise
   WRITE #13, PSImed[0], NPSI[0], VRmed[0]
   WRITE #13, AreaTotal, NUnidAnalise
   CloseFile(ArqDados);12, #13

   ' Fator 2 nas formulas abaixo se deve `a media entre antes e depois
   ' das intervencoes Programadas para o ANO:
     NPSI[ANO] := 100 * NPSI[ANO] / [2 * NUnid]
     PSImed[ANO] := PSImed[ANO] / [2 * TotalArea]
     VRmed[ANO] := VRmed[ANO] / [2 * TotalArea]

  ' - - - - - - - - - - - - - - -
  ' - Passa para o ano seguinte -
  ' - - - - - - - - - - - - - - -
  NEXT ANO
  CloseFile(ArqDados);14

   ' - - - - - - - - - - - - - - -
   ' -  Arquivos de Saida Finais -
   ' - - - - - - - - - - - - - - -
   
   Arquivo := Calc + 'Results.csv'
   AssignFile(ArqDados, Arquivo); FOR OUTPUT AS #4
   WRITE #4, 'Ano', 'Custo[mR]', 'PSI Medio', 'Ocorr. [%]', 'VR [anos]'
 
   ARQCUSTO := Calc + 'Custo' + ARQ + '.out'
   ARQPSI := Calc + 'PSI' + ARQ + '.out'
   ARQNPSI := Calc + 'NPSI' + ARQ + '.out'
   ARQVR := Calc + 'VR' + ARQ + '.out'

   OPEN ARQCUSTO FOR OUTPUT AS #1
   OPEN ARQPSI FOR OUTPUT AS #2
   OPEN ARQNPSI FOR OUTPUT AS #3
   OPEN ARQVR FOR OUTPUT AS #5

   FOR IANO := 1 TO NPeriodos
       Deficit[IANO] := Deficit[IANO] - CUSTOT[IANO]
       WRITE #1, CUSTOT[IANO]
       WRITE #1, Deficit[IANO]
       FOR IPolo := 1 TO NPolos
           WRITE #1, CustoPolo[IPolo, IANO]
       NEXT IPolo
       ANO := ANOBASE + IANO
       WRITE #4, ANO, [CUSTOT[IANO] / 1000], PSImed[IANO], NPSI[IANO], VRmed[IANO]
   NEXT IANO
   CloseFile(ArqDados);1, #4

   FOR IANO := 0 TO NPeriodos
       WRITE #2, PSImed[IANO]
       WRITE #3, NPSI[IANO]
       WRITE #5, VRmed[IANO]
   NEXT IANO
   CloseFile(ArqDados);2, #3, #5



end



500  ' - - - - - - - - - - - -
     ' -  Custos Unitarios   -
     ' -     [Subrotina]     -
     ' - - - - - - - - - - - -
       Arquivo := Calc + 'C' + Rodov[IRodov] + STR[ANO] + '.CSV'
       AssignFile(ArqDados, Arquivo); FOR Readln( AS #1
            Readln(ArqDados, CBUQm3
            Readln(ArqDados, Reperf
            Readln(ArqDados, Fresagemm3
            Readln(ArqDados, BGm3
            Readln(ArqDados, Remocao
            Readln(ArqDados, CRkmAno
            Readln(ArqDados, CLm2
            Readln(ArqDados, MICROCA4m2
            Readln(ArqDados, MICROCA7m2
            Readln(ArqDados, MICROCA12m2
            Readln(ArqDados, TSSm2
            Readln(ArqDados, TSDm3
            Readln(ArqDados, TSTm3
            Readln(ArqDados, Pintura
            Readln(ArqDados, Selagem
            Readln(ArqDados, PMFm3
            Readln(ArqDados, LamaD
            Readln(ArqDados, LamaM
            Readln(ArqDados, LamaG
            Readln(ArqDados, BaseAcostm3
            Readln(ArqDados, TSSpolm2
            Readln(ArqDados, TSDpolm3
            Readln(ArqDados, TSTpolm3
            Readln(ArqDados, CapeSealm3
       CloseFile(ArqDados);1
       RETURN

5000 ' - - - - - - - - - - - - - - - - - - - - - - -
     ' -       Custo da Medida de Manutencao       -
     ' -                [Subrotina]                -
     ' -  Dados: Medida, HC, HR, Area, PSI, VDM   -
     ' -  Saida: Custo                             -
     ' - - - - - - - - - - - - - - - - - - - - - - -
       SELECT CASE Medida
              CASE 'CP', 'FR+CP'
                        SELECT CASE CamadaRest[IRodov]
                               CASE 'Lama Asfaltica Delgada': Custo := LamaD
                               CASE 'Lama Asfaltica Media': Custo := LamaM
                               CASE 'Lama Asfaltica Grossa': Custo := LamaG
                               CASE 'Micro-CA 4 mm': Custo := MICROCA4m2
                               CASE 'Micro-CA 7 mm': Custo := MICROCA7m2
                               CASE 'Micro-CA 12 mm': Custo := MICROCA12m2
                               CASE 'TSD': Custo := TSDm3 * [Hrec[ifaixa] / 100]
                               CASE 'TST': Custo := TSTm3 * [Hrec[ifaixa] / 100]
                               CASE 'TSD com Polimero [18 mm]': Custo := TSDpolm3 * [Hrec[ifaixa] / 100]
                               CASE 'Cape Seal [TSS+Micro]': Custo := CapeSealm3 * [Hrec[ifaixa] / 100]
                               CASE ELSE: PRINT 'ERRO': STOP
                        END SELECT
                        if Medida := 'FR+CP' then Custo := Custo + Fresagemm3 * [Hrec[ifaixa] / 100]
              CASE 'CR'
                        if Idade[ifaixa] < 0 then
                             Custo := 0
                        ELSE
                             if Aream2[ISTH, ifaixa] > 0 then
                                    Custo := ABS[KMF - KMI] * CRkmAno
                                    Custo := Custo / Aream2[ISTH, ifaixa]
                             ELSE
                                    Custo := 0
                             end;
                        end;
              CASE 'CL', 'ST'
                        PSI := PSIat[ISTH, ifaixa]
                        I1 := 0
                        FOR ICL := 1 TO [NitensCL - 1]
                            if (PSI <:= PSIitemCL[ICL] AND PSI > PSIitemCL[ICL + 1]] then
                                     I1 := ICL
                                     I2 := ICL + 1
                            end;
                        NEXT ICL
                        if PSI <:= PSIitemCL[NitensCL] then
                               I1 := NitensCL - 1
                               I2 := NitensCL
                        end;
                        if I1 := 0 then
                                PerctReparos := 0
                        ELSE
                                Y1 := ARepCL[I1]
                                Y2 := ARepCL[I2]
                                X1 := PSIitemCL[I1]
                                X2 := PSIitemCL[I2]
                                PerctReparos := [[X2 * Y1 - X1 * Y2] / [X2 - X1]] + [[Y2 - Y1] * PSI / [X2 - X1]]
                        end;
                        if Medida := 'ST' then
                              PerctReparos := .1 * PerctReparos
                              if PerctReparos > 1! then PerctReparos := 1!
                              Custo := Selagem * PerctReparos / 100
                        ELSE
                              if PerctReparos > 35! then PerctReparos := 35!
                              Custo := CLm2 * PerctReparos / 100
                        end;
              CASE 'RS'
                        if Hrec[ifaixa] <:= 7! then
                           Ncamadas := 1
                        ELSE
                           if Hrec[ifaixa] <:= 14! then
                              Ncamadas := 2
                           ELSE
                              Ncamadas := 3
                           end;
                        end;
                        Custo := [Hrec[ifaixa] / 100] * CBUQm3 + Ncamadas * Pintura
              CASE 'MF+RC'
                        if Hrec[ifaixa] <:= 7! then
                           Ncamadas := 1
                        ELSE
                           if Hrec[ifaixa] <:= 14! then
                              Ncamadas := 2
                           ELSE
                              Ncamadas := 3
                           end;
                        end;
                        Custo := [Hrec[ifaixa] / 100] * CBUQm3 + [Ncamadas + 1] * Pintura + Reperf
              CASE 'FR+RC', 'RRV'
                        if Hrec[ifaixa] <:= 7! then
                           Ncamadas := 1
                        ELSE
                           if Hrec[ifaixa] <:= 14! then
                              Ncamadas := 2
                           ELSE
                              Ncamadas := 3
                           end;
                        end;
                        Custo := [Hrec[ifaixa] / 100] * CBUQm3 + Fresagemm3 * [Hrec[ifaixa] / 100] + Ncamadas * Pintura
              CASE 'RRP'
                        if Hrec[ifaixa] <:= 7! then
                           Ncamadas := 1
                        ELSE
                           if Hrec[ifaixa] <:= 14! then
                              Ncamadas := 2
                           ELSE
                              Ncamadas := 3
                           end;
                        end;
                        Custo := Remocao * Hfres[ifaixa] / 100
                        H2CM := Hfres[ifaixa] - Hrec[ifaixa]
                        Custo := Custo + [Hrec[ifaixa] / 100] * CBUQm3 + [H2CM / 100] * BGm3 + Ncamadas * Pintura
              CASE 'RRT'
                        if Hrec[ifaixa] <:= 7! then
                           Ncamadas := 1
                        ELSE
                           if Hrec[ifaixa] <:= 14! then
                              Ncamadas := 2
                           ELSE
                              Ncamadas := 3
                           end;
                        end;
                        Custo := Remocao * Hfres[ifaixa] / 100
                        H2CM := Hfres[ifaixa] - Hrec[ifaixa] - 20
                        Custo := Custo + [Hrec[ifaixa] / 100] * CBUQm3 + [H2CM / 100] * BGm3 + Ncamadas * Pintura
              CASE ELSE
                        PRINT 'ERRO: medida nao identificada.'
                        PRINT Medida
                        STOP
       END SELECT
       if Medida := 'CL' then
              Custo := RLcost[ifaixa]
       ELSE
              Custo := Custo * Aream2[ISTH, ifaixa]
       end;
       RETURN


1000 ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -              Necessidades Atuais de Manutencao              -
     ' -                         [Subrotina]                         -
     ' -  Dados: PSI, H1, VR, QI, Age, NYEAR, VSMIN,                 -
     ' -         Estado de Superficie, Parametros de decisao, HRDP,  -
     ' -         HRTR, H1TR, H2DP, HRQI, HRMPD                       -
     ' -  Saida: Medida, HC, HR, H1NOVO, H2NOVO                     -
     ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     
     Medida := ''
     HC := 0!
     CATEGORIA := 'CONSERVACAO'

     HR := HRMPD
     IRest := 0
     if H1 >:= 6! then
                 Fresavel := 'Sim'
                 HCMAX := H1 - 3
     ELSE
                 Fresavel := 'Nao'
     end;
     if (PSIacost[ifaixa] >:= 3! AND DegrauAcost[ifaixa] <:= DEGRAUadm] then
                 Fresar := 'Sim'
     ELSE
                 Fresar := 'Nao'
     end;
     if HR < HRmin then HR := HRmin

     ' Deciso quanto  categoria de interveno requerida
     if Restaurado[ifaixa] := 'Nao' then

        if (ATR := 'A3' OR ATR := 'M3' OR ATR := 'A2'] then
           if HRDP > HR then
              HR := HRDP
              IRest := 1
           end;
        end;
        if HRTR > HR then
                       HR := HRTR
                       IRest := 2
        end;
        if HRQI > HR then
                       HR := HRQI
                       IRest := 3
        end;
        if HRatr > HR then IRest := 4
        if HR < HRmin then HR := HRmin

        if (CR := 'A2' OR CR := 'A3' OR CR := 'M3' OR BL := 'A3' OR TT := 'A3' OR TL := 'A3'] then
                  ICRACK := 1
        ELSE
                  ICRACK := 0
        end;
        if (ATRmed > 15 OR COR := 'A3' OR EM := 'A3' OR DP := 'A3' OR EL := 'A3'] then
                 IDP := 1
        ELSE
                 IDP := 0
        end;

        if (ATRmed > ATRcrit OR TR23 > TRcrit] then CATEGORIA := 'RESTAURACAO'
        if (PSR < 2! OR QI > QIcrit OR PSI <:= PSif OR VR < .1] then CATEGORIA := 'RESTAURACAO'

       ' Detalhamento da Medida a ser aplicada
         
       if CATEGORIA := 'CONSERVACAO' then

          if UltCamada[ifaixa] := 'CCP' then

            if PSR > 4! then Medida := 'CR' ELSE Medida := 'CL'

          ELSE

            if (D := 'A3' OR DS := 'A' OR TR23 > 15] then
               if VSCP >:= VUMin then
                  Medida := 'CP'
                  HR := HRCP[IRodov]
                  HC := 0!
               ELSE
                  Medida := 'CL'
               end;
            ELSE
               if (BL := 'B3' OR CR := 'B2' OR CR := 'M2' OR BL := 'M2' OR TT := 'B3' OR TT := 'M3' OR TL := 'B3' OR TL := 'M3'] then
                    Medida := 'ST'
               ELSE
                    if (DP := 'B3' OR EL := 'B3' OR CR := 'B3' OR P := 'B3' OR P := 'B2' OR P := 'B1'] then
                       Medida := 'CL'
                    ELSE
                       if (PSR < 4! OR IDS > 20] then
                            Medida := 'CL'
                       ELSE
                            Medida := 'CR'
                       end;
                    end;
               end;
            end;

          end;

       ELSE

          if UltCamada[ifaixa] := 'CCP' then
            
             if PSI < 1.5 then
                    CATEGORIA := 'RECONSTRUCAO'
                    Medida := 'RRT'
                    H1NOVO := H1
                    H2NOVO := 15
                    HR := H1
                    HC := H1NOVO + H2NOVO + 20
             ELSE
                    CATEGORIA := 'RESTAURACAO'
                    HRreflex := 10
                    if HRMPD < HRreflex then HR := HRreflex ELSE HR := HRMPD
                    Medida := 'MF+RC'
                    HC := 0
             end;
         
          ELSE

            if (PSI < PSRcrit AND IDS > IDScrit] then
             
               CATEGORIA := 'RECONSTRUCAO'
               if (TE := 'A3' OR DC := 'A3' OR COR := 'A3' OR EM := 'A3'] then
                  if BF := 'A3' then
                        Medida := 'RRP'
                        H1NOVO := H1TR
                        H2NOVO := H2DP
                        HR := H1NOVO
                        HC := H1NOVO + H2NOVO
                  ELSE
                        Medida := 'RRV'
                        H1NOVO := H1TR
                        HR := H1NOVO
                        HC := H1NOVO
                  end;
               ELSE
                  Medida := 'RRT'
                  H1NOVO := H1TR
                  H2NOVO := H2DP
                  HR := H1NOVO
                  HC := H1NOVO + H2NOVO + 20
               end;

            ELSE

               CATEGORIA := 'RESTAURACAO'
               if IDP := 1 then
                    if Fresavel := 'Sim' then
                          Medida := 'FR+RC'
                          if HR > HCMAX then
                             HC := HCMAX
                          ELSE
                             HC := HR
                          end;
                          if HC < HCMIN then HC := HCMIN
                    ELSE
                          Medida := 'MF+RC'
                          HC := 0
                    end;
               ELSE
                    if ICRACK := 1 then
                     if Fresar := 'Nao' then
                       Medida := 'MF+RC'
                       HC := 0
                     ELSE
                       if Fresavel := 'Sim' then
                          Medida := 'FR+RC'
                          if HR > HCMAX then
                               HC := HCMAX
                          ELSE
                               HC := HR
                          end;
                          if HC < HCMIN then HC := HCMIN
                       ELSE
                          Medida := 'MF+RC'
                          HC := 0
                       end;
                     end;
                    ELSE
                       HC := 0
                       if IRest := 4 then
                             if HR := HRmin then
                                    Medida := 'RS'
                                    if HR < HRatr then HR := HRatr
                             ELSE
                                    Medida := 'MF+RC'
                             end;
                       ELSE
                             Medida := 'RS'
                       end;
                    end;
               end;

               if HR > HRMAX then
                        CATEGORIA := 'RECONSTRUCAO'
                        Medida := 'RRP'
                        H1NOVO := H1TR
                        H2NOVO := H2DP
                        HR := H1NOVO
                        HC := H1NOVO + H2NOVO
               end;

            end;
         
          end;

       end;

     ELSE

       if ANO := NPeriodos then
             if (PSI <:= PSif OR VR < VRminFinal] then Interv := 'S' ELSE Interv := 'N'
       ELSE
             if PSI <:= PSif then Interv := 'S' ELSE Interv := 'N'
       end;
       if Interv := 'S' then
          if PSI > PSRcrit then
                HC := 0!
                if (UltCamada[ifaixa] := 'CBUQ' AND VSCP >:= VUMin] then
                   Medida := 'CP'
                   HR := HRCP[IRodov]
                ELSE
                   CATEGORIA := 'RESTAURACAO'
                   Medida := 'RS'
                end;
          ELSE
                CATEGORIA := 'RECONSTRUCAO'
                Medida := 'RRP'
                H1NOVO := H1TR
                H2NOVO := H2DP
                HR := H1NOVO
                HC := H1NOVO + H2NOVO
          end;
       ELSE
          if PSI >:= 3.5 then
                 Medida := 'CR'
          ELSE
                 Medida := 'CL'
          end;
       end;

     end;
     if (Medida := 'CR' OR Medida := 'CL' OR Medida := 'ST'] then HR := 0

     RETURN


1200 ' - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -       Necessidades de Reforco Estrutural      -
     ' -                  [Subrotina]                  -
     ' -  Dados: H1, HT, CBRSL, NYEAR, PP, DC, QI      -
     ' -  Saida: HRDP, HRTR, H1TR, H2DP, HRMPD         -
     ' - - - - - - - - - - - - - - - - - - - - - - - - -
    
     ' Espessura de reforco efetiva existente
       if Restaurado[ifaixa] := 'Sim' then
              FCovl := FCrecap
       ELSE
              if IRec[ifaixa] := 1 then
                     if ICalib[ifaixa] := 1 then
                            FCovl := ALPHA[ifaixa]
                     ELSE
                            FCovl := FCrecaprede[IRodov]
                     end;
              ELSE
                     FCovl := FCrecaprede[IRodov]
              end;
       end;
       P := 4100 / [PI * 30 * 30 / 4]
       E := 2 * [1 - .33 * .33] * P * [30 / 2] / [DC / 1000]
       MR := E / .0703
       A1 := .44
       if VR > 0 then
          PERIODO := VR
          GOSUB 6700
          SNP := A1 * .5 / 2.54
          NP := 0
          WHILE NP < NPA
                SNP := SNP + .05
                HRmodel := 2.54 * SNP / A1
                QIest := QI
                HR := HRmodel
                HC := 0
                GOSUB 6900
                QID := QIest
                PSIQI := 5 * EXP[-QID / 71.5]
                PSR := 5
                PSI0 := [PSIQI + PSR] / 2
                if PSI0 > 4.95 then PSI0 := 4.95
                DPSI := PSI0 - 2.5
                if DPSI > 0 then
                   BETA := .4 + [1094 / [[SNP + 1] ^ 5.19]]
                   W18 := [[[SNP + 1] / 1.05] ^ 9.36] * [[DPSI / 2.7] ^ [1 / BETA]]
                   W18 := W18 * [[MR / 3000] ^ 2.32] / 1000000!
                   ALFAA := [1 / W18] * LOG[LOG[2.5 / 5] / LOG[PSI0 / 5]]
                   ALFA := ALFAA * FCovl
                   NP := [1 / ALFA] * LOG[LOG[PSif / 5] / LOG[PSI0 / 5]]
                end;
          WEND
          Heff[ifaixa] := HRmodel
       ELSE
          Heff[ifaixa] := 0
       end;

     ' Espessura de reforco em CBUQ requerida pelo modelo de previsao de desempenho
       PERIODO := PP
       GOSUB 6700
       SNP := A1 * .5 / 2.54
       NP := 0
       WHILE NP < NPA
             SNP := SNP + .05
             HRmodel := 2.54 * SNP / A1
             HR := HRmodel
             HC := 0
             QIest := QI
             GOSUB 6900
             PSI0 := [5 * EXP[-QIest / 71.5] + 5] / 2
             if PSI0 > 4.95 then PSI0 := 4.95
             DPSI := PSI0 - 2.5
             if DPSI > 0 then
                BETA := .4 + [1094 / [[SNP + 1] ^ 5.19]]
                W18 := [[[SNP + 1] / 1.05] ^ 9.36] * [[DPSI / 2.7] ^ [1 / BETA]]
                W18 := W18 * [[MR / 3000] ^ 2.32] / 1000000!
                ALFAA := [1 / W18] * LOG[LOG[2.5 / 5] / LOG[PSI0 / 5]]
                ALFA := ALFAA * FCrecap
                NP := [1 / ALFA] * LOG[LOG[PSif / 5] / LOG[PSI0 / 5]]
             end;
       WEND
       HRMPD := HRmodel
       if HRMPD < 0 then HRMPD := 0
       if UltCamada[ifaixa] := 'CCP' then
               HRreflex := 1.364 * PP
               if HRreflex > HRMPD then HRMPD := HRreflex
       end;

       ' Revestimento requerido pelo Metodo do DNER
         NPUSACE := 3 * NPA
         H1TR := 4.4608 + 2.131 * LOG[NPUSACE]
         if H1TR < HRmin then H1TR := HRmin
         HRTR := H1TR - H1
         if HRTR < 0 then HRTR := 0
       ' Camada de Base pelo modelo de previsao de desempenho
         SNP := .5
         NP := 0
         WHILE NP < NPA
               SNP := SNP + .05
               PSI0 := [5 * EXP[-15 / 71.5] + 5] / 2
               DPSI := PSI0 - 2.5
               if DPSI > 0 then
                  MR := 100 * CBRSL / .0703
                  BETA := .4 + [1094 / [[SNP + 1] ^ 5.19]]
                  W18 := [[[SNP + 1] / 1.05] ^ 9.36] * [[DPSI / 2.7] ^ [1 / BETA]]
                  W18 := W18 * [[MR / 3000] ^ 2.32] / 1000000!
                  ALFAA := [1 / W18] * LOG[LOG[2.5 / 5] / LOG[PSI0 / 5]]
                  ALFA := ALFAA * FCnovo
                  NP := [1 / ALFA] * LOG[LOG[PSif / 5] / LOG[PSI0 / 5]]
               end;
         WEND
         H2DP := [2.54 * SNP - .44 * H1TR] / .14
         if H2DP < 12 then H2DP := 12

       ' Espessura de recapeamento requerida para eliminar ATR
         ATRadm := 1
         if ATRmed > ATRadm then
               Nrecaps := LOG[ATRadm / ATRmed] / LOG[.15]
               if Nrecaps < 1 then
                    NR := 1
               ELSE
                    NR := Nrecaps - INT[Nrecaps]
                    if NR > .2 then NR := INT[Nrecaps] + 1 ELSE NR := INT[Nrecaps]
               end;
         ELSE
               NR := 0
         end;
         HRatr := NR * HRmin

    RETURN

2000 ' - - - - - - - - - - - - - - - - - -
     ' -  INTERVENCAO NOS ACOSTAMENTOS   -
     ' -           [Subrotina]           -
     ' - - - - - - - - - - - - - - - - - -
       SELECT CASE MedidaAcost[ifaixa]
              CASE 'CR'
                          Custo := 0
              CASE 'CL'
                          PerctReparos := 100 * EXP[-2.3026 * PSIacost[ifaixa]]
                          Custo := [.5 * CLm2] * PerctReparos / 100
              CASE 'TSS'
                          Custo := TSSm2
              CASE 'TSD'
                          Custo := TSDm2
              CASE 'PMF'
                          Custo := [HRAC[ifaixa] / 100] * PMFm3 + Pintura
              CASE 'RRP', 'RRT'
                          Custo := [Remocao * H2AC[ifaixa] / 100] + TSDm2 + [H2AC[ifaixa] / 100] * BaseAcostm3
              CASE ELSE
                        PRINT 'ERRO: Medida desconhecida := '; MedidaAcost[ifaixa]; ' na faixa '; ifaixa
                        STOP
       END SELECT
   
     RETURN

3000 ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -      Evolucao da Condicao do Pavimento apos um Ano    -
     ' -                      [Subrotina]                      -
     ' -  Dados: H1REV, SN, Nacum, CBRSL, PSI, IRI0[ifaixa],   -
     ' -         ALPHA[ifaixa], Nano, QImed, HRef[ifaixa],     -
     ' -         IRec[ifaixa]                                  -
     ' -  Saida: PSI, QImed                                    -
     ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
       
       DELTAT := 1
       NYEAR := Nano[ifaixa] / 1000000!
    
       ' Evolucao do PSI:
         DELTAN := DELTAT * NYEAR
         PT := 2.5
         DPSI := PSInovo[ifaixa] - PT
         if IRec[ifaixa] := 0 then
              
            MR := 100 * CBRSL / .0703
            VRmax := 25
            VRmin := 2
            BETA := .4 + [1094 / [[SN[ifaixa] + 1] ^ 5.19]]
            W18# := [[[SN[ifaixa] + 1] / 1.05] ^ 9.36] * [[DPSI / 2.7] ^ [1 / BETA]]
            W18# := W18# * [[MR / 3000] ^ 2.32] / 1000000!
            ALFAA := [1 / W18#] * LOG[LOG[PT / 5] / LOG[PSInovo[ifaixa] / 5]]
            ALFA := ALFAA * ALPHA[ifaixa]
            DeltaPSI := ALFA * DELTAN * PSI * LOG[PSI / 5]
         
         ELSE

            if UltCamada[ifaixa] := 'CBUQ' then
                 VRmax := 25
                 VRmin := 2
                 SNrecap := .44 * HRef[ifaixa] / 2.54
                 MR := MRfound[ifaixa] / .0703
                 BETA := .4 + [1094 / [[SNrecap + 1] ^ 5.19]]
                 W18# := [[[SNrecap + 1] / 1.05] ^ 9.36] * [[DPSI / 2.7] ^ [1 / BETA]]
                 W18# := W18# * [[MR / 3000] ^ 2.32] / 1000000!
                 ALFAA := [1 / W18#] * LOG[LOG[2.5 / 5] / LOG[PSInovo[ifaixa] / 5]]
                 ALFA := ALFAA * ALPHA[ifaixa]
                 DeltaPSI := ALFA * DELTAN * PSI * LOG[PSI / 5]
            ELSE
                 VRmax := 12
                 VRmin := 1
                 DeltaPSI := -[A0rest[IRodov] + B0rest[IRodov] * D0[ifaixa]] * DELTAN
            end;

         end;
         dPSIdtmin := 2! / VRmax
         dPSIdtmax := 2! / VRmin
         DPSImin := dPSIdtmin * DELTAT
         DPSImax := dPSIdtmax * DELTAT
         if ABS[DeltaPSI] > DPSImax then DeltaPSI := -DPSImax
         if ABS[DeltaPSI] < DPSImin then DeltaPSI := -DPSImin
         ' Evolucao da Irregularidade:
           if PSI < 1.5 then PSIcrit := 1.5 ELSE PSIcrit := PSI
           DQI := -71.5 * DeltaPSI / PSIcrit
           QImed[ifaixa] := QImed[ifaixa] + DQI
         PSI := PSI + DeltaPSI
         if PSI < 1 then PSI := 1

     RETURN


4000 ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -         Aplicacao da Medida de Manutencao Indicada        -
     ' -                        [Subrotina]                        -
     ' -   Dados: Medida, PSI, ATR, QIest, HR, HC, H1             -
     ' -   Saida: PSI, ATR, TR, QIest, Age, HR, H1, SN             -
     ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
       SELECT CASE Medida
              CASE 'RRP', 'RRT'
                                 QIest := 15
                                 PSIQI := 5 * EXP[-QIest / 71.5]
                                 PSR := 5
                                 PSInovo[ifaixa] := [PSIQI + PSR] / 2
                                 PSI := PSInovo[ifaixa]
                                 Age := 0!
                                 IDS := 0
                                 IRI0[ifaixa] := QIest / 13
                                 if Medida := 'RRP' then
                                       SNnovo := .44 * HR + .14 * [HC - HR]
                                 ELSE
                                       SNnovo := .44 * HR + .14 * [HC - HR - 20]
                                 end;
                                 SN[ifaixa] := SNnovo / 2.54
                                 LCBR := LOG[CBRSL] / LOG[10]
                                 SNC := SN[ifaixa] + 3.51 * LCBR - .85 * [LCBR ^ 2] - 1.43
                                 D0[ifaixa] := 100 * 6.5 * [SNC ^ -1.6]
                                 UltCamada[ifaixa] := 'CBUQ'
                                 Restaurado[ifaixa] := 'Sim'
                                 ALPHA[ifaixa] := FCnovo
                                 HrecExist[ifaixa] := 0
                                 HRef[ifaixa] := HR
                                 IRec[ifaixa] := 0
              CASE 'FR+RC', 'RS', 'MF+RC', 'RRV'
                                 GOSUB 6900
                                 Age := 0!
                                 SN[ifaixa] := SN[ifaixa] + [[.44 * HR - .35 * HC] / 2.54]
                                 PSIQI := 5! * EXP[-QIest / 71.5]
                                 PSR := 5
                                 PSI := [PSR + PSIQI] / 2
                                 if PSI > 4.95 then PSI := 4.95
                                 if PSI <:= 2.5 then PSI := 2.55
                                 PSInovo[ifaixa] := PSI
                                 IRI0[ifaixa] := QIest / 13
                                 H1 := H1 + HR - HC
                                 UltCamada[ifaixa] := 'CBUQ'
                                 Restaurado[ifaixa] := 'Sim'
                                 ALPHA[ifaixa] := FCrecap
                                 if HC < HrecExist[ifaixa] then
                                    HRef[ifaixa] := HR + Heff[ifaixa]
                                 ELSE
                                    HRef[ifaixa] := HR
                                 end;
                                 HrecExist[ifaixa] := HR
                                 DC := D0[ifaixa] * EXP[[.35 / .44] * HC / 40]
                                 B := 30
                                 P := 4100 / [PI * B * B / 4]
                                 MRfound[ifaixa] := 2 * [1 - .33 * .33] * P * [B / 2] / [DC / 1000]
                                 D0[ifaixa] := DC * EXP[-HR / 40]
                                 IRec[ifaixa] := 1
              CASE 'FR+CP'
                                 HR := HRCP[IRodov]
                                 HC := HR
                                 GOSUB 6900
                                 PSIQI := 5! * EXP[-QIest / 71.5]
                                 PSR := 5
                                 PSI := [PSR + PSIQI] / 2
                                 if PSI > 4.95 then PSI := 4.95
                                 if PSI <:= 2.5 then PSI := 2.55
                                 PSInovo[ifaixa] := PSI
                                 UltCamada[ifaixa] := CamadaRest[IRodov]
                                 Restaurado[ifaixa] := 'Sim'
                                 IRec[ifaixa] := 1
              CASE 'CP'
                                 PSI := PSR0rest[IRodov]
                                 HR := HRCP[IRodov]
                                 HC := 0
                                 GOSUB 6900
                                 ' Efeito estrutural
                                   H1 := H1 + HRCP[IRodov]
                                 UltCamada[ifaixa] := CamadaRest[IRodov]
                                 Restaurado[ifaixa] := 'Sim'
                                 IRec[ifaixa] := 1
              CASE 'CR', 'ST', 'CL'
             
              CASE ELSE
                                 PRINT 'ERRO': STOP
       END SELECT
       RETURN

6500 ' - - - - - - - - - - - - - - - - - - - - - - - -
     ' -    Calculo da Vida Residual do Pavimento    -
     ' -                 [Subrotina]                 -
     ' -  Dados: PSI, PSif, ALPHA[ifaixa], QIest     -
     ' -  Saida: VR                                  -
     ' - - - - - - - - - - - - - - - - - - - - - - - -
       DELTAT := .1
       NYEAR := Nano[ifaixa] / 1000000!
       if UltCamada[ifaixa] := 'CBUQ' then
          VRmax := 25
          VRmin := 2
          dPSIdtmin := 2! / VRmax
          dPSIdtmax := 2! / VRmin
          DPSImin := dPSIdtmin * DELTAT
          DPSImax := dPSIdtmax * DELTAT
          DPSI := PSInovo[ifaixa] - 2.5
          if HrecExist[ifaixa] := 0 then
                 BETA := .4 + [1094 / [[SN[ifaixa] + 1] ^ 5.19]]
                 MR := 100 * CBRSL / .0703
                 W18 := [[[SN[ifaixa] + 1] / 1.05] ^ 9.36] * [[DPSI / 2.7] ^ [1 / BETA]]
                 W18 := W18 * [[MR / 3000] ^ 2.32] / 1000000!
          ELSE
                 SNrecap := .44 * HRef[ifaixa] / 2.54
                 MR := MRfound[ifaixa] / .0703
                 BETA := .4 + [1094 / [[SNrecap + 1] ^ 5.19]]
                 W18 := [[[SNrecap + 1] / 1.05] ^ 9.36] * [[DPSI / 2.7] ^ [1 / BETA]]
                 W18 := W18 * [[MR / 3000] ^ 2.32] / 1000000!
          end;
          ALFAA := [1 / W18] * LOG[LOG[2.5 / 5] / LOG[PSInovo[ifaixa] / 5]]
          ALFA := ALFAA * ALPHA[ifaixa]

          VR := 0
          PSIatual := PSI
          if PSIatual > PSif then
             WHILE [PSIatual > PSif AND VR < VRmax AND QIest < QIcrit]
                   VR := VR + DELTAT
                   DELTAN := DELTAT * NYEAR * [FatorTraf ^ VR]
                   DeltaPSI := ALFA * DELTAN * PSIatual * LOG[PSIatual / 5]
                   if ABS[DeltaPSI] > DPSImax then DeltaPSI := -DPSImax
                   if ABS[DeltaPSI] < DPSImin then DeltaPSI := -DPSImin
                   PSIatual := PSIatual + DeltaPSI
                   if PSIatual < 1.5 then PSIcrit := 1.5 ELSE PSIcrit := PSIatual
                   DQI := -71.5 * DeltaPSI / PSIcrit
                   QIest := QIest + DQI
             WEND
          end;
       ELSE
              VRmax := 7
              VRmin := 1
              dPSIdtmin := 2! / VRmax
              dPSIdtmax := 2! / VRmin
              DPSImin := dPSIdtmin * DELTAT
              DPSImax := dPSIdtmax * DELTAT
              VR := 0
              PSIatual := PSI
              if PSIatual > PSif then
                 DELTAN := DELTAT * NYEAR * [FatorTraf ^ VR]
                 WHILE [PSIatual > PSif AND VR < VRmax]
                       VR := VR + DELTAT
                       DeltaPSI := -[A0rest[IRodov] + B0rest[IRodov] * D0[ifaixa]] * DELTAN
                       if ABS[DeltaPSI] > DPSImax then DeltaPSI := -DPSImax
                       if ABS[DeltaPSI] < DPSImin then DeltaPSI := -DPSImin
                       PSIatual := PSIatual + DeltaPSI
                 WEND
              end;
       end;
       if VR := DELTAT then VR := 0
       RETURN

8000 ' - - - - - - - - - - - - - - - - - - - - - - -
     ' -  Compatibilizacao Geometrica de Solucoes  -
     ' -          entre Faixas de Trafego          -
     ' -                [Subrotina]                -
     ' - - - - - - - - - - - - - - - - - - - - - - -
     CotaMax := 0
     FaixaMax := 1
     CotaMin := 1000
     FaixaMin := 1
     FOR ifaixa := 1 TO NFaixas[ISTH]
         GOSUB 8700
         CotaFaixa[ifaixa] := Cota
         if CotaFaixa[ifaixa] > CotaMax then
                 CotaMax := CotaFaixa[ifaixa]
                 FaixaMax := ifaixa
         end;
         if CotaFaixa[ifaixa] < CotaMin then
                 CotaMin := CotaFaixa[ifaixa]
                 FaixaMin := ifaixa
         end;
     NEXT ifaixa
     Compat := 'Nao'
     FOR ifaixa := 1 TO NFaixas[ISTH]
         if CotaFaixa[ifaixa] < CotaMax then Compat := 'Sim'
     NEXT ifaixa
     FOR ifaixa := 1 TO NFaixas[ISTH]
         if IPRIOR[ISTH, ifaixa] >:= IPFORC then Compat := 'Nao'
     NEXT ifaixa
     if Compat := 'Nao' then 8100
     ' Compatibiliza as duas faixas nos extremos de greide da pista
       Cota1 := CotaMin
       Cota2 := CotaMax
       Delta := ABS[Cota1 - Cota2]
       I1 := FaixaMin
       I2 := FaixaMax
       if (MedidaF[I1] := 'RRP' OR MedidaF[I1] := 'RRT'] then Delta := 0
       if Delta > 0 then
          if Delta < 1 then
             SELECT CASE MedidaF[I1]
                    CASE 'RS', 'MF+RC', 'FR+RC'
                              Hrec[I1] := Hrec[I1] + Delta
                    CASE ELSE
                              Hfres[I2] := Hfres[I2] + Delta
             END SELECT
          ELSE
             if UltCamada[I2] := 'CCP' then
                  HCMAX := 0
             ELSE
                  HCMAX := H1REV[I2] - Hfres[I2] - 3
             end;
             if Hfres[I2] > 0 then
                 if HCMAX < 0 then HCMAX := 0
             ELSE
                 if HCMAX < HCMIN then HCMAX := 0
             end;
             if Delta <:= HCMAX then
             ' O desnivel pode ser resolvido aprofundando a fresagem na faixa I2
               ifX := I2
               GOSUB 8500
             ELSE
               ' O desnivel nao pode ser resolvido apenas aprofundando a fresagem na faixa I2
                 HCnovo := Hfres[I2] + HCMAX
                 if MedidaF[I2] := 'FR+RC' then
                    ' Um aprofundamento da fresagem em I2 eh possivel
                      Hfres[I2] := HCnovo
                      Cota2 := Hrec[I2] - Hfres[I2]
                      Delta := ABS[Cota1 - Cota2]
                 end;
                 SELECT CASE MedidaF[I1]
                        CASE 'CR', 'CL', 'ST'
                                if MedidaF[I2] := 'CP' then
                                   MedidaF[I1] := MedidaF[I2]
                                   Hfres[I1] := Hfres[I2]
                                   Hrec[I1] := Hrec[I2]
                                ELSE
                                   GOSUB 8900
                                end;
                        CASE 'CP', 'FR+CP'
                                GOSUB 8900
                        CASE 'RS', 'MF+RC', 'FR+RC'
                                Hrec[I1] := Hrec[I1] + Delta
                        CASE ELSE
                
                 END SELECT
             end;
          end;
       end;
     CotaMax := 0
     FaixaMax := 1
     FOR ifaixa := 1 TO NFaixas[ISTH]
         GOSUB 8700
         CotaFaixa[ifaixa] := Cota
         if CotaFaixa[ifaixa] > CotaMax then
                 CotaMax := CotaFaixa[ifaixa]
                 FaixaMax := ifaixa
         end;
     NEXT ifaixa
     Compat := 'Nao'
     FOR ifaixa := 1 TO NFaixas[ISTH]
         if CotaFaixa[ifaixa] < CotaMax then Compat := 'Sim'
     NEXT ifaixa
     if Compat := 'Nao' then 8100
     ' Compatibiliza as faixas de trafego com a de maxima elevacao de greide
       Cota2 := CotaMax
       FOR ifaixa := 1 TO NFaixas[ISTH]
           if ifaixa <> FaixaMax then
              GOSUB 8700
              Cota1 := Cota
              Delta := Cota2 - Cota1
              if (MedidaF[ifaixa] := 'RRP' OR MedidaF[ifaixa] := 'RRT'] then Delta := 0
              if Delta > 0 then
                 SELECT CASE MedidaF[ifaixa]
                        CASE 'CR', 'CL', 'ST', 'CP', 'FR+CP'
                                  HRnew := Hrec[ifaixa] + Delta
                                  if HRnew >:= HRmin then
                                     MedidaF[ifaixa] := 'RS'
                                     Hfres[ifaixa] := 0
                                     Hrec[ifaixa] := HRnew
                                  ELSE
                                     MedidaF[ifaixa] := 'FR+RC'
                                     Hfres[ifaixa] := HCMIN
                                     Hrec[ifaixa] := HCMIN + HRnew
                                  end;
                        CASE 'RS', 'MF+RC', 'FR+RC'
                                  Hrec[ifaixa] := Hrec[ifaixa] + Delta
                        CASE ELSE
                 END SELECT
              end;
           end;
       NEXT ifaixa
8100   ' Solucao para os Acostamentos, apos a compatibilizacao da pista
         CotaMax := 0
         FOR ifaixa := 1 TO NFaixas[ISTH]
             GOSUB 8700
             CotaFaixa[ifaixa] := Cota
             if CotaFaixa[ifaixa] > CotaMax then CotaMax := CotaFaixa[ifaixa]
         NEXT ifaixa
         FOR ifaixa := 1 TO NFaixas[ISTH]
             if DegrauAcost[ifaixa] >:= 0 then HRACOST := CotaMax + DegrauAcost[ifaixa] ELSE HRACOST := CotaMax
             if HRACOST <:= DEGRAUadm then
                     HRAC[ifaixa] := 0
                     if PSIacost[ifaixa] >:= 3.5 then MedidaAcost[ifaixa] := 'CR' ELSE MedidaAcost[ifaixa] := 'CL'
             ELSE
                     if HRACOST <:= [DEGRAUadm + 1.2] then
                                 HRAC[ifaixa] := 1.2
                                 MedidaAcost[ifaixa] := 'TSS'
                     ELSE
                                 if HRACOST <:= [DEGRAUadm + 2.0] then
                                             HRAC[ifaixa] := 2.0
                                             MedidaAcost[ifaixa] := 'TSD'
                                 ELSE
                                             if HRACOST <:= [DEGRAUadm + 7!] then
                                                         if PSIacost[ifaixa] >:= 2! then
                                                                      MedidaAcost[ifaixa] := 'PMF'
                                                                      HRAC[ifaixa] := HRACOST - DEGRAUadm
                                                         ELSE
                                                                      MedidaAcost[ifaixa] := 'RRP'
                                                                      HRAC[ifaixa] := 2.5
                                                                      H2AC[ifaixa] := HbaseAcost
                                                         end;
                                             ELSE
                                                         MedidaAcost[ifaixa] := 'RRT'
                                                         HRAC[ifaixa] := 2.5
                                                         H2AC[ifaixa] := [HRACOST - DEGRAUadm] - HRAC[ifaixa]
                                                         if H2AC[ifaixa] < 12 then H2AC[ifaixa] := 12
                                             end;
                                 end;
                     end;
             end;
         NEXT ifaixa
       RETURN

8300 ' - - - - - - - - - - - - - - - - - - - - - -
     ' -   Compatibilizacao Geometrica [cont.]   -
     ' -               [Subrotina]               -
     ' - - - - - - - - - - - - - - - - - - - - - -
       if Hrec[I1] < HRmin then
               Delta := HRmin - Hrec[I1]
               Hrec[I2] := Hrec[I2] + Delta
               Hrec[I1] := HRmin
       end;
       RETURN

8500 ' - - - - - - - - - - - - - - - - - - - - - -
     ' -   Compatibilizacao Geometrica [cont.]   -
     ' -               [Subrotina]               -
     ' - - - - - - - - - - - - - - - - - - - - - -
       if MedidaF[ifX] := 'MF+RC' then Delta := Delta - 2
       if Hfres[ifX] := 0 then
          if MedidaF[ifX] := 'CP' then
                 Hfres[ifX] := HRmin - Hrec[ifX] + Delta
                 Hrec[ifX] := HRmin
          ELSE
                 Hfres[ifX] := Delta
          end;
          MedidaF[ifX] := 'FR+RC'
          if Hfres[ifX] < HCMIN then
                 Dif := HCMIN - Hfres[ifX]
                 Hfres[ifX] := HCMIN
                 Hrec[ifX] := Hrec[ifX] + Dif
          end;
       ELSE
          Hfres[ifX] := Hfres[ifX] + Delta
       end;
       RETURN

8700 ' - - - - - - - - - - - - - - - - - - - - - -
     ' -   Compatibilizacao Geometrica [cont.]   -
     ' -               [Subrotina]               -
     ' - - - - - - - - - - - - - - - - - - - - - -
       SELECT CASE MedidaF[ifaixa]
              CASE 'RS', 'CP'
                           Cota := Hrec[ifaixa]
              CASE 'FR+RC'
                           Cota := Hrec[ifaixa] - Hfres[ifaixa]
              CASE 'MF+RC'
                           Cota := Hrec[ifaixa] + 2
              CASE ELSE
                           Cota := 0
       END SELECT
       RETURN

8900 ' - - - - - - - - - - - - - - - - - - - - - -
     ' -   Compatibilizacao Geometrica [cont.]   -
     ' -               [Subrotina]               -
     ' - - - - - - - - - - - - - - - - - - - - - -
       MedidaF[I1] := 'RS'
       Hfres[I1] := 0
       HRnovo := Delta + Hrec[I1]
       if HRnovo >:= HRmin then
              Hrec[I1] := HRnovo
       ELSE
              Hrec[I1] := HRmin
              Cota1 := Hrec[I1] - Hfres[I1]
              Delta := ABS[Cota1 - Cota2]
              Hrec[I2] := Hrec[I2] + Delta
       end;
       RETURN

6700 ' - - - - - - - - - - - - -
     ' -   Trafego de Projeto  -
     ' -      [Subrotina]      -
     ' - - - - - - - - - - - - -
       NPA := 0
       PER := INT[PERIODO]
       FOR IAA := 1 TO PER
           NPA := NPA + [FatorTraf ^ IAA]
       NEXT IAA
       NPA := NPA + [FatorTraf ^ [PERIODO - PER]]
       NPA := NPA * NYEAR / 1000000!
       RETURN

6900 ' - - - - - - - - - - - - - - - - - - - -
     ' -   Irregularidade apos Recapeamento  -
     ' -        [Subrotina do HDM-III]       -
     ' -   Dados: HR, HC, QIest, QI0adm      -
     ' -   Saida: QIest                      -
     ' - - - - - - - - - - - - - - - - - - - -
       if QIest > 19 then
                          QIB := 19! + [[QIest - 19!] / [.602 * HC + 1]]
       ELSE
                          QIB := QIest
       end;
       if QI0adm > 0 then
                          DQI := QI0adm - QIB
       ELSE
                          H0 := 10 * HR
                          if QIB > 13 then QIBL := QIB ELSE QIBL := 13
                          if H0 < 80 then H0L := H0 ELSE H0L := 80
                          if H0 < 40 then X := H0 ELSE X := 40
                          HOV := 3 - [[H0L + X] / 40]
                          X1 := 19.42 - .78 * QIBL - .068 * H0
                          if H0 > 20 then Y := H0 - 20 ELSE Y := 0
                          X2 := -19.5 - .008 * QIBL * Y
                          if X1 > X2 then DQI := X1 ELSE DQI := X2
                          if DQI > 0 then DQI := 0
       end;
       QIest := QIB + DQI
       RETURN

7000 ' - - - - - - - - - - - - - - - - -
     ' -   Trechos que Compoem a Rede  -
     ' -           [Subrotina]         -
     ' - - - - - - - - - - - - - - - - -
       IPolo := IRodov
       RETURN

}
