CLS

' Funcao densidade de probabilidade para Fc
DIM Nc(4), NQI(4), NS(4)
Nc(1) = 50: NS(1) = 0: NQI(1) = 0
Nc(2) = 85: NS(2) = 1.04: NQI(2) = 1.08
Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.6038
Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.35

OPEN "SISTEMA.DAT" FOR INPUT AS #1
INPUT #1, SGP$
CLOSE #1
SGP$ = UCASE$(SGP$)
SELECT CASE SGP$
    CASE "SGPC\", "SGPL\", "SGPM\", "SGP3\", "SGP4\", "SGP5\", "SGP6\", "SGP7\", "SGP8\", "SGP9\"
    CASE ELSE
        SGP$ = SGP$ + "\"
END SELECT

OPEN "DISCO.DAT" FOR INPUT AS #1
INPUT #1, Disco$
CLOSE #1

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Fatores de Calibracao do Modelo AASHTO-HDM
OPEN "FcAASHTOHDM.csv" FOR INPUT AS #1
LINE INPUT #1, LINHA$
INPUT #1, Tipo$, FcPavNovoPSISL, FcPavNovoPSISB, FcPavNovoPSIBS, CfRecapPSI
INPUT #1, Tipo$, FcPavNovoSCISL, FcPavNovoSCISB, FcPavNovoSCIBS, CfRecapSCI
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4: NPolos = NRODOV
DIM CustoP(NPolos), ConserP(NPolos), UltCamada$(NFaixasMax), SN(NFaixasMax)
DIM Revest$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax)
DIM HRef(NFaixasMax), Heff(NFaixasMax), VDMUni(NFaixasMax), IRec(NFaixasMax)
DIM FCnovorede(NRODOV), FCrecaprede(NRODOV), FCmicroCA(NRODOV)
DIM FC0novorede(NRODOV), FC0recaprede(NRODOV), FC0microCA(NRODOV)
DIM FC2novorede(NRODOV), FC2recaprede(NRODOV), FC2microCA(NRODOV)
DIM ICalib(NFaixasMax), Trecho$(NRODOV), D0(NFaixasMax), MRfound(NFaixasMax)
DIM PSIacost(NFaixasMax), DegrauAcost(NFaixasMax), MedidaAcost$(NFaixasMax)
DIM HRAC(NFaixasMax), H2AC(NFaixasMax), CustoAcost(NFaixasMax)
DIM MatCP$(NRODOV), HRCP(NRODOV), CamadaRest$(NRODOV), FX(NFaixasMax)
DIM A0rest(NRODOV), A1rest(NRODOV), A2rest(NRODOV), SErest(NRODOV)

' Tipos de dados de que a base de dados e' composta:
ARQUIVO$ = DADOS$ + "TIPODADO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NDADOS
DIM DADO$(15)
FOR I = 1 TO NDADOS
    INPUT #1, DADO$(I)
NEXT I
CLOSE #1
NDADOS = NDADOS - 2
NTIPOSDADOS = NDADOS
FOR IFX = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "SUP"
NEXT IFX

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Leitura dos codigos numericos que identificam os Subtrechos Homogeneos:
DIM Code(NRODOV, NSTHMAX), NSTHI(NRODOV)
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "CODE" + Rodov$(I) + ".STH"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, NSTHI(I)
    FOR J = 1 TO NSTHI(I)
        INPUT #1, Code(I, J)
    NEXT J
    CLOSE #1
NEXT I

' Arquivo de configuracao do problema a ser analisado:
ARQUIVO$ = CALC$ + "DADOS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
INPUT #1, PPmin
INPUT #1, PPmax
INPUT #1, NPP
INPUT #1, inflacao
CLOSE #1
PP = PPmax

' Fatores de calibracao medios da rede
ARQUIVO$ = CALC$ + "CALIB.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FCnovorede(I), FCrecaprede(I), FCmicroCA(I)
NEXT I
INPUT #1, Rede$, FCnovo, FCrecap, FCmicro
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB0.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FC0novorede(I), FC0recaprede(I), FC0microCA(I)
NEXT I
INPUT #1, Rede$, FC0novo, FC0recap, FC0micro
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB2.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FC2novorede(I), FC2recaprede(I), FC2microCA(I)
NEXT I
INPUT #1, Rede$, FC2novo, FC2recap, FC2micro
CLOSE #1

' Parametros para o Indice de Prioridade (gerados em Estrat1.bas)
ARQUIVO$ = CALC$ + "IP.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, VDMmin, VDMmax
INPUT #1, PSIminRede, PSImaxRede
CLOSE #1

' Modelos de previsao de desempenho para conserva pesada
ARQUIVO$ = CALC$ + "CPtrecho.csv"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR IRodov = 1 TO NRODOV
    INPUT #1, TrechoDescr$, MatCP$(IRodov), HRCP(IRodov)
    ARQUIVO$ = PROGRAMA$ + "MODELOS.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #2
    INPUT #2, NMODELOS
    FOR J = 1 TO NMODELOS
        INPUT #2, CRest$
        INPUT #2, A0
        INPUT #2, A1
        INPUT #2, A2
        INPUT #2, Se
        IF CRest$ = MatCP$(IRodov) THEN
            CamadaRest$(IRodov) = CRest$
            A0rest(IRodov) = A0
            A1rest(IRodov) = A1
            A2rest(IRodov) = A2
            SErest(IRodov) = Se
        END IF
    NEXT J
    CLOSE #2
NEXT IRodov
CLOSE #1

' Percentagem da area que deve receber reparos localizados (CL)
DIM PSIitemCL(15), ARepCL(15)
ARQUIVO$ = CALC$ + "REPAROS.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
NitensCL = 0
WHILE NOT EOF(1)
    NitensCL = NitensCL + 1
    INPUT #1, PSIitemCL(NitensCL), ARepCL(NitensCL)
WEND
CLOSE #1

' Parametros para medir o desempenho das estrategias (Ocorrencias em %) e
' criterio para Priorizacao das Restauracoes sob Restricoes Orcamentarias
ARQUIVO$ = CALC$ + "PARAM.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, PSIref
INPUT #1, PTRAF
INPUT #1, PPSI
INPUT #1, Nconf
INPUT #1, QIref
INPUT #1, IGGref
INPUT #1, ATRref
INPUT #1, TRref
CLOSE #1
IF Nconf <= Nc(2) THEN
    i1 = 1: i2 = 2
ELSE
    IF Nconf <= Nc(3) THEN
        i1 = 2: i2 = 3
    ELSE
        i1 = 3: i2 = 4
    END IF
END IF
NpsiMod = ((Nc(i2) * NS(i1) - Nc(i1) * NS(i2)) + Nconf * (NS(i2) - NS(i1))) / (Nc(i2) - Nc(i1))
Ngauss = ((Nc(i2) * NS(i1) - Nc(i1) * NS(i2)) + Nconf * (NS(i2) - NS(i1))) / (Nc(i2) - Nc(i1))
Niri = ((Nc(i2) * NQI(i1) - Nc(i1) * NQI(i2)) + Nconf * (NQI(i2) - NQI(i1))) / (Nc(i2) - Nc(i1))

ARQUIVO$ = CALC$ + "NC.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, ZRmpd, S0mpd
CLOSE #1

' Criterios complementares para as arvores de decisao
ARQUIVO$ = CALC$ + "CRITERIO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TRcrit
INPUT #1, QIcrit
INPUT #1, ATRcrit
INPUT #1, ATRITOcrit
INPUT #1, IGGcrit
CLOSE #1

' Constantes
NPSITMAX = 11
PI# = 3.141592654#
QREF = 4100

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), VRmed(NPeriodos)
DIM Idade(NFaixasMax), PSIat(NSTH, NFaixasMax), Nano(NFaixasMax), PPrest(NPeriodos)
DIM RestrAnual(NPeriodos), RestrPolo(NPolos, NPeriodos), IPRIOR(NSTH, NFaixasMax)
DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), CustoFaixa(NFaixasMax)
DIM MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax), DIAGS$(NFaixasMax)
DIM PSImedSTH(NSTH), VSMIN(NPP), NPSI(NPeriodos), PSIt(NPSITMAX), NFaixas(NSTH)
DIM IRI0(NFaixasMax), ALPHA(NFaixasMax), CustoPolo(NPolos, NPeriodos), AreaAcost(NSTH, NFaixasMax)
DIM EXECF(NSTH, NFaixasMax), NewRestP(NPolos), CustoCLP(NPolos), Deficit(NPeriodos)
DIM IPMAXPolo(NPolos), STHPRIPolo(NPolos), CostPr(NPolos), CUSTOT(NPeriodos)

SELECT CASE MODO
    CASE 0
        MODOANALISE$ = "EVOLUI"
        VSMIN(1) = PP
        ARQ$ = "EVO"
    CASE 5
        MODOANALISE$ = "NECESSIDADES"
        VSMIN(1) = PP
        NPeriodos = 1
        ARQ$ = "NAT"
    CASE ELSE
        PRINT "ERRO"
END SELECT

IPSIT = 1
IPP = 1
  
CLS
PRINT
PRINT "                        * * * * * * * * * * * * * * * "
PRINT "                        *  ANALISA A CONDICAO ATUAL *  "
PRINT "                        * * * * * * * * * * * * * * * "

' Inicializacao de variaveis
FOR I = 0 TO NPeriodos
    NPSI(I) = 0
NEXT I

ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ANO = 0
ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #13

ISTH = 0
FOR IRodov = 1 TO NRODOV

    ARQUIVO$ = CALC$ + ARQ$ + "CT" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #15
    WRITE #15, "ANO", "STH", "KMI", "KMF", "Custo", "Custo1", "Custo2", "Custo3", "Custo4", "Acost"
    CLOSE #15
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFaixas(ISTH)
            INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), Nacum(IFX), Revest$(IFX), ALFAIGG(IFX)
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
        NEXT IFaixa
        WRITE #13, STH, KMI, KMF
        FOR IFX = 1 TO NFaixas(ISTH)
            Restaurado$(IFX) = "Nao"
            UltCamada$(IFX) = Revest$(IFX)
            HRef(IFX) = HrecExist(IFX)
            GOSUB 700
        NEXT IFX
    NEXT ISUB

NEXT IRodov
           
INPUT #12, PSImed(0), NPSI(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
WRITE #13, PSImed(0), NPSI(0), VRmed(0)
WRITE #13, AreaTotal, NUnidAnalise
CLOSE #12, #13

' * * * * * * * * * * * * *
' * Geracao da Estrategia *
' * * * * * * * * * * * * *

ARQUIVO$ = CALC$ + ARQ$ + ".CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #14
WRITE #14, "Ano", "STH", "Iniciokm", "Finalkm", "AcostLE", "HRACLE", "H2ACLE", "MedidaF1", "Hfrescm1", "HReccm1", "MedidaF2", "Hfrescm2", "HReccm2", "MedidaF3", "Hfrescm3", "HReccm3", "MedidaF4", "Hfrescm4", "HReccm4", "AcostLD", "HRACLD", "H2ACLD"
  
FOR ANO = 1 TO NPeriodos

    PRINT "                   Ano = "; ANO
    CustoTotal = 0
    CustoConserva = 0
    PSImed(ANO) = 0
    VRmed(ANO) = 0
    FOR IPole = 1 TO NPolos
        CustoP(IPole) = 0
        ConserP(IPole) = 0
    NEXT IPole
    TotalArea = 0
    NUnid = 0

    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO - 1) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12
    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #13

    ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #10

    ARQUIVO$ = CALC$ + "DIAGS.DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #11

    ISTH = 0
    FOR IRodov = 1 TO NRODOV

        ARQUIVO$ = CALC$ + "Cadas" + Rodov$(IRodov) + ".dat"
        OPEN ARQUIVO$ FOR INPUT AS #2
        LINE INPUT #2, LINHA$

        ' Parametros que definem as Arvores de Decisao:
        ARQUIVO$ = CALC$ + "ARV" + Rodov$(IRodov) + ".dat"
        OPEN ARQUIVO$ FOR INPUT AS #1
        INPUT #1, HRcrit
        INPUT #1, PSRcrit
        INPUT #1, HRmin
        INPUT #1, HRmax
        INPUT #1, PSIf
        INPUT #1, DEGRAUadm
        INPUT #1, HCmin
        INPUT #1, HCMAXgeral
        INPUT #1, VUMin
        INPUT #1, QI0adm
        INPUT #1, HbaseAcost
        INPUT #1, RepFres
        INPUT #1, TipoRevAcost$
        INPUT #1, SART$
        CLOSE #1
        SELECT CASE SART$
            CASE "MF3"
                HRMF = 3
            CASE "MF4"
                HRMF = 4
            CASE ELSE
                HRMF = 2
        END SELECT

        ' PSI terminal para necessidade de restaurar o pavimento
        NPSIT = 1
        PSIt(1) = PSIf

        IPolo = IRodov
        ' Estado de Superficie no Ano-Base
        FOR IFX = 1 TO NFaixasMax
            SELECT CASE IFX
                CASE 1: Faixa$ = "1"
                CASE 2: Faixa$ = "2"
                CASE 3: Faixa$ = "3"
                CASE 4: Faixa$ = "4"
                CASE ELSE: PRINT "ERRO"
            END SELECT
            ISUP = 2 + IFX
            ARQUIVO$ = CALC$ + "SUP" + Rodov$(IRodov) + Faixa$ + ".DAT"
            OPEN ARQUIVO$ FOR INPUT AS #ISUP
            ISUPout = 6 + IFX
            IF ISUPout = 10 THEN ISUPout = 16
            ARQUIVO$ = Disco$ + SGP$ + "Docs\Params\" + "LVC" + Rodov$(IRodov) + Faixa$ + ".CSV"
            OPEN ARQUIVO$ FOR INPUT AS #ISUPout
            LINE INPUT #ISUPout, LINHA$
            LINE INPUT #ISUPout, LINHA$
        NEXT IFX

        FOR ISUB = 1 TO NSTHRODOV(IRodov)

            ISTH = ISTH + 1

            INPUT #2, Subtrecho$, Rodov$, INI$, FIM$, KMini, KMfim, PISTA$
            INPUT #2, NFX, PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
            INPUT #2, GEOVERT$, GEOHORIZ$, SECTIPO$, FX(1), FX(2), FX(3), FX(4), DECTRA, RESTR, ExtPontes, OBS$
            PISTA$ = UCASE$(PISTA$)

            ' Inicializacao de parametros a cada ano
            FOR IFaixa = 1 TO NFaixasMax
                MedidaF$(IFaixa) = ""
                Hfres(IFaixa) = 0
                Hrec(IFaixa) = 0
                CustoFaixa(IFaixa) = 0
                MedidaAcost$(IFaixa) = ""
                HRAC(IFaixa) = 0
                H2AC(IFaixa) = 0
                CustoAcost(IFaixa) = 0
            NEXT IFaixa
            PSImedSTH(ISTH) = 0

            INPUT #12, STH, KMI, KMF

            FOR IFaixa = 1 TO NFaixas(ISTH)
                GOSUB 600
                ' Indice de Prioridade
                IPRIOR(ISTH, IFaixa) = 0
            NEXT IFaixa

            IF MODOANALISE$ <> "NECESSIDADES" THEN

                ' - - - - - - - - - - - - - - - - - - - - - - - - - -
                ' -  Evolucao da Condicao do Pavimento apos um Ano  -
                ' - - - - - - - - - - - - - - - - - - - - - - - - - -

                FOR IFaixa = 1 TO NFaixas(ISTH)

                    VidaRes(IFaixa) = VidaRes(IFaixa) - 1
                    IF VidaRes(IFaixa) < 0 THEN VidaRes(IFaixa) = 0
                    Idade(IFaixa) = Idade(IFaixa) + 1
                    PSI = PSIat(ISTH, IFaixa)
                    Nano(IFaixa) = Nano(IFaixa) * FatorTraf
                    Nacum(IFaixa) = Nacum(IFaixa) + Nano(IFaixa)
                    VDMUni(IFaixa) = VDMUni(IFaixa) * FatorVDM
                    H1 = H1REV(IFaixa)
                    Age = Idade(IFaixa)

                    IF Idade(IFaixa) >= 0 THEN
                        GOSUB 3000
                        PSIat(ISTH, IFaixa) = PSI
                        IF PSI <= PSIf THEN VidaRes(IFaixa) = 0
                        TR = TR23(IFaixa)
                        ATR = ATRmed(IFaixa)
                        PSIQIe = 5! * EXP(-QImed(IFaixa) / 71.5)
                        PSRest = 2 * PSIat(ISTH, IFaixa) - PSIQIe
                        IF PSRest < 0.5 THEN PSRest = 0.5
                        IGG = (309.22 - 61.844 * PSRest) / (PSRest + 0.616)
                        IF (PSI < PSIref OR QImed(IFaixa) > QIref OR IGG > IGGref OR ATR > ATRref OR TR > TRref) THEN
                            NPSI(ANO) = NPSI(ANO) + 1
                        END IF
                        PSImedSTH(ISTH) = PSImedSTH(ISTH) + PSIat(ISTH, IFaixa) * Aream2(ISTH, IFaixa)
                        VRmed(ANO) = VRmed(ANO) + Aream2(ISTH, IFaixa) * VidaRes(IFaixa)
                        TotalArea = TotalArea + Aream2(ISTH, IFaixa)
                        NUnid = NUnid + 1
                    END IF

                NEXT IFaixa

            END IF

            ' - - - - - - - - - - - - - - - - - - - - - - -
            ' - Necessidades de Manutencao da Rede no Ano -
            ' - - - - - - - - - - - - - - - - - - - - - - -

            RestSTH$ = "Nao"
            'AplicaCP$ = "Sim"
            FOR IFaixa = 1 TO NFaixasMax

                ISUP = 2 + IFaixa
                ISUPout = 6 + IFaixa
                IF ISUPout = 10 THEN ISUPout = 16

                IF IFaixa <= NFaixas(ISTH) THEN

                    ' Durabilidade esperada para a medida especificada como Conserva Pesada
                    MedCP$ = ""
                    MedCPbest$ = ""
                    DeltaT = .1
                    DeltaN = DeltaT * Nano(IFaixa) / 1000000!
                    ' Efeito dos reparos preliminares ao recapeamento
                    HR = 4
                    HC = HR
                    QIest = QImed(IFaixa)
                    GOSUB 6900
                    RedQI = QImed(IFaixa) - QIest
                    QIest = QImed(IFaixa) - (RepPerct(IFaixa) / 100) * RedQI

                    ' Medida tipo CP
                    HR = HRCP(IRodov)
                    HC = 0
                    GOSUB 300
                    IF VSCP >= VUMin THEN
                        MedCP$ = "CP"
                        MedCPbest$ = MedCP$
                    ELSE
                        ' Medida tipo FR+CP
                        HR = HRCP(IRodov)
                        HC = HR
                        QIest = QImed(IFaixa)
                        GOSUB 300
                        IF VSCP >= VUMin THEN
                            MedCP$ = "FR+CP"
                            MedCPbest$ = MedCP$
                        ELSE
                            ' Medida tipo MF+CP
                            HR = HRCP(IRodov) + HRMF
                            HC = 0
                            QIest = QImed(IFaixa)
                            GOSUB 300
                            IF VSCP >= VUMin THEN
                                IF SART$ <> "RSUP20" THEN
                                    MedCP$ = "MF+CP"
                                ELSE
                                    MedCP$ = "RSUP+CP"
                                END IF
                                MedCPbest$ = MedCP$
                            ELSE
                                IF SART$ <> "RSUP20" THEN
                                    MedCPbest$ = "MF+CP"
                                ELSE
                                    MedCPbest$ = "RSUP+CP"
                                END IF
                            END IF
                        END IF
                    END IF

                    ' Estado de Superficie no Ano-Base
                    INPUT #ISUP, SH$, KM1, KM2, PSR, CR$, BL$, TT$
                    INPUT #ISUP, TL$, TE$, TB$, P$, D$, DS$
                    INPUT #ISUP, ER$, BF$, DC$, R$, ATR$, COR$
                    INPUT #ISUP, EM$, DP$, EL$, PSRACOST, DEGRAUCM, OBS$, ATR

                    INPUT #ISUPout, KMI, KMF, IGGE, ICPF, IES, TR23, TR2, TR3, TRI, TRE, QI, Dc

                    Age = Idade(IFaixa)
                    PSI = PSIat(ISTH, IFaixa)
                    QI = QImed(IFaixa)
                    Nyear = Nano(IFaixa)
                    H1 = H1REV(IFaixa)
                    Dc = D0(IFaixa)
                    IDS = IGG(IFaixa)

                    ' Necessidade de reforco estrutural:
                    VR = VidaRes(IFaixa)
                    IF (Age >= 0 AND Age < 1) THEN PP = VSMIN(IPP) ELSE PP = VSMIN(IPP) - VR
                    IF PP < .5 THEN PP = .5
                    GOSUB 1200
                    HREFORCO(IFaixa) = HRMPD

                    IF Age >= 0 THEN
                        IF PSIat(ISTH, IFaixa) < 0 THEN
                            PSIat(ISTH, IFaixa) = .5
                            PSIacost(IFaixa) = .5
                            PSI = PSIat(ISTH, IFaixa)
                            IDS = 450
                        END IF
                        GOSUB 1000
                    ELSE
                        Medida$ = "CR"
                        HR = 0
                        HC = 0
                    END IF

                    IF HC > 0 THEN
                        RES = HC - INT(HC)
                        IF RES >= .5 THEN INCR = 1 ELSE INCR = 0
                        HC = INT(HC) + INCR
                    END IF
                    IF (HR > 0 AND Medida$ <> "CP" AND Medida$ <> "FR+CP" AND Medida$ <> "MF+CP" AND Medida$ <> "RSUP+CP") THEN
                        IF HR < HRmin THEN HR = HRmin
                        RES = HR - INT(HR)
                        IF RES >= .5 THEN INCR = 1 ELSE INCR = 0
                        HR = INT(HR) + INCR
                    END IF
                    MedidaF$(IFaixa) = Medida$
                    Hfres(IFaixa) = HC
                    Hrec(IFaixa) = HR
                    DIAGS$(IFaixa) = DIAGNOSTICO$

                    'IF (Medida$ = "CR" OR Medida$ = "CL") THEN AplicaCP$ = "Nao"
                    
                    RestSTH$ = "Sim"
                    IF (MedidaF$(IFaixa) = "" OR MedidaF$(IFaixa) = "CR" OR MedidaF$(IFaixa) = "CL" OR MedidaF$(IFaixa) = "ST") THEN RestSTH$ = "Nao"

                ELSE

                    LINE INPUT #ISUP, LINHA$
                    LINE INPUT #ISUPout, LINHA$

                END IF

            NEXT IFaixa

            'IF AplicaCP$ = "Nao" THEN
            '   FOR IFaixa = 1 TO NFaixas(ISTH)
            '       IF MedidaF$(IFaixa) = "CP" THEN
            '          MedidaF$(IFaixa) = "CL"
            '          Hfres(IFaixa) = 0
            '          Hrec(IFaixa) = 0
            '       END IF
            '   NEXT IFaixa
            'END IF

            ' Evolucao da condicao dos acostamentos apos um ano
            FOR IFaixa = 1 TO NFaixas(ISTH)
                IF PSIacost(IFaixa) > 3.5 THEN
                    DPSI = .05
                ELSE
                    IF PSIacost(IFaixa) > 2! THEN DPSI = .1 ELSE DPSI = .2
                END IF
                PSIacost(IFaixa) = PSIacost(IFaixa) - DPSI
                IF PSIacost(IFaixa) < 0 THEN PSIacost(IFaixa) = 0
            NEXT IFaixa

            ' Compatibiliza a geometria entre as faixas de trafego (incluindo os acostamentos)
            GOSUB 8000

            ' Solucoes Forcadas para os acostamentos
            FOR IFaixa = 1 TO NFaixas(ISTH)
                IF RestSTH$ = "Nao" THEN
                    MedidaAcost$(IFaixa) = "CR"
                    HRAC(IFaixa) = 0
                    H2AC(IFaixa) = 0
                END IF
                ARQUIVO$ = CALC$ + "AcosForc.csv"
                OPEN ARQUIVO$ FOR INPUT AS #1
                LINE INPUT #1, LINHA$
                WHILE EOF(1) = False
                    INPUT #1, TrechoForc$, STHForc, AnoForc, FaixaForc, MedForc$, HCForc, HRForc
                    IF (STH = STHForc AND ANOcal = AnoForc AND IFaixa = FaixaForc) THEN
                        MedidaAcost$(IFaixa) = MedForc$
                        HRAC(IFaixa) = HRForc
                        H2AC(IFaixa) = HCForc
                    END IF
                WEND
                CLOSE #1
            NEXT IFaixa

            ' Custos Unitarios:
            IF MODOANALISE$ = "NECESSIDADES" THEN
                YEAR$ = STR$(0)
            ELSE
                YEAR$ = STR$(ANO)
            END IF
            ' Leitura dos Custos Unitarios
            GOSUB 500

            FOR IFaixa = 1 TO NFaixas(ISTH)

                Medida$ = MedidaF$(IFaixa)
                GOSUB 5000

                CustoFaixa(IFaixa) = Custo
                CustoTotal = CustoTotal + Custo
                IF (Medida$ = "CR" OR Medida$ = "CL" OR Medida$ = "CP" OR Medida$ = "ST") THEN
                    CustoConserva = CustoConserva + Custo
                    ConserP(IPolo) = ConserP(IPolo) + Custo
                END IF
                CustoP(IPolo) = CustoP(IPolo) + Custo

            NEXT IFaixa

            ' Custo da Intervencao nos Acostamentos
            FOR IFaixa = 1 TO NFaixas(ISTH)
                GOSUB 2000
                CustoAcost(IFaixa) = Custo * AreaAcost(ISTH, IFaixa)
                CustoTotal = CustoTotal + CustoAcost(IFaixa)
                CustoP(IPolo) = CustoP(IPolo) + CustoAcost(IFaixa)
                IF (MedidaAcost$(IFaixa) = "CR" OR MedidaAcost$(IFaixa) = "CL" OR MedidaAcost$(IFaixa) = "ST") THEN
                    CustoConserva = CustoConserva + CustoAcost(IFaixa)
                    ConserP(IPolo) = ConserP(IPolo) + CustoAcost(IFaixa)
                END IF
            NEXT IFaixa

            WRITE #13, STH, KMini, KMfim
            FOR IFX = 1 TO NFaixas(ISTH)
                GOSUB 700
            NEXT IFX

            FOR IFX = 1 TO NFaixas(ISTH)
                WRITE #10, STH, CustoFaixa(IFX), MedidaF$(IFX), Hfres(IFX), Hrec(IFX), CustoAcost(IFX), MedidaAcost$(IFX), HRAC(IFX), H2AC(IFX)
            NEXT IFX

            FOR IFaixa = 1 TO NFaixas(ISTH)
                WRITE #11, STH, DIAGS$(IFaixa)
            NEXT IFaixa

        NEXT ISUB

        FOR IFX = 1 TO NFaixasMax
            ISUP = 2 + IFX
            ISUPout = 6 + IFX
            IF ISUPout = 10 THEN ISUPout = 16
            CLOSE #ISUP
            CLOSE #ISUPout
        NEXT IFX
        CLOSE #2

    NEXT IRodov
    Deficit(ANO) = CustoTotal

    INPUT #12, PSImed(0), NPSI(0), VRmed(0)
    INPUT #12, AreaTotal, NUnidAnalise
    WRITE #13, PSImed(0), NPSI(0), VRmed(0)
    WRITE #13, AreaTotal, NUnidAnalise
    CLOSE #4, #10, #11, #12, #13

    ' - - - - - - - - - - - - - - - - - - - - -
    ' -  Custos das Intervencoes Necessarias  -
    ' - - - - - - - - - - - - - - - - - - - - -

    CUSTOT(ANO) = 0
    FOR IPole = 1 TO NPolos
        CustoPolo(IPole, ANO) = 0
    NEXT IPole

    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12
    ARQUIVO$ = CALC$ + "ESTSTHS2.DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #13

    ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #6

    ISTH = 0
    FOR IRodov = 1 TO NRODOV

        IPolo = IRodov
        FOR ISUB = 1 TO NSTHRODOV(IRodov)

            ISTH = ISTH + 1

            INPUT #12, STH, KMI, KMF
            FOR IFaixa = 1 TO NFaixas(ISTH)
                GOSUB 600
            NEXT IFaixa

            FOR IFaixa = 1 TO NFaixasMax
                CustoFaixa(IFaixa) = 0
                CustoAcost(IFaixa) = 0
            NEXT IFaixa
            FOR IFX = 1 TO NFaixas(ISTH)
                INPUT #6, STH, CustoFaixa(IFX), MedidaF$(IFX), Hfres(IFX), Hrec(IFX), CustoAcost(IFX), MedidaAcost$(IFX), HRAC(IFX), H2AC(IFX)
            NEXT IFX

            FOR IFaixa = 1 TO NFaixas(ISTH)

                IF Idade(IFaixa) >= 0 THEN
                    VRmed(ANO) = VRmed(ANO) + Aream2(ISTH, IFaixa) * VidaRes(IFaixa)
                    IF PSIat(ISTH, IFaixa) < PSIref THEN NPSI(ANO) = NPSI(ANO) + 1
                    PSImedSTH(ISTH) = PSImedSTH(ISTH) + Aream2(ISTH, IFaixa) * PSIat(ISTH, IFaixa)
                END IF
                CUSTOT(ANO) = CUSTOT(ANO) + CustoFaixa(IFaixa)
                CustoPolo(IPolo, ANO) = CustoPolo(IPolo, ANO) + CustoFaixa(IFaixa)

                ' Inclui o custo da intervencao nos acostamentos
                CUSTOT(ANO) = CUSTOT(ANO) + CustoAcost(IFaixa)
                CustoPolo(IPolo, ANO) = CustoPolo(IPolo, ANO) + CustoAcost(IFaixa)

            NEXT IFaixa

            WRITE #13, STH, KMI, KMF
            FOR IFX = 1 TO NFaixas(ISTH)
                GOSUB 700
            NEXT IFX

            PSImed(ANO) = PSImed(ANO) + PSImedSTH(ISTH)
            J = Code(IRodov, ISUB)
            IF MODO = 5 THEN y = ANOBASE ELSE y = ANO + ANOBASE
            N = NFaixas(ISTH)
            FOR IFX = 1 TO NFaixasMax
                IF IFX > NFaixas(ISTH) THEN
                    MedidaF$(IFX) = ""
                    Hfres(IFX) = 0
                    Hrec(IFX) = 0
                END IF
            NEXT IFX
            WRITE #14, y, J, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(N), HRAC(N), H2AC(N)
            CustoSTH = 0
            CustoAc = 0
            FOR IFaixa = 1 TO NFaixas(ISTH)
                CustoSTH = CustoSTH + CustoFaixa(IFaixa) + CustoAcost(IFaixa)
                CustoAc = CustoAc + CustoAcost(IFaixa)
            NEXT IFaixa
            ARQUIVO$ = CALC$ + ARQ$ + "CT" + Rodov$(IRodov) + ".CSV"
            OPEN ARQUIVO$ FOR APPEND AS #15
            WRITE #15, y, J, KMI, KMF, CustoSTH, CustoFaixa(1), CustoFaixa(2), CustoFaixa(3), CustoFaixa(4), CustoAc
            CLOSE #15

        NEXT ISUB
    NEXT IRodov

    INPUT #12, PSImed(0), NPSI(0), VRmed(0)
    INPUT #12, AreaTotal, NUnidAnalise
    WRITE #13, PSImed(0), NPSI(0), VRmed(0)
    WRITE #13, AreaTotal, NUnidAnalise
    CLOSE #6, #12, #13

    ARQUIVO$ = CALC$ + "ESTSTHS2.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12
    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #13

    VDMmin = 1E+20: VDMmax = 0
    PSImin = 5!: PSImax = 0
    ISTH = 0
    FOR IRodov = 1 TO NRODOV
        FOR ISUB = 1 TO NSTHRODOV(IRodov)
            ISTH = ISTH + 1
            INPUT #12, STH, KMI, KMF
            FOR IFaixa = 1 TO NFaixas(ISTH)
                GOSUB 600
                IF VDMUni(IFX) > VDMmax THEN VDMmax = VDMUni(IFX)
                IF VDMUni(IFX) < VDMmin THEN VDMmin = VDMUni(IFX)
                IF PSIat(ISTH, IFX) > PSImax THEN PSImax = PSIat(ISTH, IFX)
                IF PSIat(ISTH, IFX) < PSImin THEN PSImin = PSIat(ISTH, IFX)
            NEXT IFaixa
            WRITE #13, STH, KMI, KMF
            FOR IFX = 1 TO NFaixas(ISTH)
                GOSUB 700
            NEXT IFX
        NEXT ISUB
    NEXT IRodov

    INPUT #12, PSImed(0), NPSI(0), VRmed(0)
    INPUT #12, AreaTotal, NUnidAnalise
    WRITE #13, PSImed(0), NPSI(0), VRmed(0)
    WRITE #13, AreaTotal, NUnidAnalise
    CLOSE #12, #13

    IF MODOANALISE$ <> "NECESSIDADES" THEN
        ' Fator 2 nas formulas abaixo se deve `a media entre antes e depois
        ' das intervencoes programadas para o ANO:
        NPSI(ANO) = 100 * NPSI(ANO) / (2 * NUnid)
        PSImed(ANO) = PSImed(ANO) / (2 * TotalArea)
        VRmed(ANO) = VRmed(ANO) / (2 * TotalArea)
    END IF

    ' - - - - - - - - - - - - - - -
    ' - Passa para o ano seguinte -
    ' - - - - - - - - - - - - - - -
NEXT ANO
CLOSE #14

' - - - - - - - - - - - - - - - - - - -
' -  Gera os Arquivos de Saida Finais -
' - - - - - - - - - - - - - - - - - - -
   
ARQUIVO$ = CALC$ + "Results.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #4
WRITE #4, "ANO", "CUSTO", "PSIMEDIO", "OCORR", "VRANOS"
                             
SELECT CASE MODOANALISE$
    CASE "EVOLUI"
        ARQCUSTO$ = CALC$ + "CustoEVO.out"
        ARQPSI$ = CALC$ + "PSISI.out"
        ARQNPSI$ = CALC$ + "NPSISI.OUT"
        ARQVR$ = CALC$ + "VRSI.out"
    CASE "NECESSIDADES"
        ARQCUSTO$ = CALC$ + "CustoNAT.out"
        ARQPSI$ = CALC$ + "PSIAT.out"
        ARQNPSI$ = CALC$ + "NPSI.OUT"
        ARQVR$ = CALC$ + "VRAT.out"
    CASE ELSE
        PRINT "ERRO"
END SELECT
  
OPEN ARQCUSTO$ FOR OUTPUT AS #1
OPEN ARQPSI$ FOR OUTPUT AS #2
OPEN ARQNPSI$ FOR OUTPUT AS #3
OPEN ARQVR$ FOR OUTPUT AS #5

FOR IANO = 1 TO NPeriodos
    CUSTOT(IANO) = 0
    Deficit(IANO) = Deficit(IANO) - CUSTOT(IANO)
    WRITE #1, CUSTOT(IANO)
    WRITE #1, Deficit(IANO)
    FOR IPolo = 1 TO NPolos
        WRITE #1, CustoPolo(IPolo, IANO)
    NEXT IPolo
    ANO = ANOBASE + IANO
    temp$ = "&, #######.###, #.##, ###.##, ###.##"
    PRINT #4, USING temp$; STR$(ANO); (Deficit(IANO) / 1000); PSImed(IANO); NPSI(IANO); VRmed(IANO)
NEXT IANO
CLOSE #1, #4

IF MODOANALISE$ = "NECESSIDADES" THEN

    ARQUIVO$ = CALC$ + "DIAGS.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #7
    ISTH = 0
    FOR IRodov = 1 TO NRODOV
        ARQUIVO$ = CALC$ + "DIAGS" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR OUTPUT AS #1
        WRITE #1, "STH", "Faixa 1", "Faixa 2", "Faixa 3", "Faixa 4"
        FOR ISUB = 1 TO NSTHRODOV(IRodov)
            ISTH = ISTH + 1
            FOR IFaixa = 1 TO NFaixas(ISTH)
                INPUT #7, STH, DIAGS$(IFaixa)
            NEXT IFaixa
            J = Code(IRodov, ISUB)
            WRITE #1, J, DIAGS$(1), DIAGS$(2), DIAGS$(3), DIAGS$(4)
        NEXT ISUB
        CLOSE #1
    NEXT IRodov
    CLOSE #7
    WRITE #2, PSImed(0)
    WRITE #3, NPSI(0)
    WRITE #5, VRmed(0)

ELSE

    FOR IANO = 0 TO NPeriodos
        WRITE #2, PSImed(IANO)
        WRITE #3, NPSI(IANO)
        WRITE #5, VRmed(IANO)
    NEXT IANO
 
END IF
CLOSE #2, #3, #5

SYSTEM


300 '
' - - - - - - - - - - - - - - - - - - - - - - - - - -
' -  Vida de servico prevista em medidas do tipo CP -
' - - - - - - - - - - - - - - - - - - - - - - - - - -
GOSUB 6900
PSIQI = 5! * EXP(-QIest / 71.5)
PSI = (5 + PSIQI) / 2
LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
SNCrec = SNC + (0.44 * (HR - HC) / 2.54)
VSCP = 0
QI = QIest
IGGest = 0
PSRest = 5
Achou$ = "N"
WHILE (Achou$ = "N" AND VSCP < 10)
    VSCP = VSCP + DeltaT
    DeltaPSI = -A1rest(IRodov) * DeltaN / EXP((A0rest(IRodov) + A2rest(IRodov) * SN(IFaixa) - (PSI + NpsiMod * SErest(IRodov))) / A1rest(IRodov))
    PSI = PSI + DeltaPSI
    QI = 13 * EXP(0.0153 * VSCP) * ((QIest / 13) + 725 * ((1 + SNCrec) ^ -4.99) * (Nano(IFaixa) / 1000000!) * VSCP)
    ' Evolucao do IGG e do PSR
    PSIQIe = 5! * EXP(-QI / 71.5)
    PSRe = 2 * PSI - PSIQIe
    IF PSRe < 0.5 THEN PSRe = 0.5
    DeltaPSR = PSRe - PSRest
    DeltaIGG = DeltaPSR * (-61.844 - IGGest) / (.616 + PSRest)
    IGGest = IGGest + DeltaIGG
    PSRest = PSRe
    IF (PSI < PSIf OR QI > QIcrit OR IGGest > IGGcrit) THEN Achou$ = "S"
WEND
RETURN


500 '
' - - - - - - - - - - - -
' -  Custos Unitarios   -
' -     (Subrotina)     -
' - - - - - - - - - - - -
ARQUIVO$ = CALC$ + "C" + Rodov$(IRodov) + YEAR$ + ".CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, CBUQm3
INPUT #1, Reperf
INPUT #1, Fresagemm3
INPUT #1, BGm3
INPUT #1, Remocao
INPUT #1, CRkmAno
INPUT #1, CLm2
INPUT #1, MICROCA4m2
INPUT #1, MICROCA7m2
INPUT #1, MICROCA12m2
INPUT #1, TSSm2
INPUT #1, TSDm3
INPUT #1, TSTm3
INPUT #1, Pintura
INPUT #1, Selagem
INPUT #1, PMFm3
INPUT #1, LamaD
INPUT #1, LamaM
INPUT #1, LamaG
INPUT #1, BaseAcostm3
INPUT #1, TSSpolm2
INPUT #1, TSDpolm3
INPUT #1, TSTpolm3
INPUT #1, CapeSealm3
INPUT #1, Imprimam2
INPUT #1, CamReciclm3
CLOSE #1
RETURN

600 '
INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
INPUT #12, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), Nacum(IFX), ALFAIGG(IFX), ATRmed(IFX)
INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX)
RETURN

700 '
WRITE #13, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
WRITE #13, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), Nacum(IFX), ALFAIGG(IFX), ATRmed(IFX)
WRITE #13, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX)
RETURN

5000 '
' - - - - - - - - - - - - - - - - - - - - - - -
' -       Custo da Medida de Manutencao       -
' -                (Subrotina)                -
' -  Dados: Medida$, HC, HR, Area, PSI, VDM   -
' -  Saida: Custo                             -
' - - - - - - - - - - - - - - - - - - - - - - -
SELECT CASE Medida$
    CASE "CP", "FR+CP", "MF+CP", "FR+MF+CP", "RSUP+CP"
        SELECT CASE CamadaRest$(IRodov)
            CASE "Lama Asfaltica Delgada": Custo = LamaD
            CASE "Lama Asfaltica Media": Custo = LamaM
            CASE "Lama Asfaltica Grossa": Custo = LamaG
            CASE "Micro-CA Delgado": Custo = MICROCA4m2
            CASE "Micro-CA Normal": Custo = MICROCA7m2
            CASE "Micro-CA Espesso": Custo = MICROCA12m2
            CASE "TSD": Custo = TSDm3 * (Hrec(IFaixa) / 100)
            CASE "TST": Custo = TSTm3 * (Hrec(IFaixa) / 100)
            CASE "TSD com Polimero (18 mm)": Custo = TSDpolm3 * (Hrec(IFaixa) / 100)
            CASE "Cape Seal (TSS+Micro)": Custo = CapeSealm3 * (Hrec(IFaixa) / 100)
            CASE ELSE: PRINT "ERRO"
        END SELECT
        Custo = Custo + Fresagemm3 * (Hfres(IFaixa) / 100)
        IF (Medida$ = "MF+CP" OR Medida$ = "FR+MF+CP") THEN Custo = Custo + Pintura + Reperf * (HRMF / 2)
    CASE "CR", ""
        Custo = 0
    CASE "CL", "ST"
        PSI = PSIat(ISTH, IFaixa)
        i1 = 0
        FOR ICL = 1 TO (NitensCL - 1)
            IF (PSI <= PSIitemCL(ICL) AND PSI > PSIitemCL(ICL + 1)) THEN
                i1 = ICL
                i2 = ICL + 1
            END IF
        NEXT ICL
        IF PSI <= PSIitemCL(NitensCL) THEN
            i1 = NitensCL - 1
            i2 = NitensCL
        END IF
        IF i1 = 0 THEN
            PerctReparos = 0
        ELSE
            Y1 = ARepCL(i1)
            Y2 = ARepCL(i2)
            X1 = PSIitemCL(i1)
            X2 = PSIitemCL(i2)
            PerctReparos = ((X2 * Y1 - X1 * Y2) / (X2 - X1)) + ((Y2 - Y1) * PSI / (X2 - X1))
        END IF
        IF Medida$ = "ST" THEN
            PerctReparos = .1 * PerctReparos
            IF PerctReparos > 1! THEN PerctReparos = 1!
            Custo = Selagem * PerctReparos / 100
        ELSE
            IF PerctReparos > ARepCL(NitensCL) THEN PerctReparos = ARepCL(NitensCL)
            Custo = CLm2 * PerctReparos / 100
        END IF
    CASE "RS", "RSUP+RC"
        GOSUB 5100
        Custo = (Hrec(IFaixa) / 100) * CBUQm3 + Ncamadas * Pintura
    CASE "MF+RC"
        GOSUB 5100
        Custo = (Hrec(IFaixa) / 100) * CBUQm3 + (Ncamadas + 1) * Pintura + Reperf * (HRMF / 2)
    CASE "FR+RC", "RRV", "FR+MF+RC"
        GOSUB 5100
        Custo = (Hrec(IFaixa) / 100) * CBUQm3 + Fresagemm3 * (Hfres(IFaixa) / 100) + Ncamadas * Pintura + Reperf * (HRMF / 2)
    CASE "RRP"
        GOSUB 5100
        Custo = Remocao * Hfres(IFaixa) / 100
        H2CM = Hfres(IFaixa) - Hrec(IFaixa)
        Custo = Custo + (Hrec(IFaixa) / 100) * CBUQm3 + (H2CM / 100) * BGm3 + Ncamadas * Pintura + Imprimam2
    CASE "RRT"
        GOSUB 5100
        Custo = Remocao * Hfres(IFaixa) / 100
        H2CM = Hfres(IFaixa) - Hrec(IFaixa) - 20
        Custo = Custo + (Hrec(IFaixa) / 100) * CBUQm3 + (H2CM / 100) * BGm3 + Ncamadas * Pintura + Imprimam2
    CASE "RECL"
        Custo = CamReciclm3 * Hfres(IFaixa) / 100
        H2CM = Hfres(IFaixa)
        IF Hrec(IFaixa) > 2.5 THEN
            GOSUB 5100
            Custo = Custo + (Hrec(IFaixa) / 100) * CBUQm3 + Ncamadas * Pintura
        ELSE
            Custo = Custo + (Hrec(IFaixa) / 100) * TSDm3
        END IF
    CASE ELSE
        PRINT "ERRO: medida nao identificada."
        PRINT Medida$
END SELECT
IF (Idade(IFaixa) < 0 OR Aream2(ISTH, IFaixa) <= 0) THEN
    Custo = 0
ELSE
    Custo = Custo + ABS(KMF - KMI) * CRkmAno / Aream2(ISTH, IFaixa)
END IF
SELECT CASE Medida$
    CASE "RS", "CP"
        IF RepFres < 0 THEN
            IF TR23(IFaixa) < 50 THEN
                RepPerct(IFaixa) = TR23(IFaixa)
            ELSE
                RepPerct(IFaixa) = 20
            END IF
        ELSE
            RepPerct(IFaixa) = RepFres
        END IF
        IF Nano(IFaixa) < 500000! THEN
            HCrepFres = 3
        ELSE
            IF Nano(IFaixa) < 1000000! THEN
                HCrepFres = 4
            ELSE
                HCrepFres = 5
            END IF
        END IF
        Custo = Custo + (RepPerct(IFaixa) / 100) * ((HCrepFres / 100) * CBUQm3 + Fresagemm3 * (HCrepFres / 100) + Pintura)
    CASE "RSUP+RC", "RSUP+CP"
        RepPerct(IFaixa) = 20
        IF Nano(IFaixa) < 500000! THEN
            HCrepFres = 3
        ELSE
            IF Nano(IFaixa) < 1000000! THEN
                HCrepFres = 4
            ELSE
                HCrepFres = 5
            END IF
        END IF
        Custo = Custo + (RepPerct(IFaixa) / 100) * ((HCrepFres / 100) * CBUQm3 + Fresagemm3 * (HCrepFres / 100) + Pintura)
    CASE ELSE
END SELECT
Custo = Custo * Aream2(ISTH, IFaixa)
RETURN

5100 '
' - - - - - - - - - - - - -
' -   Subrotina Auxiliar  -
' - - - - - - - - - - - - -
IF Hrec(IFaixa) <= 7.5 THEN
    Ncamadas = 1
ELSE
    IF Hrec(IFaixa) <= 15 THEN
        Ncamadas = 2
    ELSE
        Ncamadas = 3
    END IF
END IF
RETURN

1000 '
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -              Necessidades Atuais de Manutencao              -
' -                        (Subrotina)                          -
' -  Dados: PSI, H1, VR, QI, Age, NYEAR, VSMIN(IPP),            -
' -         Estado de Superficie, Parametros de decisao, HRDP,  -
' -         HRTR, H1TR, H2DP, HRQI, HRMPD                       -
' -  Saida: Medida$, HC, HR, DIAGNOSTICO$, H1NOVO, H2NOVO       -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Medida$ = ""
HC = 0!
DIAGNOSTICO$ = ""
H1NOVO = 0
H2NOVO = 0
' Deciso quanto  categoria de interveno requerida
IF MODO = 5 THEN VRMINrec = PPmin ELSE VRMINrec = .1
IF VR < VRMINrec THEN DIAGNOSTICO$ = "Pavimento deve ser restaurado devido a vida restante insuficiente."
IF PSI <= PSIt(IPSIT) THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Deve ser restaurado devido ao baixo Indice de Serventia."
IF ATRmed(IFaixa) >= ATRcrit THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Pavimento deve ser restaurado devido aos afundamentos em trilha de roda excessivos."
IF QI >= QIcrit THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Pavimento deve ser restaurado devido `a irregularidade elevada."
IF TR23 >= TRcrit THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Pavimento deve ser restaurado devido ao trincamento excessivo."
IF IGG(IFaixa) >= IGGcrit THEN DIAGNOSTICO$ = DIAGNOSTICO$ + "Pavimento deve ser restaurado devido ao IGG em nivel inaceitavel."

IF DIAGNOSTICO$ = "" THEN CATEGORIA$ = "CONSERVACAO" ELSE CATEGORIA$ = "RESTAURACAO"

IF CATEGORIA$ = "RESTAURACAO" THEN
    ' Espessura de recapeamento necessaria
    HR = HRMPD
    IRest = 0
    IF (ATRmed(IFaixa) >= ATRcrit OR ATR$ = "A3") THEN
        IF HRDP > HR THEN
            HR = HRDP
            IRest = 1
        END IF
    END IF
    IF HRTR > HR THEN
        HR = HRTR
        IRest = 2
    END IF
    IF HRQI > HR THEN
        HR = HRQI
        IRest = 3
    END IF
    IF HRatr > HR THEN IRest = 4
    SELECT CASE IRest
        CASE 0
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pela perda de serventia."
        CASE 1
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada por deformacoes plasticas."
        CASE 2
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pelo trincamento por fadiga."
        CASE 3
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pela reducao da irregularidade ao valor admissivel pos-restauracao."
        CASE 4
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pela eliminacao dos afundamentos em trilha de roda."
        CASE ELSE
            PRINT "ERRO: codigo invalido!"
    END SELECT
    IF H1 >= 6! THEN
        Fresavel$ = "Sim"
        HCMAX = H1 - 3
    ELSE
        Fresavel$ = "Nao"
    END IF
    IF (TR23 > 20 OR CR$ = "A2" OR CR$ = "A3" OR CR$ = "M3" OR BL$ = "A3" OR TT$ = "A3" OR TL$ = "A3") THEN
        ICRACK = 1
    ELSE
        ICRACK = 0
    END IF
    IF (ATRmed(IFaixa) > 15 OR COR$ = "A3" OR EM$ = "A3" OR DP$ = "A3" OR EL$ = "A3") THEN
        IDP = 1
    ELSE
        IDP = 0
    END IF
    IF HR < HRmin THEN HR = HRmin
END IF


' Detalhamento da Medida$ a ser aplicada
         
IF CATEGORIA$ = "CONSERVACAO" THEN

    IF UltCamada$(IFaixa) = "CCP" THEN

        IF PSR > 4! THEN
            Medida$ = "CR"
            DIAGNOSTICO$ = "Pavimento nao apresenta defeitos severos que requeiram intervencao imediata."
        ELSE
            Medida$ = "CL"
            DIAGNOSTICO$ = "Devem ser executados reparos em areas localizadas onde ha' problemas."
        END IF

    ELSE

        IF (D$ = "A3" OR DS$ = "A") THEN
            DIAGNOSTICO$ = "Deve ser aplicada capa selante devido ao desgaste e ou desagregacao superficial."
            IF VSCP >= VUMin THEN
                Medida$ = MedCP$
                HR = HRCP(IRodov)
                HC = 0!
            ELSE
                CATEGORIA$ = "RESTAURACAO"
                DIAGNOSTICO$ = "Nivel de deterioracao atual justifica aplicacao de Conserva Pesada, em carater corretivo e preventivo, mas a medida selecionada para CP nao devera ter durabilidade aceitavel."
            END IF
        ELSE
            IF TR23 > 10 THEN
                DIAGNOSTICO$ = "Deve ser aplicada capa selante devido `as trincas existentes."
                IF VSCP >= VUMin THEN
                    Medida$ = MedCP$
                    HR = HRCP(IRodov)
                    HC = 0!
                ELSE
                    Medida$ = "ST"
                    DIAGNOSTICO$ = "Nivel de deterioracao atual justifica aplicacao de Conserva Pesada, em carater corretivo e preventivo, mas a medida selecionada para CP nao deve ter durabilidade aceitavel."
                END IF
            ELSE
                IF (BL$ = "B3" OR BL$ = "M2" OR TT$ = "B3" OR TT$ = "M3" OR TL$ = "B3" OR TL$ = "M3") THEN
                    DIAGNOSTICO$ = "Deve ser feita selagem das trincas severas existentes."
                    Medida$ = "ST"
                ELSE
                    IF (DP$ = "B3" OR EL$ = "B3" OR CR$ = "B3" OR P$ = "B3" OR P$ = "B2" OR P$ = "B1") THEN
                        DIAGNOSTICO$ = "Devem ser executados reparos em areas localizadas onde ha' deterioracao severa."
                        Medida$ = "CL"
                    ELSE
                        IF (PSR < 4! OR IDS > 20) THEN
                            DIAGNOSTICO$ = "Devem ser executados reparos em areas localizadas onde ha' deterioracao severa."
                            Medida$ = "CL"
                        ELSE
                            DIAGNOSTICO$ = "Pavimento nao apresenta defeitos severos que requeiram intervencao imediata."
                            Medida$ = "CR"
                        END IF
                    END IF
                END IF
            END IF
        END IF

    END IF

END IF

IF CATEGORIA$ = "RESTAURACAO" THEN

    IF UltCamada$(IFaixa) = "CCP" THEN

        IF PSI < 1.5 THEN
            CATEGORIA$ = "RECONSTRUCAO"
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Pavimento deve ser reconstruido devido `a deterioracao de superficie severa."
            Medida$ = "RRT"
            H1NOVO = H1
            H2NOVO = 15
            HR = H1
            HC = H1NOVO + H2NOVO + 20
        ELSE
            CATEGORIA$ = "RESTAURACAO"
            HRreflex = 10
            IF HRMPD < HRreflex THEN
                HR = HRreflex
                DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pelo trincamento por reflexao."
            ELSE
                HR = HRMPD
                DIAGNOSTICO$ = DIAGNOSTICO$ + " Espessura de recapeamento e' condicionada pelo modelo de previsao de desempenho."
            END IF
            IF SART$ <> "RSUP20" THEN Medida$ = "MF+RC" ELSE Medida$ = "RSUP+RC"
            HC = 0
        END IF

    ELSE

        IF (PSI < PSRcrit AND HR > HRcrit) THEN

            CATEGORIA$ = "RECONSTRUCAO"
            DIAGNOSTICO$ = DIAGNOSTICO$ + " Pavimento deve ser reconstruido devido `a deterioracao de superficie severa e `as deficiencias estruturais."
            IF Age < 3 THEN
                DIAGNOSTICO$ = DIAGNOSTICO$ + " Causa da deterioracao prematura deve ser deficiencia de natureza construtiva."
            ELSE
                IF Age > 20 THEN
                    DIAGNOSTICO$ = DIAGNOSTICO$ + " A causa deve estar em ter o pavimento permanecido um longo tempo em condicao ruim."
                ELSE
                    IF HRDP > 7 THEN
                        DIAGNOSTICO$ = DIAGNOSTICO$ + " Deve haver deficiencia estrutural em termos de protecao contra deformacoes plasticas."
                    ELSE
                        IF HRTR > 7 THEN
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Deve haver deficiencia estrutural em termos de protecao do revestimento contra trincamento por fadiga."
                        ELSE
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " A causa da deterioracao excessiva deve ser pesquisada."
                        END IF
                    END IF
                END IF
            END IF
            IF (TE$ = "A3" OR DC$ = "A3" OR COR$ = "A3" OR EM$ = "A3") THEN
                IF BF$ = "A3" THEN
                    DIAGNOSTICO$ = DIAGNOSTICO$ + " Ha' problemas no revestimento, e a base foi deteriorada pela entrada de agua atraves das trincas."
                    Medida$ = "RRP"
                    H1NOVO = H1TR
                    H2NOVO = H2DP
                    HR = H1NOVO
                    HC = H1NOVO + H2NOVO
                ELSE
                    DIAGNOSTICO$ = DIAGNOSTICO$ + " Deterioracao deve estar confinada ao revestimento."
                    Medida$ = "RRV"
                    H1NOVO = H1TR
                    HR = H1NOVO
                    HC = H1NOVO
                END IF
            ELSE
                DIAGNOSTICO$ = DIAGNOSTICO$ + " Causa da deterioracao excessiva deve ser pesquisada nas camadas mais profundas do pavimento."
                Medida$ = "RRT"
                H1NOVO = H1TR
                H2NOVO = H2DP
                HR = H1NOVO
                HC = H1NOVO + H2NOVO + 20
            END IF

        ELSE

            CATEGORIA$ = "RESTAURACAO"
            IF IDP = 1 THEN
                IF Fresavel$ = "Sim" THEN
                    IF ICRACK = 0 THEN
                        Medida$ = "FR+RC"
                        IF HR > HCMAX THEN
                            HC = HCMAX
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Maxima espessura fresavel nao permite FR+RC sem elevacao de greide."
                        ELSE
                            HC = HR
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Maxima espessura fresavel permite FR+RC sem elevacao de greide."
                        END IF
                        IF HC < HCmin THEN HC = HCmin
                    ELSE
                        Medida$ = "FR+MF+RC"
                        IF HR + 2 > HCMAX THEN
                            HC = HCMAX
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Maxima espessura fresavel nao permite FR+RC sem elevacao de greide."
                        ELSE
                            HC = HR + 2
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Maxima espessura fresavel permite FR+RC sem elevacao de greide."
                        END IF
                        IF HC < HCmin THEN HC = HCmin
                    END IF
                ELSE
                    CATEGORIA$ = "RECONSTRUCAO"
                    DIAGNOSTICO$ = DIAGNOSTICO$ + " Pavimento deve ser parcialmente reconstruido devido `as deformacoes plasticas, sem possibilidade de fresagem."
                    Medida$ = "RRP"
                    H1NOVO = H1TR
                    H2NOVO = H2DP
                    HR = H1NOVO
                    HC = H1NOVO + H2NOVO
                END IF
            ELSE
                IF ICRACK = 1 THEN
                    IF Fresar$ = "Nao" THEN
                        IF SART$ <> "RSUP20" THEN Medida$ = "MF+RC" ELSE Medida$ = "RSUP+RC"
                        HC = 0
                        DIAGNOSTICO$ = DIAGNOSTICO$ + " Massa Fina e' recomendavel antes do recapeamento devido ao trincamento excessivo."
                    ELSE
                        IF Fresavel$ = "Sim" THEN
                            Medida$ = "FR+RC"
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Fresagem e' recomendavel devido ao trincamento excessivo do revestimento."
                            IF HR > HCMAX THEN
                                HC = HCMAX
                                DIAGNOSTICO$ = DIAGNOSTICO$ + " Maxima espessura fresavel nao permite FR+RC sem elevacao de greide."
                            ELSE
                                HC = HR
                            END IF
                            IF HC < HCmin THEN HC = HCmin
                        ELSE
                            IF SART$ <> "RSUP20" THEN Medida$ = "MF+RC" ELSE Medida$ = "RSUP+RC"
                            HC = 0
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Massa Fina e' recomendavel antes do recapeamento devido ao trincamento excessivo e por nao ser o revestimento fresavel."
                        END IF
                    END IF
                ELSE
                    HC = 0
                    DIAGNOSTICO$ = DIAGNOSTICO$ + " Nao ha' deterioracao severa que inviabilize o recapeamento simples em espessuras delgadas."
                    IF IRest = 4 THEN
                        IF HR = HRmin THEN
                            Medida$ = "RS"
                            IF HR < HRatr THEN HR = HRatr
                        ELSE
                            IF SART$ <> "RSUP20" THEN Medida$ = "MF+RC" ELSE Medida$ = "RSUP+RC"
                            DIAGNOSTICO$ = DIAGNOSTICO$ + " Reperfilagem foi indicada devido aos afundamentos em trilha de roda."
                        END IF
                    ELSE
                        IF VSCP >= VUMin THEN
                            Medida$ = MedCP$
                            HR = HRCP(IRodov)
                            HC = 0!
                        ELSE
                            Medida$ = "RS"
                        END IF
                    END IF
                END IF
            END IF

        END IF

    END IF

END IF

IF (Medida$ = "CR" OR Medida$ = "CL" OR Medida$ = "ST") THEN HR = 0

RETURN


1200 '
' - - - - - - - - - - - - - - - - - - - - - - - - -
' -       Necessidades de Reforco Estrutural      -
' -                  (Subrotina)                  -
' -  Dados: H1, HT, NYEAR, PP, DC, QI             -
' -  Saida: HRTR, H1TR, H2DP, HRMPD               -
' - - - - - - - - - - - - - - - - - - - - - - - - -
' Espessura de reforco efetiva existente
P = 4100 / (PI# * 30 * 30 / 4)
E = 2 * (1 - .33 * .33) * P * (30 / 2) / (Dc / 1000)
MR = E / .0703
A1 = .44
IF VR > 0 THEN
    PERIODO = VR
    GOSUB 6700
    SNP = A1 * .5 / 2.54
    HRmodel = 2.54 * SNP / A1
    NP = 0
    WHILE (NP < NPA AND HRmodel < HRmax)
        SNP = SNP + .05
        HRmodel = 2.54 * SNP / A1
        QIest = QI
        HR = HRmodel
        HC = 0
        GOSUB 6900
        QIx = QIest
        IC = 1
        GOSUB 1300
    WEND
    Heff(IFaixa) = HRmodel
ELSE
    Heff(IFaixa) = 0
END IF

' Espessura de reforco em CBUQ requerida pelo modelo de previsao de desempenho
PERIODO = PP
GOSUB 6700
SNP = A1 * .5 / 2.54
HRmodel = 2.54 * SNP / A1
NP = 0
WHILE (NP < NPA AND HRmodel < HRmax)
    SNP = SNP + .05
    HRmodel = 2.54 * SNP / A1
    QIest = QI
    HR = HRmodel
    HC = 0
    GOSUB 6900
    QIx = QIest
    IC = 2
    GOSUB 1300
WEND
HRMPD = HRmodel
IF HRMPD < 0 THEN HRMPD = 0
IF UltCamada$(IFaixa) = "CCP" THEN
    HRreflex = 1.364 * PP
    IF HRreflex > HRMPD THEN HRMPD = HRreflex
END IF

' Espessura minima de recapeamento para manter o QI abaixo do valor admissivel
HR = 0.4
HC = 0
QIf = QIcrit
MR = (2 * (1 - 0.35 * 0.35) * 5.6 * 15 / (D0(IFaixa) / 1000)) / 0.0703
DeltaT = 1
WHILE (QIf >= QIcrit AND HR < HRmax)
    HR = HR + .1
    QIest = QI
    GOSUB 6900
    PSI0ah = 5 * EXP(-QIest / 71.5)
    IF PSI0ah >= 4.99 THEN PSI0ah = 4.99
    IF PSI0ah > 2.5 THEN
        ' Modelo AASHTO-HDM para irregularidade
        SNP = CfRecapPSI * A1 * HR / 2.54
        BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
        DPSI = PSI0ah - 2.5
        W18# = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
        W18# = 10 ^ (-ZRmpd * S0mpd) * W18# * ((MR / 3000) ^ 2.32) / 1000000!
        ALFAah# = FcPavNovoPSIBS * (1 / W18#) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
        IF ALFAah# * NPA < 80 THEN
            PSIah# = 5 * ((PSI0ah / 5) ^ EXP(ALFAah# * NPA))
            QIf = 71.5 * LOG(5 / PSIah#)
        END IF
    END IF
WEND
IF HRMPD < HR THEN HRMPD = HR

' Espessura minima de recapeamento para manter o IGG abaixo do valor admissivel
HR = 0.4
HC = 0
IGGf = IGGcrit
DeltaT = 1
WHILE (IGGf >= IGGcrit AND HR < HRmax)
    HR = HR + .1
    ' Modelo AASHTO-HDM para IGG
    SCI0 = 4.97
    PCR4 = 5
    TYcr2A = 2.54 * EXP(.0157 * HR * 10 - .0141 * PCR4)
    Dc = D0(IFaixa) * (10 ^ (-HR / 40))
    TYcr2B = 10.8 * EXP(-1.21 * (Dc / 100) - 1.02 * (Nano(IFaixa) / 1000000!) * (Dc / 100))
    TYcr2 = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
    ALFAah# = (10 ^ (ZRmpd * S0mpd)) * LOG(10.676 / TYcr2) / (1.222E-6 * Nano(IFaixa))
    IF ALFAah# * NPA < 80 THEN
        SCI# = 5 * ((SCI0 / 5) ^ EXP(ALFAah# * NPA))
        IGGf = (309.22 - 61.844 * SCI#) / (SCI# + 0.616)
    END IF
WEND
IF HRMPD < HR THEN HRMPD = HR

' Revestimento requerido pelo Metodo do DNER
NPUSACE = 3 * NPA
H1TR = 4.4608 + 2.131 * LOG(NPUSACE)
IF H1TR < HRmin THEN H1TR = HRmin
HRTR = H1TR - H1
IF HRTR < 0 THEN HRTR = 0
' Camada de Base pelo modelo de previsao de desempenho
SNP = .5
NP = 0
WHILE (NP < NPA AND SNP < 12)
    SNP = SNP + .05
    IC = 3
    QIx = 15
    GOSUB 1300
WEND
H2DP = (2.54 * SNP - .44 * H1TR) / .14
IF H2DP < 12 THEN H2DP = 12

' Espessura de recapeamento requerida para eliminar ATR
ATRadm = 1
IF ATRmed(IFaixa) > ATRadm THEN
    Nrecaps = LOG(ATRadm / ATRmed(IFaixa)) / LOG(.15)
    IF Nrecaps < 1 THEN
        NR = 1
    ELSE
        NR = Nrecaps - INT(Nrecaps)
        IF NR > .2 THEN NR = INT(Nrecaps) + 1 ELSE NR = INT(Nrecaps)
    END IF
ELSE
    NR = 0
END IF
HRatr = NR * HRmin
HRdeflex = 0

RETURN


1300 '
' - - - - - - - - - - - -
' -  Subrotina Auxiliar -
' - - - - - - - - - - - -
PSIQI = 5 * EXP(-QIx / 71.5)
PSR = 5
PSI0 = (PSIQI + PSR) / 2
IF PSI0 > 4.95 THEN PSI0 = 4.95
DPSI = PSI0 - 2.5
IF DPSI > 0 THEN
    BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
    W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
    W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
    ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
    IF IC = 3 THEN
        LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
        SNC = SNP + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
        TYcr2 = 4.21 * EXP(.139 * SNC - 17.1 * ((Nano(IFaixa) / 1000000!) / (SNC ^ 2)))
        FC0 = FC0novo
    ELSE
        Hrec = 2.54 * SNP / .44
        PCR4 = 5
        TYcr2A = 2.54 * EXP(.0157 * Hrec * 10 - .0141 * PCR4)
        TYcr2B = 10.8 * EXP(-1.21 * (Dc / 100) - 1.02 * (Nano(IFaixa) / 1000000!) * (Dc / 100))
        TYcr2 = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
        IF IC = 1 THEN FC0 = ALPHA0(IFaixa) ELSE FC0 = FC0recap
    END IF
    Nf = TYcr2 * FC0 * Nano(IFaixa) / 1000000!
    PSIx = PSI0
    DeltaT = .1
    DeltaN = DeltaT * Nano(IFaixa) / 1000000!
    NP = 0
    WHILE PSIx > PSIf
        NP = NP + DeltaN
        SELECT CASE IC
            CASE 1
                IF Restaurado$(IFaixa) = "Sim" THEN
                    IF NP < Nf THEN
                        FC = FCrecap
                    ELSE
                        FC = FC2recap
                    END IF
                ELSE
                    IF IRec(IFaixa) = 1 THEN
                        IF ICalib(IFaixa) = 1 THEN
                            IF NP < Nf THEN
                                FC = ALPHA(IFaixa)
                            ELSE
                                FC = ALPHA2(IFaixa)
                            END IF
                        ELSE
                            IF NP < Nf THEN
                                FC = FCrecaprede(IRodov)
                            ELSE
                                FC = FC2recaprede(IRodov)
                            END IF
                        END IF
                    ELSE
                        IF NP < Nf THEN
                            FC = FCrecaprede(IRodov)
                        ELSE
                            FC = FC2recaprede(IRodov)
                        END IF
                    END IF
                END IF
            CASE 2
                IF NP < Nf THEN
                    FC = FCrecap
                ELSE
                    FC = FC2recap
                END IF
            CASE 3
                IF NP < Nf THEN
                    FC = FCnovo
                ELSE
                    FC = FC2novo
                END IF
            CASE ELSE
                PRINT "ERRO"
        END SELECT
        ALFA = ALFAA * FC
        DeltaPSI = (ALFA / 10 ^ (-ZRmpd * S0mpd)) * DeltaN * PSIx * LOG(PSIx / 5)
        VRmax = 64.43 * (5 ^ -.76) * ((HRmodel / 2.54) ^ .37)
        VRmin = 64.43 * (25 ^ -.76) * ((HRmodel / 2.54) ^ .37)
        dPSIdtmin = 2! / VRmax
        dPSIdtmax = 2! / VRmin
        DPSImin = dPSIdtmin * DeltaT
        DPSImax = dPSIdtmax * DeltaT
        IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
        IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
        PSIx = PSIx + DeltaPSI
    WEND
END IF
RETURN


2000 '
' - - - - - - - - - - - - - - - - - -
' -  INTERVENCAO NOS ACOSTAMENTOS   -
' -           (Subrotina)           -
' - - - - - - - - - - - - - - - - - -
SELECT CASE MedidaAcost$(IFaixa)
    CASE "CR"
        Custo = 0
    CASE "CL", "ST"
        PerctReparos = 100 * EXP(-2.3026 * PSIacost(IFaixa))
        Custo = (.5 * CLm2) * PerctReparos / 100
    CASE "CP"
        Custo = MICROCA12m2
    CASE "TSS"
        Custo = TSSm2
    CASE "TSD"
        Custo = TSDm2
    CASE "PMF"
        Custo = (HRAC(IFaixa) / 100) * PMFm3 + Pintura
    CASE "CBUQ", "RS", "RSUP+RC"
        Custo = (HRAC(IFaixa) / 100) * CBUQm3 + Pintura
    CASE "RRP", "RRT"
        Custo = (Remocao * H2AC(IFaixa) / 100) + TSDm2 + (H2AC(IFaixa) / 100) * BaseAcostm3 + Imprimam2
    CASE "RECL"
        Custo = (CamReciclm3 * H2AC(IFaixa) / 100) + TSDm2 + Imprimam2
    CASE "FR+CP", "MF+CP", "FR+MF+CP", "RSUP+CP"
        SELECT CASE CamadaRest$(IRodov)
            CASE "Lama Asfaltica Delgada": Custo = LamaD
            CASE "Lama Asfaltica Media": Custo = LamaM
            CASE "Lama Asfaltica Grossa": Custo = LamaG
            CASE "Micro-CA Delgado": Custo = MICROCA4m2
            CASE "Micro-CA Normal": Custo = MICROCA7m2
            CASE "Micro-CA Espesso": Custo = MICROCA12m2
            CASE "TSD": Custo = TSDm3 * (HRAC(IFaixa) / 100)
            CASE "TST": Custo = TSTm3 * (HRAC(IFaixa) / 100)
            CASE "TSD com Polimero (18 mm)": Custo = TSDpolm3 * (HRAC(IFaixa) / 100)
            CASE "Cape Seal (TSS+Micro)": Custo = CapeSealm3 * (HRAC(IFaixa) / 100)
            CASE ELSE
                PRINT "ERRO: tipo nao identificado ==> "; CamadaRest$(IRodov)
                B$ = "": WHILE B$ = "": B$ = INKEY$: WEND
        END SELECT
        Custo = Custo + Fresagemm3 * (H2AC(IFaixa) / 100)
        IF (Medida$ = "MF+CP" OR Medida$ = "FR+MF+CP") THEN Custo = Custo + Pintura + Reperf * (HRMF / 2)
    CASE "MF+RC"
        GOSUB 5100
        Custo = (HRAC(IFaixa) / 100) * CBUQm3 + (Ncamadas + 1) * Pintura + Reperf * (HRMF / 2)
    CASE "FR+RC", "RRV", "FR+MF+RC"
        GOSUB 5100
        Custo = (HRAC(IFaixa) / 100) * CBUQm3 + Fresagemm3 * (H2AC(IFaixa) / 100) + Ncamadas * Pintura + Reperf * (HRMF / 2)
    CASE ELSE
        PRINT "ERRO: Medida desconhecida no acostamento = "; MedidaAcost$(IFaixa); " na faixa "; IFaixa
END SELECT
RETURN


3000 '
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -      Evolucao da Condicao do Pavimento apos um Ano    -
' -                      (Subrotina)                      -
' -  Dados: H1REV, SN, Nacum, CBRSL, PSI, IRI0(IFaixa),   -
' -         ALPHA(IFaixa), Nano, QImed, HRef(IFaixa),     -
' -         IRec(IFaixa), ATRmed, TR23                    -
' -  Saida: PSI, QImed, IGG, TR23, ATRmed                 -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
IF PSI <= 4.5 THEN
    IGG(IFaixa) = ALFAIGG(IFaixa) * ((((4.5 / PSI) - 1) / .007635) ^ (1 / 1.065))
    IF IGG(IFaixa) > 500 THEN IGG(IFaixa) = 500
ELSE
    IGG(IFaixa) = 0
END IF
PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
PSR = 2 * PSI - PSIQI
IF UltCamada$(IFaixa) = "CCP" THEN
    IGGat = (309.22 - 61.844 * PSR) / (PSR + 0.616)
    ' Dados
    Epsi = 100 * CBRSL(IFaixa) / 0.0703
    K = Epsi / 19.4
    RTF = 640
    Dcm = H1REV(IFaixa)
    D = Dcm / 2.54
    PT = 2.5
    J = 3.2
    CD = 1
    PSI0 = 4.5
    ' Correlacoes
    RTFMPA = RTF * .0703 / 10
    RCS = 10 * ((RTFMPA / .56) ^ 1.67)
    EC = 15110 * (RCS ^ .5)
    EC = EC / .0703
    ' Parametros complementares
    DPSI = PSI0 - PT
    ZR = ZRmpd
    S0 = S0mpd
    ' Modelo
    W18# = 215.63 * J * ((D ^ .75) - (18.42 / ((EC / K) ^ .25)))
    W18# = (4.22 - .32 * PT) * LOG(RTF * CD * ((D ^ .75) - 1.132) / W18#) / LOG(10)
    A# = (LOG(DPSI / (4.5 - 1.5)) / LOG(10)) / (1 + (1.624E+07 / ((D + 1) ^ 8.46)))
    W18# = W18# + A# - .06 + 7.35 * (LOG(D + 1) / LOG(10)) + ZR * S0
    W18# = (10 ^ W18#) / 1.E6
    ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSI0 / 5))
    FcCCP = 0.3
    ALFA = FcCCP * ALFAA
    Nyear = Nano(IFaixa) / 1000000!
    DeltaN = Nyear
    DeltaPSI = ALFA * DeltaN * PSI * LOG(PSI / 5)
    IF PSI < -1 * DeltaPSI THEN DeltaPSI = -PSI
    DeltaQI = (-71.5 / ((PSI + PSI + DeltaPSI) / 2)) * DeltaPSI
    QImed(IFaixa) = QImed(IFaixa) + DeltaQI
    PSI = PSI + DeltaPSI
    IF PSI < .5 THEN PSI = .5
    ' Evolucao do IGG e do PSR
    PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
    PSRat = 2 * PSI - PSIQI
    IF PSRat < 1.0 THEN PSRat = 1.0
    'DeltaPSR = PSRat - PSR
    'DeltaIGG = DeltaPSR * (-61.844 - IGG(IFaixa)) / (.616 + PSR)
    'IGG(IFaixa) = IGG(IFaixa) + DeltaIGG
    IGG(IFaixa) = (309.22 - 61.844 * PSRat) / (PSRat + 0.616)
    IF IGG(IFaixa) > 450 THEN IGG(IFaixa) = 450
    DeltaIGG = IGG(IFaixa) - IGGat
    DeltaTR = DeltaIGG * (5 / 30)
    TR23(IFaixa) = TR23(IFaixa) + DeltaTR
    IF TR23(IFaixa) > 100 THEN TR23(IFaixa) = 100
    ATRmed(IFaixa) = 0
ELSE
    TRmin = 10
    DeltaT = .1
    Nyear = Nano(IFaixa) / 1000000!
    DeltaN = DeltaT * Nyear
    PT = 2.5
    DPSI = PSInovo(IFaixa) - PT
    NE4 = Nacum(IFaixa) / 1000000!
    Nac = Nacum(IFaixa)
    TTIME = Idade(IFaixa)
    IF (Idade(IFaixa) > 20 AND ATRmed(IFaixa) > 12) THEN COMP = .7 ELSE COMP = 1
    LCBR = LOG(CBRSL(IFaixa)) / LOG(10)
    SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
    FOR II = 1 TO 10
        ' Evolucao do PSI
        Nac = Idade(IFaixa) * Nano(IFaixa)
        Nf = T0(IFaixa) * ALPHA0(IFaixa) * Nano(IFaixa)
        IF TR23(IFaixa) < TRmin THEN
            ALFA = ALPHA(IFaixa)
        ELSE
            ALFA = ALPHA2(IFaixa)
        END IF
        IF IRec(IFaixa) = 0 THEN
            FcIRImed = 1: SigmaIRI = .48
            MR = 100 * CBRSL(IFaixa) / .0703
            VRmax = 25
            VRmin = 5
            SNx = SN(IFaixa)
            GOSUB 3050
        ELSE
            FcIRImed = 1.883: SigmaIRI = 1.905
            IF UltCamada$(IFaixa) = "CBUQ" THEN
                VRmax = 64.43 * (5 ^ -.76) * ((HrecExist(IFaixa) / 2.54) ^ .37)
                VRmin = 64.43 * (25 ^ -.76) * ((HrecExist(IFaixa) / 2.54) ^ .37)
                SNrecap = .44 * HRef(IFaixa) / 2.54
                MR = MRfound(IFaixa) / .0703
                SNx = SNrecap
                GOSUB 3050
            ELSE
                VRmax = 10
                VRmin = 2
                DeltaPSI = -A1rest(IRodov) * DeltaN / EXP((A0rest(IRodov) + A2rest(IRodov) * SN(IFaixa) - (PSI + NpsiMod * SErest(IRodov))) / A1rest(IRodov))
            END IF
        END IF
        dPSIdtmin = 2! / VRmax
        dPSIdtmax = 2! / VRmin
        DPSImin = dPSIdtmin * DeltaT
        DPSImax = dPSIdtmax * DeltaT
        IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
        IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
        PSI = PSI + DeltaPSI
        IF PSI < .5 THEN PSI = .5
        ' - - - - - - - - - - - - - - - - - - - - -
        ' - Modelo AASHTO-HDM para irregularidade -
        ' - - - - - - - - - - - - - - - - - - - - -
        IF DEFPSI = 0 THEN
            PSI0ah = 2 * PSInovo(IFaixa) - 5
            IF PSI0ah < 2.55 THEN PSI0ah = 2.55
        ELSE
            PSI0ah = PSInovo(IFaixa)
        END IF
        DPSI = PSI0ah - 2.5
        IF DPSI <= 0.5 THEN DPSI = 0.5
        PSIah = 5 * EXP(-QImed(IFaixa) / 71.5)
        IF PSIah < 0.5 THEN PSIah = 0.5
        IF IRec(IFaixa) = 0 THEN
            ' Analise do subleito
            MR = 100 * CBRSL(IFaixa) / .0703
            SNP = SN(IFaixa)
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAah = FcPavNovoPSISL * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
            DeltaPSI = ALFAah * DeltaT * Nyear * PSIah * LOG(PSIah / 5)
            DeltaQI = (-71.5 / PSIah) * DeltaPSI
            IF DeltaQI > 2 THEN DeltaQI = 2
            QImed(IFaixa) = QImed(IFaixa) + DeltaQI
        ELSE
            IF HrecExist(IFaixa) < 3 THEN
                ' Modelo do HDM-III para irregularidade em caso de CP
                NE4 = NE4 + DeltaT * Nyear
                TTIME = TTIME + DeltaT
                'IRI = (IRI0 + 725 * ((1 + SNC) ^ -4.99) * NE4) * EXP(.0153 * TTIME)
                FcIRI = FcIRImed + Niri * SigmaIRI
                DeltaIRI = (.0153 * (QImed(IFaixa) / 13) + 725 * FcIRI * ((1 + SNC) ^ -4.99) * Nyear * EXP(.0153 * TTIME)) * DeltaT
                QImed(IFaixa) = QImed(IFaixa) + 13 * DeltaIRI
            ELSE
                MR = MRfound(IFaixa) / .0703
                SNP = CfRecapPSI * 0.44 * HrecExist(IFaixa) / 2.54
                BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
                ALFAah = FcPavNovoPSIBS * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
                DeltaPSI = ALFAah * DeltaT * Nyear * PSIah * LOG(PSIah / 5)
                DeltaQI = (-71.5 / PSIah) * DeltaPSI
                IF DeltaQI > 2 THEN DeltaQI = 2
                QImed(IFaixa) = QImed(IFaixa) + DeltaQI
            END IF
        END IF
        ' - - - - - - - - - - - - - - -
        ' -  Evolucao do IGG e do PSR -
        ' - - - - - - - - - - - - - - -
        SCI = (309.22 - .616 * IGG(IFaixa)) / (61.844 + IGG(IFaixa))
        SCI0 = 4.97
        DPSI = SCI0 - 2.5
        IF IRec(IFaixa) = 0 THEN
            ' Analise do subleito
            MR = 100 * CBRSL(IFaixa) / .0703
            SNP = SN(IFaixa)
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAah = FcPavNovoSCISL * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(SCI0 / 5))
            ' Analise da camada de base
            SELECT CASE CamBase$(IFaixa)
                CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP", "SC", "CCR"
                CASE "MB", "PMF", "PMQ", "CBUQ", "CBUQ+PMQ", "CBUQ+PMF"
                CASE ELSE
                    CBRbase = 80
                    MR = 20 * CBRbase / .0703
                    SNP = 0.44 * H1REV(IFaixa) / 2.54
                    BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                    W18 = (((SNP + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                    W18 = 10 ^ (-ZRmpd * S0mpd) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
                    ALFAahbs = FcPavNovoSCIBS * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(SCI0 / 5))
                    IF ALFAahbs > ALFAah THEN ALFAah = ALFAahbs
            END SELECT
        ELSE
            ALFAah = (10 ^ (ZRmpd * S0mpd)) * LOG(10.676 / T0(IFaixa)) / (1.222E-6 * Nano(IFaixa))
        END IF
        DeltaSCI = ALFAah * DeltaT * Nyear * SCI * LOG(SCI / 5)
        DeltaIGG = DeltaSCI * (-61.844 - IGG(IFaixa)) / (.616 + SCI)
        IGG(IFaixa) = IGG(IFaixa) + DeltaIGG
        IF IGG(IFaixa) > 350 THEN IGG(IFaixa) = 350
        PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
        PSRat = 2 * PSI - PSIQI
        IF PSRat < 1.5 THEN PSRat = 1.5
        DeltaPSR = PSRat - PSR
        PSR = PSRat
        Nac = Nac + DeltaT * Nano(IFaixa)
        TR = TR23(IFaixa)
        ATR = ATRmed(IFaixa)
        GOSUB 3100
        TR23(IFaixa) = TR
        ATRmed(IFaixa) = ATR
    NEXT II
END IF
RETURN

3050 '
BETA = .4 + (1094 / ((SNx + 1) ^ 5.19))
W18# = (((SNx + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo(IFaixa) / 5))
DeltaPSI = (ALFA / 10 ^ (-ZRmpd * S0mpd)) * ALFAA * DeltaN * PSI * LOG(PSI / 5)
RETURN

3100 '
' Evolucao do trincamento severo
IF IRec(IFaixa) = 0 THEN
    RH = 0
    FcATRmed = 1.3492: SigmaATR = .5612
    SELECT CASE CamBase$(IFaixa)
        CASE "BGTC", "SOLO-CIMENTO", "SOLO-CAL", "CCP", "SC", "CCR"
            V1 = 8.7: V2 = 12.5
        CASE ELSE
            V1 = 6.3: V2 = 8.7
    END SELECT
ELSE
    RH = 1
    IF UltCamada$(IFaixa) = "CBUQ" THEN
        V1 = 5: V2 = 7.6
        FcATRmed = 1.2464: SigmaATR = .8204
    ELSE
        V1 = 5 / T0(IFaixa)
        IF V1 < 5 THEN V1 = 5
        V2 = (31 / 10.2) * V1
        FcATRmed = 1.8168: SigmaATR = .8717
    END IF
END IF
IF TTIME <= T0(IFaixa) THEN
    dTRdt = 0
ELSE
    IF TR > 0 THEN
        IF TR > 30 THEN dTRdt = V2 ELSE dTRdt = V1
    ELSE
        dTRdt = V1
    END IF
END IF
TR = TR + dTRdt * DeltaT
IF TR > 100 THEN TR = 100
' Evolucao dos afundamentos em trilha de roda
MMP = .123
FcATR = FcATRmed + Ngauss * SigmaATR
ERM = .0902 + .0384 * (D0(IFaixa) / 100) - .009 * RH + .00158 * MMP * TR
dATR = (.166 * FcATR * (COMP ^ -2.3) * (TTIME ^ (.166 - 1)) * (SNC ^ -.502) * (Nac ^ ERM) + ERM * ATR * (Nyear / NE4)) * DeltaT
ATR = ATR + dATR
RETURN


8000 '
' - - - - - - - - - - - - - - - - - - - - - - -
' -  Compatibilizacao Geometrica de Solucoes  -
' -          entre Faixas de Trafego          -
' -                (Subrotina)                -
' - - - - - - - - - - - - - - - - - - - - - - -
CotaMax = 0
FaixaMax = 2
FOR IFaixa = 1 TO NFaixas(ISTH)
    GOSUB 8700
    CotaFaixa(IFaixa) = Cota
    IF CotaFaixa(IFaixa) > CotaMax THEN
        CotaMax = CotaFaixa(IFaixa)
        FaixaMax = IFaixa
    END IF
NEXT IFaixa
Compat$ = "Nao"
FOR IFaixa = 1 TO NFaixas(ISTH)
    IF CotaFaixa(IFaixa) < CotaMax THEN Compat$ = "Sim"
NEXT IFaixa
IF Compat$ = "Nao" THEN 8100
' Tenta compatibilizar a faixa de maxima elevacao de greide com as demais
FOR IFaixa = 1 TO NFaixas(ISTH)
    Delta = CotaMax - CotaFaixa(IFaixa)
    IF Delta > 0.3 THEN
        SELECT CASE MedidaF$(FaixaMax)
            CASE "RS", "FR+RC", "MF+RC", "RSUP+RC", "FR+MF+RC"
                DeltaL = Delta - (HRmin - HRCP(IRodov))
                SELECT CASE MedidaF$(IFaixa)
                    CASE "CR", "CL", "ST"
                        IF Delta >= HRmin THEN
                            MedidaF$(IFaixa) = "RS"
                            Hfres(IFaixa) = 0
                            Hrec(IFaixa) = Delta
                        ELSE
                            MedidaF$(IFaixa) = "FR+RC"
                            Hfres(IFaixa) = HRmin - Delta
                            Hrec(IFaixa) = HRmin
                            IF Hfres(IFaixa) < HCmin THEN
                                MedidaF$(IFaixa) = "RS"
                                Hfres(IFaixa) = 0
                            END IF
                        END IF
                    CASE "CP", "RSUP+CP"
                        IF DeltaL >= 0 THEN
                            MedidaF$(IFaixa) = "RS"
                            Hfres(IFaixa) = 0
                            Hrec(IFaixa) = DeltaL + HRmin
                        ELSE
                            MedidaF$(IFaixa) = "FR+RC"
                            Hfres(IFaixa) = -DeltaL
                            Hrec(IFaixa) = HRmin
                            IF Hfres(IFaixa) < HCmin THEN
                                MedidaF$(IFaixa) = "RS"
                                Hfres(IFaixa) = 0
                            END IF
                        END IF
                    CASE "FR+CP"
                        MedidaF$(IFaixa) = "FR+RC"
                        Hrec(IFaixa) = HRmin
                        IF DeltaL >= 0 THEN
                            HFx = Hrec(IFaixa) + DeltaL
                            IF HFx <= HRmax THEN
                                Hrec(IFaixa) = HFx
                                IF Hfres(IFaixa) < HCmin THEN
                                    MedidaF$(IFaixa) = "RS"
                                    Hfres(IFaixa) = 0
                                END IF
                            ELSE
                                Hfres(IFaixa) = Hfres(FaixaMax)
                                Hrec(IFaixa) = Hrec(FaixaMax)
                                MedidaF$(IFaixa) = MedidaF$(FaixaMax)
                            END IF
                        ELSE
                            Hfres(IFaixa) = Hfres(IFaixa) - DeltaL
                            IF Hfres(IFaixa) < HCmin THEN
                                MedidaF$(IFaixa) = "RS"
                                Hfres(IFaixa) = 0
                            END IF
                        END IF
                    CASE "MF+CP", "FR+MF+CP"
                        IF DeltaL >= 0 THEN
                            MedidaF$(IFaixa) = "MF+RC"
                            Hrec(IFaixa) = HRmin + DeltaL
                        ELSE
                            MedidaF$(IFaixa) = "RS"
                            Hrec(IFaixa) = Delta + HRCP(IRodov) + 2
                        END IF
                    CASE "RS", "MF+RC", "FR+RC", "RSUP+RC", "FR+MF+RC"
                        Hrec(IFaixa) = Hrec(IFaixa) + Delta
                    CASE "RRV", "RRP", "RRT"

                    CASE ELSE
                        PRINT "ERRO: medida nao identificada = "; MedidaF$(IFaixa)
                END SELECT
            CASE "CP", "FR+CP", "MF+CP", "RSUP+CP", "FR+MF+CP"
                MedidaF$(IFaixa) = MedidaF$(FaixaMax)
                Hrec(IFaixa) = Hrec(FaixaMax)
                Hfres(IFaixa) = Hfres(FaixaMax)
            CASE ELSE
                PRINT "ERRO. Medida desconhecida: "; MedidaF$(FaixaMax)
        END SELECT
    END IF
NEXT IFaixa
8100 ' Solucao para os Acostamentos, apos a compatibilizacao da pista
CotaMax = 0
FOR IFaixa = 1 TO NFaixas(ISTH)
    GOSUB 8700
    CotaFaixa(IFaixa) = Cota
    IF CotaFaixa(IFaixa) > CotaMax THEN CotaMax = CotaFaixa(IFaixa)
NEXT IFaixa
FOR IFaixa = 1 TO NFaixas(ISTH)
    IF (PISTA$ = "DUPLA" AND IFaixa = 1) THEN
        MedidaAcost$(IFaixa) = MedidaF$(IFaixa)
        HRAC(IFaixa) = Hrec(IFaixa)
        H2AC(IFaixa) = Hfres(IFaixa)
    ELSE
        IF DegrauAcost(IFaixa) >= 0 THEN HRACOST = CotaMax + DegrauAcost(IFaixa) ELSE HRACOST = CotaMax
        IF HRACOST <= DEGRAUadm THEN
            HRAC(IFaixa) = 0
            IF PSIacost(IFaixa) >= 3.5 THEN MedidaAcost$(IFaixa) = "CR" ELSE MedidaAcost$(IFaixa) = "CL"
        ELSE
            IF HRACOST <= (DEGRAUadm + 1.2) THEN
                HRAC(IFaixa) = 1.2
                IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN MedidaAcost$(IFaixa) = "TSS" ELSE MedidaAcost$(IFaixa) = "CP"
            ELSE
                IF HRACOST <= (DEGRAUadm + 2!) THEN
                    HRAC(IFaixa) = 2!
                    IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN MedidaAcost$(IFaixa) = "TSD" ELSE MedidaAcost$(IFaixa) = "CBUQ"
                ELSE
                    IF HRACOST <= (DEGRAUadm + 7!) THEN
                        IF PSIacost(IFaixa) >= 2! THEN
                            IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN MedidaAcost$(IFaixa) = "PMF" ELSE MedidaAcost$(IFaixa) = "CBUQ"
                            HRAC(IFaixa) = HRACOST - DEGRAUadm
                        ELSE
                            MedidaAcost$(IFaixa) = "RRP"
                            H2AC(IFaixa) = HbaseAcost
                            IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN HRAC(IFaixa) = 2.5 ELSE HRAC(IFaixa) = 4
                        END IF
                    ELSE
                        MedidaAcost$(IFaixa) = "RRT"
                        H2AC(IFaixa) = (HRACOST - DEGRAUadm) - HRAC(IFaixa)
                        IF H2AC(IFaixa) < 12 THEN H2AC(IFaixa) = 12
                        IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN HRAC(IFaixa) = 2.5 ELSE HRAC(IFaixa) = 4
                    END IF
                END IF
            END IF
        END IF
        IF PSIacost(IFaixa) = -1 THEN
            MedidaAcost$(IFaixa) = "CR"
            HRAC(IFaixa) = 0
            H2AC(IFaixa) = 0
        END IF
    END IF
NEXT IFaixa
RETURN

8700 '
' - - - - - - - - - - - - - - - - - - - - - -
' -   Compatibilizacao Geometrica (cont.)   -
' -               (Subrotina)               -
' - - - - - - - - - - - - - - - - - - - - - -
SELECT CASE MedidaF$(IFaixa)
    CASE "RS", "CP", "RSUP+RC", "RSUP+CP"
        Cota = Hrec(IFaixa)
    CASE "FR+RC", "FR+CP"
        Cota = Hrec(IFaixa) - Hfres(IFaixa)
        IF Cota < 0 THEN Cota = 0
    CASE "MF+RC", "MF+CP", "FR+MF+RC", "FR+MF+CP"
        Cota = Hrec(IFaixa) + HRMF
    CASE ELSE
        Cota = 0
END SELECT
RETURN


6700 '
' - - - - - - - - - - - - -
' -   Trafego de Projeto  -
' -      (Subrotina)      -
' - - - - - - - - - - - - -
NPA = 0
IF PERIODO < 1 THEN PERIODO = 1
PER = INT(PERIODO)
FOR IAA = 1 TO PER
    NPA = NPA + (FatorTraf ^ IAA)
NEXT IAA
NPA = NPA * Nyear / 1000000!
RETURN


6900 '
' - - - - - - - - - - - - - - - - - - - -
' -   Irregularidade apos Recapeamento  -
' -        (Subrotina do HDM-III)       -
' -   Dados: HR, HC, QIest, QI0adm      -
' -   Saida: QIest                      -
' - - - - - - - - - - - - - - - - - - - -
IF QIest > 19 THEN
    QIB = 19! + ((QIest - 19!) / (.602 * HC + 1))
ELSE
    QIB = QIest
END IF
IF QI0adm > 0 THEN
    DQI = QI0adm - QIB
ELSE
    H0 = 10 * HR
    IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
    IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
    IF H0 < 40 THEN X = H0 ELSE X = 40
    HOV = 3 - ((H0L + X) / 40)
    X1 = 19.42 - .78 * QIBL - .068 * H0
    IF H0 > 20 THEN y = H0 - 20 ELSE y = 0
    X2 = -19.5 - .008 * QIBL * y
    IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
    IF DQI > 0 THEN DQI = 0
END IF
QIest = QIB + DQI
RETURN


