CLS

   ' Subdiretorios onde se encontram o programa SGP e a base de dados:
     OPEN "DIRETOR.DAT" FOR INPUT AS #1
          INPUT #1, ANOBASE
          INPUT #1, NPeriodos
          INPUT #1, PROGRAMA$
          INPUT #1, DADOS$
          INPUT #1, CALC$
     CLOSE #1

   ' Codigos de identificacao das rodovias que compoem a rede:
     ARQUIVO$ = DADOS$ + "RODOVIAS.DAT"
     OPEN ARQUIVO$ FOR INPUT AS #1
          INPUT #1, NRODOV
          DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
          FOR I = 1 TO NRODOV
              INPUT #1, Rodov$(I)
          NEXT I
     CLOSE #1

   ' Vetores e Matrizes associados `as faixas de trafego:
     NFaixasMax = 4: NPolos = NRODOV
     DIM CustoP(NPolos), ConserP(NPolos), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
     DIM REVEST$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
     DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
     DIM HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax)
     DIM FCnovorede(NRODOV), FCrecaprede(NRODOV), FCccprede(NRODOV)
     DIM ICalib(NFaixasMax), D0(NFaixasMax), MRfound(NFaixasMax)
     DIM PSIacost(NFaixasMax), DegrauAcost(NFaixasMax), MedidaAcost$(NFaixasMax)
     DIM HRAC(NFaixasMax), H2AC(NFaixasMax), CustoAcost(NFaixasMax)
     DIM HbaseAcost(NRODOV), CTotal(NPolos)
     DIM MatCP$(NRODOV), HRCP(NRODOV), CamadaRest$(NRODOV)
     DIM A0rest(NRODOV), PSR0rest(NRODOV), B0rest(NRODOV)

   ' Numero de Subtrechos Homogeneos por rodovia e
   ' numero total de Subtrechos Homogeneos da rede
     NSTH = 0
     ARQUIVO$ = CALC$ + "NSTHROD.OUT"
     OPEN ARQUIVO$ FOR INPUT AS #1
     INPUT #1, NSTHMAX
     FOR I = 1 TO NRODOV
         INPUT #1, NSTHRODOV(I)
         NSTH = NSTH + NSTHRODOV(I)
     NEXT I
     CLOSE #1

   ' Leitura dos codigos numericos que identificam os Subtrechos Homogeneos:
     DIM Code(NRODOV, NSTHMAX), NSTHI(NRODOV)
     FOR I = 1 TO NRODOV
         ARQUIVO$ = CALC$ + "CODE" + Rodov$(I) + ".STH"
         OPEN ARQUIVO$ FOR INPUT AS #1
         INPUT #1, NSTHI(I)
         FOR J = 1 TO NSTHI(I)
             INPUT #1, Code(I, J)
         NEXT J
         CLOSE #1
     NEXT I

   ' Arquivo de configuracao do problema a ser analisado:
     ARQUIVO$ = CALC$ + "DADOS.DAT"
     OPEN ARQUIVO$ FOR INPUT AS #1
          INPUT #1, MODO
          INPUT #1, PPmin
          INPUT #1, PPmax
          INPUT #1, NPP
          INPUT #1, inflacao
     CLOSE #1
     PP = PPmin

   ' Tipos de dados de que a base de dados e' composta:
     ARQUIVO$ = DADOS$ + "TIPODADO.DAT"
     OPEN ARQUIVO$ FOR INPUT AS #1
          INPUT #1, NDADOS
          NDADOS = NDADOS - 1
          DIM DADO$(15)
          FOR I = 1 TO NDADOS
              INPUT #1, DADO$(I)
          NEXT I
     CLOSE #1
     NTIPOSDADOS = NDADOS
     FOR IFX = 1 TO NFaixasMax
         NTIPOSDADOS = NTIPOSDADOS + 1
         DADO$(NTIPOSDADOS) = "SUP"
     NEXT IFX
     FOR IFX = 1 TO NFaixasMax
         NTIPOSDADOS = NTIPOSDADOS + 1
         DADO$(NTIPOSDADOS) = "DFX"
     NEXT IFX

   ' Criterios complementares para as arvores de decisao
     ARQUIVO$ = CALC$ + "CRITERIO.DAT"
     OPEN ARQUIVO$ FOR INPUT AS #1
          INPUT #1, TRcrit
          INPUT #1, QIcrit
          INPUT #1, ATRcrit
          INPUT #1, ATRITOcrit
          INPUT #1, UsaModulos$
     CLOSE #1

   ' Modelos de previsao de desempenho para conserva pesada
     ARQUIVO$ = CALC$ + "CPtrecho.csv"
     OPEN ARQUIVO$ FOR INPUT AS #1
     LINE INPUT #1, LINHA$
     FOR IRodov = 1 TO NRODOV
         INPUT #1, TrechoDescr$, MatCP$(IRodov), HRCP(IRodov)
         ARQUIVO$ = PROGRAMA$ + "MODELOS.DAT"
         OPEN ARQUIVO$ FOR INPUT AS #2
              INPUT #2, NMODELOS
              FOR J = 1 TO NMODELOS
                  INPUT #2, CRest$
                  INPUT #2, Arest
                  INPUT #2, Brest
                  INPUT #2, PSRrest
                  IF CRest$ = MatCP$(IRodov) THEN
                     CamadaRest$(IRodov) = CRest$
                     A0rest(IRodov) = Arest
                     B0rest(IRodov) = Brest
                     PSR0rest(IRodov) = PSRrest
                  END IF
              NEXT J
         CLOSE #2
     NEXT IRodov
     CLOSE #1

   ' Fatores de calibracao medios da rede
     ARQUIVO$ = CALC$ + "CALIB.CSV"
     OPEN ARQUIVO$ FOR INPUT AS #1
          LINE INPUT #1, LINHA$
          FOR I = 1 TO NRODOV
              INPUT #1, Trecho$, FCnovorede(I), FCrecaprede(I), FCccprede(I)
          NEXT I
          INPUT #1, Rede$, FCnovo, FCrecap, FCccp
     CLOSE #1

   ' Percentagem da area que deve receber reparos localizados (CL)
     DIM PSIitemCL(15), ARepCL(15)
     ARQUIVO$ = CALC$ + "REPAROS.CSV"
     OPEN ARQUIVO$ FOR INPUT AS #1
     LINE INPUT #1, LINHA$
     NitensCL = 0
     WHILE NOT EOF(1)
           NitensCL = NitensCL + 1
           INPUT #1, PSIitemCL(NitensCL), ARepCL(NitensCL)
     WEND
     CLOSE #1

   ' Parametros para medir o desempenho das estrategias (Ocorrencias em %) e
   ' criterio para Priorizacao das Restauracoes sob Restricoes Orcamentarias
     ARQUIVO$ = CALC$ + "PARAM.DAT"
     OPEN ARQUIVO$ FOR INPUT AS #1
          INPUT #1, PSIref
          INPUT #1, PTRAF
          INPUT #1, PPSI
     CLOSE #1

   ' Constantes
     PI# = 3.141592654#
     QREF = 4100

   ' - - - - - - - - - - - -
   ' - Vetores e Matrizes  -
   ' - - - - - - - - - - - -
     DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax), VRmed(NPeriodos)
     DIM Idade(NFaixasMax), PSIat(NSTH, NFaixasMax), Nano(NFaixasMax), PPrest(NPeriodos)
     DIM RestrAnual(NPeriodos), RestrPolo(NPolos, NPeriodos), IPRIOR(NSTH, NFaixasMax)
     DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), CustoFaixa(NFaixasMax)
     DIM MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax)
     DIM PSImedSTH(NSTH), VSMIN(NPP), NPSI(NPeriodos), PSIt(1), NFaixas(NSTH)
     DIM IRI0(NFaixasMax), ALPHA(NFaixasMax), CustoPolo(NPolos, NPeriodos)
     DIM EXECF(NSTH, NFaixasMax), NewRestP(NPolos), CustoCLP(NPolos), Deficit(NPeriodos)
     DIM IPMAXPolo(NPolos), STHPRIPolo(NPolos), CostPr(NPolos), CUSTOT(NPeriodos)
     DIM AreaAcost(NSTH, NFaixasMax)

                      ARQUIVO$ = CALC$ + "RESTR.DAT"
                      OPEN ARQUIVO$ FOR INPUT AS #8
                           LINE INPUT #8, RedeRestric$
                           FOR I = 1 TO NPeriodos
                               INPUT #8, RestrAnual(I)
                           NEXT I
                           FOR IPolo = 1 TO NPolos
                               LINE INPUT #8, PoloRestr$
                               FOR I = 1 TO NPeriodos
                                   INPUT #8, RestrPolo(IPolo, I)
                               NEXT I
                           NEXT IPolo
                      CLOSE #8
                      VSMIN(1) = PP
                      ARQUIVO$ = CALC$ + "Conseq.dat"
                      OPEN ARQUIVO$ FOR INPUT AS #8
                           INPUT #8, ICONSEQ
                      CLOSE #8
                      ARQ$ = "CO"

   IPSIT = 1
   IPP = 1

   CLS
   PRINT
   PRINT "                        * * * * * * * * * * * * *  "
   PRINT "                        *  GERA AS ESTRATEGIAS  *  "
   PRINT "                        * * * * * * * * * * * * *  "

   ' Inicializacao de variaveis
     FOR I = 0 TO NPeriodos
         NPSI(I) = 0
     NEXT I
   ' Parametros para o Indice de Prioridade (gerados em Estrat1.bas)
     ARQUIVO$ = CALC$ + "IP.DAT"
     OPEN ARQUIVO$ FOR INPUT AS #1
     INPUT #1, VDMmin, VDMmax
     INPUT #1, PSIminRede, PSImaxRede
     CLOSE #1
     IPFORC0 = 1000

   ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12
   ANO = 0
   ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #13

   ISTH = 0
   FOR IRodov = 1 TO NRODOV
       
       ARQUIVO$ = CALC$ + ARQ$ + "CT" + Rodov$(IRodov) + ".CSV"
       OPEN ARQUIVO$ FOR OUTPUT AS #15
       WRITE #15, "ANO", "STH", "KMI", "KMF", "Custo", "Custo 1", "Custo 2", "Custo 3", "Custo 4", "Acost."
       CLOSE #15
       FOR ISUB = 1 TO NSTHRODOV(IRodov)
           ISTH = ISTH + 1
           INPUT #12, STH, NFaixas(ISTH), KMI, KMF, CBRSL, FatorVDM, FatorTraf, BASE$
           FOR IFaixa = 1 TO NFaixas(ISTH)
               INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), ALPHA(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
               INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
               INPUT #12, AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX)
           NEXT IFaixa
           WRITE #13, STH, KMI, KMF, CBRSL
           FOR IFX = 1 TO NFaixas(ISTH)
               Restaurado$(IFX) = "Nao"
               IF REVEST$(IFX) = "CCP" THEN UltCamada$(IFX) = "CCP" ELSE UltCamada$(IFX) = "CBUQ"
               HRef(IFX) = HrecExist(IFX)
               WRITE #13, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
               WRITE #13, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), ALPHA(IFX), Nacum(IFX), ALFAIGG(IFX)
               WRITE #13, AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX)
           NEXT IFX
       NEXT ISUB
   
   NEXT IRodov

   INPUT #12, PSImed(0), NPSI(0), VRmed(0)
   INPUT #12, AreaTotal, NUnidAnalise
   WRITE #13, PSImed(0), NPSI(0), VRmed(0)
   WRITE #13, AreaTotal, NUnidAnalise
   CLOSE #12, #13

  ' * * * * * * * * * * * * *
  ' * Geracao da Estrategia *
  ' * * * * * * * * * * * * *

   FOR ANO = 1 TO NPeriodos
  
     PRINT "                   Ano = "; ANO
     CustoTotal = 0
     CustoConserva = 0
     PSImed(ANO) = 0
     VRmed(ANO) = 0
     FOR IPole = 1 TO NPolos
         CustoP(IPole) = 0
         ConserP(IPole) = 0
     NEXT IPole

     ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO - 1) + ".DAT"
      OPEN ARQUIVO$ FOR INPUT AS #12
     ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
      OPEN ARQUIVO$ FOR OUTPUT AS #13

     ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
      OPEN ARQUIVO$ FOR OUTPUT AS #10

   ISTH = 0
   FOR IRodov = 1 TO NRODOV
      
       GOSUB 7000

       ' Parametros que definem as Arvores de Decisao:
         ARQUIVO$ = CALC$ + "ARV" + Rodov$(IRodov) + ".dat"
         OPEN ARQUIVO$ FOR INPUT AS #1
              INPUT #1, IDScrit
              INPUT #1, PSRcrit
              INPUT #1, HRmin
              INPUT #1, HRMAX
              INPUT #1, PSIf
              INPUT #1, DEGRAUadm
              INPUT #1, HCMIN
              INPUT #1, VUMin
              INPUT #1, QI0adm
              INPUT #1, HbaseAcost
         CLOSE #1
       
      ' PSI terminal para necessidade de restaurar o pavimento
        IPSIT = 1
        PSIt(1) = PSIf

      ' Estado de Superficie no Ano-Base
        NDADOS = 5
        FOR IFX = 1 TO NFaixasMax
            SELECT CASE IFX
                   CASE 1: Faixa$ = "1"
                   CASE 2: Faixa$ = "2"
                   CASE 3: Faixa$ = "3"
                   CASE 4: Faixa$ = "4"
                   CASE ELSE: PRINT "ERRO": STOP
            END SELECT
            ISUP = NDADOS + IFX
            ARQUIVO$ = CALC$ + DADO$(ISUP) + Rodov$(IRodov) + Faixa$ + ".DAT"
            OPEN ARQUIVO$ FOR INPUT AS #ISUP
            ISUPout = ISUP - 4
            ARQUIVO$ = PROGRAMA$ + "Docs\Params\" + "LVC" + Rodov$(IRodov) + Faixa$ + ".CSV"
            OPEN ARQUIVO$ FOR INPUT AS #ISUPout
                 LINE INPUT #ISUPout, LINHA$
                 LINE INPUT #ISUPout, LINHA$
        NEXT IFX

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        ISTH = ISTH + 1
        ' Inicializacao de parametros a cada ano
          FOR IFaixa = 1 TO NFaixasMax
              MedidaF$(IFaixa) = ""
              Hfres(IFaixa) = 0
              Hrec(IFaixa) = 0
              CustoFaixa(IFaixa) = 0
              MedidaAcost$(IFaixa) = ""
              HRAC(IFaixa) = 0
              H2AC(IFaixa) = 0
              CustoAcost(IFaixa) = 0
          NEXT IFaixa
          PSImedSTH(ISTH) = 0
        
        INPUT #12, STH, KMI, KMF, CBRSL

        FOR IFaixa = 1 TO NFaixas(ISTH)
            
            INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), ALPHA(IFX), Nacum(IFX), ALFAIGG(IFX)
            INPUT #12, AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX)

            ' Indice de Prioridade
              IPSI = 100 * (PSImaxRede - PSIat(ISTH, IFaixa)) / (PSImaxRede - PSIminRede)
              ITRAF = 100 * (VDMUni(IFaixa) - VDMmin) / (VDMmax - VDMmin)
              IPRIOR(ISTH, IFaixa) = (PTRAF * ITRAF + PPSI * IPSI) / (PTRAF + PPSI)
              IF (IPRIOR(ISTH, IFaixa) < 0) THEN IPRIOR(ISTH, IFaixa) = .5
       
        NEXT IFaixa

       ' - - - - - - - - - - - - - - - - - - - - - - - - - -
       ' -  Evolucao da Condicao do Pavimento apos um Ano  -
       ' - - - - - - - - - - - - - - - - - - - - - - - - - -

         FOR IFaixa = 1 TO NFaixas(ISTH)
          
           VidaRes(IFaixa) = VidaRes(IFaixa) - 1
           IF (VidaRes(IFaixa) < 0) THEN VidaRes(IFaixa) = 0
          
           Idade(IFaixa) = Idade(IFaixa) + 1
           PSI = PSIat(ISTH, IFaixa)
           QIest = QImed(IFaixa)
           Nano(IFaixa) = Nano(IFaixa) * FatorTraf
           Nacum(IFaixa) = Nacum(IFaixa) + Nano(IFaixa)
           VDMUni(IFaixa) = VDMUni(IFaixa) * FatorVDM
           H1 = H1REV(IFaixa)
           Age = Idade(IFaixa)
           
           GOSUB 3000

           PSIat(ISTH, IFaixa) = PSI
           QImed(IFaixa) = QIest
           IF PSI <= PSIt(IPSIT) THEN VidaRes(IFaixa) = 0

           IF PSIat(ISTH, IFaixa) < PSIref THEN NPSI(ANO) = NPSI(ANO) + 1
           PSImedSTH(ISTH) = PSImedSTH(ISTH) + PSIat(ISTH, IFaixa) * Aream2(ISTH, IFaixa)

         NEXT IFaixa

    ' - - - - - - - - - - - - - - - - - - - - - - -
    ' - Necessidades de Manutencao da Rede no Ano -
    ' - - - - - - - - - - - - - - - - - - - - - - -
    
     RestSTH$ = "Nao"
     AplicaCP$ = "Sim"
     FOR IFaixa = 1 TO NFaixasMax
       
         ISUP = NDADOS + IFaixa
         ISUPout = ISUP - 4
         IF IFaixa <= NFaixas(ISTH) THEN

            ' Durabilidade esperada para a medida especificada como Conserva Pesada
              NP = 1000000! * (PSR0rest(IRodov) - PSIt(IPSIT)) / (A0rest(IRodov) + B0rest(IRodov) * D0(IFaixa))
              VSCP = NP / Nano(IFaixa)

            ' Estado de Superficie no Ano-Base
              INPUT #ISUP, STH, KMINI, KMFIM, PSR, CR$, BL$, TT$
              INPUT #ISUP, TL$, TE$, TB$, P$, D$, DS$
              INPUT #ISUP, ER$, BF$, DC$, R$, ATR$, COR$
              INPUT #ISUP, EM$, DP$, EL$, PSRACOST, DEGRAUCM, OBS$, ATRmed

              INPUT #ISUPout, KMI, KMF, IGGE, ICPF, IES, TR23, TR2, TR3

            Age = Idade(IFaixa)
            PSI = PSIat(ISTH, IFaixa)
            QI = QImed(IFaixa)
            NYEAR = Nano(IFaixa)
            H1 = H1REV(IFaixa)
            DC = D0(IFaixa)
            ' Correlacao PSI x IDS
              PSImax = 4.5
              IF PSI <= PSImax THEN
                   IDS = ALFAIGG(IFaixa) * ((((PSImax / PSI) - 1) / .007635) ^ (1 / 1.065))
              ELSE
                   IDS = 0
              END IF
        
            ' Vida restante:
              VR = VidaRes(IFaixa)
              VRmed(ANO) = VRmed(ANO) + Aream2(ISTH, IFaixa) * VR
        
            ' Necessidade de reforco estrutural:
              PP = VSMIN(IPP) - VR
              IF PP < .5 THEN PP = .5
              GOSUB 1200

            GOSUB 1000

            IF HC > 0 THEN
               RES = HC - INT(HC)
               IF RES >= .5 THEN INCR = 1 ELSE INCR = 0
               HC = INT(HC) + INCR
            END IF
            IF HR > 0 THEN
               RES = HR - INT(HR)
               IF RES >= .5 THEN INCR = 1 ELSE INCR = 0
               HR = INT(HR) + INCR
            END IF
            MedidaF$(IFaixa) = Medida$
            Hfres(IFaixa) = HC
            Hrec(IFaixa) = HR

            IF (Medida$ = "CR" OR Medida$ = "CL") THEN AplicaCP$ = "Nao"
           
            IF (MedidaF$(IFaixa) = "RS" OR MedidaF$(IFaixa) = "MF+RC" OR MedidaF$(IFaixa) = "FR+RC" OR MedidaF$(IFaixa) = "RRV" OR MedidaF$(IFaixa) = "RRP" OR MedidaF$(IFaixa) = "RRT") THEN RestSTH$ = "Sim"
    
         ELSE

              LINE INPUT #ISUP, LINHA$
              LINE INPUT #ISUPout, LINHA$

         END IF

     NEXT IFaixa
   
     IF AplicaCP$ = "Nao" THEN
        FOR IFaixa = 1 TO NFaixas(ISTH)
            IF MedidaF$(IFaixa) = "CP" THEN
               MedidaF$(IFaixa) = "CL"
               Hfres(IFaixa) = 0
               Hrec(IFaixa) = 0
            END IF
        NEXT IFaixa
     END IF
     
     ' Evolucao da condicao dos acostamentos apos um ano
       FOR IFaixa = 1 TO NFaixas(ISTH)
           IF PSIacost(IFaixa) > 3.5 THEN
                 DPSI = .05
           ELSE
                 IF PSIacost(IFaixa) > 2! THEN DPSI = .1 ELSE DPSI = .2
           END IF
           PSIacost(IFaixa) = PSIacost(IFaixa) - DPSI
           IF PSIacost(IFaixa) < 0 THEN PSIacost(IFaixa) = 0
       NEXT IFaixa

     ' Compatibiliza a geometria entre as faixas de trafego (incluindo os acostamentos)
       GOSUB 8000

     ' Leitura dos Custos Unitarios
       YEAR$ = STR$(ANO)
       GOSUB 500

     FOR IFaixa = 1 TO NFaixas(ISTH)
        
         Medida$ = MedidaF$(IFaixa)
         GOSUB 5000

         CustoFaixa(IFaixa) = Custo
         CustoTotal = CustoTotal + Custo
         IF (Medida$ = "CR" OR Medida$ = "CL" OR Medida$ = "ST") THEN
            CustoConserva = CustoConserva + Custo
            ConserP(IPolo) = ConserP(IPolo) + Custo
         END IF
         CustoP(IPolo) = CustoP(IPolo) + Custo

     NEXT IFaixa

     ' Custo da Intervencao nos Acostamentos
       FOR IFaixa = 1 TO NFaixas(ISTH)
           GOSUB 2000
           CustoAcost(IFaixa) = Custo * AreaAcost(ISTH, IFaixa)
           CustoTotal = CustoTotal + CustoAcost(IFaixa)
           CustoP(IPolo) = CustoP(IPolo) + CustoAcost(IFaixa)
           IF (MedidaAcost$(IFaixa) = "CR" OR MedidaAcost$(IFaixa) = "CL" OR MedidaAcost$(IFaixa) = "ST") THEN
                  CustoConserva = CustoConserva + CustoAcost(IFaixa)
                  ConserP(IPolo) = ConserP(IPolo) + CustoAcost(IFaixa)
           END IF
       NEXT IFaixa

       WRITE #13, STH, KMI, KMF, CBRSL
       FOR IFX = 1 TO NFaixas(ISTH)
         WRITE #13, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
         WRITE #13, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), ALPHA(IFX), Nacum(IFX), ALFAIGG(IFX)
         WRITE #13, AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX)
       NEXT IFX

       FOR IFX = 1 TO NFaixas(ISTH)
           WRITE #10, STH, CustoFaixa(IFX), MedidaF$(IFX), Hfres(IFX), Hrec(IFX), CustoAcost(IFX), MedidaAcost$(IFX), HRAC(IFX), H2AC(IFX)
       NEXT IFX
  
    NEXT ISUB
    FOR IFX = 1 TO NFaixasMax
        ISUP = NDADOS + IFX
        ISUPout = ISUP - 4
        CLOSE #ISUP
        CLOSE #ISUPout
    NEXT IFX
 
   NEXT IRodov
   Deficit(ANO) = CustoTotal
  
   INPUT #12, PSImed(0), NPSI(0), VRmed(0)
   INPUT #12, AreaTotal, NUnidAnalise
   WRITE #13, PSImed(0), NPSI(0), VRmed(0)
   WRITE #13, AreaTotal, NUnidAnalise
   CLOSE #4, #10, #12, #13

    ' - - - - - - - - - - - - - - - - - - - - - - -
    ' -  Define os Segmentos a serem Restaurados  -
    ' - - - - - - - - - - - - - - - - - - - - - - -
    PRINT "                          R.O. = "; RestrAnual(ANO); "      Custo ="; CustoTotal
   
    IF RedeRestric$ = "Para toda a rede" THEN
         IF RestrAnual(ANO) >= CustoTotal THEN Prioriza$ = "Nao" ELSE Prioriza$ = "Sim"
    ELSE
         Prioriza$ = "Nao"
         FOR IPole = 1 TO NPolos
             IF RestrPolo(IPole, ANO) < CustoP(IPole) THEN Prioriza$ = "Sim"
         NEXT IPole
    END IF
    
    IF Prioriza$ = "Nao" THEN
        
     ' Todas as restauracoes necessarias serao executadas
       PRINT "                          Nao ha necessidade de priorizacao."
       ISTH = 0
       FOR IRodov = 1 TO NRODOV
           FOR ISUB = 1 TO NSTHRODOV(IRodov)
               ISTH = ISTH + 1
               FOR IFaixa = 1 TO NFaixas(ISTH)
                   EXECF(ISTH, IFaixa) = 1
               NEXT IFaixa
           NEXT ISUB
       NEXT IRodov

       CUSTOT(ANO) = CustoTotal
       FOR IPole = 1 TO NPolos
           CustoPolo(IPole, ANO) = CustoP(IPole)
       NEXT IPole

    ELSE
       
     ' Deve ser aplicada a priorizacao para as restauracoes
       PRINT "                    Aplicando a priorizacao..."

     IF RedeRestric$ = "Para toda a rede" THEN
            NovaRestr = RestrAnual(ANO) - CustoConserva
     ELSE
            FOR IPole = 1 TO NPolos
                NewRestP(IPole) = RestrPolo(IPole, ANO) - ConserP(IPole)
            NEXT IPole
     END IF
     CustoCL = 0!
     FOR IPole = 1 TO NPolos
         CustoCLP(IPole) = 0
     NEXT IPole
    
     FOR ICONTROL = 1 TO 4
         
       CUSTOT(ANO) = CustoConserva
       TotalCost = CUSTOT(ANO) + CustoCL
       FOR IPole = 1 TO NPolos
           CustoPolo(IPole, ANO) = ConserP(IPole)
           CTotal(IPole) = CustoPolo(IPole, ANO) + CustoCLP(IPole)
       NEXT IPole
       IF RedeRestric$ = "Para toda a rede" THEN
            IF TotalCost < RestrAnual(ANO) THEN
                 TERMINOU$ = "Nao"
            ELSE
                 TERMINOU$ = "Sim"
            END IF
       ELSE
            Conclude$ = "Sim"
            FOR IPole = 1 TO NPolos
                IF CTotal(IPole) < RestrPolo(IPole, ANO) THEN Conclude$ = "Nao"
            NEXT IPole
            IF Conclude$ = "Sim" THEN TERMINOU$ = "Sim" ELSE TERMINOU$ = "Nao"
       END IF

       ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
       OPEN ARQUIVO$ FOR INPUT AS #6
       ISTH = 0
       FOR IRodov = 1 TO NRODOV
        FOR ISUB = 1 TO NSTHRODOV(IRodov)
         ISTH = ISTH + 1
         FOR IFaixa = 1 TO NFaixas(ISTH)
             INPUT #6, STH, CustoFaixa(IFaixa), MedidaF$(IFaixa), Hfres(IFaixa), Hrec(IFaixa), CustoAcost(IFaixa), MedidaAcost$(IFaixa), HRAC(IFaixa), H2AC(IFaixa)
             Medida$ = MedidaF$(IFaixa)
             IF (Medida$ = "CR" OR Medida$ = "CL" OR Medida$ = "ST") THEN
                    EXECF(ISTH, IFaixa) = 1
             ELSE
                    EXECF(ISTH, IFaixa) = 0
             END IF
         NEXT IFaixa
        NEXT ISUB
       NEXT IRodov
       CLOSE #6

     ' Encontra o segmento de maxima prioridade
       WHILE TERMINOU$ = "Nao"

         IPMAX = 0
         STHPRIOR = 0
         FOR IPole = 1 TO NPolos
             IPMAXPolo(IPole) = 0
             STHPRIPolo(IPole) = 0
         NEXT IPole
         ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
         OPEN ARQUIVO$ FOR INPUT AS #6
         ISTH = 0
         FOR IRodov = 1 TO NRODOV
          GOSUB 7000
          FOR ISUB = 1 TO NSTHRODOV(IRodov)
           ISTH = ISTH + 1
           FOR IFaixa = 1 TO NFaixas(ISTH)
             INPUT #6, STH, CustoFaixa(IFaixa), MedidaF$(IFaixa), Hfres(IFaixa), Hrec(IFaixa), CustoAcost(IFaixa), MedidaAcost$(IFaixa), HRAC(IFaixa), H2AC(IFaixa)
           NEXT IFaixa
                
             FOR IFaixa = 1 TO NFaixas(ISTH)
                
               IF RedeRestric$ = "Para toda a rede" THEN

                  IF (IPRIOR(ISTH, IFaixa) > IPMAX AND EXECF(ISTH, IFaixa) = 0) THEN
                     IPMAX = IPRIOR(ISTH, IFaixa)
                     STHPRIOR = ISTH
                     IPoloPrior = IPolo
                     CustoPrior = 0
                     FOR IFX = 1 TO NFaixas(ISTH)
                         CustoPrior = CustoPrior + CustoFaixa(IFX) + CustoAcost(IFX)
                     NEXT IFX
                  END IF
                   
               ELSE
                     
                  IF (IPRIOR(ISTH, IFaixa) > IPMAXPolo(IPolo) AND EXECF(ISTH, IFaixa) = 0) THEN
                     IPMAXPolo(IPolo) = IPRIOR(ISTH, IFaixa)
                     STHPRIPolo(IPolo) = ISTH
                     CostPr(IPolo) = 0
                     FOR IFX = 1 TO NFaixas(ISTH)
                         CostPr(IPolo) = CostPr(IPolo) + CustoFaixa(IFX) + CustoAcost(IFX)
                     NEXT IFX
                  END IF

               END IF

             NEXT IFaixa
          NEXT ISUB
         NEXT IRodov
         CLOSE #6
        
         ' Verifica se o segmento de maxima prioridade pode ser restaurado:
           IF RedeRestric$ = "Para toda a rede" THEN
                   
              IF STHPRIOR = 0 THEN
                     TERMINOU$ = "Sim"
              ELSE
                     IF NovaRestr >= CustoPrior THEN
                         ' Aciona a restauracao:
                           NovaRestr = NovaRestr - CustoPrior
                           FOR IFX = 1 TO NFaixas(STHPRIOR)
                               EXECF(STHPRIOR, IFX) = 1
                           NEXT IFX
                           CUSTOT(ANO) = CUSTOT(ANO) + CustoPrior
                           CustoPolo(IPoloPrior, ANO) = CustoPolo(IPoloPrior, ANO) + CustoPrior
                     ELSE
                         ' Elimina o segmento prioritario neste ano, a fim de
                         ' se verificar se o proximo colocado deste ANO pode ser
                         ' restaurado:
                           FOR IFX = 1 TO NFaixas(STHPRIOR)
                               IPRIOR(STHPRIOR, IFX) = -1
                           NEXT IFX
                     END IF
              END IF
              IF NovaRestr <= 0 THEN TERMINOU$ = "Sim"
                
           ELSE

              SOMA = 0
              FOR IPole = 1 TO NPolos
                  SOMA = SOMA + STHPRIPolo(IPole)
              NEXT IPole
              IF SOMA = 0 THEN TERMINOU$ = "Sim"
             
              IF TERMINOU$ = "Nao" THEN
                 FOR IPole = 1 TO NPolos
                   IF STHPRIPolo(IPole) > 0 THEN
                     IF NewRestP(IPole) >= CostPr(IPole) THEN
                         ' Aciona a restauracao:
                           NewRestP(IPole) = NewRestP(IPole) - CostPr(IPole)
                           FOR IFX = 1 TO NFaixas(STHPRIPolo(IPole))
                               EXECF(STHPRIPolo(IPole), IFX) = 1
                           NEXT IFX
                           CUSTOT(ANO) = CUSTOT(ANO) + CostPr(IPole)
                           CustoPolo(IPole, ANO) = CustoPolo(IPole, ANO) + CostPr(IPole)
                     ELSE
                         ' Elimina o segmento prioritario neste ano, a fim de
                         ' se verificar se o proximo colocado deste ANO pode ser
                         ' restaurado:
                           FOR IFX = 1 TO NFaixas(STHPRIPolo(IPole))
                               IPRIOR(STHPRIPolo(IPole), IFX) = -1
                           NEXT IFX
                     END IF
                   END IF
                 NEXT IPole
                 Conclude$ = "Sim"
                 FOR IPole = 1 TO NPolos
                     IF NewRestP(IPole) > 0 THEN Conclude$ = "Nao"
                 NEXT IPole
                 IF Conclude$ = "Sim" THEN TERMINOU$ = "Sim"

              END IF
                
           END IF
           
       WEND

       ' Exclui o custo de CL da restricao orcamentaria nos segmentos nao
       ' priorizados que deveriam ser restaurados:
           CustoCL = 0!
           FOR IPole = 1 TO NPolos
               CustoCLP(IPole) = 0
           NEXT IPole
           ISTH = 0
           FOR IRodov = 1 TO NRODOV

             GOSUB 7000

             ' Leitura dos Custos Unitarios
               YEAR$ = STR$(ANO)
               GOSUB 500

             FOR ISUB = 1 TO NSTHRODOV(IRodov)
                 ISTH = ISTH + 1
                 FOR IFaixa = 1 TO NFaixas(ISTH)
                     IF EXECF(ISTH, IFaixa) = 0 THEN
                               Medida$ = "CL"
                               GOSUB 5000
                               CustoCL = CustoCL + Custo
                               CustoCLP(IPolo) = CustoCLP(IPolo) + Custo
                     END IF
                 NEXT IFaixa
             NEXT ISUB
           NEXT IRodov
           ' Refaz a priorizacao com a restricao orcamentaria ajustada
             IF RedeRestric$ = "Para toda a rede" THEN
                NovaRestr = RestrAnual(ANO) - CustoConserva - CustoCL
             ELSE
                FOR IPole = 1 TO NPolos
                    NewRestP(IPole) = RestrPolo(IPole, ANO) - ConserP(IPole) - CustoCLP(IPole)
                NEXT IPole
             END IF

     NEXT ICONTROL
     CUSTOT(ANO) = CUSTOT(ANO) + CustoCL
     FOR IPole = 1 TO NPolos
           CustoPolo(IPole, ANO) = CustoPolo(IPole, ANO) + CustoCLP(IPole)
     NEXT IPole

    END IF
    PRINT "Custo Total apos otimizacao = "; CUSTOT(ANO)
   
   ' - - - - - - - - - - - - - - - - - - -
   ' -  Aplica as Intervencoes Indicadas -
   ' - - - - - - - - - - - - - - - - - - -
     ARQUIVO$ = CALC$ + "MEDIDAS.DAT"
     OPEN ARQUIVO$ FOR INPUT AS #6
     ARQUIVO$ = CALC$ + "MED.DAT"
     OPEN ARQUIVO$ FOR OUTPUT AS #15
     ISTH = 0
     FOR IRodov = 1 TO NRODOV

         GOSUB 7000

         ' Leitura dos Custos Unitarios
           YEAR$ = STR$(ANO)
           GOSUB 500

         FOR ISUB = 1 TO NSTHRODOV(IRodov)
             ISTH = ISTH + 1
             FOR IFaixa = 1 TO NFaixas(ISTH)
                 INPUT #6, STH, CustoFaixa(IFaixa), MedidaF$(IFaixa), Hfres(IFaixa), Hrec(IFaixa), CustoAcost(IFaixa), MedidaAcost$(IFaixa), HRAC(IFaixa), H2AC(IFaixa)
             NEXT IFaixa
             ' Muda a medida para CL onde nao foi priorizado
               FOR IFaixa = 1 TO NFaixas(ISTH)
                   IF EXECF(ISTH, IFaixa) = 0 THEN
                          
                           MedidaF$(IFaixa) = "CL"
                           Hfres(IFaixa) = 0
                           Hrec(IFaixa) = 0
                           MedidaAcost$(IFaixa) = "CR"
                           HRAC(IFaixa) = 0
                           H2AC(IFaixa) = 0
                            
                           Medida$ = MedidaF$(IFaixa)
                           GOSUB 5000
                           CustoFaixa(IFaixa) = Custo

                           ' Custo da Intervencao nos Acostamentos
                             CustoAcost(IFaixa) = 0!

                   END IF
               NEXT IFaixa
               FOR IFaixa = 1 TO NFaixas(ISTH)
                   WRITE #15, STH, CustoFaixa(IFaixa), MedidaF$(IFaixa), Hfres(IFaixa), Hrec(IFaixa), CustoAcost(IFaixa), MedidaAcost$(IFaixa), HRAC(IFaixa), H2AC(IFaixa)
               NEXT IFaixa

         NEXT ISUB
     NEXT IRodov
     CLOSE #6, #15

 ' Altera a condicao do pavimento devido `a intervencao

   ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12
   ARQUIVO$ = CALC$ + "ESTSTHS2.DAT"
     OPEN ARQUIVO$ FOR OUTPUT AS #13

   ARQUIVO$ = CALC$ + "MED.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #6

   ISTH = 0
   FOR IRodov = 1 TO NRODOV
       
    GOSUB 7000
    FOR ISUB = 1 TO NSTHRODOV(IRodov)

     ISTH = ISTH + 1
     
     INPUT #12, STH, KMI, KMF, CBRSL
     FOR IFaixa = 1 TO NFaixas(ISTH)
         
         INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
         INPUT #12, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), ALPHA(IFX), Nacum(IFX), ALFAIGG(IFX)
         INPUT #12, AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX)
         INPUT #6, STH, CustoFaixa(IFaixa), MedidaF$(IFaixa), Hfres(IFaixa), Hrec(IFaixa), CustoAcost(IFaixa), MedidaAcost$(IFaixa), HRAC(IFaixa), H2AC(IFaixa)
              
              Area = Aream2(ISTH, IFaixa)
              HR = Hrec(IFaixa)
              HC = Hfres(IFaixa)
              Medida$ = MedidaF$(IFaixa)
              VDM = VDMUni(IFaixa)
              Age = Idade(IFaixa)
              PSI = PSIat(ISTH, IFaixa)
              QIest = QImed(IFaixa)
              H1 = H1REV(IFaixa)
              
              GOSUB 4000
              
              Idade(IFaixa) = Age
              PSIat(ISTH, IFaixa) = PSI
              QImed(IFaixa) = QIest
              H1REV(IFaixa) = H1

         ' Vida Residual do Pavimento
           PSI = PSIat(ISTH, IFaixa)
           IF (MedidaF$(IFaixa) <> "CR" AND MedidaF$(IFaixa) <> "CL" AND MedidaF$(IFaixa) <> "ST") THEN
              PSI = PSIat(ISTH, IFaixa)
              H1 = H1REV(IFaixa)
              Age = Idade(IFaixa)
              GOSUB 6500
              VidaRes(IFaixa) = VR
           END IF
           VRmed(ANO) = VRmed(ANO) + Aream2(ISTH, IFaixa) * VidaRes(IFaixa)

         IF PSIat(ISTH, IFaixa) < PSIref THEN NPSI(ANO) = NPSI(ANO) + 1
         PSImedSTH(ISTH) = PSImedSTH(ISTH) + Aream2(ISTH, IFaixa) * PSIat(ISTH, IFaixa)
       
         ' Intervencao nos Acostamentos
           SELECT CASE MedidaAcost$(IFaixa)
                  CASE "CR", "CL"
                  CASE "TSS", "TSD"
                                        PSIacost(IFaixa) = 4.2
                                        DegrauAcost(IFaixa) = 0
                  CASE "PMF", "RRP", "RRT"
                                        PSIacost(IFaixa) = 4.5
                                        DegrauAcost(IFaixa) = 0
                  CASE ELSE
                                        PRINT "ERRO: Medida = "; MedidaAcost$: STOP
           END SELECT
     
     NEXT IFaixa
    
     WRITE #13, STH, KMI, KMF, CBRSL
     FOR IFX = 1 TO NFaixas(ISTH)
         WRITE #13, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
         WRITE #13, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), ALPHA(IFX), Nacum(IFX), ALFAIGG(IFX)
         WRITE #13, AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX)
     NEXT IFX

     PSImed(ANO) = PSImed(ANO) + PSImedSTH(ISTH)
     J = Code(IRodov, ISUB)
     Y = ANO + ANOBASE
     N = NFaixas(ISTH)
     
     CustoSTH = 0
     CustoAc = 0
     FOR IFaixa = 1 TO NFaixas(ISTH)
         CustoSTH = CustoSTH + CustoFaixa(IFaixa) + CustoAcost(IFaixa)
         CustoAc = CustoAc + CustoAcost(IFaixa)
     NEXT IFaixa
    
    NEXT ISUB
   NEXT IRodov
  
   INPUT #12, PSImed(0), NPSI(0), VRmed(0)
   INPUT #12, AreaTotal, NUnidAnalise
   WRITE #13, PSImed(0), NPSI(0), VRmed(0)
   WRITE #13, AreaTotal, NUnidAnalise
   CLOSE #6, #12, #13

   ARQUIVO$ = CALC$ + "ESTSTHS2.DAT"
    OPEN ARQUIVO$ FOR INPUT AS #12
   ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #13

   VDMmin = 1E+20: VDMmax = 0
   PSIminRede = 5!: PSImaxRede = 0
   ISTH = 0
   FOR IRodov = 1 TO NRODOV
       FOR ISUB = 1 TO NSTHRODOV(IRodov)
           ISTH = ISTH + 1
           INPUT #12, STH, KMI, KMF, CBRSL
           FOR IFaixa = 1 TO NFaixas(ISTH)
               INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
               INPUT #12, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), ALPHA(IFX), Nacum(IFX), ALFAIGG(IFX)
               INPUT #12, AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX)
               IF VDMUni(IFX) > VDMmax THEN VDMmax = VDMUni(IFX)
               IF VDMUni(IFX) < VDMmin THEN VDMmin = VDMUni(IFX)
               IF PSIat(ISTH, IFX) > PSImaxRede THEN PSImaxRede = PSIat(ISTH, IFX)
               IF PSIat(ISTH, IFX) < PSIminRede THEN PSIminRede = PSIat(ISTH, IFX)
           NEXT IFaixa
           WRITE #13, STH, KMI, KMF, CBRSL
           FOR IFX = 1 TO NFaixas(ISTH)
               WRITE #13, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), Restaurado$(IFX), UltCamada$(IFX), VDMUni(IFX), PSInovo(IFX), HRef(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
               WRITE #13, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), Nano(IFX), IRI0(IFX), ALPHA(IFX), Nacum(IFX), ALFAIGG(IFX)
               WRITE #13, AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX)
           NEXT IFX
       NEXT ISUB
   NEXT IRodov
  
   INPUT #12, PSImed(0), NPSI(0), VRmed(0)
   INPUT #12, AreaTotal, NUnidAnalise
   WRITE #13, PSImed(0), NPSI(0), VRmed(0)
   WRITE #13, AreaTotal, NUnidAnalise
   CLOSE #12, #13

   ' Fator 2 nas formulas abaixo se deve `a media entre antes e depois
   ' das intervencoes programadas para o ANO:
     NPSI(ANO) = 100 * NPSI(ANO) / (2 * NUnidAnalise)
     PSImed(ANO) = PSImed(ANO) / (2 * AreaTotal)
     VRmed(ANO) = VRmed(ANO) / (2 * AreaTotal)

   ' - - - - - - - - - - - - - - -
   ' - Passa para o ano seguinte -
   ' - - - - - - - - - - - - - - -
   NEXT ANO

   ' - - - - - - - - - - - - - - - -
   ' -  Gera os Arquivos de Saida  -
   ' - - - - - - - - - - - - - - - -
   
   ARQUIVO$ = CALC$ + "Results.csv"
   OPEN ARQUIVO$ FOR OUTPUT AS #4
   WRITE #4, "Ano", "Custo(mR$)", "PSI Medio", "Ocorr. (%)", "VR (anos)"
 
                             SELECT CASE ICONSEQ
                                    CASE 4
                                           ARQCUSTO$ = CALC$ + "CustoICA.out"
                                           ARQPSI$ = CALC$ + "PSIICA.out"
                                           ARQNPSI$ = CALC$ + "NPSIICA.OUT"
                                           ARQVR$ = CALC$ + "VRICA.out"
                                    CASE 5
                                           ARQCUSTO$ = CALC$ + "CustoICB.out"
                                           ARQPSI$ = CALC$ + "PSIICB.out"
                                           ARQNPSI$ = CALC$ + "NPSIICB.OUT"
                                           ARQVR$ = CALC$ + "VRICB.out"
                                    CASE 6
                                           ARQCUSTO$ = CALC$ + "CustoICC.out"
                                           ARQPSI$ = CALC$ + "PSIICC.out"
                                           ARQNPSI$ = CALC$ + "NPSIICC.OUT"
                                           ARQVR$ = CALC$ + "VRICC.out"
                                    CASE 7
                                           ARQCUSTO$ = CALC$ + "CustoICD.out"
                                           ARQPSI$ = CALC$ + "PSIICD.out"
                                           ARQNPSI$ = CALC$ + "NPSIICD.OUT"
                                           ARQVR$ = CALC$ + "VRICD.out"
                                    CASE ELSE
                                           PRINT "ERRO": STOP
                             END SELECT

   OPEN ARQCUSTO$ FOR OUTPUT AS #1
   OPEN ARQPSI$ FOR OUTPUT AS #2
   OPEN ARQNPSI$ FOR OUTPUT AS #3
   OPEN ARQVR$ FOR OUTPUT AS #5

   FOR IANO = 1 TO NPeriodos
       Deficit(IANO) = Deficit(IANO) - CUSTOT(IANO)
       WRITE #1, CUSTOT(IANO)
       WRITE #1, Deficit(IANO)
       FOR IPolo = 1 TO NPolos
           WRITE #1, CustoPolo(IPolo, IANO)
       NEXT IPolo
       ANO = ANOBASE + IANO
       WRITE #4, ANO, (CUSTOT(IANO) / 1000), PSImed(IANO), NPSI(IANO), VRmed(IANO)
   NEXT IANO
   CLOSE #1, #4

   FOR IANO = 0 TO NPeriodos
       WRITE #2, PSImed(IANO)
       WRITE #3, NPSI(IANO)
       WRITE #5, VRmed(IANO)
   NEXT IANO
   CLOSE #2, #3, #5

 END

500  ' - - - - - - - - - - - -
     ' -  Custos Unitarios   -
     ' -     (Subrotina)     -
     ' - - - - - - - - - - - -
       ARQUIVO$ = CALC$ + "C" + Rodov$(IRodov) + YEAR$ + ".CSV"
       OPEN ARQUIVO$ FOR INPUT AS #1
            INPUT #1, CBUQm3
            INPUT #1, Reperf
            INPUT #1, Fresagemm3
            INPUT #1, BGm3
            INPUT #1, Remocao
            INPUT #1, CRkmAno
            INPUT #1, CLm2
            INPUT #1, MICROCA4m2
            INPUT #1, MICROCA7m2
            INPUT #1, MICROCA12m2
            INPUT #1, TSSm2
            INPUT #1, TSDm3
            INPUT #1, TSTm3
            INPUT #1, Pintura
            INPUT #1, Selagem
            INPUT #1, PMFm3
            INPUT #1, LamaD
            INPUT #1, LamaM
            INPUT #1, LamaG
            INPUT #1, BaseAcostm3
            INPUT #1, TSSpolm2
            INPUT #1, TSDpolm3
            INPUT #1, TSTpolm3
       CLOSE #1
       RETURN

5000 ' - - - - - - - - - - - - - - - - - - - - - - -
     ' -       Custo da Medida de Manutencao       -
     ' -                (Subrotina)                -
     ' -  Dados: Medida$, HC, HR, Area, PSI, VDM   -
     ' -  Saida: Custo                             -
     ' - - - - - - - - - - - - - - - - - - - - - - -
       SELECT CASE Medida$
              CASE "CP"
                        SELECT CASE CamadaRest$(IRodov)
                               CASE "Lama Asfaltica Delgada": Custo = LamaD
                               CASE "Lama Asfaltica Media": Custo = LamaM
                               CASE "Lama Asfaltica Grossa": Custo = LamaG
                               CASE "Micro-CA 4 mm": Custo = MICROCA4m2
                               CASE "Micro-CA 7 mm": Custo = MICROCA7m2
                               CASE "Micro-CA 12 mm": Custo = MICROCA12m2
                               CASE "TSD": Custo = TSDm3
                               CASE "TST": Custo = TSTm3
                               CASE "TSD com Polimero (18 mm)": Custo = TSDpolm3
                               CASE ELSE: PRINT "ERRO": STOP
                        END SELECT
              CASE "CR"
                        IF Aream2(ISTH, IFaixa) > 0 THEN
                                         Custo = ABS(KMF - KMI) * CRkmAno
                                         Custo = Custo / Aream2(ISTH, IFaixa)
                        ELSE
                                         Custo = 0
                        END IF
              CASE "CL", "ST"
                        PSI = PSIat(ISTH, IFaixa)
                        I1 = 0
                        FOR ICL = 1 TO (NitensCL - 1)
                            IF (PSI <= PSIitemCL(ICL) AND PSI > PSIitemCL(ICL + 1)) THEN
                                     I1 = ICL
                                     I2 = ICL + 1
                            END IF
                        NEXT ICL
                        IF PSI <= PSIitemCL(NitensCL) THEN
                               I1 = NitensCL - 1
                               I2 = NitensCL
                        END IF
                        IF I1 = 0 THEN
                                PerctReparos = 0
                        ELSE
                                Y1 = ARepCL(I1)
                                Y2 = ARepCL(I2)
                                X1 = PSIitemCL(I1)
                                X2 = PSIitemCL(I2)
                                PerctReparos = ((X2 * Y1 - X1 * Y2) / (X2 - X1)) + ((Y2 - Y1) * PSI / (X2 - X1))
                        END IF
                        IF Medida$ = "ST" THEN
                              PerctReparos = .1 * PerctReparos
                              IF PerctReparos > 1! THEN PerctReparos = 1!
                              Custo = Selagem * PerctReparos / 100
                        ELSE
                              IF PerctReparos > 35! THEN PerctReparos = 35!
                              Custo = CLm2 * PerctReparos / 100
                        END IF
              CASE "RS"
                        IF Hrec(IFaixa) <= 7! THEN
                           Ncamadas = 1
                        ELSE
                           IF Hrec(IFaixa) <= 14! THEN
                              Ncamadas = 2
                           ELSE
                              Ncamadas = 3
                           END IF
                        END IF
                        Custo = (Hrec(IFaixa) / 100) * CBUQm3 + Ncamadas * Pintura
              CASE "MF+RC"
                        IF Hrec(IFaixa) <= 7! THEN
                           Ncamadas = 1
                        ELSE
                           IF Hrec(IFaixa) <= 14! THEN
                              Ncamadas = 2
                           ELSE
                              Ncamadas = 3
                           END IF
                        END IF
                        Custo = (Hrec(IFaixa) / 100) * CBUQm3 + (Ncamadas + 1) * Pintura + Reperf
              CASE "FR+RC", "RRV"
                        IF Hrec(IFaixa) <= 7! THEN
                           Ncamadas = 1
                        ELSE
                           IF Hrec(IFaixa) <= 14! THEN
                              Ncamadas = 2
                           ELSE
                              Ncamadas = 3
                           END IF
                        END IF
                        Custo = (Hrec(IFaixa) / 100) * CBUQm3 + Fresagemm3 * (Hrec(IFaixa) / 100) + Ncamadas * Pintura
              CASE "RRP"
                        IF Hrec(IFaixa) <= 7! THEN
                           Ncamadas = 1
                        ELSE
                           IF Hrec(IFaixa) <= 14! THEN
                              Ncamadas = 2
                           ELSE
                              Ncamadas = 3
                           END IF
                        END IF
                        Custo = Remocao * Hfres(IFaixa) / 100
                        H2CM = Hfres(IFaixa) - Hrec(IFaixa)
                        Custo = Custo + (Hrec(IFaixa) / 100) * CBUQm3 + (H2CM / 100) * BGm3 + Ncamadas * Pintura
              CASE "RRT"
                        IF Hrec(IFaixa) <= 7! THEN
                           Ncamadas = 1
                        ELSE
                           IF Hrec(IFaixa) <= 14! THEN
                              Ncamadas = 2
                           ELSE
                              Ncamadas = 3
                           END IF
                        END IF
                        Custo = Remocao * Hfres(IFaixa) / 100
                        H2CM = Hfres(IFaixa) - Hrec(IFaixa) - 20
                        Custo = Custo + (Hrec(IFaixa) / 100) * CBUQm3 + (H2CM / 100) * BGm3 + Ncamadas * Pintura
              CASE ELSE
                        PRINT "ERRO: medida nao identificada."
                        PRINT Medida$
                        STOP
       END SELECT
       Custo = Custo * Aream2(ISTH, IFaixa)
       RETURN


1000 ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -              Necessidades Atuais de Manutencao              -
     ' -                         (Subrotina)                         -
     ' -  Dados: PSI, H1, VR, QI, Age, NYEAR, VSMIN,                 -
     ' -         Estado de Superficie, Parametros de decisao, HRDP,  -
     ' -         HRTR, H1TR, H2DP, HRQI, HRMPD                       -
     ' -  Saida: Medida$, HC, HR, H1NOVO, H2NOVO                     -
     ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     
     Medida$ = ""
     HC = 0!
     CATEGORIA$ = "CONSERVACAO"

     HR = HRMPD
     IRest = 0
     IF (ATR$ = "A3" OR ATR$ = "M3" OR ATR$ = "A2") THEN
        IF HRDP > HR THEN
             HR = HRDP
             IRest = 1
        END IF
     END IF
     IF HRTR > HR THEN
                       HR = HRTR
                       IRest = 2
     END IF
     IF HRQI > HR THEN
                       HR = HRQI
                       IRest = 3
     END IF
     IF HRatr > HR THEN IRest = 4
     IF H1 >= 6! THEN
                 Fresavel$ = "Sim"
                 HCMAX = H1 - 3
     ELSE
                 Fresavel$ = "Nao"
     END IF
     IF (PSIacost(IFaixa) >= 3! AND DegrauAcost(IFaixa) <= DEGRAUadm) THEN
                 Fresar$ = "Sim"
     ELSE
                 Fresar$ = "Nao"
     END IF
     IF (CR$ = "A2" OR CR$ = "A3" OR CR$ = "M3" OR BL$ = "A3" OR TT$ = "A3" OR TL$ = "A3") THEN
                  ICRACK = 1
     ELSE
                  ICRACK = 0
     END IF
     IF (ATRmed > 15 OR COR$ = "A3" OR EM$ = "A3" OR DP$ = "A3" OR EL$ = "A3") THEN
                 IDP = 1
     ELSE
                 IDP = 0
     END IF
     IF HR < HRmin THEN HR = HRmin

     ' Deciso quanto  categoria de interveno requerida
     IF Restaurado$(IFaixa) = "Nao" THEN

         IF (PSI <= PSIf OR VR < .1) THEN CATEGORIA$ = "RESTAURACAO"
         IF TR23 > TRcrit THEN CATEGORIA$ = "RESTAURACAO"
         IF ATRmed > ATRcrit THEN CATEGORIA$ = "RESTAURACAO"
         IF QI > QIcrit THEN CATEGORIA$ = "RESTAURACAO"

       ' Detalhamento da Medida$ a ser aplicada
         
       IF CATEGORIA$ = "CONSERVACAO" THEN

          IF UltCamada$(IFaixa) = "CCP" THEN
            IF PSR > 4! THEN Medida$ = "CR" ELSE Medida$ = "CL"
          ELSE
            IF (D$ = "A3" OR DS$ = "A") THEN
               IF VSCP >= VUMin THEN
                  Medida$ = "CP"
                  HR = HRCP(IRodov)
                  HC = 0!
               ELSE
                  CATEGORIA$ = "RESTAURACAO"
               END IF
            ELSE
               IF TR23 > 10 THEN
                  IF VSCP >= VUMin THEN
                     Medida$ = "CP"
                     HR = HRCP(IRodov)
                     HC = 0!
                  ELSE
                     Medida$ = "ST"
                  END IF
               ELSE
                 IF (BL$ = "B3" OR CR$ = "B2" OR CR$ = "M2" OR BL$ = "M2" OR TT$ = "B3" OR TT$ = "M3" OR TL$ = "B3" OR TL$ = "M3") THEN
                    Medida$ = "ST"
                 ELSE
                    IF (DP$ = "B3" OR EL$ = "B3" OR CR$ = "B3" OR P$ = "B3" OR P$ = "B2" OR P$ = "B1") THEN
                       Medida$ = "CL"
                    ELSE
                       IF (PSR < 4! OR IDS > 20) THEN
                            Medida$ = "CL"
                       ELSE
                            Medida$ = "CR"
                       END IF
                    END IF
                 END IF
               END IF
            END IF
          END IF

       END IF

       IF CATEGORIA$ = "RESTAURACAO" THEN

          IF UltCamada$(IFaixa) = "CCP" THEN
            
             IF PSI < 1.5 THEN
                    CATEGORIA$ = "RECONSTRUCAO"
                    Medida$ = "RRT"
                    H1NOVO = H1
                    H2NOVO = 15
                    HR = H1
                    HC = H1NOVO + H2NOVO + 20
             ELSE
                    CATEGORIA$ = "RESTAURACAO"
                    HRreflex = 10
                    IF HRMPD < HRreflex THEN HR = HRreflex ELSE HR = HRMPD
                    Medida$ = "MF+RC"
                    HC = 0
             END IF
         
          ELSE

            IF (PSI < PSRcrit AND IDS > IDScrit) THEN
             
               CATEGORIA$ = "RECONSTRUCAO"
               IF (TE$ = "A3" OR DC$ = "A3" OR COR$ = "A3" OR EM$ = "A3") THEN
                  IF BF$ = "A3" THEN
                        Medida$ = "RRP"
                        H1NOVO = H1TR
                        H2NOVO = H2DP
                        HR = H1NOVO
                        HC = H1NOVO + H2NOVO
                  ELSE
                        Medida$ = "RRV"
                        H1NOVO = H1TR
                        HR = H1NOVO
                        HC = H1NOVO
                  END IF
               ELSE
                  Medida$ = "RRT"
                  H1NOVO = H1TR
                  H2NOVO = H2DP
                  HR = H1NOVO
                  HC = H1NOVO + H2NOVO + 20
               END IF

            ELSE

               CATEGORIA$ = "RESTAURACAO"
               IF IDP = 1 THEN
                    IF Fresavel$ = "Sim" THEN
                          Medida$ = "FR+RC"
                          IF HR > HCMAX THEN
                             HC = HCMAX
                          ELSE
                             HC = HR
                          END IF
                          IF HC < HCMIN THEN HC = HCMIN
                    ELSE
                          Medida$ = "MF+RC"
                          HC = 0
                    END IF
               ELSE
                    IF ICRACK = 1 THEN
                     IF Fresar$ = "Nao" THEN
                       Medida$ = "MF+RC"
                       HC = 0
                     ELSE
                       IF Fresavel$ = "Sim" THEN
                          Medida$ = "FR+RC"
                          IF HR > HCMAX THEN
                               HC = HCMAX
                          ELSE
                               HC = HR
                          END IF
                          IF HC < HCMIN THEN HC = HCMIN
                       ELSE
                          Medida$ = "MF+RC"
                          HC = 0
                       END IF
                     END IF
                    ELSE
                       HC = 0
                       IF IRest = 4 THEN
                             IF HR = HRmin THEN
                                    Medida$ = "RS"
                                    IF HR < HRatr THEN HR = HRatr
                             ELSE
                                    Medida$ = "MF+RC"
                             END IF
                       ELSE
                             Medida$ = "RS"
                       END IF
                    END IF
               END IF

               IF HR > HRMAX THEN
                        CATEGORIA$ = "RECONSTRUCAO"
                        Medida$ = "RRP"
                        H1NOVO = H1TR
                        H2NOVO = H2DP
                        HR = H1NOVO
                        HC = H1NOVO + H2NOVO
               END IF

            END IF
         
          END IF

       END IF

     ELSE

       IF PSI > 4! THEN
              Medida$ = "CR"
       ELSE
              IF PSI > PSIf THEN
                     Medida$ = "CL"
              ELSE
                     IF PSI > PSRcrit THEN
                            CATEGORIA$ = "RESTAURACAO"
                            Medida$ = "RS"
                     ELSE
                            CATEGORIA$ = "RECONSTRUCAO"
                            IF PSI > .5 THEN
                                   Medida$ = "RRP"
                            ELSE
                                   Medida$ = "RRT"
                            END IF
                     END IF
              END IF
       END IF

     END IF
     IF (Medida$ = "CR" OR Medida$ = "CL" OR Medida$ = "ST") THEN HR = 0

     RETURN


1200 ' - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -       Necessidades de Reforco Estrutural      -
     ' -                  (Subrotina)                  -
     ' -  Dados: H1, HT, CBRSL, NYEAR, PP, DC, QI      -
     ' -  Saida: HRDP, HRTR, H1TR, H2DP, HRMPD         -
     ' - - - - - - - - - - - - - - - - - - - - - - - - -
    
     ' Espessura de reforco efetiva existente
       IF Restaurado$(IFaixa) = "Sim" THEN
              FCovl = FCrecap
       ELSE
              IF IRec(IFaixa) = 1 THEN
                     IF ICalib(IFaixa) = 1 THEN
                            FCovl = ALPHA(IFaixa)
                     ELSE
                            FCovl = FCrecaprede(IRodov)
                     END IF
              ELSE
                     FCovl = FCrecaprede(IRodov)
              END IF
       END IF
       B = 30
       P = 4100 / (PI# * B * B / 4)
       E = 2 * (1 - .33 * .33) * P * (B / 2) / (DC / 1000)
       MR = E / .0703
       A1 = .44
       IF VR > 0 THEN
          PERIODO = VR
          GOSUB 6700
          SNP = A1 * .5 / 2.54
          NP = 0
          WHILE NP < NPA
                SNP = SNP + .05
                HRmodel = 2.54 * SNP / A1
                QIest = QI
                HR = HRmodel
                HC = 0
                GOSUB 6900
                QID = QIest
                PSIQI = 5 * EXP(-QID / 71.5)
                PSR = 5
                PSI0 = (PSIQI + PSR) / 2
                IF PSI0 > 4.95 THEN PSI0 = 4.95
                DPSI = PSI0 - 2.5
                IF DPSI > 0 THEN
                   BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                   W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                   W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
                   ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
                   ALFA = ALFAA * FCovl
                   NP = (1 / ALFA) * LOG(LOG(PSIf / 5) / LOG(PSI0 / 5))
                END IF
          WEND
          Heff(IFaixa) = HRmodel
       ELSE
          Heff(IFaixa) = 0
       END IF

     ' Espessura de reforco em CBUQ requerida pelo modelo de previsao de desempenho
       PERIODO = PP
       GOSUB 6700
       SNP = A1 * .5 / 2.54
       NP = 0
       WHILE NP < NPA
             SNP = SNP + .05
             HRmodel = 2.54 * SNP / A1
             HR = HRmodel
             HC = 0
             QIest = QI
             GOSUB 6900
             QID = QIest
             PSIQI = 5 * EXP(-QID / 71.5)
             PSR = 5
             PSI0 = (PSIQI + PSR) / 2
             IF PSI0 > 4.95 THEN PSI0 = 4.95
             DPSI = PSI0 - 2.5
             IF DPSI > 0 THEN
                BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
                ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
                ALFA = ALFAA * FCrecap
                NP = (1 / ALFA) * LOG(LOG(PSIf / 5) / LOG(PSI0 / 5))
             END IF
       WEND
       HRMPD = HRmodel
       IF HRMPD < 0 THEN HRMPD = 0
       IF UltCamada$(IFaixa) = "CCP" THEN
               HRreflex = 1.364 * PP
               IF HRreflex > HRMPD THEN HRMPD = HRreflex
       END IF

       ' Revestimento requerido pelo Metodo do DNER
         NPUSACE = 3 * NPA
         H1TR = 4.4608 + 2.131 * LOG(NPUSACE)
         IF H1TR < HRmin THEN H1TR = HRmin
         HRTR = H1TR - H1
         IF HRTR < 0 THEN HRTR = 0
       ' Camada de Base pelo modelo de previsao de desempenho
         SNP = .5
         NP = 0
         WHILE NP < NPA
               SNP = SNP + .1
               IF QI0adm > 0 THEN QID = QI0adm ELSE QID = 19
               PSIQI = 5 * EXP(-QID / 71.5)
               PSR = 5
               PSI0 = (PSIQI + PSR) / 2
               IF PSI0 > 4.95 THEN PSI0 = 4.95
               DPSI = PSI0 - 2.5
               IF DPSI > 0 THEN
                  MR = 100 * CBRSL / .0703
                  BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
                  W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                  W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
                  ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
                  ALFA = ALFAA * FCnovo
                  NP = (1 / ALFA) * LOG(LOG(PSIf / 5) / LOG(PSI0 / 5))
               END IF
         WEND
         H2DP = (2.54 * SNP - .44 * H1TR) / .14
         IF H2DP < 12 THEN H2DP = 12

       ' Espessura de recapeamento requerida para eliminar ATR
         ATRadm = 1
         IF ATRmed > ATRadm THEN
               Nrecaps = LOG(ATRadm / ATRmed) / LOG(.15)
               IF Nrecaps < 1 THEN
                    NR = 1
               ELSE
                    NR = Nrecaps - INT(Nrecaps)
                    IF NR > .2 THEN NR = INT(Nrecaps) + 1 ELSE NR = INT(Nrecaps)
               END IF
         ELSE
               NR = 0
         END IF
         HRatr = NR * HRmin

    RETURN

2000 ' - - - - - - - - - - - - - - - - - -
     ' -  INTERVENCAO NOS ACOSTAMENTOS   -
     ' -           (Subrotina)           -
     ' - - - - - - - - - - - - - - - - - -
       SELECT CASE MedidaAcost$(IFaixa)
              CASE "CR"
                          Custo = 0
              CASE "CL"
                          PerctReparos = 100 * EXP(-2.3026 * PSIacost(IFaixa))
                          Custo = (.5 * CLm2) * PerctReparos / 100
              CASE "TSS"
                          Custo = TSSm2
              CASE "TSD"
                          Custo = TSDm2
              CASE "PMF"
                          Custo = (HRAC(IFaixa) / 100) * PMFm3 + Pintura
              CASE "RRP", "RRT"
                          Custo = (Remocao * H2AC(IFaixa) / 100) + TSDm2 + (H2AC(IFaixa) / 100) * BaseAcostm3
              CASE ELSE
                        PRINT "ERRO: Medida desconhecida = "; MedidaAcost$(IFaixa); " na faixa "; IFaixa
                        STOP
       END SELECT
   
     RETURN

3000 ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -      Evolucao da Condicao do Pavimento apos um Ano    -
     ' -                      (Subrotina)                      -
     ' -  Dados: H1, SN, Age, Nacum, CBRSL, PSI, IRI0(IFaixa)  -
     ' -         ALPHA(IFaixa), Nano, QIest, HRef(IFaixa),     -
     ' -         IRec(IFaixa)                                  -
     ' -  Saida: PSI, QIest                                    -
     ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
       
       DELTAT = 1
       NYEAR = Nano(IFaixa) / 1000000!
    
       ' Evolucao do PSI:
         DELTAN = DELTAT * NYEAR
         PT = 2.5
         DPSI = PSInovo(IFaixa) - PT
         IF IRec(IFaixa) = 0 THEN
              
            MR = 100 * CBRSL / .0703
            IF UltCamada$(IFaixa) = "CBUQ" THEN
                   VRmax = 25
                   VRmin = 2
                   BETA = .4 + (1094 / ((SN(IFaixa) + 1) ^ 5.19))
                   W18# = (((SN(IFaixa) + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                   W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
            ELSE
                   VRmax = 45
                   VRmin = 4
                   K = MR / 19.4
                   D = H1 / 2.54
                   CD = 1
                   J = 3.2
                   RTF = 650
                   RTFMPA = RTF * .0703 / 10
                   RCS = 10 * ((RTFMPA / .56) ^ 1.67)
                   EC = 15110 * (RCS ^ .5)
                   EC = EC / .0703
                   S0 = .35
                   NC = 50
                   ZR = 0
                   W18# = 215.63 * J * ((D ^ .75) - (18.42 / ((EC / K) ^ .25)))
                   W18# = (4.22 - .32 * PT) * LOG(RTF * CD * ((D ^ .75) - 1.132) / W18#) / LOG(10)
                   A# = (LOG(DPSI / (4.5 - 1.5)) / LOG(10)) / (1 + (1.624E+07 / ((D + 1) ^ 8.46)))
                   W18# = W18# + A# - .06 + 7.35 * (LOG(D + 1) / LOG(10)) + ZR * S0
                   W18# = (10 ^ W18#) / 1000000!
            END IF
            ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo(IFaixa) / 5))
            ALFA = ALFAA * ALPHA(IFaixa)
            DeltaPSI = ALFA * DELTAN * PSI * LOG(PSI / 5)
         
         ELSE

            IF UltCamada$(IFaixa) = "CBUQ" THEN
                 VRmax = 25
                 VRmin = 2
                 SNrecap = .44 * HRef(IFaixa) / 2.54
                 MR = MRfound(IFaixa) / .0703
                 BETA = .4 + (1094 / ((SNrecap + 1) ^ 5.19))
                 W18# = (((SNrecap + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                 W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
                 ALFAA = (1 / W18#) * LOG(LOG(2.5 / 5) / LOG(PSInovo(IFaixa) / 5))
                 ALFA = ALFAA * ALPHA(IFaixa)
                 DeltaPSI = ALFA * DELTAN * PSI * LOG(PSI / 5)
            ELSE
                 VRmax = 12
                 VRmin = 1
                 DeltaPSI = -(A0rest(IRodov) + B0rest(IRodov) * D0(IFaixa)) * DELTAN
            END IF

         END IF
         dPSIdtmin = 2! / VRmax
         dPSIdtmax = 2! / VRmin
         DPSImin = dPSIdtmin * DELTAT
         DPSImax = dPSIdtmax * DELTAT
         IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
         IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
         PSI = PSI + DeltaPSI
         IF PSI < .05 THEN PSI = .05

       ' Evolucao da Irregularidade:
         IF UltCamada$(IFaixa) <> "CCP" THEN
            NE4 = Nacum(IFaixa) / 1000000!
            LCBR = LOG(CBRSL) / LOG(10)
            SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
            DeltaIRI = DELTAT * (.0153 * IRI0(IFaixa) + 725 * ((1 + SNC) ^ -4.99) * (NYEAR + .0153 * NE4)) * EXP(.0153 * Age)
            IRIest = QIest / 13
            IRIest = IRIest + DeltaIRI
            QIest = 13 * IRIest
         ELSE
            QIest = 71.5 * LOG(5 / PSI)
         END IF

     RETURN

4000 ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     ' -         Aplicacao da Medida de Manutencao Indicada        -
     ' -                        (Subrotina)                        -
     ' -   Dados: Medida$, PSI, ATR, QIest, HR, HC, H1             -
     ' -   Saida: PSI, ATR, TR, QIest, Age, HR, H1, SN             -
     ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
       SELECT CASE Medida$
              CASE "RRP", "RRT"
                                 PSI = 4.5
                                 PSInovo(IFaixa) = PSI
                                 QIest = 71.5 * LOG(5! / PSI)
                                 ATRmed = 0!
                                 Age = 0!
                                 IDS = 0
                                 IRI0(IFaixa) = QIest / 13
                                 IF D0(IFaixa) > 45 THEN D0(IFaixa) = 45
                                 SNnovo = .44 * (HR / 2.54) + .14 * (HC / 2.54)
                                 IF (SNnovo > SN(IFaixa)) THEN SN(IFaixa) = SNnovo
                                 UltCamada$(IFaixa) = "CBUQ"
                                 Restaurado$(IFaixa) = "Sim"
                                 ALPHA(IFaixa) = FCnovo
                                 HrecExist(IFaixa) = 0
                                 HRef(IFaixa) = HR
                                 IRec(IFaixa) = 0
              CASE "FR+RC", "RS", "MF+RC", "RRV"
                                 GOSUB 6900
                                 ATRmed = .15 * ATRmed
                                 Age = 0!
                                 SN(IFaixa) = SN(IFaixa) + ((.44 * HR - .35 * HC) / 2.54)
                                 PSIQI = 5! * EXP(-QIest / 71.5)
                                 PSR = 5
                                 PSI = (PSR + PSIQI) / 2
                                 IF PSI > 4.95 THEN PSI = 4.95
                                 PSInovo(IFaixa) = PSI
                                 IRI0(IFaixa) = QIest / 13
                                 H1 = H1 + HR - HC
                                 UltCamada$(IFaixa) = "CBUQ"
                                 Restaurado$(IFaixa) = "Sim"
                                 ALPHA(IFaixa) = FCrecap
                                 HrecExist(IFaixa) = HR
                                 DC = D0(IFaixa) * EXP((.35 / .44) * HC / 40)
                                 B = 30
                                 P = 4100 / (PI# * B * B / 4)
                                 MRfound(IFaixa) = 2 * (1 - .33 * .33) * P * (B / 2) / (DC / 1000)
                                 D0(IFaixa) = DC * EXP(-HR / 40)
                                 HRef(IFaixa) = HR + Heff(IFaixa)
                                 IRec(IFaixa) = 1
              CASE "CP"
                                 PSI = PSR0rest(IRodov)
                                 HR = HRCP(IRodov)
                                 HC = 0
                                 ATRmed = .85 * ATRmed
                                 GOSUB 6900
                                 ' Efeito estrutural
                                   H1 = H1 + HRCP(IRodov)
                                 UltCamada$(IFaixa) = CamadaRest$(IRodov)
                                 Restaurado$(IFaixa) = "Sim"
                                 IRec(IFaixa) = 1
              CASE "CL", "ST"
                                 FatorPSI = 1!
                                 DeltaPSI = (FatorPSI - 1) * PSI
                                 DeltaQI = -71.5 * DeltaPSI / PSI
                                 PSI = FatorPSI * PSI
                                 IF (PSI > PSInovo(IFaixa)) THEN PSI = PSInovo(IFaixa)
                                 QIest = QIest + DeltaQI
              CASE "CR"
             
              CASE ELSE
                                 PRINT "ERRO": STOP
       END SELECT
       RETURN

6500 ' - - - - - - - - - - - - - - - - - - - - - - - -
     ' -    Calculo da Vida Residual do Pavimento    -
     ' -                 (Subrotina)                 -
     ' -  Dados: PSI, PSIf, ALPHA(IFaixa)            -
     ' -  Saida: VR                                  -
     ' - - - - - - - - - - - - - - - - - - - - - - - -
       DELTAT = .1
       NYEAR = Nano(IFaixa) / 1000000!
       IF UltCamada$(IFaixa) = "CBUQ" THEN
          VRmax = 25
          VRmin = 2
          dPSIdtmin = 2! / VRmax
          dPSIdtmax = 2! / VRmin
          DPSImin = dPSIdtmin * DELTAT
          DPSImax = dPSIdtmax * DELTAT
          DPSI = PSInovo(IFaixa) - 2.5
          IF HrecExist(IFaixa) = 0 THEN
                 BETA = .4 + (1094 / ((SN(IFaixa) + 1) ^ 5.19))
                 MR = 100 * CBRSL / .0703
                 W18 = (((SN(IFaixa) + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                 W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
          ELSE
                 SNrecap = .44 * HRef(IFaixa) / 2.54
                 MR = MRfound(IFaixa) / .0703
                 BETA = .4 + (1094 / ((SNrecap + 1) ^ 5.19))
                 W18 = (((SNrecap + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                 W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
          END IF
          ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSInovo(IFaixa) / 5))
          ALFA = ALFAA * ALPHA(IFaixa)

          VR = 0
          PSIatual = PSI
          IF PSIatual > PSIf THEN
             WHILE (PSIatual > PSIf AND VR < VRmax)
                   VR = VR + DELTAT
                   DELTAN = DELTAT * NYEAR * (FatorTraf ^ VR)
                   DeltaPSI = ALFA * DELTAN * PSIatual * LOG(PSIatual / 5)
                   IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
                   IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
                   PSIatual = PSIatual + DeltaPSI
             WEND
          END IF
       ELSE
              IF UltCamada$(IFaixa) = "CCP" THEN
                      VRmax = 45
                      VRmin = 4
              ELSE
                      VRmax = 7
                      VRmin = 1
              END IF
              dPSIdtmin = 2! / VRmax
              dPSIdtmax = 2! / VRmin
              DPSImin = dPSIdtmin * DELTAT
              DPSImax = dPSIdtmax * DELTAT
              VR = 0
              PSIatual = PSI
              IF PSIatual > PSIf THEN
                 DELTAN = DELTAT * NYEAR * (FatorTraf ^ VR)
                 WHILE (PSIatual > PSIf AND VR < VRmax)
                       VR = VR + DELTAT
                       IF UltCamada$(IFaixa) = "CCP" THEN
                              DeltaPSI = ALPHA(IFaixa) * DELTAN * PSIatual * LOG(PSIatual / 5)
                       ELSE
                              DeltaPSI = -(A0rest(IRodov) + B0rest(IRodov) * D0(IFaixa)) * DELTAN
                       END IF
                       IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
                       IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
                       PSIatual = PSIatual + DeltaPSI
                 WEND
              END IF
       END IF
       IF VR = DELTAT THEN VR = 0
       RETURN

8000 ' - - - - - - - - - - - - - - - - - - - - - - -
     ' -  Compatibilizacao Geometrica de Solucoes  -
     ' -          entre Faixas de Trafego          -
     ' -                (Subrotina)                -
     ' - - - - - - - - - - - - - - - - - - - - - - -
     CotaMax = 0
     FaixaMax = 1
     CotaMin = 1000
     FaixaMin = 1
     FOR IFaixa = 1 TO NFaixas(ISTH)
         IFX = IFaixa
         GOSUB 8700
         CotaFaixa(IFaixa) = Cota
         IF CotaFaixa(IFaixa) > CotaMax THEN
                 CotaMax = CotaFaixa(IFaixa)
                 FaixaMax = IFaixa
         END IF
         IF CotaFaixa(IFaixa) < CotaMin THEN
                 CotaMin = CotaFaixa(IFaixa)
                 FaixaMin = IFaixa
         END IF
     NEXT IFaixa
     Compat$ = "Nao"
     FOR IFaixa = 1 TO NFaixas(ISTH)
         IF CotaFaixa(IFaixa) < CotaMax THEN Compat$ = "Sim"
     NEXT IFaixa
     FOR IFaixa = 1 TO NFaixas(ISTH)
         IF IPRIOR(ISTH, IFaixa) >= IPFORC0 THEN Compat$ = "Nao"
     NEXT IFaixa
     IF Compat$ = "Nao" THEN 8100
     ' Compatibiliza as duas faixas nos extremos de greide da pista
       Cota1 = CotaMin
       Cota2 = CotaMax
       Delta = ABS(Cota1 - Cota2)
       IF Delta > 0 THEN
          I1 = FaixaMin
          I2 = FaixaMax
          IF Delta <= 1 THEN
                SELECT CASE MedidaF$(I1)
                       CASE "RS", "MF+RC", "FR+RC", "RRV", "RRP", "RRT"
                                  Hrec(I1) = Hrec(I1) + Delta
                       CASE "CP"
                                  MedidaF$(I1) = "RS"
                                  Hfres(I1) = 0
                                  Hrec(I1) = Hrec(I1) + Delta
                                  IF Hrec(I1) < HRmin THEN
                                          Delta = HRmin - Hrec(I1)
                                          Hrec(I2) = Hrec(I2) + Delta
                                          Hrec(I1) = HRmin
                                  END IF
                       CASE ELSE
                                  HRnovo = Hrec(I2) - Delta
                                  IF HRnovo < HRmin THEN
                                         MedidaF$(I1) = "RS"
                                         Hfres(I1) = 0
                                         Hrec(I1) = Hrec(I1) + Delta
                                         IF Hrec(I1) < HRmin THEN
                                            Delta = HRmin - Hrec(I1)
                                            Hrec(I2) = Hrec(I2) + Delta
                                            Hrec(I1) = HRmin
                                         END IF
                                  ELSE
                                         Hrec(I2) = HRnovo
                                  END IF
                END SELECT
          ELSE
                IF UltCamada$(I2) = "CCP" THEN
                       HCMAX = 0
                ELSE
                       HCMAX = H1REV(I2) - Hfres(I2) - 3
                END IF
                IF Hfres(I2) > 0 THEN
                       IF HCMAX < 0 THEN HCMAX = 0
                ELSE
                       IF HCMAX < HCMIN THEN HCMAX = 0
                END IF
                IF Delta <= HCMAX THEN
                   ' O desnivel pode ser resolvido aprofundando a fresagem na faixa I2
                     IFX = I2
                     GOSUB 8500
                ELSE
                   ' O desnivel nao pode ser resolvido apenas aprofundando a fresagem na faixa I2
                     HCnovo = Hfres(I2) + HCMAX
                     IF HCnovo >= HCMIN THEN
                            ' Um aprofundamento da fresagem em I2 eh possivel
                              MedidaF$(I2) = "FR+RC"
                              Hfres(I2) = HCnovo
                              Cota2 = Hrec(I2) - Hfres(I2)
                              Delta = ABS(Cota1 - Cota2)
                     END IF
                     SELECT CASE MedidaF$(I1)
                            CASE "CR", "CL", "ST", "CP"
                                          MedidaF$(I1) = "RS"
                                          Hfres(I1) = 0
                                          HRnovo = Delta + Hrec(I1)
                                          IF HRnovo >= HRmin THEN
                                                 Hrec(I1) = HRnovo
                                          ELSE
                                                 Hrec(I1) = HRmin
                                                 Cota1 = Hrec(I1) - Hfres(I1)
                                                 Delta = ABS(Cota1 - Cota2)
                                                 Hrec(I2) = Hrec(I2) + Delta
                                          END IF
                            CASE "RS", "MF+RC", "FR+RC"
                                          Hrec(I1) = Hrec(I1) + Delta
                            CASE "RRV", "RRP", "RRT"
                                          Hfres(I1) = Hfres(I1) - Delta
                            CASE ELSE
                                          PRINT "ERRO": STOP
                     END SELECT
                END IF
          END IF
       END IF
       ' Elevacao de cota resultante da compatibilizacao, a ser fixada como
       '   restricao para as demais faixas:
           IFX = FaixaMax
           GOSUB 8700
           Cota2 = Cota
     ' As demais faixas se ajustam a FaixaMin e FaixaMax, jah compatibilizadas
       FOR IFaixa = 1 TO NFaixas(ISTH)
         IF (IFaixa <> FaixaMin AND IFaixa <> FaixaMax) THEN
            ' Elevacao de cota apos a restauracao
              IFX = IFaixa
              GOSUB 8700
              Cota1 = Cota
            Delta = Cota2 - Cota1
            IF Delta > 0 THEN
                   SELECT CASE MedidaF$(IFaixa)
                          CASE "CR", "CL", "ST", "CP"
                                    HRnovo = Hrec(IFaixa) + Delta
                                    IF HRnovo >= HRmin THEN
                                            MedidaF$(IFaixa) = "RS"
                                            Hfres(IFaixa) = 0
                                            Hrec(IFaixa) = HRnovo
                                    ELSE
                                            MedidaF$(IFaixa) = "FR+RC"
                                            Hfres(IFaixa) = HCMIN
                                            Hrec(IFaixa) = Hfres(IFaixa) + Cota2
                                    END IF
                          CASE "RS", "MF+RC", "FR+RC"
                                    Hrec(IFaixa) = Hrec(IFaixa) + Delta
                          CASE "RRV", "RRP", "RRT"
                                    Hfres(IFaixa) = Hfres(IFaixa) - Delta
                          CASE ELSE
                                    PRINT "ERRO": STOP
                   END SELECT
            ELSE
                   Delta = ABS(Delta)
                   IF UltCamada$(IFaixa) = "CCP" THEN
                          HCMAX = 0
                   ELSE
                          HCMAX = H1REV(IFaixa) - Hfres(IFaixa) - 3
                   END IF
                   IF Hfres(IFaixa) > 0 THEN
                          IF HCMAX < 0 THEN HCMAX = 0
                   ELSE
                          IF HCMAX < HCMIN THEN HCMAX = 0
                   END IF
                   IF Delta <= HCMAX THEN
                      ' O desnivel pode ser resolvido aprofundando a fresagem em IFaixa
                        IFX = IFaixa
                        GOSUB 8500
                   ELSE
                      ' O desnivel nao pode ser resolvido apenas aprofundando a fresagem em IFaixa
                        MedidaF$(IFaixa) = MedidaF$(FaixaMax)
                        Hfres(IFaixa) = Hfres(FaixaMax)
                        Hrec(IFaixa) = Hrec(FaixaMax)
                   END IF
            END IF
         END IF
       NEXT IFaixa
8100   ' Solucao para os Acostamentos, apos a compatibilizacao da pista
         CotaMax = 0
         FOR IFaixa = 1 TO NFaixas(ISTH)
             IFX = IFaixa
             GOSUB 8700
             CotaFaixa(IFaixa) = Cota
             IF CotaFaixa(IFaixa) > CotaMax THEN CotaMax = CotaFaixa(IFaixa)
         NEXT IFaixa
         FOR IFaixa = 1 TO NFaixas(ISTH)
             HRACOST = CotaMax + DegrauAcost(IFaixa)
             IF HRACOST <= DEGRAUadm THEN
                     HRAC(IFaixa) = 0
                     IF PSIacost(IFaixa) >= 3.5 THEN MedidaAcost$(IFaixa) = "CR" ELSE MedidaAcost$(IFaixa) = "CL"
             ELSE
                     IF HRACOST <= (DEGRAUadm + 1.5) THEN
                                 HRAC(IFaixa) = 1!
                                 MedidaAcost$(IFaixa) = "TSS"
                     ELSE
                                 IF HRACOST <= (DEGRAUadm + 3!) THEN
                                             HRAC(IFaixa) = 2.5
                                             MedidaAcost$(IFaixa) = "TSD"
                                 ELSE
                                             IF HRACOST <= (DEGRAUadm + 7!) THEN
                                                         IF PSIacost(IFaixa) >= 2! THEN
                                                                      MedidaAcost$(IFaixa) = "PMF"
                                                                      HRAC(IFaixa) = 5!
                                                         ELSE
                                                                      MedidaAcost$(IFaixa) = "RRP"
                                                                      HRAC(IFaixa) = 2.5
                                                                      H2AC(IFaixa) = HbaseAcost
                                                         END IF
                                             ELSE
                                                         MedidaAcost$(IFaixa) = "RRT"
                                                         HRAC(IFaixa) = 2.5
                                                         H2AC(IFaixa) = (HRACOST - DEGRAUadm) - HRAC(IFaixa)
                                                         IF H2AC(IFaixa) < 12 THEN H2AC(IFaixa) = 12
                                             END IF
                                 END IF
                     END IF
             END IF
         NEXT IFaixa
       RETURN

8500 ' - - - - - - - - - - - - - - - - - - - - - -
     ' -   Compatibilizacao Geometrica (cont.)   -
     ' -               (Subrotina)               -
     ' - - - - - - - - - - - - - - - - - - - - - -
       IF MedidaF$(IFX) = "MF+RC" THEN Delta = Delta - 2
       IF Hfres(IFX) = 0 THEN
          IF MedidaF$(IFX) = "CP" THEN
                 Hfres(IFX) = HRmin - Hrec(IFX) + Delta
                 Hrec(IFX) = HRmin
          ELSE
                 Hfres(IFX) = Delta
          END IF
          MedidaF$(IFX) = "FR+RC"
          IF Hfres(IFX) < HCMIN THEN
                 Dif = HCMIN - Hfres(IFX)
                 Hfres(IFX) = HCMIN
                 Hrec(IFX) = Hrec(IFX) + Dif
          END IF
       ELSE
          Hfres(IFX) = Hfres(IFX) + Delta
       END IF
       RETURN

8700 ' - - - - - - - - - - - - - - - - - - - - - -
     ' -   Compatibilizacao Geometrica (cont.)   -
     ' -               (Subrotina)               -
     ' - - - - - - - - - - - - - - - - - - - - - -
       SELECT CASE MedidaF$(IFX)
              CASE "RS", "CP"
                           Cota = Hrec(IFX)
              CASE "FR+RC"
                           Cota = Hrec(IFX) - Hfres(IFX)
              CASE "MF+RC"
                           Cota = Hrec(IFX) + 2
              CASE ELSE
                           Cota = 0
       END SELECT
       RETURN

6700 ' - - - - - - - - - - - - -
     ' -   Trafego de Projeto  -
     ' -      (Subrotina)      -
     ' - - - - - - - - - - - - -
       NPA = 0
       PER = INT(PERIODO)
       FOR IAA = 1 TO PER
           NPA = NPA + (FatorTraf ^ IAA)
       NEXT IAA
       NPA = NPA + (FatorTraf ^ (PERIODO - PER))
       NPA = NPA * NYEAR / 1000000!
       RETURN

6900 ' - - - - - - - - - - - - - - - - - - - -
     ' -   Irregularidade apos Recapeamento  -
     ' -        (Subrotina do HDM-III)       -
     ' -   Dados: HR, HC, QIest, QI0adm      -
     ' -   Saida: QIest                      -
     ' - - - - - - - - - - - - - - - - - - - -
       IF QIest > 19 THEN
                          QIB = 19! + ((QIest - 19!) / (.602 * HC + 1))
       ELSE
                          QIB = QIest
       END IF
       IF QI0adm > 0 THEN
                          DQI = QI0adm - QIB
       ELSE
                          H0 = 10 * HR
                          IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
                          IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
                          IF H0 < 40 THEN X = H0 ELSE X = 40
                          HOV = 3 - ((H0L + X) / 40)
                          X1 = 19.42 - .78 * QIBL - .068 * H0
                          IF H0 > 20 THEN Y = H0 - 20 ELSE Y = 0
                          X2 = -19.5 - .008 * QIBL * Y
                          IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
                          IF DQI > 0 THEN DQI = 0
       END IF
       QIest = QIB + DQI
       RETURN

7000 ' - - - - - - - - - - - - - - - - -
     ' -   Trechos que Compoem a Rede  -
     ' -           (Subrotina)         -
     ' - - - - - - - - - - - - - - - - -
       IPolo = IRodov
       RETURN

