CLS

OPEN "SISTEMA.DAT" FOR INPUT AS #1
INPUT #1, SGP$
CLOSE #1
SGP$ = UCASE$(SGP$)

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4: NRodovMax = NRODOV: NEixosMax = 6
DIM H(NFaixasMax), Tipo$(NFaixasMax)
DIM PSR(NFaixasMax), CR$(NFaixasMax), BL$(NFaixasMax), TT$(NFaixasMax)
DIM TL$(NFaixasMax), TE$(NFaixasMax), TB$(NFaixasMax), P$(NFaixasMax)
DIM D$(NFaixasMax), DS$(NFaixasMax), ER$(NFaixasMax), BF$(NFaixasMax)
DIM DC$(NFaixasMax), R$(NFaixasMax), ATR$(NFaixasMax), COR$(NFaixasMax)
DIM EM$(NFaixasMax), DP$(NFaixasMax), EL$(NFaixasMax), PSRACOST(NFaixasMax)
DIM DEGRAUCM(NFaixasMax), OBS$(NFaixasMax), IGG(NFaixasMax), VDMUni(NFaixasMax)
DIM CARGADEF(NFaixasMax), D0(NFaixasMax), NPTS(NFaixasMax), HC(NFaixasMax)
DIM REVEST$(NFaixasMax), FX(NFaixasMax), Nacum(NFaixasMax), ALPHA(NFaixasMax)
DIM FV(NEixosMax), PERCT(NEixosMax), VidaRes(NFaixasMax), ALFAIGG(NFaixasMax)
DIM IRest(NFaixasMax), Trecho$(NRodovMax + 1), FCnovorede(NRodovMax)
DIM FCrecaprede(NRodovMax), FCccprede(NRodovMax), VI(NFaixasMax)
DIM QI(NFaixasMax), Heff(NFaixasMax), ALFA(NFaixasMax), ICalib(NFaixasMax)
DIM ALFAnew(NFaixasMax), TSUP(NFaixasMax), MRfound(NFaixasMax), PERCTRAF(NFaixasMax)
DIM PSIacost(NFaixasMax), DegrauAcost(NFaixasMax)

' Codigos de indentificacao das Pracas de Pedagio nos arquivos a serem gerados
ARQUIVO$ = DadosAnoBase$ + "PEDAGIOS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NPDG
INPUT #1, NCatTraf
ARQUIVO$ = DadosAnoBase$ + "PEDG.DAT"
OPEN ARQUIVO$ FOR INPUT AS #2
LINE INPUT #2, LINHA$
DIM Cat(NCatTraf), VolAnual(NCatTraf), Pdg$(NPDG), ISent(NPDG), PdgNome$(NPDG)
FOR I = 1 TO NPDG
    INPUT #1, PdgNome$(I)
    INPUT #1, ISent(I)
    INPUT #2, Pdg$(I)
NEXT I
CLOSE #1, #2

' - - - - - - - - - - - - - - - -
' -  PARAMETROS DE CONFIGURACAO -
' - - - - - - - - - - - - - - - -
    
' Tipos de dados de que a base de dados e' composta:
ARQUIVO$ = DADOS$ + "TIPODADO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NDADOS
DIM DADO$(15)
FOR I = 1 TO NDADOS
    INPUT #1, DADO$(I)
NEXT I
CLOSE #1
NDADOS = NDADOS - 1
DADO$(NDADOS) = "ATR"
NTIPOSDADOS = NDADOS
FOR IFX = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "SUP"
NEXT IFX
FOR IFX = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "DFX"
NEXT IFX

' Determina o numero maximo de Subtrechos Homogeneos por rodovia:
NSTHMAX = 0
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + DADO$(2) + Rodov$(I) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    NSTH = 0
    WHILE EOF(1) = FALSE
        LINE INPUT #1, LINHA$
        NSTH = NSTH + 1
    WEND
    NSTH = NSTH - 1
    NSTHRODOV(I) = NSTH
    IF NSTH > NSTHMAX THEN NSTHMAX = NSTH
    CLOSE #1
NEXT I
                      
' Leitura dos codigos numericos que identificam os Subtrechos Homogeneos:
DIM Code(NRODOV, NSTHMAX), NSTHI(NRODOV)
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "CODE" + Rodov$(I) + ".STH"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, NSTHI(I)
    FOR J = 1 TO NSTHI(I)
        INPUT #1, Code(I, J)
    NEXT J
    CLOSE #1
NEXT I

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax)
DIM Idade(NFaixasMax), PSIat(NSTH, NFaixasMax), NANO(NFaixasMax)
DIM Aream2(NSTH, NFaixasMax), VSMIN(NPP), PSIt(NPSITMAX), AreaAcost(NSTH, NFaixasMax)
DIM IRI0(NFaixasMax), IRI0PSI(NFaixasMax), SN(NFaixasMax)

CLS
PRINT
PRINT "                        * * * * * * * * * * * * * "
PRINT "                        *   ATUALIZA O TRAFEGO  * "
PRINT "                        * * * * * * * * * * * * * "
PRINT

ARQUIVO$ = CALC$ + "TRAFEGO.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
' Taxas anuais de crescimento do trafego
INPUT #1, Ano, TxAutos, TxCam, TxOn
TaxaAutos = (1 + (TxAutos / 100))
TaxaCam = (1 + (TxCam / 100))
TaxaOnibus = (1 + (TxOn / 100))
ICONT = 1
WHILE NOT EOF(1)
    INPUT #1, Ano, TxAutos, TxCam, TxOn
    TaxaAutos = TaxaAutos * (1 + (TxAutos / 100))
    TaxaCam = TaxaCam * (1 + (TxCam / 100))
    TaxaOnibus = TaxaOnibus * (1 + (TxOn / 100))
    ICONT = ICONT + 1
WEND
CLOSE #1
TaxaAutos = 100 * ((TaxaAutos ^ (1 / ICONT)) - 1)
TaxaCam = 100 * ((TaxaCam ^ (1 / ICONT)) - 1)
TaxaOnibus = 100 * ((TaxaOnibus ^ (1 / ICONT)) - 1)
ARQUIVO$ = CALC$ + "TRAFEGO.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, TaxaAutos
WRITE #1, TaxaCam
WRITE #1, TaxaOnibus
CLOSE #1

TAXACOMERC = (TaxaCam + TaxaOnibus) / 2
TaxaVDM = (TaxaAutos * (VDMunid - VDMcom) + TAXACOMERC * VDMcom) / VDMunid
FatorVDM = 1 + (TaxaVDM / 100)
FatorTraf = 1 + (TAXACOMERC / 100)

ARQUIVO$ = CALC$ + "ESTSTHS0.OUT"
OPEN ARQUIVO$ FOR INPUT AS #12
ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #13

ISTH = 0
FOR IRodov = 1 TO NRODOV

    ARQUIVO$ = CALC$ + "Fv_" + Rodov$(IRodov) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #1
    ' Fatores de Veiculo Adotados
    FOR NEIXOS = 2 TO 6
        INPUT #1, FV(NEIXOS)
    NEXT NEIXOS
    CLOSE #1

    I = 5
    EXT$ = ".CSV"
    ARQUIVO$ = CALC$ + DADO$(I) + Rodov$(IRodov) + EXT$
    OPEN ARQUIVO$ FOR INPUT AS #I
    LINE INPUT #I, LINHA$

    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #12, STH, NFaixas, KMI, KMF, FatorVDM0, FatorTraf0
        FOR IFaixa = 1 TO NFaixas
            INPUT #12, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
        NEXT IFaixa

        INPUT #5, SH$, Praca$, PERCTVDM, PERCTRAF(1), PERCTRAF(2), PERCTRAF(3), PERCTRAF(4), VDMunid, VDMeixos(2), VDMeixos(3), VDMeixos(4), VDMeixos(5), VDMeixos(6)
        Praca$ = UCASE$(Praca$)
        SELECT CASE Praca$
            CASE "CONTAGEM"
                IPDG = 0
            CASE "P1"
                IPDG = 1
            CASE "P2"
                IPDG = 2
            CASE "P3"
                IPDG = 3
            CASE "P4"
                IPDG = 4
            CASE "P5"
                IPDG = 5
            CASE "P6"
                IPDG = 6
            CASE "P7"
                IPDG = 7
            CASE "P8"
                IPDG = 8
            CASE "P9"
                IPDG = 9
            CASE "P10"
                IPDG = 10
            CASE "P11"
                IPDG = 11
            CASE "P12"
                IPDG = 12
            CASE "P13"
                IPDG = 13
            CASE "P14"
                IPDG = 14
            CASE "P15"
                IPDG = 15
            CASE "P16"
                IPDG = 16
            CASE "P17"
                IPDG = 17
            CASE "P18"
                IPDG = 18
            CASE "P19"
                IPDG = 19
            CASE "P20"
                IPDG = 20
            CASE "P21"
                IPDG = 21
            CASE "P22"
                IPDG = 22
            CASE "P23"
                IPDG = 23
            CASE "P24"
                IPDG = 24
            CASE "P25"
                IPDG = 25
            CASE "P26"
                IPDG = 26
            CASE "P27"
                IPDG = 27
            CASE "P28"
                IPDG = 28
            CASE "P29"
                IPDG = 29
            CASE "P30"
                IPDG = 30
            CASE "P31"
                IPDG = 31
            CASE "P32"
                IPDG = 32
            CASE "P33"
                IPDG = 33
            CASE "P34"
                IPDG = 34
            CASE "P35"
                IPDG = 35
            CASE "P36"
                IPDG = 36
            CASE "P37"
                IPDG = 37
            CASE "P38"
                IPDG = 38
            CASE "P39"
                IPDG = 39
            CASE "P40"
                IPDG = 40
            CASE "P41"
                IPDG = 41
            CASE "P42"
                IPDG = 42
            CASE "P43"
                IPDG = 43
            CASE "P44"
                IPDG = 44
            CASE ELSE
                ARQUIVO$ = CALC$ + "DEPURA.DAT"
                OPEN ARQUIVO$ FOR APPEND AS #16
                WRITE #16, "ERRO: pedagio desconhecido ==> ", Praca$, " em ", Rodov$(IRodov), " no Subtrecho No.: ", STH
                CLOSE #16
                IDepura = IDepura + 1
        END SELECT

        FOR IEIXOS = 1 TO NEixosMax
            PERCT(IEIXOS) = 0
        NEXT IEIXOS

        IF IPDG > 0 THEN

            Pedagio$ = Pdg$(IPDG)
            ARQUIVO$ = CALC$ + Pedagio$ + ".CSV"
            OPEN ARQUIVO$ FOR INPUT AS #15
            LINE INPUT #15, LINHA$
            VDM = 0

            FOR I = 1 TO NCatTraf

                INPUT #15, J, VolAnual(J)
                VDM = VDM + VolAnual(J)

                SELECT CASE SGP$

                    CASE "SGP17"

                        SELECT CASE J

                            CASE 1, 5, 9, 11, 12, 13
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2, 3
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8, 10
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP3\"

                        SELECT CASE J

                            CASE 1, 3, 5, 9, 10, 11, 12, 13, 14, 15
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGPC\", "SGPL\", "SGPM\", "SGP8\", "SGP10", "SGP11"

                        SELECT CASE J

                            CASE 1, 7, 8, 15
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2, 12
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 3, 13
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 4, 14
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 6, 9, 10, 11
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP5\", "SGP16"

                        SELECT CASE J

                            CASE 1, 2, 3
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 4, 9, 10
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP18"

                        SELECT CASE J

                            CASE 1, 7, 8
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 3
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP14"

                        SELECT CASE J

                            CASE 1, 2, 3
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP13"

                        SELECT CASE J

                            CASE 1, 7, 8, 10
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2, 3
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 9
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP23"

                        SELECT CASE J
                            CASE 1, 3, 5, 9
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8, 10, 11, 12, 13, 14
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP22"

                        SELECT CASE J

                            CASE 1, 7, 8, 9
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 3
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 6, 10, 11, 12
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP6\"

                        SELECT CASE J

                            CASE 1, 11
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2, 3
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 5, 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8, 9, 10
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE "SGP42"

                        SELECT CASE J

                            CASE 1, 3, 5, 9
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 4
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 6
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 7
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 8, 10, 11, 12, 13, 14
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                    CASE ELSE

                        SELECT CASE J
                            CASE 1, 7, 8, 15
                                ' Automoveis e motos
                                PERCT(1) = PERCT(1) + VolAnual(J)
                            CASE 2, 12
                                ' Veiculos comerciais de dois eixos
                                PERCT(2) = PERCT(2) + VolAnual(J)
                            CASE 3, 13
                                ' Veiculos comerciais de tres eixos
                                PERCT(3) = PERCT(3) + VolAnual(J)
                            CASE 4, 14
                                ' Veiculos comerciais de 4 eixos
                                PERCT(4) = PERCT(4) + VolAnual(J)
                            CASE 5
                                ' Veiculos comerciais de 5 eixos
                                PERCT(5) = PERCT(5) + VolAnual(J)
                            CASE 6, 9, 10, 11
                                ' Veiculos comerciais de 6 ou mais eixos
                                PERCT(6) = PERCT(6) + VolAnual(J)
                            CASE ELSE
                                GOSUB 10
                        END SELECT

                END SELECT

            NEXT I
            CLOSE #15

            VDMcom = 0
            FOR I = 2 TO 6
                VDMcom = VDMcom + PERCT(I) / 365
            NEXT I
            FVeic = 0
            FOR I = 2 TO 6
                PERCT(I) = (PERCT(I) / 365) / VDMcom
                FVeic = FVeic + FV(I) * PERCT(I)
            NEXT I
            VDMunid = VDM / 365

        ELSE

            VDMcom = 0
            FOR I = 2 TO 6
                VDMcom = VDMcom + VDMeixos(I)
            NEXT I
            FVeic = 0
            FOR I = 2 TO 6
                PERCT(I) = VDMeixos(I) / VDMcom
                FVeic = FVeic + FV(I) * PERCT(I)
            NEXT I

        END IF

        WRITE #13, STH, NFaixas, KMI, KMF, FatorVDM, FatorTraf

        FOR IFX = 1 TO NFaixas
            VDMUni(IFX) = (VDMunid - VDMcom) / NFaixas
            VDMc(IFX) = VDMcom * (PERCTRAF(IFX) / 100)
            VDMUni(IFX) = VDMUni(IFX) + VDMc(IFX)
            NANO(IFX) = VDMc(IFX) * FVeic * 365
            WRITE #13, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
            WRITE #13, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo(IFX), Heff(IFX), IRec(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            WRITE #13, ALPHA0(IFX), ALPHA(IFX), ALPHA2(IFX), AreaAcost(ISTH, IFX), PSIacost(IFX), DegrauAcost(IFX), T0(IFX), TR23(IFX), CBRSL(IFX), CamBase$(IFX), VDMc(IFX), ATRmed(IFX)
        NEXT IFX

    NEXT ISUB
    CLOSE #5
NEXT IRodov
 
INPUT #12, PSImed(0), NPSI(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
WRITE #13, PSImed(0), NPSI(0), VRmed(0)
WRITE #13, AreaTotal, NUnidAnalise
CLOSE #12, #13

SYSTEM

10 '
ARQUIVO$ = CALC$ + "DEPURA.DAT"
OPEN ARQUIVO$ FOR APPEND AS #16
WRITE #16, "ERRO: categoria de veiculo nao identificada no pedagio ", Pedagio$
CLOSE #16
IDepura = IDepura + 1
RETURN
