CLS
PRINT
PRINT "                   * * * * * * * * * * * * * * * * * * "
PRINT "                   *  VALORES DEFAULT PARA OS DADOS  * "
PRINT "                   * * * * * * * * * * * * * * * * * * "

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4: NRodovMax = 50
DIM TRAFSIMPLES(NFaixasMax, NFaixasMax), TRAFDUPLA(NFaixasMax, NFaixasMax)
DIM H(NFaixasMax), Tipo$(NFaixasMax), CARGADEF(NFaixasMax)
DIM Df(7, NFaixasMax), NPTS(NFaixasMax), FV(6), VDMUni(NFaixasMax)
DIM TAR(NFaixasMax), TSUP(NFaixasMax), RCM(7, NFaixasMax), FIPLACA(NFaixasMax)
DIM DATADEFLX$(NFaixasMax), EQUIPDEFLX$(NFaixasMax)
DIM ATResq(NFaixasMax), ATRdir(NFaixasMax), DSVesq(NFaixasMax), DSVdir(NFaixasMax)

' Constantes
PI# = 3.141592654#
NPAREA = 3
DIM XX(NPAREA), DD(NPAREA)
XX(1) = 30
XX(2) = 61
XX(3) = 91

' Tipos de dados de que a base de dados e' composta:
ARQUIVO$ = DADOS$ + "TIPODADO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NDADOS
DIM DADO$(15)
FOR I = 1 TO NDADOS
    INPUT #1, DADO$(I)
NEXT I
CLOSE #1
NTIPOSDADOS = NDADOS
FOR IFX = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "SUP"
NEXT IFX
FOR IFX = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "MOD"
NEXT IFX

' Determina o numero maximo de Subtrechos Homogeneos por rodovia:
NSTHMAX = 0
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + DADO$(2) + Rodov$(I) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    NSTH = 0
    WHILE EOF(1) = FALSE
        LINE INPUT #1, LINHA$
        NSTH = NSTH + 1
    WEND
    NSTH = NSTH - 1
    NSTHRODOV(I) = NSTH
    IF NSTH > NSTHMAX THEN NSTHMAX = NSTH
    CLOSE #1
NEXT I
DIM FxDefault(NSTHMAX), NFaixas(NSTHMAX)
    
' Leitura dos codigos numericos que identificam os Subtrechos Homogeneos:
DIM Code(NRODOV, NSTHMAX), NSTHI(NRODOV)
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "CODE" + Rodov$(I) + ".STH"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, NSTHI(I)
    FOR J = 1 TO NSTHI(I)
        INPUT #1, Code(I, J)
    NEXT J
    CLOSE #1
NEXT I

' Parametros de configuracao do trafego atuante na rede:
ARQUIVO$ = CALC$ + "TRAFEGO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
' Taxas anuais de crescimento do trafego
INPUT #1, TaxaAutos
INPUT #1, TaxaCam
INPUT #1, TaxaOnibus
CLOSE #1

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

' - - - - - - - - - - - - - - - - - - - - -
' - Condicoes Iniciais de cada Subtrecho  -
' - - - - - - - - - - - - - - - - - - - - -
 
FOR IRodov = 1 TO NRODOV

    ' Fatores de Veiculo Adotados
      ARQUIVO$ = CALC$ + "Fv_" + Rodov$(IRodov) + ".DAT"
      OPEN ARQUIVO$ FOR INPUT AS #1
      FOR NEIXOS = 2 TO 6
          INPUT #1, FV(NEIXOS)
      NEXT NEIXOS
      CLOSE #1

    ARQUIVO$ = CALC$ + DADO$(1) + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    LINE INPUT #1, LINHA$

    ARQUIVO$ = CALC$ + DADO$(1) + Rodov$(IRodov) + ".DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #2
    WRITE #2, LINHA$

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        INPUT #1, Subtrecho$, USOACOST$, ACOSTANOREVEST, ACOSTREVEST$, ACOSTH1CM
        INPUT #1, ACOSTBASE$, ACOSTH2CM, ACOSTSUBBASE$, ACOSTH3CM
        INPUT #1, ACOSTDECTRANSV, SUPPISTA$, SUPACOST$, HLFREATM, INUNDTEMP$
        STH = VAL(Subtrecho$)

        IF USOACOST$ = "" THEN USOACOST$ = "Normal"
        IF ACOSTANOREVEST = -1 THEN ACOSTANOREVEST = 1985
        IF ACOSTREVEST$ = "" THEN ACOSTREVEST$ = "TSD"
        IF ACOSTH1CM = -1 THEN ACOSTH1CM = 2.5
        IF ACOSTBASE$ = "" THEN ACOSTBASE$ = "SE"
        IF ACOSTH2CM = -1 THEN ACOSTH2CM = 15
        IF ACOSTSUBBASE$ = "" THEN ACOSTSUBBASE$ = "Inexistente"
        IF ACOSTH3CM = -1 THEN ACOSTH3CM = 0
        IF ACOSTDECTRANSV = -1 THEN ACOSTDECTRANSV = 2.5
        IF SUPPISTA$ = "" THEN SUPPISTA$ = "Boa"
        IF SUPACOST$ = "" THEN SUPACOST$ = "Boa"
        IF HLFREATM = -1 THEN HLFREATM = 5!
        IF INUNDTEMP$ = "" THEN INUNDTEMP$ = "Nao"

        WRITE #2, Subtrecho$, USOACOST$, ACOSTANOREVEST, ACOSTREVEST$, ACOSTH1CM
        WRITE #2, ACOSTBASE$, ACOSTH2CM, ACOSTSUBBASE$, ACOSTH3CM
        WRITE #2, ACOSTDECTRANSV, SUPPISTA$, SUPACOST$, HLFREATM, INUNDTEMP$

    NEXT ISUB
    CLOSE #1, #2

    ARQUIVO$ = CALC$ + DADO$(2) + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    LINE INPUT #1, LINHA$

    ARQUIVO$ = CALC$ + DADO$(2) + Rodov$(IRodov) + ".DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #2
    WRITE #2, LINHA$

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        INPUT #1, Subtrecho$, Rodov$, INI$, FIM$, KMINI, KMFIM, PISTA$
        INPUT #1, NFaixas(ISUB), PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
        INPUT #1, GEOVERT$, GEOHORIZ$, SECTIPO$, FX1, FX2, FX3, FX4, DECTRA, RESTR, ExtPontes, OBS$
        STH = VAL(Subtrecho$)

        IF PISTA$ = "" THEN PISTA$ = "Simples"
        IF NFaixas(ISUB) = -1 THEN NFaixas(ISUB) = 2
        IF PLUV = -1 THEN PLUV = 1500
        IF ALTM = -1 THEN ALTM = 400
        IF PLATAF = -1 THEN PLATAF = 12!
        IF LARGPISTA = -1 THEN LARGPISTA = 7!
        IF ACOSTLE = -1 THEN ACOSTLE = 2.5
        IF ACOSTLD = -1 THEN ACOSTLD = 2.5
        IF GEOVERT$ = "" THEN GEOVERT$ = "Plana"
        IF GEOHORIZ$ = "" THEN GEOHORIZ$ = "Sinuosa"
        IF SECTIPO$ = "" THEN SECTIPO$ = "Mista"
        IF FX1 = -1 THEN FX1 = 3.5
        IF FX2 = -1 THEN FX2 = 3.5
        IF FX3 = -1 THEN FX3 = 0
        IF FX4 = -1 THEN FX4 = 0
        IF DECTRA = -1 THEN DECTRA = 1.5
        IF RESTR = -1 THEN RESTR = 1000!
        IF OBS$ = "" THEN OBS$ = "Nenhuma"

        WRITE #2, STH, Rodov$, INI$, FIM$, KMINI, KMFIM, PISTA$
        WRITE #2, NFaixas(ISUB), PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
        WRITE #2, GEOVERT$, GEOHORIZ$, SECTIPO$, FX1, FX2, FX3, FX4, DECTRA, RESTR, ExtPontes, OBS$

    NEXT ISUB
    CLOSE #1, #2

    ARQUIVO$ = CALC$ + DADO$(4) + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    LINE INPUT #1, LINHA$

    ARQUIVO$ = CALC$ + DADO$(4) + Rodov$(IRodov) + ".OUT"
    OPEN ARQUIVO$ FOR OUTPUT AS #2
    WRITE #2, LINHA$

    FOR IFX = 1 TO NFaixasMax
        SELECT CASE IFX
            CASE 1: Faixa$ = "1"
            CASE 2: Faixa$ = "2"
            CASE 3: Faixa$ = "3"
            CASE 4: Faixa$ = "4"
            CASE ELSE: PRINT "ERRO"
        END SELECT
        ISUP = 3 + IFX
        ARQUIVO$ = CALC$ + "SUP" + Rodov$(IRodov) + Faixa$ + ".DAT"
        OPEN ARQUIVO$ FOR INPUT AS #ISUP
    NEXT IFX
    ARQUIVO$ = CALC$ + "ATR" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #3
    LINE INPUT #3, LINHA$
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        INPUT #1, Subtrecho$, QImed(1), QImed(2), QImed(3), QImed(4), DATAQI$, EQUIPQI$
        INPUT #3, Subtrecho$, ATResq(1), ATRdir(1), ATResq(2), ATRdir(2), ATResq(3), ATRdir(3), ATResq(4), ATRdir(4), DAT$, EQUIP$, DSVesq(1), DSVdir(1), DSVesq(2), DSVdir(2), DSVesq(3), DSVdir(3), DSVesq(4), DSVdir(4)
        STH = VAL(Subtrecho$)
        FOR IFaixa = 1 TO NFaixas(ISUB)
            IF ATResq(IFaixa) < -1 THEN ATResq(IFaixa) = -1
            IF ATRdir(IFaixa) < -1 THEN ATRdir(IFaixa) = -1
        NEXT IFaixa
        FOR IFaixa = 1 TO NFaixasMax
            ISUP = 3 + IFaixa
            INPUT #ISUP, Subtrecho$, KMI, KMF, PSR(IFaixa), CR$(IFaixa), BL$(IFaixa), TT$(IFaixa)
            INPUT #ISUP, TL$(IFaixa), TE$(IFaixa), TB$(IFaixa), P$(IFaixa), D$(IFaixa), DS$(IFaixa)
            INPUT #ISUP, ER$(IFaixa), BF$(IFaixa), Dc$(IFaixa), R$(IFaixa), ATR$(IFaixa), COR$(IFaixa)
            INPUT #ISUP, EM$(IFaixa), DP$(IFaixa), EL$(IFaixa), PSRACOST(IFaixa), DEGRAUCM(IFaixa), OBS$(IFaixa), ATRmed(IFaixa)
            IF IFaixa <= NFaixas(ISUB) THEN
                IF QImed(IFaixa) < 0 THEN
                    IF PSR(IFaixa) > 0 THEN
                        QImed(IFaixa) = 71.5 * LOG(5 / PSR(IFaixa))
                    ELSE
                        QImed(IFaixa) = 40
                    END IF
                END IF
            END IF
        NEXT IFaixa
        WRITE #2, STH, QImed(1), QImed(2), QImed(3), QImed(4), ATResq(1), ATRdir(1), ATResq(2), ATRdir(2), ATResq(3), ATRdir(3), ATResq(4), ATRdir(4), DSVesq(1), DSVdir(1), DSVesq(2), DSVdir(2), DSVesq(3), DSVdir(3), DSVesq(4), DSVdir(4)
    NEXT ISUB
    CLOSE #1, #2, #3, #4, #5, #6, #7

    ARQUIVO$ = CALC$ + DADO$(3) + Rodov$(IRodov) + ".DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #1
    WRITE #1, LINHA$

    IARQ = 1
    IIQ = 16
    FOR IFX = 1 TO NFaixasMax
        IARQ = IARQ + 1
        SELECT CASE IFX
            CASE 1: Faixa$ = "1"
            CASE 2: Faixa$ = "2"
            CASE 3: Faixa$ = "3"
            CASE 4: Faixa$ = "4"
            CASE ELSE: PRINT "ERRO"
        END SELECT
        ARQUIVO$ = CALC$ + "DFX" + Rodov$(IRodov) + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #IARQ
        LINE INPUT #IARQ, LINHA$
        IIQ = IIQ - 1
        ARQUIVO$ = CALC$ + "ESTR" + Rodov$(IRodov) + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #IIQ
        LINE INPUT #IIQ, LINHA$
    NEXT IFX
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        IARQ = 1
        FxDefault(ISUB) = 0
        FOR IFX = 1 TO NFaixasMax
            IARQ = IARQ + 1
            INPUT #IARQ, Subtrecho$, CARGADEF(IFX), Df(1, IFX), Df(2, IFX), Df(3, IFX), Df(4, IFX), Df(5, IFX), Df(6, IFX), Df(7, IFX)
            INPUT #IARQ, NPTS(IFX), TAR(IFX), TSUP(IFX), RCM(1, IFX), RCM(2, IFX), RCM(3, IFX), RCM(4, IFX), RCM(5, IFX), RCM(6, IFX), RCM(7, IFX)
            INPUT #IARQ, FIPLACA(IFX), DATADEFLX$(IFX), EQUIPDEFLX$(IFX)
            STH = VAL(Subtrecho$)
            IF NPTS(IFX) > 0 THEN
                FxDefault(ISUB) = IFX
            END IF
        NEXT IFX
    NEXT ISUB
    IARQ = 1
    FOR I = 1 TO NFaixasMax
        IARQ = IARQ + 1
        CLOSE #IARQ
    NEXT I

    IARQ = 1
    FOR IFX = 1 TO NFaixasMax
        IARQ = IARQ + 1
        SELECT CASE IFX
            CASE 1: Faixa$ = "1"
            CASE 2: Faixa$ = "2"
            CASE 3: Faixa$ = "3"
            CASE 4: Faixa$ = "4"
            CASE ELSE: PRINT "ERRO"
        END SELECT
        ARQUIVO$ = CALC$ + "DFX" + Rodov$(IRodov) + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #IARQ
        LINE INPUT #IARQ, LINHA$
        IQ = 6 + IFX
        ARQUIVO$ = CALC$ + "MOD" + Rodov$(IRodov) + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #IQ
        LINE INPUT #IQ, LINHA$
    NEXT IFX
    ARQUIVO$ = CALC$ + "DFX" + Rodov$(IRodov) + ".DAT"
    OPEN ARQUIVO$ FOR OUTPUT AS #6
    WRITE #6, LINHA$

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        IARQ = 1
        IIQ = 16
        FOR IFX = 1 TO NFaixasMax
            IARQ = IARQ + 1
            INPUT #IARQ, Subtrecho$, CARGADEF(IFX), Df(1, IFX), Df(2, IFX), Df(3, IFX), Df(4, IFX), Df(5, IFX), Df(6, IFX), Df(7, IFX)
            INPUT #IARQ, NPTS(IFX), TAR(IFX), TSUP(IFX), RCM(1, IFX), RCM(2, IFX), RCM(3, IFX), RCM(4, IFX), RCM(5, IFX), RCM(6, IFX), RCM(7, IFX)
            INPUT #IARQ, FIPLACA(IFX), DATADEFLX$(IFX), EQUIPDEFLX$(IFX)
            IQ = 6 + IFX
            INPUT #IQ, STH, H1(IFX), E1(IFX), TEMP(IFX), H2(IFX), E2(IFX), H3(IFX), E3(IFX), H4(IFX), E4(IFX), H5(IFX), E5(IFX), E1REF(IFX), D0REF(IFX), SN(IFX), DAT$, EQUIP$
        NEXT IFX
        STH = VAL(Subtrecho$)

        FOR IFX = 1 TO NFaixasMax

            IIQ = IIQ - 1
            INPUT #IIQ, Subtrecho$, ANORIG, REVORIG$, MARSHALL, RTDIAMET, VAZIOSAR, TEORASF
            INPUT #IIQ, H1CM, BASE$, H2CM, CBRBS, RCS28DBASE, SUBBASE$
            INPUT #IIQ, H3CM, CBRSUB, RCS28DSUBB, REFSL$, H4CM, CBRREF
            INPUT #IIQ, SL$, CBRSL, LLSL, IPSL, P200SL, PROFROCHAm

            MR = 0
            ICONT = 0
            IF NPTS(IFX) <= 0 THEN
                IF FxDefault(ISUB) > 0 THEN
                    CARGADEF(IFX) = CARGADEF(FxDefault(ISUB))
                    FOR IGEO = 1 TO 7
                        Df(IGEO, IFX) = Df(IGEO, FxDefault(ISUB))
                        RCM(IGEO, IFX) = RCM(IGEO, FxDefault(ISUB))
                    NEXT IGEO
                    NPTS(IFX) = NPTS(FxDefault(ISUB))
                    TAR(IFX) = TAR(FxDefaut)
                    TSUP(IFX) = TSUP(FxDefault(ISUB))
                    FIPLACA(IFX) = FIPLACA(FxDefault(ISUB))
                    DATADEFLX$(IFX) = DATADEFLX$(FxDefault(ISUB))
                    EQUIPDEFLX$(IFX) = EQUIPDEFLX$(FxDefault(ISUB))
                ELSE
                    CARGADEF(IFX) = 4100
                    IF REVORIG$ = "CCP" THEN
                        Df(1, IFX) = 20
                        RCM(1, IFX) = 0
                    ELSE
                        IF REVORIG$ = "CBUQ" THEN A1 = .44 ELSE A1 = .35
                        SELECT CASE BASE$
                            CASE "BG", "MS", "MH"
                                A2 = .14
                            CASE "Solo-Cimento", "Solo-Cal"
                                A2 = .2
                            CASE "BGTC"
                                A2 = .25
                            CASE "PMF"
                                A2 = .27
                            CASE "MB", "PMQ", "Solo-Betume"
                                A2 = .29
                            CASE "CCR", "CCP"
                                A2 = .3
                            CASE "CBUQ", "Binder", "BINDER"
                                A2 = .32
                            CASE ELSE
                                A2 = .12
                        END SELECT
                        IF SUBBASE$ <> "" THEN A3 = .11
                        SN = (H1CM * A1 + H2CM * A2 + H3CM * A3) / 2.54
                        IF CBRSL > 0 THEN
                            LCBR = LOG(CBRSL) / LOG(10)
                        ELSE
                            IF CBRREF > 0 THEN
                                LCBR = LOG(CBRREF) / LOG(10)
                            ELSE
                                CBRSL = 10
                                LCBR = LOG(CBRSL) / LOG(10)
                            END IF
                        END IF
                        SNC = SN + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
                        RCM(1, IFX) = 0
                        IF (BASE$ = "Solo-Cimento" OR BASE$ = "Solo-Cal" OR BASE$ = "BGTC" OR BASE$ = "CCR" OR BASE$ = "CCP") THEN
                            Df(1, IFX) = 100 * 3.5 * (SNC ^ -1.6)
                        ELSE
                            Df(1, IFX) = 100 * 6.5 * (SNC ^ -1.6)
                        END IF
                    END IF
                END IF
            END IF

            WRITE #6, STH, CARGADEF(IFX), Df(1, IFX), Df(2, IFX), Df(3, IFX), Df(4, IFX), Df(5, IFX), Df(6, IFX), Df(7, IFX)
            WRITE #6, NPTS(IFX), TAR(IFX), TSUP(IFX), RCM(1, IFX), RCM(2, IFX), RCM(3, IFX), RCM(4, IFX), RCM(5, IFX), RCM(6, IFX), RCM(7, IFX)
            WRITE #6, FIPLACA(IFX), DATADEFLX$(IFX), EQUIPDEFLX$(IFX)

            IF IFX <= NFaixas(ISUB) THEN
                IF REVORIG$ = "CCP" THEN
                    IF Df(7, IFX) > 0 THEN
                        FOR JJ = 1 TO NPAREA
                            X = XX(JJ)
                            I1 = 6
                            I2 = 7
                            FOR IDEF = 1 TO 6
                                IF (X > RCM(IDEF, IFX) AND X <= RCM(IDEF + 1, IFX)) THEN
                                    I1 = IDEF
                                    I2 = IDEF + 1
                                END IF
                            NEXT IDEF
                            X1 = RCM(I1, IFX): Y1 = Df(I1, IFX)
                            X2 = RCM(I2, IFX): Y2 = Df(I2, IFX)
                            y = ((X2 * Y1 - X1 * Y2) / (X2 - X1)) + ((Y2 - Y1) / (X2 - X1)) * X
                            DD(JJ) = y
                        NEXT JJ
                        AREA = 6 * (1 + 2 * (DD(1) / Df(1, IFX)) + 2 * (DD(2) / Df(1, IFX)) + (DD(3) / Df(1, IFX)))
                        LK = 685.84 - 126.57 * AREA + 8.679 * (AREA ^ 2) - .259 * (AREA ^ 3) + .00287 * (AREA ^ 4)
                        RAIO = FIPLACA(IFX) / 2
                        KEF = 1 + ((RAIO / LK) ^ 2) * (.217 - .367 * (LOG(RAIO / LK) / LOG(10)))
                        D0 = Df(1, IFX) / (2.54 * 1000)
                        KEF = KEF * (CARGADEF(IFX) / .4536) / (8 * D0 * (LK ^ 2))
                        KEF = KEF * .4536 / (2.54 ^ 3)
                        E = 19.4 * KEF
                        MR = MR + E
                        ICONT = ICONT + 1
                    END IF
                ELSE
                    FOR IDEF = 4 TO 7
                        IF (Df(IDEF, IFX) > 0 AND RCM(IDEF, IFX) > 0) THEN
                            AREA = PI# * (FIPLACA(IFX) ^ 2) / 4
                            IF AREA > 0 THEN
                                PRESSAO = CARGADEF(IFX) / AREA
                                IF PRESSAO > 0 THEN
                                    RAIO = FIPLACA(IFX) / 2
                                    POISSON = .4
                                    DIST = RCM(IDEF, IFX)
                                    DEFLEX = Df(IDEF, IFX) / 1000
                                    E(IDEF) = .904 * 2 * (1 - (POISSON ^ 2)) * PRESSAO * (RAIO ^ 2) / (DIST * DEFLEX)
                                    MR = MR + E(IDEF)
                                    ICONT = ICONT + 1
                                END IF
                            END IF
                        END IF
                    NEXT IDEF
                END IF
            END IF

            IF ICONT > 0 THEN
                MR = MR / ICONT
                'IF E(6) > E(5) THEN
                '     IF E(7) > E(6) THEN
                '        MR = E(5)
                '     ELSE
                '        MR = E(7)
                '     END IF
                'ELSE
                '     MR = MR / ICONT
                'END IF
            ELSE
                MR = -1
            END IF

            ESL = MR
            'IF E5(IFX) > 0 THEN
            '   ESL = E5(IFX)
            'ELSE
            '   IF E4(IFX) > 0 THEN
            '      ESL = E4(IFX)
            '   ELSE
            '      IF E3(IFX) > 0 THEN
            '         ESL = E3(IFX)
            '      ELSE
            '         IF E2(IFX) > 0 THEN
            '            ESL = E2(IFX)
            '         ELSE
            '            ESL = -1
            '         END IF
            '      END IF
            '   END IF
            'END IF

            IF ESL > 0 THEN
                Msl = ESL
            ELSE
                IF MR > 0 THEN
                    Msl = MR
                ELSE
                    Msl = 1000
                END IF
            END IF
            IF Msl < 1500 THEN
                K = 100
            ELSE
                IF Msl < 3000 THEN
                    K = 150
                ELSE
                    K = 200
                END IF
            END IF
            IF CBRSL > 0 THEN
                CBRSL = (CBRSL + (Msl / K)) / 2
            ELSE
                CBRSL = Msl / K
            END IF
            IF CBRSL > 60 THEN CBRSL = 60

            WRITE #1, STH, ANORIG, REVORIG$, MARSHALL, RTDIAMET, VAZIOSAR, TEORASF
            WRITE #1, H1CM, BASE$, H2CM, CBRBS, RCS28DBASE, SUBBASE$
            WRITE #1, H3CM, CBRSUB, RCS28DSUBB, REFSL$, H4CM, CBRREF
            WRITE #1, SL$, CBRSL, LLSL, IPSL, P200SL, PROFROCHAm

        NEXT IFX

    NEXT ISUB

    CLOSE #1
    IARQ = 1
    IIQ = 16
    FOR I = 1 TO NFaixasMax
        IARQ = IARQ + 1
        IIQ = IIQ - 1
        II = 6 + I
        CLOSE #IARQ, #IIQ, #II
    NEXT
    CLOSE #6

NEXT IRodov

SYSTEM
