CLS

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

ARQUIVO$ = CALC$ + "Quant.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, Quant
CLOSE #1
IF Quant = 1 THEN GeraDet$ = "S" ELSE GeraDet$ = "N"
IF GeraDet$ = "N" THEN 10

PRINT
PRINT "Gera os quantitativos detalhados por trecho e ano"
PRINT

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NPolos = NRODOV: NFaixasMax = 4: NClasses = 39
DIM CustoFaixa(NFaixasMax), MedidaAcost$(NFaixasMax), HRAC(NFaixasMax)
DIM H2AC(NFaixasMax), MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax)
DIM CustoP(NPolos), ConserP(NPolos), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
DIM REVEST$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
DIM HREFORCO(NFaixasMax), HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax)
DIM ICalib(NFaixasMax), D0(NFaixasMax), MRfound(NFaixasMax)
DIM DegrauAcost(NFaixasMax), CustoAcost(NFaixasMax)

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
P = NPeriodos
DIM kmCA(NRODOV, P), kmMF(NRODOV, P), kmCP(NRODOV, P), kmFR(NRODOV, P)
DIM kmBG(NRODOV, P), kmRE(NRODOV, P), kmRP(NRODOV, P), kmPT(NRODOV, P)
DIM kmPMF(NRODOV, P), kmTSS(NRODOV, P), kmTSD(NRODOV, P)
DIM kmBASE(NRODOV, P), kmREM(NRODOV, P), kmREP(NRODOV, P), kmPi(NRODOV, P)

DIM VRmed(NPeriodos), TR23(NSTH, NFaixasMax), Nano(NSTH, NFaixasMax)
DIM PSIat(NSTH, NFaixasMax), PPrest(NPeriodos)
DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), AreaAcost(NSTH, NFaixasMax)
DIM PSImedSTH(NSTH), VSMIN(NPP), Npsi(NPeriodos), PSIt(1), NFaixas(NSTH)
DIM STH(NSTHMAX), PSIacost(NSTH, NFaixasMax), COV(NPeriodos, NRODOV)

' Arquivo de configuracao do problema a ser analisado:
ARQUIVO$ = CALC$ + "MODO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
CLOSE #1

' Percentagem da area que deve receber reparos localizados (CL)
DIM PSIitemCL(15), ARepCL(15)
ARQUIVO$ = CALC$ + "REPAROS.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
NitensCL = 0
WHILE NOT EOF(1)
    NitensCL = NitensCL + 1
    INPUT #1, PSIitemCL(NitensCL), ARepCL(NitensCL)
WEND
CLOSE #1

SELECT CASE MODO
    CASE 1
        ARQUIVO$ = CALC$ + "DadoEstr.dat"
        MODOANALISE$ = "EstratBase"
        ARQ$ = "EB"
        NPer = NPeriodos
    CASE 2
        ARQUIVO$ = CALC$ + "DadoEstr.dat"
        MODOANALISE$ = "EstratRO"
        ARQ$ = "RO"
        NPer = NPeriodos
    CASE 0
        ARQUIVO$ = CALC$ + "Dados.dat"
        MODOANALISE$ = "EVOLUI"
        ARQ$ = "EVO"
        NPer = NPeriodos
    CASE 5
        ARQUIVO$ = CALC$ + "Dados.dat"
        MODOANALISE$ = "NECESSIDADES"
        ARQ$ = "NAT"
        NPer = 1
    CASE ELSE
        PRINT "ERRO"
END SELECT
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
INPUT #1, PPmin
INPUT #1, PPmax
INPUT #1, NPP
INPUT #1, inflacao
CLOSE #1

DIM Custo(NRODOV, NPeriodos), ANO(NPeriodos), C$(50)

ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ISTH = 0
FOR IRodov = 1 TO NRODOV
    COV(0, IRodov) = 0
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFaixas(ISTH)
            INPUT #12, IFX, H1REV, HrecExist, Idade, SN, QImed, Nano(ISTH, IFX), IRI0, Nacum, REVEST$, ALFAIGG
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes, VDMUni, PSInovo, Heff, IRec, ICalib, D0, MRfound
            INPUT #12, ALPHA0, ALPHA, ALPHA2, AreaAcost(ISTH, IFX), PSIacost(ISTH, IFX), DegrauAcost, T0, TR23(ISTH, IFX), CBRSL, CamBase$, VDMc, ATRmed
        NEXT IFaixa
    NEXT ISUB
NEXT IRodov
INPUT #12, PSImed(0), Npsi(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
CLOSE #12

' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -  Quantitativos dos Servicos de Manutencao por Subtrecho -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

ARQUIVO$ = CALC$ + ARQ$ + "PTsth.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #15
WRITE #15, "Trecho", "Ano", "STH", "kmi", "kmf", "AreaCPm2", "AreaSTm2", "ExtkmCR", "AreaCLm2", "CBUQm3", "PtLig m2", "Reperfm2", "Fresagm3", "Remoc.m3", "BGm3"
ARQUIVO$ = CALC$ + ARQ$ + "ACsth.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #16
WRITE #16, "Trecho", "Ano", "STH", "kmi", "kmf", "CL m2", "TSS m2", "TSD m2", "PMF m3", "CBUQ m3", "PtLig m2", "Remoc.m3", "Base m3", "Fresagem m3"

JSTH = 0
FOR IRodov = 1 TO NRODOV

    ' Parametros que definem as Arvores de Decisao:
    ARQUIVO$ = CALC$ + "ARV" + Rodov$(IRodov) + ".dat"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, IDScrit
    INPUT #1, PSRcrit
    INPUT #1, HRmin
    INPUT #1, HRmax
    INPUT #1, PSIf
    INPUT #1, DEGRAUadm
    INPUT #1, HCmin
    INPUT #1, HCMAXgeral
    INPUT #1, VUMin
    INPUT #1, QI0adm
    INPUT #1, HbaseAcost
    INPUT #1, RepFres
    INPUT #1, TipoRevAcost$
    INPUT #1, SART$
    CLOSE #1
    SELECT CASE SART$
        CASE "MF3"
            HRMF = 3
        CASE "MF4"
            HRMF = 4
        CASE ELSE
            HRMF = 2
    END SELECT

    ARQUIVO$ = CALC$ + ARQ$ + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #13
    LINE INPUT #13, LINHA$

    FOR ANO = 1 TO NPer

        PRINT Rodov$(IRodov), ANO

        ANOcal = ANOBASE + ANO
        ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
        OPEN ARQUIVO$ FOR INPUT AS #12
        ISTH = 0
        FOR IR = 1 TO NRODOV
            FOR ISUB = 1 TO NSTHRODOV(IR)
                ISTH = ISTH + 1
                INPUT #12, Subtrecho, KMI, KMF
                FOR IFaixa = 1 TO NFaixas(ISTH)
                    INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes, Restaurado$, UltCamada$, VDMUni, PSInovo, HRef, Heff, IRec, ICalib, D0, MRfound
                    INPUT #12, H1REV, HrecExist, Idade, SN, QImed, Nano(ISTH, IFX), IRI0, Nacum, ALFAIGG, ATRmed
                    INPUT #12, ALPHA0, ALPHA, ALPHA2, AreaAcost(ISTH, IFX), PSIacost(ISTH, IFX), DegrauAcost, T0, TR23(ISTH, IFX), CBRSL, CamBase$, VDMc
                NEXT IFaixa
            NEXT ISUB
        NEXT IR
        INPUT #12, PSImed(0), Npsi(0), VRmed(0)
        INPUT #12, AreaTotal, NUnidAnalise
        CLOSE #12

        FOR ISUB = 1 TO NSTHRODOV(IRodov)

            AreaCP = 0
            AreaST = 0
            ExtkmFaixaCR = 0
            AreaCL = 0
            CBUQm3 = 0
            Pinturam2 = 0
            Reperfm2 = 0
            Fresagemm3 = 0
            Remocaom3 = 0
            BGm3 = 0
            CLacostm2 = 0
            TSSacostm2 = 0
            TSDacostm2 = 0
            PMFacostm3 = 0
            CBUQacostm3 = 0
            PinturaAcostm2 = 0
            RemAcostm3 = 0
            BaseAcostm3 = 0
            CBUQacostm3 = 0
            FresagAcostm3 = 0

            IF ANO = 1 THEN
                JSTH = JSTH + 1
                STH(ISUB) = JSTH
            END IF
            ISTH = STH(ISUB)
            INPUT #13, Year, J, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(2), HRAC(2), H2AC(2)

            Extkm = ABS(KMF - KMI)

            FOR IFaixa = 1 TO NFaixas(ISTH)

                Medida$ = MedidaF$(IFaixa)
                HC = Hfres(IFaixa)
                HR = Hrec(IFaixa)
                PSI = PSIat(ISTH, IFaixa)

                SELECT CASE Medida$
                    CASE "RS", "CP"
                        IF RepFres < 0 THEN
                            IF TR23(ISTH, IFaixa) < 50 THEN
                                RepPerct = TR23(ISTH, IFaixa)
                            ELSE
                                RepPerct = 20
                            END IF
                        ELSE
                            RepPerct = RepFres
                        END IF
                        IF Nano(ISTH, IFaixa) < 500000! THEN
                            HCrepFres = 3
                        ELSE
                            IF Nano(ISTH, IFaixa) < 1000000! THEN
                                HCrepFres = 4
                            ELSE
                                HCrepFres = 5
                            END IF
                        END IF
                    CASE "RSUP+RC", "RSUP+CP"
                        RepPerct = 20
                        IF Nano(ISTH, IFaixa) < 500000! THEN
                            HCrepFres = 3
                        ELSE
                            IF Nano(ISTH, IFaixa) < 1000000! THEN
                                HCrepFres = 4
                            ELSE
                                HCrepFres = 5
                            END IF
                        END IF
                    CASE ELSE
                END SELECT

                SELECT CASE Medida$

                    CASE "RL", "CL"
                        I1 = 0
                        FOR ICL = 1 TO (NitensCL - 1)
                            IF (PSI <= PSIitemCL(ICL) AND PSI > PSIitemCL(ICL + 1)) THEN
                                I1 = ICL
                                I2 = ICL + 1
                            END IF
                        NEXT ICL
                        IF PSI <= PSIitemCL(NitensCL) THEN
                            I1 = NitensCL - 1
                            I2 = NitensCL
                        END IF
                        IF I1 = 0 THEN
                            PerctReparos = 0
                        ELSE
                            Y1 = ARepCL(I1)
                            Y2 = ARepCL(I2)
                            X1 = PSIitemCL(I1)
                            X2 = PSIitemCL(I2)
                            PerctReparos = ((X2 * Y1 - X1 * Y2) / (X2 - X1)) + ((Y2 - Y1) * PSI / (X2 - X1))
                        END IF
                        IF PerctReparos > ARepCL(NitensCL) THEN PerctReparos = ARepCL(NitensCL)
                        AreaCL = AreaCL + Aream2(ISTH, IFaixa) * PerctReparos / 100
                    CASE "ST"
                        I1 = 0
                        FOR ICL = 1 TO (NitensCL - 1)
                            IF (PSI <= PSIitemCL(ICL) AND PSI > PSIitemCL(ICL + 1)) THEN
                                I1 = ICL
                                I2 = ICL + 1
                            END IF
                        NEXT ICL
                        IF PSI <= PSIitemCL(NitensCL) THEN
                            I1 = NitensCL - 1
                            I2 = NitensCL
                        END IF
                        IF I1 = 0 THEN
                            PerctReparos = 0
                        ELSE
                            Y1 = ARepCL(I1)
                            Y2 = ARepCL(I2)
                            X1 = PSIitemCL(I1)
                            X2 = PSIitemCL(I2)
                            PerctReparos = ((X2 * Y1 - X1 * Y2) / (X2 - X1)) + ((Y2 - Y1) * PSI / (X2 - X1))
                        END IF
                        PerctReparos = .1 * PerctReparos
                        IF PerctReparos > 1! THEN PerctReparos = 1!
                        AreaST = AreaST + Aream2(ISTH, IFaixa) * PerctReparos / 100
                    CASE "FR+CP"
                        kmFR(IRodov, ANO) = kmFR(IRodov, ANO) + Extkm
                        kmCP(IRodov, ANO) = kmCP(IRodov, ANO) + Extkm
                        Ncortes = 1
                        Ncamadas = 1
                        Fresagemm3 = Fresagemm3 + (HC / 100) * Aream2(ISTH, IFaixa)
                        Fresm3TR = Fresm3TR + (HC / 100) * Aream2(ISTH, IFaixa)
                        AreaCP = AreaCP + Aream2(ISTH, IFaixa)
                    CASE "CP", "RSUP+CP"
                        AreaCP = AreaCP + Aream2(ISTH, IFaixa)
                        ' Reparos preliminares executados com fresadora
                        Ncortes = 1
                        Ncamadas = 1
                        Fresagemm3 = Fresagemm3 + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        Fresm3TR = Fresm3TR + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        CBUQm3 = CBUQm3 + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        CBUQm3TR = CBUQm3TR + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        Pinturam2 = Pinturam2 + Ncamadas * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        Ptm2TR = Ptm2TR + Ncamadas * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                    CASE "MF+CP", "FR+MF+CP"
                        AreaCP = AreaCP + Aream2(ISTH, IFaixa)
                        Pinturam2 = Pinturam2 + Aream2(ISTH, IFaixa)
                        Reperfm2 = Reperfm2 + Aream2(ISTH, IFaixa)
                        Ncortes = 1
                        Ncamadas = 1
                        Fresagemm3 = Fresagemm3 + (HC / 100) * Aream2(ISTH, IFaixa)
                    CASE "CR"
                        ExtkmFaixaCR = ExtkmFaixaCR + ABS(KMF - KMI)
                    CASE "RS", "RSUP+RC"
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        CBUQm3 = CBUQm3 + (HR / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2 = Pinturam2 + Ncamadas * Aream2(ISTH, IFaixa)
                        ' Reparos preliminares executados com fresadora
                        Ncortes = 1
                        Ncamadas = 1
                        Fresagemm3 = Fresagemm3 + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        CBUQm3 = CBUQm3 + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        Pinturam2 = Pinturam2 + Ncamadas * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                    CASE "MF+RC", "FR+MF+RC"
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        CBUQm3 = CBUQm3 + (HR / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2 = Pinturam2 + (Ncamadas + 1) * Aream2(ISTH, IFaixa)
                        Reperfm2 = Reperfm2 + Aream2(ISTH, IFaixa)
                        IF HC <= 7! THEN
                            Ncortes = 1
                        ELSE
                            IF HC <= 14! THEN
                                Ncortes = 2
                            ELSE
                                Ncortes = 3
                            END IF
                        END IF
                        Fresagemm3 = Fresagemm3 + (HC / 100) * Aream2(ISTH, IFaixa)
                    CASE "FR+RC", "RRV"
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        IF HC <= 7! THEN
                            Ncortes = 1
                        ELSE
                            IF HC <= 14! THEN
                                Ncortes = 2
                            ELSE
                                Ncortes = 3
                            END IF
                        END IF
                        CBUQm3 = CBUQm3 + (HR / 100) * Aream2(ISTH, IFaixa)
                        Fresagemm3 = Fresagemm3 + (HC / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2 = Pinturam2 + Ncamadas * Aream2(ISTH, IFaixa)
                    CASE "RRP"
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        H2CM = HC - HR
                        Remocaom3 = Remocaom3 + (HC / 100) * Aream2(ISTH, IFaixa)
                        CBUQm3 = CBUQm3 + (HR / 100) * Aream2(ISTH, IFaixa)
                        BGm3 = BGm3 + (H2CM / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2 = Pinturam2 + Ncamadas * Aream2(ISTH, IFaixa)
                    CASE "RRT"
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        H2CM = HC - HR - 20
                        Remocaom3 = Remocaom3 + (HC / 100) * Aream2(ISTH, IFaixa)
                        CBUQm3 = CBUQm3 + (HR / 100) * Aream2(ISTH, IFaixa)
                        BGm3 = BGm3 + (H2CM / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2 = Pinturam2 + Ncamadas * Aream2(ISTH, IFaixa)
                    CASE ELSE
                        PRINT "ERRO: medida nao identificada."
                        PRINT Medida$
                END SELECT

                IF (IFaixa = 1 OR IFaixa = NFaixas(ISTH)) THEN
                    IF IFaixa = 1 THEN Iacost = 1 ELSE Iacost = 2
                    Medida$ = MedidaAcost$(Iacost)
                    HR = HRAC(Iacost)
                    HC = H2AC(Iacost)
                    Area = AreaAcost(ISTH, IFaixa)

                    SELECT CASE Medida$
                        CASE "", "CR"
                        CASE "CL", "ST"
                            IF PSIacost(ISTH, IFaixa) > 0 THEN PerctReparos = 100 * EXP(-2.3026 * PSIacost(ISTH, IFaixa)) ELSE PerctReparos = 0
                            CLacostm2 = CLacostm2 + Area * PerctReparos / 100
                        CASE "CP", "FR+CP", "MF+CP", "FR+MF+CP", "RSUP+CP"
                            AreaCP = AreaCP + Aream2(ISTH, IFaixa)
                        CASE "TSS"
                            TSSacostm2 = TSSacostm2 + Area
                        CASE "TSD"
                            TSacostm2 = TSacostm2 + Area
                        CASE "PMF"
                            PMFacostm3 = PMFacostm3 + (HR / 100) * Area
                            PinturaAcostm2 = PinturaAcostm2 + Area
                        CASE "CBUQ", "RS", "RSUP+RC", "MF+RC"
                            CBUQacostm3 = CBUQacostm3 + (HR / 100) * Area
                            PinturaAcostm2 = PinturaAcostm2 + Area
                        CASE "FR+RC", "RRV", "FR+MF+RC"
                            IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN
                                TSacostm2 = TSacostm2 + Area
                            ELSE
                                CBUQacostm3 = CBUQacostm3 + (HR / 100) * Area
                                PinturaAcostm2 = PinturaAcostm2 + Area
                            END IF
                            FresagAcostm3 = FresagAcostm3 + Area * HC / 100
                        CASE "RRP", "RRT"
                            RemAcostm3 = RemAcostm3 + Area * HC / 100
                            IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN
                                TSacostm2 = TSacostm2 + Area
                            ELSE
                                CBUQacostm3 = CBUQacostm3 + (HR / 100) * Area
                                PinturaAcostm2 = PinturaAcostm2 + Area
                            END IF
                            BaseAcostm3 = BaseAcostm3 + Area * HC / 100
                        CASE ELSE
                            PRINT "ERRO: Medida desconhecida = "; Medida$
                    END SELECT
                END IF
            NEXT IFaixa

            IF ARQ$ = "NAT" THEN Year = ANOBASE ELSE Year = ANO + ANOBASE

            WRITE #15, Rodov$(IRodov), Year, ISTH, KMI, KMF, AreaCP, AreaST, ExtkmFaixaCR, AreaCL, CBUQm3, Pinturam2, Reperfm2, Fresagemm3, Remocaom3, BGm3
            WRITE #16, Rodov$(IRodov), Year, ISTH, KMI, KMF, CLacostm2, TSSacostm2, TSDacostm2, PMFacostm3, CBUQacostm3, PinturaAcostm2, RemAcostm3, BaseAcostm3, FresagAcostm3

        NEXT ISUB

    NEXT ANO
    CLOSE #13

NEXT IRodov
CLOSE #15, #16

10 SYSTEM

