CLS

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

ARQUIVO$ = CALC$ + "Quant.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, Quant
CLOSE #1
IF Quant = 1 THEN GeraDet$ = "S" ELSE GeraDet$ = "N"
IF GeraDet$ = "N" THEN 10

PRINT
PRINT "Gera os quantitativos detalhados e os custos por segmento e ano"
PRINT

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NPolos = NRODOV: NFaixasMax = 4: NClasses = 39
DIM CustoFaixa(NFaixasMax), MedidaAcost$(NFaixasMax), HRAC(NFaixasMax)
DIM H2AC(NFaixasMax), MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax)
DIM CustoP(NPolos), ConserP(NPolos), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
DIM REVEST$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
DIM HREFORCO(NFaixasMax), HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax)
DIM ICalib(NFaixasMax), D0(NFaixasMax), MRfound(NFaixasMax)
DIM DegrauAcost(NFaixasMax), CustoAcost(NFaixasMax)

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
P = NPeriodos
DIM kmCA(NRODOV, P), kmMF(NRODOV, P), kmCP(NRODOV, P), kmFR(NRODOV, P)
DIM kmBG(NRODOV, P), kmRE(NRODOV, P), kmRP(NRODOV, P), kmPT(NRODOV, P)
DIM kmPMF(NRODOV, P), kmTSS(NRODOV, P), kmTSD(NRODOV, P)
DIM kmBASE(NRODOV, P), kmREM(NRODOV, P), kmREP(NRODOV, P), kmPi(NRODOV, P)

DIM VRmed(NPeriodos), TR23(NSTH, NFaixasMax), Nano(NSTH, NFaixasMax)
DIM PSIat(NSTH, NFaixasMax), PPrest(NPeriodos)
DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), AreaAcost(NSTH, NFaixasMax)
DIM PSImedSTH(NSTH), VSMIN(NPP), Npsi(NPeriodos), PSIt(1), NFaixas(NSTH)
DIM STH(NSTHMAX), PSIacost(NSTH, NFaixasMax), COV(NPeriodos, NRODOV)

' Arquivo de configuracao do problema a ser analisado:
ARQUIVO$ = CALC$ + "MODO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
CLOSE #1

' Percentagem da area que deve receber reparos localizados (CL)
DIM PSIitemCL(15), ARepCL(15)
ARQUIVO$ = CALC$ + "REPAROS.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
NitensCL = 0
WHILE NOT EOF(1)
    NitensCL = NitensCL + 1
    INPUT #1, PSIitemCL(NitensCL), ARepCL(NitensCL)
WEND
CLOSE #1

SELECT CASE MODO
    CASE 1
        ARQUIVO$ = CALC$ + "DadoEstr.dat"
        MODOANALISE$ = "EstratBase"
        ARQ$ = "EB"
        NPer = NPeriodos
    CASE 2
        ARQUIVO$ = CALC$ + "DadoEstr.dat"
        MODOANALISE$ = "EstratRO"
        ARQ$ = "RO"
        NPer = NPeriodos
    CASE 0
        ARQUIVO$ = CALC$ + "Dados.dat"
        MODOANALISE$ = "EVOLUI"
        ARQ$ = "EVO"
        NPer = NPeriodos
    CASE 5
        ARQUIVO$ = CALC$ + "Dados.dat"
        MODOANALISE$ = "NECESSIDADES"
        ARQ$ = "NAT"
        NPer = 1
    CASE ELSE
        PRINT "ERRO"
END SELECT
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
INPUT #1, PPmin
INPUT #1, PPmax
INPUT #1, NPP
INPUT #1, inflacao
CLOSE #1

DIM Custo(NRODOV, NPeriodos), ANO(NPeriodos), C$(50)

' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -  Quantitativos dos Servicos de Manutencao por Subtrecho -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

ARQUIVO$ = CALC$ + ARQ$ + "CustoSEGpt.csv"
OPEN ARQUIVO$ FOR INPUT AS #5
LINE INPUT #5, LINHA$
ARQUIVO$ = CALC$ + ARQ$ + "CustoSEGac.csv"
OPEN ARQUIVO$ FOR INPUT AS #6
LINE INPUT #6, LINHA$
ARQUIVO$ = CALC$ + ARQ$ + "PTseg.csv"
OPEN ARQUIVO$ FOR INPUT AS #3
LINE INPUT #3, LINHA$
ARQUIVO$ = CALC$ + ARQ$ + "ACseg.csv"
OPEN ARQUIVO$ FOR INPUT AS #4
LINE INPUT #4, LINHA$

ARQUIVO$ = CALC$ + "CustoSEGpt.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #15
WRITE #15, "Subtrecho", "Ano", "Inicio (km)", "Final (km)", "CustoPista (R$)"
ARQUIVO$ = CALC$ + "CustoSEGac.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #16
WRITE #16, "Subtrecho", "Ano", "Inicio (km)", "Final (km)", "CustoAcost (R$)"
ARQUIVO$ = CALC$ + "PTseg.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #13
WRITE #13, "Subtrecho", "Ano", "kmi", "kmf", "AreaCPm2", "AreaSTm2", "ExtkmCR", "AreaCLm2", "CBUQm3", "PtLig m2", "Reperfm2", "Fresagm3", "Remoc.m3", "BGm3"
ARQUIVO$ = CALC$ + "ACseg.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #14
WRITE #14, "Subtrecho", "Ano", "kmi", "kmf", "CL m2", "TSS m2", "TSD m2", "PMF m3", "CBUQ m3", "PtLig m2", "Remoc.m3", "Base m3", "Fresagem m3"

WHILE NOT EOF(5)

    INPUT #3, Subtrecho, Ano, kmini, kmfim, AreaCPm2T, AreaSTm2T, ExtkmCRT, AreaCLm2T, CBUQm3T, PtLigm2T, Reperfm2T, Fresagm3T, Remocm3T, BGm3T
    INPUT #5, Subtrecho, Ano, kmini, kmfim, CPistaT
    INPUT #4, Subtrecho, Ano, kmini, kmfim, CLacostm2T, TSSacostm2T, TSDacostm2T, PMFacostm3T, CBUQacostm3T, PtAcostm2T, RemAcostm3T, BaseAcostm3T, FresagAcm3T
    INPUT #6, Subtrecho, Ano, kmini, kmfim, CAcostT
    PRINT Subtrecho, Ano

    ARQUIVO$ = CALC$ + "SEG2.csv"
    OPEN ARQUIVO$ FOR INPUT AS #2
    LINE INPUT #2, LINHA$
    WHILE NOT EOF(2)
        INPUT #2, STHX, SubtrechoX
        IF Subtrecho = SubtrechoX THEN
            GOSUB 100
            CPistaT = CPistaT + CustoPista
            CAcostT = CAcostT + CustoAcost
        END IF
    WEND
    CLOSE #2

    WRITE #13, Subtrecho, Ano, kmini, kmfim, AreaCPm2T, AreaSTm2T, ExtkmCRT, AreaCLm2T, CBUQm3T, PtLigm2T, Reperfm2T, Fresagm3T, Remocm3T, BGm3T
    WRITE #15, Subtrecho, Ano, kmini, kmfim, CPistaT
    WRITE #14, Subtrecho, Ano, kmini, kmfim, CLacostm2T, TSSacostm2T, TSDacostm2T, PMFacostm3T, CBUQacostm3T, PtAcostm2T, RemAcostm3T, BaseAcostm3T, FresagAcm3T
    WRITE #16, Subtrecho, Ano, kmini, kmfim, CAcostT

WEND
CLOSE #3, #4, #5, #6, #13, #14, #15, #16

10 SYSTEM

100 ' Subrotina

ARQUIVO$ = CALC$ + "PTsth.csv"
OPEN ARQUIVO$ FOR INPUT AS #7
LINE INPUT #7, LINHA$
ARQUIVO$ = CALC$ + "ACsth.csv"
OPEN ARQUIVO$ FOR INPUT AS #8
LINE INPUT #8, LINHA$

Achou$ = "N"
IANO = 0
WHILE (Achou$ = "N" AND IANO < NPeriodos)
    IANO = IANO + 1
    ISTH = 0
    WHILE (Achou$ = "N" AND ISTH < NSTH)
        ISTH = ISTH + 1
        INPUT #7, AnoX, Trecho$, STH, kmi, kmf, AreaCPm2, AreaSTm2, ExtkmCR, AreaCLm2, CBUQm3, PtLigm2, Reperfm2, Fresagm3, Remocm3, BGm3
        INPUT #8, AnoX, Trecho$, STH, kmi, kmf, CLacostm2, TSSacostm2, TSDacostm2, PMFacostm3, CBUQacostm3, PinturaAcostm2, RemAcostm3, BaseAcostm3, FresagAcostm3
        IF (AnoX = Ano AND STHX = STH) THEN
            Achou$ = "S"
            TrechoX$ = Trecho$
            AreaCPm2T = AreaCPm2T + AreaCPm2
            AreaSTm2T = AreaSTm2T + AreaSTm2
            ExtkmCRT = ExtkmCRT + ExtkmCR
            AreaCLm2T = AreaCLm2T + AreaCLm2
            CBUQm3T = CBUQm3T + CBUQm3
            PtLigm2T = PtLigm2T + PtLigm2
            Reperfm2T = Reperfm2T + Reperfm2
            Fresagm3T = Fresagm3T + Fresagm3
            Remocm3T = Remocm3T + Remocm3
            BGm3T = BGm3T + BGm3
            CLacostm2T = CLacostm2T + CLacostm2
            TSSacostm2T = TSSacostm2T + TSSacostm2
            TSDacostm2T = TSDacostm2T + TSDacostm2
            PMFacostm3T = PMFacostm3T + PMFacostm3
            CBUQacostm3T = CBUQacostm3T + CBUQacostm3
            PtAcostm2T = PtAcostm2T + PinturaAcostm2
            RemAcostm3T = RemAcostm3T + RemAcostm3
            BaseAcostm3T = BaseAcostm3T + BaseAcostm3
            FresagAcm3T = FresagAcm3T + FresagAcostm3
            GOSUB 500
            CustoPista = AreaCPm2 * MICROCA12m2 + AreaSTm2 * Selagem + ExtkmCR * CRkmAno + AreaCLm2 * CLm2 + CBUQm3 * CCBUQm3
            CustoPista = CustoPista + PtLigm2 * Pintura + Reperfm2 * Reperf + Fresagm3 * Fresagemm3 + Remocm3 * Remocao
            CustoPista = CustoPista + BGm3 * CBGm3 + Imprimam2 * BGm3 * (15 / 100)
            CustoAcost = CLacostm2 * CLm2 + TSSacostm2 * TSSm2 + TSDacostm2 * TSDm3 * (2.5 / 100) + PMFacostm3 * PMFm3
            CustoAcost = CustoAcost + CBUQacostm3 * CCBUQm3 + PtAcostm2 * Pintura + RemAcostm3 * Remocao
            CustoAcost = CustoAcost + CBaseAcostm3 * BaseAcostm3 + Imprimam2 * RemAcostm3 / (15 / 100) + FresagAcostm3 * Fresagemm3
        END IF
    WEND
WEND
CLOSE #7, #8

RETURN

500 '
' - - - - - - - - - - - -
' -  Custos Unitarios   -
' -     (Subrotina)     -
' - - - - - - - - - - - -
ARQUIVO$ = CALC$ + "C" + TrechoX$ + STR$(IANO) + ".csv"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, CCBUQm3
INPUT #1, Reperf
INPUT #1, Fresagemm3
INPUT #1, CBGm3
INPUT #1, Remocao
INPUT #1, CRkmAno
INPUT #1, CLm2
INPUT #1, MICROCA4m2
INPUT #1, MICROCA7m2
INPUT #1, MICROCA12m2
INPUT #1, TSSm2
INPUT #1, TSDm3
INPUT #1, TSTm3
INPUT #1, Pintura
INPUT #1, Selagem
INPUT #1, PMFm3
INPUT #1, LamaD
INPUT #1, LamaM
INPUT #1, LamaG
INPUT #1, CBaseAcostm3
INPUT #1, TSSpolm2
INPUT #1, TSDpolm3
INPUT #1, TSTpolm3
INPUT #1, CapeSealm3
INPUT #1, Imprimam2
INPUT #1, CamReciclm3
CLOSE #1
RETURN
