CLS

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

ARQUIVO$ = CALC$ + "Quant.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, Quant
CLOSE #1
IF Quant = 1 THEN GeraDet$ = "S" ELSE GeraDet$ = "N"
IF GeraDet$ = "N" THEN 10

PRINT
PRINT "Gera os quantitativos detalhados e os custos por segmento e ano"
PRINT

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NPolos = NRODOV: NFaixasMax = 4: NClasses = 39
DIM CustoFaixa(NFaixasMax), MedidaAcost$(NFaixasMax), HRAC(NFaixasMax)
DIM H2AC(NFaixasMax), MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax)
DIM CustoP(NPolos), ConserP(NPolos), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
DIM REVEST$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
DIM HREFORCO(NFaixasMax), HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax)
DIM ICalib(NFaixasMax), D0(NFaixasMax), MRfound(NFaixasMax)
DIM DegrauAcost(NFaixasMax), CustoAcost(NFaixasMax)

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
P = NPeriodos
DIM kmCA(NRODOV, P), kmMF(NRODOV, P), kmCP(NRODOV, P), kmFR(NRODOV, P)
DIM kmBG(NRODOV, P), kmRE(NRODOV, P), kmRP(NRODOV, P), kmPT(NRODOV, P)
DIM kmPMF(NRODOV, P), kmTSS(NRODOV, P), kmTSD(NRODOV, P)
DIM kmBASE(NRODOV, P), kmREM(NRODOV, P), kmREP(NRODOV, P), kmPi(NRODOV, P)

DIM VRmed(NPeriodos), TR23(NSTH, NFaixasMax), Nano(NSTH, NFaixasMax)
DIM PSIat(NSTH, NFaixasMax), PPrest(NPeriodos)
DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), AreaAcost(NSTH, NFaixasMax)
DIM PSImedSTH(NSTH), VSMIN(NPP), Npsi(NPeriodos), PSIt(1), NFaixas(NSTH)
DIM STH(NSTHMAX), PSIacost(NSTH, NFaixasMax), COV(NPeriodos, NRODOV)

' Arquivo de configuracao do problema a ser analisado:
ARQUIVO$ = CALC$ + "MODO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
CLOSE #1

' Percentagem da area que deve receber reparos localizados (CL)
DIM PSIitemCL(15), ARepCL(15)
ARQUIVO$ = CALC$ + "REPAROS.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
NitensCL = 0
WHILE NOT EOF(1)
    NitensCL = NitensCL + 1
    INPUT #1, PSIitemCL(NitensCL), ARepCL(NitensCL)
WEND
CLOSE #1

SELECT CASE MODO
    CASE 1
        ARQUIVO$ = CALC$ + "DadoEstr.dat"
        MODOANALISE$ = "EstratBase"
        ARQ$ = "EB"
        NPer = NPeriodos
    CASE 2
        ARQUIVO$ = CALC$ + "DadoEstr.dat"
        MODOANALISE$ = "EstratRO"
        ARQ$ = "RO"
        NPer = NPeriodos
    CASE 0
        ARQUIVO$ = CALC$ + "Dados.dat"
        MODOANALISE$ = "EVOLUI"
        ARQ$ = "EVO"
        NPer = NPeriodos
    CASE 5
        ARQUIVO$ = CALC$ + "Dados.dat"
        MODOANALISE$ = "NECESSIDADES"
        ARQ$ = "NAT"
        NPer = 1
    CASE ELSE
        PRINT "ERRO"
END SELECT
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
INPUT #1, PPmin
INPUT #1, PPmax
INPUT #1, NPP
INPUT #1, inflacao
CLOSE #1

DIM Custo(NRODOV, NPeriodos), ANO(NPeriodos), C$(50)

' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -  Quantitativos dos Servicos de Manutencao por Subtrecho -
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

ARQUIVO$ = CALC$ + ARQ$ + "CustoSEGpt.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #5
WRITE #5, "Subtrecho", "Ano", "Inicio (km)", "Final (km)", "CustoPista (R$)"
ARQUIVO$ = CALC$ + ARQ$ + "CustoSEGac.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #6
WRITE #6, "Subtrecho", "Ano", "Inicio (km)", "Final (km)", "CustoAcost (R$)"

ARQUIVO$ = CALC$ + ARQ$ + "PTseg.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #3
WRITE #3, "Subtrecho", "Ano", "kmi", "kmf", "AreaCPm2", "AreaSTm2", "ExtkmCR", "AreaCLm2", "CBUQm3", "PtLig m2", "Reperfm2", "Fresagm3", "Remoc.m3", "BGm3"
ARQUIVO$ = CALC$ + ARQ$ + "ACseg.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #4
WRITE #4, "Subtrecho", "Ano", "kmi", "kmf", "CL m2", "TSS m2", "TSD m2", "PMF m3", "CBUQ m3", "PtLig m2", "Remoc.m3", "Base m3", "Fresagem m3"

ARQUIVO$ = CALC$ + "SEG.csv"
OPEN ARQUIVO$ FOR INPUT AS #2
LINE INPUT #2, LINHA$
WHILE NOT EOF(2)

    INPUT #2, Subtrecho, Trecho1$, Trecho2$, kmini, kmfim
    PRINT Subtrecho

    ARQUIVO$ = CALC$ + "PTsth.csv"
    OPEN ARQUIVO$ FOR INPUT AS #15
    LINE INPUT #15, LINHA$
    FOR IANO = 1 TO NPeriodos

        AreaCPm2T = 0
        AreaSTm2T = 0
        ExtkmCRT = 0
        AreaCLm2T = 0
        CBUQm3T = 0
        PtLigm2T = 0
        Reperfm2T = 0
        Fresagm3T = 0
        Remocm3T = 0
        BGm3T = 0

        FOR ISTH = 1 TO NSTH

            INPUT #15, Ano, Trecho$, STH, kmi, kmf, AreaCPm2, AreaSTm2, ExtkmCR, AreaCLm2, CBUQm3, PtLigm2, Reperfm2, Fresagm3, Remocm3, BGm3
            IF Trecho1$ = Trecho$ THEN
                IF (kmini <= kmi AND kmf <= kmfim) THEN
                    TrechoX$ = Trecho$
                    AreaCPm2T = AreaCPm2T + AreaCPm2
                    AreaSTm2T = AreaSTm2T + AreaSTm2
                    ExtkmCRT = ExtkmCRT + ExtkmCR
                    AreaCLm2T = AreaCLm2T + AreaCLm2
                    CBUQm3T = CBUQm3T + CBUQm3
                    PtLigm2T = PtLigm2T + PtLigm2
                    Reperfm2T = Reperfm2T + Reperfm2
                    Fresagm3T = Fresagm3T + Fresagm3
                    Remocm3T = Remocm3T + Remocm3
                    BGm3T = BGm3T + BGm3
                END IF
            ELSE
                IF Trecho2$ = Trecho$ THEN
                    IF (kmfim >= kmi AND kmf >= kmini) THEN
                        TrechoX$ = Trecho$
                        AreaCPm2T = AreaCPm2T + AreaCPm2
                        AreaSTm2T = AreaSTm2T + AreaSTm2
                        ExtkmCRT = ExtkmCRT + ExtkmCR
                        AreaCLm2T = AreaCLm2T + AreaCLm2
                        CBUQm3T = CBUQm3T + CBUQm3
                        PtLigm2T = PtLigm2T + PtLigm2
                        Reperfm2T = Reperfm2T + Reperfm2
                        Fresagm3T = Fresagm3T + Fresagm3
                        Remocm3T = Remocm3T + Remocm3
                        BGm3T = BGm3T + BGm3
                    END IF
                END IF
            END IF

        NEXT ISTH
        WRITE #3, Subtrecho, Ano, kmini, kmfim, AreaCPm2T, AreaSTm2T, ExtkmCRT, AreaCLm2T, CBUQm3T, PtLigm2T, Reperfm2T, Fresagm3T, Remocm3T, BGm3T

        GOSUB 500
        CustoPista = AreaCPm2T * MICROCA12m2 + AreaSTm2T * Selagem + ExtkmCRT * CRkmAno + AreaCLm2T * CLm2 + CBUQm3T * CCBUQm3
        CustoPista = CustoPista + PtLigm2T * Pintura + Reperfm2T * Reperf + Fresagm3T * Fresagemm3 + Remocm3T * Remocao
        CustoPista = CustoPista + BGm3T * CBGm3 + Imprimam2 * BGm3T * (15 / 100)
        WRITE #5, Subtrecho, Ano, kmini, kmfim, CustoPista

    NEXT IANO
    CLOSE #15

    ARQUIVO$ = CALC$ + "ACsth.csv"
    OPEN ARQUIVO$ FOR INPUT AS #16
    LINE INPUT #16, LINHA$
    FOR IANO = 1 TO NPeriodos

        CLacostm2T = 0
        TSSacostm2T = 0
        TSDacostm2T = 0
        PMFacostm3T = 0
        CBUQacostm3T = 0
        PtAcostm2T = 0
        RemAcostm3T = 0
        BaseAcostm3T = 0
        FresagAcm3T = 0

        FOR ISTH = 1 TO NSTH
            INPUT #16, Ano, Trecho$, STH, kmi, kmf, CLacostm2, TSSacostm2, TSDacostm2, PMFacostm3, CBUQacostm3, PinturaAcostm2, RemAcostm3, BaseAcostm3, FresagAcostm3
            IF Trecho1$ = Trecho$ THEN
                IF (kmini <= kmi AND kmf <= kmfim) THEN
                    TrechoX$ = Trecho$
                    CLacostm2T = CLacostm2T + CLacostm2
                    TSSacostm2T = TSSacostm2T + TSSacostm2
                    TSDacostm2T = TSDacostm2T + TSDacostm2
                    PMFacostm3T = PMFacostm3T + PMFacostm3
                    CBUQacostm3T = CBUQacostm3T + CBUQacostm3
                    PtAcostm2T = PtAcostm2T + PinturaAcostm2
                    RemAcostm3T = RemAcostm3T + RemAcostm3
                    BaseAcostm3T = BaseAcostm3T + BaseAcostm3
                    FresagAcm3T = FresagAcm3T + FresagAcostm3
                END IF
            ELSE
                IF Trecho2$ = Trecho$ THEN
                    IF (kmfim >= kmi AND kmf >= kmini) THEN
                        TrechoX$ = Trecho$
                        CLacostm2T = CLacostm2T + CLacostm2
                        TSSacostm2T = TSSacostm2T + TSSacostm2
                        TSDacostm2T = TSDacostm2T + TSDacostm2
                        PMFacostm3T = PMFacostm3T + PMFacostm3
                        CBUQacostm3T = CBUQacostm3T + CBUQacostm3
                        PtAcostm2T = PtAcostm2T + PinturaAcostm2
                        RemAcostm3T = RemAcostm3T + RemAcostm3
                        BaseAcostm3T = BaseAcostm3T + BaseAcostm3
                        FresagAcm3T = FresagAcm3T + FresagAcostm3
                    END IF
                END IF
            END IF
        NEXT ISTH
        WRITE #4, Subtrecho, Ano, kmini, kmfim, CLacostm2T, TSSacostm2T, TSDacostm2T, PMFacostm3T, CBUQacostm3T, PtAcostm2T, RemAcostm3T, BaseAcostm3T, FresagAcm3T
        GOSUB 500
        CustoAcost = CLacostm2T * CLm2 + TSSacostm2T * TSSm2 + TSDacostm2T * TSDm3 * (2.5 / 100) + PMFacostm3T * PMFm3
        CustoAcost = CustoAcost + CBUQacostm3T * CCBUQm3 + PtAcostm2T * Pintura + RemAcostm3T * Remocao
        CustoAcost = CustoAcost + BaseAcostm3T * CBaseAcostm3 + Imprimam2 * RemAcostm3T / (15 / 100) + FresagAcm3T * Fresagemm3
        WRITE #6, Subtrecho, Ano, kmini, kmfim, CustoAcost

    NEXT IANO
    CLOSE #16

WEND
CLOSE #2, #3, #4, #5, #6

10 SYSTEM

500 '
' - - - - - - - - - - - -
' -  Custos Unitarios   -
' -     (Subrotina)     -
' - - - - - - - - - - - -
ARQUIVO$ = CALC$ + "C" + TrechoX$ + STR$(IANO) + ".csv"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, CCBUQm3
INPUT #1, Reperf
INPUT #1, Fresagemm3
INPUT #1, CBGm3
INPUT #1, Remocao
INPUT #1, CRkmAno
INPUT #1, CLm2
INPUT #1, MICROCA4m2
INPUT #1, MICROCA7m2
INPUT #1, MICROCA12m2
INPUT #1, TSSm2
INPUT #1, TSDm3
INPUT #1, TSTm3
INPUT #1, Pintura
INPUT #1, Selagem
INPUT #1, PMFm3
INPUT #1, LamaD
INPUT #1, LamaM
INPUT #1, LamaG
INPUT #1, CBaseAcostm3
INPUT #1, TSSpolm2
INPUT #1, TSDpolm3
INPUT #1, TSTpolm3
INPUT #1, CapeSealm3
INPUT #1, Imprimam2
INPUT #1, CamReciclm3
CLOSE #1
RETURN
