CLS

PRINT
PRINT "   PLANO PARA CORRECAO FUNCIONAL LOCALIZADA   "
PRINT

INPUT "- QI maximo admissivel (cont/km) = "; QIcrit
PRINT
INPUT "- ATR maximo (mm) = "; ATRmax
PRINT

DIM QI(4), ATResq(4), ATRdir(4)

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

ARQ$ = CALC$ + "CorrQI.csv"
OPEN ARQ$ FOR OUTPUT AS #1
WRITE #1, "Trecho", "kmi", "kmf", "Faixa", "QI (cont/km)", "FR(cm)", "FR+RC(cm)"

ARQ$ = CALC$ + "CorrATR.csv"
OPEN ARQ$ FOR OUTPUT AS #3
WRITE #3, "Trecho", "km", "Faixa", "Trilha", "ATR (mm)"
PRINT "Trecho: "

FOR IRODOV = 1 TO NRODOV

    PRINT "         "; Rodov$(IRODOV)

    ARQ$ = DadosAnoBase$ + "QI\" + Rodov$(IRODOV) + ".CSV"
    OPEN ARQ$ FOR INPUT AS #2
    LINE INPUT #2, LINHA$
    WHILE NOT EOF(2)
        INPUT #2, kmi, kmf, QI(1), QI(2), QI(3), QI(4), Dat$, Equip$
        FOR IFX = 1 TO 4
            IF QI(IFX) > QIcrit THEN
                hc = 0.4
                QIest = QI(IFX)
                WHILE QIest > QIcrit
                    hc = hc + 0.1
                    HR = 0
                    GOSUB 1000
                WEND
                hfres = hc
                hc = 0.4
                QIest = QI(IFX)
                WHILE QIest > QIcrit
                    hc = hc + 0.1
                    HR = hc
                    GOSUB 1000
                WEND
                WRITE #1, Rodov$(IRODOV), kmi, kmf, IFX, QI(IFX), hfres, HR
            END IF
        NEXT IFX
    WEND
    CLOSE #2

    ARQ$ = DadosAnoBase$ + "ATR\" + Rodov$(IRODOV) + ".CSV"
    OPEN ARQ$ FOR INPUT AS #2
    LINE INPUT #2, LINHA$
    WHILE NOT EOF(2)
        INPUT #2, km, ATResq(1), ATRdir(1), ATResq(2), ATRdir(2), ATResq(3), ATRdir(3), ATResq(4), ATRdir(4), Dat$, Equip$
        FOR IFX = 1 TO 4
            IF ATResq(IFX) > ATRmax THEN
                WRITE #3, Rodov$(IRODOV), km, IFX, "Esq.", ATResq(IFX)
            END IF
            IF ATRdir(IFX) > ATRmax THEN
                WRITE #3, Rodov$(IRODOV), km, IFX, "Dir.", ATRdir(IFX)
            END IF
        NEXT IFX
    WEND
    CLOSE #2

NEXT IRODOV
CLOSE #1, #3

PRINT
PRINT "==> Resultados em ...\Calc\CorrQI.csv e CorrATR.csv"
PRINT

END

1000 '
' - - - - - - - - - - - - - - - - - - - -
' -   Irregularidade apos Recapeamento  -
' -        (Subrotina do HDM-III)       -
' -   Dados: HR, hc, QI(IFX)            -
' -   Saida: QIest                      -
' - - - - - - - - - - - - - - - - - - - -
IF QI(IFX) > 19 THEN
    QIB = 19! + ((QI(IFX) - 19!) / (.602 * hc + 1))
ELSE
    QIB = QI(IFX)
END IF
DQI = 0
IF HR > 0 THEN
    H0 = 10 * HR
    IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
    IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
    IF H0 < 40 THEN X = H0 ELSE X = 40
    HOV = 3 - ((H0L + X) / 40)
    X1 = 19.42 - .78 * QIBL - .068 * H0
    IF H0 > 20 THEN Y = H0 - 20 ELSE Y = 0
    X2 = -19.5 - .008 * QIBL * Y
    IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
    IF DQI > 0 THEN DQI = 0
END IF
QIest = QIB + DQI
RETURN

