CLS

PI# = 3.141592654#
DIM R(18), Z(18), DF(9), D(9)

' Carga de referencia para a conversao das deflexoes do FWD
LOAD = 4100

' Analisa cada bacia do FWD

ARQUIVO$ = DADOSANOBASE$ + "DEFLEX\" + TRECHO$ + "_" + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR INPUT AS #2
LINE INPUT #2, LINHA$
WHILE NOT EOF(2)

    INPUT #2, km, CARGA, DF(1), DF(2), DF(3), DF(4), DF(5), DF(6), DF(7), TAR, TSUP, D(1), D(2), D(3), D(4), D(5), D(6), D(7), DPLACA, DAT$, Equipamento$

    PRINT "km "; km

            ' Converte D0 a 70oF e 4100 kgf
            GOSUB 10
            Deflex = DF(1) * (LOAD / CARGA)
            DF(1) = Deflex * Fd
            FOR I = 2 TO 7
                DF(I) = (LOAD / CARGA) * DF(I)
            NEXT I

            ' Modulo Dinamico do Revestimento em CBUQ

              ' Parametros do CBUQ de referencia adotado
                VV = 4
                PB = 5.2
                P200 = 7
                PNT = 60
                PAC = PB
                ' Parametros da mistura obtidos atraves de correlacoes
                VB = PB / .434
                TRB = 153.19 * (PNT ^ -.2596)
                VISC = 29508.2 * (PNT ^ -2.1939)
                PTS = ((LOG(800) / LOG(10)) - (LOG(PNT) / LOG(10))) / (TRB - 25)
                IP = (20 - 500 * PTS) / (1 + 50 * PTS)
                ' Calculo da espessura efetiva do revestimento existente
                DTFWD = 30
                h1 = Hrev
                ' Temperatura da camada (Gomez & Thompson, 1984)
                Z = h1 / 2.54
                TREF = 45.4 + 1.32 * Z
                TAIR = 1.8 * TAR + 32
                TMIX1 = 1.8 * TSUP + 32
                IF TAIR >= TREF THEN
                    TMIX = -10 + 1.39 * TAIR - .52 * Z
                ELSE
                    TMIX = 7.7 + 1! * TAIR - .004 * Z
                END IF
                TMIX = (TMIX + 2 * TMIX1) / 3
                TREV = (TMIX - 32) / 1.8
                PERIODO = DTFWD / 1000
                FREQ = 1 / PERIODO
                GOSUB 1000

WEND
CLOSE #2
SYSTEM


10 '
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'- Corrige a deflexao maxima para 21,1oC (Guia da AASHTO de 1993)  -
'-                         (Subrotina)                             -
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
IF Hrev < 3.5 THEN
    X1 = 110
    X2 = -32
    Y1 = 65
    Y2 = -17
ELSE
    IF Hrev <= 7.5 THEN
        X1 = 110
        X2 = -35
        Y1 = 60
        Y2 = -17
    ELSE
        X1 = 110
        X2 = -38
        Y1 = 55
        Y2 = -17
    END IF
END IF
IF TSUP > 75 THEN TSUP = 75
IF TAR > 45 THEN TAR = 45
X = TSUP + TAR
Tpav = ((X2 * Y1 - X1 * Y2) - X * (Y1 - Y2)) / (X2 - X1)
Fd = -.00002 * (Tpav ^ 3) + .0019 * (Tpav ^ 2) - .0597 * Tpav + 1.6028
RETURN

1000 '
' - - - - - - - - - - - - - - - - - - - - - -
' - Modulo dinamico em compressao (T.A.I.)  -
' -              (Subrotina)                -
' - - - - - - - - - - - - - - - - - - - - - -
TF = TMIX
TT = TF ^ (1.3 + .49825 * (LOG(FREQ) / LOG(10)))
EAC = 5.553833 + .028829 * (P200 / (FREQ ^ .17033)) - .03476 * VV
EAC = EAC + .070377 * VISC + .000005 * TT * (PAC ^ .5)
EAC = EAC - .00189 * (TT * (PAC ^ .5) / (FREQ ^ 1.1))
EAC = EAC + .931757 * (1 / (FREQ ^ .02774))
EACPSI = 10 ^ EAC
EACKSI = EACPSI / 1000
EACKGF = EACPSI * .0703
RETURN
