CLS

' Vetores e Matrizes associados `as faixas de trafego:
NFaixasMax = 4: NPolos = 50: NRodovMax = NPolos: NEixosMax = 6
DIM H(NFaixasMax), Tipo$(NFaixasMax), CustoP(NPolos), ConserP(NPolos)
DIM PSR(NFaixasMax), CR$(NFaixasMax), BL$(NFaixasMax), TT$(NFaixasMax)
DIM TL$(NFaixasMax), TE$(NFaixasMax), TB$(NFaixasMax), P$(NFaixasMax)
DIM D$(NFaixasMax), DS$(NFaixasMax), ER$(NFaixasMax), BF$(NFaixasMax)
DIM DC$(NFaixasMax), R$(NFaixasMax), ATR$(NFaixasMax), COR$(NFaixasMax)
DIM EM$(NFaixasMax), DP$(NFaixasMax), EL$(NFaixasMax), PSRACOST(NFaixasMax)
DIM DEGRAUCM(NFaixasMax), OBS$(NFaixasMax), IGG(NFaixasMax), VDMUni(NFaixasMax)
DIM CARGADEF(NFaixasMax), D0(NFaixasMax), NPTS(NFaixasMax), HC(NFaixasMax)
DIM REVEST$(NFaixasMax), FX(NFaixasMax), Nacum(NFaixasMax), ALPHA(NFaixasMax)
DIM FV(NEixosMax), PERCT(NEixosMax), VidaRes(NFaixasMax), ALFAIGG(NFaixasMax)
DIM IRest(NFaixasMax), Trecho$(NRodovMax + 1), FCnovorede(NRodovMax)
DIM FCrecaprede(NRodovMax), FCccprede(NRodovMax), VI(NFaixasMax), UltRest$(NFaixasMax)
DIM QI(NFaixasMax), Heff(NFaixasMax), ALFA(NFaixasMax), ICalib(NFaixasMax)
DIM ALFAnew(NFaixasMax), TSUP(NFaixasMax), MRfound(NFaixasMax), PERCTRAF(NFaixasMax)
DIM PSIacost(NFaixasMax), DegrauAcost(NFaixasMax), AreaAcost(NFaixasMax)
DIM VDMeixos(NEixosMax), CamBase$(NFaixasMax)
' Fatores de Calibracao
NCalMax = 15
DIM CodeOverlay(NCalMax), FcOverlay(NCalMax)

' Definicao de PSI dada pelo usuario
OPEN "DEFPSI.DAT" FOR INPUT AS #1
INPUT #1, DEFPSI
CLOSE #1

' Codigos de indentificacao das Pracas de Pedagio nos arquivos a serem gerados
OPEN "PEDAGIOS.DAT" FOR INPUT AS #1
INPUT #1, NPDG
INPUT #1, NCatTraf
OPEN "PEDG.DAT" FOR INPUT AS #2
LINE INPUT #2, LINHA$
DIM Cat(NCatTraf), VolAnual(NCatTraf), Pdg$(NPDG), ISent(NPDG), PdgNome$(NPDG)
FOR I = 1 TO NPDG
    INPUT #1, PdgNome$(I)
    INPUT #1, ISent(I)
    INPUT #2, Pdg$(I)
NEXT I
CLOSE #1, #2

' - - - - - - - - - - - - - - - -
' -  PARAMETROS DE CONFIGURACAO -
' - - - - - - - - - - - - - - - -

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

ARQUIVO$ = CALC$ + "CALIBRA.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #16
WRITE #16, "STH", "Faixa", "FcNovo", "h1cm", "Revest", "Base"
CLOSE #16

ARQUIVO$ = CALC$ + "RecCal.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #16
WRITE #16, "STH", "Faixa", "Fc", "ITR", "Recap"
CLOSE #16

ARQUIVO$ = CALC$ + "CALIBRA.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, CALIBRA$
CLOSE #1
CALIBRA$ = UCASE$(CALIBRA$)

OPEN "MES.DAT" FOR INPUT AS #1
INPUT #1, MESBASE$
CLOSE #1
MESBASE$ = UCASE$(MESBASE$)
SELECT CASE MESBASE$
    CASE "JAN": MONTH = .5
    CASE "FEV": MONTH = 1.5
    CASE "MAR": MONTH = 2.5
    CASE "ABR": MONTH = 3.5
    CASE "MAI": MONTH = 4.5
    CASE "JUN": MONTH = 5.5
    CASE "JUL": MONTH = 6.5
    CASE "AGO": MONTH = 7.5
    CASE "SET": MONTH = 8.5
    CASE "OUT": MONTH = 9.5
    CASE "NOV": MONTH = 10.5
    CASE "DEZ": MONTH = 11.5
    CASE ELSE: MONTH = 6
END SELECT
MONTH = MONTH / 12
ANOatual = ANOBASE + MONTH

' Tipos de dados de que a base de dados e' composta:
ARQUIVO$ = DADOS$ + "TIPODADO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NDADOS
DIM DADO$(15)
NDADOS = NDADOS - 1
FOR I = 1 TO NDADOS
    INPUT #1, DADO$(I)
NEXT I
INPUT #1, DADO$(NDADOS + 1)
CLOSE #1
NTIPOSDADOS = NDADOS
FOR IFX = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "SUP"
NEXT IFX
FOR IFX = 1 TO NFaixasMax
    NTIPOSDADOS = NTIPOSDADOS + 1
    DADO$(NTIPOSDADOS) = "DFX"
NEXT IFX

' Determina o numero maximo de Subtrechos Homogeneos por rodovia:
NSTHMAX = 0
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + DADO$(2) + Rodov$(I) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    NSTH = 0
    WHILE EOF(1) = FALSE
        LINE INPUT #1, LINHA$
        NSTH = NSTH + 1
    WEND
    NSTH = NSTH - 1
    NSTHRODOV(I) = NSTH
    IF NSTH > NSTHMAX THEN NSTHMAX = NSTH
    CLOSE #1
NEXT I
                      
' Leitura dos codigos numericos que identificam os Subtrechos Homogeneos:
DIM Code(NRODOV, NSTHMAX), NSTHI(NRODOV)
FOR I = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "CODE" + Rodov$(I) + ".STH"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, NSTHI(I)
    FOR J = 1 TO NSTHI(I)
        INPUT #1, Code(I, J)
    NEXT J
    CLOSE #1
NEXT I

' Parametros de configuracao do trafego atuante na rede:
ARQUIVO$ = CALC$ + "TRAFEGO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
' Taxas anuais de crescimento do trafego
INPUT #1, TaxaAutos
INPUT #1, TaxaCam
INPUT #1, TaxaOnibus
' Fatores de Veiculo Adotados
FOR NEIXOS = 2 TO 6
    INPUT #1, FV(NEIXOS)
NEXT NEIXOS
CLOSE #1

' Parametros para medir o desempenho das estrategias (Ocorrencias em %) e
' criterio para Priorizacao das Restauracoes sob Restricoes Orcamentarias
ARQUIVO$ = CALC$ + "PARAM.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, PSIref
INPUT #1, PTRAF
INPUT #1, PPSI
CLOSE #1

' Calibracao do Modelo da AASHTO para a rede
ARQUIVO$ = CALC$ + "FAIXACAL.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, FCminCA
INPUT #1, FCmaxCA
INPUT #1, FCdefCA
INPUT #1, FCminCCP
INPUT #1, FCmaxCCP
INPUT #1, FCdefCCP
INPUT #1, FCminRecap
INPUT #1, FCmaxRecap
INPUT #1, FCdefRecap
CLOSE #1
ARQUIVO$ = CALC$ + "CALIB.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
FOR I = 1 TO NRODOV
    INPUT #1, Trecho$(I), FCnovorede(I), FCrecaprede(I), FCccprede(I)
NEXT I
INPUT #1, Trecho$(NRODOV + 1), FCnew, FCovl, FCpcc
CLOSE #1
FOR I = 1 TO NRODOV
    FCnovorede(I) = 0
    FCrecaprede(I) = 0
    FCccprede(I) = 0
NEXT I
ICONTnovo = 0
ICONTrecap = 0
ICONTccp = 0
FCccp = 0
FcRecap = 0
FcNovo = 0
ICONTcalibra = 0
Ncasos = 0

' Modelos de previsao de desempenho para conserva pesada
ARQUIVO$ = PROGRAMA$ + "MODELOS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NMODELOS
DIM Arest(NMODELOS), CRest$(NMODELOS), PSRrest(NMODELOS), Brest(NMODELOS)
FOR I = 1 TO NMODELOS
    INPUT #1, CRest$(I)
    INPUT #1, Arest(I)
    INPUT #1, Brest(I)
    INPUT #1, PSRrest(I)
NEXT I
CLOSE #1

' Constantes
PI# = 3.141592654#
NPSITMAX = 11

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
DIM QImed(NFaixasMax), H1REV(NFaixasMax), HrecExist(NFaixasMax)
DIM Idade(NFaixasMax), PSIat(NSTH, NFaixasMax), NANO(NFaixasMax)
DIM Aream2(NSTH, NFaixasMax), VSMIN(NPP), PSIt(NPSITMAX)
DIM IRI0(NFaixasMax), IRI0PSI(NFaixasMax), SN(NFaixasMax)

CLS
PRINT
PRINT "                        * * * * * * * * * * * * * * * "
PRINT "                        *  INICIALIZA AS VARIAVEIS  * "
PRINT "                        * * * * * * * * * * * * * * * "

ARQUIVO$ = CALC$ + "ESTSTHS.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
CLOSE #1
KILL ARQUIVO$
   
FOR IRodov = 1 TO NRODOV
    ARQUIVO$ = CALC$ + "EST" + Rodov$(IRodov) + ".CSV"
    ARQCALB$ = CALC$ + "CALB" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #1
    OPEN ARQCALB$ FOR OUTPUT AS #2
    WRITE #1, "STH", "KMI", "KMF", "Nano1", "Nano2", "Nano3", "Nano4", "PSI1", "VidaRes1", "VDMUni1", "PSI2", "VidaRes2", "VDMUni2", "PSI3", "VidaRes3", "VDMUni3", "PSI4", "VidaRes4", "VDMUni4"
    WRITE #2, "STH", "KMI", "KMF", "Fc1", "Fc2", "Fc3", "Fc4"
    CLOSE #1, #2
    ARQUIVO$ = CALC$ + "Nec" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #1
    WRITE #1, "STH", "KMI", "KMF", "PSI1", "VidaRes1", "IDS1", "Idade1", "PSI2", "VidaRes2", "IDS2", "Idade2", "PSI3", "VidaRes3", "IDS3", "Idade3", "PSI4", "VidaRes4", "IDS4", "Idade4", "D01", "D02", "D03", "D04", "QI1", "QI2", "QI3", "QI4"
    CLOSE #1
    FOR IFX = 1 TO NFaixasMax
        SELECT CASE IFX
            CASE 1: Faixa$ = "1"
            CASE 2: Faixa$ = "2"
            CASE 3: Faixa$ = "3"
            CASE 4: Faixa$ = "4"
            CASE ELSE: PRINT "ERRO"
        END SELECT
        ARQUIVO$ = CALC$ + "Par" + Rodov$(IRodov) + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR OUTPUT AS #1
        WRITE #1, "STH", "KMI", "KMF", "UltCam", "HR", "VS", "VidaRes", "Idade", "PSI", "IDS", "D0", "QI", "Fc", "Nano", "VDMuni", "MR"
        CLOSE #1
    NEXT IFX
    ARQUIVO$ = CALC$ + "INT" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #15
    WRITE #15, "STH", "UltRest1", "UltRest2", "UltRest3", "UltRest4"
    CLOSE #15
NEXT IRodov

' - - - - - - - - - - - - - - - - - - - - -
' - Condicoes Iniciais de cada Subtrecho  -
' - - - - - - - - - - - - - - - - - - - - -
ARQUIVO$ = CALC$ + "IDS.OUT"
OPEN ARQUIVO$ FOR INPUT AS #17

AreaTotal = 0!
PSImed = 0!
NPSI = 0
NUnidAnalise = 0
VDMmin = 1E+20: VDMmax = 0
PSImin = 5!: PSImax = 0

ISTH = 0
FOR IRodov = 1 TO NRODOV

    PRINT "Trecho: "; Rodov$(IRodov)

    ' Parametros que definem as Arvores de Decisao:
    ARQUIVO$ = CALC$ + "ARV" + Rodov$(IRodov) + ".dat"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, IDScrit
    INPUT #1, PSRcrit
    INPUT #1, HRMIN
    INPUT #1, HRMAX
    INPUT #1, PSIf
    INPUT #1, DEGRAUadm
    INPUT #1, HCMIN
    INPUT #1, VUMin
    INPUT #1, QI0adm
    INPUT #1, HbaseAcost
    CLOSE #1

    ICONTnew = 0
    ICONTovl = 0
    IARQ = NDADOS
    FOR I = 1 TO (NDADOS + 2)
        IF I <= NDADOS THEN
            IF DADO$(I) = "TRAF" THEN EXT$ = ".CSV" ELSE EXT$ = ".DAT"
            ARQUIVO$ = CALC$ + DADO$(I) + Rodov$(IRodov) + EXT$
            OPEN ARQUIVO$ FOR INPUT AS #I
        ELSE
            FOR IFX = 1 TO NFaixasMax
                IARQ = IARQ + 1
                SELECT CASE IFX
                    CASE 1: Faixa$ = "1"
                    CASE 2: Faixa$ = "2"
                    CASE 3: Faixa$ = "3"
                    CASE 4: Faixa$ = "4"
                    CASE ELSE
                        PRINT "Erro"
                END SELECT
                IF DADO$(IARQ) = "DFX" THEN EXT$ = ".DAT" ELSE EXT$ = ".CSV"
                ARQUIVO$ = CALC$ + DADO$(IARQ) + Rodov$(IRodov) + Faixa$ + EXT$
                OPEN ARQUIVO$ FOR INPUT AS #IARQ
            NEXT IFX
        END IF
        ' Sequencia dos arquivos de dados em DADO$(I):
        ' 1 ==> ACOST e DRG
        ' 2 ==> CADAS
        ' 3 ==> ESTR
        ' 4 ==> FUNC
        ' 5 ==> TRAF
        ' 6, 7, 8, e 9 ==> SUP
        ' 10, 11, 12 e 13 ==> DFX
    NEXT I

    FOR ILL = 1 TO 13
        LINE INPUT #ILL, LINHA$
    NEXT ILL

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        ISTH = ISTH + 1
        FOR IFaixa = 1 TO NFaixasMax
            H1REV(IFaixa) = 0
            SN(IFaixa) = 0
            HrecExist(IFaixa) = 0
            Idade(IFaixa) = 0
            REVEST$(IFaixa) = ""
            QImed(IFaixa) = 0
            Nacum(IFaixa) = 0
            NANO(IFaixa) = 0
            D0(IFaixa) = -1
            IRI0(IFaixa) = 0
            PSIat(ISTH, IFaixa) = 0
            Aream2(ISTH, IFaixa) = 0
            VidaRes(IFaixa) = 0
            VDMUni(IFaixa) = 0
            IRest(IFaixa) = 0
            ALFAIGG(IFaixa) = 1
            ALPHA(IFaixa) = -1
            QI(IFaixa) = -1
            VI(IFaixa) = -1
            ESL(IFaixa) = -1
            ITR(IFaixa) = -1
        NEXT IFaixa

        INPUT #1, STH, USOACOST$, ACOSTANOREVEST, ACOSTREVEST$, ACOSTH1CM
        INPUT #1, ACOSTBASE$, ACOSTH2CM, ACOSTSUBBASE$, ACOSTH3CM
        INPUT #1, ACOSTDECTRANSV, SUPPISTA$, SUPACOST$, HLFREATM, INUNDTEMP$

        INPUT #2, STH, Rodov$, INI$, FIM$, KMI, KMF, PISTA$
        INPUT #2, NFaixas, PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
        INPUT #2, GEOVERT$, GEOHORIZ$, SECTIPO$, FX(1), FX(2), FX(3), FX(4), DECTRA, RESTR, ExtPontes, OBS$

        ' Geometria em Planta
        Extensaom = 1000 * ABS(KMI - KMF)
        FOR IFaixa = 1 TO NFaixas
            Aream2(ISTH, IFaixa) = Extensaom * FX(IFaixa)
            IF Aream2(ISTH, IFaixa) <= 0 THEN
                PRINT "Erro"
            END IF
            AreaTotal = AreaTotal + Aream2(ISTH, IFaixa)
            IF IFaixa = 1 THEN
                AreaAcost(IFaixa) = ACOSTLE * Extensaom
            ELSE
                IF IFaixa = NFaixas THEN
                    AreaAcost(IFaixa) = ACOSTLD * Extensaom
                ELSE
                    AreaAcost(IFaixa) = 0
                END IF
            END IF
        NEXT IFaixa

        INPUT #4, STH, QImed(1), QImed(2), QImed(3), QImed(4), ATResq(1), ATRdir(1), ATResq(2), ATRdir(2), ATResq(3), ATRdir(3), ATResq(4), ATRdir(4), DSVesq(1), DSVdir(1), DSVesq(2), DSVdir(2), DSVesq(3), DSVdir(3), DSVesq(4), DSVdir(4)

        FOR IFX = 1 TO NFaixasMax
            ISUP = NDADOS + IFX
            INPUT #ISUP, STH, KMIni, KMFim, PSR(IFX), CR$(IFX), BL$(IFX), TT$(IFX)
            INPUT #ISUP, TL$(IFX), TE$(IFX), TB$(IFX), P$(IFX), D$(IFX), DS$(IFX)
            INPUT #ISUP, ER$(IFX), BF$(IFX), DC$(IFX), R$(IFX), ATR$(IFX), COR$(IFX)
            INPUT #ISUP, EM$(IFX), DP$(IFX), EL$(IFX), PSRACOST(IFX), DEGRAUCM(IFX), DataLVC$, OBS$(IFX)
            CR$(IFX) = UCASE$(CR$(IFX)): BL$(IFX) = UCASE$(BL$(IFX)): TT$(IFX) = UCASE$(TT$(IFX))
            TL$(IFX) = UCASE$(TL$(IFX)): TE$(IFX) = UCASE$(TE$(IFX)): TB$(IFX) = UCASE$(TB$(IFX))
            P$(IFX) = UCASE$(P$(IFX)): D$(IFX) = UCASE$(D$(IFX)): DS$(IFX) = UCASE$(DS$(IFX))
            ER$(IFX) = UCASE$(ER$(IFX)): BF$(IFX) = UCASE$(BF$(IFX)): DC$(IFX) = UCASE$(DC$(IFX))
            R$(IFX) = UCASE$(R$(IFX)): ATR$(IFX) = UCASE$(ATR$(IFX)): COR$(IFX) = UCASE$(COR$(IFX))
            EM$(IFX) = UCASE$(EM$(IFX)): DP$(IFX) = UCASE$(DP$(IFX)): EL$(IFX) = UCASE$(EL$(IFX))
            ICONTtr = 0
            SELECT CASE CR$(IFX)
                CASE "A3": ICONTtr = ICONTtr + 100
                CASE "A2": ICONTtr = ICONTtr + 85
                CASE "M3": ICONTtr = ICONTtr + 75
                CASE "M2": ICONTtr = ICONTtr + 50
                CASE "B3": ICONTtr = ICONTtr + 30
                CASE "B2": ICONTtr = ICONTtr + 20
                CASE "A1": ICONTtr = ICONTtr + 10
                CASE "M1": ICONTtr = ICONTtr + 5
                CASE "B1": ICONTtr = ICONTtr + 3
                CASE ELSE
            END SELECT
            SELECT CASE TL$(IFX)
                CASE "A3": ICONTtr = ICONTtr + 90
                CASE "A2": ICONTtr = ICONTtr + 80
                CASE "M3": ICONTtr = ICONTtr + 70
                CASE "M2": ICONTtr = ICONTtr + 40
                CASE "B3": ICONTtr = ICONTtr + 20
                CASE "B2": ICONTtr = ICONTtr + 15
                CASE "A1": ICONTtr = ICONTtr + 7
                CASE "M1": ICONTtr = ICONTtr + 4
                CASE "B1": ICONTtr = ICONTtr + 2
                CASE ELSE
            END SELECT
            SELECT CASE BL$(IFX)
                CASE "A3": ICONTtr = ICONTtr + 85
                CASE "A2": ICONTtr = ICONTtr + 70
                CASE "M3": ICONTtr = ICONTtr + 65
                CASE "M2": ICONTtr = ICONTtr + 30
                CASE "B3": ICONTtr = ICONTtr + 15
                CASE "B2": ICONTtr = ICONTtr + 10
                CASE "A1": ICONTtr = ICONTtr + 5
                CASE "M1": ICONTtr = ICONTtr + 3
                CASE "B1": ICONTtr = ICONTtr + 1
                CASE ELSE
            END SELECT
            SELECT CASE TT$(IFX)
                CASE "A3": ICONTtr = ICONTtr + 80
                CASE "A2": ICONTtr = ICONTtr + 65
                CASE "M3": ICONTtr = ICONTtr + 60
                CASE "M2": ICONTtr = ICONTtr + 25
                CASE "B3": ICONTtr = ICONTtr + 13
                CASE "B2": ICONTtr = ICONTtr + 7
                CASE "A1": ICONTtr = ICONTtr + 4
                CASE "M1": ICONTtr = ICONTtr + 2
                CASE "B1": ICONTtr = ICONTtr + 0
                CASE ELSE
            END SELECT
            SELECT CASE TE$(IFX)
                CASE "A3": ICONTtr = ICONTtr + 70
                CASE "A2": ICONTtr = ICONTtr + 60
                CASE "M3": ICONTtr = ICONTtr + 50
                CASE "M2": ICONTtr = ICONTtr + 20
                CASE "B3": ICONTtr = ICONTtr + 11
                CASE "B2": ICONTtr = ICONTtr + 5
                CASE "A1": ICONTtr = ICONTtr + 3
                CASE "M1": ICONTtr = ICONTtr + 1
                CASE "B1": ICONTtr = ICONTtr + 0
                CASE ELSE
            END SELECT
            SELECT CASE TB$(IFX)
                CASE "A3": ICONTtr = ICONTtr + 30
                CASE "A2": ICONTtr = ICONTtr + 25
                CASE "M3": ICONTtr = ICONTtr + 20
                CASE "M2": ICONTtr = ICONTtr + 15
                CASE "B3": ICONTtr = ICONTtr + 10
                CASE "B2": ICONTtr = ICONTtr + 5
                CASE "A1": ICONTtr = ICONTtr + 2
                CASE "M1": ICONTtr = ICONTtr + 1
                CASE "B1": ICONTtr = ICONTtr + 0
                CASE ELSE
            END SELECT
            IF ICONTtr >= 80 THEN
                ITR(IFX) = 3
            ELSE
                IF ICONTtr >= 65 THEN
                    ITR(IFX) = 2
                ELSE
                    IF ICONTtr >= 40 THEN
                        ITR(IFX) = 1
                    ELSE
                        ITR(IFX) = 0
                    END IF
                END IF
            END IF
        NEXT IFX

        INPUT #5, STH, Praca$, PERCTVDM, PERCTRAF(1), PERCTRAF(2), PERCTRAF(3), PERCTRAF(4), VDMunid, VDMeixos(2), VDMeixos(3), VDMeixos(4), VDMeixos(5), VDMeixos(6)
        Praca$ = UCASE$(Praca$)
        SELECT CASE Praca$
            CASE "CONTAGEM"
                IPDG = 0
            CASE "P1"
                IPDG = 1
            CASE "P2"
                IPDG = 2
            CASE "P3"
                IPDG = 3
            CASE "P4"
                IPDG = 4
            CASE "P5"
                IPDG = 5
            CASE "P6"
                IPDG = 6
            CASE ELSE
                PRINT "ERRO"
        END SELECT
        FOR IEIXOS = 1 TO NEixosMax
            PERCT(IEIXOS) = 0
        NEXT IEIXOS
        IF IPDG > 0 THEN
            Pedagio$ = Pdg$(IPDG)
            ARQUIVO$ = CALC$ + Pedagio$ + ".CSV"
            OPEN ARQUIVO$ FOR INPUT AS #15
            LINE INPUT #15, LINHA$
            VDMUNIDIRE = 0
            FOR I = 1 TO NCatTraf
                INPUT #15, J, VolAnual(J)
                VDMUNIDIRE = VDMUNIDIRE + VolAnual(J)
                SELECT CASE J
                    CASE 1, 2, 3
                        ' Automoveis e motos
                        PERCT(1) = PERCT(1) + VolAnual(J)
                    CASE 4, 9, 10
                        ' Veiculos comerciais de dois eixos
                        PERCT(2) = PERCT(2) + VolAnual(J)
                    CASE 5
                        ' Veiculos comerciais de tres eixos
                        PERCT(3) = PERCT(3) + VolAnual(J)
                    CASE 6
                        ' Veiculos comerciais de 4 eixos
                        PERCT(4) = PERCT(4) + VolAnual(J)
                    CASE 7
                        ' Veiculos comerciais de 5 eixos
                        PERCT(5) = PERCT(5) + VolAnual(J)
                    CASE 8
                        ' Veiculos comerciais de 6 ou mais eixos
                        PERCT(6) = PERCT(6) + VolAnual(J)
                    CASE ELSE
                        PRINT "ERRO"
                END SELECT
            NEXT I
            CLOSE #15
            PerctCom = 0
            FVeic = 0
            FOR IEIXOS = 1 TO NEixosMax
                PERCT(IEIXOS) = PERCT(IEIXOS) / VDMUNIDIRE
                IF IEIXOS > 1 THEN
                    PerctCom = PerctCom + PERCT(IEIXOS)
                    FVeic = FVeic + FV(IEIXOS) * PERCT(IEIXOS)
                END IF
            NEXT IEIXOS
            FVeic = FVeic / PerctCom
            VDMUNIDIRE = VDMUNIDIRE / 365
            VDM = VDMUNIDIRE * PERCTVDM / 100
        ELSE
            VDM = VDMunid
            PerctCom = 0
            FVeic = 0
            FOR I = 2 TO 6
                PERCT(I) = VDMeixos(I) / VDM
                PerctCom = PerctCom + PERCT(I)
                FVeic = FVeic + FV(I) * PERCT(I)
            NEXT I
            FVeic = FVeic / PerctCom
        END IF

        ' Indice de Defeitos de Superficie
        INPUT #17, ISTHH, IGG(1), IGG(2), IGG(3), IGG(4)

        FOR IFaixa = 1 TO NFaixas

            ' Parametros relativos ao trafego:
            PISTA$ = UCASE$(PISTA$)
            VDMUni(IFaixa) = VDM * (PERCTRAF(IFaixa) / 100)
            NANO(IFaixa) = PerctCom * VDMUni(IFaixa) * FVeic * 365
            TAXACOMERC = (TaxaCam + TaxaOnibus) / 2
            TaxaVDM = (TaxaAutos * PERCT(1) + TAXACOMERC * PerctCom) / (PerctCom + PERCT(1))
            FatorVDM = 1 + (TaxaVDM / 100)
            FatorTraf = 1 + (TAXACOMERC / 100)

            ' - - - - - - - - - - - - - - - -
            ' -  Estado de Superficie atual -
            ' - - - - - - - - - - - - - - - -

            QInovo = 15
            PSIQInovo = 5! * EXP(-QInovo / 71.5)
            PSRnovo = 5
            PSInovo = (PSIQInovo + PSRnovo) / 2
            PSImax = 4.9

            PSIQI = 5! * EXP(-QImed(IFaixa) / 71.5)
            PSIIDS = (309.22 - .616 * IGG(IFaixa)) / (61.844 + IGG(IFaixa))
            PSRmed = (PSR(IFaixa) + PSIIDS) / 2
            SELECT CASE DEFPSI
                CASE 0
                    PSIat(ISTH, IFaixa) = (PSRmed + PSIQI) / 2
                CASE 1
                    PSIat(ISTH, IFaixa) = PSRmed
                CASE ELSE
                    PRINT "ERRO"
            END SELECT
            IF PSIat(ISTH, IFaixa) > PSInovo THEN PSIat(ISTH, IFaixa) = PSInovo
            IF PSIat(ISTH, IFaixa) < .5 THEN PSIat(ISTH, IFaixa) = .5

            IF PSIat(ISTH, IFaixa) < PSIref THEN NPSI = NPSI + 1
            PSImed = PSImed + PSIat(ISTH, IFaixa) * Aream2(ISTH, IFaixa)

            ' Parametros para o Indice de Prioridade
            IF VDMUni(IFaixa) > VDMmax THEN VDMmax = VDMUni(IFaixa)
            IF VDMUni(IFaixa) < VDMmin THEN VDMmin = VDMUni(IFaixa)
            IF PSIat(ISTH, IFaixa) > PSImax THEN PSImax = PSIat(ISTH, IFaixa)
            IF PSIat(ISTH, IFaixa) < PSImin THEN PSImin = PSIat(ISTH, IFaixa)

        NEXT IFaixa

        FOR IFaixa = 1 TO NFaixasMax

            INPUT #3, STH, ANORIG, REVORIG$, MARSHALL, RTDIAMET, VAZIOSAR, TEORASF
            INPUT #3, H1CM, BASE$, H2CM, CBRBS, RCS28DBASE, SUBBASE$
            INPUT #3, H3CM, CBRSUB, RCS28DSUBB, REFSL$, H4CM, CBRREF
            INPUT #3, SL$, CBRSL, LLSL, IPSL, P200SL, PROFROCHAm

            IF IFaixa <= NFaixas THEN
                IF (ANORIG > ANOatual OR ANORIG < 1900) THEN
                    Idade(IFaixa) = 15
                    AnoOriginal(IFaixa) = 1969
                ELSE
                    Idade(IFaixa) = ANOatual - ANORIG
                    AnoOriginal(IFaixa) = ANORIG
                END IF
                UltRest$(IFaixa) = "NONE"
                H1REV(IFaixa) = H1CM
                REVEST$(IFaixa) = REVORIG$
                CamBase$(IFaixa) = BASE$
                NUnidAnalise = NUnidAnalise + 1

                Hrev(IFaixa) = H1CM
                REV$(IFaixa) = UCASE$(REVORIG$)
                BASEorig$(IFaixa) = UCASE$(BASE$)
                SELECT CASE REV$(IFaixa)
                    CASE "CBUQ": A1 = .44
                    CASE "CBUQ+PMQ": A1 = .42
                    CASE "PMQ": A1 = .4
                    CASE "PMF": A1 = .36
                    CASE ELSE: A1 = .33
                END SELECT
                SELECT CASE BASEorig$(IFaixa)
                    CASE "BGTC", "CCR", "CCP": A2 = .25
                    CASE "SOLO-CIMENTO", "SOLO-CAL": A2 = .23
                    CASE "MB", "PMQ": A2 = .2
                    CASE "BG", "MS", "MH": A2 = .14
                    CASE ELSE: A2 = .12
                END SELECT
                IF CBRSUB >= 30 THEN
                    A3 = .11
                ELSE
                    A3 = 0
                END IF
                IF CBRREF >= 30 THEN
                    A4 = .11
                ELSE
                    A4 = 0
                END IF
                SNorig(IFaixa) = (A1 * H1CM + A2 * H2CM + A3 * H3CM + A4 * H4CM) / 2.54
            END IF

        NEXT IFaixa

        ' Leitura do Historico de Manutencao:
        ARQUIVO$ = CALC$ + "STHS.DAT"
        OPEN ARQUIVO$ FOR INPUT AS #15
        FOR I = 1 TO NSTH
            INPUT #15, PATHHM$
            IF I = ISTH THEN ARQHM$ = PATHHM$
        NEXT I
        CLOSE #15
        OPEN ARQHM$ FOR INPUT AS #15
        LINE INPUT #15, LINHA$
        WHILE EOF(15) = FALSE
            INPUT #15, Interv, Mes$, ANO, Tipo$(1), H(1), HC(1), F1PArea, Tipo$(2), H(2), HC(2), F2PArea
            INPUT #15, Tipo$(3), H(3), HC(3), F3PArea, Tipo$(4), H(4), HC(4), F4PArea
            IF Interv > 0 THEN
                Mes$ = UCASE$(Mes$)
                SELECT CASE Mes$
                    CASE "JAN": MONTH = .5
                    CASE "FEV": MONTH = 1.5
                    CASE "MAR": MONTH = 2.5
                    CASE "ABR": MONTH = 3.5
                    CASE "MAI": MONTH = 4.5
                    CASE "JUN": MONTH = 5.5
                    CASE "JUL": MONTH = 6.5
                    CASE "AGO": MONTH = 7.5
                    CASE "SET": MONTH = 8.5
                    CASE "OUT": MONTH = 9.5
                    CASE "NOV": MONTH = 10.5
                    CASE "DEZ": MONTH = 11.5
                    CASE ELSE: MONTH = 6
                END SELECT
                MONTH = MONTH / 12
                ANO = ANO + MONTH
                Age = ANOatual - ANO
                IF Age > 0 THEN
                    FOR IFaixa = 1 TO NFaixas
                        Tipo$(IFaixa) = UCASE$(Tipo$(IFaixa))
                        TIPOMED$ = Tipo$(IFaixa)
                        SELECT CASE TIPOMED$
                            CASE "", "CR", "CL", "NENHUMA", "NADA"
                                AnoFim(IFaixa) = ANOatual
                                PSIfim(IFaixa) = PSIat(ISTH, IFaixa)
                            CASE "CP"
                                IF Age <= Idade(IFaixa) THEN
                                    UltRest$(IFaixa) = Tipo$(IFaixa)
                                    HrecExist(IFaixa) = H(IFaixa)
                                    Idade(IFaixa) = Age
                                END IF
                                H1REV(IFaixa) = H1REV(IFaixa) + H(IFaixa)
                                REVEST$(IFaixa) = Tipo$(IFaixa)
                                AnoFim(IFaixa) = ANO
                                IF (PISTA$ = "DUPLA" AND IFaixa = 1) THEN
                                    PSIfim(IFaixa) = 3.3
                                ELSE
                                    PSIfim(IFaixa) = 2.7
                                END IF
                            CASE "MICROCA", "MICRO CA", "LAMA ASF.", "LAMA ASFALTICA", "TSD", "TST", "PMF", "TSS"
                                IF Age <= Idade(IFaixa) THEN
                                    UltRest$(IFaixa) = "CBUQ"
                                    HrecExist(IFaixa) = H(IFaixa)
                                    Idade(IFaixa) = Age
                                END IF
                                H1REV(IFaixa) = H1REV(IFaixa) + H(IFaixa)
                                REVEST$(IFaixa) = "CBUQ"
                                IRest(IFaixa) = 1
                                AnoFim(IFaixa) = ANO
                                IF (PISTA$ = "DUPLA" AND IFaixa = 1) THEN
                                    PSIfim(IFaixa) = 3.3
                                ELSE
                                    PSIfim(IFaixa) = 2.7
                                END IF
                            CASE "RS", "FR+RC", "CBUQ", "MF+RC", "PMQ", "AAQ", "CBUQ+PMQ", "BINDER", "CAPA", "REPERF.", "REPERFILAGEM", "PMQA", "CBUQ+PMF", "CPA"
                                IF Age <= Idade(IFaixa) THEN
                                    UltRest$(IFaixa) = Tipo$(IFaixa)
                                    HrecExist(IFaixa) = H(IFaixa)
                                    Idade(IFaixa) = Age
                                END IF
                                H1REV(IFaixa) = H1REV(IFaixa) + H(IFaixa) - HC(IFaixa)
                                REVEST$(IFaixa) = "CBUQ"
                                IRest(IFaixa) = 1
                                AnoFim(IFaixa) = ANO
                                IF (PISTA$ = "DUPLA" AND IFaixa = 1) THEN
                                    PSIfim(IFaixa) = 3!
                                ELSE
                                    PSIfim(IFaixa) = 2.3
                                END IF
                            CASE "RRV", "RRP", "RRT"
                                IF Age <= Idade(IFaixa) THEN
                                    UltRest$(IFaixa) = Tipo$(IFaixa)
                                    Idade(IFaixa) = Age
                                END IF
                                H1REV(IFaixa) = H(IFaixa)
                                REVEST$(IFaixa) = "CBUQ"
                                IRest(IFaixa) = 0
                                AnoFim(IFaixa) = ANO
                                IF (PISTA$ = "DUPLA" AND IFaixa = 1) THEN
                                    PSIfim(IFaixa) = 2.5
                                ELSE
                                    PSIfim(IFaixa) = 1.5
                                END IF
                            CASE "BG"
                                IF Age <= Idade(IFaixa) THEN
                                    UltRest$(IFaixa) = Tipo$(IFaixa)
                                    Idade(IFaixa) = Age
                                END IF
                                H1REV(IFaixa) = 0
                                REVEST$(IFaixa) = "CBUQ"
                                IRest(IFaixa) = 0
                                AnoFim(IFaixa) = ANO
                                IF (PISTA$ = "DUPLA" AND IFaixa = 1) THEN
                                    PSIfim(IFaixa) = 2.5
                                ELSE
                                    PSIfim(IFaixa) = 1.5
                                END IF
                            CASE ELSE
                                PRINT "ERRO"
                        END SELECT
                    NEXT IFaixa
                END IF
            ELSE
                FOR IFaixa = 1 TO NFaixas
                    AnoFim(IFaixa) = ANOatual
                    PSIfim(IFaixa) = PSIat(ISTH, IFaixa)
                NEXT IFaixa
            END IF
        WEND
        CLOSE #15

        ' Demais dados:

        QREF = 4100
        FOR IFX = 1 TO NFaixasMax
            IDFX = NDADOS + NFaixasMax + IFX
            INPUT #IDFX, STH, CARGADEF(IFX), DF1, DF2, DF3, DF4, DF5, DF6, DF7
            INPUT #IDFX, NPTSDF, TAR, TSUP(IFX), R1CM, R2CM, R3CM, R4CM, R5CM, R6CM, R7CM
            INPUT #IDFX, FIPLACA, DATADEFLX$, EQUIPDEFLX$
            AREA = PI# * (FIPLACA ^ 2) / 4
            PRESSAO = CARGADEF(IFX) / AREA
            NPTS(IFX) = NPTSDF
            IF DF1 > 0 THEN
                FATOR = QREF / CARGADEF(IFX)
                DF1 = FATOR * DF1
                IF TSUP(IFX) > 0 THEN
                    B = 15
                    P = QREF / (PI# * B * B)
                    E30C = 25000
                    E1T = E30C * .8 * EXP(-.0691 * (TSUP(IFX) - 30))
                    TREF = 25
                    E1TREF = E30C * .8 * EXP(-.0691 * (TREF - 30))
                    BLOC = (H1REV(IFX) * P / 2) * (1 + ((B / (B + H1REV(IFX))) ^ 2))
                    DF1 = DF1 - BLOC * ((1 / E1T) - (1 / E1TREF))
                END IF
                D0(IFX) = DF1
                DF2 = FATOR * DF2
                DF3 = FATOR * DF3
                DF4 = FATOR * DF4
                DF5 = FATOR * DF5
                DF6 = FATOR * DF6
                DF7 = FATOR * DF7
            ELSE
                IF REVEST$(IFX) = "CCP" THEN
                    D0(IFX) = 12
                ELSE
                    D0(IFX) = 60
                END IF
            END IF
            IF DF7 > 0 THEN
                IF (R5CM > 0 AND R7CM > 0 AND R5CM <> R7CM) THEN
                    IF DF5 > DF7 THEN
                        IF REVEST$(IFX) <> "CCP" THEN
                            HP = H1REV(IFX) + H2CM + H3CM + H4CM
                            X = 1.5 * HP
                            IF X <= R2CM THEN
                                X1 = R1CM: X2 = R2CM
                                Y1 = DF1: Y2 = DF2
                            ELSE
                                IF X <= R3CM THEN
                                    X1 = R2CM: X2 = R3CM
                                    Y1 = DF2: Y2 = DF3
                                ELSE
                                    IF X <= R4CM THEN
                                        X1 = R3CM: X2 = R4CM
                                        Y1 = DF3: Y2 = DF4
                                    ELSE
                                        IF X <= R5CM THEN
                                            X1 = R4CM: X2 = R5CM
                                            Y1 = DF4: Y2 = DF5
                                        ELSE
                                            IF X <= R6CM THEN
                                                X1 = R5CM: X2 = R6CM
                                                Y1 = DF5: Y2 = DF6
                                            ELSE
                                                X1 = R6CM: X2 = R7CM
                                                Y1 = DF6: Y2 = DF7
                                            END IF
                                        END IF
                                    END IF
                                END IF
                            END IF
                            Y = ((X2 * Y1 - X1 * Y2) / (X2 - X1)) + ((Y2 - Y1) / (X2 - X1)) * X
                            D15HP = Y
                            SIP = 10 * (D0(IFX) - D15HP)
                            HP = 10 * HP
                            IF (REVEST$(IFX) = "TSD" OR REVEST$(IFX) = "TST") THEN
                                K1 = .1165
                                K2 = -.3248
                                K3 = .8241
                            ELSE
                                K1 = .4728
                                K2 = -.481
                                K3 = .7581
                            END IF
                            SN(IFX) = K1 * (SIP ^ K2) * (HP ^ K3)
                            RAIO = FIPLACA / 2
                            Dist = 1.5 * HP / 10
                            ESL(IFX) = (700 / 774) * (1 - (.4 ^ 2)) * PRESSAO * (RAIO ^ 2) / (Dist * (D15HP / 1000))
                        END IF
                    ELSE
                        PRINT "ERRO"
                    END IF
                ELSE
                    PRINT "ERRO"
                END IF
            END IF
            IF ESL(IFX) < 50 THEN ESL(IFX) = 100 * CBRSL
            IF ESL(IFX) > 5000 THEN ESL(IFX) = 5000
        NEXT IFX

        ' - - - - - - - - - - - - - - - - - - - - - - - - - - -
        ' -   Calibracao do Modelo de Previsao de Desempenho  -
        ' - - - - - - - - - - - - - - - - - - - - - - - - - - -
     
        FOR IFaixa = 1 TO NFaixas
         
            FcNewPav = -1
            NContCal = 0
            FOR JJ = 1 TO NCalMax
                CodeOverlay(JJ) = -1
                FcOverlay(JJ) = -1
            NEXT JJ
            PT = 2.5
            DPSI = PSInovo - PT
            FcOverlay = -1

            ' Pavimento Original
            IF REVEST$(IFaixa) <> "CCP" THEN
                Vs = AnoFim(IFaixa) - AnoOriginal(IFaixa)
                IF Vs > 0 THEN
                    DeltaPSI = PSInovo - PSIfim(IFaixa)
                    IF DeltaPSI > .5 THEN
                        FATOR = (1 + (3 / 100)) ^ Vs
                        Nano0 = NANO(IFaixa) / FATOR
                        NacOrig = .000001 * Vs * (NANO(IFaixa) + Nano0) / 2
                        ALFAreq = (1 / NacOrig) * LOG(LOG(PSIfim(IFaixa) / 5) / LOG(PSInovo / 5))
                        MR = ESL(IFaixa) / .0703
                        BETA = .4 + (1094 / ((SNorig(IFaixa) + 1) ^ 5.19))
                        W18# = (((SNorig(IFaixa) + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                        W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
                        ALFAAASHTO = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo / 5))
                        FcNewPav = ALFAreq / ALFAAASHTO
                    END IF
                END IF
            END IF

            Age = Idade(IFaixa)
            PSI = PSIat(ISTH, IFaixa)
            Nacum(IFaixa) = Age * NANO(IFaixa)
            NE4 = Nacum(IFaixa) / 1000000!
            NYEAR = NANO(IFaixa) / 1000000!
            H1 = H1REV(IFaixa)
            IF REVEST$(IFaixa) <> "CCP" THEN
                IF SN(IFaixa) = 0 THEN SN(IFaixa) = .44 * (H1 / 2.54) + .14 * (H2CM / 2.54) + .11 * (H3CM / 2.54) + .07 * (H4CM / 2.54)
                LCBR = LOG(CBRSL) / LOG(10)
                SNC = SN(IFaixa) + 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
            END IF

            ' Modelo: PSI = f(t)
            ' Valor de Alfa requerido pelo pavimento existente
            IF NE4 <= 0 THEN
                ALFAL = 1
            ELSE
                IF (PSI <= 0 OR PSI >= 5) THEN
                    ALFAL = 1
                ELSE
                    ALFAL = (1 / NE4) * LOG(LOG(PSI / 5) / LOG(PSInovo / 5))
                END IF
            END IF
            IF REVEST$(IFaixa) = "CCP" THEN
                MR = 100 * CBRSL / .0703
                K = MR / 19.4
                D = H1 / 2.54
                CD = 1
                J = 3.2
                RTF = 650
                RTFMPA = RTF * .0703 / 10
                RCS = 10 * ((RTFMPA / .56) ^ 1.67)
                EC = 15110 * (RCS ^ .5)
                EC = EC / .0703
                S0 = .35
                NC = 50
                ZR = 0
                W18# = 215.63 * J * ((D ^ .75) - (18.42 / ((EC / K) ^ .25)))
                W18# = (4.22 - .32 * PT) * LOG(RTF * CD * ((D ^ .75) - 1.132) / W18#) / LOG(10)
                A# = (LOG(DPSI / (4.5 - 1.5)) / LOG(10)) / (1 + (1.624E+07 / ((D + 1) ^ 8.46)))
                W18# = W18# + A# - .06 + 7.35 * (LOG(D + 1) / LOG(10)) + ZR * S0
                W18# = (10 ^ W18#) / 1000000!
                FCmin = FCminCCP
                FCmax = FCmaxCCP
                ' Valor de Alfa pelo Guia da AASHTO
                ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo / 5))
                ' Calibracao regional
                ALFA(IFaixa) = 1! * ALFAA
                ALFAnew(IFaixa) = ALFA(IFaixa)
                SNcalib = D
            ELSE
                SNcalib = SN(IFaixa)
                MR = 100 * CBRSL / .0703
                BETA = .4 + (1094 / ((SNcalib + 1) ^ 5.19))
                W18# = (((SNcalib + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
                FCmin = FCminCA
                FCmax = FCmaxCA
                ' Valor de Alfa pelo Guia da AASHTO
                ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo / 5))
                ' Calibracao pelo HDM-III
                ALFAnew(IFaixa) = 1! * ALFAA
                IF IRest(IFaixa) = 1 THEN
                    IF HrecExist(IFaixa) <= 0 THEN
                        PRINT "ERRO"
                    ELSE
                        SNcalib = .44 * HrecExist(IFaixa) / 2.54
                        GOSUB 6800
                        MR = E / .0703
                        BETA = .4 + (1094 / ((SNcalib + 1) ^ 5.19))
                        W18# = (((SNcalib + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
                        W18# = W18# * ((MR / 3000) ^ 2.32) / 1000000!
                        FCmin = FCminRecap
                        FCmax = FCmaxRecap
                        ' Valor de Alfa pelo Guia da AASHTO
                        ALFAA = (1 / W18#) * LOG(LOG(PT / 5) / LOG(PSInovo / 5))
                        ' Calibracao pelo HDM-III
                        ALFA(IFaixa) = 1! * ALFAA
                        FcOverlay = ALFAL / ALFAA
                    END IF
                ELSE
                    ALFA(IFaixa) = ALFAnew(IFaixa)
                END IF
            END IF

            Ncasos = Ncasos + 1
            MRfound(IFaixa) = .0703 * MR
            ICalib(IFaixa) = 0
            IF PSI < PSInovo THEN
                Fc = ALFAL / ALFA(IFaixa)
                IF (Fc > FCmin AND Fc < FCmax) THEN
                    ICONTcalibra = ICONTcalibra + 1
                    ICalib(IFaixa) = 1
                    IF REVEST$(IFaixa) = "CCP" THEN
                        FCccp = FCccp + Fc
                        ICONTccp = ICONTccp + 1
                        FCccprede(IRodov) = FCccprede(IRodov) + Fc
                        ICONTpcc = ICONTpcc + 1
                    ELSE
                        IF IRest(IFaixa) = 1 THEN
                            FcRecap = FcRecap + Fc
                            ICONTrecap = ICONTrecap + 1
                            FCrecaprede(IRodov) = FCrecaprede(IRodov) + Fc
                            ICONTovl = ICONTovl + 1
                        ELSE
                            FcNovo = FcNovo + Fc
                            ICONTnovo = ICONTnovo + 1
                            FCnovorede(IRodov) = FCnovorede(IRodov) + Fc
                            ICONTnew = ICONTnew + 1
                        END IF
                    END IF
                ELSE
                    IF REVEST$(IFaixa) = "CCP" THEN
                        Fc = FCdefCCP
                    ELSE
                        IF IRest(IFaixa) = 1 THEN
                            Fc = FCdefRecap
                        ELSE
                            Fc = FCdefCA
                        END IF
                    END IF
                END IF
                ALPHA(IFaixa) = Fc
            ELSE
                IF REVEST$(IFaixa) = "CCP" THEN
                    ALPHA(IFaixa) = FCdefCCP
                ELSE
                    IF IRest(IFaixa) = 1 THEN
                        ALPHA(IFaixa) = FCdefRecap
                    ELSE
                        ALPHA(IFaixa) = FCdefCA
                    END IF
                END IF
            END IF

            ' Modelo: Irregularidade = f(t)
            IRIcor = QImed(IFaixa) / 13
            IRI0(IFaixa) = IRIcor * EXP(-.0153 * Age)
            IRI0(IFaixa) = IRI0(IFaixa) - 725 * ((1 + SNC) ^ -4.99) * NE4
            QI0 = 13 * IRI0(IFaixa)
            QI0min = 5
            QI0max = 40
            IF QI0 < QI0min THEN QI0 = QI0min
            IF QI0 > QI0max THEN QI0 = QI0max
            IRI0(IFaixa) = QI0 / 13
         
            ' Calibracao da correlacao PSI x IDS
            IF PSIat(ISTH, IFaixa) <= PSImax THEN
                'IGG = ALFAIGG * ((((PSIMAX / PSI) - 1) / .007635) ^ (1 / 1.065))
                ALFAI = IGG(IFaixa) / ((((PSImax / PSIat(ISTH, IFaixa)) - 1) / .007635) ^ (1 / 1.065))
                IF (ALFAI > .3 AND ALFAI < 3) THEN ALFAIGG(IFaixa) = ALFAI
            END IF

            PSIacost(IFaixa) = PSRACOST(IFaixa)
            DegrauAcost(IFaixa) = DEGRAUCM(IFaixa)

            ARQUIVO$ = CALC$ + "CALIBRA.CSV"
            OPEN ARQUIVO$ FOR APPEND AS #16
            WRITE #16, STH, IFaixa, FcNewPav, Hrev(IFaixa), REV$(IFaixa), BASEorig$(IFaixa)
            FOR JJ = 1 TO NContCal
                WRITE #16, CodeOverlay(JJ), FcOverlay(JJ)
            NEXT JJ
            CLOSE #16

            ARQUIVO$ = CALC$ + "RecCal.CSV"
            OPEN ARQUIVO$ FOR APPEND AS #16
            WRITE #16, STH, IFaixa, FcOverlay, ITR(IFaixa), Tipo$(IFaixa)
            CLOSE #16

        NEXT IFaixa

        IF DegrauAcost(1) >= 0 THEN
            IF DegrauAcost(NFaixas) >= 0 THEN
                DegrauMedio = (DegrauAcost(1) + DegrauAcost(NFaixas)) / 2
            ELSE
                DegrauMedio = DegrauAcost(1)
            END IF
        ELSE
            IF DegrauAcost(NFaixas) >= 0 THEN
                DegrauMedio = DegrauAcost(NFaixas)
            ELSE
                DegrauMedio = 0
            END IF
        END IF
        DegrauAcost(1) = DegrauMedio
        DegrauAcost(NFaixas) = DegrauMedio

        ' Arquivos onde sera' armazenada a condicao dos Subtrechos Homogeneos
        ARQUIVO$ = CALC$ + "ESTSTHS.DAT"
        OPEN ARQUIVO$ FOR APPEND AS #15
        WRITE #15, STH, NFaixas, KMI, KMF, H1REV(1), H1REV(2), H1REV(3), H1REV(4), HrecExist(1), HrecExist(2), HrecExist(3), HrecExist(4), Idade(1), Idade(2), Idade(3), Idade(4), SN(1), SN(2), SN(3), SN(4), CBRSL
        WRITE #15, STH, QImed(1), QImed(2), QImed(3), QImed(4), NANO(1), NANO(2), NANO(3), NANO(4), IRI0(1), IRI0(2), IRI0(3), IRI0(4), ALFA(1), ALFA(2), ALFA(3), ALFA(4), ALFAnew(1), ALFAnew(2), ALFAnew(3), ALFAnew(4)
        WRITE #15, STH, FatorVDM, FatorTraf, Nacum(1), Nacum(2), Nacum(3), Nacum(4), REVEST$(1), REVEST$(2), REVEST$(3), REVEST$(4), CamBase$(1), ALFAIGG(1), ALFAIGG(2), ALFAIGG(3), ALFAIGG(4)
        FOR IFaixa = 1 TO NFaixas
            WRITE #15, STH, IFaixa, PSIat(ISTH, IFaixa), Aream2(ISTH, IFaixa), VidaRes(IFaixa), VDMUni(IFaixa), PSInovo, ICalib(IFaixa), IRest(IFaixa), ALPHA(IFaixa), D0(IFaixa), MRfound(IFaixa)
            WRITE #15, AreaAcost(IFaixa), PSIacost(IFaixa), DegrauAcost(IFaixa)
        NEXT IFaixa
        CLOSE #15

        ARQUIVO$ = CALC$ + "EST" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR APPEND AS #15
        WRITE #15, STH, KMI, KMF, NANO(1), NANO(2), NANO(3), NANO(4), PSIat(ISTH, 1), VidaRes(1), VDMUni(1), PSIat(ISTH, 2), VidaRes(2), VDMUni(2), PSIat(ISTH, 3), VidaRes(3), VDMUni(3), PSIat(ISTH, 4), VidaRes(4), VDMUni(4)
        CLOSE #15
        ARQUIVO$ = CALC$ + "CALB" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR APPEND AS #15
        WRITE #15, STH, KMI, KMF, ALPHA(1), ALPHA(2), ALPHA(3), ALPHA(4)
        CLOSE #15
        ARQUIVO$ = CALC$ + "INT" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR APPEND AS #15
        WRITE #15, STH, UltRest$(1), UltRest$(2), UltRest$(3), UltRest$(4)
        CLOSE #15

    NEXT ISUB

    FOR ILL = 1 TO 14
        CLOSE #ILL
    NEXT ILL

    IF ICONTovl > 0 THEN
        FCrecaprede(IRodov) = FCrecaprede(IRodov) / ICONTovl
    ELSE
        FCrecaprede(IRodov) = FCdefRecap
    END IF
    IF ICONTnew > 0 THEN
        FCnovorede(IRodov) = FCnovorede(IRodov) / ICONTnew
    ELSE
        FCnovorede(IRodov) = FCdefCA
    END IF
    IF ICONTpcc > 0 THEN
        FCccprede(IRodov) = FCccprede(IRodov) / ICONTpcc
    ELSE
        FCccprede(IRodov) = FCdefCCP
    END IF

NEXT IRodov
CLOSE #17
 
IF ICONTrecap > 0 THEN
    FcRecap = FcRecap / ICONTrecap
ELSE
    FcRecap = FCdefRecap
END IF
IF ICONTnovo > 0 THEN
    FcNovo = FcNovo / ICONTnovo
ELSE
    FcNovo = FCdefCA
END IF
IF ICONTccp > 0 THEN
    FCccp = FCccp / ICONTccp
ELSE
    FCccp = FCdefCCP
END IF
 
PSImed = PSImed / AreaTotal
NPSI = 100 * NPSI / NUnidAnalise
 
ARQUIVO$ = CALC$ + "ESTSTHS.DAT"
OPEN ARQUIVO$ FOR APPEND AS #15
WRITE #15, PSImed, NPSI
WRITE #15, AreaTotal, NUnidAnalise
CLOSE #15

ARQUIVO$ = CALC$ + "IP.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, VDMmin, VDMmax
WRITE #1, PSImin, PSImax
CLOSE #1

ARQUIVO$ = CALC$ + "CALIB.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, "Trecho", "FC novo", "FC recap", "FC ccp"
FOR I = 1 TO NRODOV
    WRITE #1, Trecho$(I), FCnovorede(I), FCrecaprede(I), FCccprede(I)
NEXT I
WRITE #1, "Rede", FcNovo, FcRecap, FCccp
CLOSE #1

ARQUIVO$ = CALC$ + "CALIB.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, FcNovo
WRITE #1, FcRecap
WRITE #1, FCccp
CLOSE #1

ARQUIVO$ = CALC$ + "IDS.OUT"
OPEN ARQUIVO$ FOR INPUT AS #14

VRmed = 0!
ARQUIVO$ = CALC$ + "ESTSTHS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR OUTPUT AS #13

IF CALIBRA$ = "FALSE" THEN
    ARQUIVO$ = CALC$ + "ESTSTHS.OUT"
    OPEN ARQUIVO$ FOR INPUT AS #10
END IF

ISTH = 0
FOR IRodov = 1 TO NRODOV

    ' Parametros que definem as Arvores de Decisao:
    ARQUIVO$ = CALC$ + "ARV" + Rodov$(IRodov) + ".dat"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, IDScrit
    INPUT #1, PSRcrit
    INPUT #1, HRMIN
    INPUT #1, HRMAX
    INPUT #1, PSIf
    INPUT #1, DEGRAUadm
    INPUT #1, HCMIN
    INPUT #1, VUMin
    INPUT #1, QI0adm
    INPUT #1, HbaseAcost
    CLOSE #1

    ARQUIVO$ = CALC$ + "INT" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #11
    LINE INPUT #11, LINHA$

    FOR ISUB = 1 TO NSTHRODOV(IRodov)

        ISTH = ISTH + 1

        INPUT #11, STH, UltRest$(1), UltRest$(2), UltRest$(3), UltRest$(4)

        INPUT #12, STH, NFaixas, KMI, KMF, H1REV(1), H1REV(2), H1REV(3), H1REV(4), HrecExist(1), HrecExist(2), HrecExist(3), HrecExist(4), Idade(1), Idade(2), Idade(3), Idade(4), SN(1), SN(2), SN(3), SN(4), CBRSL
        INPUT #12, STH, QImed(1), QImed(2), QImed(3), QImed(4), NANO(1), NANO(2), NANO(3), NANO(4), IRI0(1), IRI0(2), IRI0(3), IRI0(4), ALFA(1), ALFA(2), ALFA(3), ALFA(4), ALFAnew(1), ALFAnew(2), ALFAnew(3), ALFAnew(4)
        INPUT #12, STH, FatorVDM, FatorTraf, Nacum(1), Nacum(2), Nacum(3), Nacum(4), REVEST$(1), REVEST$(2), REVEST$(3), REVEST$(4), BASE$, ALFAIGG(1), ALFAIGG(2), ALFAIGG(3), ALFAIGG(4)

        IF CALIBRA$ = "FALSE" THEN
            INPUT #10, STH, NFaixas, KMI, KMF, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A
            INPUT #10, STH, A, A, A, A, A, A, A, A, A, A, A, A, ALFA(1), ALFA(2), ALFA(3), ALFA(4), ALFAnew(1), ALFAnew(2), ALFAnew(3), ALFAnew(4)
            INPUT #10, STH, A, A, A, A, A, A, B$, B$, B$, B$, B$, A, A, A, A
        END IF

        FOR IFaixa = 1 TO NFaixas

            INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo, ICalib(IFX), IRest(IFX), ALPHA(IFX), D0(IFX), MRfound(IFX)
            INPUT #12, AreaAcost(IFX), PSIacost(IFX), DegrauAcost(IFX)

            IF CALIBRA$ = "FALSE" THEN
                INPUT #10, STH, IFX, A, A, A, A, PSInovo, ICalib(IFX), IRest(IFX), ALPHA(IFX), A, A
                INPUT #10, A, A, A
            END IF

            IF ICalib(IFaixa) = 0 THEN
                IF REVEST$(IFaixa) = "CCP" THEN
                    ALPHA(IFaixa) = FCccprede(IRodov)
                    FChr = FcRecap
                ELSE
                    FChr = FCrecaprede(IRodov)
                    IF IRest(IFaixa) = 0 THEN
                        ALPHA(IFaixa) = FCnovorede(IRodov)
                    ELSE
                        ALPHA(IFaixa) = FCrecaprede(IRodov)
                    END IF
                END IF
            ELSE
                IF IRest(IFaixa) = 0 THEN
                    FChr = FCrecaprede(IRodov)
                ELSE
                    FChr = ALPHA(IFaixa)
                END IF
            END IF
            ALFAG = ALFA(IFaixa) * ALPHA(IFaixa)
            ' Estimativa da Vida Restante
            NYEAR = NANO(IFaixa) / 1000000!
            Age = Idade(IFaixa)
            GOSUB 6000
            VidaRes(IFaixa) = VR
            VRmed = VRmed + VR * Aream2(ISTH, IFaixa)
            ' Espessura efetiva de reforco existente
            PSI = PSIat(ISTH, IFaixa)
            NYEAR = NANO(IFaixa)
            QI = QImed(IFaixa)
            GOSUB 1700

        NEXT IFaixa

        WRITE #13, STH, NFaixas, KMI, KMF, CBRSL, FatorVDM, FatorTraf, BASE$
        FOR IFX = 1 TO NFaixas
            WRITE #13, IFX, H1REV(IFX), HrecExist(IFX), Idade(IFX), SN(IFX), QImed(IFX), NANO(IFX), IRI0(IFX), ALPHA(IFX), Nacum(IFX), REVEST$(IFX), ALFAIGG(IFX)
            WRITE #13, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes(IFX), VDMUni(IFX), PSInovo, Heff(IFX), IRest(IFX), ICalib(IFX), D0(IFX), MRfound(IFX)
            WRITE #13, AreaAcost(IFX), PSIacost(IFX), DegrauAcost(IFX)
        NEXT IFX

        ' Indice de Defeitos de Superficie
        INPUT #14, ISTHH, IGG(1), IGG(2), IGG(3), IGG(4)

        ARQUIVO$ = CALC$ + "Nec" + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR APPEND AS #15
        I = ISTH
        FOR J = 1 TO NFaixas
            QI(J) = QImed(J)
            VI(J) = VidaRes(J)
        NEXT J
        FOR J = (NFaixas + 1) TO NFaixasMax
            D0(J) = -1
            PSIat(I, J) = -1
            VI(J) = -1
            IGG(J) = -1
            Idade(J) = -1
            QI(J) = -1
        NEXT J
        WRITE #15, STH, KMI, KMF, PSIat(I, 1), VI(1), IGG(1), Idade(1), PSIat(I, 2), VI(2), IGG(2), Idade(2), PSIat(I, 3), VI(3), IGG(3), Idade(3), PSIat(I, 4), VI(4), IGG(4), Idade(4), D0(1), D0(2), D0(3), D0(4), QI(1), QI(2), QI(3), QI(4)
        CLOSE #15

    NEXT ISUB
    CLOSE #11

NEXT IRodov
INPUT #12, PSImed, NPSI
INPUT #12, AreaTotal, NUnidAnalise
VRmed = VRmed / AreaTotal
WRITE #13, PSImed, NPSI, VRmed
WRITE #13, AreaTotal, NUnidAnalise

IF CALIBRA$ = "FALSE" THEN
    INPUT #10, PSImed, NPSI
    INPUT #10, AreaTotal, NUnidAnalise
    CLOSE #10
END IF
CLOSE #12, #13, #14
  
ICONTcalibra = 100 * ICONTcalibra / Ncasos
ARQUIVO$ = CALC$ + "PerctCal.OUT"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, ICONTcalibra
CLOSE #1

SYSTEM

1700 ' - - - - - - - - - - - - - - - - - - - - - - - - -
' -     Espessura de reforco efetiva existente    -
' -                  (Subrotina)                  -
' - - - - - - - - - - - - - - - - - - - - - - - - -
A1 = .44
IF VR > 0 THEN
    IPER = INT(VR)
    NANO = NYEAR / 1000000!
    IF VR > 1 THEN
        NPA = NANO
        FOR IVR = 2 TO IPER
            NANO = NANO * (1 + (FatorTraf / 100))
            NPA = NPA + NANO
        NEXT IVR
        NPA = NPA + NANO * (VR - IPER)
    ELSE
        NPA = NANO * VR
    END IF
    SNP = A1 * .5 / 2.54
    NP = 0
    WHILE NP < NPA
        SNP = SNP + .01
        HRmodel = 2.54 * SNP / A1
        IF QI > 19 THEN
            QId = 19 + ((QI - 19) / (.602 * HRmodel + 1))
        ELSE
            QId = QI
        END IF
        PSIQI = 5 * EXP(-QId / 71.5)
        PSR = 5
        PSI0 = (PSIQI + PSR) / 2
        IF PSI0 > 4.95 THEN PSI0 = 4.95
        DPSI = PSI0 - 2.5
        IF DPSI > 0 THEN
            B = 30
            P = QREF / (PI# * B * B / 4)
            E = 2 * (1 - .33 * .33) * P * (B / 2) / (D0(IFaixa) / 1000)
            MR = E / .0703
            BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
            W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
            W18 = W18 * ((MR / 3000) ^ 2.32) / 1000000!
            ALFAA = (1 / W18) * LOG(LOG(2.5 / 5) / LOG(PSI0 / 5))
            ALFA = ALFAA * FChr
            NP = (1 / ALFA) * LOG(LOG(PSIf / 5) / LOG(PSI0 / 5))
        END IF
    WEND
    Heff(IFaixa) = HRmodel
ELSE
    Heff(IFaixa) = 0
END IF
RETURN


6000 ' - - - - - - - - - - - - - - - - - - - - - - - - - -
' -      Calculo da Vida Residual do Pavimento      -
' -                   (Subrotina)                   -
' -  Dados: PSI, PSIf, ALFAG, NYEAR, Age            -
' -  Saida: VR, IVR                                 -
' - - - - - - - - - - - - - - - - - - - - - - - - - -
VR = 0
DELTAT = .1
IF REVEST$(IFaixa) = "CCP" THEN
    VRmax = 45
    VRmin = 4
ELSE
    VRmax = 25
    VRmin = 2
END IF
dPSIdtmin = 2! / VRmax
dPSIdtmax = 2! / VRmin
DPSImin = dPSIdtmin * DELTAT
DPSImax = dPSIdtmax * DELTAT
PSIatual = PSIat(ISTH, IFaixa)
IF PSIatual > PSIf THEN
    WHILE PSIatual > PSIf
        VR = VR + DELTAT
        DELTAN = DELTAT * NYEAR * (FatorTraf ^ VR)
        SELECT CASE UltRest$(IFaixa)
            CASE "TSS"
                JCP = 1
                DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
            CASE "LAMA ASF.", "LAMA ASFALTICA"
                JCP = 2
                DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
            CASE "MICROCA", "MICRO CA"
                JCP = 6
                DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
                DeltaPSI = DeltaPSI * 1.2 / HrecExist(IFaixa)
            CASE "TSD"
                JCP = 7
                DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
            CASE "CP"
                JCP = 4
                DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
            CASE "TST"
                JCP = 8
                DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
            CASE "PMF"
                JCP = 3
                DeltaPSI = -(Arest(JCP) + Brest(JCP) * D0(IFaixa)) * DELTAN
            CASE ELSE
                DeltaPSI = ALFAG * DELTAN * PSIatual * LOG(PSIatual / 5)
        END SELECT
        IF ABS(DeltaPSI) > DPSImax THEN DeltaPSI = -DPSImax
        IF ABS(DeltaPSI) < DPSImin THEN DeltaPSI = -DPSImin
        PSIatual = PSIatual + DeltaPSI
    WEND
END IF
IF VR = DELTAT THEN VR = 0
IF (Age > 0 AND Age < VRmax) THEN VRmax = VRmax - Age
IF VR > VRmax THEN
    VR = VRmax
    IVR = 1
ELSE
    IVR = 0
END IF
RETURN


6800 ' - - - - - - - - - - - - - - - - - - - - - - - - -
' -  Modulo de Elasticidade da Camada Subjacente  -
' -                  (Subrotina)                  -
' - - - - - - - - - - - - - - - - - - - - - - - - -
B = 15
P = QREF / (PI# * B * B)
'DCantigo = D0(IFaixa) * 10 ^ (HrecExist(IFaixa) / 40)
'E = 2 * (1 - .35 * .35) * P * B / (DCantigo / 1000)
EP = 30000
ERROABS = 100
MR = 1000
WHILE ERROABS > 1!
    DELTA = 1 + ((HrecExist(IFaixa) / B) * ((EP / MR) ^ (1 / 3))) ^ 2
    DELTA = 1 / (MR * (DELTA ^ (1 / 2)))
    BLOC = (1 - (1 / ((1 + ((HrecExist(IFaixa) / B) ^ 2)) ^ .5))) / EP
    DELTA = 1.5 * P * B * (DELTA + BLOC)
    DELTA = 1000 * DELTA
    ERRO = (DELTA - D0(IFaixa)) / D0(IFaixa)
    FATOR = 1 + .3 * ERRO
    MR = MR * FATOR
    ERROABS = 100 * ABS(ERRO)
WEND
E = MR
RETURN


