CLS

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DadosAnoBase$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DadosAnoBase$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodov$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodov$(I)
NEXT I
CLOSE #1

' Vetores e Matrizes associados `as faixas de trafego:
NPolos = NRODOV: NFaixasMax = 4: NClasses = 39
DIM CustoFaixa(NFaixasMax), MedidaAcost$(NFaixasMax), HRAC(NFaixasMax)
DIM H2AC(NFaixasMax), MedidaF$(NFaixasMax), Hfres(NFaixasMax), Hrec(NFaixasMax)
DIM CustoP(NPolos), ConserP(NPolos), UltCamada$(NFaixasMax), VDMUni(NFaixasMax)
DIM REVEST$(NFaixasMax), Nacum(NFaixasMax), VidaRes(NFaixasMax), CotaFaixa(NFaixasMax)
DIM ALFAIGG(NFaixasMax), Restaurado$(NFaixasMax), PSInovo(NFaixasMax), SN(NFaixasMax)
DIM HREFORCO(NFaixasMax), HRef(NFaixasMax), Heff(NFaixasMax), IRec(NFaixasMax)
DIM ICalib(NFaixasMax), D0(NFaixasMax), MRfound(NFaixasMax)
DIM DegrauAcost(NFaixasMax), CustoAcost(NFaixasMax)

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Numero total de Subtrechos Homogeneos da rede
NSTH = 0
FOR I = 1 TO NRODOV
    NSTH = NSTH + NSTHRODOV(I)
NEXT I

' - - - - - - - - - - - -
' - Vetores e Matrizes  -
' - - - - - - - - - - - -
P = NPeriodos
DIM kmCA(NRODOV, P), kmMF(NRODOV, P), kmCP(NRODOV, P), kmFR(NRODOV, P)
DIM kmBG(NRODOV, P), kmRE(NRODOV, P), kmRP(NRODOV, P), kmPT(NRODOV, P)
DIM kmPMF(NRODOV, P), kmTSS(NRODOV, P), kmTSD(NRODOV, P)
DIM kmBASE(NRODOV, P), kmREM(NRODOV, P), kmREP(NRODOV, P), kmPi(NRODOV, P)

DIM VRmed(NPeriodos), TR23(NSTH, NFaixasMax), Nano(NSTH, NFaixasMax)
DIM PSIat(NSTH, NFaixasMax), PPrest(NPeriodos)
DIM PSImed(NPeriodos), Aream2(NSTH, NFaixasMax), AreaAcost(NSTH, NFaixasMax)
DIM PSImedSTH(NSTH), VSMIN(NPP), Npsi(NPeriodos), PSIt(1), NFaixas(NSTH)
DIM STH(NSTHMAX), PSIacost(NSTH, NFaixasMax), COV(NPeriodos, NRODOV)

' Arquivo de configuracao do problema a ser analisado:
ARQUIVO$ = CALC$ + "MODO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
CLOSE #1

ARQUIVO$ = CALC$ + "Quant.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, Quant
CLOSE #1
IF Quant = 1 THEN GeraDet$ = "S" ELSE GeraDet$ = "N"

' Percentagem da area que deve receber reparos localizados (CL)
DIM PSIitemCL(15), ARepCL(15)
ARQUIVO$ = CALC$ + "REPAROS.CSV"
OPEN ARQUIVO$ FOR INPUT AS #1
LINE INPUT #1, LINHA$
NitensCL = 0
WHILE NOT EOF(1)
    NitensCL = NitensCL + 1
    INPUT #1, PSIitemCL(NitensCL), ARepCL(NitensCL)
WEND
CLOSE #1

SELECT CASE MODO
    CASE 1
        ARQUIVO$ = CALC$ + "DadoEstr.dat"
        MODOANALISE$ = "EstratBase"
        ARQ$ = "EB"
        NPer = NPeriodos
    CASE 2
        ARQUIVO$ = CALC$ + "DadoEstr.dat"
        MODOANALISE$ = "EstratRO"
        ARQ$ = "RO"
        NPer = NPeriodos
    CASE 0
        ARQUIVO$ = CALC$ + "Dados.dat"
        MODOANALISE$ = "EVOLUI"
        ARQ$ = "EVO"
        NPer = NPeriodos
    CASE 5
        ARQUIVO$ = CALC$ + "Dados.dat"
        MODOANALISE$ = "NECESSIDADES"
        ARQ$ = "NAT"
        NPer = 1
    CASE ELSE
        PRINT "ERRO"
END SELECT
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, MODO
INPUT #1, PPmin
INPUT #1, PPmax
INPUT #1, NPP
INPUT #1, inflacao
CLOSE #1

DIM Custo(NRODOV, NPeriodos), ANO(NPeriodos), C$(60)

ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #12
ISTH = 0
FOR IRodov = 1 TO NRODOV
    COV(0, IRodov) = 0
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #12, STH, NFaixas(ISTH), KMI, KMF, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFaixas(ISTH)
            INPUT #12, IFX, H1REV, HrecExist, Idade, SN, QImed, Nano(ISTH, IFX), IRI0, Nacum, REVEST$, ALFAIGG
            INPUT #12, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes, VDMUni, PSInovo, Heff, IRec, ICalib, D0, MRfound
            INPUT #12, ALPHA0, ALPHA, ALPHA2, AreaAcost(ISTH, IFX), PSIacost(ISTH, IFX), DegrauAcost, T0, TR23(ISTH, IFX), CBRSL, CamBase$, VDMc, ATRmed
            ' Custos Operacionais dos Veiculos
            BLOC = .00001 * (QImed ^ 2) + .0031 * QImed + 1.0091
            COV(0, IRodov) = COV(0, IRodov) + BLOC * (VDMUni / 1000) * ABS(KMF - KMI) / 10
        NEXT IFaixa
    NEXT ISUB
NEXT IRodov
INPUT #12, PSImed(0), Npsi(0), VRmed(0)
INPUT #12, AreaTotal, NUnidAnalise
CLOSE #12

FOR IRodov = 1 TO NRODOV
    FOR ANO = 1 TO NPer
        COV(ANO, IRodov) = 0
    NEXT ANO
NEXT IRodov
FOR ANO = 1 TO NPer
    ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
    OPEN ARQUIVO$ FOR INPUT AS #10
    ISTH = 0
    FOR IRodov = 1 TO NRODOV
        FOR ISUB = 1 TO NSTHRODOV(IRodov)
            ISTH = ISTH + 1
            INPUT #10, STH, KMI, KMF
            FOR IFX = 1 TO NFaixas(ISTH)
                INPUT #10, STH, IFaixa, PSI, Area, VidaRes, Restaurado$, UltCamada$, VDMUni, PSInovo, HRef, Heff, IRec, ICalib, D0, MRfound
                INPUT #10, H1REV, HrecExist, Idade, SN, QImed, Nanual, IRI0, Nacum, ALFAIGG, ATRmed
                INPUT #10, ALPHA0, ALPHA, ALPHA2, AreaAc, PSIac, DegrauAcost, T0, TRx23, CBRSL, CamBase$, VDMc
                ' Custos Operacionais dos Veiculos
                BLOC = .00001 * (QImed ^ 2) + .0031 * QImed + 1.0091
                COV(ANO, IRodov) = COV(ANO, IRodov) + BLOC * (VDMUni / 1000) * ABS(KMF - KMI) / 10
            NEXT IFX
        NEXT ISUB
    NEXT IRodov
    INPUT #10, PSImed(0), Npsi(0), VRmed(0)
    INPUT #10, AreaTotal, NUnidAnalise
    CLOSE #10
NEXT ANO
  
IF ARQ$ <> "NAT" THEN
    FOR IRodov = 1 TO NRODOV
        ARQUIVO$ = CALC$ + "CV" + ARQ$ + Rodov$(IRodov) + ".CSV"
        OPEN ARQUIVO$ FOR OUTPUT AS #10
        WRITE #10, "Ano", "Custop"
        FOR ANO = 0 TO NPer
            WRITE #10, ANO, COV(ANO, IRodov)
        NEXT ANO
        CLOSE #10
    NEXT IRodov
END IF

' - - - - - - - - - - - - - - - - - - - - - - - - -
' -  Gera os Arquivos de Intervencoes por Rodovia -
' - - - - - - - - - - - - - - - - - - - - - - - - -

FOR IRodov = 1 TO NRODOV

    ARQUIVO$ = CALC$ + ARQ$ + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #14
    LINE INPUT #14, LINHA$

    ARQUIVO$ = CALC$ + ARQ$ + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR OUTPUT AS #13
    WRITE #13, "Ano", "STH", "Iniciokm", "Finalkm", "AcostLE", "HRACLE", "H2ACLE", "MedidaF1", "Hfrescm1", "HReccm1", "MedidaF2", "Hfrescm2", "HReccm2", "MedidaF3", "Hfrescm3", "HReccm3", "MedidaF4", "Hfrescm4", "HReccm4", "AcostLD", "HRACLD", "H2ACLD"

    FOR ANO = 1 TO NPer
        ISTH = 0
        FOR IR = 1 TO NRODOV
            FOR ISUB = 1 TO NSTHRODOV(IR)
                ISTH = ISTH + 1
                N = NFaixas(ISTH)
                INPUT #14, Y, J, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(N), HRAC(N), H2AC(N)
                IF IRodov = IR THEN
                    temp$ = "&, &, ###.###, ###.###, &, ###.#, ###.#, &, ###.#, ###.#, &, ###.#, ###.#, &, ###.#, ###.#, &, ###.#, ###.#, &, ###.#, ###.#"
                    PRINT #13, USING temp$; STR$(Y); STR$(J); KMI; KMF; MedidaAcost$(1); HRAC(1); H2AC(1); MedidaF$(1); Hfres(1); Hrec(1); MedidaF$(2); Hfres(2); Hrec(2); MedidaF$(3); Hfres(3); Hrec(3); MedidaF$(4); Hfres(4); Hrec(4); MedidaAcost$(N); HRAC(N); H2AC(N)
                END IF
            NEXT ISUB
        NEXT IR
    NEXT ANO
    CLOSE #13, #14

NEXT IRodov

ARQUIVO$ = CALC$ + ARQ$ + "_Pista_" + "Interv.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #10
WRITE #10, "Trecho", "Ano", "CR", "CL", "CP", "FR+CP", "MF+CP", "FR+MF+CP", "RS", "MF+RC", "FR+RC", "FR+MF+RC", "REC"
ARQUIVO$ = CALC$ + ARQ$ + "_Acost_" + "Interv.CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #11
WRITE #11, "Trecho", "Ano", "CR", "CL", "CP", "FR+CP", "MF+CP", "FR+MF+CP", "TSS", "TSD", "PMF", "RS", "MF+RC", "FR+RC", "FR+MF+RC", "REC"

FOR IRodov = 1 TO NRODOV

    ARQUIVO$ = CALC$ + ARQ$ + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #13
    LINE INPUT #13, LINHA$

    FOR ANO = 1 TO NPer

        PCR = 0
        PCL = 0
        PCP = 0
        PFRCP = 0
        PMFCP = 0
        PFRMFCP = 0
        PRS = 0
        PMFRC = 0
        PFRRC = 0
        PFRMFRC = 0
        PREC = 0
        ACR = 0
        ACL = 0
        ACP = 0
        AFRCP = 0
        AMFCP = 0
        AFRMFCP = 0
        ATSS = 0
        ATSD = 0
        APMF = 0
        ARS = 0
        AMFRC = 0
        AFRRC = 0
        AFRMFRC = 0
        AREC = 0
        PCONT = 0
        ACONT = 0

        FOR ISUB = 1 TO NSTHRODOV(IRodov)

            INPUT #13, Y, J, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(2), HRAC(2), H2AC(2)

            FOR IFaixa = 1 TO NFaixasMax
                IF MedidaF$(IFaixa) <> "" THEN
                    PCONT = PCONT + 1
                    SELECT CASE MedidaF$(IFaixa)
                        CASE "CP", "RSUP+CP": PCP = PCP + 1
                        CASE "FR+CP": PFRCP = PFRCP + 1
                        CASE "MF+CP": PMFCP = PMFCP + 1
                        CASE "FR+MF+CP": PFRMFCP = PFRMFCP + 1
                        CASE "CR", "": PCR = PCR + 1
                        CASE "CL", "ST": PCL = PCL + 1
                        CASE "RS", "RSUP+RC": PRS = PRS + 1
                        CASE "MF+RC": PMFRC = PMFRC + 1
                        CASE "FR+RC", "RRV": PFRRC = PFRRC + 1
                        CASE "FR+MF+RC": PFRMFRC = PFRMFRC + 1
                        CASE "RRP", "RRT", "RECL": PREC = PREC + 1
                        CASE ELSE
                            PRINT "ERRO: medida nao identificada ==> "; MedidaF$(IFaixa)
                            B$ = "": WHILE B$ = "": B$ = INKEY$: WEND
                    END SELECT
                END IF
            NEXT IFaixa
            FOR IFaixa = 1 TO 2
                IF MedidaAcost$(IFaixa) <> "" THEN
                    ACONT = ACONT + 1
                    SELECT CASE MedidaAcost$(IFaixa)
                        CASE "CR", "": ACR = ACR + 1
                        CASE "CL", "ST": ACL = ACL + 1
                        CASE "CP", "RSUP+CP": ACP = ACP + 1
                        CASE "TSS": ATSS = ATSS + 1
                        CASE "TSD", "TST": ATSD = ATSD + 1
                        CASE "PMF": APMF = APMF + 1
                        CASE "CBUQ", "RS", "RSUP+RC": ARS = ARS + 1
                        CASE "RRP", "RRT", "RECL": AREC = AREC + 1
                        CASE "FR+CP": AFRCP = AFRCP + 1
                        CASE "MF+CP": AMFCP = AMFCP + 1
                        CASE "FR+MF+CP": AFRMFCP = AFRMFCP + 1
                        CASE "MF+RC": AMFRC = AMFRC + 1
                        CASE "FR+RC", "RRV": AFRRC = AFRRC + 1
                        CASE "FR+MF+RC": AFRMFRC = AFRMFRC + 1
                        CASE ELSE
                            PRINT "ERRO: Medida desconhecida no acostamento = "; MedidaAcost$(IFaixa); " na faixa "; IFaixa
                    END SELECT
                END IF
            NEXT IFaixa
        
        NEXT ISUB

        PCR = 100 * PCR / PCONT
        PCL = 100 * PCL / PCONT
        PCP = 100 * PCP / PCONT
        PFRCP = 100 * PFRCP / PCONT
        PMFCP = 100 * PMFCP / PCONT
        PFRMFCP = 100 * PFRMFCP / PCONT
        PRS = 100 * PRS / PCONT
        PMFRC = 100 * PMFRC / PCONT
        PFRRC = 100 * PFRRC / PCONT
        PFRMFRC = 100 * PFRMFRC / PCONT
        PREC = 100 * PREC / PCONT
        ACR = 100 * ACR / ACONT
        ACL = 100 * ACL / ACONT
        ACP = 100 * ACP / ACONT
        AFRCP = 100 * AFRCP / ACONT
        AMFCP = 100 * AMFCP / ACONT
        AFRMFCP = 100 * AFRMFCP / ACONT
        ATSS = 100 * ATSS / ACONT
        ATSD = 100 * ATSD / ACONT
        APMF = 100 * APMF / ACONT
        ARS = 100 * ARS / ACONT
        AMFRC = 100 * AMFRC / ACONT
        AFRRC = 100 * AFRRC / ACONT
        AFRMFRC = 100 * AFRMFRC / ACONT
        AREC = 100 * AREC / ACONT
    
        WRITE #10, Rodov$(IRodov), ANO, PCR, PCL, PCP, PFRCP, PMFCP, PFRMFCP, PRS, PMFRCP, PFRRC, PFRMFRC, PREC
        WRITE #11, Rodov$(IRodov), ANO, ACR, ACL, ACP, AFRCP, AMFCP, AFRMFCP, ATSS, ATSD, APMF, ARS, AMFRC, AFRRC, AFRMFRC, AREC

    NEXT ANO

    CLOSE #13

NEXT IRodov
CLOSE #10, #11

FOR IRodov = 1 TO NRODOV
    ARQUIVO$ = CALC$ + ARQ$ + "CT" + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #1
    LINE INPUT #1, LINHA$
    FOR IANO = 1 TO NPer
        Custo(IRodov, IANO) = 0
        FOR ISUB = 1 TO NSTHRODOV(IRodov)
            INPUT #1, ANO(IANO), JSUB, KMI, KMF, CustoSTH, CustoFaixa(1), CustoFaixa(2), CustoFaixa(3), CustoFaixa(4), CustoAcost
            Custo(IRodov, IANO) = Custo(IRodov, IANO) + CustoSTH
        NEXT ISUB
    NEXT IANO
    CLOSE #1
NEXT IRodov
  
ARQUIVO$ = CALC$ + ARQ$ + "CUSTO" + ".CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #2
WRITE #2, "ANO", "Trecho 1", "Trecho 2", "Trecho 3", "Trecho 4", "Trecho 5", "Trecho 6", "Trecho 7", "Trecho 8", "Trecho 9", "Trecho 10"
FOR IANO = 1 TO NPer
    FOR IRodov = 1 TO NRODOV
        C$(IRodov) = STR$(Custo(IRodov, IANO))
    NEXT IRodov
    WRITE #2, STR$(ANO(IANO)), C$(1), C$(2), C$(3), C$(4), C$(5), C$(6), C$(7), C$(8), C$(9), C$(10)
NEXT IANO
WRITE #2, "ANO", "Trecho 11", "Trecho 12", "Trecho 13", "Trecho 14", "Trecho 15", "Trecho 16", "Trecho 17", "Trecho 18", "Trecho 19", "Trecho 20"
FOR IANO = 1 TO NPer
    FOR IRodov = 1 TO NRODOV
        C$(IRodov) = STR$(Custo(IRodov, IANO))
    NEXT IRodov
    WRITE #2, STR$(ANO(IANO)), C$(11), C$(12), C$(13), C$(14), C$(15), C$(16), C$(17), C$(18), C$(19), C$(20)
NEXT IANO
WRITE #2, "ANO", "Trecho 21", "Trecho 22", "Trecho 23", "Trecho 24", "Trecho 25", "Trecho 26", "Trecho 27", "Trecho 28", "Trecho 29", "Trecho 30"
FOR IANO = 1 TO NPer
    FOR IRodov = 1 TO NRODOV
        C$(IRodov) = STR$(Custo(IRodov, IANO))
    NEXT IRodov
    WRITE #2, STR$(ANO(IANO)), C$(21), C$(22), C$(23), C$(24), C$(25), C$(26), C$(27), C$(28), C$(29), C$(30)
NEXT IANO
WRITE #2, "ANO", "Trecho 31", "Trecho 32", "Trecho 33", "Trecho 34", "Trecho 35", "Trecho 36", "Trecho 37", "Trecho 38", "Trecho 39", "Trecho 40"
FOR IANO = 1 TO NPer
    FOR IRodov = 1 TO NRODOV
        C$(IRodov) = STR$(Custo(IRodov, IANO))
    NEXT IRodov
    WRITE #2, STR$(ANO(IANO)), C$(31), C$(32), C$(33), C$(34), C$(35), C$(36), C$(37), C$(38), C$(39), C$(40)
NEXT IANO
WRITE #2, "ANO", "Trecho 41", "Trecho 42", "Trecho 43", "Trecho 44", "Trecho 45", "Trecho 46", "Trecho 47", "Trecho 48", "Trecho 49", "Trecho 50"
FOR IANO = 1 TO NPer
    FOR IRodov = 1 TO NRODOV
        C$(IRodov) = STR$(Custo(IRodov, IANO))
    NEXT IRodov
    WRITE #2, STR$(ANO(IANO)), C$(41), C$(42), C$(43), C$(44), C$(45), C$(46), C$(47), C$(48), C$(49), C$(50)
NEXT IANO
WRITE #2, "ANO", "Trecho 51", "Trecho 52", "Trecho 53", "Trecho 54", "Trecho 55", "Trecho 56", "Trecho 57", "Trecho 58", "Trecho 59", "Trecho 60"
FOR IANO = 1 TO NPer
    FOR IRodov = 1 TO NRODOV
        C$(IRodov) = STR$(Custo(IRodov, IANO))
    NEXT IRodov
    WRITE #2, STR$(ANO(IANO)), C$(51), C$(52), C$(53), C$(54), C$(55), C$(56), C$(57), C$(58), C$(59), C$(60)
NEXT IANO
CLOSE #2

' - - - - - - - - - - - - - - - - - - - - - - -
' -  Quantitativos dos Servicos de Manutencao -
' - - - - - - - - - - - - - - - - - - - - - - -
DIM AreaCP(NPer), AreaST(NPer), ExtkmFaixaCR(NPer), AreaCL(NPer), CBUQm3(NPer)
DIM Pinturam2(NPer), Reperfm2(NPer), Fresagemm3(NPer), Remocaom3(NPer), BGm3(NPer)
DIM CLacostm2(NPer), TSSacostm2(NPer), TSDacostm2(NPer), PMFacostm3(NPer)
DIM PinturaAcostm2(NPer), RemAcostm3(NPer), BaseAcostm3(NPer), CBUQacostm3(NPer)
DIM FresagAcm3(NPer), ClasseInterv(NPer, NClasses)

FOR ANO = 1 TO NPer
    AreaCP(ANO) = 0
    AreaST(ANO) = 0
    ExtkmFaixaCR(ANO) = 0
    AreaCL(ANO) = 0
    CBUQm3(ANO) = 0
    Pinturam2(ANO) = 0
    Reperfm2(ANO) = 0
    Fresagemm3(ANO) = 0
    Remocaom3(ANO) = 0
    BGm3(ANO) = 0
    CLacostm2(ANO) = 0
    TSSacostm2(ANO) = 0
    TSDacostm2(ANO) = 0
    PMFacostm3(ANO) = 0
    CBUQacostm3(ANO) = 0
    PinturaAcostm2(ANO) = 0
    RemAcostm3(ANO) = 0
    BaseAcostm3(ANO) = 0
    CBUQacostm3(ANO) = 0
    FresagAcm3(ANO) = 0
    FOR IC = 1 TO NClasses
        ClasseInterv(ANO, IC) = 0
    NEXT IC
NEXT ANO

JSTH = 0
FOR IRodov = 1 TO NRODOV

    FOR ANO = 1 TO NPeriodos
        ' Pista
        kmCA(IRodov, ANO) = 0
        kmMF(IRodov, ANO) = 0
        kmCP(IRodov, ANO) = 0
        kmFR(IRodov, ANO) = 0
        kmBG(IRodov, ANO) = 0
        kmRE(IRodov, ANO) = 0
        kmRP(IRodov, ANO) = 0
        kmPT(IRodov, ANO) = 0
        ' Acostamentos
        kmPMF(IRodov, ANO) = 0
        kmTSS(IRodov, ANO) = 0
        kmTSD(IRodov, ANO) = 0
        kmBASE(IRodov, ANO) = 0
        kmREM(IRodov, ANO) = 0
        kmREP(IRodov, ANO) = 0
        kmPi(IRodov, ANO) = 0
    NEXT ANO

    ' Parametros que definem as Arvores de Decisao:
    ARQUIVO$ = CALC$ + "ARV" + Rodov$(IRodov) + ".dat"
    OPEN ARQUIVO$ FOR INPUT AS #1
    INPUT #1, IDScrit
    INPUT #1, PSRcrit
    INPUT #1, HRmin
    INPUT #1, HRmax
    INPUT #1, PSIf
    INPUT #1, DEGRAUadm
    INPUT #1, HCmin
    INPUT #1, HCMAXgeral
    INPUT #1, VUMin
    INPUT #1, QI0adm
    INPUT #1, HbaseAcost
    INPUT #1, RepFres
    INPUT #1, TipoRevAcost$
    INPUT #1, SART$
    CLOSE #1
    SELECT CASE SART$
        CASE "MF3"
            HRMF = 3
        CASE "MF4"
            HRMF = 4
        CASE ELSE
            HRMF = 2
    END SELECT

    IF GeraDet$ = "S" THEN
        PRINT
        PRINT "Gera os quantitativos detalhados por trecho e ano"
        ARQUIVO$ = CALC$ + ARQ$ + Rodov$(IRodov) + "PT.csv"
        OPEN ARQUIVO$ FOR OUTPUT AS #15
        WRITE #15, "Ano", "AreaCPm2", "AreaSTm2", "ExtkmCR", "AreaCLm2", "CBUQm3", "PtLig m2", "Reperfm2", "Fresagm3", "Remoc.m3", "BGm3"
        ARQUIVO$ = CALC$ + ARQ$ + Rodov$(IRodov) + "AC.csv"
        OPEN ARQUIVO$ FOR OUTPUT AS #16
        WRITE #16, "Ano", "CL m2", "TSS m2", "TSD m2", "PMF m3", "CBUQ m3", "PtLig m2", "Remoc.m3", "Base m3", "Fresagem m3"
        CLOSE #15, #16
    END IF
    PRINT

    ARQUIVO$ = CALC$ + ARQ$ + Rodov$(IRodov) + ".CSV"
    OPEN ARQUIVO$ FOR INPUT AS #13
    LINE INPUT #13, LINHA$

    FOR ANO = 1 TO NPer

        PRINT Rodov$(IRodov), ANO

        AreaCPTR = 0
        AreaSTTR = 0
        ExtkmFxCRTR = 0
        AreaCLTR = 0
        CBUQm3TR = 0
        Ptm2TR = 0
        Repm2TR = 0
        Fresm3TR = 0
        Remocm3TR = 0
        BGm3TR = 0
        CLacm2TR = 0
        TSSacm2TR = 0
        TSDacm2TR = 0
        PMFacm3TR = 0
        CBUQacm3TR = 0
        PtAcm2TR = 0
        RemAcm3TR = 0
        BaseAcm3TR = 0
        CPacostm2 = 0
        CBUQacost = 0
        FresagAcTR = 0

        ANOcal = ANOBASE + ANO
        ARQUIVO$ = CALC$ + ARQ$ + STR$(ANO) + ".DAT"
        OPEN ARQUIVO$ FOR INPUT AS #12
        ISTH = 0
        FOR IR = 1 TO NRODOV
            FOR ISUB = 1 TO NSTHRODOV(IR)
                ISTH = ISTH + 1
                INPUT #12, Subtrecho, KMI, KMF
                FOR IFaixa = 1 TO NFaixas(ISTH)
                    INPUT #12, STH, IFX, PSIat(ISTH, IFX), Aream2(ISTH, IFX), VidaRes, Restaurado$, UltCamada$, VDMUni, PSInovo, HRef, Heff, IRec, ICalib, D0, MRfound
                    INPUT #12, H1REV, HrecExist, Idade, SN, QImed, Nano(ISTH, IFX), IRI0, Nacum, ALFAIGG, ATRmed
                    INPUT #12, ALPHA0, ALPHA, ALPHA2, AreaAcost(ISTH, IFX), PSIacost(ISTH, IFX), DegrauAcost, T0, TR23(ISTH, IFX), CBRSL, CamBase$, VDMc
                NEXT IFaixa
            NEXT ISUB
        NEXT IR
        INPUT #12, PSImed(0), Npsi(0), VRmed(0)
        INPUT #12, AreaTotal, NUnidAnalise
        CLOSE #12

        FOR ISUB = 1 TO NSTHRODOV(IRodov)

            IF ANO = 1 THEN
                JSTH = JSTH + 1
                STH(ISUB) = JSTH
            END IF
            ISTH = STH(ISUB)
            INPUT #13, Year, J, KMI, KMF, MedidaAcost$(1), HRAC(1), H2AC(1), MedidaF$(1), Hfres(1), Hrec(1), MedidaF$(2), Hfres(2), Hrec(2), MedidaF$(3), Hfres(3), Hrec(3), MedidaF$(4), Hfres(4), Hrec(4), MedidaAcost$(2), HRAC(2), H2AC(2)

            Extkm = ABS(KMF - KMI)

            FOR IFaixa = 1 TO NFaixas(ISTH)

                Medida$ = MedidaF$(IFaixa)
                HC = Hfres(IFaixa)
                HR = Hrec(IFaixa)
                PSI = PSIat(ISTH, IFaixa)

                SELECT CASE Medida$
                    CASE "RS", "CP"
                        IF RepFres < 0 THEN
                            IF TR23(ISTH, IFaixa) < 50 THEN
                                RepPerct = TR23(ISTH, IFaixa)
                            ELSE
                                RepPerct = 20
                            END IF
                        ELSE
                            RepPerct = RepFres
                        END IF
                        IF Nano(ISTH, IFaixa) < 500000! THEN
                            HCrepFres = 3
                        ELSE
                            IF Nano(ISTH, IFaixa) < 1000000! THEN
                                HCrepFres = 4
                            ELSE
                                HCrepFres = 5
                            END IF
                        END IF
                    CASE "RSUP+RC", "RSUP+CP"
                        RepPerct = 20
                        IF Nano(ISTH, IFaixa) < 500000! THEN
                            HCrepFres = 3
                        ELSE
                            IF Nano(ISTH, IFaixa) < 1000000! THEN
                                HCrepFres = 4
                            ELSE
                                HCrepFres = 5
                            END IF
                        END IF
                    CASE ELSE
                END SELECT

                SELECT CASE Medida$

                    CASE "RL", "CL"
                        kmRP(IRodov, ANO) = kmRP(IRodov, ANO) + Extkm
                        I1 = 0
                        FOR ICL = 1 TO (NitensCL - 1)
                            IF (PSI <= PSIitemCL(ICL) AND PSI > PSIitemCL(ICL + 1)) THEN
                                I1 = ICL
                                I2 = ICL + 1
                            END IF
                        NEXT ICL
                        IF PSI <= PSIitemCL(NitensCL) THEN
                            I1 = NitensCL - 1
                            I2 = NitensCL
                        END IF
                        IF I1 = 0 THEN
                            PerctReparos = 0
                        ELSE
                            Y1 = ARepCL(I1)
                            Y2 = ARepCL(I2)
                            X1 = PSIitemCL(I1)
                            X2 = PSIitemCL(I2)
                            PerctReparos = ((X2 * Y1 - X1 * Y2) / (X2 - X1)) + ((Y2 - Y1) * PSI / (X2 - X1))
                        END IF
                        IF PerctReparos > ARepCL(NitensCL) THEN PerctReparos = ARepCL(NitensCL)
                        AreaCL(ANO) = AreaCL(ANO) + Aream2(ISTH, IFaixa) * PerctReparos / 100
                        AreaCLTR = AreaCLTR + Aream2(ISTH, IFaixa) * PerctReparos / 100
                    CASE "ST"
                        I1 = 0
                        FOR ICL = 1 TO (NitensCL - 1)
                            IF (PSI <= PSIitemCL(ICL) AND PSI > PSIitemCL(ICL + 1)) THEN
                                I1 = ICL
                                I2 = ICL + 1
                            END IF
                        NEXT ICL
                        IF PSI <= PSIitemCL(NitensCL) THEN
                            I1 = NitensCL - 1
                            I2 = NitensCL
                        END IF
                        IF I1 = 0 THEN
                            PerctReparos = 0
                        ELSE
                            Y1 = ARepCL(I1)
                            Y2 = ARepCL(I2)
                            X1 = PSIitemCL(I1)
                            X2 = PSIitemCL(I2)
                            PerctReparos = ((X2 * Y1 - X1 * Y2) / (X2 - X1)) + ((Y2 - Y1) * PSI / (X2 - X1))
                        END IF
                        PerctReparos = .1 * PerctReparos
                        IF PerctReparos > 1! THEN PerctReparos = 1!
                        AreaST(ANO) = AreaST(ANO) + Aream2(ISTH, IFaixa) * PerctReparos / 100
                        AreaSTTR = AreaSTTR + Aream2(ISTH, IFaixa) * PerctReparos / 100
                    CASE "FR+CP"
                        kmFR(IRodov, ANO) = kmFR(IRodov, ANO) + Extkm
                        kmCP(IRodov, ANO) = kmCP(IRodov, ANO) + Extkm
                        Ncortes = 1
                        Ncamadas = 1
                        Fresagemm3(ANO) = Fresagemm3(ANO) + (HC / 100) * Aream2(ISTH, IFaixa)
                        Fresm3TR = Fresm3TR + (HC / 100) * Aream2(ISTH, IFaixa)
                        AreaCP(ANO) = AreaCP(ANO) + Aream2(ISTH, IFaixa)
                        AreaCPTR = AreaCPTR + Aream2(ISTH, IFaixa)
                    CASE "CP", "RSUP+CP"
                        AreaCP(ANO) = AreaCP(ANO) + Aream2(ISTH, IFaixa)
                        kmCP(IRodov, ANO) = kmCP(IRodov, ANO) + Extkm
                        AreaCPTR = AreaCPTR + Aream2(ISTH, IFaixa)
                        ' Reparos preliminares executados com fresadora
                        Ncortes = 1
                        Ncamadas = 1
                        Fresagemm3(ANO) = Fresagemm3(ANO) + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        Fresm3TR = Fresm3TR + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        CBUQm3(ANO) = CBUQm3(ANO) + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        CBUQm3TR = CBUQm3TR + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        Pinturam2(ANO) = Pinturam2(ANO) + Ncamadas * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        Ptm2TR = Ptm2TR + Ncamadas * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                    CASE "MF+CP", "FR+MF+CP"
                        kmCP(IRodov, ANO) = kmCP(IRodov, ANO) + Extkm
                        kmMF(IRodov, ANO) = kmMF(IRodov, ANO) + Extkm
                        AreaCP(ANO) = AreaCP(ANO) + Aream2(ISTH, IFaixa)
                        AreaCPTR = AreaCPTR + Aream2(ISTH, IFaixa)
                        Pinturam2(ANO) = Pinturam2(ANO) + Aream2(ISTH, IFaixa)
                        Ptm2TR = Ptm2TR + Aream2(ISTH, IFaixa)
                        Reperfm2(ANO) = Reperfm2(ANO) + Aream2(ISTH, IFaixa)
                        Repm2TR = Repm2TR + Aream2(ISTH, IFaixa)
                        kmPT(IRodov, ANO) = kmPT(IRodov, ANO) + Extkm
                        kmFR(IRodov, ANO) = kmFR(IRodov, ANO) + Extkm
                        Ncortes = 1
                        Ncamadas = 1
                        Fresagemm3(ANO) = Fresagemm3(ANO) + (HC / 100) * Aream2(ISTH, IFaixa)
                        Fresm3TR = Fresm3TR + (HC / 100) * Aream2(ISTH, IFaixa)
                    CASE "CR"
                        ExtkmFaixaCR(ANO) = ExtkmFaixaCR(ANO) + ABS(KMF - KMI)
                        ExtkmFxCRTR = ExtkmFxCRTR + ABS(KMF - KMI)
                    CASE "RS", "RSUP+RC"
                        kmPT(IRodov, ANO) = kmPT(IRodov, ANO) + Extkm
                        kmCA(IRodov, ANO) = kmCA(IRodov, ANO) + Extkm
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        CBUQm3(ANO) = CBUQm3(ANO) + (HR / 100) * Aream2(ISTH, IFaixa)
                        CBUQm3TR = CBUQm3TR + (HR / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2(ANO) = Pinturam2(ANO) + Ncamadas * Aream2(ISTH, IFaixa)
                        Ptm2TR = Ptm2TR + Ncamadas * Aream2(ISTH, IFaixa)
                        ' Reparos preliminares executados com fresadora
                        Ncortes = 1
                        Ncamadas = 1
                        Fresagemm3(ANO) = Fresagemm3(ANO) + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        Fresm3TR = Fresm3TR + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        CBUQm3(ANO) = CBUQm3(ANO) + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        CBUQm3TR = CBUQm3TR + (HCrepFres / 100) * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        Pinturam2(ANO) = Pinturam2(ANO) + Ncamadas * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                        Ptm2TR = Ptm2TR + Ncamadas * Aream2(ISTH, IFaixa) * (RepPerct / 100)
                    CASE "MF+RC", "FR+MF+RC"
                        kmPT(IRodov, ANO) = kmPT(IRodov, ANO) + Extkm
                        kmMF(IRodov, ANO) = kmMF(IRodov, ANO) + Extkm
                        kmCA(IRodov, ANO) = kmCA(IRodov, ANO) + Extkm
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        CBUQm3(ANO) = CBUQm3(ANO) + (HR / 100) * Aream2(ISTH, IFaixa)
                        CBUQm3TR = CBUQm3TR + (HR / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2(ANO) = Pinturam2(ANO) + (Ncamadas + 1) * Aream2(ISTH, IFaixa)
                        Ptm2TR = Ptm2TR + (Ncamadas + 1) * Aream2(ISTH, IFaixa)
                        Reperfm2(ANO) = Reperfm2(ANO) + Aream2(ISTH, IFaixa)
                        Repm2TR = Repm2TR + Aream2(ISTH, IFaixa)
                        kmFR(IRodov, ANO) = kmFR(IRodov, ANO) + Extkm
                        IF HC <= 7! THEN
                            Ncortes = 1
                        ELSE
                            IF HC <= 14! THEN
                                Ncortes = 2
                            ELSE
                                Ncortes = 3
                            END IF
                        END IF
                        Fresagemm3(ANO) = Fresagemm3(ANO) + (HC / 100) * Aream2(ISTH, IFaixa)
                        Fresm3TR = Fresm3TR + (HC / 100) * Aream2(ISTH, IFaixa)
                    CASE "FR+RC", "RRV"
                        kmPT(IRodov, ANO) = kmPT(IRodov, ANO) + Extkm
                        kmFR(IRodov, ANO) = kmFR(IRodov, ANO) + Extkm
                        kmCA(IRodov, ANO) = kmCA(IRodov, ANO) + Extkm
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        IF HC <= 7! THEN
                            Ncortes = 1
                        ELSE
                            IF HC <= 14! THEN
                                Ncortes = 2
                            ELSE
                                Ncortes = 3
                            END IF
                        END IF
                        CBUQm3(ANO) = CBUQm3(ANO) + (HR / 100) * Aream2(ISTH, IFaixa)
                        CBUQm3TR = CBUQm3TR + (HR / 100) * Aream2(ISTH, IFaixa)
                        Fresagemm3(ANO) = Fresagemm3(ANO) + (HC / 100) * Aream2(ISTH, IFaixa)
                        Fresm3TR = Fresm3TR + (HC / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2(ANO) = Pinturam2(ANO) + Ncamadas * Aream2(ISTH, IFaixa)
                        Ptm2TR = Ptm2TR + Ncamadas * Aream2(ISTH, IFaixa)
                    CASE "RRP"
                        kmPT(IRodov, ANO) = kmPT(IRodov, ANO) + Extkm
                        kmRE(IRodov, ANO) = kmRE(IRodov, ANO) + Extkm
                        kmBG(IRodov, ANO) = kmBG(IRodov, ANO) + Extkm
                        kmCA(IRodov, ANO) = kmCA(IRodov, ANO) + Extkm
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        H2CM = HC - HR
                        Remocaom3(ANO) = Remocaom3(ANO) + (HC / 100) * Aream2(ISTH, IFaixa)
                        Remocm3TR = Remocm3TR + (HC / 100) * Aream2(ISTH, IFaixa)
                        CBUQm3(ANO) = CBUQm3(ANO) + (HR / 100) * Aream2(ISTH, IFaixa)
                        CBUQm3TR = CBUQm3TR + (HR / 100) * Aream2(ISTH, IFaixa)
                        BGm3(ANO) = BGm3(ANO) + (H2CM / 100) * Aream2(ISTH, IFaixa)
                        BGm3TR = BGm3TR + (H2CM / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2(ANO) = Pinturam2(ANO) + Ncamadas * Aream2(ISTH, IFaixa)
                        Ptm2TR = Ptm2TR + Ncamadas * Aream2(ISTH, IFaixa)
                    CASE "RRT"
                        kmPT(IRodov, ANO) = kmPT(IRodov, ANO) + Extkm
                        kmRE(IRodov, ANO) = kmRE(IRodov, ANO) + Extkm
                        kmBG(IRodov, ANO) = kmBG(IRodov, ANO) + Extkm
                        kmCA(IRodov, ANO) = kmCA(IRodov, ANO) + Extkm
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        H2CM = HC - HR - 20
                        Remocaom3(ANO) = Remocaom3(ANO) + (HC / 100) * Aream2(ISTH, IFaixa)
                        Remocm3TR = Remocm3TR + (HC / 100) * Aream2(ISTH, IFaixa)
                        CBUQm3(ANO) = CBUQm3(ANO) + (HR / 100) * Aream2(ISTH, IFaixa)
                        CBUQm3TR = CBUQm3TR + (HR / 100) * Aream2(ISTH, IFaixa)
                        BGm3(ANO) = BGm3(ANO) + (H2CM / 100) * Aream2(ISTH, IFaixa)
                        BGm3TR = BGm3TR + (H2CM / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2(ANO) = Pinturam2(ANO) + Ncamadas * Aream2(ISTH, IFaixa)
                        Ptm2TR = Ptm2TR + Ncamadas * Aream2(ISTH, IFaixa)
                    CASE "RECL"
                        kmPT(IRodov, ANO) = kmPT(IRodov, ANO) + Extkm
                        kmRE(IRodov, ANO) = kmRE(IRodov, ANO) + Extkm
                        kmBG(IRodov, ANO) = kmBG(IRodov, ANO) + Extkm
                        kmCA(IRodov, ANO) = kmCA(IRodov, ANO) + Extkm
                        IF HR <= 7.5 THEN
                            Ncamadas = 1
                        ELSE
                            IF HR <= 14! THEN
                                Ncamadas = 2
                            ELSE
                                Ncamadas = 3
                            END IF
                        END IF
                        H2CM = HC
                        CBUQm3(ANO) = CBUQm3(ANO) + (HR / 100) * Aream2(ISTH, IFaixa)
                        CBUQm3TR = CBUQm3TR + (HR / 100) * Aream2(ISTH, IFaixa)
                        BGm3(ANO) = BGm3(ANO) + (H2CM / 100) * Aream2(ISTH, IFaixa)
                        BGm3TR = BGm3TR + (H2CM / 100) * Aream2(ISTH, IFaixa)
                        Pinturam2(ANO) = Pinturam2(ANO) + Ncamadas * Aream2(ISTH, IFaixa)
                        Ptm2TR = Ptm2TR + Ncamadas * Aream2(ISTH, IFaixa)
                    CASE ELSE
                        PRINT "ERRO: medida nao identificada."
                        PRINT Medida$
                END SELECT

                I = 0
                SELECT CASE Medida$
                    CASE "FR+RC", "FR+MF+RC"
                        IF HC <= 3 THEN
                            I = 4
                            IF HR = 10 THEN I = 1
                            IF HR = 11 THEN I = 2
                            IF HR = 12 THEN I = 3
                            IF HR = 6 THEN I = 5
                            IF (HR > 6 AND HR <= 8) THEN I = 6
                            IF HR = 9 THEN I = 7
                        ELSE
                            IF HC = 4.5 THEN
                                I = 8
                            ELSE
                                IF HC = 4 THEN
                                    I = 11
                                    IF HR = 10 THEN I = 9
                                    IF HR = 11 THEN I = 10
                                    IF HR = 5 THEN I = 11
                                    IF HR = 7 THEN I = 13
                                    IF HR = 8 THEN I = 14
                                ELSE
                                    IF HC = 5 THEN
                                        I = 15
                                        IF HR = 6 THEN I = 16
                                        IF HR = 8 THEN I = 17
                                        IF HR = 9 THEN I = 18
                                    ELSE
                                        IF HC = 6 THEN
                                            IF HR = 7 THEN I = 20 ELSE I = 19
                                        ELSE
                                            IF HC = 7 THEN
                                                I = 22
                                                IF HR = 10 THEN I = 21
                                                IF HR = 8 THEN I = 23
                                            ELSE
                                                I = 24
                                                IF HC <> 8 THEN I = 25
                                            END IF
                                        END IF
                                    END IF
                                END IF
                            END IF
                        END IF
                    CASE "RS", "RSUP+RC"
                        IF HR >= 10 THEN
                            I = 26
                        ELSE
                            IF HR <= 3.5 THEN
                                I = 27
                            ELSE
                                IF HR <= 4.5 THEN
                                    I = 28
                                ELSE
                                    IF HR <= 5.5 THEN
                                        I = 29
                                    ELSE
                                        IF HR <= 6.5 THEN
                                            I = 30
                                        ELSE
                                            IF HR <= 7.5 THEN
                                                I = 31
                                            ELSE
                                                IF HR <= 8.5 THEN
                                                    I = 32
                                                ELSE
                                                    I = 33
                                                END IF
                                            END IF
                                        END IF
                                    END IF
                                END IF
                            END IF
                        END IF
                    CASE "CP", "MF+CP", "FR+MF+CP", "RSUP+CP"
                        IF HR < .5 THEN
                            I = 35
                        ELSE
                            IF HR >= 2! THEN
                                I = 36
                            ELSE
                                IF HR >= 1.7 THEN
                                    I = 37
                                ELSE
                                    I = 34
                                END IF
                            END IF
                        END IF
                    CASE "CL"
                        I = 38
                    CASE ELSE
                        I = 39
                END SELECT
                IF I <> 38 THEN
                    ClasseInterv(ANO, I) = ClasseInterv(ANO, I) + Aream2(ISTH, IFaixa)
                ELSE
                    ClasseInterv(ANO, I) = ClasseInterv(ANO, I) + Aream2(ISTH, IFaixa) * PerctReparos / 100
                END IF

                IF (IFaixa = 1 OR IFaixa = NFaixas(ISTH)) THEN
                    IF IFaixa = 1 THEN Iacost = 1 ELSE Iacost = 2
                    Medida$ = MedidaAcost$(Iacost)
                    HR = HRAC(Iacost)
                    HC = H2AC(Iacost)
                    Area = AreaAcost(ISTH, IFaixa)

                    SELECT CASE Medida$
                        CASE "", "CR"
                        CASE "CL", "ST"
                            kmREP(IRodov, ANO) = kmREP(IRodov, ANO) + Extkm
                            IF PSIacost(ISTH, IFaixa) > 0 THEN PerctReparos = 100 * EXP(-2.3026 * PSIacost(ISTH, IFaixa)) ELSE PerctReparos = 0
                            CLacostm2(ANO) = CLacostm2(ANO) + Area * PerctReparos / 100
                            CLacm2TR = CLacm2TR + Area * PerctReparos / 100
                        CASE "CP", "FR+CP", "MF+CP", "FR+MF+CP", "RSUP+CP"
                            AreaCP(ANO) = AreaCP(ANO) + Aream2(ISTH, IFaixa)
                            AreaCPTR = AreaCPTR + Aream2(ISTH, IFaixa)
                            FresagAcm3(ANO) = FresagAcm3(ANO) + Aream2(ISTH, IFaixa) * HC / 100
                            FresagAcTR = FresagAcTR + Aream2(ISTH, IFaixa) * HC / 100
                        CASE "TSS"
                            kmTSS(IRodov, ANO) = kmTSS(IRodov, ANO) + Extkm
                            TSSacostm2(ANO) = TSSacostm2(ANO) + Area
                            TSSacm2TR = TSSacm2TR + Area
                        CASE "TSD"
                            kmTSD(IRodov, ANO) = kmTSD(IRodov, ANO) + Extkm
                            TSDacostm2(ANO) = TSDacostm2(ANO) + Area
                            TSDacm2TR = TSDacm2TR + Area
                        CASE "PMF"
                            kmPMF(IRodov, ANO) = kmPMF(IRodov, ANO) + Extkm
                            kmPi(IRodov, ANO) = kmPi(IRodov, ANO) + Extkm
                            PMFacostm3(ANO) = PMFacostm3(ANO) + (HR / 100) * Area
                            PMFacm3TR = PMFacm3TR + (HR / 100) * Area
                            PinturaAcostm2(ANO) = PinturaAcostm2(ANO) + Area
                            PtAcm2TR = PtAcm2TR + Area
                        CASE "CBUQ", "RS", "RSUP+RC", "MF+RC"
                            CBUQacostm3(ANO) = CBUQacostm3(ANO) + (HR / 100) * Area
                            CBUQacm3TR = CBUQacm3TR + (HR / 100) * Area
                            PinturaAcostm2(ANO) = PinturaAcostm2(ANO) + Area
                            PtAcm2TR = PtAcm2TR + Area
                        CASE "FR+RC", "RRV", "FR+MF+RC"
                            kmPi(IRodov, ANO) = kmPi(IRodov, ANO) + Extkm
                            IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN
                                TSDacostm2(ANO) = TSDacostm2(ANO) + Area
                            ELSE
                                CBUQacostm3(ANO) = CBUQacostm3(ANO) + (HR / 100) * Area
                                CBUQacm3TR = CBUQacm3TR + (HR / 100) * Area
                                PinturaAcostm2(ANO) = PinturaAcostm2(ANO) + Area
                                PtAcm2TR = PtAcm2TR + Area
                            END IF
                            FresagAcm3(ANO) = FresagAcm3(ANO) + Aream2(ISTH, IFaixa) * HC / 100
                            FresagAcTR = FresagAcTR + Aream2(ISTH, IFaixa) * HC / 100
                        CASE "RRP", "RRT", "RECL"
                            kmPi(IRodov, ANO) = kmPi(IRodov, ANO) + Extkm
                            kmREM(IRodov, ANO) = kmREM(IRodov, ANO) + Extkm
                            kmBASE(IRodov, ANO) = kmBASE(IRodov, ANO) + Extkm
                            RemAcostm3(ANO) = RemAcostm3(ANO) + Area * HC / 100
                            RemAcm3TR = RemAcm3TR + Area * HC / 100
                            IF TipoRevAcost$ = "Tratamento superficial e PMF" THEN
                                TSDacostm2(ANO) = TSDacostm2(ANO) + Area
                            ELSE
                                CBUQacostm3(ANO) = CBUQacostm3(ANO) + (HR / 100) * Area
                                CBUQacm3TR = CBUQacm3TR + (HR / 100) * Area
                                PinturaAcostm2(ANO) = PinturaAcostm2(ANO) + Area
                                PtAcm2TR = PtAcm2TR + Area
                            END IF
                            BaseAcostm3(ANO) = BaseAcostm3(ANO) + Area * HC / 100
                            BaseAcm3TR = BaseAcm3TR + Area * HC / 100
                        CASE ELSE
                            PRINT "ERRO: Medida desconhecida = "; Medida$
                    END SELECT
                END IF
            NEXT IFaixa

        NEXT ISUB

        IF ARQ$ = "NAT" THEN Year = ANOBASE ELSE Year = ANO + ANOBASE
        AreaCP& = INT(AreaCPTR)
        AreaST& = INT(AreaSTTR)
        ExtCR& = INT(ExtkmFxCRTR)
        AreaCL& = INT(AreaCLTR)
        CBUQm3& = INT(CBUQm3TR)
        Pintm2& = INT(Ptm2TR)
        Repm2& = INT(Repm2TR)
        Fresm3& = INT(Fresm3TR)
        Remm3& = INT(Remocm3TR)
        BGm3& = INT(BGm3TR)
        CLacm2& = INT(CLacm2TR)
        TSSacm2& = INT(TSSacm2TR)
        TSDacm2& = INT(TSDacm2TR)
        PMFacm3& = INT(PMFacm3TR)
        PintAcm2& = INT(PtAcm2TR)
        RemAcm3& = INT(RemAcm3TR)
        BaseAcm3& = INT(BaseAcm3TR)
        CBUQacm3& = INT(CBUQacm3TR)
        FresagAcTRm3& = INT(FresagAcTR)

        IF GeraDet$ = "S" THEN
            ARQUIVO$ = CALC$ + ARQ$ + Rodov$(IRodov) + "PT.csv"
            OPEN ARQUIVO$ FOR APPEND AS #15
            ARQUIVO$ = CALC$ + ARQ$ + Rodov$(IRodov) + "AC.csv"
            OPEN ARQUIVO$ FOR APPEND AS #16
            WRITE #15, Year, AreaCP&, AreaST&, ExtCR&, AreaCL&, CBUQm3&, Pintm2&, Repm2&, Fresm3&, Remm3&, BGm3&
            WRITE #16, Year, CLacm2&, TSSacm2&, TSDacm2&, PMFacm3&, CBUQacm3&, PintAcm2&, RemAcm3&, BaseAcm3&, FresagAcTRm3&
            CLOSE #15, #16
        END IF

    NEXT ANO
    CLOSE #13

NEXT IRodov

IF ARQ$ = "EVO" THEN GOTO 10

ARQUIVO$ = CALC$ + ARQ$ + "Pista.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #15
WRITE #15, "Ano", "AreaCPm2", "AreaSTm2", "ExtkmCR", "AreaCLm2", "CBUQm3", "PtLig m2", "Reperfm2", "Fresagm3", "Remoc.m3", "BGm3"

ARQUIVO$ = CALC$ + ARQ$ + "Acost.csv"
OPEN ARQUIVO$ FOR OUTPUT AS #16
WRITE #16, "Ano", "CL m2", "TSS m2", "TSD m2", "PMF m3", "CBUQ m3", "PtLig m2", "Remoc.m3", "Base m3", "Fresagem m3"
   
FOR ANO = 1 TO NPer
    IF ARQ$ = "NAT" THEN Year = ANOBASE ELSE Year = ANO + ANOBASE
    AreaCP& = INT(AreaCP(ANO))
    AreaST& = INT(AreaST(ANO))
    ExtCR& = INT(ExtkmFaixaCR(ANO))
    AreaCL& = INT(AreaCL(ANO))
    CBUQm3& = INT(CBUQm3(ANO))
    Pintm2& = INT(Pinturam2(ANO))
    Repm2& = INT(Reperfm2(ANO))
    Fresm3& = INT(Fresagemm3(ANO))
    Remm3& = INT(Remocaom3(ANO))
    BGm3& = INT(BGm3(ANO))
    CLacm2& = INT(CLacostm2(ANO))
    TSSacm2& = INT(TSSacostm2(ANO))
    TSDacm2& = INT(TSDacostm2(ANO))
    PMFacm3& = INT(PMFacostm3(ANO))
    PintAcm2& = INT(PinturaAcostm2(ANO))
    RemAcm3& = INT(RemAcostm3(ANO))
    BaseAcm3& = INT(BaseAcostm3(ANO))
    CBUQacm3& = INT(CBUQacostm3(ANO))
    FresagemAc& = INT(FresagAcm3(ANO))

    temp$ = "&, #########.#, #########.#, #########.#, #########.#, #########.#, #########.#, #########.#, #########.#, #########.#, #########.#"
    PRINT #15, USING temp$; STR$(Year); AreaCP&; AreaST&; ExtCR&; AreaCL&; CBUQm3&; Pintm2&; Repm2&; Fresm3&; Remm3&; BGm3&
    temp$ = "&, #########.#, #########.#, #########.#, #########.#, #########.#, #########.#, #########.#, #########.#, #########.#"
    PRINT #16, USING temp$; STR$(Year); CLacm2&; TSSacm2&; TSDacm2&; PMFacm3&; CBUQacm3&; PintAcm2&; RemAcm3&; BaseAcm3&; FresagemAc&

    IF GeraDet$ = "S" THEN
        ARQUIVO$ = CALC$ + "Class" + STR$(ANO) + ".CSV"
        OPEN ARQUIVO$ FOR OUTPUT AS #3
        WRITE #3, "Classe de Intervencao", "Area (m2)"
        FOR I = 1 TO NClasses
            SELECT CASE I
                CASE 1: Tipo$ = "Fresagem(3cm)+Recapeamento(10cm)"
                CASE 2: Tipo$ = "Fresagem(3cm)+Recapeamento(11cm)"
                CASE 3: Tipo$ = "Fresagem(3cm)+Recapeamento(12cm)"
                CASE 4: Tipo$ = "Fresagem(3cm)+Recapeamento(3cm)"
                CASE 5: Tipo$ = "Fresagem(3cm)+Recapeamento(6cm)"
                CASE 6: Tipo$ = "Fresagem(3cm)+Recapeamento(8cm)"
                CASE 7: Tipo$ = "Fresagem(3cm)+Recapeamento(9cm)"
                CASE 8: Tipo$ = "Fresagem(4,5cm)+Recapeamento(7,5cm)"
                CASE 9: Tipo$ = "Fresagem(4cm)+Recapeamento(10cm)"
                CASE 10: Tipo$ = "Fresagem(4cm)+Recapeamento(11cm)"
                CASE 11: Tipo$ = "Fresagem(4cm)+Recapeamento(4cm)"
                CASE 12: Tipo$ = "Fresagem(4cm)+Recapeamento(5cm)"
                CASE 13: Tipo$ = "Fresagem(4cm)+Recapeamento(7cm)"
                CASE 14: Tipo$ = "Fresagem(4cm)+Recapeamento(8cm)"
                CASE 15: Tipo$ = "Fresagem(5cm)+Recapeamento(5cm)"
                CASE 16: Tipo$ = "Fresagem(5cm)+Recapeamento(6cm)"
                CASE 17: Tipo$ = "Fresagem(5cm)+Recapeamento(8cm)"
                CASE 18: Tipo$ = "Fresagem(5cm)+Recapeamento(9cm)"
                CASE 19: Tipo$ = "Fresagem(6cm)+Recapeamento(6cm)"
                CASE 20: Tipo$ = "Fresagem(6cm)+Recapeamento(7cm)"
                CASE 21: Tipo$ = "Fresagem(7cm)+Recapeamento(10cm)"
                CASE 22: Tipo$ = "Fresagem(7cm)+Recapeamento(7cm)"
                CASE 23: Tipo$ = "Fresagem(7cm)+Recapeamento(8cm)"
                CASE 24: Tipo$ = "Fresagem(8cm)+Recapeamento(8cm)"
                CASE 25: Tipo$ = "Fresagem(9cm)+Recapeamento(9cm)"
                CASE 26: Tipo$ = "Recapeamento Simples (10cm)"
                CASE 27: Tipo$ = "Recapeamento Simples (3cm)"
                CASE 28: Tipo$ = "Recapeamento Simples (4cm)"
                CASE 29: Tipo$ = "Recapeamento Simples (5cm)"
                CASE 30: Tipo$ = "Recapeamento Simples (6cm)"
                CASE 31: Tipo$ = "Recapeamento Simples (7cm)"
                CASE 32: Tipo$ = "Recapeamento Simples (8cm)"
                CASE 33: Tipo$ = "Recapeamento Simples (9cm)"
                CASE 34: Tipo$ = "Micro-revestimento asfltico"
                CASE 35: Tipo$ = "Capa Selante"
                CASE 36: Tipo$ = "Tratamento Superficial Duplo"
                CASE 37: Tipo$ = "Cape-Seal (TSS+Micro)"
                CASE 38: Tipo$ = "Remendo Profundo"
                CASE ELSE: Tipo$ = "Outros"
            END SELECT
            WRITE #3, Tipo$, ClasseInterv(ANO, I)
        NEXT I
        CLOSE #3
    END IF

NEXT ANO
CLOSE #15, #16

IF GeraDet$ = "S" THEN

    I = 50
    DIM CP(I), AST(I), ExtCR(I), ACL(I), CA(I), Pt(I), Repm2(I), Frm3(I), Remm3(I), V(I)
    DIM CL(I), TSS(I), TSD(I), PMF(I), Pint(I), RemA(I), BaseA(I), RP(I), RL(I), BG(I)

    FOR IRodov = 1 TO NRODOV

        ARQUIVO$ = CALC$ + "TA" + Rodov$(IRodov) + "PT.csv"
        OPEN ARQUIVO$ FOR OUTPUT AS #1
        ARQUIVO$ = CALC$ + "TA" + Rodov$(IRodov) + "AC.csv"
        OPEN ARQUIVO$ FOR OUTPUT AS #2

        ARQUIVO$ = CALC$ + ARQ$ + Rodov$(IRodov) + "PT.csv"
        OPEN ARQUIVO$ FOR INPUT AS #15
        LINE INPUT #15, LINHA$
        ARQUIVO$ = CALC$ + ARQ$ + Rodov$(IRodov) + "AC.csv"
        OPEN ARQUIVO$ FOR INPUT AS #16
        LINE INPUT #16, LINHA$
        I = 0
        WHILE NOT EOF(15)
            I = I + 1
            INPUT #15, J, CP(I), AST(I), ExtCR(I), ACL(I), CA(I), Pt(I), Repm2(I), Frm3(I), Remm3(I), BG(I)
            RP(I) = ACL(I) / 2
            INPUT #16, J, CL(I), TSS(I), TSD(I), PMF(I), Pint(I), RemA(I), BaseA(I)
            RL(I) = CL(I) / 2
        WEND
        CLOSE #15, #16

        WRITE #1, "QUANTIDADES"
        WRITE #1, "CBUQ", CA(1), CA(2), CA(3), CA(4), CA(5), CA(6), CA(7), CA(8), CA(9), CA(10), CA(11), CA(12), CA(13), CA(14), CA(15), CA(16), CA(17), CA(18), CA(19), CA(20)
        WRITE #1, "Reperf", Repm2(1), Repm2(2), Repm2(3), Repm2(4), Repm2(5), Repm2(6), Repm2(7), Repm2(8), Repm2(9), Repm2(10), Repm2(11), Repm2(12), Repm2(13), Repm2(14), Repm2(15), Repm2(16), Repm2(17), Repm2(18), Repm2(19), Repm2(20)
        WRITE #1, "Fres", Frm3(1), Frm3(2), Frm3(3), Frm3(4), Frm3(5), Frm3(6), Frm3(7), Frm3(8), Frm3(9), Frm3(10), Frm3(11), Frm3(12), Frm3(13), Frm3(14), Frm3(15), Frm3(16), Frm3(17), Frm3(18), Frm3(19), Frm3(20)
        WRITE #1, "BG", BG(1), BG(2), BG(3), BG(4), BG(5), BG(6), BG(7), BG(8), BG(9), BG(10), BG(11), BG(12), BG(13), BG(14), BG(15), BG(16), BG(17), BG(18), BG(19), BG(20)
        WRITE #1, "Rem", Remm3(1), Remm3(2), Remm3(3), Remm3(4), Remm3(5), Remm3(6), Remm3(7), Remm3(8), Remm3(9), Remm3(10), Remm3(11), Remm3(12), Remm3(13), Remm3(14), Remm3(15), Remm3(16), Remm3(17), Remm3(18), Remm3(19), Remm3(20)
        WRITE #1, "Rep.Sup.", RP(1), RP(2), RP(3), RP(4), RP(5), RP(6), RP(7), RP(8), RP(9), RP(10), RP(11), RP(12), RP(13), RP(14), RP(15), RP(16), RP(17), RP(18), RP(19), RP(20)
        WRITE #1, "Rep.Prof.", RP(1), RP(2), RP(3), RP(4), RP(5), RP(6), RP(7), RP(8), RP(9), RP(10), RP(11), RP(12), RP(13), RP(14), RP(15), RP(16), RP(17), RP(18), RP(19), RP(20)
        WRITE #1, "Lama", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        WRITE #1, "Micro", CP(1), CP(2), CP(3), CP(4), CP(5), CP(6), CP(7), CP(8), CP(9), CP(10), CP(11), CP(12), CP(13), CP(14), CP(15), CP(16), CP(17), CP(18), CP(19), CP(20)
        WRITE #1, "TSD", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        WRITE #1, "Pintura", Pt(1), Pt(2), Pt(3), Pt(4), Pt(5), Pt(6), Pt(7), Pt(8), Pt(9), Pt(10), Pt(11), Pt(12), Pt(13), Pt(14), Pt(15), Pt(16), Pt(17), Pt(18), Pt(19), Pt(20)
        WRITE #1,
        WRITE #1, "EXTENSOES EM KM DE FAIXA"
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmCA(IRodov, ANO)
        NEXT ANO
        WRITE #1, "CBUQ", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmMF(IRodov, ANO)
        NEXT ANO
        WRITE #1, "Reperf", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmFR(IRodov, ANO)
        NEXT ANO
        WRITE #1, "Fres", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmBG(IRodov, ANO)
        NEXT ANO
        WRITE #1, "BG", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmRE(IRodov, ANO)
        NEXT ANO
        WRITE #1, "Rem", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmRP(IRodov, ANO) / 2
        NEXT ANO
        WRITE #1, "Rep.Sup.", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        WRITE #1, "Rep.Prof.", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        WRITE #1, "Lama", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmCP(IRodov, ANO)
        NEXT ANO
        WRITE #1, "Micro", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        WRITE #1, "TSD", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmPT(IRodov, ANO)
        NEXT ANO
        WRITE #1, "Pintura", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)

        WRITE #2, "QUANTIDADES"
        WRITE #2, "CBUQ", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        WRITE #2, "PMQ", PMF(1), PMF(2), PMF(3), PMF(4), PMF(5), PMF(6), PMF(7), PMF(8), PMF(9), PMF(10), PMF(11), PMF(12), PMF(13), PMF(14), PMF(15), PMF(16), PMF(17), PMF(18), PMF(19), PMF(20)
        WRITE #2, "Reperf", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        WRITE #2, "Fres", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        WRITE #2, "Base", BaseA(1), BaseA(2), BaseA(3), BaseA(4), BaseA(5), BaseA(6), BaseA(7), BaseA(8), BaseA(9), BaseA(10), BaseA(11), BaseA(12), BaseA(13), BaseA(14), BaseA(15), BaseA(16), BaseA(17), BaseA(18), BaseA(19), BaseA(20)
        WRITE #2, "Rem", RemA(1), RemA(2), RemA(3), RemA(4), RemA(5), RemA(6), RemA(7), RemA(8), RemA(9), RemA(10), RemA(11), RemA(12), RemA(13), RemA(14), RemA(15), RemA(16), RemA(17), RemA(18), RemA(19), RemA(20)
        WRITE #2, "Rep.Sup.", RL(1), RL(2), RL(3), RL(4), RL(5), RL(6), RL(7), RL(8), RL(9), RL(10), RL(11), RL(12), RL(13), RL(14), RL(15), RL(16), RL(17), RL(18), RL(19), RL(20)
        WRITE #2, "Rep.Prof.", RL(1), RL(2), RL(3), RL(4), RL(5), RL(6), RL(7), RL(8), RL(9), RL(10), RL(11), RL(12), RL(13), RL(14), RL(15), RL(16), RL(17), RL(18), RL(19), RL(20)
        WRITE #2, "Lama", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        WRITE #2, "TSS", TSS(1), TSS(2), TSS(3), TSS(4), TSS(5), TSS(6), TSS(7), TSS(8), TSS(9), TSS(10), TSS(11), TSS(12), TSS(13), TSS(14), TSS(15), TSS(16), TSS(17), TSS(18), TSS(19), TSS(20)
        WRITE #2, "TSD", TSD(1), TSD(2), TSD(3), TSD(4), TSD(5), TSD(6), TSD(7), TSD(8), TSD(9), TSD(10), TSD(11), TSD(12), TSD(13), TSD(14), TSD(15), TSD(16), TSD(17), TSD(18), TSD(19), TSD(20)
        WRITE #2, "Pintura", Pint(1), Pint(2), Pint(3), Pint(4), Pint(5), Pint(6), Pint(7), Pint(8), Pint(9), Pint(10), Pint(11), Pint(12), Pint(13), Pint(14), Pint(15), Pint(16), Pint(17), Pint(18), Pint(19), Pint(20)
        WRITE #2,
        WRITE #2, "EXTENSOES EM KM DE FAIXA"
        WRITE #2, "CBUQ", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmPMF(IRodov, ANO)
        NEXT ANO
        WRITE #2, "PMF", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        WRITE #2, "Reperf", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        WRITE #2, "Fres", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmBASE(IRodov, ANO)
        NEXT ANO
        WRITE #2, "BASE", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmREM(IRodov, ANO)
        NEXT ANO
        WRITE #2, "Rem", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmREP(IRodov, ANO) / 2
        NEXT ANO
        WRITE #2, "Rep.Sup.", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        WRITE #2, "Rep.Prof.", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        WRITE #2, "Lama", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmTSS(IRodov, ANO)
        NEXT ANO
        WRITE #2, "TSS", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmTSD(IRodov, ANO)
        NEXT ANO
        WRITE #2, "TSD", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)
        FOR ANO = 1 TO NPeriodos
            V(ANO) = kmPi(IRodov, ANO)
        NEXT ANO
        WRITE #2, "Pintura", V(1), V(2), V(3), V(4), V(5), V(6), V(7), V(8), V(9), V(10), V(11), V(12), V(13), V(14), V(15), V(16), V(17), V(18), V(19), V(20)

        CLOSE #1, #2

    NEXT IRodov

END IF

10 SYSTEM

