CLS

PI# = 3.141592654#
DIM R(18), Z(18), DF(9), D(9), ESURF(9), SVERT(9), Dx(9)
V = 1
DIM X(V + 2), S(V + 2), T(V + 2), A(V + 2, V + 2)

' Carga de referencia para a conversao das deflexoes do FWD
LOAD = 4100
Dplaca = 30
Raio = Dplaca / 2
Pressao = LOAD / (PI# * (Raio ^ 2))
NPONTOS = 7

PRINT
PRINT "    ANALISE ESTRUTURAL DOS SUBTRECHOS HOMOGENEOS   "
PRINT

NFaixasMax = 4

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DADOSANOBASE$
CLOSE #1

' Fatores de Calibracao do Modelo AASHTO-HDM
OPEN "FcAASHTOHDM.csv" FOR INPUT AS #1
LINE INPUT #1, LINHA$
INPUT #1, Tipo$, FcPavNovoPSISL, FcPavNovoPSISB, FcPavNovoPSIBS, CfRecapPSI
INPUT #1, Tipo$, FcPavNovoSCISL, FcPavNovoSCISB, FcPavNovoSCIBS, CfRecapSCI
CLOSE #1

ARQUIVO$ = CALC$ + "TipoLev.dat"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TipoLev$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DADOSANOBASE$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodovia$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodovia$(I)
NEXT I
CLOSE #1

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

' Criterios complementares para as arvores de decisao
ARQUIVO$ = CALC$ + "CRITERIO.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, TRcrit
INPUT #1, QIcrit
INPUT #1, ATRcrit
INPUT #1, ATRITOcrit
INPUT #1, UsaModulos$
INPUT #1, IGGcrit
INPUT #1, PSIf
CLOSE #1

ARQ$ = CALC$ + "REF.DAT"
OPEN ARQ$ FOR INPUT AS #1
INPUT #1, TRECHO$
INPUT #1, Faixa
INPUT #1, PP
INPUT #1, NC
INPUT #1, TAXA
INPUT #1, PSIt
INPUT #1, GrTraf$
INPUT #1, RestrGreide$
CLOSE #1

' Parametros para o Fator de Seguranca no Guia da AASHTO

' Overall standard deviation
GrTraf$ = UCASE$(GrTraf$)
SELECT CASE GrTraf$
    CASE "A": S0 = .5
    CASE "M": S0 = .4
    CASE "B": S0 = .3
    CASE ELSE: S0 = .4
END SELECT

' Nivel de Confiabilidade
R(1) = 50: Z(1) = 0
R(2) = 60: Z(2) = -.253
R(3) = 70: Z(3) = -.524
R(4) = 75: Z(4) = -.674
R(5) = 80: Z(5) = -.841
R(6) = 85: Z(6) = -1.037
R(7) = 90: Z(7) = -1.282
R(8) = 91: Z(8) = -1.34
R(9) = 92: Z(9) = -1.405
R(10) = 93: Z(10) = -1.476
R(11) = 94: Z(11) = -1.555
R(12) = 95: Z(12) = -1.645
R(13) = 96: Z(13) = -1.751
R(14) = 97: Z(14) = -1.881
R(15) = 98: Z(15) = -2.054
R(16) = 99: Z(16) = -2.327
R(17) = 99.9: Z(17) = -3.09
R(18) = 99.99: Z(18) = -3.75
IF NC <= 50 THEN
    ZR = 0
ELSE
    IF NC <= R(2) THEN
        I1 = 1: I2 = 2
    ELSE
        IF NC <= R(3) THEN
            I1 = 2: I2 = 3
        ELSE
            IF NC <= R(4) THEN
                I1 = 3: I2 = 4
            ELSE
                IF NC <= R(5) THEN
                    I1 = 4: I2 = 5
                ELSE
                    IF NC <= R(6) THEN
                        I1 = 5: I2 = 6
                    ELSE
                        IF NC <= R(7) THEN
                            I1 = 6: I2 = 7
                        ELSE
                            IF NC <= R(8) THEN
                                I1 = 7: I2 = 8
                            ELSE
                                IF NC <= R(9) THEN
                                    I1 = 8: I2 = 9
                                ELSE
                                    IF NC <= R(10) THEN
                                        I1 = 9: I2 = 10
                                    ELSE
                                        IF NC <= R(11) THEN
                                            I1 = 10: I2 = 11
                                        ELSE
                                            IF NC <= R(12) THEN
                                                I1 = 11: I2 = 12
                                            ELSE
                                                IF NC <= R(13) THEN
                                                    I1 = 12: I2 = 13
                                                ELSE
                                                    IF NC <= R(14) THEN
                                                        I1 = 13: I2 = 14
                                                    ELSE
                                                        IF NC <= R(15) THEN
                                                            I1 = 14: I2 = 15
                                                        ELSE
                                                            IF NC <= R(16) THEN
                                                                I1 = 15: I2 = 16
                                                            ELSE
                                                                IF NC <= R(17) THEN
                                                                    I1 = 16: I2 = 17
                                                                ELSE
                                                                    I1 = 17: I2 = 18
                                                                END IF
                                                            END IF
                                                        END IF
                                                    END IF
                                                END IF
                                            END IF
                                        END IF
                                    END IF
                                END IF
                            END IF
                        END IF
                    END IF
                END IF
            END IF
        END IF
    END IF
    ' Interpolacao Linear
    X = NC
    X1 = R(I1)
    X2 = R(I2)
    Y1 = Z(I1)
    Y2 = Z(I2)
    ZR = ((X2 * Y1 - X1 * Y2) + X * (Y2 - Y1)) / (X2 - X1)
END IF

SELECT CASE Faixa
    CASE 1: Faixa$ = "1"
    CASE 2: Faixa$ = "2"
    CASE 3: Faixa$ = "3"
    CASE 4: Faixa$ = "4"
    CASE ELSE
        PRINT "ERRO"
END SELECT

' Dados do pavimento dentro dos subtrechos homogeneos

ARQUIVO$ = CALC$ + "HR" + TRECHO$ + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #1
WRITE #1, "STH", "km", "D0fwd", "HRestrut_cm", "Camada Critica", "HR_func", "Medida", "hc_cm", "HR_cm", "h2_cm", "Acost.", "hcac_cm", "HRac_cm", "h2ac_cm", "SN", "Hrev", "Hbase", "Hsub", "Href", "E1ref", "Erev", "Ebase+sb", "Ebase", "Efund", "Esl", "JDR", "Eccp", "Kef"

ARQUIVO$ = CALC$ + "REP" + TRECHO$ + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #13
WRITE #13, "Subtrecho", "km", "Tipo de Reparo"

ARQUIVO$ = CALC$ + "D" + TRECHO$ + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #15
WRITE #15, "STH", "km", "D0vbk", "Nano_USACE", "VR_anos", "Rc_m", "Dadm_PRO11", "HR_PRO11", "MedPRO11", "Tipo_SL", "hef_cm", "Dadm_PRO269", "HR_PRO269", "Idade"

ARQUIVO$ = CALC$ + "Mod_" + TRECHO$ + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR OUTPUT AS #14
WRITE #14, "km", "h1 cm", "E1", "Temp", "h2 cm", "E2", "h3 cm", "E3", "h4 cm", "E4", "h5 cm", "E5", "E1ref", "D0ref", "SN", "Data", "Equip."

' Analisa cada bacia do FWD

ARQUIVO$ = DADOSANOBASE$ + "DEFLEX\" + TRECHO$ + "_" + Faixa$ + ".CSV"
OPEN ARQUIVO$ FOR INPUT AS #2
LINE INPUT #2, LINHA$
WHILE NOT EOF(2)

    INPUT #2, km, CARGA, DF(1), DF(2), DF(3), DF(4), DF(5), DF(6), DF(7), TAR, TSUP, D(1), D(2), D(3), D(4), D(5), D(6), D(7), Dplaca, DAT$, Equipamento$

    PRINT "km "; km

    Exec$ = "S"
    FOR I = 1 TO 7
        IF DF(I) <= 0 THEN Exec$ = "N"
    NEXT I

    IF Exec$ = "S" THEN

        Qkgf = CARGA
        p0 = Qkgf / (PI# * (Raio ^ 2))

        ARQUIVO$ = CALC$ + "ESTR" + TRECHO$ + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #3
        LINE INPUT #3, LINHA$

        ARQUIVO$ = CALC$ + "CADAS" + TRECHO$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #4
        LINE INPUT #4, LINHA$

        Hrev = -1
        Hbase = -1
        Hsub = -1
        Href = -1
        Hp = -1
        TipoPista$ = ""
        Rev$ = ""
        NLayers = 0

        WHILE NOT EOF(3)

            INPUT #4, STH$, Rodov$, INI$, FIM$, KMI, KMF, PISTA$
            INPUT #4, NFaixas, PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
            INPUT #4, GEOVERT$, GEOHORIZ$, SECTIPO$, FX(1), FX(2), FX(3), FX(4), DECTRA, RESTR, ExtPontes, OBS$

            INPUT #3, STH$, ANORIG, REVORIG$, MARSHALL, RTDIAMET, VAZIOSAR, TEORASF
            INPUT #3, H1CM, CamBase$, H2CM, CBRBS, RCS28DBASE, SUBBASE$
            INPUT #3, H3CM, CBRSUB, RCS28DSUBB, REFSL$, H4CM, CBRREF
            INPUT #3, SL$, CBRsl, LLSL, IPSL, P200SL, PROFROCHAm

            IF KMF > KMI THEN
                IF (km >= KMI AND km <= KMF) THEN
                    Subtrecho$ = STH$
                    TipoPista$ = PISTA$
                    GOSUB 300
                    QIa = QImed
                    IF H1REV > 0 THEN
                        Hrev = H1REV
                        Hbase = H2CM
                        NLayers = 3
                        Hp = H1REV + H2CM
                        IF H3CM > 0 THEN
                            Hp = Hp + H3CM
                            Hsub = H3CM
                            NLayers = 4
                        ELSE
                            Hsub = 0
                        END IF
                        IF H4CM > 0 THEN
                            Hp = Hp + H4CM
                            Href = H4CM
                            NLayers = 5
                        ELSE
                            Href = 0
                        END IF
                        NP = 0
                        FOR I = 1 TO PP
                            Nano = NanoAASHTO * ((1 + (TAXA / 100)) ^ I)
                            NP = NP + Nano
                        NEXT I
                        NanoMed = NP / PP
                    END IF
                    Raio = Dplaca / 2
                END IF
            ELSE
                IF (km <= KMI AND km >= KMF) THEN
                    Subtrecho$ = STH$
                    TipoPista$ = PISTA$
                    GOSUB 300
                    IF H1REV > 0 THEN
                        Hrev = H1REV
                        Hbase = H2CM
                        NLayers = 3
                        Hp = H1REV + H2CM
                        IF H3CM > 0 THEN
                            Hp = Hp + H3CM
                            Hsub = H3CM
                            NLayers = 4
                        ELSE
                            Hsub = 0
                        END IF
                        IF H4CM > 0 THEN
                            Hp = Hp + H4CM
                            Href = H4CM
                            NLayers = 5
                        ELSE
                            Href = 0
                        END IF
                        NP = 0
                        FOR I = 1 TO PP
                            Nano = NanoAASHTO * ((1 + (TAXA / 100)) ^ I)
                            NP = NP + Nano
                        NEXT I
                        NanoMed = NP / PP
                    END IF
                    Raio = Dplaca / 2
                END IF
            END IF

        WEND
        CLOSE #3, #4
        HT = Hp

        IF Hrev > 0 THEN

            E1min = 10000
            E1max = 100000
            CamBase$ = UCASE$(CamBase$)
            SELECT CASE CamBase$
                CASE "CBUQ", "PMQ", "CBUQ+PMQ", "CBUQ+PMF", "PMF", "MB"
                    E2min = 7000
                    E2max = 70000
                CASE "SC", "SOLO-CIMENTO", "SOLO-CAL", "BGTC"
                    E2min = 3000
                    E2max = 150000
                CASE "CCP", "CCR"
                    E2min = 50000
                    E2max = 500000
                CASE ELSE
                    E2min = 300
                    E2max = 10000
            END SELECT
            SUBBASE$ = UCASE$(SUBBASE$)
            SELECT CASE SUBBASE$
                CASE "CBUQ", "PMQ", "CBUQ+PMQ", "CBUQ+PMF", "PMF", "MB"
                    E3min = 7000
                    E3max = 70000
                CASE "SC", "SOLO-CIMENTO", "SOLO-CAL", "BGTC"
                    E3min = 3000
                    E3max = 150000
                CASE "CCP", "CCR"
                    E3min = 50000
                    E3max = 500000
                CASE ELSE
                    E3min = 300
                    E3max = 10000
            END SELECT
            ESLmin = 300
            ESLmax = 9000
            IF NLayers = 3 THEN
                EpMin = (Hrev * E1min + Hbase * E2min) / HT
                EpMax = (Hrev * E1max + Hbase * E2max) / HT
            ELSE
                EpMin = (Hrev * E1min + Hbase * E2min + Hsub * E3min) / HT
                EpMax = (Hrev * E1max + Hbase * E2max + Hsub * E3max) / HT
            END IF

            ' Converte D0 a 70oF e 4100 kgf
            GOSUB 10
            DeflexRef = Fd * DF(1) * (LOAD / CARGA)

            AREAref = 0
            FOR IP = 1 TO NPONTOS - 1
                IF IP = 1 THEN Deflex = Fd * DF(1) ELSE Deflex = DF(IP)
                AREAref = AREAref + ((Deflex + DF(IP + 1)) / 2) * (D(IP + 1) - D(IP))
            NEXT IP

            ' Retroanalise com o sistema de duas camadas elasticas (Swift)
            NPassos = 100
            PassoEp = (EpMax - EpMin) / NPassos
            PassoSL = (ESLmax - ESLmin) / NPassos
            ErroMin = 1.0E10
            Ep = EpMin
            FOR IEP = 1 TO NPassos
                Esl = ESLmin
                FOR ISL = 1 TO NPassos
                    FOR IP = 2 TO NPONTOS
                        XX = 2 * HT * (((Ep + 2 * Esl) / (3 * Esl)) ^ (1 / 3))
                        LL = ((D(IP) ^ 2) + (XX ^ 2)) ^ 0.5
                        BLOC = (3 * D(IP) * (XX ^ 4) / (2 * (LL ^ 5))) + (D(IP) * (XX ^ 2) / (2 * (LL ^ 3))) + (D(IP) / LL)
                        BLOC = BLOC * ((1 / Esl) - (1 / Ep)) + (1 / Esl)
                        Dx(IP) = 1000 * BLOC * 3 * Qkgf / (4 * PI# * D(IP))
                    NEXT IP
                    ' Valor de D0 pela formula do Guia da AASHTO (1993)
                    Bloc1 = 1 / (Esl * (1 + ((((Ep / Esl) ^ (1 / 3)) * HT / Raio) ^ 2)) ^ (1 / 2))
                    Bloc2 = (1 - (1 / ((1 + ((HT / Raio) ^ 2)) ^ (1 / 2)))) / Ep
                    Dx(1) = 1000 * 1.5 * p0 * Raio * (Bloc1 + Bloc2)
                    AREA = 0
                    FOR IP = 1 TO NPONTOS - 1
                        AREA = AREA + ((Dx(IP) + Dx(IP + 1)) / 2) * (D(IP + 1) - D(IP))
                    NEXT IP
                    Erro = 100 * ABS(AREA - AREAref) / AREAref
                    IF Erro < ErroMin THEN
                        ErroMin = Erro
                        EpOt = Ep
                        Eslot = Esl
                    END IF
                    Esl = Esl + PassoSL
                NEXT ISL
                Ep = Ep + PassoEp
            NEXT IEP

            Deflex = DF(1) * (LOAD / CARGA)
            DF(1) = Deflex * Fd
            FOR I = 2 TO 7
                DF(I) = (LOAD / CARGA) * DF(I)
            NEXT I

            ' Numero Estrutural Efetivo do pavimento
            X = Raio + 1.5 * HT
            GOSUB 100
            SNrhode = SN
            SNaashto = 0.0045 * (HT / 2.54) * ((EpOt / 0.0703) ^ (1 / 3))
            IF SNrhode > 0 THEN SNef = (SNaashto + SNrhode) / 2 ELSE SNef = SNaashto

            IF DF(1) > 0 THEN

                X1 = D(2): Y1 = DF(2)
                X2 = D(3): Y2 = DF(3)
                X = 25
                D25 = ((X2 * Y1 - X1 * Y2) - X * (Y1 - Y2)) / (X2 - X1)
                Rc = 3125 / (DF(1) - D25)
                X = 30
                D30 = ((X2 * Y1 - X1 * Y2) - X * (Y1 - Y2)) / (X2 - X1)
                X1 = D(4): Y1 = DF(4)
                X2 = D(5): Y2 = DF(5)
                X = 60
                D60 = ((X2 * Y1 - X1 * Y2) - X * (Y1 - Y2)) / (X2 - X1)
                X1 = D(5): Y1 = DF(5)
                X2 = D(6): Y2 = DF(6)
                X = 90
                D90 = ((X2 * Y1 - X1 * Y2) - X * (Y1 - Y2)) / (X2 - X1)

                ' Modulo Dinamico do Revestimento em CBUQ

                ' Parametros do CBUQ de referencia adotado
                VV = 4
                PB = 5.2
                P200 = 7
                PNT = 60
                PAC = PB
                ' Parametros da mistura obtidos atraves de correlacoes
                VB = PB / .434
                TRB = 153.19 * (PNT ^ -.2596)
                VISC = 29508.2 * (PNT ^ -2.1939)
                PTS = ((LOG(800) / LOG(10)) - (LOG(PNT) / LOG(10))) / (TRB - 25)
                IP = (20 - 500 * PTS) / (1 + 50 * PTS)
                ' Calculo da espessura efetiva do revestimento existente
                DTFWD = 30
                h1 = Hrev
                ' Temperatura da camada (Gomez & Thompson, 1984)
                Z = h1 / 2.54
                TREF = 45.4 + 1.32 * Z
                TAIR = 1.8 * TAR + 32
                TMIX1 = 1.8 * TSUP + 32
                IF TAIR >= TREF THEN
                    TMIX = -10 + 1.39 * TAIR - .52 * Z
                ELSE
                    TMIX = 7.7 + 1! * TAIR - .004 * Z
                END IF
                TMIX = (TMIX + 2 * TMIX1) / 3
                TREV = (TMIX - 32) / 1.8
                PERIODO = DTFWD / 1000
                FREQ = 1 / PERIODO
                GOSUB 1000

                ' Deformacao maxima de tracao sob o revestimento
                Epst = .4383 + 1.73711 * (LOG(Deflex / 2.54) / LOG(10))
                Epst = Epst - .0538 * (D30 / 2.54) + .1801 * (D60 / 2.54) - .192 * (D90 / 2.54)
                Epst = (10 ^ Epst) / 1000000!
                ' Espessura efetiva em CBUQ convencional que reproduz a deflexao de campo
                IF Epst > 1.E-9 THEN
                    h1ef = (LOG(Epst * 1000000!) / LOG(10)) - 2.2469 - .2912 * (LOG(Deflex / 2.54) / LOG(10))
                    h1ef = 2.54 * h1ef / (.1233 - .06681 * LOG(EACKSI) / LOG(10))
                    IF h1ef < 0 THEN h1ef = 0
                ELSE
                    h1ef = Hrev
                END IF
                'IF h1ef > Hrev THEN h1ef = Hrev

                ' Retroanalise do Modulo de Elasticidade Equivalente da Fundacao
                HT = Hrev + Hbase
                X = Raio + 1.5 * HT
                ' Modulo de Elasticidade da Fundacao
                GOSUB 500
                E3 = MR
                E3 = 1.078 * (E3 ^ 0.9943)

                ' Valor de SN acima do subleito
                CamCrit$ = "Subleito"
                HT = Hp
                X = Raio + 1.5 * HT
                SNnominal = .44 * Hrev + .14 * Hbase
                Hsb = Hp - (Hrev + Hbase)
                IF Hsb > 0 THEN SNnominal = SNnominal + .11 * Hsb
                SNnominal = SNnominal / 2.54
                GOSUB 100
                IF SN = -1 THEN SN = SNnominal
                SNtotal = SN
                GOSUB 500
                IF MR < 300 THEN
                    IF E3 < 300 THEN
                        E3 = 300
                        MRsl = 300
                    ELSE
                        MRsl = E3
                    END IF
                ELSE
                    MRsl = MR
                    IF E3 < 300 THEN E3 = MRsl
                END IF
                MRsl = 1.078 * (MRsl ^ 0.9943)

                CBRsl = MRsl / 100
                IF CBRsl < 3 THEN CBRsl = 3
                IF CBRsl > 35 THEN CBRsl = 35
                LCBR = LOG(CBRsl) / LOG(10)
                SNcbr = 3.51 * LCBR - .85 * (LCBR ^ 2) - 1.43
                SNC = SN + SNcbr

                ' Espessura de recapeamento em CBUQ para correcao funcional
                ARQUIVO$ = DADOSANOBASE$ + "QI\" + TRECHO$ + ".CSV"
                OPEN ARQUIVO$ FOR INPUT AS #3
                LINE INPUT #3, LINHA$
                WHILE NOT EOF(3)
                    INPUT #3, kmini, kmfim, QI(1), QI(2), QI(3), QI(4), DataLev$, EquipLev$
                    IF kmfim > kmini THEN
                        IF (kmini <= km AND km <= kmfim) THEN QIa = QI(Faixa)
                    ELSE
                        IF (kmini >= km AND km >= kmfim) THEN QIa = QI(Faixa)
                    END IF
                WEND
                CLOSE #3
                IF QIa >= 0 THEN
                    IRIt = QIcrit / 13
                    HR = 0: Vfunc = 0: hc = 0
                    WHILE Vfunc < PP
                        HR = HR + .5
                        QIest = QIa
                        GOSUB 6900
                        IRI0 = QIest / 13
                        SNCnew = SNC + .44 * (HR / 2.54)
                        IRIest = IRI0
                        Age = 0
                        WHILE IRIest < IRIt
                            Age = Age + .1
                            Nac = Age * (NanoAASHTO / 1000000!)
                            IRIest = (IRI0 + 725 * ((1 + SNCnew) ^ -4.99) * Nac) * EXP(.0153 * Age)
                        WEND
                        Vfunc = Age
                    WEND
                    IF HR > .5 THEN HRfunc = HR ELSE HRfunc = 0
                ELSE
                    HRfunc = 0
                END IF

                '- - - - - - - - - - - - - - - - - - - -
                ' Espessura de reforco requerido pelo  -
                '-         Modelo AASHTO-HDM           -
                '- - - - - - - - - - - - - - - - - - - -
                  
                ' Analise da camada de recapeamento aplicada sobre o pavimento antigo
                SNp = 0
                MR = (2 * (1 - 0.35 * 0.35) * 5.6 * 15 / (DF(1) / 1000)) / 0.0703
                Cf = CfRecapPSI
                FcPSI = FcPavNovoPSIBS
                FcSCI = FcPavNovoSCIBS
                GOSUB 1500
                HRmax = HR
                CamCrit$ = "Pav.Exist."

                ' Analise da necessidade de reforco da espessura total de pavimento
                MRsurf = MRsl
                SNp = SN
                MR = MRsurf
                Cf = 1
                FcPSI = FcPavNovoPSISL
                FcSCI = FcPavNovoSCISL
                GOSUB 1500
                IF HR > HRmax THEN
                    HRmax = HR
                    CamCrit$ = "Subleito"
                END IF

                ' Espessura de reforco necessaria para a fundacao do pavimento
                ' Valor de SN acima da sub-base/reforco
                HT = Hrev + Hbase
                X = Raio + 1.5 * HT
                SNnominal = .44 * Hrev + .14 * Hbase
                SNnominal = SNnominal / 2.54
                GOSUB 100
                IF SN = -1 THEN SN = SNnominal
                SNp = SN
                MR = MRsurf
                Cf = 1
                FcPSI = FcPavNovoPSISB
                FcSCI = FcPavNovoSCISB
                GOSUB 1500
                HRsubref = HR
                IF HR > HRmax THEN
                    HRmax = HR
                    CamCrit$ = "Sub-base/Reforco do SL"
                END IF

                ' Valor de SN acima da camada de base
                HT = Hrev
                X = Raio + 1.5 * HT
                SNnominal = .44 * Hrev
                SNnominal = SNnominal / 2.54
                GOSUB 100
                EtopBase = MRsurf
                IF SN = -1 THEN SN = SNnominal
                SNp = SN
                MR = MRsurf
                Cf = 1
                FcPSI = FcPavNovoPSIBS
                FcSCI = FcPavNovoSCIBS
                GOSUB 1500
                IF HR > HRmax THEN
                    HRmax = HR
                    CamCrit$ = "Base"
                END IF
                IF EtopBase > 500 THEN HRbase = HR ELSE HRbase = 0

                ' Trincamento por Fadiga do Revestimento em CBUQ
                ' Calculo da espessura de reforco em CBUQ
                h1 = Hrev
                TMIX = 70
                RaioRoda = (2050 / (PI# * 5.6)) ^ .5
                VEL# = 90 * 100 / (60 * 60)
                PERIODO = (2 * RaioRoda + 3 * h1) / (VEL# * 1000)
                FREQ = 1 / PERIODO
                GOSUB 1000
                ' Lei de Fadiga do T.A.I.
                MMIX = 4.84 * ((VB / (VV + VB)) - .69)
                CMIX = 10 ^ MMIX
                ENEtai = 3.291
                Ktai = 18.4 * CMIX * .004325 * (EACPSI ^ -.854)
                EpstAdm = (NP / Ktai) ^ (-1 / ENEtai)
                HR = 2.9
                Epst = 2 * EpstAdm
                WHILE Epst > EpstAdm
                    HR = HR + .1
                    D0L = DF(1) * (10 ^ (-(HR - h1) / 40)) / 2.54
                    Epst = 2.2469 + .2912 * (LOG(D0L) / LOG(10))
                    Epst = Epst + .1233 * (HR / 2.54) - .06681 * (HR / 2.54) * (LOG(EACKSI) / LOG(10))
                    Epst = (10 ^ Epst) / 1000000!
                WEND
                HR = HR - h1ef
                IF HR < 0 THEN HR = 0
                IF HR > HRbase THEN HRbase = HR
                IF HRbase > HRmax THEN
                    CamCrit$ = "Base"
                    HRmax = HRbase
                END IF

                IF HRmax < .1 THEN HRmax = 0

                ' Espessura de revestimento requerido pelo Guia da AASHTO
                ' no caso de reconstrucao
                PSI0 = 4.7
                SNp = .44 * (3 / 2.54)
                MRsurf = 4000 / .0703
                W18 = 0
                WHILE W18 < NP
                    SNp = SNp + .01
                    BETA = .4 + (1094 / ((SNp + 1) ^ 5.19))
                    HR = 2.54 * (SNp - SN) / .44
                    W18 = (10 ^ (ZR * S0)) * (((SNp + 1) / 1.05) ^ 9.36) * (((PSI0 - PSIt) / 2.7) ^ (1 / BETA)) * (((MRsurf / .0703) / 3000) ^ 2.32)
                WEND
                h1AASHTO = 2.54 * (SNp / .44)
                h1min = 1.0165 * LOG(NP) - 5.8245
                IF h1AASHTO < h1min THEN h1AASHTO = h1min
                IF h1AASHTO < 5 THEN h1AASHTO = 5

                ' Medida tipo CP
                HRmicro = 1
                HR = HRmicro
                hc = 0
                QIest = QIa
                GOSUB 900
                IF (VSCP >= PP AND HRfunc < HRmicro) THEN
                    MedCP$ = "CP"
                    HRCP = HR
                ELSE
                    ' Medida tipo FR+CP
                    HR = HRmicro
                    hc = HR
                    QIest = QIa
                    GOSUB 900
                    IF (VSCP >= PP AND HRfunc < 2 * HRmicro) THEN
                        MedCP$ = "FR+CP"
                        HRCP = HRmicro
                    ELSE
                        ' Medida tipo MF+CP
                        HR = HRmicro + 2
                        hc = 0
                        QIest = QIa
                        GOSUB 900
                        IF (VSCP >= PP AND HRfunc < HR) THEN
                            MedCP$ = "MF+CP"
                            HRCP = HR
                        ELSE
                            ' Medida tipo FR+MF+CP
                            HR = 1 + 2
                            hc = HR
                            QIest = QIa
                            GOSUB 900
                            IF (VSCP >= PP AND HRfunc < 2 * hc) THEN
                                MedCP$ = "FR+MF+CP"
                                HRCP = HR
                            ELSE
                                MedCP$ = ""
                                HRCP = 0
                            END IF
                        END IF
                    END IF
                END IF

                Medida$ = ""
                hc = 0
                h2 = 0
                HRestr = HRmax
                IF HRfunc > HRestr THEN
                    HR = HRfunc
                    Criterio$ = "Funcional"
                ELSE
                    HR = HRestr
                    Criterio$ = "Estrutural"
                END IF
                hcmax = H1REV - 3
                IF (MedCP$ <> "" OR HR < 2) THEN
                    IF RestrGreide$ = "S" THEN
                        IF Trincado$ = "S" THEN
                            IF hcmax > 4 THEN
                                Medida$ = "FR+MF+CP"
                                HR = HRmicro
                                hc = 2 + HR
                            ELSE
                                Medida$ = "FR+CP"
                                HR = HRmicro
                                hc = HR
                            END IF
                        ELSE
                            Medida$ = "FR+CP"
                            HR = HRmicro
                            hc = HR
                        END IF
                    ELSE
                        IF Trincado$ = "S" THEN
                            Medida$ = "MF+CP"
                            HR = HRmicro
                        ELSE
                            Medida$ = "CP"
                            HR = HRmicro
                        END IF
                    END IF
                ELSE
                    IF Criterio$ = "Funcional" THEN
                        IF Trincado$ = "S" THEN
                            IF RestrGreide$ = "S" THEN
                                IF HRestr <= hcmax + 2 THEN
                                    Medida$ = "FR+MF+RC"
                                    hc = HRestr + 2
                                    HR = HRestr
                                ELSE
                                    Medida$ = "RRP"
                                    HR = h1AASHTO
                                    hc = Hrev + Hbase
                                END IF
                            ELSE
                                IF HRestr < 13 THEN
                                    Medida$ = "MF+RC"
                                    HR = HRestr
                                ELSE
                                    h2 = 2 * (HRestr - h1AASHTO)
                                    IF h2 < 12 THEN h2 = 12
                                    HR = h1AASHTO
                                    IF h2 > 20 THEN
                                        Medida$ = "RRP"
                                        hc = Hrev + Hbase
                                        h2 = hc - HR
                                    ELSE
                                        Medida$ = "BG+RC"
                                    END IF
                                END IF
                            END IF
                        ELSE
                            IF HR <= 7.5 THEN
                                IF RestrGreide$ = "S" THEN
                                    IF hcmax >= 3 THEN
                                        IF HRestr <= 3 THEN
                                            Medida$ = "FR+RC"
                                            hc = 3
                                            HR = hc
                                        ELSE
                                            IF hcmax >= HRestr THEN
                                                Medida$ = "FR+RC"
                                                hc = HRestr
                                                HR = hc
                                            ELSE
                                                Medida$ = "FR+RC"
                                                hc = hcmax
                                                HR = HRestr
                                            END IF
                                        END IF
                                    ELSE
                                        Medida$ = "RRP"
                                        HR = h1AASHTO
                                        h2 = 12
                                        hc = HR + h2
                                    END IF
                                ELSE
                                    Medida$ = "RS"
                                END IF
                            ELSE
                                IF hcmax >= 7 THEN
                                    IF HRestr <= 7 THEN
                                        Medida$ = "FR+RC"
                                        hc = 7
                                        HR = hc
                                    ELSE
                                        IF HRestr <= 12 THEN
                                            Medida$ = "FR+RC"
                                            hc = 7
                                            HR = HRestr
                                        ELSE
                                            Medida$ = "RRP"
                                            hc = Hrev + Hbase
                                            HR = h1AASHTO
                                        END IF
                                    END IF
                                ELSE
                                    IF hcmax >= 3 THEN
                                        IF HRestr <= 7 THEN
                                            Medida$ = "FR+RC"
                                            hc = 3
                                            HR = 7
                                        ELSE
                                            IF HRestr <= 12 THEN
                                                Medida$ = "FR+RC"
                                                hc = 3
                                                HR = HRestr
                                            ELSE
                                                Medida$ = "RRP"
                                                hc = Hrev + Hbase
                                                HR = h1AASHTO
                                            END IF
                                        END IF
                                    ELSE
                                        Medida$ = "RRP"
                                        hc = Hrev + Hbase
                                        HR = h1AASHTO
                                    END IF
                                END IF
                            END IF
                        END IF
                    ELSE
                        IF Trincado$ = "N" THEN
                            IF RestrGreide$ = "N" THEN
                                IF HR > 13 THEN
                                    Medida$ = "RRP"
                                    hc = Hrev + Hbase
                                    HR = h1AASHTO
                                ELSE
                                    Medida$ = "RS"
                                END IF
                            ELSE
                                IF hcmax >= HR THEN
                                    Medida$ = "FR+RC"
                                    hc = HR
                                ELSE
                                    Medida$ = "RRP"
                                    hc = Hrev + Hbase
                                    HR = h1AASHTO
                                END IF
                            END IF
                        ELSE
                            IF HR > 13 THEN
                                h2 = 2 * (HR - h1AASHTO)
                                IF h2 < 12 THEN h2 = 12
                                IF RestrGreide$ = "S" THEN
                                    Medida$ = "RRP"
                                    hc = Hrev + Hbase
                                    HR = h1AASHTO
                                ELSE
                                    Medida$ = "BG+CBUQ"
                                    HR = h1AASHTO
                                END IF
                            ELSE
                                IF RestrGreide$ = "N" THEN
                                    Medida$ = "MF+RC"
                                ELSE
                                    IF (6 <= Hrev AND Hrev <= 10) THEN
                                        Medida$ = "FR+RC"
                                        hc = hcmax
                                        IF HR < hc THEN HR = hc
                                    ELSE
                                        IF hcmax >= HR + 2 THEN
                                            Medida$ = "FR+MF+RC"
                                            hc = HR + 2
                                        ELSE
                                            IF Hrev >= HR THEN
                                                Medida$ = "RRV"
                                                hc = HR
                                            ELSE
                                                Medida$ = "RRP"
                                                hc = Hrev + Hbase
                                                HR = h1AASHTO
                                            END IF
                                        END IF
                                    END IF
                                END IF
                            END IF
                        END IF
                    END IF
                END IF
                IF Medida$ = "MF+RC" THEN
                    IF HR < 3 THEN HR = 3
                END IF

                ' Soluo para o Acostamento
                Acost$ = ""
                hcac = 0
                HRac = 0
                h2ac = 0
                TipoPista$ = UCASE$(TipoPista$)
                IF (TipoPista$ = "DUPLA" AND Faixa = 1) THEN
                    Acost$ = Medida$
                    hcac = hc
                    HRac = HR
                    h2ac = h2
                ELSE
                    DegrauMed = Degraucm + (HR - hc)
                    IF DegrauMed > .4 THEN
                        IF DegrauMed < 1.3 THEN
                            IF PSRacost < 2 THEN
                                Acost$ = "ESC+Micro"
                                HRac = 1
                                hcac = 12
                            ELSE
                                Acost$ = "Micro"
                                HRac = DegrauMed
                            END IF
                        ELSE
                            IF DegrauMed < 2 THEN
                                IF PSRacost < 2 THEN
                                    Acost$ = "ESC+TSD"
                                    HRac = 2.5
                                    hcac = 12
                                ELSE
                                    Acost$ = "TSS"
                                    HRac = 1.5
                                END IF
                            ELSE
                                IF DegrauMed < 3 THEN
                                    IF PSRacost < 2 THEN
                                        Acost$ = "ESC+TSD"
                                        HRac = 2.5
                                        hcac = 12
                                    ELSE
                                        Acost$ = "TSD"
                                        HRac = 2.5
                                    END IF
                                ELSE
                                    IF DegrauMed < 7.5 THEN
                                        IF PSRacost < 2 THEN
                                            Acost$ = "ESC+TSD"
                                            HRac = 2.5
                                            hcac = 12
                                        ELSE
                                            Acost$ = "PMF"
                                            HRac = DegrauMed
                                            Resto = HRac - INT(HRac)
                                            IF Resto >= .5 THEN HRac = INT(HRac) + 1 ELSE HRac = INT(HRac)
                                        END IF
                                    ELSE
                                        Acost$ = "ESC+TSD"
                                        HRac = 2.5
                                        hcac = DegrauMed
                                        IF hcac < 12 THEN hcac = 12
                                    END IF
                                END IF
                            END IF
                        END IF
                    ELSE
                        IF PSRacost < 2 THEN
                            Acost$ = "ESC+TSD"
                            HRac = 2.5
                            hcac = 12
                        END IF
                    END IF
                END IF

                ' Modulo de Elasticidade do Revestimento
                ' Erro admissivel e dominio de pesquisa
                ErroAdm = 2
                E1min = 5000
                E1max = 150000
                AREA = PI# * (Raio ^ 2)
                Pressao = LOAD / AREA
                Einf = EtopBase
                Hsup = Hrev
                Esup = E1min - 100
                Erro = 100
                ' - - - - - - - - - - - - - - - - - - - -
                ' -  Formula do Guia da AASHTO (1993)   -
                ' -     (sistema de duas camadas e      -
                ' -          reproducao de D0)          -
                ' - - - - - - - - - - - - - - - - - - - -
                WHILE (Erro > ErroAdm AND Esup < 150000)
                    Esup = Esup + 100
                    Bloc1 = (1 + ((Hsup / Raio) * ((Esup / Einf) ^ (1 / 3))) ^ 2) ^ .5
                    Bloc2 = 1 - (1 / ((1 + ((Hsup / Raio) ^ 2)) ^ .5))
                    D0est = 1000 * 1.5 * Pressao * Raio * ((1 / (Einf * Bloc1)) + (Bloc2 / Esup))
                    Erro = 100 * ABS(DF(1) - D0est) / DF(1)
                WEND
                E1 = Esup
                IF Erro > ErroAdm THEN
                    IF E1 >= E1max THEN
                        E1 = 70000
                    END IF
                    IF E1 <= E1min THEN
                        E1 = 20000
                    END IF
                END IF
                E1 = 119.62 * (E1 ^ 0.5333)

                ' Modulo de Elasticidade Equivalente das Camadas de Base e Sub-base
                ErroAdm = 2
                Einf = MRsl
                Hsup = Hrev + Hbase + Hsub
                Esup = 350
                Erro = 100
                WHILE (Erro > ErroAdm AND Esup < 250000)
                    Esup = Esup + 10
                    Bloc1 = (1 + ((Hsup / Raio) * ((Esup / Einf) ^ (1 / 3))) ^ 2) ^ .5
                    Bloc2 = 1 - (1 / ((1 + ((Hsup / Raio) ^ 2)) ^ .5))
                    D0est = 1000 * 1.5 * Pressao * Raio * ((1 / (Einf * Bloc1)) + (Bloc2 / Esup))
                    Erro = 100 * ABS(DF(1) - D0est) / DF(1)
                WEND
                Eeq = Esup
                F = 1
                E2 = ((((Eeq / F) ^ (1 / 3)) * Hsup - Hrev * (E1 ^ (1 / 3))) / (Hbase + Hsub)) ^ 3
                IF E2 < 200 THEN E2 = 200
                IF E1 <= E2 THEN
                    F = .76 + .24 * (E1 / E2)
                ELSE
                    F = .76 + .24 * (E2 / E1)
                END IF
                E2 = ((((Eeq / F) ^ (1 / 3)) * Hsup - Hrev * (E1 ^ (1 / 3))) / (Hbase + Hsub)) ^ 3
                IF E2 < 200 THEN E2 = 200
                IF E1 <= E2 THEN
                    F = .76 + .24 * (E1 / E2)
                ELSE
                    F = .76 + .24 * (E2 / E1)
                END IF
                E2 = ((((Eeq / F) ^ (1 / 3)) * Hsup - Hrev * (E1 ^ (1 / 3))) / (Hbase + Hsub)) ^ 3
                IF E2 < 200 THEN E2 = 200
                IF E1 <= E2 THEN
                    F = .76 + .24 * (E1 / E2)
                ELSE
                    F = .76 + .24 * (E2 / E1)
                END IF
                E2 = ((((Eeq / F) ^ (1 / 3)) * Hsup - Hrev * (E1 ^ (1 / 3))) / (Hbase + Hsub)) ^ 3
                IF E2 < 200 THEN E2 = 200
                IF E2 > 250000 THEN E2 = Eeq
                E2 = 2.9499 * (E2 ^ 0.936)

                ' Modulo de Elasticidade da Camada de Base
                ErroAdm = 2
                Einf = E3
                Hsup = Hrev + Hbase
                Esup = 200
                Erro = 100
                WHILE (Erro > ErroAdm AND Esup < 250000)
                    Esup = Esup + 10
                    Bloc1 = (1 + ((Hsup / Raio) * ((Esup / Einf) ^ (1 / 3))) ^ 2) ^ .5
                    Bloc2 = 1 - (1 / ((1 + ((Hsup / Raio) ^ 2)) ^ .5))
                    D0est = 1000 * 1.5 * Pressao * Raio * ((1 / (Einf * Bloc1)) + (Bloc2 / Esup))
                    Erro = 100 * ABS(DF(1) - D0est) / DF(1)
                WEND
                Eeq = Esup
                F = 1
                Ebase = ((((Eeq / F) ^ (1 / 3)) * Hsup - Hrev * (E1 ^ (1 / 3))) / Hbase) ^ 3
                IF Ebase < 200 THEN Ebase = 200
                IF E1 <= Ebase THEN
                    F = .76 + .24 * (E1 / Ebase)
                ELSE
                    F = .76 + .24 * (Ebase / E1)
                END IF
                Ebase = ((((Eeq / F) ^ (1 / 3)) * Hsup - Hrev * (E1 ^ (1 / 3))) / Hbase) ^ 3
                IF Ebase < 200 THEN Ebase = 200
                IF E1 <= Ebase THEN
                    F = .76 + .24 * (E1 / Ebase)
                ELSE
                    F = .76 + .24 * (Ebase / E1)
                END IF
                Ebase = ((((Eeq / F) ^ (1 / 3)) * Hsup - Hrev * (E1 ^ (1 / 3))) / Hbase) ^ 3
                IF Ebase < 200 THEN Ebase = 200
                IF E1 <= Ebase THEN
                    F = .76 + .24 * (E1 / Ebase)
                ELSE
                    F = .76 + .24 * (Ebase / E1)
                END IF
                Ebase = ((((Eeq / F) ^ (1 / 3)) * Hsup - Hrev * (E1 ^ (1 / 3))) / Hbase) ^ 3
                IF Ebase < 200 THEN Ebase = 200
                IF Ebase > 250000 THEN Ebase = Eeq
                Ebase = 2.9499 * (Ebase ^ 0.936)

                ' Correlacao entre deflexao do FWD e da viga
                Dvbk = DF(1)
                'IF DF(1) < 85 THEN
                '    IF DF(1) > 25 THEN
                '        Dvbk = 20.645 * ((DF(1) - 19) ^ .351)
                '    ELSE
                '        Dvbk = DF(1)
                '    END IF
                'ELSE
                '    Dvbk = 8.964 * ((DF(1) - 60) ^ .715)
                'END IF

                ' Calculo da espessura de recapeamento da PRO-269/94
                IF E3 <= 500 THEN
                    TipoSL$ = "III"
                    I1 = 0
                    I2 = 1
                ELSE
                    IF E3 < 2000 THEN
                        TipoSL$ = "II"
                        I1 = 1
                        I2 = 0
                    ELSE
                        TipoSL$ = "I"
                        I1 = 0
                        I2 = 0
                    END IF
                END IF
                NanoUSACE = NanoAASHTO * 3
                NpUSACE = NP * 3

                IF Rev$ = "CCP" THEN

                    ' Analise estrutural (FWD)
                    DADM = 10
                    HEF = Hrev
                    HR269 = 0
                    VR$ = "> 8"
                    Dadm11 = 10
                    MedPRO11$ = ""
                    HRpro11 = 0
                    E1ref = -1
                    AREA = 6 * (1 + 2 * (D30 / Deflex) + 2 * (D60 / Deflex) + (D90 / Deflex))
                    LK = 685.84 - 126.57 * AREA + 8.679 * (AREA ^ 2) - .259 * (AREA ^ 3) + .00287 * (AREA ^ 4)
                    RaioPol = (Dplaca / 2) / 2.54
                    Kef = 1 + ((RaioPol / LK) ^ 2) * (.217 - .367 * (LOG(RaioPol / LK) / LOG(10)))
                    D0 = Deflex / (2.54 * 1000)
                    Kef = Kef * (LOAD / .4536) / (8 * D0 * (LK ^ 2))
                    Eccp = (LK ^ 4) * 12 * (1 - 0.15 * 0.15) * Kef / ((Hrev / 2.54) ^ 3)
                    Eccp = 0.0703 * Eccp
                    Kef = Kef * .4536 / (2.54 ^ 3)
                    JDR = (DF(2) / Deflex) / 0.9219
                    IF JDR > 1 THEN JDR = 1

                ELSE

                    ' Criterios deflectometricos
                    DADM = 10 ^ (3.148 - .188 * (LOG(NpUSACE) / LOG(10)))
                    'IF E2 > 40000 THEN
                    '    DADM = 0.5 * DADM
                    'ELSE
                    '    IF Rev$ <> "CBUQ" THEN DADM = 2 * DADM
                    'END IF
                    Nf = 10 ^ ((3.148 - (LOG(Dvbk) / LOG(10))) / .188)
                    VR = Nf / NanoUSACE
                    IF VR > 8 THEN
                        VR$ = "> 8"
                    ELSE
                        VR$ = STR$(INT(10 * VR) / 10)
                    END IF
                    HEF = -5.737 + (807.961 / Dvbk) + .972 * I1 + 4.101 * I2
                    IF HEF < 0 THEN HEF = 0
                    IF HEF > Hrev THEN HEF = Hrev
                    HR269 = -19.015 + (238.14 / (DADM ^ .5)) - 1.357 * HEF + 1.016 * I1 + 3.893 * I2
                    IF HRpro269 < 0 THEN HRpro269 = 0
                    ' Calculo da espessura de recapeamento da PRO-11/79
                    Dadm11 = 10 ^ (3.01 - .176 * (LOG(NpUSACE) / LOG(10)))
                    'IF E2 > 40000 THEN
                    '    Dadm11 = 0.5 * Dadm11
                    'ELSE
                    '    IF Rev$ <> "CBUQ" THEN Dadm11 = 2 * Dadm11
                    'END IF
                    HRpro11 = 40 * LOG(Dvbk / Dadm11) / LOG(10)
                    IF HRpro11 < 0 THEN HRpro11 = 0
                    IF IGG$ = "Pessimo" THEN
                        MedPRO11$ = "Reconstrucao"
                    ELSE
                        IF Dvbk <= Dadm11 THEN
                            IF Rc <= 100 THEN
                                MedPRO11$ = "Reforco ou Reconstrucao"
                            ELSE
                                MedPRO11$ = "Rest. de Superficie"
                            END IF
                        ELSE
                            IF Dvbk <= 3 * Dadm11 THEN
                                MedPRO11$ = "Reforco"
                            ELSE
                                IF Rc <= 100 THEN
                                    MedPRO11$ = "Reconstrucao"
                                ELSE
                                    MedPRO11$ = "Reforco"
                                END IF
                            END IF
                        END IF
                    END IF

                    ' Converte o modulo de elasticidade do revestimento asfaltico para 70 oF
                    ' Parametros adotados
                    TREF = 70
                    TR = (TREF - 32) / 1.8
                    VV = 4
                    PB = 5.2
                    P200 = 7
                    PNT = 60
                    DTFWD = 30
                    PAC = PB
                    h1 = Hrev
                    ' Parametros da mistura obtidos atraves de correlacoes
                    VB = PB / .434
                    TRB = 153.19 * (PNT ^ -.2596)
                    PAC = .434 * VB
                    VISC = 29508.2 * (PNT ^ -2.1939)
                    PTS = ((LOG(800) / LOG(10)) - (LOG(PNT) / LOG(10))) / (TRB - 25)
                    IP = (20 - 500 * PTS) / (1 + 50 * PTS)
                    PERIODO = DTFWD / 1000
                    FREQ = 1 / PERIODO
                    TMIX = 1.8 * TR + 32
                    GOSUB 1000
                    ERFWD = EACKGF
                    TAIR = 1.8 * TAR + 32
                    TMIX1 = 1.8 * TSUP + 32
                    Z = h1 / 2.54
                    ' Temperatura da camada (Gomez & Thompson, 1984)
                    TREF = 45.4 + 1.32 * Z
                    IF TAIR >= TREF THEN
                        TMIX = -10 + 1.39 * TAIR - .52 * Z
                    ELSE
                        TMIX = 7.7 + 1! * TAIR - .004 * Z
                    END IF
                    TMIX = (TMIX + 2 * TMIX1) / 3
                    TREV = (TMIX - 32) / 1.8
                    PERIODO = DTFWD / 1000
                    FREQ = 1 / PERIODO
                    GOSUB 1000
                    EC = EACKGF
                    FTEMPERAT = ERFWD / EC
                    E1ref = FTEMPERAT * E1
                    IF E1ref < 7000 THEN E1ref = E1
                    IF E1ref > 150000 THEN E1ref = E1
                    JDR = -1
                    Eccp = -1
                    Kef = -1

                END IF

                WRITE #15, VAL(Subtrecho$), km, INT(10 * Dvbk) / 10, NanoUSACE, VR$, INT(10 * Rc) / 10, Dadm11, HRpro11, MedPRO11$, TipoSL$, HEF, DADM, HRpro269, AgePav

                WRITE #1, VAL(Subtrecho$), km, DF(1), INT(10 * HRestr) / 10, CamCrit$, HRfunc, Medida$, INT(10 * hc) / 10, INT(10 * HR) / 10, INT(h2), Acost$, hcac, HRac, h2ac, SNef, Hrev, Hbase, Hsub, Href, INT(E1ref), INT(E1), INT(E2), INT(Ebase), INT(E3), INT(Eslot), INT(100 * JDR) / 100, INT(Eccp), INT(10 * Kef) / 10

                WRITE #14, km, Hrev, INT(E1), TREV, Hbase, INT(Ebase), Hsub, INT(E3), Href, INT(Eslot), 0, -1, INT(E1ref), DF(1), SNef, DAT$, Equipamento$

                IF HRfunc > 2 THEN
                    IF HRestr > 7.5 THEN
                        TipoRep$ = "Reparo Profundo e/ou Correo de Drenagem"
                    ELSE
                        TipoRep$ = "Reparo Superficial para correo funcional"
                    END IF
                ELSE
                    IF HRestr > 7.5 THEN
                        TipoRep$ = "Reparo Profundo"
                    ELSE
                        TipoRep$ = ""
                    END IF
                END IF
                IF TipoRep$ <> "" THEN WRITE #13, Subtrecho$, km, TipoRep$

            END IF

        END IF

    END IF

WEND
CLOSE #2, #1, #14, #13

SYSTEM


10 '
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'- Corrige a deflexao maxima para 21,1oC (Guia da AASHTO de 1993)  -
'-                         (Subrotina)                             -
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
IF Hrev < 3.5 THEN
    X1 = 110
    X2 = -32
    Y1 = 65
    Y2 = -17
ELSE
    IF Hrev <= 7.5 THEN
        X1 = 110
        X2 = -35
        Y1 = 60
        Y2 = -17
    ELSE
        X1 = 110
        X2 = -38
        Y1 = 55
        Y2 = -17
    END IF
END IF
IF TSUP > 75 THEN TSUP = 75
IF TAR > 45 THEN TAR = 45
X = TSUP + TAR
Tpav = ((X2 * Y1 - X1 * Y2) - X * (Y1 - Y2)) / (X2 - X1)
Fd = -.00002 * (Tpav ^ 3) + .0019 * (Tpav ^ 2) - .0597 * Tpav + 1.6028
RETURN


100 '
'- - - - - - - - - - - - - - - - - - - -
'- CALCULA SN A PARTIR DA BACIA DO FWD -
'-            (Subrotina)              -
'- - - - - - - - - - - - - - - - - - - -
IF X > D(7) THEN
    IF DF(7) > 0 THEN
        K = D(7) * DF(7)
    ELSE
        IF DF(6) > 0 THEN
            K = D(6) * DF(6)
        ELSE
            K = D(5) * DF(5)
        END IF
    END IF
    D15HP = K / X
ELSE
    IF X >= D(6) THEN
        I1 = 6
        X1 = D(6)
        X2 = D(7)
        Y1 = DF(6)
        Y2 = DF(7)
    ELSE
        IF X >= D(5) THEN
            I1 = 5
            X1 = D(5)
            X2 = D(6)
            Y1 = DF(5)
            Y2 = DF(6)
        ELSE
            IF X >= D(4) THEN
                I1 = 4
                X1 = D(4)
                X2 = D(5)
                Y1 = DF(4)
                Y2 = DF(5)
            ELSE
                IF X >= D(3) THEN
                    I1 = 3
                    X1 = D(3)
                    X2 = D(4)
                    Y1 = DF(3)
                    Y2 = DF(4)
                ELSE
                    I1 = 2
                    IF X >= D(2) THEN
                        X1 = D(2)
                        X2 = D(3)
                        Y1 = DF(2)
                        Y2 = DF(3)
                    ELSE
                        X1 = D(1)
                        X2 = D(2)
                        Y1 = DF(1)
                        Y2 = DF(2)
                    END IF
                END IF
            END IF
        END IF
    END IF
    D15HP = ((X2 * Y1 - X1 * Y2) - X * (Y1 - Y2)) / (X2 - X1)
    IF D15HP <= 0 THEN
        K = D(I1) * DF(I1)
        D15HP = K / X
    END IF
END IF
SIP = 10 * (DF(1) - D15HP)
IF SIP <= 0 THEN SIP = 10 * (Deflex - D15HP)
IF REVORIG$ = "CBUQ" THEN
    K1 = .4728
    K2 = -.481
    K3 = .7581
ELSE
    IF Hrev >= 3.5 THEN
        K1 = .4728
        K2 = -.481
        K3 = .7581
    ELSE
        K1 = .1165
        K2 = -.3248
        K3 = .8241
    END IF
END IF
IF SIP > 0 THEN
    IF HT <= 0 THEN HT = 30
    SN = K1 * (SIP ^ K2) * ((10 * HT) ^ K3)
ELSE
    SN = -1
END IF
MRsurf = (1 - .4 * .4) * LOAD / (PI# * X * (D15HP / 1000))
RETURN


300 '
' - - - - - - - - - - - - - - - - - - -
' -  Leitura da Base de Dados do SGP  -
' - - - - - - - - - - - - - - - - - - -
Trincado$ = "N"
ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #5
ISTH = 0
QIa = -1
AgePav = -1
FOR IRodov = 1 TO NRODOV
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #5, Subtr, NFX, KM1, KM2, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFX
            INPUT #5, IFX, h1, HrecExist, Idade, SN, QImed, Nano, IRI0, Nacum, REVEST$, ALFAIGG
            INPUT #5, PSIat, Aream2, VidaRes, VDMUni, PSInovo, Heff, IRec, ICalib, D0, MRfound
            INPUT #5, ALPHA0, ALPHA, ALPHA2, AreaAcost, PSIacost, DegrauAcost, T0, TR23, CBRsl, CamBase$, VDMc, ATRmed
            IF (Subtr = VAL(STH$) AND IFX = Faixa) THEN
                H1REV = h1
                Rev$ = REVEST$
                QIa = QImed
                AgePav = Idade
                IF TR23 > 20 THEN Trincado$ = "S"
                NanoAASHTO = Nano
                IGG$ = "Excelente"
                IF PSIat >= 0 THEN
                    IF PSIat < 2 THEN
                        IGG$ = "Pessimo"
                    ELSE
                        IF PSIat < 3 THEN
                            IGG$ = "Regular"
                        ELSE
                            IF PSIat < 4 THEN
                                IGG$ = "Bom"
                            ELSE
                                IGG$ = "Excelente"
                            END IF
                        END IF
                    END IF
                END IF
            END IF
        NEXT IFaixa
    NEXT ISUB
NEXT IRodov
INPUT #5, PSImed(0), Npsi(0), VRmed(0)
INPUT #5, AreaTotal, NUnidAnalise
CLOSE #5
PSR = 0
PSRacost = -1
Degraucm = -1
Achou$ = "N"
IF TipoLev$ = "LVC" THEN
    ARQUIVO$ = CALC$ + "LVC" + TRECHO$ + Faixa$ + ".CS1"
ELSE
    ARQUIVO$ = CALC$ + "LTR" + TRECHO$ + Faixa$ + ".CSV"
END IF
OPEN ARQUIVO$ FOR INPUT AS #5
LINE INPUT #5, LINHA$
WHILE (Achou$ = "N" AND NOT EOF(5))
    IF TipoLev$ = "LVC" THEN
        INPUT #5, Sg, K1, K2, PSRx, CR1$, CR2$, CR3$, BL1$, BL2$, BL3$, TT1$, TT2$, TT3$, TL1$, TL2$, TL3$, TE1$, TE2$, TE3$, TB1$, TB2$, TB3$, Pan$, D$, DS$, ER$, BF$, DC$, R1$, R2$, R3$, ATR$, COR$, EM$, DP$, EX$, PSRAC, DEGRAU, OBS$
    ELSE
        INPUT #5, Sg, K1, K2, IFaixa, PSRx, CR1$, CR2$, CR3$, BL1$, BL2$, BL3$, TT1$, TT2$, TT3$, TL1$, TL2$, TL3$, TE1$, TE2$, TE3$, TB1$, TB2$, TB3$, Pan$, D$, DS$, ER$, BF$, DC$, R1$, R2$, R3$, ATR$, COR$, EM$, DP$, EX$, PSRAC, DEGRAU, TipoSec$, TR$, DP$, P$, OBS$
    END IF
    IF K1 < K2 THEN
        IF (K1 <= km AND km <= K2) THEN
            PSRacost = PSRAC
            Degraucm = DEGRAU
            PSR = PSRx
            IF Trincado$ = "N" THEN
                IF (CR3$ = "A" OR CR3$ = "M" OR CR2$ = "A") THEN
                    Trincado$ = "S"
                ELSE
                    IF (BL3$ = "A" OR BL3$ = "M" OR BL2$ = "A") THEN
                        Trincado$ = "S"
                    ELSE
                        IF (TT3$ = "A" OR TT3$ = "M" OR TT2$ = "A") THEN
                            Trincado$ = "S"
                        ELSE
                            IF (TL3$ = "A" OR TL2$ = "A") THEN Trincado$ = "S"
                        END IF
                    END IF
                END IF
            END IF
            Achou$ = "S"
        END IF
    ELSE
        IF (K1 >= km AND km >= K2) THEN
            PSRacost = PSRAC
            Degraucm = DEGRAU
            PSR = PSRx
            IF Trincado$ = "N" THEN
                IF (CR3$ = "A" OR CR3$ = "M" OR CR2$ = "A") THEN
                    Trincado$ = "S"
                ELSE
                    IF (BL3$ = "A" OR BL3$ = "M" OR BL2$ = "A") THEN
                        Trincado$ = "S"
                    ELSE
                        IF (TT3$ = "A" OR TT3$ = "M" OR TT2$ = "A") THEN
                            Trincado$ = "S"
                        ELSE
                            IF (TL3$ = "A" OR TL2$ = "A") THEN Trincado$ = "S"
                        END IF
                    END IF
                END IF
            END IF
            Achou$ = "S"
        END IF
    END IF
WEND
CLOSE #5
IF PSR > 0 THEN
    IF PSR <= 1.5 THEN
        IGG$ = "Pessimo"
    ELSE
        IF PSR <= 3 THEN
            IGG$ = "Regular"
        ELSE
            IF PSR < 4.5 THEN
                IGG$ = "Bom"
            ELSE
                IGG$ = "Excelente"
            END IF
        END IF
    END IF
END IF
ARQUIVO$ = DADOSANOBASE$ + "QI\" + TRECHO$ + ".CSV"
OPEN ARQUIVO$ FOR INPUT AS #5
LINE INPUT #5, LINHA$
WHILE NOT EOF(5)
    INPUT #5, kmini, kmfim, QI(1), QI(2), QI(3), QI(4), DAT$, Equip$
    IF kmini < kmfim THEN
        IF (kmini <= km AND km <= kmfim) THEN
            IF QI(Faixa) >= 0 THEN QIa = QI(Faixa)
        END IF
    ELSE
        IF (kmini >= km AND km >= kmfim) THEN
            IF QI(Faixa) >= 0 THEN QIa = QI(Faixa)
        END IF
    END IF
WEND
CLOSE #5
RETURN


500 '
' - - - - - - - - - - - - - - - - - - - - - - - - -
' - Modelo Nao Linear do Subleito ou da Fundacao  -
' -                 (Subrotina)                   -
' - - - - - - - - - - - - - - - - - - - - - - - - -
RCRIT = X
NPONTOS = 7
FOR J = 2 TO NPONTOS
    ESURF(J) = (1 - .4 * .4) * LOAD / (PI# * D(J) * (DF(J) / 1000))
NEXT J
FOR J = 1 TO NPONTOS
    SVERT(J) = 3 * LOAD / (2 * PI# * (HT ^ 2) * (1 + ((D(J) / HT) ^ 2)) ^ (5 / 2))
NEXT J
R1 = 100 * (ESURF(NPONTOS) - ESURF(NPONTOS - 1)) / ESURF(NPONTOS)
D1 = (ESURF(NPONTOS) - ESURF(NPONTOS - 1)) / (D(NPONTOS) - D(NPONTOS - 1))
D2 = (ESURF(NPONTOS - 1) - ESURF(NPONTOS - 2)) / (D(NPONTOS - 1) - D(NPONTOS - 2))
X1 = (D(NPONTOS) + D(NPONTOS - 1)) / 2
X2 = (D(NPONTOS - 1) + D(NPONTOS - 2)) / 2
IF (R1 > 5 AND D1 > D2) THEN
    MODELOSL$ = "N. Linear"
    N = 0
    FOR J = 2 TO NPONTOS
        IF D(J) >= RCRIT THEN N = N + 1
    NEXT J
    IF N < 3 THEN N = 3
    GOSUB 700
    Esl = 0
    FOR J = 2 TO NPONTOS
        ESG(J) = KSL * (SVERT(J) ^ ENESL)
        Esl = Esl + ESG(J)
    NEXT J
    Esl = Esl / (NPONTOS - 1)
ELSE
    IF ABS(D2) > ABS(D1) THEN
        MODELOSL$ = "Linear"
        Q0 = (X2 * D1 - X1 * D2) / (X2 - X1)
        Q1 = (D2 - D1) / (X2 - X1)
        RCSL = -Q0 / Q1
        Q2 = ESURF(NPONTOS) - Q0 * D(NPONTOS) - (Q1 / 2) * (D(NPONTOS) ^ 2)
        Esl = Q2 + Q0 * RCSL + (Q1 / 2) * (RCSL ^ 2)
        KSL = Esl
        ENESL = 0
    ELSE
        MODELOSL$ = "Indef."
        NPTS = 0
        Esl = 0
        FOR J = 2 TO NPONTOS
            IF D(J) >= RCRIT THEN
                NPTS = NPTS + 1
                Esl = Esl + ESURF(NPTS)
            END IF
        NEXT J
        IF NPTS > 0 THEN
            Esl = Esl / NPTS
        ELSE
            Esl = ESURF(NPONTOS)
        END IF
        KSL = Esl
        ENESL = 0
    END IF
END IF
' Calculo do modulo medio do subleito sob o pavimento
IF ENESL = 0 THEN
    MR = Esl
ELSE
    MR = KSL * (SVERT(1) ^ ENESL)
END IF
IF MR < 100 THEN MR = 100
IF MR > 10000 THEN MR = 10000
RETURN


700 '
' - - - - - - - - - - - - -
' -   REGRESSAO LINEAR    -
' -      (Subrotina)      -
' - - - - - - - - - - - - -
FOR K = 1 TO V + 1
    FOR L = 1 TO V + 2
        A(K, L) = 0
        S(K) = o
    NEXT L
NEXT K
X(1) = 1
SOMA = 0: S2 = 0
FOR I = 1 TO N

    II = NPONTOS - (I - 1)
    X(2) = LOG(SVERT(II))
    X(V + 2) = LOG(ESURF(II))

    SOMA = SOMA + X(V + 2)
    S2 = S2 + (X(V + 2) * X(V + 2))

    FOR K = 1 TO V + 1
        FOR L = 1 TO V + 2
            A(K, L) = A(K, L) + X(K) * X(L)
            S(K) = A(K, V + 2)
        NEXT L
    NEXT K
    S(V + 2) = S(V + 2) + X(V + 2) ^ 2
NEXT I
FOR I = 2 TO V + 1
    T(I) = A(1, I)
NEXT I
FOR I = 1 TO V + 1
    J = I
    710 IF A(J, I) <> 0 THEN 740
    J = J + 1
    IF (J <= V + 1) THEN
        GOTO 710
    ELSE
        PRINT "SOLUCAO NAO UNICA"
        RETURN
    END IF
    740 FOR K = 1 TO V + 2
        B = A(I, K)
        A(I, K) = A(J, K)
        A(J, K) = B
    NEXT K
    Z = 1 / A(I, I)
    FOR K = 1 TO V + 2
        A(I, K) = Z * A(I, K)
    NEXT K
    FOR J = 1 TO V + 1
        IF J = I THEN 790
        Z = -A(J, I)
        FOR K = 1 TO V + 2
            A(J, K) = A(J, K) + Z * A(I, K)
        NEXT K
    790 NEXT J
NEXT I
KSL = EXP(A(1, V + 2))
ENESL = A(2, V + 2)
MEDIA = SOMA / N
Desvio = SQR((S2 - N * MEDIA * MEDIA) / (N - 1))
P = 0
FOR I = 2 TO V + 1
    P = P + A(I, V + 2) * (S(I) - T(I) * S(1) / N)
NEXT I
R = S(V + 2) - S(1) ^ 2 / N
Z = R - P
L = N - V - 1
I = P / R
ERROPAD = SQR(ABS(Z / L))
R2 = I
RETURN


1000 '
' - - - - - - - - - - - - - - - - - - - - - -
' - Modulo dinamico em compressao (T.A.I.)  -
' -              (Subrotina)                -
' - - - - - - - - - - - - - - - - - - - - - -
TF = TMIX
TT = TF ^ (1.3 + .49825 * (LOG(FREQ) / LOG(10)))
EAC = 5.553833 + .028829 * (P200 / (FREQ ^ .17033)) - .03476 * VV
EAC = EAC + .070377 * VISC + .000005 * TT * (PAC ^ .5)
EAC = EAC - .00189 * (TT * (PAC ^ .5) / (FREQ ^ 1.1))
EAC = EAC + .931757 * (1 / (FREQ ^ .02774))
EACPSI = 10 ^ EAC
EACKSI = EACPSI / 1000
EACKGF = EACPSI * .0703
RETURN


6900 '
' - - - - - - - - - - - - - - - - - - - -
' -   Irregularidade apos Recapeamento  -
' -        (Subrotina do HDM-III)       -
' -   Dados: HR, HC, QIest              -
' -   Saida: QIest                      -
' - - - - - - - - - - - - - - - - - - - -
IF QIest > 19 THEN
    QIB = 19! + ((QIest - 19!) / (.602 * hc + 1))
ELSE
    QIB = QIest
END IF
H0 = 10 * HR
IF QIB > 13 THEN QIBL = QIB ELSE QIBL = 13
IF H0 < 80 THEN H0L = H0 ELSE H0L = 80
IF H0 < 40 THEN X = H0 ELSE X = 40
HOV = 3 - ((H0L + X) / 40)
X1 = 19.42 - .78 * QIBL - .068 * H0
IF H0 > 20 THEN Y = H0 - 20 ELSE Y = 0
X2 = -19.5 - .008 * QIBL * Y
IF X1 > X2 THEN DQI = X1 ELSE DQI = X2
IF DQI > 0 THEN DQI = 0
QIest = QIB + DQI
RETURN


900 '
' - - - - - - - - - - - - - - - - - - - - - - - - - -
' - Vida de servico prevista em medidas do tipo CP  -
' -                  (Subrotina)                    -
' - - - - - - - - - - - - - - - - - - - - - - - - - -
A0 = 3.9668
A1 = -.0463
A2 = -.00106
A3 = .22483
SE = .4101
GOSUB 6900
Deltat = .1
PSIQI = 5! * EXP(-QIest / 71.5)
PSI = (5 + PSIQI) / 2
PSI0 = PSI
PSI0mod = A0 + A2 * DF(1) * LOG(NanoMed) + A3 * HRmicro
IF PSI0mod > 5 THEN PSI0mod = 5
DeltaPSI0 = PSI0 - PSI0mod
VSCP = 0
WHILE (PSI > PSIt AND VSCP < PP)
    PSI = A0 + A1 * VSCP + A2 * DF(1) * LOG(NanoMed) + A3 * HRmicro + DeltaPSI0
    PSI = PSI - NpsiMod * SE
    VSCP = VSCP + Deltat
WEND
IF QIest > .85 * QIcrit THEN VSCP = 0
RETURN


1500 '
' - - - - - - - - - - - - - - - - - - - - - - - -
' - Espessura de Reforco pelo Modelo AASHTO-HDM -
' -                 (Subrotina)                 -
' - - - - - - - - - - - - - - - - - - - - - - - -
NPA = NP / 1.0E6
' Espessura de recapeamento para manter o QI abaixo do valor admissivel
A1 = 0.44
HR = 0.4
hc = 0
QIf = QIcrit
WHILE (QIf >= QIcrit AND HR < 30 AND SNp < 15)
    HR = HR + .1
    QIest = QIa
    GOSUB 6900
    PSI0ah = 5 * EXP(-QIest / 71.5)
    IF PSI0ah >= 4.99 THEN PSI0ah = 4.99
    IF PSI0ah > 2.5 THEN
        ' Modelo AASHTO-HDM para irregularidade
        SNp = SN + Cf * A1 * HR / 2.54
        BETA = .4 + (1094 / ((SNp + 1) ^ 5.19))
        DPSI = PSI0ah - 2.5
        W18# = (((SNp + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
        W18# = 10 ^ (-ZR * S0) * W18# * ((MR / 3000) ^ 2.32) / 1000000!
        ALFAah# = FcPSI * (1 / W18#) * LOG(LOG(2.5 / 5) / LOG(PSI0ah / 5))
        IF ALFAah# * NPA < 80 THEN
            PSIah# = 5 * ((PSI0ah / 5) ^ EXP(ALFAah# * NPA))
            QIf = 71.5 * LOG(5 / PSIah#)
        END IF
    END IF
WEND
HRmodel = HR
' Espessura de recapeamento para manter o IGG abaixo do valor admissivel
HR = 0.4
hc = 0
IGGf = IGGcrit
WHILE (IGGf >= IGGcrit AND HR < 30)
    HR = HR + .1
    ' Modelo AASHTO-HDM para IGG
    SCI0 = 4.97
    PCR4 = 5
    IF SN = 0 THEN
        TYcr2A = 2.54 * EXP(.0157 * HR * 10 - .0141 * PCR4)
        Dc = DF(1) * (10 ^ (-HR / 40))
        TYcr2B = 10.8 * EXP(-1.21 * (Dc / 100) - 1.02 * (NanoMed / 1000000!) * (Dc / 100))
        TYcr2 = (1 * TYcr2A + 1.5 * TYcr2B) / (1 + 1.5)
        ALFAah# = (10 ^ (ZR * S0)) * LOG(10.228 / TYcr2) / (1.226E-6 * NanoMed)
    ELSE
        SNp = SN + A1 * HR / 2.54
        BETA = .4 + (1094 / ((SNp + 1) ^ 5.19))
        DPSI = SCI0 - 2.5
        W18 = (((SNp + 1) / 1.0512) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
        W18 = 10 ^ (-ZR * S0) * W18 * ((MR / 3000) ^ 2.32) / 1000000!
        ALFAah# = FcSCI * (1 / W18) * LOG(LOG(2.5 / 5) / LOG(SCI0 / 5))
    END IF
    IF ALFAah# * NPA < 80 THEN
        SCI# = 5 * ((SCI0 / 5) ^ EXP(ALFAah# * NPA))
        IGGf = (309.22 - 61.844 * SCI#) / (SCI# + 0.616)
    END IF
WEND
IF HRmodel < HR THEN HRmodel = HR
HR = HRmodel

RETURN



' PAVIMENTOS RIGIDOS PELA AASHTO-86
' Dados
'RTF = 640
'NANO = 1000000!
'Dcm = 25
'D = Dcm / 2.54
'PT = 2.5
'J = 3.2
'CD = 1
'PSI0 = 4.5
' Correlacoes
'RTFMPA = RTF * .0703 / 10
'RCS = 10 * ((RTFMPA / .56) ^ 1.67)
'EC = 15110 * (RCS ^ .5)
'EC = EC / .0703
' Parametros complementares
'DPSI = PSI0 - PT
'S0 = .4
'NC = 95
'ZR = -1.645
' Modelo
'W18# = 215.63 * J * ((D ^ .75) - (18.42 / ((EC / Kef) ^ .25)))
'W18# = (4.22 - .32 * PT) * LOG(RTF * CD * ((D ^ .75) - 1.132) / W18#) / LOG(10)
'A# = (LOG(DPSI / (4.5 - 1.5)) / LOG(10)) / (1 + (1.624E+07 / ((D + 1) ^ 8.46)))
'W18# = W18# + A# - .06 + 7.35 * (LOG(D + 1) / LOG(10)) + ZR * S0
'W18# = 10 ^ W18#
